(ns uikit-hl.visibility
  (:require [hoplon.core :as hl]
            [javelin.core :as j]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-invisible* nil)

(defmethod hl/do! :uk-visibility
  [elem _ v]
  (.visibility js/UIkit elem (clj->js v)))

(hl/defelem invisible [attr kids]
  (let [invisible (:uk-invisible attr *uk-invisible*)]
    (hl/ul attr :class/uikit (j/cell= {:uk-invisible invisible}) kids)))

(hl/defelem item [attr kids]
  (let [title (:title attr *title*)
        attr  (dissoc attr :title)]
    (hl/li attr
      (hl/h3  :class [:uk-visibility-title] (hl/text "~{title}"))
      (hl/div :class [:uk-visibility-content] kids))))
