(ns uikit-hl.visibility
  (:require [hoplon.core :as hl]
            [javelin.core :as j]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-invisible* nil)

(def ^:dynamic *uk-hidden-s* nil)

(hl/defelem invisible [attr kids]
  (let [invisible (:uk-invisible attr *uk-invisible*)]
    (hl/div attr :class/uikit {:uk-invisible invisible} kids)))

(hl/defelem hidden [attr kids]
  (let [hidden-s (:uk-hidden-s attr *uk-hidden-s*)]
    (hl/div attr :class/uikit {(keyword "uk-hidden@s") hidden-s} kids)))
