(ns uikit-hl.visibility
  (:require [hoplon.core :as hl]
            [javelin.core :as j]
            [uikit-hl.core :as core]))

(def ^:dynamic *uk-invisible* nil)

(def ^:dynamic *uk-hidden-s*  nil)
(def ^:dynamic *uk-hidden-m*  nil)
(def ^:dynamic *uk-hidden-l*  nil)

(defmethod hl/do! :uk-invisible
  [elem _ v]
  (hl/do! elem :class/uikit {:uk-invisible v}))

(defmethod hl/do! :uk-hidden-s
  [elem _ v]
  (hl/do! elem :class/uikit {(keyword "uk-hidden@s") v}))

(defmethod hl/do! :uk-hidden-m
  [elem _ v]
  (hl/do! elem :class/uikit {(keyword "uk-hidden@m") v}))

(defmethod hl/do! :uk-hidden-l
  [elem _ v]
  (hl/do! elem :class/uikit {(keyword "uk-hidden@l") v}))

(hl/defelem hidden [attr kids]
  (let [hidden-s (:small  attr *uk-hidden-s*)
        hidden-m (:medium attr *uk-hidden-m*)
        hidden-l (:large  attr *uk-hidden-l*)]
    (hl/div attr
      :uk-hidden-s hidden-s
      :uk-hidden-m hidden-m
      :uk-hidden-l hidden-l
      kids)))
