(ns uikit-hl.heading
  (:require [hoplon.core :as hl]
            [uikit-hl.core :as core]))

(defmethod hl/do! :uk-heading
  [elem _ v]
  (.heading js/UIkit elem (clj->js v)))

(hl/defelem heading [attr kids]
  (let [heading (:uk-heading attr *uk-heading*)
        attr      (assoc attr :uk-heading heading)]
    (hl/ul attr kids)))

(hl/defelem item [attr kids]
  (let [title (:title attr *title*)
        attr  (dissoc attr :title)]
    (hl/li attr
      (hl/h3  :class [:uk-heading-title] (hl/text "~{title}"))
      (hl/div :class [:uk-heading-content] kids))))
