(ns uikit-hl.modal
  (:require [hoplon.core :as h]
            [uikit-hl.core :as uk]))

(defn show [modal]
  (.show modal))

(defn hide [modal]
  (.hide modal))

(defmulti on-modal! h/kw-dispatcher :default ::default)

(defmethod h/on! ::default
  [elem key val]
  (on-modal! elem key val))

(defmethod on-modal! ::default
  [elem kw func]
  (.on (uk/modal elem) (name kw) func))

(defmulti do-modal! h/kw-dispatcher :default ::default)

(defmethod h/do! ::default
  [elem key val]
  (do-modal! elem key val))

(defn- format-modal [modal]
  (str "uk-modal-" modal))

(defmethod do-modal! ::default
  [elem kw v]
  (h/do! elem :class {(format-modal (name kw)) v}))

(defmethod do-modal! ::modal
  [elem _ v]
  (uk/modal elem (clj->js v)))

(h/defelem modal [{:keys [modal container full show hide] :or {modal {}} :as attr} kids]
  (h/div
    (dissoc attr :modal :container :full :show :hide)
    ::modal modal
    ::container container
    ::full full
    ::show show
    ::hide hide
    kids))

(h/defelem dialog [attr kids]
  (h/div
    attr
    ::dialog true
    kids))

(h/defelem header [attr kids]
  (h/div
    attr
    ::header true
    kids))

(h/defelem body [attr kids]
  (h/div
    attr
    ::body true
    kids))

(h/defelem footer [attr kids]
  (h/div
    attr
    ::footer true
    kids))

(h/defelem title [attr kids]
  (h/h2
    attr
    ::title true
    kids))

(h/defelem close [{:keys [default outside full] :as attr} kids]
  (h/button
    (dissoc attr :default :outside :full)
    ::close-default default
    ::close-outside outside
    ::close-full full
    kids))
