(ns election-reminders.partner
  "Specifies partner-related attributes."
  (:require
   [clojure.spec.alpha :as s]
   [clojure.spec.gen.alpha :as gen]
   [election-reminders.notification :as notification]))

(s/def ::notification
  (s/keys :req [::notification/id
                ::notification/notification-id
                ::notification/type]))

(s/def ::id uuid?)
(s/def ::cognito-forms-id
  (s/with-gen string?
    #(gen/fmap (fn [^long n]
                 (str (inc (Math/abs n))))
               (gen/int))))
(s/def ::name string?)
(s/def ::active? boolean?)
(s/def ::notifications
  (s/coll-of ::notification
             :kind set?))
