(ns election-reminders-specs.common
  "Election Reminders common specifications that are not specific to any
  particular data model."
  (:require
   [clojure.spec.alpha :as s])
  (:import
   (com.google.i18n.phonenumbers NumberParseException
                                 PhoneNumberUtil)
   (java.time DateTimeException
              LocalDate
              Period
              ZoneId)))

(s/def ::local-date
  (partial instance? LocalDate))

(s/def ::period
  (partial instance? Period))

(defn phone-number?
  "Is `s` a string representation of a valid US phone number?"
  [^CharSequence s]
  (let [pnu (PhoneNumberUtil/getInstance)]
    (try
      (.isValidNumber pnu (.parse pnu s "US"))
      (catch NumberParseException _
        false))))

(s/def ::phone-number
  (s/and string? phone-number?))

(defn time-zone-id?
  "Is `s` a valid time zone identifier?"
  [^String s]
  (try
    (boolean (ZoneId/of s))
    (catch DateTimeException _
      false)))

(s/def ::time-zone-id
  (s/and string? time-zone-id?))
