(ns election-reminders-specs.message
  "Election Reminders message specifications.

  These correspond to messages sent between systems, and are not \"entities\",
  though much of the data exchanged between systems is going to correspond to
  attributes in the Election Reminders information model."
  (:require
   [clojure.spec.alpha :as s]
   [election-reminders.partner :as partner]
   [election-reminders.user :as user]
   [election-reminders-specs.entity :as entity]))

;;;; User subscription

;; Enough information to subscribe or unsubscribe a user from a given
;; notification medium.
(s/def ::user-subscription
  (s/keys :req [::user/id ::user/notification-medium]))

;;;; User registration

;; Optional flag to set that controls whether or not confirmation messages are
;; sent to users. Useful for backfilling registrations.
(s/def ::send-confirmation? boolean?)

;; Used to register a new user in the system.
(s/def ::user-registration
  (s/and
   (s/keys :req [::user/first-name
                 ::user/last-name
                 ::user/registered-address]
           :opt [::user/phone-number
                 ::user/email-address
                 ::user/notification-media
                 ::partner/id
                 ::partner/cognito-forms-id]
           :opt-un [::send-confirmation?])
   ::entity/valid-user-subscriptions
   ::entity/one-partner-id))
