(ns gov-notifications-specs.entity.registration
  "Specifies registration-related entities."
  (:require [clojure.spec.alpha :as spec]
            [gov-notifications-specs.entity.user :as user]
            [gov-notifications-specs.entity.partner]))

(defn has-one-partner-id?
  [m]
  (and (or (:gn.partner/id m)
           (:gn.partner/cognito-forms-id m))
       (not (and (:gn.partner/id m)
                 (:gn.partner/cognito-forms-id m)))))

(spec/def :gn/registration
  (spec/and
   (spec/keys :req [:gn.user/first-name
                    :gn.user/last-name
                    :gn.user/registered-address]
              :opt [:gn.user/phone-number
                    :gn.user/email-address
                    :gn.user/notification-subscriptions
                    :gn.partner/id
                    :gn.partner/cognito-forms-id])
   user/subscriptions-have-contact-info?
   has-one-partner-id?))
