(ns gov-notifications-specs.entity.notification
  "Specifies notification-related entities."
  (:require
   [clojure.spec.alpha :as spec]))

(spec/def :gn.notification/medium #{:email :sms})
(spec/def :gn.notification/notification-type keyword?)
(spec/def :gn.notification/language #{:en :es})
(spec/def :gn.notification/context (spec/map-of keyword? any?))
(spec/def :gn.notification/attachments (spec/coll-of
                                        (spec/map-of keyword? any?)))

(spec/def :gn/notification
  (spec/keys :req [:gn.notification/medium :gn.notification/notification-type
                   :gn.notification/context]
             :opt [:gn.notification/language :gn.notification/attachments]))
