(ns gov-notifications-specs.entity.user
  "Specifies user-related entities."
  (:require
   [clojure.spec.alpha :as spec]
   [gov-notifications-specs.entity.address]
   [gov-notifications-specs.entity.partner]))

(spec/def :gn.user/id uuid?)
(spec/def :gn.user/partner
  (spec/keys :req [:gn.partner/id]))
(spec/def :gn.user/first-name string?)
(spec/def :gn.user/last-name string?)
(spec/def :gn.user/registered-address :gn/address)
(spec/def :gn.user/phone-number string?)
(spec/def :gn.user/email-address string?)
(spec/def :gn.user/notification-subscriptions
  (spec/coll-of #{:email :sms}
    :kind set?
    :min-count 1
    :max-count 2))

(defn subscriptions-have-contact-info?
  [m]
  (let [sub-k :gn.user/notification-subscriptions
        email-k :gn.user/email-address
        phone-k :gn.user/phone-number]
    (if-let [subscriptions (not-empty (get m sub-k))]
      (let [type->contact {:email (contains? m email-k)
                           :sms (contains? m phone-k)}]
        (every? #(get type->contact %) subscriptions))
      true)))

(spec/def :gn/user
  (spec/and
   (spec/keys :req [:gn.user/partner
                    :gn.user/first-name
                    :gn.user/last-name
                    :gn.user/registered-address]
              :opt [:gn.user/id
                    :gn.user/phone-number
                    :gn.user/email-address
                    :gn.user/notification-subscriptions])
   subscriptions-have-contact-info?))
