(ns gov-notifications-specs.entity.notification-type
  "Specifies notification-type-related entities."
  (:require
   [clojure.spec.alpha :as spec]))

(spec/def :gn.notification-type/medium #{:email :sms})
(spec/def :gn.notification-type/slug keyword?)
(spec/def :gn.notification-type/from string?)
(spec/def :gn.notification-type/to string?)
(spec/def :gn.notification-type/body string?)
(spec/def :gn.notification-type/subject string?)
(spec/def :gn.notification-type/language #{:en :es})

(defmulti medium-type :gn.notification-type/medium)

(defmethod medium-type :sms
  [_]
  (spec/keys :req [:gn.notification-type/medium :gn.notification-type/slug
                   :gn.notification-type/from :gn.notification-type/to
                   :gn.notification-type/body]
             :opt [:gn.notification-type/language]))

(defmethod medium-type :email
  [_]
  (spec/keys :req [:gn.notification-type/medium :gn.notification-type/slug
                   :gn.notification-type/from :gn.notification-type/to
                   :gn.notification-type/subject :gn.notification-type/body]
             :opt [:gn.notification-type/language]))

(spec/def :gn/notification-type
  (spec/multi-spec medium-type :gn.notification-type/medium))
