(ns gov-notifications-specs.entity.notification-schedule
  "Specifies notification-schedule-related entities."
  (:require
   [clojure.spec.alpha :as spec]
   [clojure.spec.gen.alpha :as gen]
   [gov-notifications-specs.predicate :as predicate]))

(defn period-gen
  "Returns a generator that will generate valid ISO-8601 period strings."
  []
  (gen/fmap (fn [[neg d]]
              (str neg "P" d "D"))
            (gen/tuple (gen/elements ["" "-"])
                       (gen/elements (map inc (range 30))))))

(spec/def :gn.notification-schedule/send-after-offset-period
  (spec/with-gen predicate/iso-8601-period?
    period-gen))
(spec/def :gn.notification-schedule/send-before-offset-period
  (spec/with-gen predicate/iso-8601-period?
    period-gen))
(spec/def :gn.notification-schedule/offset-from
  #{:gn.offset-type/election-date
    :gn.offset-type/vbm-ballot-request-received
    :gn.offset-type/vbm-ballot-return-received
    :gn.offset-type/vbm-ballot-return-postmarked
    :gn.offset-type/vbm-ballot-return-in-person})
