(ns gov-notifications-specs.entity.notification
  "Specifies notification-related entities."
  (:require
   [clojure.spec.alpha :as spec]
   [clojure.spec.gen.alpha :as gen])
  (:import
   (java.time Instant)))

(defn instant?
  [i]
  (instance? Instant i))

(defn instant-gen
  "Returns a generator for java.time.Instant objects."
  []
  (gen/fmap (fn [x]
              (Instant/ofEpochMilli x))
            (gen/large-integer)))

(spec/def :gn.notification/medium
  #{:email :sms})
(spec/def :gn.notification/notification-type
  keyword?)
(spec/def :gn.notification/language
  #{:en :es})
(spec/def :gn.notification/context
  (spec/map-of keyword? any?))
(spec/def :gn.notification/attachments
  (spec/coll-of (spec/map-of keyword? any?)))
(spec/def :gn.notification/identifiers
  (spec/with-gen
    (spec/map-of keyword? (complement coll?))
    #(gen/map (gen/keyword) (gen/string))))
(spec/def :gn.notification/send-after
  (spec/with-gen instant?
    instant-gen))
(spec/def :gn.notification/send-before
  (spec/with-gen instant?
    instant-gen))

(spec/def :gn/notification
  (spec/keys :req [:gn.notification/medium :gn.notification/notification-type
                   :gn.notification/context]
             :opt [:gn.notification/language :gn.notification/attachments
                   :gn.notification/identifiers :gn.notification/send-after
                   :gn.notification/send-before]))
