(ns turbovote-admin-specs.reporting.user
  (:require
    [clojure.spec :as s]
    [turbovote-admin-specs.reporting :as reporting]
    [turbovote-admin-specs.request :as request]))

(s/def ::hostname string?)

(s/def ::start-date inst?)
(s/def ::end-date inst?)

(s/def ::uid uuid?)
(s/def ::uids (s/coll-of ::uid :kind set?))

(s/def ::hostnames (s/or ::all (s/and keyword? #(= ::all %))
                         ::specific-hostnames (s/coll-of string?
                                                         :distinct true
                                                         :into #{})))
(s/def ::states (s/coll-of #{"AL" "AK" "AZ" "AR" "CA" "CO" "CT" "DE" "DC" "FL" "GA" "HI"
                             "ID" "IL" "IN" "IA" "KA" "KY" "LA" "ME" "MD" "MA" "MI" "MN"
                             "MS" "MO" "MT" "NE" "NV" "NH" "NJ" "NM" "NY" "NC" "ND" "OH"
                             "OK" "OR" "PA" "RI" "SC" "SD" "TN" "TX" "UT" "VT" "VA" "WA"
                             "WV" "WI" "WY"}
                           :into #{}))

(s/def ::filter
  (s/and
   (s/keys :req [::hostnames]
           :opt [::states ::registered? ::start-date ::end-date])
   (fn [m]
     (or (and (::start-date m) (::end-date m))
         (not (or (::start-date m) (::end-date m)))))))

(def pull-properties
  #{::hostname ::zip ::state ::email ::registered-addr?})
(s/def ::pull (reporting/pull-spec pull-properties))

(def group-by-properties
  #{::hostname})
(s/def ::group-by (s/coll-of group-by-properties :kind vector? :distinct true))

(s/def ::report-request (s/keys :req [::filter ::pull] :opt [::group-by]))

(s/def ::user (s/keys :req [::pull ::filter]))

(s/def ::reporting/query-spec (s/keys :opt [::user]))

(s/def ::secondary-count-request
  (s/keys :req [::uids ::request/request-id]))
