(ns turbovote-admin-specs.utils
  (:require
    [clojure.spec.alpha :as s]))

(defn valid-or-throw
  ([spec value]
   (valid-or-throw spec value ""))
  ([spec value extra-msg]
   (if (not (s/valid? spec value))
     (->> (s/explain-data spec value)
          (ex-info (str extra-msg "Value doesn't match spec: "))
          throw)
     value)))

(defn list-vector-or-set?
  [c]
  (or (list? c) (set? c) (vector? c)))
