/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.tasks.ClojureCompileOptions;
import dev.clojurephant.plugin.clojurescript.ClojureScriptBuild;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompileOptions;
import dev.clojurephant.plugin.clojurescript.tasks.FigwheelOptions;
import dev.clojurephant.plugin.clojurescript.tasks.ForeignLib;
import dev.clojurephant.plugin.clojurescript.tasks.Module;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Provider;
import us.bpsm.edn.Keyword;
import us.bpsm.edn.Symbol;
import us.bpsm.edn.parser.Parseable;
import us.bpsm.edn.parser.Parser;
import us.bpsm.edn.parser.Parsers;
import us.bpsm.edn.printer.Printer;
import us.bpsm.edn.printer.Printers;
import us.bpsm.edn.protocols.Protocol;

public class Edn {
    private static final Printer.Fn<Enum<?>> ENUM_PRINTER = (self, printer) -> printer.printValue((Object)Keyword.newKeyword((String)self.name()));
    private static final Printer.Fn<File> FILE_PRINTER = (self, printer) -> printer.printValue((Object)self.getAbsolutePath());
    private static final Printer.Fn<FileCollection> FILE_COLLECTION_PRINTER = (self, printer) -> {
        if (self.isEmpty()) {
            printer.printValue(null);
        } else {
            printer.printValue(self.getFiles().stream().collect(Collectors.toList()));
        }
    };
    private static final Printer.Fn<NamedDomainObjectCollection<?>> NAMED_DOMAIN_PRINTER = (self, printer) -> printer.printValue((Object)(self.isEmpty() ? null : self.getAsMap()));
    private static final Printer.Fn<Provider<?>> PROVIDER_PRINTER = (self, printer) -> printer.printValue(self.getOrNull());
    private static final Printer.Fn<ClojureCompileOptions> CLOJURE_COMPILE_OPTIONS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> root = new LinkedHashMap<Keyword, Object>();
        root.put(Keyword.newKeyword((String)"disable-locals-clearing"), self.isDisableLocalsClearing());
        root.put(Keyword.newKeyword((String)"direct-linking"), self.isDirectLinking());
        root.put(Keyword.newKeyword((String)"elide-metadata"), self.getElideMeta().stream().map(Keyword::newKeyword).collect(Collectors.toList()));
        printer.printValue(root);
    };
    private static final Printer.Fn<ClojureScriptBuild> CLOJURESCRIPT_BUILD_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> root = new LinkedHashMap<Keyword, Object>();
        root.put(Keyword.newKeyword((String)"output-dir"), self.getOutputDir().map(Directory::getAsFile).getOrNull());
        root.put(Keyword.newKeyword((String)"compiler"), self.getCompiler());
        root.put(Keyword.newKeyword((String)"figwheel"), self.getFigwheel());
        printer.printValue(root);
    };
    private static final Printer.Fn<FigwheelOptions> FIGWHEEL_OPTIONS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> root = new LinkedHashMap<Keyword, Object>();
        root.put(Keyword.newKeyword((String)"watch-dirs"), self.getWatchDirs());
        root.put(Keyword.newKeyword((String)"css-dirs"), self.getCssDirs());
        root.put(Keyword.newKeyword((String)"ring-handler"), Edn.toSymbol(self.getRingHandler()));
        root.put(Keyword.newKeyword((String)"ring-server-options"), Edn.keywordize(self.getRingServerOptions()));
        root.put(Keyword.newKeyword((String)"rebel-readline"), self.getRebelReadline());
        root.put(Keyword.newKeyword((String)"pprint-config"), self.getPprintConfig());
        root.put(Keyword.newKeyword((String)"open-file-command"), self.getOpenFileCommand());
        root.put(Keyword.newKeyword((String)"figwheel-core"), self.getFigwheelCore());
        root.put(Keyword.newKeyword((String)"hot-reload-cljs"), self.getHotReloadCljs());
        root.put(Keyword.newKeyword((String)"connect-url"), self.getConnectUrl());
        root.put(Keyword.newKeyword((String)"open-url"), self.getOpenUrl());
        root.put(Keyword.newKeyword((String)"reload-clj-files"), self.getReloadCljFiles());
        root.put(Keyword.newKeyword((String)"log-file"), self.getLogFile().getOrNull());
        root.put(Keyword.newKeyword((String)"log-level"), Edn.toKeyword(self.getLogLevel()));
        root.put(Keyword.newKeyword((String)"client-log-level"), Edn.toKeyword(self.getClientLogLevel()));
        root.put(Keyword.newKeyword((String)"log-syntax-error-style"), Edn.toKeyword(self.getLogSyntaxErrorStyle()));
        root.put(Keyword.newKeyword((String)"load-warninged-code"), self.getLoadWarningedCode());
        root.put(Keyword.newKeyword((String)"ansi-color-output"), self.getAnsiColorOutput());
        root.put(Keyword.newKeyword((String)"validate-config"), self.getValidateConfig());
        root.put(Keyword.newKeyword((String)"target-dir"), self.getTargetDir().map(Directory::getAsFile).getOrNull());
        root.put(Keyword.newKeyword((String)"launch-node"), self.getLaunchNode());
        root.put(Keyword.newKeyword((String)"inspect-node"), self.getInspectNode());
        root.put(Keyword.newKeyword((String)"node-command"), self.getNodeCommand());
        root.put(Keyword.newKeyword((String)"cljs-devtools"), self.getCljsDevtools());
        Edn.removeEmptyAndNulls(root);
        printer.printValue(root);
    };
    private static final Printer.Fn<ClojureScriptCompileOptions> CLOJURESCRIPT_COMPILE_OPTIONS_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"output-to"), self.getOutputTo().getAsFile().getOrNull());
        map.put(Keyword.newKeyword((String)"output-dir"), self.getOutputDir().getAsFile().getOrNull());
        map.put(Keyword.newKeyword((String)"optimizations"), (Object)self.getOptimizations());
        map.put(Keyword.newKeyword((String)"main"), self.getMain());
        map.put(Keyword.newKeyword((String)"asset-path"), self.getAssetPath());
        map.put(Keyword.newKeyword((String)"source-map"), self.getSourceMap());
        map.put(Keyword.newKeyword((String)"verbose"), self.getVerbose());
        map.put(Keyword.newKeyword((String)"pretty-print"), self.getPrettyPrint());
        map.put(Keyword.newKeyword((String)"target"), (Object)self.getTarget());
        map.put(Keyword.newKeyword((String)"foreign-libs"), self.getForeignLibs());
        map.put(Keyword.newKeyword((String)"externs"), self.getExterns());
        map.put(Keyword.newKeyword((String)"modules"), Edn.parseModules(self.getModules()));
        map.put(Keyword.newKeyword((String)"preloads"), Edn.parsePreloads(self.getPreloads()));
        map.put(Keyword.newKeyword((String)"npm-deps"), self.getNpmDeps());
        map.put(Keyword.newKeyword((String)"install-deps"), self.getInstallDeps());
        map.put(Keyword.newKeyword((String)"checked-arrays"), (Object)self.getCheckedArrays());
        map.put(Keyword.newKeyword((String)"devcards"), self.getDevcards());
        Edn.removeEmptyAndNulls(map);
        printer.printValue(map);
    };
    private static final Printer.Fn<ForeignLib> FOREIGN_LIB_PRINTER = (self, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"file"), self.getFile());
        map.put(Keyword.newKeyword((String)"file-min"), self.getFileMin());
        map.put(Keyword.newKeyword((String)"provides"), self.getProvides());
        map.put(Keyword.newKeyword((String)"requires"), self.getRequires());
        map.put(Keyword.newKeyword((String)"module-type"), (Object)self.getModuleType());
        map.put(Keyword.newKeyword((String)"preprocess"), Edn.parsePreprocess(self.getPreprocess()));
        map.put(Keyword.newKeyword((String)"global-exports"), Edn.parseGlobalExports(self.getGlobalExports()));
        Edn.removeEmptyAndNulls(map);
        printer.printValue(map);
    };
    private static final Printer.Fn<Module> MODULE_PRINTER = (module, printer) -> {
        LinkedHashMap<Keyword, Object> map = new LinkedHashMap<Keyword, Object>();
        map.put(Keyword.newKeyword((String)"output-to"), module.getOutputTo().getAsFile().getOrNull());
        map.put(Keyword.newKeyword((String)"entries"), module.getEntries());
        map.put(Keyword.newKeyword((String)"dependsOn"), module.getDependsOn());
        Edn.removeEmptyAndNulls(map);
        printer.printValue(map);
    };
    private static final Protocol<Printer.Fn<?>> PROTOCOL = Printers.prettyProtocolBuilder().put(Enum.class, ENUM_PRINTER).put(File.class, FILE_PRINTER).put(FileCollection.class, FILE_COLLECTION_PRINTER).put(NamedDomainObjectCollection.class, NAMED_DOMAIN_PRINTER).put(Provider.class, PROVIDER_PRINTER).put(ClojureCompileOptions.class, CLOJURE_COMPILE_OPTIONS_PRINTER).put(ClojureScriptBuild.class, CLOJURESCRIPT_BUILD_PRINTER).put(FigwheelOptions.class, FIGWHEEL_OPTIONS_PRINTER).put(ClojureScriptCompileOptions.class, CLOJURESCRIPT_COMPILE_OPTIONS_PRINTER).put(ForeignLib.class, FOREIGN_LIB_PRINTER).put(Module.class, MODULE_PRINTER).build();

    private static Map<Keyword, Module> parseModules(Map<String, Module> modules) {
        return modules.entrySet().stream().collect(Collectors.toMap(e -> Keyword.newKeyword((String)((String)e.getKey())), Map.Entry::getValue));
    }

    private static List<Symbol> parsePreloads(Collection<String> preloads) {
        if (preloads == null) {
            return null;
        }
        return preloads.stream().map(Symbol::newSymbol).collect(Collectors.toList());
    }

    private static Object parsePreprocess(String value) {
        if (value == null) {
            return null;
        }
        Parseable parseable = Parsers.newParseable((CharSequence)value);
        Parser parser = Parsers.newParser((Parser.Config)Parsers.defaultConfiguration());
        return parser.nextValue(parseable);
    }

    private static Map<Symbol, Symbol> parseGlobalExports(Map<String, String> globalExports) {
        return globalExports.entrySet().stream().collect(Collectors.toMap(e -> Symbol.newSymbol((String)((String)e.getKey())), e -> Symbol.newSymbol((String)((String)e.getValue()))));
    }

    public static String print(Object value) {
        return Printers.printString(PROTOCOL, (Object)value);
    }

    private static Symbol toSymbol(String name) {
        return Optional.ofNullable(name).map(Symbol::newSymbol).orElse(null);
    }

    private static Keyword toKeyword(String name) {
        return Optional.ofNullable(name).map(Keyword::newKeyword).orElse(null);
    }

    public static <V> Map<Keyword, V> keywordize(Map<String, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(e -> Keyword.newKeyword((String)((String)e.getKey())), e -> e.getValue()));
    }

    private static <K, V> void removeEmptyAndNulls(Map<K, V> map) {
        map.values().removeIf(Objects::isNull);
        map.values().removeIf(obj -> obj instanceof Collection && ((Collection)obj).isEmpty());
        map.values().removeIf(obj -> obj instanceof Map && ((Map)obj).isEmpty());
    }
}

