/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.common.internal;

import dev.clojurephant.plugin.clojure.ClojureBasePlugin;
import dev.clojurephant.plugin.clojure.tasks.ClojureCheck;
import dev.clojurephant.plugin.clojure.tasks.ClojureCompile;
import dev.clojurephant.plugin.clojure.tasks.ClojureNRepl;
import dev.clojurephant.plugin.clojurescript.tasks.ClojureScriptCompile;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.function.Consumer;
import java.util.function.Function;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ComponentModuleMetadataDetails;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetOutput;
import org.gradle.language.jvm.tasks.ProcessResources;

public class ClojureCommonPlugin
implements Plugin<Project> {
    public static final String DEV_SOURCE_SET_NAME = "dev";
    public static final String NREPL_CONFIGURATION_NAME = "nrepl";
    public static final String NREPL_TASK_NAME = "clojureRepl";

    public void apply(Project project) {
        project.getPlugins().apply(ClojureBasePlugin.class);
        project.getPlugins().apply(JavaPlugin.class);
        JavaPluginConvention javaConvention = (JavaPluginConvention)project.getConvention().getPlugin(JavaPluginConvention.class);
        this.configureDev(project, javaConvention);
        this.configureDependencyConstraints(project);
        ClojureCommonPlugin.configureDevSource(javaConvention, SourceSet::getResources);
    }

    private void configureDev(Project project, JavaPluginConvention javaConvention) {
        SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
        SourceSet test = (SourceSet)javaConvention.getSourceSets().getByName("test");
        SourceSet dev = (SourceSet)javaConvention.getSourceSets().create(DEV_SOURCE_SET_NAME);
        Configuration nrepl = (Configuration)project.getConfigurations().create(NREPL_CONFIGURATION_NAME);
        project.getDependencies().add(NREPL_CONFIGURATION_NAME, (Object)"nrepl:nrepl:0.6.0");
        project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName()).extendsFrom(new Configuration[]{nrepl});
        Function<SourceSet, FileCollection> nonClojureOutput = sourceSet -> {
            SourceSetOutput allOutput = sourceSet.getOutput();
            return allOutput.filter(file -> project.getTasks().stream().filter(task -> task instanceof ClojureCompile || task instanceof ClojureScriptCompile || task instanceof ProcessResources).allMatch(task -> !task.getOutputs().getFiles().contains(file)));
        };
        dev.setCompileClasspath((FileCollection)project.files(new Object[]{test.getOutput(), main.getOutput(), project.getConfigurations().getByName(dev.getCompileClasspathConfigurationName())}));
        dev.setRuntimeClasspath((FileCollection)project.files(new Object[]{dev.getAllSource().getSourceDirectories(), nonClojureOutput.apply(dev), nonClojureOutput.apply(test), nonClojureOutput.apply(main), project.getConfigurations().getByName(dev.getRuntimeClasspathConfigurationName())}));
        Consumer<Function> devExtendsTest = getConfName -> {
            Configuration devConf = project.getConfigurations().getByName((String)getConfName.apply(dev));
            Configuration testConf = project.getConfigurations().getByName((String)getConfName.apply(test));
            devConf.extendsFrom(new Configuration[]{testConf});
        };
        devExtendsTest.accept(SourceSet::getCompileConfigurationName);
        devExtendsTest.accept(SourceSet::getImplementationConfigurationName);
        devExtendsTest.accept(SourceSet::getRuntimeConfigurationName);
        devExtendsTest.accept(SourceSet::getRuntimeOnlyConfigurationName);
        Task repl = project.getTasks().create(NREPL_TASK_NAME, ClojureNRepl.class, task -> {
            task.setGroup("run");
            task.setDescription("Starts an nREPL server.");
            task.setClasspath(dev.getRuntimeClasspath());
        });
        project.getGradle().getTaskGraph().whenReady(graph -> {
            if (!graph.hasTask(repl)) {
                return;
            }
            HashSet selectedTasks = new HashSet(graph.getAllTasks());
            LinkedList<Task> toProcess = new LinkedList<Task>();
            toProcess.add(repl);
            HashSet<Task> toDisable = new HashSet<Task>();
            while (!toProcess.isEmpty()) {
                Task next = (Task)toProcess.remove();
                selectedTasks.remove(next);
                if (next instanceof ClojureCompile || next instanceof ClojureScriptCompile) {
                    toDisable.add(next);
                } else if (next instanceof ClojureCheck && !"checkDevClojure".equals(next.getName())) {
                    toDisable.add(next);
                }
                graph.getDependencies(next).forEach(toProcess::add);
            }
            if (selectedTasks.isEmpty()) {
                toDisable.forEach(task -> task.setEnabled(false));
            }
        });
    }

    private void configureDependencyConstraints(Project project) {
        project.getDependencies().getModules().module((Object)"org.clojure:tools.nrepl", module -> {
            ComponentModuleMetadataDetails details = module;
            details.replacedBy((Object)"nrepl:nrepl", "nREPL was moved out of Clojure Contrib to its own project.");
        });
        if (JavaVersion.current().isJava9Compatible()) {
            project.getDependencies().constraints(constraints -> constraints.add("devRuntimeClasspath", (Object)"org.clojure:java.classpath:0.3.0", constraint -> constraint.because("Java 9 has a different classloader architecture. 0.3.0 adds support for this.")));
        }
    }

    public static void configureDevSource(JavaPluginConvention javaConvention, Function<SourceSet, SourceDirectorySet> languageMapper) {
        SourceSet main = (SourceSet)javaConvention.getSourceSets().getByName("main");
        SourceSet test = (SourceSet)javaConvention.getSourceSets().getByName("test");
        SourceSet dev = (SourceSet)javaConvention.getSourceSets().getByName(DEV_SOURCE_SET_NAME);
        languageMapper.apply(dev).source(languageMapper.apply(test));
        languageMapper.apply(dev).source(languageMapper.apply(main));
    }
}

