/*
 * Decompiled with CFR 0.152.
 */
package dev.clojurephant.plugin.clojure;

import dev.clojurephant.plugin.clojure.ClojureBuild;
import dev.clojurephant.plugin.clojure.ClojureExtension;
import dev.clojurephant.plugin.clojure.tasks.ClojureCheck;
import dev.clojurephant.plugin.clojure.tasks.ClojureCompile;
import dev.clojurephant.plugin.common.internal.ClojureCommonBasePlugin;
import dev.clojurephant.plugin.common.internal.Namespaces;
import java.io.File;
import java.util.Collections;
import javax.inject.Inject;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.tasks.DefaultSourceSetOutput;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;

public class ClojureBasePlugin
implements Plugin<Project> {
    private final ObjectFactory objects;

    @Inject
    public ClojureBasePlugin(ObjectFactory objects) {
        this.objects = objects;
    }

    public void apply(Project project) {
        project.getPluginManager().apply(ClojureCommonBasePlugin.class);
        ClojureExtension extension = (ClojureExtension)project.getExtensions().create("clojure", ClojureExtension.class, new Object[0]);
        SourceSetContainer sourceSets = (SourceSetContainer)project.getExtensions().getByType(SourceSetContainer.class);
        this.configureSourceSetDefaults(project, sourceSets, extension);
        this.configureBuildDefaults(project, sourceSets, extension);
        this.configureCheckDefaults(project.getTasks());
    }

    private void configureSourceSetDefaults(Project project, SourceSetContainer sourceSets, ClojureExtension extension) {
        sourceSets.all(sourceSet -> {
            SourceDirectorySet clojureSource = this.objects.sourceDirectorySet(sourceSet.getName(), sourceSet.getName());
            clojureSource.srcDir((Object)String.format("src/%s/clojure", sourceSet.getName()));
            clojureSource.getFilter().include(Namespaces.CLOJURE_PATTERNS);
            sourceSet.getExtensions().add("clojure", (Object)clojureSource);
            sourceSet.getResources().getFilter().exclude(element -> clojureSource.contains(element.getFile()));
            sourceSet.getAllSource().source(clojureSource);
            ClojureBuild build = (ClojureBuild)extension.getBuilds().create(sourceSet.getName());
            build.getSourceRoots().from(new Object[]{clojureSource.getSourceDirectories()});
            clojureSource.getDestinationDirectory().set((Provider)build.getOutputDir());
            build.getClasspath().from(new Object[]{project.provider(() -> sourceSet.getCompileClasspath())}).from(new Object[]{project.files(new Object[]{sourceSet.getJava().getClassesDirectory()})}).from(new Object[]{project.getTasks().named(sourceSet.getProcessResourcesTaskName())});
            Provider output = project.provider(() -> {
                if (build.isCompilerConfigured()) {
                    return project.files(new Object[]{build.getOutputDir()});
                }
                return build.getSourceRoots();
            });
            ((DefaultSourceSetOutput)sourceSet.getOutput()).getClassesDirs().from(new Object[]{output});
            project.getTasks().named(sourceSet.getClassesTaskName(), task -> {
                task.dependsOn(new Object[]{build.getTaskName("compile")});
                task.dependsOn(new Object[]{build.getTaskName("check")});
            });
        });
    }

    private void configureBuildDefaults(Project project, SourceSetContainer sourceSets, ClojureExtension extension) {
        extension.getRootOutputDir().set(project.getLayout().getBuildDirectory().dir("clojure"));
        extension.getBuilds().configureEach(build -> {
            build.getOutputDir().convention(extension.getRootOutputDir().dir(build.getName()));
            build.getReflection().convention((Object)"silent");
            build.getCompiler().getDirectLinking().convention((Object)false);
            build.getCompiler().getDisableLocalsClearing().convention((Object)false);
            build.getCompiler().getElideMeta().convention(Collections.emptyList());
            String checkTaskName = build.getTaskName("check");
            project.getTasks().register(checkTaskName, ClojureCheck.class, task -> {
                task.setDescription(String.format("Checks the Clojure source for the %s build.", build.getName()));
                task.setSource(build.getSourceTree());
                task.getClasspath().from(new Object[]{build.getSourceRoots()});
                task.getClasspath().from(new Object[]{build.getClasspath()});
                task.getReflection().set(build.getReflection());
                task.getNamespaces().set(build.getCheckNamespaces());
            });
            String compileTaskName = build.getTaskName("compile");
            TaskProvider compileTask = project.getTasks().register(compileTaskName, ClojureCompile.class, task -> {
                task.setDescription(String.format("Compiles the Clojure source for the %s build.", build.getName()));
                task.getDestinationDir().set((Provider)build.getOutputDir());
                task.setSource(build.getSourceTree());
                task.getClasspath().from(new Object[]{build.getSourceRoots()});
                task.getClasspath().from(new Object[]{build.getClasspath()});
                task.getOptions().set((Object)build.getCompiler());
                task.getNamespaces().set(build.getAotNamespaces());
            });
            SourceSet sourceSet = (SourceSet)sourceSets.findByName(build.getName());
            if (sourceSet != null) {
                SourceDirectorySet source = (SourceDirectorySet)sourceSet.getExtensions().getByName("clojure");
                source.compiledBy(compileTask, ClojureCompile::getDestinationDir);
            }
        });
    }

    private void configureCheckDefaults(TaskContainer tasks) {
        tasks.withType(ClojureCheck.class, task -> task.getInternalOutputFile().set(new File(task.getTemporaryDir(), "internal.txt")));
    }
}

