/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classloader;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.internal.classloader.ClassLoaderHierarchy;
import org.gradle.internal.classloader.ClassLoaderSpec;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.internal.classloader.ClassLoaderVisitor;
import org.gradle.internal.classloader.DelegatingClassLoader;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class MultiParentClassLoader
extends ClassLoader
implements DelegatingClassLoader,
ClassLoaderHierarchy {
    private final List<ClassLoader> parents;

    public MultiParentClassLoader(ClassLoader ... parents) {
        this(Arrays.asList(parents));
    }

    public MultiParentClassLoader(Collection<? extends ClassLoader> parents) {
        super(null);
        this.parents = new CopyOnWriteArrayList<ClassLoader>(parents);
    }

    public String toString() {
        return MultiParentClassLoader.class.getSimpleName() + "(" + StringUtils.join(this.parents, ", ") + ")";
    }

    public void addParent(ClassLoader parent) {
        this.parents.add(parent);
    }

    public List<ClassLoader> getParents() {
        return ImmutableList.copyOf(this.parents);
    }

    @Override
    public void visit(ClassLoaderVisitor visitor) {
        visitor.visitSpec(new Spec());
        for (ClassLoader parent : this.parents) {
            visitor.visitParent(parent);
        }
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (ClassLoader parent : this.parents) {
            try {
                return parent.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(String.format("%s not found.", name));
    }

    @Override
    protected Package getPackage(String name) {
        for (ClassLoader parent : this.parents) {
            Package p = ClassLoaderUtils.getPackage(parent, name);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    @Override
    protected Package[] getPackages() {
        LinkedHashSet<Package> packages = new LinkedHashSet<Package>();
        for (ClassLoader parent : this.parents) {
            Package[] parentPackages = ClassLoaderUtils.getPackages(parent);
            packages.addAll(Arrays.asList(parentPackages));
        }
        return packages.toArray(new Package[0]);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader parent : this.parents) {
            URL resource = parent.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        LinkedHashSet<URL> resources = new LinkedHashSet<URL>();
        for (ClassLoader parent : this.parents) {
            Enumeration<URL> parentResources = parent.getResources(name);
            while (parentResources.hasMoreElements()) {
                resources.add(parentResources.nextElement());
            }
        }
        return Collections.enumeration(resources);
    }

    static {
        try {
            ClassLoader.registerAsParallelCapable();
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public static class Spec
    extends ClassLoaderSpec {
        public boolean equals(Object obj) {
            return obj != null && obj.getClass().equals(Spec.class);
        }

        public int hashCode() {
            return this.getClass().getName().hashCode();
        }
    }
}

