(defproject dev.corkplace/reconciler "0.0.1"
  :description "A reconciler."
  :url "http://package.corkplace.dev/reconciler"
  :plugins [[lein-cljsbuild "1.1.8"]
            [lein-codox "0.10.7"]
            [lein-doo "0.1.10"]]
  :license {:name "EPL-2.0 OR GPL-2.0-or-later WITH Classpath-exception-2.0"
            :url "https://www.eclipse.org/legal/epl-2.0/"}
  :dependencies [[org.clojure/clojure "1.10.0"]
                 [org.clojure/clojurescript "1.10.764"]]
  :doo {:headless [:chrome-headless]
        :paths {:karma "./node_modules/.bin/karma"}}
  :codox {:language :clojurescript
          :output-path "codox"}
  :profiles {:test {:dependencies [[pjstadig/humane-test-output "0.10.0"]]}}
  :cljsbuild
  {:builds {:dev {:source-paths ["src/cljs"]
                  :compiler {:optimizations :whitespace}}
            :prod {:source-paths ["src/cljs"]
                   :compiler {:optimizations :advanced}}
            :test {:id "test"
                   :source-paths ["src/cljs" "test-cljs"]
                   :compiler {:output-to "target/cljs-tests.js"
                              :output-dir "target"
                              :main dev.corkplace.reconciler.test.runner}}}})
