(ns dev.corkplace.reconciler.dom
  (:refer-clojure :exclude [name]))

(defn elt [type]
  (let [node (js/document.createElement type)]
    node))

(def div (partial elt "div"))
(def p (partial elt "p"))
(def span (partial elt "span"))
(def button (partial elt "button"))

(defprotocol IEvent
  (attach [this event handler])
  (detach [this event handler]))

(defprotocol INode
  (get-content [this] [this or])
  (set-content [this value])
  (add-child [this node])
  (remove-child [this node])
  (children [this]))

(extend-type js/Element
  IMap
  (-dissoc [this k]
    (.removeAttribute this k))
  IEvent
  (attach [this event handler]
    (.addEventListener this event handler))
  (detach [this event handler]
    (.removeEventListener this event handler))
  INamed
  (-name [this]
    (if (empty? (.-id this))
      (.-tagName this)
      (.-id this)))
  ICloneable
  (-clone [this]
    (.cloneNode this))
  IAssociative
  (-contains-key? [this k]
    (.hasAttribute this k))
  (-assoc [this k v]
    (.setAttribute this k v)
    this)
  ILookup
  (-lookup [this k]
    (.getAttribute this k))
  (-lookup [this k not-found]
    (or (-looup this k)
        not-found))
  IIndexed
  (-nth [this n]
    (aget (.-children this) n))
  (-nth [this n not-found]
    (or (aget (.-children this) n)
        not-found))
  ICounted
  (-count [this]
    (.. this -children -length))
  INode
  (children [this]
    (.-children this))
  (get-content [this]
    (.-innerHTML this)
    this)
  (get-content [this not-found]
    (or (get-content this) not-found))
  (set-content [this value]
    (set! (.-textContent this) value)
    this)
  (add-child [this node]
    (.appendChild this node)
    this)
  (remove-child [this node]
    (.removeChild this node)
    this))

(defn mount
  "Mount tree onto Dom Node."
  [tree dom-node]
  (println "Mounting tree onto dom node."))

(defn ^:export main [])

(main)
