(ns dev.corkplace.reconciler.tree
  (:require [clojure.set :as set]))

(defn node
  ([key] (node key {}))
  ([key attr] (node key attr children))
  ([key attr children]
   {:type key
    :attr attr
    :children (reduce
                (fn [output child]
                  (assoc output (:type child) child))
                {}
                children)}))

(def sample-a
  (node :container
    {}
    [(node :name {} [(node :alex)])]))

(def sample-b
  (node :container
    {}
    [(node :name {:show? true} [(node :alex)])]))


(comment
  (def sample-a
    {:container {:name "alex" :address "18 cork place"}})
  (def sample-b
    {:container {:name "alex" :age 25
                 :address "1000 Beethoven Cmn"}}))


(defprotocol IID
  (id [this]))

(extend-type js/String
  IID
  (id [this]
    (keyword (str this))))

(defn make-edge-list
  ([tree] (make-edge-list :root tree))
  ([pid tree]
   (cond
     (nil? tree) #{}
     (map? tree)
     (reduce
       (fn [output [k v]]
         (-> output
           (conj [pid k])
           (concat (make-edge-list k v))))
       #{}
       tree)
     :else
     #{[pid tree]})))


(println (make-edge-list sample-tree))

(defn make-change-list [a b]
  (let [a-edges (set (make-edge-list a))
        b-edges (set (make-edge-list b))]
    {:remove (set/difference a-edges b-edges)
     :add (set/difference b-edges a-edges)}))
