;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.gl
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"01-01" {:name (partial get-name "01-01")},
   "easter 39" {:name (partial get-name "easter 39")},
   "easter 50" {:name (partial get-name "easter 50")},
   "easter" {:name (partial get-name "easter")},
   "06-21"
   {:name {:kl "ullortuneq", :da "Nationaldag", :en "National Day"}},
   "12-24" {:name (partial get-name "12-24")},
   "easter -2" {:name (partial get-name "easter -2")},
   "12-26" {:name (partial get-name "12-26")},
   "easter 49" {:name (partial get-name "easter 49")},
   "easter 1" {:name (partial get-name "easter 1")},
   "easter -3" {:name (partial get-name "easter -3")},
   "easter 26"
   {:name {:kl "tussiarfissuaq", :da "Store Bededag", :en "Prayer Day"}},
   "01-06" {:name (partial get-name "01-06")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :gl
  [_ context]
  (holiday? context))
