;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.gu
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"1st monday in March"
   {:name {:en "Guam History and Chamorro Heritage Day"}},
   "easter -2"
   {"type" "observance", :name (partial get-name "easter -2")},
   "07-21 if sunday then next monday" {:name {:en "Liberation Day"}},
   "11-02" {:name (partial get-name "11-02")},
   "12-08 if sunday then next monday"
   {:name {:en "Our Lady of Camarin Day"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :gu
  [_ context]
  (holiday? context))
