;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.sc
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"12-08" {:name (partial get-name "12-08")},
   "08-15" {:name (partial get-name "08-15")},
   "easter 60" {:name (partial get-name "easter 60")},
   "06-29" {:name (partial get-name "Independence Day")},
   "06-18" {:name (partial get-name "National Holiday")},
   "11-01" {:name (partial get-name "11-01")},
   "easter -1" {:name (partial get-name "easter -1")},
   "easter" {:name (partial get-name "easter")},
   "easter -2" {:name (partial get-name "easter -2")},
   "01-01 P2D" {:name (partial get-name "01-01")},
   "easter 1" {:name (partial get-name "easter 1")},
   "05-01" {:name (partial get-name "05-01")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :sc
  [_ context]
  (holiday? context))
