;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.tg
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"11 Dhu al-Hijjah" {:name (partial get-name "10 Dhu al-Hijjah")},
   "08-15" {:name (partial get-name "08-15")},
   "04-27" {:name (partial get-name "Independence Day")},
   "01-01" {:name (partial get-name "01-01")},
   "easter 39" {:name (partial get-name "easter 39")},
   "11-01" {:name (partial get-name "11-01")},
   "easter 50" {:name (partial get-name "easter 50")},
   "06-21" {:name {:fr "Journée des Martyrs", :en "Day of the Martyrs"}},
   "01-13" {:name {:fr "Jour de la libération", :en "Liberation Day"}},
   "2 Shawwal" {:name (partial get-name "1 Shawwal")},
   "easter 1" {:name (partial get-name "easter 1")},
   "13 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")},
   "05-01" {:name (partial get-name "05-01")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :tg
  [_ context]
  (holiday? context))
