;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.au
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"12-26 and if saturday then next monday if sunday then next tuesday"
   {"substitute" true, :name (partial get-name "12-26")},
   "01-26 if saturday,sunday then next monday"
   {"substitute" true, :name {:en "Australia Day"}},
   "easter -1" {:name (partial get-name "easter -1")},
   "easter" {:name (partial get-name "easter")},
   "1st sunday in September"
   {"type" "observance", :name (partial get-name "Fathers Day")},
   "01-01 and if saturday,sunday then next monday"
   {:name (partial get-name "01-01")},
   "easter -2" {:name (partial get-name "easter -2")},
   "2nd sunday in May"
   {"type" "observance", :name (partial get-name "Mothers Day")},
   "12-25 and if saturday then next monday if sunday then next tuesday"
   {"substitute" true, :name (partial get-name "12-25")},
   "easter 1" {:name (partial get-name "easter 1")},
   "04-25" {:name {:en "Anzac Day"}},
   "2022-09-22"
   {:name {:en "National Day of Mourning for Queen Elizabeth II"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :au
  [_ context]
  (holiday? context))
