;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.zm
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"03-12 and if sunday then next monday"
   {"substitute" true, :name {:en "Youth Day"}},
   "1st monday in July" {:name {:en "Heroes' Day"}},
   "03-09" {:name {:en "Women’s Day"}},
   "01-01 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "01-01")},
   "tuesday after 1st monday in July" {:name {:en "Unity Day"}},
   "12-25 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "12-25")},
   "10-24 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "Independence Day")},
   "2015-10-18" {:name {:en "National day of Prayers"}},
   "easter -2" {:name (partial get-name "easter -2")},
   "easter 1" {:name (partial get-name "easter 1")},
   "05-25 and if sunday then next monday"
   {"substitute" true, :name {:en "African Freedom Day"}},
   "05-01 and if sunday then next monday"
   {"substitute" true, :name (partial get-name "05-01")},
   "1st monday in August" {:name {:en "Farmers' Day"}}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :zm
  [_ context]
  (holiday? context))
