;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.bq
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"04-27"
   {:name {:pap "Aña di Rey", :nl "Koningsdag", :en "Kings Day"}},
   "01-01" {:name (partial get-name "01-01")},
   "easter 39" {:name (partial get-name "easter 39")},
   "3rd sunday in June"
   {"type" "observance", :name (partial get-name "Fathers Day")},
   "12-15"
   {:name
    {:pap "Dia di Reino", :nl "Koninkrijksdag", :en "Kingdom Day"}},
   "easter" {"type" "observance", :name (partial get-name "easter")},
   "12-05"
   {"type" "observance",
    :name {:nl "Sinterklaasavond", :en "St. Nicholas' Eve"}},
   "easter -2" {:name (partial get-name "easter -2")},
   "2nd sunday in May"
   {"type" "observance", :name (partial get-name "Mothers Day")},
   "05-01 if sunday then next monday"
   {"substitute" true, :name (partial get-name "05-01")},
   "12-26" {:name (partial get-name "12-26")},
   "easter 1" {:name (partial get-name "easter 1")},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :bq
  [_ context]
  (holiday? context))
