;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.cx
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"10 Dhu al-Hijjah"
   {"_name" "10 Dhu al-Hijjah", :name {:ms "Hari Raya Haji"}},
   "01-01" {:name (partial get-name "01-01")},
   "01-26" {:name {:en "Australia Day"}},
   "10-06" {:name {:en "Territory Day"}},
   "4th monday in March" {:name (partial get-name "05-01")},
   "easter -2" {:name (partial get-name "easter -2")},
   "1 Shawwal" {"_name" "1 Shawwal", :name {:ms "Hari Raya Puasa"}},
   "12-26" {:name (partial get-name "12-26")},
   "chinese 01-0-01 P2D" {:name {:en "Chinese New Year", :zh "春节"}},
   "04-25" {:name {:en "Anzac Day"}},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :cx
  [_ context]
  (holiday? context))
