;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.gr
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"08-15" {:name (partial get-name "08-15")},
   "orthodox 49" {:name (partial get-name "easter 49")},
   "01-01" {:name (partial get-name "01-01")},
   "03-25"
   {:name
    {:el "Ευαγγελισμός, Εθνική Εορτή",
     :en "Annunciation, Anniversary of 1821 Revolution"}},
   "orthodox 50" {:name (partial get-name "easter 50")},
   "2nd sunday in May"
   {"type" "observance", :name (partial get-name "Mothers Day")},
   "12-26" {:name (partial get-name "12-26")},
   "orthodox -2" {:name (partial get-name "easter -2")},
   "05-01" {:name (partial get-name "05-01")},
   "10-28" {"_name" "National Holiday", :name {:el "Επέτειος του Όχι"}},
   "orthodox" {:name (partial get-name "easter")},
   "01-06" {:name (partial get-name "01-06")},
   "orthodox 1" {:name (partial get-name "easter 1")},
   "orthodox -48" {:name {:el "Καθαρά Δευτέρα", :en "Ash Sunday"}},
   "12-25" {:name (partial get-name "12-25")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :gr
  [_ context]
  (holiday? context))
