;; This file is autogenerated using timing.holidays.compile/-main

(ns timing.holiday.id
  (:require
   [clojure.string]
   [timing.holiday :refer [is-holiday?]]
   [timing.holiday.util :refer [parse-definition
                              get-name]]
   [timing.holiday.compiler :as compiler]))

(def holidays
  {"2026-05-31" {:name (partial get-name "Vesak")},
   "2010-03-16" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "06-01" {:name {:en "Pancasila Day", :id "Hari Lahir Pancasila"}},
   "10 Dhu al-Hijjah" {:name (partial get-name "10 Dhu al-Hijjah")},
   "2015-06-02" {:name (partial get-name "Vesak")},
   "2020-05-07" {:name (partial get-name "Vesak")},
   "2001-05-07" {:name (partial get-name "Vesak")},
   "2012-03-23" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "01-01" {:name (partial get-name "01-01")},
   "2019-03-07" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "easter 39" {:name (partial get-name "easter 39")},
   "2011-03-05" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2024-05-23" {:name (partial get-name "Vesak")},
   "2015-03-21" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2022-03-03" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2012-05-06" {:name (partial get-name "Vesak")},
   "27 Rajab" {:name (partial get-name "27 Rajab")},
   "2009-03-26" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2002-05-26" {:name (partial get-name "Vesak")},
   "2008-05-20" {:name (partial get-name "Vesak")},
   "2018-03-17" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2016-03-09" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2025-05-12" {:name (partial get-name "Vesak")},
   "2016-05-22" {:name (partial get-name "Vesak")},
   "2026-03-19" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "1 Muharram" {:name (partial get-name "1 Muharram")},
   "chinese 01-0-01"
   {:name {:en "Chinese New Year", :id "Tahun Baru Imlek"}},
   "2013-03-12" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2024-03-11" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2017-05-11" {:name (partial get-name "Vesak")},
   "2018-05-29" {:name (partial get-name "Vesak")},
   "2005-05-24" {:name (partial get-name "Vesak")},
   "easter -2" {:name (partial get-name "easter -2")},
   "1 Shawwal" {:name (partial get-name "1 Shawwal")},
   "2022-05-16" {:name (partial get-name "Vesak")},
   "2009-05-09" {:name (partial get-name "Vesak")},
   "2014-05-15" {:name (partial get-name "Vesak")},
   "2014-03-31" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2 Shawwal" {:name (partial get-name "1 Shawwal")},
   "2011-05-17" {:name (partial get-name "Vesak")},
   "2006-05-13" {:name (partial get-name "Vesak")},
   "2004-06-03" {:name (partial get-name "Vesak")},
   "2023-03-22" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2025-03-29" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "05-01" {:name (partial get-name "05-01")},
   "2021-03-14" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2021-05-26" {:name (partial get-name "Vesak")},
   "2010-05-28" {:name (partial get-name "Vesak")},
   "2019-05-19" {:name (partial get-name "Vesak")},
   "08-17" {:name (partial get-name "Independence Day")},
   "2003-05-16" {:name (partial get-name "Vesak")},
   "12 Rabi al-awwal" {:name (partial get-name "12 Rabi al-awwal")},
   "2020-03-25" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2023-05-06" {:name (partial get-name "Vesak")},
   "2027-05-20" {:name (partial get-name "Vesak")},
   "12-25" {:name (partial get-name "12-25")},
   "2017-03-28" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2013-05-25" {:name (partial get-name "Vesak")},
   "2027-03-08" {:name {:en "Nyepi", :id "Hari Raya Nyepi"}},
   "2007-06-01" {:name (partial get-name "Vesak")}})

(def locale-holiday-mapping
  (reduce-kv
   (fn [result definition name-mapping]
     (assoc result
            (compiler/compile-type (parse-definition definition))
            name-mapping))
   {}
   holidays))

(defn holiday?
  [context]
  (some
   (fn [[pred naming]]
     (when (pred context)
       naming))
   locale-holiday-mapping))

(defmethod is-holiday? :id
  [_ context]
  (holiday? context))
