(ns
 toddler.material.round
 (:refer-clojure
  :exclude
  [merge
   map
   loop
   cast
   repeat
   shuffle
   sync
   remove
   sort
   send
   compare
   filter
   update
   print
   list
   commute
   class
   comment
   key])
 (:require [helix.core] [helix.dom]))


(helix.core/defnc
 agriculture
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.5,11.97c0.93,0,1.78,0.28,2.5,0.76V7.97c0-1.1-0.9-2-2-2h-6.29l-1.06-1.06l1.06-1.06c0.2-0.2,0.2-0.51,0-0.71 s-0.51-0.2-0.71,0l-2.83,2.83c-0.2,0.2-0.2,0.51,0,0.71l0,0c0.2,0.2,0.51,0.2,0.71,0l1.06-1.06L13,6.68v2.29c0,1.1-0.9,2-2,2 h-0.54c0.95,1.06,1.54,2.46,1.54,4c0,0.34-0.04,0.67-0.09,1h3.14C15.3,13.73,17.19,11.97,19.5,11.97z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.5,12.97c-1.93,0-3.5,1.57-3.5,3.5s1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S21.43,12.97,19.5,12.97z M19.5,17.97 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S20.33,17.97,19.5,17.97z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,8.97h5c0-1.1-0.9-2-2-2H4c-0.55,0-1,0.45-1,1C3,8.53,3.45,8.97,4,8.97z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.83,13.79l-0.18-0.47l0.93-0.35c-0.46-1.06-1.28-1.91-2.31-2.43l-0.4,0.89l-0.46-0.21l0.4-0.9 C7.26,10.11,6.64,9.97,6,9.97c-0.53,0-1.04,0.11-1.52,0.26l0.34,0.91l-0.47,0.18L4,10.4c-1.06,0.46-1.91,1.28-2.43,2.31l0.89,0.4 l-0.21,0.46l-0.9-0.4C1.13,13.72,1,14.33,1,14.97c0,0.53,0.11,1.04,0.26,1.52l0.91-0.34l0.18,0.47l-0.93,0.35 c0.46,1.06,1.28,1.91,2.31,2.43l0.4-0.89l0.46,0.21l-0.4,0.9c0.57,0.22,1.18,0.35,1.82,0.35c0.53,0,1.04-0.11,1.52-0.26L7.18,18.8 l0.47-0.18L8,19.55c1.06-0.46,1.91-1.28,2.43-2.31l-0.89-0.4l0.21-0.46l0.9,0.4c0.22-0.57,0.35-1.18,0.35-1.82 c0-0.53-0.11-1.04-0.26-1.52L9.83,13.79z M7.15,17.75c-1.53,0.63-3.29-0.09-3.92-1.62c-0.63-1.53,0.09-3.29,1.62-3.92 c1.53-0.63,3.29,0.09,3.92,1.62C9.41,15.36,8.68,17.11,7.15,17.75z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 diamond
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "12.16,3 11.84,3 9.21,8.25 14.79,8.25",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16.46,8.25h5.16l-2.07-4.14C19.21,3.43,18.52,3,17.76,3h-3.93L16.46,8.25z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "21.38,9.75 12.75,9.75 12.75,20.1",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/polygon
      {:points "11.25,20.1 11.25,9.75 2.62,9.75",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M7.54,8.25L10.16,3H6.24C5.48,3,4.79,3.43,4.45,4.11L2.38,8.25H7.54z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 local-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 11.55c-1.82-1.7-4.12-2.89-6.68-3.35C4.11 7.99 3 8.95 3 10.18v6.24c0 1.68.72 2.56 1.71 2.69 2.5.32 4.77 1.35 6.63 2.87.35.29.92.32 1.27.04 1.87-1.53 4.16-2.58 6.68-2.9.94-.13 1.71-1.06 1.71-2.02v-6.92c0-1.23-1.11-2.19-2.32-1.98-2.56.46-4.86 1.65-6.68 3.35zM12 8c1.66 0 3-1.34 3-3s-1.34-3-3-3-3 1.34-3 3 1.34 3 3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 connecting-airports
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.93,10.6c0.39,0,0.66,0.37,0.55,0.74L15.4,15h2.85l0.59-0.78c0.1-0.14,0.26-0.22,0.43-0.22c0.36,0,0.62,0.35,0.52,0.7 L19.4,16l0.39,1.3c0.1,0.35-0.16,0.7-0.52,0.7c-0.17,0-0.33-0.08-0.43-0.22L18.25,17H15.4l1.08,3.66c0.11,0.37-0.17,0.74-0.55,0.74 c-0.2,0-0.39-0.11-0.5-0.28L13,17h-2.97c-0.53,0-1-0.4-1.03-0.93C8.96,15.48,9.43,15,10,15h3l2.43-4.12 C15.54,10.71,15.73,10.6,15.93,10.6z M8.07,2.6c-0.39,0-0.66,0.37-0.55,0.74L8.6,7H5.75L5.16,6.22C5.06,6.08,4.9,6,4.73,6 C4.37,6,4.11,6.35,4.21,6.7L4.6,8L4.21,9.3C4.11,9.65,4.37,10,4.73,10c0.17,0,0.33-0.08,0.43-0.22L5.75,9H8.6l-1.08,3.66 c-0.11,0.37,0.17,0.74,0.55,0.74c0.2,0,0.39-0.11,0.5-0.28L11,9h2.97c0.53,0,1-0.4,1.03-0.93C15.04,7.48,14.57,7,14,7h-3L8.57,2.88 C8.46,2.71,8.27,2.6,8.07,2.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 traffic
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.96 10.59c.04-.31-.19-.59-.5-.59H17V8.86c1.54-.4 2.72-1.68 2.96-3.27.04-.31-.19-.59-.5-.59H17V4c0-.55-.45-1-1-1H8c-.55 0-1 .45-1 1v1H4.54c-.31 0-.54.28-.5.59C4.28 7.18 5.46 8.46 7 8.86V10H4.54c-.31 0-.54.28-.5.59.24 1.59 1.42 2.87 2.96 3.27V15H4.54c-.31 0-.54.28-.5.59.24 1.59 1.42 2.87 2.96 3.27V20c0 .55.45 1 1 1h8c.55 0 1-.45 1-1v-1.14c1.54-.4 2.72-1.68 2.96-3.27.04-.31-.19-.59-.5-.59H17v-1.14c1.54-.4 2.72-1.68 2.96-3.27zM12 19c-1.11 0-2-.9-2-2s.89-2 2-2c1.1 0 2 .9 2 2s-.89 2-2 2zm0-5c-1.11 0-2-.9-2-2s.89-2 2-2c1.1 0 2 .9 2 2s-.89 2-2 2zm0-5c-1.11 0-2-.9-2-2 0-1.11.89-2 2-2 1.1 0 2 .89 2 2 0 1.1-.89 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crisis-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14.5,2.5c0,1.5-1.5,6-1.5,6h-2c0,0-1.5-4.5-1.5-6C9.5,1.12,10.62,0,12,0S14.5,1.12,14.5,2.5z M12,10c-1.1,0-2,0.9-2,2 s0.9,2,2,2s2-0.9,2-2S13.1,10,12,10z M16.08,5.11c0.18-0.75,0.33-1.47,0.39-2.06C19.75,4.69,22,8.08,22,12c0,5.52-4.48,10-10,10 S2,17.52,2,12c0-3.92,2.25-7.31,5.53-8.95C7.6,3.64,7.74,4.37,7.92,5.11C5.58,6.51,4,9.07,4,12c0,4.42,3.58,8,8,8s8-3.58,8-8 C20,9.07,18.42,6.51,16.08,5.11z M18,12c0,3.31-2.69,6-6,6s-6-2.69-6-6c0-2,0.98-3.77,2.48-4.86c0.23,0.81,0.65,2.07,0.65,2.07 C8.43,9.93,8,10.92,8,12c0,2.21,1.79,4,4,4s4-1.79,4-4c0-1.08-0.43-2.07-1.13-2.79c0,0,0.41-1.22,0.65-2.07C17.02,8.23,18,10,18,12 z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bakery-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18.77,8.55L17.6,8.08c-0.62-0.25-1.31,0.17-1.37,0.84l-0.74,8.08H17l2.6-6.5C19.91,9.73,19.54,8.85,18.77,8.55z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M6.4,8.08L5.23,8.55C4.46,8.85,4.09,9.73,4.4,10.5l2.6,6.5h1.5L7.76,8.92C7.7,8.25,7.02,7.83,6.4,8.08z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M13.36,6h-2.71C9.76,6,9.07,6.76,9.15,7.64L10,16.99h4l0.85-9.36C14.93,6.76,14.24,6,13.36,6z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M3.18,13.72l-1,1.93c-0.19,0.36-0.23,0.78-0.12,1.19c0.29,1.01,1.43,1.41,2.38,0.94l1.05-0.52l-1.4-3.49 C3.93,13.37,3.38,13.34,3.18,13.72z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21.82,15.65l-1-1.93c-0.2-0.38-0.75-0.35-0.91,0.04l-1.4,3.49l1.05,0.52c0.94,0.47,2.09,0.07,2.38-0.94 C22.05,16.43,22.01,16.01,21.82,15.65z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 signpost
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points
      "13,10 18,10 21,7 18,4 13,4 13,2 11,2 11,4 4,4 4,10 11,10 11,12 6,12 3,15 6,18 11,18 11,22 13,22 13,18 20,18 20,12 13,12",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 departure-board
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.34 1.13c-2.94-.55-5.63.75-7.12 2.92.01-.01.01-.02.02-.03C9.84 4 9.42 4 9 4c-4.42 0-8 .5-8 4v10c0 .88.39 1.67 1 2.22v1.28c0 .83.67 1.5 1.5 1.5S5 22.33 5 21.5V21h8v.5c0 .82.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5v-1.28c.61-.55 1-1.34 1-2.22v-3.08c3.72-.54 6.5-3.98 5.92-7.97-.42-2.9-2.7-5.29-5.58-5.82zM4.5 19c-.83 0-1.5-.67-1.5-1.5S3.67 16 4.5 16s1.5.67 1.5 1.5S5.33 19 4.5 19zM3 13V8h6c0 1.96.81 3.73 2.11 5H3zm10.5 6c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm2.5-6c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm-.25-9c-.41 0-.75.34-.75.75v3.68c0 .35.19.68.49.86l2.52 1.51c.34.2.78.09.98-.24.21-.34.1-.79-.25-.99L16.5 8.25v-3.5c0-.41-.34-.75-.75-.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 moped
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,7c0-1.1-0.9-2-2-2h-2c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2v2.65L13.52,14H10v-4c0-0.55-0.45-1-1-1H6 c-2.21,0-4,1.79-4,4v3h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,10.35V7z M7,17c-0.55,0-1-0.45-1-1h2C8,16.55,7.55,17,7,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,6H6C5.45,6,5,6.45,5,7v0c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v0C10,6.45,9.55,6,9,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,13c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,13,19,13z M19,17c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,17,19,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 u-turn-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20.29,12.29c-0.39-0.39-1.02-0.39-1.41,0L18,13.17V9c0-3.31-2.69-6-6-6S6,5.69,6,9v11c0,0.55,0.45,1,1,1s1-0.45,1-1V9 c0-2.21,1.79-4,4-4s4,1.79,4,4v4.17l-0.88-0.88c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41l2.59,2.59 c0.39,0.39,1.02,0.39,1.41,0l2.59-2.59C20.68,13.32,20.68,12.68,20.29,12.29z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 forest
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.14,12h-0.06c0.81,0,1.28-0.91,0.82-1.57L9.82,3.17c-0.4-0.57-1.24-0.57-1.64,0L3.1,10.43C2.64,11.09,3.11,12,3.92,12 H3.86l-2.87,4.46C0.56,17.12,1.04,18,1.83,18H7v2c0,1.1,0.9,2,2,2s2-0.9,2-2v-2h5.17c0.79,0,1.27-0.88,0.84-1.54L14.14,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M23.01,16.46L20.14,12h-0.06c0.81,0,1.28-0.91,0.82-1.57l-5.08-7.26c-0.4-0.57-1.24-0.57-1.64,0l-1.57,2.24l3.11,4.44 c0.43,0.61,0.48,1.41,0.14,2.07c-0.08,0.16-0.18,0.3-0.3,0.43l2.29,3.57c0.4,0.62,0.42,1.4,0.07,2.04 c-0.01,0.02-0.02,0.03-0.03,0.04h4.28C22.96,18,23.44,17.12,23.01,16.46z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M13,20c0,1.1,0.9,2,2,2s2-0.9,2-2v-1h-4V20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-walk
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM9.8 8.9L7.24 21.81c-.13.61.35 1.19.98 1.19h.08c.47 0 .87-.32.98-.78L10.9 15l2.1 2v5c0 .55.45 1 1 1s1-.45 1-1v-5.64c0-.55-.22-1.07-.62-1.45L12.9 13.5l.6-3c1.07 1.24 2.62 2.13 4.36 2.41.6.09 1.14-.39 1.14-1 0-.49-.36-.9-.85-.98-1.52-.25-2.78-1.15-3.45-2.33l-1-1.6c-.56-.89-1.68-1.25-2.65-.84L7.22 7.78C6.48 8.1 6 8.82 6 9.63V12c0 .55.45 1 1 1s1-.45 1-1V9.6l1.8-.7",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 miscellaneous-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.17,13.71l1.4-2.42c0.09-0.15,0.05-0.34-0.08-0.45l-1.48-1.16c0.03-0.22,0.05-0.45,0.05-0.68s-0.02-0.46-0.05-0.69 l1.48-1.16c0.13-0.11,0.17-0.3,0.08-0.45l-1.4-2.42c-0.09-0.15-0.27-0.21-0.43-0.15L12,4.83c-0.36-0.28-0.75-0.51-1.18-0.69 l-0.26-1.85C10.53,2.13,10.38,2,10.21,2h-2.8C7.24,2,7.09,2.13,7.06,2.3L6.8,4.15C6.38,4.33,5.98,4.56,5.62,4.84l-1.74-0.7 c-0.16-0.06-0.34,0-0.43,0.15l-1.4,2.42C1.96,6.86,2,7.05,2.13,7.16l1.48,1.16C3.58,8.54,3.56,8.77,3.56,9s0.02,0.46,0.05,0.69 l-1.48,1.16C2,10.96,1.96,11.15,2.05,11.3l1.4,2.42c0.09,0.15,0.27,0.21,0.43,0.15l1.74-0.7c0.36,0.28,0.75,0.51,1.18,0.69 l0.26,1.85C7.09,15.87,7.24,16,7.41,16h2.8c0.17,0,0.32-0.13,0.35-0.3l0.26-1.85c0.42-0.18,0.82-0.41,1.18-0.69l1.74,0.7 C13.9,13.92,14.08,13.86,14.17,13.71z M8.81,11c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2s2,0.9,2,2C10.81,10.1,9.91,11,8.81,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.92,18.67l-0.96-0.74c0.02-0.14,0.04-0.29,0.04-0.44c0-0.15-0.01-0.3-0.04-0.44l0.95-0.74 c0.08-0.07,0.11-0.19,0.05-0.29l-0.9-1.55c-0.05-0.1-0.17-0.13-0.28-0.1l-1.11,0.45c-0.23-0.18-0.48-0.33-0.76-0.44l-0.17-1.18 C18.73,13.08,18.63,13,18.53,13h-1.79c-0.11,0-0.21,0.08-0.22,0.19l-0.17,1.18c-0.27,0.12-0.53,0.26-0.76,0.44l-1.11-0.45 c-0.1-0.04-0.22,0-0.28,0.1l-0.9,1.55c-0.05,0.1-0.04,0.22,0.05,0.29l0.95,0.74c-0.02,0.14-0.03,0.29-0.03,0.44 c0,0.15,0.01,0.3,0.03,0.44l-0.95,0.74c-0.08,0.07-0.11,0.19-0.05,0.29l0.9,1.55c0.05,0.1,0.17,0.13,0.28,0.1l1.11-0.45 c0.23,0.18,0.48,0.33,0.76,0.44l0.17,1.18c0.02,0.11,0.11,0.19,0.22,0.19h1.79c0.11,0,0.21-0.08,0.22-0.19l0.17-1.18 c0.27-0.12,0.53-0.26,0.75-0.44l1.12,0.45c0.1,0.04,0.22,0,0.28-0.1l0.9-1.55C22.03,18.86,22,18.74,21.92,18.67z M17.63,18.83 c-0.74,0-1.35-0.6-1.35-1.35s0.6-1.35,1.35-1.35s1.35,0.6,1.35,1.35S18.37,18.83,17.63,18.83z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wrong-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:enable-background "new",
      :d
      "M20.42,4.5l1.38-1.38c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L19,3.08 l-1.38-1.38c-0.39-0.39-1.02-0.39-1.41,0s-0.39,1.02,0,1.41l1.38,1.38l-1.38,1.38c-0.39,0.39-0.39,1.02,0,1.41l0,0 c0.39,0.39,1.02,0.39,1.41,0L19,5.92l1.38,1.38c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L20.42,4.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:enable-background "new",
      :d
      "M19.67,8L19,7.33l-0.59,0.59c-0.7,0.7-1.84,0.88-2.65,0.3c-1.03-0.74-1.12-2.19-0.26-3.05 l0.67-0.67L15.5,3.83c-0.36-0.36-0.54-0.81-0.57-1.28C14.01,2.19,13.02,2,12,2c-4.2,0-8,3.22-8,8.2c0,3.18,2.45,6.92,7.34,11.23 c0.38,0.33,0.95,0.33,1.33,0C17.55,17.12,20,13.38,20,10.2c0-0.76-0.1-1.47-0.26-2.14C19.72,8.04,19.69,8.02,19.67,8z M12,12 c-1.1,0-2-0.9-2-2s0.9-2,2-2c1.1,0,2,0.9,2,2S13.1,12,12,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,18v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2h-2c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2v2c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1v-2h2c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,4L19,4c-0.55,0-1,0.45-1,1v7c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V5C20,4.45,19.55,4,19,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,20L5,20c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1h0C4.45,4,4,4.45,4,5v14C4,19.55,4.45,20,5,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,8L12,8c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C11,7.55,11.45,8,12,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,14L12,14c0.55,0,1-0.45,1-1v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C11,13.55,11.45,14,12,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,20L12,20c0.55,0,1-0.45,1-1v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C11,19.55,11.45,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 not-listed-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12 2c-4.2 0-8 3.22-8 8.2 0 3.18 2.45 6.92 7.34 11.22.38.33.95.33 1.33 0C17.55 17.12 20 13.38 20 10.2 20 5.22 16.2 2 12 2zm.01 14c-.59 0-1.05-.47-1.05-1.05 0-.59.47-1.04 1.05-1.04.59 0 1.04.45 1.04 1.04 0 .58-.44 1.05-1.04 1.05zm2.51-6.17c-.63.93-1.23 1.21-1.56 1.81-.08.14-.13.26-.16.49-.05.39-.36.68-.75.68h-.03c-.44 0-.79-.38-.75-.82.03-.27.09-.57.25-.84.41-.73 1.18-1.16 1.63-1.8.48-.68.21-1.94-1.14-1.94-.61 0-1.01.32-1.26.7-.19.29-.57.39-.89.25-.42-.18-.6-.7-.34-1.07C10.03 6.55 10.88 6 12 6c1.23 0 2.08.56 2.51 1.26.36.61.58 1.73.01 2.57z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 attractions
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10.44,18.75c0.37-0.46,0.94-0.75,1.57-0.75s1.19,0.29,1.56,0.75c0.39-0.09,0.76-0.21,1.12-0.36l-1.42-3.18 c-0.39,0.15-0.82,0.23-1.26,0.23c-0.46,0-0.9-0.09-1.3-0.25l-1.43,3.19C9.65,18.54,10.03,18.67,10.44,18.75z M5.16,10 C5,10.59,4.91,11.21,4.91,11.85c0,0.75,0.12,1.47,0.33,2.15c0.63,0.05,1.22,0.4,1.56,0.99c0.33,0.57,0.35,1.23,0.11,1.79 c0.27,0.27,0.56,0.53,0.87,0.76l1.52-3.39l0,0c-0.47-0.58-0.75-1.32-0.75-2.13c0-1.89,1.55-3.41,3.46-3.41s3.46,1.53,3.46,3.41 c0,0.82-0.29,1.57-0.78,2.16l1.5,3.35c0.32-0.24,0.62-0.5,0.9-0.79c-0.22-0.55-0.2-1.2,0.12-1.75c0.33-0.57,0.9-0.92,1.52-0.99 c0.22-0.68,0.34-1.41,0.34-2.16c0-0.64-0.09-1.27-0.25-1.86c-0.64-0.04-1.26-0.39-1.6-1c-0.36-0.62-0.35-1.36-0.03-1.95 c-0.91-0.98-2.1-1.71-3.44-2.05C13.4,5.6,12.74,6,12.01,6s-1.39-0.41-1.74-1.01C8.93,5.33,7.74,6.04,6.83,7.02 C7.16,7.62,7.18,8.37,6.81,9C6.45,9.62,5.82,9.97,5.16,10z M3.86,9.58C3.08,8.98,2.84,7.88,3.35,7s1.58-1.23,2.49-0.85 c1.11-1.17,2.56-2.03,4.18-2.42C10.15,2.75,10.99,2,12.01,2s1.85,0.75,1.98,1.73c1.63,0.39,3.07,1.24,4.18,2.42 c0.91-0.38,1.99-0.03,2.49,0.85c0.51,0.88,0.27,1.98-0.51,2.58c0.23,0.77,0.35,1.58,0.35,2.42s-0.12,1.65-0.35,2.42 c0.78,0.6,1.02,1.7,0.51,2.58s-1.58,1.23-2.49,0.85c-0.4,0.43-0.85,0.81-1.34,1.15l0.81,1.8c0.25,0.56-0.16,1.2-0.78,1.2h0 c-0.33,0-0.64-0.2-0.78-0.5l-0.75-1.67c-0.43,0.18-0.88,0.33-1.34,0.44C13.86,21.25,13.02,22,12.01,22s-1.85-0.75-1.98-1.73 C9.55,20.15,9.09,20,8.65,19.81L7.89,21.5C7.75,21.8,7.45,22,7.11,22H7.1c-0.62,0-1.03-0.64-0.77-1.2l0.82-1.83 c-0.47-0.33-0.91-0.71-1.3-1.12c-0.92,0.38-1.99,0.03-2.5-0.85s-0.27-1.98,0.51-2.58C3.62,13.65,3.51,12.84,3.51,12 S3.62,10.35,3.86,9.58z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 brunch-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,8h2V4h-2V8z M15,22H3c-0.55,0-1-0.45-1-1v-1h14v1C16,21.55,15.55,22,15,22z M18,15.89l-0.4-0.42 c-1.03-1.08-1.6-2.51-1.6-4V3c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1v8.51c0,1.46-0.54,2.87-1.53,3.94L20,15.97V20h1 c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1h-2c-0.55,0-1-0.45-1-1V15.89z M7,16v-1c0-0.55,0.45-1,1-1h2c0.55,0,1,0.45,1,1v1h4 c0.55,0,1,0.45,1,1v1H2v-1c0-0.55,0.45-1,1-1H7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 handyman
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21.67,18.17l-4.72-4.72c-0.48-0.48-0.99-0.59-1.58-0.59l-2.54,2.54c0,0.59,0.11,1.11,0.59,1.58l4.72,4.72 c0.39,0.39,1.02,0.39,1.41,0l2.12-2.12C22.06,19.2,22.06,18.56,21.67,18.17z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16.63,9.49c0.39,0.39,1.02,0.39,1.41,0l0.71-0.71l2.12,2.12c1.17-1.17,1.17-3.07,0-4.24l-2.83-2.83 c-0.39-0.39-1.02-0.39-1.41,0l-0.71,0.71V2c0-0.62-0.76-0.95-1.21-0.5l-2.54,2.54c-0.45,0.45-0.12,1.21,0.5,1.21h2.54l-0.71,0.71 c-0.39,0.39-0.39,1.02,0,1.41l0.35,0.35l-2.89,2.89L7.85,6.48v-1c0-0.27-0.11-0.52-0.29-0.71L5.54,2.74 c-0.39-0.39-1.02-0.39-1.41,0L2.71,4.16c-0.39,0.39-0.39,1.02,0,1.41L4.73,7.6c0.19,0.19,0.44,0.29,0.71,0.29h1l4.13,4.13 l-0.85,0.85H8.42c-0.53,0-1.04,0.21-1.41,0.59l-4.72,4.72c-0.39,0.39-0.39,1.02,0,1.41l2.12,2.12c0.39,0.39,1.02,0.39,1.41,0 l4.72-4.72c0.38-0.38,0.59-0.88,0.59-1.41v-1.29l5.15-5.15L16.63,9.49z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 two-wheeler
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0",
     :x "0",
     :width "24",
     :height "24",
     :fill-rule "evenodd",
     :fill "none",
     :stroke nil})
   (helix.dom/path
    {:d
     "M20,11c-0.18,0-0.36,0.03-0.53,0.05L17.41,9H19c0.55,0,1-0.45,1-1V7.62c0-0.74-0.78-1.23-1.45-0.89l-2.28,1.14l-2.57-2.57 C13.52,5.11,13.26,5,13,5h-3C9.45,5,9,5.45,9,6v0c0,0.55,0.45,1,1,1h2.17c0.27,0,0.52,0.11,0.71,0.29L14.59,9h-3.35 c-0.16,0-0.31,0.04-0.45,0.11l-3.14,1.57c-0.38,0.19-0.85,0.12-1.15-0.19l-1.2-1.2C5.11,9.11,4.85,9,4.59,9H1c-0.55,0-1,0.45-1,1v0 c0,0.55,0.45,1,1,1h3c-2.52,0-4.49,2.32-3.89,4.94c0.33,1.45,1.5,2.62,2.95,2.95C5.68,19.49,8,17.52,8,15l1.41,1.41 C9.79,16.79,10.3,17,10.83,17h1.01c0.72,0,1.38-0.38,1.74-1.01l2.91-5.09l1.01,1.01c-1.13,0.91-1.76,2.41-1.38,4.05 c0.34,1.44,1.51,2.61,2.95,2.94C21.68,19.49,24,17.51,24,15C24,12.79,22.21,11,20,11z M4,17c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2 c1.1,0,2,0.9,2,2C6,16.1,5.1,17,4,17z M20,17c-1.1,0-2-0.9-2-2c0-1.1,0.9-2,2-2s2,0.9,2,2C22,16.1,21.1,17,20,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M13,7c0-0.55-0.44-1-1-1c-0.55,0-1,0.44-1,1v2H9c-0.55,0-1,0.44-1,1c0,0.55,0.44,1,1,1h2v2 c0,0.55,0.44,1,1,1c0.55,0,1-0.44,1-1v-2h2c0.55,0,1-0.44,1-1c0-0.55-0.44-1-1-1h-2V7z M12,2c4.2,0,8,3.22,8,8.2 c0,3.18-2.45,6.92-7.34,11.23c-0.38,0.33-0.95,0.33-1.33,0C6.45,17.12,4,13.38,4,10.2C4,5.22,7.8,2,12,2z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 electric-scooter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M7.82,16H15v-1c0-2.21,1.79-4,4-4h0.74l-1.9-8.44C17.63,1.65,16.82,1,15.89,1H13c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1 h2.89l1.4,6.25c0,0-0.01,0-0.01,0c-2.16,0.65-3.81,2.48-4.19,4.75H7.82c-0.48-1.34-1.86-2.24-3.42-1.94 c-1.18,0.23-2.13,1.2-2.35,2.38C1.7,16.34,3.16,18,5,18C6.3,18,7.4,17.16,7.82,16z M5,16c-0.55,0-1-0.45-1-1s0.45-1,1-1 s1,0.45,1,1S5.55,16,5,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,12c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,12,19,12z M19,16c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,16,19,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,20 7,20 13,23 13,21 17,21 11,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-sharp-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,6.83l0.88,0.88c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41L7.71,3.71c-0.39-0.39-1.02-0.39-1.41,0 L3.71,6.29c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0L6,6.83V13c0,1.1,0.9,2,2,2h8v5c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1v-5c0-1.1-0.9-2-2-2H8V6.83L8,6.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-printshop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M18,7V4c0-0.55-0.45-1-1-1H7C6.45,3,6,3.45,6,4v3H18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,8H5c-1.66,0-3,1.34-3,3v5c0,0.55,0.45,1,1,1h3v2c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2v-2h3c0.55,0,1-0.45,1-1v-5 C22,9.34,20.66,8,19,8z M16,19H8v-4h8V19z M18,12.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S18.55,12.5,18,12.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 restaurant
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 6v6c0 1.1.9 2 2 2h1v7c0 .55.45 1 1 1s1-.45 1-1V3.13c0-.65-.61-1.13-1.24-.98C17.6 2.68 16 4.51 16 6zm-5 3H9V3c0-.55-.45-1-1-1s-1 .45-1 1v6H5V3c0-.55-.45-1-1-1s-1 .45-1 1v6c0 2.21 1.79 4 4 4v8c0 .55.45 1 1 1s1-.45 1-1v-8c2.21 0 4-1.79 4-4V3c0-.55-.45-1-1-1s-1 .45-1 1v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cleaning-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,11h-1V4c0-1.66-1.34-3-3-3h0c-1.66,0-3,1.34-3,3v7H8c-2.76,0-5,2.24-5,5v5c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-5 C21,13.24,18.76,11,16,11z M19,21h-2v-3c0-0.55-0.45-1-1-1s-1,0.45-1,1v3h-2v-3c0-0.55-0.45-1-1-1s-1,0.45-1,1v3H9v-3 c0-0.55-0.45-1-1-1s-1,0.45-1,1v3H5v-5c0-1.65,1.35-3,3-3h8c1.65,0,3,1.35,3,3V21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tire-repair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,7c0,0.55,0.45,1,1,1c0.28,0,0.53-0.11,0.71-0.29c0.4-0.4,1.04-2.46,1.04-2.46s-2.06,0.64-2.46,1.04 C18.11,6.47,18,6.72,18,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,2c-2.76,0-5,2.24-5,5c0,2.05,1.23,3.81,3,4.58V12c0,0.55,0.45,1,1,1v5c0,0.55-0.45,1-1,1s-1-0.45-1-1v-3 c0-1.65-1.35-3-3-3c-0.35,0-0.69,0.06-1,0.17V5c0-1.1-0.9-2-2-2H4C2.9,3,2,3.9,2,5v14c0,1.1,0.9,2,2,2h6c1.1,0,2-0.9,2-2v-4 c0-0.55,0.45-1,1-1s1,0.45,1,1v3c0,1.65,1.35,3,3,3s3-1.35,3-3v-5c0.55,0,1-0.45,1-1v-0.42c1.77-0.77,3-2.53,3-4.58 C24,4.24,21.76,2,19,2z M6,19.5l-2-2v-2.83l2,2V19.5z M6,14.5l-2-2V9.67l2,2V14.5z M6,9.5l-2-2V4.67l2,2V9.5z M10,17.5l-2,2v-2.83 l2-2V17.5z M10,12.5l-2,2v-2.83l2-2V12.5z M10,7.5l-2,2V6.67l2-2V7.5z M19,10c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3 S20.66,10,19,10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 fastfood
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21.9 5H18V2c0-.55-.45-1-1-1s-1 .45-1 1v3h-3.9c-.59 0-1.05.51-1 1.1l.12 1.21C14.9 8.16 18 10.77 18 15l.02 8h1.7c.84 0 1.53-.65 1.63-1.47L22.89 6.1c.06-.59-.4-1.1-.99-1.1zM15 21H2c-.55 0-1 .45-1 1s.45 1 1 1h13c.55 0 1-.45 1-1s-.45-1-1-1zM2.1 15h12.8c.62 0 1.11-.56.99-1.16-.65-3.23-4.02-4.85-7.39-4.85s-6.73 1.62-7.39 4.85c-.12.6.38 1.16.99 1.16zM15 17H2c-.55 0-1 .45-1 1s.45 1 1 1h13c.55 0 1-.45 1-1s-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-laundry-service
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9.64,16.36c1.3,1.3,3.42,1.3,4.72,0c1.3-1.3,1.3-3.42,0-4.72L9.64,16.36z M18,2.01L6,2C4.89,2,4,2.89,4,4v16 c0,1.11,0.89,2,2,2h12c1.11,0,2-0.89,2-2V4C20,2.89,19.11,2.01,18,2.01z M11,5c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1 S10.45,5,11,5z M8,5c0.55,0,1,0.45,1,1S8.55,7,8,7S7,6.55,7,6S7.45,5,8,5z M12,19c-2.76,0-5-2.24-5-5c0-2.76,2.24-5,5-5s5,2.24,5,5 C17,16.76,14.76,19,12,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 medical-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,6h-4V4c0-1.1-0.9-2-2-2h-4C8.9,2,8,2.9,8,4v2H4C2.9,6,2,6.9,2,8v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M10,4h4v2h-4V4z M15,15h-2v2c0,0.55-0.45,1-1,1s-1-0.45-1-1v-2H9c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h2v-2 c0-0.55,0.45-1,1-1s1,0.45,1,1v2h2c0.55,0,1,0.45,1,1C16,14.55,15.55,15,15,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "m21.71 11.29-9-9a.996.996 0 00-1.41 0l-9 9a.996.996 0 000 1.41l9 9c.39.39 1.02.39 1.41 0l9-9a.996.996 0 000-1.41zM14 14.5V12h-4v2c0 .55-.45 1-1 1s-1-.45-1-1v-3c0-.55.45-1 1-1h5V7.5l3.15 3.15c.2.2.2.51 0 .71L14 14.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-car-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.92,6.01C18.72,5.42,18.16,5,17.5,5h-11C5.84,5,5.29,5.42,5.08,6.01L3,12v7.5C3,20.33,3.67,21,4.5,21h0 C5.33,21,6,20.33,6,19.5V19h12v0.5c0,0.82,0.67,1.5,1.5,1.5h0c0.82,0,1.5-0.67,1.5-1.5V12L18.92,6.01z M7.5,16 C6.67,16,6,15.33,6,14.5S6.67,13,7.5,13S9,13.67,9,14.5S8.33,16,7.5,16z M16.5,16c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5 s1.5,0.67,1.5,1.5S17.33,16,16.5,16z M5.81,10l1.04-3h10.29l1.04,3H5.81z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 edit-location
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2c-4.2,0-8,3.22-8,8.2c0,3.18,2.45,6.92,7.34,11.23c0.38,0.33,0.95,0.33,1.33,0C17.55,17.12,20,13.38,20,10.2 C20,5.22,16.2,2,12,2z M9.73,13.5H8.5v-1.44l3.93-3.92l1.43,1.43l-3.77,3.78C9.99,13.45,9.87,13.5,9.73,13.5z M15.28,8.16l-0.7,0.7 l-1.44-1.44l0.7-0.7c0.15-0.15,0.39-0.15,0.54,0l0.9,0.9C15.43,7.77,15.43,8.01,15.28,8.16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roundabout-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,21c-0.55,0-1-0.45-1-1l0-5.09c0-0.98,0.71-1.8,1.67-1.97C18.56,12.63,20,10.98,20,9c0-2.21-1.79-4-4-4 c-1.98,0-3.63,1.44-3.94,3.33C11.89,9.29,11.07,10,10.09,10l-4.26,0l0.88,0.88c0.39,0.39,0.39,1.02,0,1.41 c-0.39,0.39-1.02,0.39-1.41,0L2.71,9.71c-0.39-0.39-0.39-1.02,0-1.41l2.59-2.59c0.39-0.39,1.02-0.39,1.41,0 c0.39,0.39,0.39,1.02,0,1.41L5.83,8l4.25,0c0.48-2.84,2.94-5,5.92-5c3.31,0,6,2.69,6,6c0,2.97-2.16,5.44-5,5.92L17,20 C17,20.55,16.55,21,16,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-shipping
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.5 8H17V6c0-1.1-.9-2-2-2H3c-1.1 0-2 .9-2 2v9c0 1.1.9 2 2 2 0 1.66 1.34 3 3 3s3-1.34 3-3h6c0 1.66 1.34 3 3 3s3-1.34 3-3h1c.55 0 1-.45 1-1v-3.33c0-.43-.14-.85-.4-1.2L20.3 8.4c-.19-.25-.49-.4-.8-.4zM6 18c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm13.5-8.5l1.96 2.5H17V9.5h2.5zM18 18c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-railway-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:enable-background "new",
     :d
     "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19l-1.21,0.81C6.11,19.93,6,20.13,6,20.35v0 C6,20.71,6.29,21,6.65,21h10.7c0.36,0,0.65-0.29,0.65-0.65v0c0-0.22-0.11-0.42-0.29-0.54L16.5,19c1.93,0,3.5-1.57,3.5-3.5V6 C20,2.5,16.42,2,12,2z M12,16c-0.83,0-1.5-0.67-1.5-1.5S11.17,13,12,13s1.5,0.67,1.5,1.5S12.83,16,12,16z M18,10H6V7h12V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 egg
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,3C8.5,3,5,9.33,5,14c0,3.87,3.13,7,7,7s7-3.13,7-7C19,9.33,15.5,3,12,3z M13,18c-3,0-5-1.99-5-5c0-0.55,0.45-1,1-1 s1,0.45,1,1c0,2.92,2.42,3,3,3c0.55,0,1,0.45,1,1S13.55,18,13,18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.29,13.29c0.39,0.39,1.02,0.39,1.41,0l2.59-2.59c0.39-0.39,0.39-1.02,0-1.41l-2.59-2.59c-0.39-0.39-1.02-0.39-1.41,0 c-0.39,0.39-0.39,1.02,0,1.41L17.17,9L9,9c-1.1,0-2,0.9-2,2v8c0,0.55,0.45,1,1,1s1-0.45,1-1v-8l8.17,0l-0.88,0.88 C15.9,12.27,15.9,12.9,16.29,13.29z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 remove-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,4L19,4c-0.55,0-1,0.45-1,1v7c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V5C20,4.45,19.55,4,19,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,20L5,20c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1h0C4.45,4,4,4.45,4,5v14C4,19.55,4.45,20,5,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,8L12,8c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C11,7.55,11.45,8,12,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,14L12,14c0.55,0,1-0.45,1-1v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C11,13.55,11.45,14,12,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,20L12,20c0.55,0,1-0.45,1-1v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C11,19.55,11.45,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.79,15.71L21.79,15.71c-0.39-0.39-1.02-0.39-1.41,0L19,17.09l-1.38-1.38c-0.39-0.39-1.02-0.39-1.41,0v0 c-0.39,0.39-0.39,1.02,0,1.41l1.38,1.38l-1.38,1.38c-0.39,0.39-0.39,1.02,0,1.41l0,0c0.39,0.39,1.02,0.39,1.41,0L19,19.91 l1.38,1.38c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41l-1.38-1.38l1.38-1.38C22.18,16.73,22.18,16.1,21.79,15.71z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-business
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,6h13c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1H3C2.45,4,2,4.45,2,5C2,5.55,2.45,6,3,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,17h2v-3h0.18c0.63,0,1.1-0.58,0.98-1.2l-1-5C17.07,7.34,16.66,7,16.18,7H2.82C2.34,7,1.93,7.34,1.84,7.8l-1,5 C0.72,13.42,1.19,14,1.82,14H2v5c0,0.55,0.45,1,1,1h7c0.55,0,1-0.45,1-1v-5h4V17z M9,18H4v-4h5V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,18h-2v-2c0-0.55-0.45-1-1-1s-1,0.45-1,1v2h-2c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h2v2c0,0.55,0.45,1,1,1s1-0.45,1-1 v-2h2c0.55,0,1-0.45,1-1C23,18.45,22.55,18,22,18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-bike
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,7h-0.82l-1.7-4.68C16.19,1.53,15.44,1,14.6,1H13c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h1.6l1.46,4h-4.81l-0.36-1h0.09 c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1H8C7.45,4,7,4.45,7,5c0,0.55,0.45,1,1,1h0.75l1.82,5H9.9C9.46,8.77,7.59,7.12,5.25,7.01 C2.45,6.87,0,9.2,0,12c0,2.8,2.2,5,5,5c2.46,0,4.45-1.69,4.9-4h4.2c0.44,2.23,2.31,3.88,4.65,3.99c2.8,0.13,5.25-2.19,5.25-5 C24,9.2,21.8,7,19,7z M6,13h1.82c-0.42,1.23-1.6,2.08-3.02,1.99C3.31,14.9,2.07,13.64,2,12.14C1.93,10.39,3.27,9,5,9 c1.33,0,2.42,0.83,2.82,2H6c-0.55,0-1,0.45-1,1C5,12.55,5.45,13,6,13z M14.1,11h-1.4l-0.73-2H15C14.56,9.58,14.24,10.25,14.1,11z M18.88,15c-1.54-0.06-2.84-1.37-2.88-2.92c-0.02-0.96,0.39-1.8,1.05-2.36l0.62,1.7c0.19,0.52,0.76,0.79,1.28,0.6 c0.52-0.19,0.79-0.76,0.6-1.28l-0.63-1.73c0,0,0,0,0.01-0.01C20.64,8.96,22,10.29,22,12C22,13.72,20.62,15.06,18.88,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "11,20 7,20 13,23 13,21 17,21 11,18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hardware
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M17.59,3.41L15,6V5c0-1.1-0.9-2-2-2H9C6.24,3,4,5.24,4,8h5v3h6V8l2.59,2.59c0.26,0.26,0.62,0.41,1,0.41h0.01 C19.37,11,20,10.37,20,9.59V4.41C20,3.63,19.37,3,18.59,3h-0.01C18.21,3,17.85,3.15,17.59,3.41z",
        :stroke nil,
        :fill nil}))
     (helix.dom/g
      nil
      (helix.dom/path
       {:d "M9,13v7c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-7H9z",
        :stroke nil,
        :fill nil})))))))


(helix.core/defnc
 car-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18,7c-0.28,0-0.5-0.22-0.5-0.5v-3C17.5,3.22,17.72,3,18,3 s0.5,0.22,0.5,0.5v3C18.5,6.78,18.28,7,18,7z M18.5,8.5C18.5,8.78,18.28,9,18,9s-0.5-0.22-0.5-0.5S17.72,8,18,8 S18.5,8.22,18.5,8.5z M19.5,20c0.82,0,1.5-0.67,1.5-1.5v-6.18c-1.05,0.51-2.16,0.69-3.09,0.68c0.06,0.16,0.09,0.33,0.09,0.5 c0,0.83-0.67,1.5-1.5,1.5S15,14.33,15,13.5c0-0.39,0.15-0.74,0.39-1.01c-1.63-0.66-2.96-1.91-3.71-3.49H5.81l1.04-3H11 c0-0.69,0.1-1.37,0.29-2H6.5C5.84,4,5.29,4.42,5.08,5.01l-1.97,5.67C3.04,10.89,3,11.11,3,11.34v7.16C3,19.33,3.67,20,4.5,20 S6,19.33,6,18.5V18h12v0.5C18,19.33,18.68,20,19.5,20z M7.5,15C6.67,15,6,14.33,6,13.5S6.67,12,7.5,12S9,12.67,9,13.5 S8.33,15,7.5,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 transfer-within-a-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 15.5h-5.52v-.77c0-.36-.44-.54-.69-.29l-1.51 1.52c-.16.16-.16.41 0 .57l1.51 1.52c.26.26.69.08.69-.29V17H22v-1.5zm-.28 4.71l-1.51-1.52c-.26-.26-.69-.08-.69.29v.77H14v1.5h5.52v.77c0 .36.44.54.69.29l1.51-1.52c.16-.16.16-.42 0-.58zM9.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM5.75 8.9L3.23 21.81c-.12.62.35 1.19.98 1.19h.09c.47 0 .88-.33.98-.79L6.85 15 9 17v5c0 .55.45 1 1 1s1-.45 1-1v-5.72c0-.53-.21-1.04-.59-1.41L8.95 13.4l.6-3c1.07 1.32 2.58 2.23 4.31 2.51.6.1 1.14-.39 1.14-1 0-.49-.36-.9-.84-.98-1.49-.25-2.75-1.15-3.51-2.38l-.95-1.6C9.35 6.35 8.7 6 8 6c-.25 0-.5.05-.75.15L3.24 7.79C2.49 8.1 2 8.83 2 9.64V12c0 .55.45 1 1 1s1-.45 1-1V9.65l1.75-.75",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-grocery-store
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 18c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zM2 4h1l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h11c.55 0 1-.45 1-1s-.45-1-1-1H7l1.1-2h7.45c.75 0 1.41-.41 1.75-1.03l3.58-6.49c.37-.66-.11-1.48-.87-1.48H5.21l-.67-1.43c-.16-.35-.52-.57-.9-.57H2c-.55 0-1 .45-1 1s.45 1 1 1zm15 14c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-transfer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M5.78,2.95C7.24,2.16,9.48,2,12,2c4.42,0,8,0.5,8,4v10c0,0.35-0.08,0.67-0.19,0.98L13.83,11H18V6H8.83L5.78,2.95z M20.49,21.9c-0.39,0.39-1.02,0.39-1.41,0l-1.01-1.01C17.89,20.96,17.7,21,17.5,21c-0.83,0-1.5-0.68-1.5-1.5V19H8v0.5 C8,20.33,7.33,21,6.5,21S5,20.33,5,19.5v-1.28C4.39,17.67,4,16.88,4,16V6.83l-1.9-1.9c-0.39-0.39-0.39-1.02,0-1.41 c0.39-0.39,1.02-0.39,1.41,0l16.97,16.97C20.88,20.88,20.88,21.51,20.49,21.9z M9,15.5C9,14.67,8.33,14,7.5,14S6,14.67,6,15.5 C6,16.33,6.67,17,7.5,17S9,16.33,9,15.5z M8.17,11L6,8.83V11H8.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-activity
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 12c0-.76.43-1.42 1.06-1.76.6-.33.94-1.01.94-1.7V6c0-1.1-.9-2-2-2H4c-1.1 0-1.99.89-1.99 1.99v2.55c0 .69.33 1.37.94 1.69C3.58 10.58 4 11.24 4 12s-.43 1.43-1.06 1.76c-.6.33-.94 1.01-.94 1.7V18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-2.54c0-.69-.34-1.37-.94-1.7-.63-.34-1.06-1-1.06-1.76zm-5.5 4.1L12 14.5l-2.5 1.61c-.38.24-.87-.11-.75-.55l.75-2.88-2.3-1.88c-.35-.29-.17-.86.29-.89l2.96-.17 1.08-2.75c.17-.42.77-.42.93 0l1.08 2.76 2.96.17c.45.03.64.6.29.89l-2.3 1.88.76 2.86c.12.45-.37.8-.75.55z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flight-class
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M16,4h-2c-1.1,0-2,0.9-2,2v5c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2V6C18,4.9,17.1,4,16,4z M6,4c0.55,0,1,0.45,1,1v3l2.5,8H17 c0.55,0,1,0.45,1,1s-0.45,1-1,1H9.49c-0.88,0-1.66-0.58-1.92-1.43L5.08,8.28C5.03,8.09,5,7.9,5,7.71V5C5,4.45,5.45,4,6,4z M18,20 c0,0.55-0.45,1-1,1H9c-0.55,0-1-0.45-1-1s0.45-1,1-1h8C17.55,19,18,19.45,18,20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-phone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.23 15.26l-2.54-.29c-.61-.07-1.21.14-1.64.57l-1.84 1.84c-2.83-1.44-5.15-3.75-6.59-6.59l1.85-1.85c.43-.43.64-1.03.57-1.64l-.29-2.52c-.12-1.01-.97-1.77-1.99-1.77H5.03c-1.13 0-2.07.94-2 2.07.53 8.54 7.36 15.36 15.89 15.89 1.13.07 2.07-.87 2.07-2v-1.73c.01-1.01-.75-1.86-1.76-1.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 design-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.24,11.51l1.57-1.57l-3.75-3.75l-1.57,1.57L8.35,3.63c-0.78-0.78-2.05-0.78-2.83,0l-1.9,1.9 c-0.78,0.78-0.78,2.05,0,2.83l4.13,4.13L3.15,17.1C3.05,17.2,3,17.32,3,17.46v3.04C3,20.78,3.22,21,3.5,21h3.04 c0.13,0,0.26-0.05,0.35-0.15l4.62-4.62l4.13,4.13c1.32,1.32,2.76,0.07,2.83,0l1.9-1.9c0.78-0.78,0.78-2.05,0-2.83L16.24,11.51z M9.18,11.07L5.04,6.94l1.89-1.9c0,0,0,0,0,0l1.27,1.27L7.73,6.8c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0 l0.48-0.48l1.45,1.45L9.18,11.07z M17.06,18.96l-4.13-4.13l1.9-1.9l1.45,1.45l-0.48,0.48c-0.39,0.39-0.39,1.02,0,1.41 c0.39,0.39,1.02,0.39,1.41,0l0.48-0.48l1.27,1.27L17.06,18.96z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.71,7.04c0.39-0.39,0.39-1.02,0-1.41l-2.34-2.34c-0.47-0.47-1.12-0.29-1.41,0l-1.83,1.83l3.75,3.75L20.71,7.04z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 layers
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.6 18.06c-.36.28-.87.28-1.23 0l-6.15-4.78c-.36-.28-.86-.28-1.22 0-.51.4-.51 1.17 0 1.57l6.76 5.26c.72.56 1.73.56 2.46 0l6.76-5.26c.51-.4.51-1.17 0-1.57l-.01-.01c-.36-.28-.86-.28-1.22 0l-6.15 4.79zm.63-3.02l6.76-5.26c.51-.4.51-1.18 0-1.58l-6.76-5.26c-.72-.56-1.73-.56-2.46 0L4.01 8.21c-.51.4-.51 1.18 0 1.58l6.76 5.26c.72.56 1.74.56 2.46-.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wine-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7,3C6.45,3,6,3.45,6,4l0,5c0,2.97,2.16,5.43,5,5.91V19H9c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h6c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1h-2v-4.09c2.84-0.48,5-2.94,5-5.91l0-5c0-0.55-0.45-1-1-1H7z M16,8H8l0-3h8C16,5,16,8,16,8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.5,24c0.82,0,1.5-0.67,1.5-1.5v-7.16c0-0.22-0.04-0.45-0.11-0.66l-1.97-5.67C18.72,8.42,18.16,8,17.5,8h-11 C5.84,8,5.29,8.42,5.08,9.01l-1.97,5.67C3.04,14.89,3,15.11,3,15.34v7.16C3,23.33,3.68,24,4.5,24S6,23.33,6,22.5V22h12v0.5 C18,23.33,18.67,24,19.5,24z M6.85,10h10.29l1.04,3H5.81L6.85,10z M6,17.5C6,16.67,6.67,16,7.5,16S9,16.67,9,17.5S8.33,19,7.5,19 S6,18.33,6,17.5z M15,17.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,19,16.5,19S15,18.33,15,17.5z M16.24,0.71 c0.39,0.39,0.39,1.02,0,1.41l-3.54,3.54c-0.39,0.39-1.02,0.39-1.41,0L9.88,4.24c-0.39-0.39-0.39-1.02,0-1.41l0,0 c0.39-0.39,1.02-0.39,1.41,0L12,3.54l2.83-2.83C15.22,0.32,15.85,0.32,16.24,0.71z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 route
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,15.18V7c0-2.21-1.79-4-4-4s-4,1.79-4,4v10c0,1.1-0.9,2-2,2s-2-0.9-2-2V8.82C8.16,8.4,9,7.3,9,6c0-1.66-1.34-3-3-3 S3,4.34,3,6c0,1.3,0.84,2.4,2,2.82V17c0,2.21,1.79,4,4,4s4-1.79,4-4V7c0-1.1,0.9-2,2-2s2,0.9,2,2v8.18c-1.16,0.41-2,1.51-2,2.82 c0,1.66,1.34,3,3,3s3-1.34,3-3C21,16.7,20.16,15.6,19,15.18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-boat-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,21c-1.19,0-2.38-0.35-3.47-0.98c-0.33-0.19-0.73-0.19-1.07,0c-2.17,1.26-4.76,1.26-6.93,0 c-0.33-0.19-0.73-0.19-1.07,0C6.38,20.65,5.19,21,4,21H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1c1.38,0,2.74-0.35,4-0.99 c2.52,1.29,5.48,1.29,8,0c1.26,0.65,2.62,0.99,4,0.99h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H20z M3.95,19H4 c1.27,0,2.42-0.55,3.33-1.33c0.39-0.34,0.95-0.34,1.34,0C9.58,18.45,10.73,19,12,19s2.42-0.55,3.33-1.33 c0.39-0.34,0.95-0.34,1.34,0C17.58,18.45,18.73,19,20,19h0.05l1.9-6.68c0.11-0.37,0.04-1.06-0.66-1.28L20,10.62V6c0-1.1-0.9-2-2-2 h-3V2c0-0.55-0.45-1-1-1h-4C9.45,1,9,1.45,9,2v2H6C4.9,4,4,4.9,4,6v4.62l-1.29,0.42c-0.63,0.19-0.81,0.84-0.66,1.28L3.95,19z M6,6 h12v3.97L12.62,8.2c-0.41-0.13-0.84-0.13-1.25,0L6,9.97V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 category
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.15 3.4L7.43 9.48c-.41.66.07 1.52.85 1.52h7.43c.78 0 1.26-.86.85-1.52L12.85 3.4c-.39-.64-1.31-.64-1.7 0z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "4.5", :cy "17.5", :cx "17.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M4 21.5h6c.55 0 1-.45 1-1v-6c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 store-mall-directory
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.16 7.8c-.09-.46-.5-.8-.98-.8H4.82c-.48 0-.89.34-.98.8L3 12v1c0 .55.45 1 1 1v5c0 .55.45 1 1 1h8c.55 0 1-.45 1-1v-5h4v5c0 .55.45 1 1 1s1-.45 1-1v-5c.55 0 1-.45 1-1v-1l-.84-4.2zM12 18H6v-4h6v4zM5 6h14c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fork-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M15,20c0,0.55-0.45,1-1,1c-0.55,0-1-0.45-1-1v-3c-0.73-2.58-3.07-3.47-5.17-3l0.88,0.88c0.39,0.39,0.39,1.02,0,1.41 c-0.39,0.39-1.02,0.39-1.41,0l-2.59-2.59c-0.39-0.39-0.39-1.02,0-1.41l2.59-2.59c0.39-0.39,1.02-0.39,1.41,0 c0.39,0.39,0.39,1.02,0,1.41L7.83,12c1.51-0.33,3.73,0.08,5.17,1.36l0-6.53l-0.88,0.88c-0.39,0.39-1.02,0.39-1.41,0 c-0.39-0.39-0.39-1.02,0-1.41l2.59-2.59c0.39-0.39,1.02-0.39,1.41,0l2.59,2.59c0.39,0.39,0.39,1.02,0,1.41 c-0.39,0.39-1.02,0.39-1.41,0L15,6.83V20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 turn-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.71,13.29c-0.39,0.39-1.02,0.39-1.41,0l-2.59-2.59c-0.39-0.39-0.39-1.02,0-1.41l2.59-2.59c0.39-0.39,1.02-0.39,1.41,0 c0.39,0.39,0.39,1.02,0,1.41L6.83,9L15,9c1.1,0,2,0.9,2,2v8c0,0.55-0.45,1-1,1c-0.55,0-1-0.45-1-1v-8l-8.17,0l0.88,0.88 C8.1,12.27,8.1,12.9,7.71,13.29z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 car-rental
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,7c1.3,0,2.41-0.84,2.83-2H16v1c0,0.55,0.45,1,1,1s1-0.45,1-1V5h0c0.55,0,1-0.45,1-1s-0.45-1-1-1h-7.17 C10.35,1.65,8.95,0.76,7.4,1.06C6.23,1.29,5.28,2.25,5.05,3.42C4.7,5.32,6.15,7,8,7z M8,3c0.55,0,1,0.45,1,1S8.55,5,8,5S7,4.55,7,4 S7.45,3,8,3z M16.39,9H7.61C7.18,9,6.8,9.28,6.66,9.68L5,14.69V21c0,0.55,0.45,1,1,1s1-0.45,1-1v-1h10v1c0,0.55,0.45,1,1,1 s1-0.45,1-1v-6.31l-1.66-5.01C17.2,9.28,16.82,9,16.39,9z M9,17.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S9.55,17.5,9,17.5z M15,17.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,17.5,15,17.5z M7.67,13l0.66-2h7.34l0.66,2H7.67z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 hotel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 13c1.66 0 3-1.34 3-3S8.66 7 7 7s-3 1.34-3 3 1.34 3 3 3zm12-6h-6c-1.1 0-2 .9-2 2v5H3V6c0-.55-.45-1-1-1s-1 .45-1 1v13c0 .55.45 1 1 1s1-.45 1-1v-2h18v2c0 .55.45 1 1 1s1-.45 1-1v-8c0-2.21-1.79-4-4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emergency-share
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,9c-3.15,0-6,2.41-6,6.15c0,2.35,1.78,5.11,5.34,8.27c0.37,0.33,0.95,0.33,1.33,0C16.22,20.25,18,17.5,18,15.15 C18,11.41,15.15,9,12,9z M12,16.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S12.83,16.5,12,16.5z M16.18,6.82 c-0.35,0.35-0.89,0.38-1.3,0.09C14.07,6.34,13.07,6,12,6S9.93,6.34,9.12,6.91c-0.41,0.28-0.95,0.26-1.3-0.09 c-0.43-0.43-0.39-1.15,0.09-1.5C9.06,4.49,10.48,4,12,4s2.94,0.49,4.09,1.32C16.58,5.67,16.61,6.39,16.18,6.82z M4.97,3.97 C4.55,3.54,4.59,2.85,5.05,2.47C6.95,0.93,9.37,0,12.01,0c2.64,0,5.06,0.93,6.95,2.48c0.46,0.38,0.5,1.07,0.08,1.49 c-0.36,0.36-0.93,0.39-1.32,0.07C16.16,2.77,14.17,2,12.01,2C9.83,2,7.84,2.77,6.29,4.04C5.9,4.36,5.33,4.32,4.97,3.97z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dinner-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M2.85,19.85l1,1C3.95,20.95,4.07,21,4.21,21h15.59c0.13,0,0.26-0.05,0.35-0.15l1-1c0.31-0.31,0.09-0.85-0.35-0.85H3.21 C2.76,19,2.54,19.54,2.85,19.85z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3,18l16.97,0c0,0,0,0,0,0c0.29-3.26-2.28-6-5.48-6c-2.35,0-4.35,1.48-5.14,3.55C8.94,15.32,8.48,15.17,8,15.08V9h1.75 C10.99,9,12,7.99,12,6.75v0h8.25C20.66,6.75,21,6.41,21,6s-0.34-0.75-0.75-0.75H12v0C12,4.01,10.99,3,9.75,3h-6 C3.34,3,3,3.34,3,3.75S3.34,4.5,3.75,4.5H4v0.75H3.75C3.34,5.25,3,5.59,3,6s0.34,0.75,0.75,0.75H4V7.5H3.75 C3.34,7.5,3,7.84,3,8.25S3.34,9,3.75,9H4v7.39C3.56,16.85,3.22,17.39,3,18z M8,4.5h2v0.75H8V4.5z M8,6.75h2V7.5H8V6.75z M5.5,4.5 h1v0.75h-1V4.5z M5.5,6.75h1V7.5h-1V6.75z M5.5,9h1v6.06c-0.35,0.06-0.68,0.17-1,0.3V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 lunch-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3.37,14.28c0.79-0.29,1.17-0.78,1.99-0.78c1.19,0,1.42,1,3.33,1c1.95,0,2.09-1,3.33-1c1.19,0,1.42,1,3.33,1 c1.95,0,2.09-1,3.33-1c0.81,0,1.17,0.46,1.93,0.76c0.67,0.26,1.39-0.25,1.39-0.96c0-0.43-0.28-0.81-0.69-0.96 c-0.97-0.35-1.22-0.83-2.65-0.83c-1.95,0-2.09,1-3.33,1c-1.19,0-1.42-1-3.33-1c-1.95,0-2.09,1-3.33,1c-1.19,0-1.42-1-3.33-1 c-1.55,0-1.96,0.63-2.68,0.89c-0.39,0.14-0.65,0.52-0.65,0.94C2.01,14.03,2.71,14.52,3.37,14.28z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2,19c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-1c0-1.1-0.9-2-2-2H4c-1.1,0-2,0.9-2,2V19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,9c0.02-4-4.28-6-10-6C6.29,3,2,5,2,9v0c0,0.55,0.45,1,1,1h18C21.55,10,22,9.55,22,9L22,9L22,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 turn-slight-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11.66,5L11.66,5c0-0.55-0.45-1-1-1H7C6.45,4,6,4.45,6,5v3.66c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V7.41l5,5V19 c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-6.58c0-0.53-0.21-1.04-0.59-1.41l-5-5h1.24C11.21,6,11.66,5.55,11.66,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 merge
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8.71,7.71c-0.39-0.39-0.39-1.02,0-1.41l2.59-2.59c0.39-0.39,1.02-0.39,1.41,0l2.59,2.59c0.39,0.39,0.39,1.02,0,1.41 c-0.39,0.39-1.02,0.39-1.41,0L13,6.83v5.1c0,1.06,0.42,2.08,1.17,2.83l4.12,4.12c0.39,0.39,0.39,1.02,0,1.41s-1.02,0.39-1.41,0 L12,15.41l-4.88,4.88c-0.39,0.39-1.02,0.39-1.41,0c-0.39-0.39-0.39-1.02,0-1.41l4.12-4.12c0.75-0.75,1.17-1.77,1.17-2.83v-5.1 l-0.88,0.88C9.73,8.1,9.1,8.1,8.71,7.71z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roundabout-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,21c0.55,0,1-0.45,1-1l0-5.09c0-0.98-0.71-1.8-1.67-1.97C5.44,12.63,4,10.98,4,9c0-2.21,1.79-4,4-4 c1.98,0,3.63,1.44,3.94,3.33C12.11,9.29,12.93,10,13.91,10l4.26,0l-0.88,0.88c-0.39,0.39-0.39,1.02,0,1.41 c0.39,0.39,1.02,0.39,1.41,0l2.59-2.59c0.39-0.39,0.39-1.02,0-1.41l-2.59-2.59c-0.39-0.39-1.02-0.39-1.41,0 c-0.39,0.39-0.39,1.02,0,1.41L18.17,8l-4.25,0C13.44,5.16,10.97,3,8,3C4.69,3,2,5.69,2,9c0,2.97,2.16,5.44,5,5.92L7,20 C7,20.55,7.45,21,8,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 ramen-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,2.84L22,2.84c0-0.45-0.39-0.79-0.83-0.75L4.89,3.9C4.38,3.95,4,4.38,4,4.89V12H3.08c-0.6,0-1.08,0.53-1,1.13 C2.52,16.33,4.83,19,8,20.25V21c0,0.55,0.45,1,1,1h6c0.55,0,1-0.45,1-1v-0.75c3.17-1.25,5.48-3.92,5.92-7.12 c0.08-0.6-0.4-1.13-1-1.13H10.5V8h10.75C21.66,8,22,7.66,22,7.25v0c0-0.41-0.34-0.75-0.75-0.75H10.5V4.78l10.83-1.19 C21.71,3.54,22,3.22,22,2.84z M6.5,5.22V6.5h-1V5.34L6.5,5.22z M5.5,8h1v4h-1V8z M9,12H8V8h1V12z M9,6.5H8V5.06l1-0.11V6.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 edit-location-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M13.54,13H10c-0.55,0-1-0.45-1-1V8.46C9,8.2,9.11,7.94,9.29,7.76l5.32-5.32C13.78,2.16,12.9,2,12,2c-4.2,0-8,3.22-8,8.2 c0,3.18,2.44,6.92,7.33,11.22c0.38,0.33,0.96,0.33,1.34,0C17.56,17.12,20,13.37,20,10.2c0-1.01-0.16-1.94-0.45-2.8l-5.31,5.31 C14.06,12.89,13.8,13,13.54,13z",
       :stroke nil,
       :fill nil}))
    (helix.dom/polygon
     {:points "11,11 13.12,11 19.28,4.84 17.16,2.72 11,8.88",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.71,2L20,1.29c-0.39-0.39-1.02-0.39-1.41,0l-0.72,0.72l2.12,2.12l0.72-0.72C21.1,3.02,21.1,2.39,20.71,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 taxi-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,13c-1.91,0-3.63-0.76-4.89-2H4.81l1.04-3h5.44C11.1,7.37,11,6.7,11,6s0.1-1.37,0.29-2H9C8.45,4,8,4.45,8,5v1H5.5 C4.84,6,4.29,6.42,4.08,7.01L2,13v7.5C2,21.32,2.67,22,3.5,22S5,21.32,5,20.5V20h12v0.5c0,0.82,0.67,1.5,1.5,1.5 s1.5-0.68,1.5-1.5V13l-0.09-0.27C19.3,12.9,18.66,13,18,13z M6.5,17C5.67,17,5,16.33,5,15.5S5.67,14,6.5,14S8,14.67,8,15.5 S7.33,17,6.5,17z M15.5,17c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,17,15.5,17z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18,9c-0.28,0-0.5-0.22-0.5-0.5S17.72,8,18,8 s0.5,0.22,0.5,0.5S18.28,9,18,9z M18.5,6.5C18.5,6.78,18.28,7,18,7s-0.5-0.22-0.5-0.5v-3C17.5,3.22,17.72,3,18,3 s0.5,0.22,0.5,0.5V6.5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 soup-kitchen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.15,13.5c-0.46,0-0.8-0.42-0.71-0.87C5.48,12.45,5.5,12.24,5.5,12c0-1-1-2.85-1-3.62c0-0.29,0.03-0.59,0.17-0.93 C4.78,7.18,5.04,7,5.34,7c0.45,0,0.8,0.42,0.71,0.86C6.01,8.04,6,8.21,6,8.38C6,9.15,7,11,7,12c0,0.42-0.08,0.76-0.17,1.01 C6.73,13.31,6.46,13.5,6.15,13.5z M12.65,13.5c0.31,0,0.58-0.19,0.68-0.49c0.09-0.25,0.17-0.59,0.17-1.01c0-1-1-2.85-1-3.62 c0-0.17,0.01-0.34,0.04-0.51C12.63,7.42,12.29,7,11.84,7c-0.29,0-0.56,0.18-0.67,0.45C11.03,7.79,11,8.08,11,8.38 C11,9.15,12,11,12,12c0,0.24-0.02,0.45-0.06,0.63C11.85,13.08,12.19,13.5,12.65,13.5z M9.4,13.5c0.31,0,0.58-0.19,0.68-0.49 c0.09-0.25,0.17-0.59,0.17-1.01c0-1-1-2.85-1-3.62c0-0.17,0.01-0.34,0.04-0.51C9.38,7.42,9.04,7,8.59,7C8.29,7,8.03,7.18,7.92,7.45 C7.78,7.79,7.75,8.08,7.75,8.38c0,0.77,1,2.63,1,3.62c0,0.24-0.02,0.45-0.06,0.63C8.6,13.08,8.94,13.5,9.4,13.5z M20.46,6.37 c0.57,0.07,1.08-0.34,1.12-0.91C21.59,5.28,21.6,5.12,21.6,5c0-1.65-1.35-3-3-3c-1.54,0-2.81,1.16-2.98,2.65L14.53,15H3.99 c-0.6,0-1.07,0.54-0.98,1.14C3.54,19.46,6.39,22,9.75,22c3.48,0,6.34-2.73,6.71-6.23l1.15-10.87C17.66,4.39,18.08,4,18.6,4 c0.55,0,1,0.45,1,1c0,0.07-0.01,0.18-0.01,0.31C19.55,5.84,19.93,6.3,20.46,6.37L20.46,6.37z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-pizza
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C9.01 2 6.28 3.08 4.17 4.88c-.71.61-.86 1.65-.4 2.46l7.36 13.11c.38.68 1.36.68 1.74 0l7.36-13.11c.46-.81.31-1.86-.4-2.46C17.73 3.09 14.99 2 12 2zM7 7c0-1.1.9-2 2-2s2 .9 2 2-.9 2-2 2-2-.9-2-2zm5 8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bike-scooter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10,14h0.74L8.82,5.56C8.61,4.65,7.8,4,6.87,4H4C3.45,4,3,4.45,3,5v0c0,0.55,0.45,1,1,1h2.87l1.42,6.25c0,0-0.01,0-0.01,0 C6.12,12.9,4.47,14.73,4.09,17H0v2h6v-1C6,15.79,7.79,14,10,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.75,8l-0.56,0l-1.35-3.69C16.55,3.52,15.8,3,14.96,3H12c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2.96l1.1,3H10.4 l0.46,2H15c-0.43,0.58-0.75,1.25-0.9,2h-2.79l0.46,2h2.33c0.44,2.23,2.31,3.88,4.65,3.99c3.16,0.15,5.88-2.83,5.12-6.1 C23.34,9.57,21.13,8,18.75,8z M18.88,16c-1.54-0.06-2.84-1.37-2.88-2.92c-0.02-0.96,0.39-1.8,1.05-2.36l0.62,1.7 c0.19,0.52,0.76,0.79,1.28,0.6l0,0c0.52-0.19,0.79-0.76,0.6-1.28l-0.63-1.73c0,0,0,0,0.01-0.01C20.64,9.96,22,11.29,22,13 C22,14.72,20.62,16.06,18.88,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,15c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S11.66,15,10,15z M10,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S10.55,19,10,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 atm
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8 9.75c0 .41.34.75.75.75h1.5v3.75c0 .41.34.75.75.75s.75-.34.75-.75V10.5h1.5c.41 0 .75-.34.75-.75S13.66 9 13.25 9h-4.5c-.41 0-.75.34-.75.75zM6 9H3c-.55 0-1 .45-1 1v4.25c0 .41.34.75.75.75s.75-.34.75-.75v-.75h2v.75c0 .41.34.75.75.75s.75-.34.75-.75V10c0-.55-.45-1-1-1zm-.5 3h-2v-1.5h2V12zM21 9h-4.5c-.55 0-1 .45-1 1v4.25c0 .41.34.75.75.75s.75-.34.75-.75V10.5h1v2.75c0 .41.34.75.75.75s.75-.34.75-.75v-2.76h1v3.76c0 .41.34.75.75.75s.75-.34.75-.75V10c0-.55-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 set-meal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.3,17.6L3.83,18.46c-0.41,0.02-0.77-0.3-0.79-0.71l0,0c-0.02-0.41,0.3-0.77,0.71-0.79l16.48-0.86 c0.41-0.02,0.77,0.3,0.79,0.71v0C21.04,17.22,20.72,17.58,20.3,17.6z M20.25,19.48H3.75C3.34,19.48,3,19.82,3,20.23l0,0 c0,0.41,0.34,0.75,0.75,0.75h16.5c0.41,0,0.75-0.34,0.75-0.75l0,0C21,19.82,20.66,19.48,20.25,19.48z M22,5v7c0,1.1-0.9,2-2,2H4 c-1.1,0-2-0.9-2-2V5c0-1.1,0.9-2,2-2h16C21.1,3,22,3.9,22,5z M19.12,6.09c-1.25,0.27-2.19,1.11-2.33,2.14 C16.15,7.5,14.06,5.5,10.25,5.5c-3.44,0-5.48,1.63-6.31,2.49c-0.28,0.29-0.28,0.74,0,1.03c0.83,0.86,2.87,2.49,6.31,2.49 c3.81,0,5.9-2,6.54-2.73c0.14,1.02,1.08,1.86,2.33,2.14c0.46,0.1,0.88-0.28,0.88-0.74V6.84C20,6.37,19.57,5.99,19.12,6.09z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 takeout-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.29,6.75c-0.39-0.39-1.01-0.39-1.4,0L19,7.63l0.03-0.56l-3.46-3.48C15.19,3.21,14.68,3,14.15,3h-4.3 C9.32,3,8.81,3.21,8.43,3.59L4.97,7.07L5,7.57L4.11,6.7C3.72,6.32,3.1,6.32,2.72,6.71L2.7,6.73C2.32,7.12,2.32,7.75,2.72,8.13 L4.66,10h14.69l1.92-1.84C21.67,7.78,21.68,7.14,21.29,6.75z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5.79,18.15C5.87,19.19,6.74,20,7.79,20h8.43c1.05,0,1.92-0.81,1.99-1.85l0.49-6.6H5.3L5.79,18.15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 screen-rotation-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.53,9.29C19.16,9.92,18.71,11,17.82,11c-0.27,0-0.52-0.11-0.71-0.29L10.4,4L5.41,9H7c0.55,0,1,0.45,1,1s-0.45,1-1,1H3 c-0.55,0-1-0.45-1-1V6c0-0.55,0.45-1,1-1s1,0.45,1,1v1.59l5-5c0.78-0.78,2.05-0.78,2.83,0L18.53,9.29z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M5.47,14.71C4.84,14.08,5.29,13,6.18,13c0.27,0,0.52,0.11,0.71,0.29L13.6,20l4.99-5H17c-0.55,0-1-0.45-1-1s0.45-1,1-1h4 c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1s-1-0.45-1-1v-1.59l-5,5c-0.78,0.78-2.05,0.78-2.83,0L5.47,14.71z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 minor-crash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.5,24c0.82,0,1.5-0.67,1.5-1.5v-7.16c0-0.22-0.04-0.45-0.11-0.66l-1.97-5.67C18.72,8.42,18.16,8,17.5,8h-11 C5.84,8,5.29,8.42,5.08,9.01l-1.97,5.67C3.04,14.89,3,15.11,3,15.34v7.16C3,23.33,3.68,24,4.5,24S6,23.33,6,22.5V22h12v0.5 C18,23.33,18.67,24,19.5,24z M6.85,10h10.29l1.04,3H5.81L6.85,10z M6,17.5C6,16.67,6.67,16,7.5,16S9,16.67,9,17.5S8.33,19,7.5,19 S6,18.33,6,17.5z M15,17.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S17.33,19,16.5,19S15,18.33,15,17.5z M8.71,5.71 c-0.39,0.39-1.02,0.39-1.41,0L5.71,4.12c-0.39-0.39-0.39-1.02,0-1.41s1.02-0.39,1.41,0l1.59,1.59C9.1,4.68,9.1,5.32,8.71,5.71z M18.29,2.71c0.39,0.39,0.39,1.02,0,1.41l-1.59,1.59c-0.39,0.39-1.02,0.39-1.41,0s-0.39-1.02,0-1.41l1.59-1.59 C17.27,2.32,17.9,2.32,18.29,2.71z M12,5c-0.55,0-1-0.45-1-1V1c0-0.55,0.45-1,1-1s1,0.45,1,1v3C13,4.55,12.55,5,12,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 maps-ugc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24",
    :height "24",
    :fill-rule "evenodd",
    :fill "none",
    :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,4c4.97,0,8.9,4.56,7.82,9.72c-0.68,3.23-3.4,5.74-6.67,6.2c-1.59,0.22-3.14-0.01-4.58-0.7 c-0.27-0.13-0.56-0.19-0.86-0.19c-0.19,0-0.38,0.03-0.56,0.08l-2.31,0.68c-0.38,0.11-0.74-0.24-0.63-0.63l0.7-2.39 c0.13-0.45,0.07-0.92-0.14-1.35C4.26,14.34,4,13.18,4,12C4,7.59,7.59,4,12,4 M12,2C6.48,2,2,6.48,2,12c0,1.54,0.36,2.98,0.97,4.29 l-1.46,4.96C1.29,22,2,22.71,2.76,22.48l4.96-1.46c1.66,0.79,3.56,1.15,5.58,0.89c4.56-0.59,8.21-4.35,8.66-8.92 C22.53,7.03,17.85,2,12,2L12,2z",
     :stroke nil,
     :fill nil}))
  (helix.dom/path
   {:fill-rule "evenodd",
    :d
    "M12,8L12,8c-0.55,0-1,0.45-1,1v2H9c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2v2 c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2h2c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-2V9C13,8.45,12.55,8,12,8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 park
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16.96,12h0.08c0.81,0,1.28-0.91,0.82-1.57l-5.08-7.25c-0.4-0.57-1.24-0.57-1.64,0L6.1,10.43C5.64,11.09,6.12,12,6.93,12 h0.04l-2.9,4.46C3.63,17.12,4.11,18,4.91,18h5.08v2.02c0,1.09,0.89,1.98,1.98,1.98h0c1.09,0,1.98-0.89,1.98-1.98V18h5.15 c0.8,0,1.28-0.89,0.83-1.55L16.96,12z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 pest-control
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,14L21,14c0-0.55-0.45-1-1-1h-2.07c-0.05-0.39-0.12-0.77-0.22-1.14l1.72-0.99c0.48-0.28,0.64-0.89,0.37-1.37l0,0 c-0.28-0.48-0.89-0.64-1.37-0.37L16.92,10c-0.28-0.48-0.62-0.91-0.99-1.29C15.97,8.48,16,8.25,16,8c0-0.8-0.24-1.55-0.65-2.18 l0.94-0.94c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0l-1.02,1.02c-1.68-0.89-3.1-0.33-3.73,0L9.12,3.46 c-0.39-0.39-1.02-0.39-1.41,0l0,0c-0.39,0.39-0.39,1.02,0,1.41l0.94,0.94C8.24,6.45,8,7.2,8,8c0,0.25,0.03,0.48,0.07,0.72 C7.7,9.1,7.36,9.53,7.08,10L5.57,9.13C5.09,8.86,4.48,9.02,4.21,9.5l0,0c-0.28,0.48-0.11,1.09,0.37,1.37l1.72,0.99 c-0.1,0.37-0.17,0.75-0.22,1.14H4c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2.07c0.05,0.39,0.12,0.77,0.22,1.14l-1.72,0.99 c-0.48,0.28-0.64,0.89-0.37,1.37l0,0c0.28,0.48,0.89,0.64,1.37,0.37L7.08,18c1.08,1.81,2.88,3,4.92,3s3.84-1.19,4.92-3l1.51,0.87 c0.48,0.28,1.09,0.11,1.37-0.37l0,0c0.28-0.48,0.11-1.09-0.37-1.37l-1.72-0.99c0.1-0.37,0.17-0.75,0.22-1.14H20 C20.55,15,21,14.55,21,14z M12,17L12,17c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v4C13,16.55,12.55,17,12,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-boat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,21c-1.19,0-2.38-0.35-3.47-0.98c-0.33-0.19-0.73-0.19-1.07,0c-2.17,1.26-4.76,1.26-6.93,0 c-0.33-0.19-0.73-0.19-1.07,0C6.38,20.65,5.19,21,4,21H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1c1.38,0,2.74-0.35,4-0.99 c2.52,1.29,5.48,1.29,8,0c1.26,0.65,2.62,0.99,4,0.99h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H20z M3.95,19H4 c1.27,0,2.42-0.55,3.33-1.33c0.39-0.34,0.95-0.34,1.34,0C9.58,18.45,10.73,19,12,19s2.42-0.55,3.33-1.33 c0.39-0.34,0.95-0.34,1.34,0C17.58,18.45,18.73,19,20,19h0.05l1.9-6.68c0.11-0.37,0.04-1.06-0.66-1.28L20,10.62V6c0-1.1-0.9-2-2-2 h-3V2c0-0.55-0.45-1-1-1h-4C9.45,1,9,1.45,9,2v2H6C4.9,4,4,4.9,4,6v4.62l-1.29,0.42c-0.63,0.19-0.81,0.84-0.66,1.28L3.95,19z M6,6 h12v3.97L12.62,8.2c-0.41-0.13-0.84-0.13-1.25,0L6,9.97V6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flight
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 14.58c0-.36-.19-.69-.49-.89L13 9V3.5c0-.83-.67-1.5-1.5-1.5S10 2.67 10 3.5V9l-7.51 4.69c-.3.19-.49.53-.49.89 0 .7.68 1.21 1.36 1L10 13.5V19l-1.8 1.35c-.13.09-.2.24-.2.4v.59c0 .33.32.57.64.48L11.5 21l2.86.82c.32.09.64-.15.64-.48v-.59c0-.16-.07-.31-.2-.4L13 19v-5.5l6.64 2.08c.68.21 1.36-.3 1.36-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pedal-bike
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.18,10l-1.7-4.68C16.19,4.53,15.44,4,14.6,4H13c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1.6l1.46,4h-4.81l-0.36-1h0.09 c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H8C7.45,7,7,7.45,7,8v0c0,0.55,0.45,1,1,1h0.75l1.82,5H9.9c-0.44-2.23-2.31-3.88-4.65-3.99 C2.45,9.87,0,12.2,0,15c0,2.8,2.2,5,5,5c2.46,0,4.45-1.69,4.9-4h4.2c0.44,2.23,2.31,3.88,4.65,3.99c2.8,0.13,5.25-2.19,5.25-5 c0-2.8-2.2-5-5-5H18.18z M7.82,16c-0.42,1.23-1.6,2.08-3.02,1.99C3.31,17.9,2.07,16.64,2,15.14C1.93,13.39,3.27,12,5,12 c1.33,0,2.42,0.83,2.82,2H6c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1H7.82z M14.1,14h-1.4l-0.73-2H15 C14.56,12.58,14.24,13.25,14.1,14z M18.88,18c-1.54-0.06-2.84-1.37-2.88-2.92c-0.02-0.96,0.39-1.8,1.05-2.36l0.62,1.7 c0.19,0.52,0.76,0.79,1.28,0.6l0,0c0.52-0.19,0.79-0.76,0.6-1.28l-0.63-1.73c0,0,0,0,0.01-0.01c1.72-0.04,3.08,1.29,3.08,3 C22,16.72,20.62,18.06,18.88,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 directions-bike
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.5 5.5c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zM5 12c-2.8 0-5 2.2-5 5s2.2 5 5 5 5-2.2 5-5-2.2-5-5-5zm0 8.5c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5 3.5 1.6 3.5 3.5-1.6 3.5-3.5 3.5zm5.8-10l2.4-2.4.8.8c1.06 1.06 2.38 1.78 3.96 2.02.6.09 1.14-.39 1.14-1 0-.49-.37-.91-.85-.99-1.11-.18-2.02-.71-2.75-1.43l-1.9-1.9c-.5-.4-1-.6-1.6-.6s-1.1.2-1.4.6L7.8 8.4c-.4.4-.6.9-.6 1.4 0 .6.2 1.1.6 1.4L11 14v4c0 .55.45 1 1 1s1-.45 1-1v-4.4c0-.52-.2-1.01-.55-1.38L10.8 10.5zM19 12c-2.8 0-5 2.2-5 5s2.2 5 5 5 5-2.2 5-5-2.2-5-5-5zm0 8.5c-1.9 0-3.5-1.6-3.5-3.5s1.6-3.5 3.5-3.5 3.5 1.6 3.5 3.5-1.6 3.5-3.5 3.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 moving
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M2.7,17.29c0.39,0.39,1.02,0.39,1.41,0l4.59-4.59c0.39-0.39,1.02-0.39,1.41,0l1.17,1.17c1.17,1.17,3.07,1.17,4.24,0 l4.18-4.17l1.44,1.44c0.31,0.31,0.85,0.09,0.85-0.35V6.5C22,6.22,21.78,6,21.5,6h-4.29c-0.45,0-0.67,0.54-0.35,0.85l1.44,1.44 l-4.17,4.17c-0.39,0.39-1.02,0.39-1.41,0l-1.17-1.17c-1.17-1.17-3.07-1.17-4.24,0L2.7,15.88C2.32,16.27,2.32,16.91,2.7,17.29z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-truck
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22.9,10.69l-1.44-4.32C21.18,5.55,20.42,5,19.56,5H19V4c0-0.55-0.45-1-1-1h-1c-0.55,0-1,0.45-1,1v1h-2c-1.1,0-2,0.9-2,2 v4H3c-1.1,0-2,0.9-2,2v3c0,1.1,0.9,2,2,2h1c0,1.66,1.34,3,3,3s3-1.34,3-3h4c0,1.66,1.34,3,3,3s3-1.34,3-3h1c1.1,0,2-0.9,2-2v-4.68 C23,11.11,22.97,10.9,22.9,10.69z M7,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S7.55,19,7,19z M17,19c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S17.55,19,17,19z M14,11V7h5.56l1.33,4H14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.25,8.5H10v-2h0.25C10.66,6.5,11,6.16,11,5.75v0C11,5.34,10.66,5,10.25,5h-8.5C1.34,5,1,5.34,1,5.75v0 C1,6.16,1.34,6.5,1.75,6.5H2v2H1.75C1.34,8.5,1,8.84,1,9.25v0C1,9.66,1.34,10,1.75,10h8.5C10.66,10,11,9.66,11,9.25v0 C11,8.84,10.66,8.5,10.25,8.5z M5.25,8.5H3.5v-2h1.75V8.5z M8.5,8.5H6.75v-2H8.5V8.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-run
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.49 5.48c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm-3.17 12l.57-2.5 2.1 2v5c0 .55.45 1 1 1s1-.45 1-1v-5.64c0-.55-.22-1.07-.62-1.45l-1.48-1.41.6-3c1.07 1.24 2.62 2.13 4.36 2.41.6.09 1.14-.39 1.14-1 0-.49-.36-.9-.85-.98-1.52-.25-2.78-1.15-3.45-2.33l-1-1.6c-.4-.6-1-1-1.7-1-.3 0-.5.1-.8.1L7.21 7.76c-.74.32-1.22 1.04-1.22 1.85v2.37c0 .55.45 1 1 1s1-.45 1-1v-2.4l1.8-.7-1.6 8.1-3.92-.8c-.54-.11-1.07.24-1.18.78V17c-.11.54.24 1.07.78 1.18l4.11.82c1.06.21 2.1-.46 2.34-1.52z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-car-wash
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 5c.83 0 1.5-.67 1.5-1.5 0-.66-.66-1.64-1.11-2.22-.2-.26-.59-.26-.79 0-.44.58-1.1 1.56-1.1 2.22 0 .83.67 1.5 1.5 1.5zm-5 0c.83 0 1.5-.67 1.5-1.5 0-.66-.66-1.64-1.11-2.22-.2-.26-.59-.26-.79 0-.44.58-1.1 1.56-1.1 2.22 0 .83.67 1.5 1.5 1.5zM7 5c.83 0 1.5-.67 1.5-1.5 0-.66-.66-1.64-1.11-2.22-.2-.26-.59-.26-.79 0-.44.58-1.1 1.56-1.1 2.22C5.5 4.33 6.17 5 7 5zm11.92 3.01C18.72 7.42 18.16 7 17.5 7h-11c-.66 0-1.21.42-1.42 1.01l-1.97 5.67c-.07.21-.11.43-.11.66v7.16c0 .83.67 1.5 1.5 1.5S6 22.33 6 21.5V21h12v.5c0 .82.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5v-7.16c0-.22-.04-.45-.11-.66l-1.97-5.67zM6.5 18c-.83 0-1.5-.67-1.5-1.5S5.67 15 6.5 15s1.5.67 1.5 1.5S7.33 18 6.5 18zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 13l1.27-3.82c.14-.4.52-.68.95-.68h9.56c.43 0 .81.28.95.68L19 13H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 church
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,12.22v-1.99c0-0.76-0.43-1.45-1.11-1.79L13,6.5V5h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1V2c0-0.55-0.45-1-1-1h0 c-0.55,0-1,0.45-1,1v1h-1C9.45,3,9,3.45,9,4v0c0,0.55,0.45,1,1,1h1v1.5L7.11,8.45C6.43,8.79,6,9.48,6,10.24v1.99l-2.81,1.25 C2.47,13.79,2,14.51,2,15.3V20c0,1.1,0.9,2,2,2h6l0-2.89c0-1,0.68-1.92,1.66-2.08C12.92,16.82,14,17.79,14,19v3h6c1.1,0,2-0.9,2-2 v-4.7c0-0.79-0.47-1.51-1.19-1.83L18,12.22z M12,13.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5 S12.83,13.5,12,13.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 my-location
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm8.94 3c-.46-4.17-3.77-7.48-7.94-7.94V2c0-.55-.45-1-1-1s-1 .45-1 1v1.06C6.83 3.52 3.52 6.83 3.06 11H2c-.55 0-1 .45-1 1s.45 1 1 1h1.06c.46 4.17 3.77 7.48 7.94 7.94V22c0 .55.45 1 1 1s1-.45 1-1v-1.06c4.17-.46 7.48-3.77 7.94-7.94H22c.55 0 1-.45 1-1s-.45-1-1-1h-1.06zM12 19c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 straight
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13,6.83l0.88,0.88c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41l-2.59-2.59c-0.39-0.39-1.02-0.39-1.41,0 L8.71,6.29c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0L11,6.83V20c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V6.83 L13,6.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 turn-slight-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12.34,5L12.34,5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1v3.66c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1V7.41l-5,5V19 c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v-6.58c0-0.53,0.21-1.04,0.59-1.41l5-5h-1.24C12.79,6,12.34,5.55,12.34,5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 railway-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M4,11V8h7.29c-0.77-2.6,0.21-4.61,0.37-4.97C2.97,2.67,2,5.02,2,7v9.5C2,18.43,3.57,20,5.5,20l-1.21,0.81 C4.11,20.93,4,21.13,4,21.35v0C4,21.71,4.29,22,4.65,22h10.7c0.36,0,0.65-0.29,0.65-0.65v0c0-0.22-0.11-0.42-0.29-0.54L14.5,20 c1.93,0,3.5-1.57,3.5-3.5V13c-1.91,0-3.63-0.76-4.89-2H4z M10,17c-0.83,0-1.5-0.67-1.5-1.5c0-0.83,0.67-1.5,1.5-1.5 s1.5,0.67,1.5,1.5C11.5,16.33,10.83,17,10,17z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18,9c-0.28,0-0.5-0.22-0.5-0.5C17.5,8.22,17.72,8,18,8 s0.5,0.22,0.5,0.5C18.5,8.78,18.28,9,18,9z M18.5,6.5C18.5,6.78,18.28,7,18,7s-0.5-0.22-0.5-0.5v-3C17.5,3.22,17.72,3,18,3 s0.5,0.22,0.5,0.5V6.5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 zoom-in-map
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3,8c0,0.55,0.45,1,1,1l4,0c0.55,0,1-0.45,1-1l0-4c0-0.55-0.45-1-1-1S7,3.45,7,4l0,1.59L4.62,3.21 c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41L5.59,7L4,7C3.45,7,3,7.45,3,8z M20,7h-1.59l2.38-2.38 c0.39-0.39,0.39-1.02,0-1.41c-0.39-0.39-1.02-0.39-1.41,0L17,5.59V4c0-0.55-0.45-1-1-1c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h4 c0.55,0,1-0.45,1-1S20.55,7,20,7z M4,17h1.59l-2.38,2.38c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0L7,18.41L7,20 c0,0.55,0.45,1,1,1s1-0.45,1-1l0-4c0-0.55-0.45-1-1-1l-4,0c-0.55,0-1,0.45-1,1C3,16.55,3.45,17,4,17z M21,16c0-0.55-0.45-1-1-1h-4 c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-1.59l2.38,2.38c0.39,0.39,1.02,0.39,1.41,0 c0.39-0.39,0.39-1.02,0-1.41L18.41,17H20C20.55,17,21,16.55,21,16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-gas-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "m19.77 7.23.01-.01-3.19-3.19c-.29-.29-.77-.29-1.06 0-.29.29-.29.77 0 1.06l1.58 1.58c-1.05.4-1.76 1.47-1.58 2.71.16 1.1 1.1 1.99 2.2 2.11.47.05.88-.03 1.27-.2v7.21c0 .55-.45 1-1 1s-1-.45-1-1V14c0-1.1-.9-2-2-2h-1V5c0-1.1-.9-2-2-2H6c-1.1 0-2 .9-2 2v15c0 .55.45 1 1 1h8c.55 0 1-.45 1-1v-6.5h1.5v4.86c0 1.31.94 2.5 2.24 2.63 1.5.15 2.76-1.02 2.76-2.49V9c0-.69-.28-1.32-.73-1.77zM12 10H6V6c0-.55.45-1 1-1h4c.55 0 1 .45 1 1v4zm6 0c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 transit-enterexit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.5 18H8c-1.1 0-2-.9-2-2V9.5C6 8.67 6.67 8 7.5 8S9 8.67 9 9.5v3.27L14.95 7c.57-.55 1.48-.54 2.04.02s.56 1.47.01 2.04L11.15 15h3.35c.83 0 1.5.67 1.5 1.5s-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 navigation
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.93 4.26l6.15 14.99c.34.83-.51 1.66-1.33 1.29l-5.34-2.36c-.26-.11-.55-.11-.81 0l-5.34 2.36c-.82.36-1.67-.46-1.33-1.29l6.15-14.99c.33-.83 1.51-.83 1.85 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-see
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M9.5,14c0,1.38,1.12,2.5,2.5,2.5c1.23,0,2.25-0.9,2.46-2.07c-1-1.01-1.83-1.98-2.48-2.93C10.61,11.52,9.5,12.63,9.5,14z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18.65,17.08c-0.37,0.32-0.92,0.32-1.3,0c-1.26-1.08-0.7-0.61-1.3-1.14c-0.83,1.74-2.73,2.87-4.85,2.5 c-1.83-0.32-3.31-1.8-3.63-3.63c-0.42-2.44,1.13-4.58,3.31-5.14C10.3,8.45,10,7.28,10,6.15C10,5.4,10.1,4.68,10.28,4h-0.4 c-0.56,0-1.1,0.24-1.48,0.65L7.17,6H4C2.9,6,2,6.9,2,8v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-6.03 C20.59,15.46,19.35,16.48,18.65,17.08z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17.34,14.42c0.37,0.33,0.95,0.33,1.33,0C22.22,11.25,24,8.5,24,6.15C24,2.42,21.15,0,18,0s-6,2.42-6,6.15 C12,8.5,13.78,11.25,17.34,14.42z M17.27,5.25L18,3l0.73,2.25H21l-1.85,1.47L19.85,9L18,7.59L16.15,9l0.7-2.28L15,5.25H17.27z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 hail
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,6c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2S13.1,6,12,6z M17.95,2L17.95,2c0.59,0,1.06,0.51,1,1.09 C18.93,3.24,18.74,7.15,15,8.4V21c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v-5h-2v5c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1V10.1 c-0.3,0.1-0.5,0.2-0.6,0.3c-0.46,0.36-1.17,0.87-1.36,2.67C6.99,13.59,6.57,14,6.04,14h0c-0.58,0-1.05-0.49-1-1.07 c0.13-1.6,0.62-2.98,2.07-4.22C8.21,7.81,10,7,12,7s2.68-0.46,3.48-1.06c0.43-0.34,1.28-0.99,1.48-3.02C17.01,2.4,17.43,2,17.95,2z M5,16h1c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H5c-0.55,0-1-0.45-1-1v-4C4,16.45,4.45,16,5,16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 emergency
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.29,8.37l-1-1.73c-0.28-0.48-0.89-0.64-1.37-0.37L14,8.54V4c0-0.55-0.45-1-1-1h-2c-0.55,0-1,0.45-1,1v4.54L6.07,6.27 C5.59,5.99,4.98,6.16,4.71,6.63l-1,1.73C3.43,8.84,3.59,9.46,4.07,9.73L8,12l-3.93,2.27c-0.48,0.28-0.64,0.89-0.37,1.37l1,1.73 c0.28,0.48,0.89,0.64,1.37,0.37L10,15.46V20c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1v-4.54l3.93,2.27c0.48,0.28,1.09,0.11,1.37-0.37 l1-1.73c0.28-0.48,0.11-1.09-0.37-1.37L16,12l3.93-2.27C20.41,9.46,20.57,8.84,20.29,8.37z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hvac
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,16c1.01,0,1.91-0.39,2.62-1H9.38C10.09,15.61,10.99,16,12,16z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8.56,14h6.89c0.26-0.45,0.44-0.96,0.51-1.5h-7.9C8.12,13.04,8.29,13.55,8.56,14z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,8c-1.01,0-1.91,0.39-2.62,1h5.24C13.91,8.39,13.01,8,12,8z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8.56,10c-0.26,0.45-0.44,0.96-0.51,1.5h7.9c-0.07-0.54-0.24-1.05-0.51-1.5H8.56z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M12,18c-3.31,0-6-2.69-6-6 s2.69-6,6-6s6,2.69,6,6S15.31,18,12,18z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 stadium
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6.11,5.45L3.72,6.64C3.39,6.8,3,6.56,3,6.19V3.81C3,3.44,3.39,3.2,3.72,3.36l2.38,1.19C6.47,4.74,6.47,5.26,6.11,5.45z M18,3.81v2.38c0,0.37,0.39,0.61,0.72,0.45l2.38-1.19c0.37-0.18,0.37-0.71,0-0.89l-2.38-1.19C18.39,3.2,18,3.44,18,3.81z M11,2.81 v2.38c0,0.37,0.39,0.61,0.72,0.45l2.38-1.19c0.37-0.18,0.37-0.71,0-0.89l-2.38-1.19C11.39,2.2,11,2.44,11,2.81z M5,10.04 C6.38,10.53,8.77,11,12,11s5.62-0.47,7-0.96C19,9.86,16.22,9,12,9S5,9.86,5,10.04z M14,17h-4c-0.55,0-1,0.45-1,1l0,3.88 C4.94,21.49,2,20.34,2,19v-9c0-1.66,4.48-3,10-3s10,1.34,10,3v9c0,1.34-2.94,2.48-7,2.87L15,18C15,17.45,14.55,17,14,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tram
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 5l.75-1.5H17V2H7v1.5h4.75L11 5c-3.13.09-6 .73-6 3.5V17c0 1.5 1.11 2.73 2.55 2.95l-1.19 1.19c-.32.32-.1.86.35.86H7.8c.13 0 .26-.05.35-.15L10 20h4l1.85 1.85c.09.09.22.15.35.15h1.09c.45 0 .67-.54.35-.85l-1.19-1.19C17.89 19.73 19 18.5 19 17V8.5c0-2.77-2.87-3.41-6-3.5zm-1 13.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm5-4.5H7V9h10v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-florist
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 22c4.56 0 8.33-3.4 8.92-7.8.09-.64-.48-1.21-1.12-1.12-4.4.59-7.8 4.36-7.8 8.92zM5.6 10.25c0 1.38 1.12 2.5 2.5 2.5.53 0 1.01-.16 1.42-.44l-.02.19c0 1.38 1.12 2.5 2.5 2.5s2.5-1.12 2.5-2.5l-.02-.19c.4.28.89.44 1.42.44 1.38 0 2.5-1.12 2.5-2.5 0-1-.59-1.85-1.43-2.25.84-.4 1.43-1.25 1.43-2.25 0-1.38-1.12-2.5-2.5-2.5-.53 0-1.01.16-1.42.44l.02-.19C14.5 2.12 13.38 1 12 1S9.5 2.12 9.5 3.5l.02.19c-.4-.28-.89-.44-1.42-.44-1.38 0-2.5 1.12-2.5 2.5 0 1 .59 1.85 1.43 2.25-.84.4-1.43 1.25-1.43 2.25zM12 5.5c1.38 0 2.5 1.12 2.5 2.5s-1.12 2.5-2.5 2.5S9.5 9.38 9.5 8s1.12-2.5 2.5-2.5zm-8.92 8.7C3.67 18.6 7.44 22 12 22c0-4.56-3.4-8.33-7.8-8.92-.64-.09-1.21.48-1.12 1.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compass-calibration
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "4", :cy "17", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 3C8.49 3 5.28 4.29 2.8 6.41c-.44.38-.48 1.06-.06 1.48l3.6 3.6c.36.36.92.39 1.32.08 1.2-.94 2.71-1.5 4.34-1.5 1.64 0 3.14.56 4.34 1.49.4.31.96.28 1.31-.08l3.6-3.6c.42-.42.38-1.1-.07-1.48C18.72 4.28 15.51 3 12 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-atm
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zm0 13c0 .55-.45 1-1 1H5c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v10zm-6-7c.55 0 1-.45 1-1s-.45-1-1-1h-1v-.01c0-.55-.45-1-1-1s-1 .45-1 1V8h-1c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1h3v1h-3c-.55 0-1 .45-1 1s.45 1 1 1h1c0 .55.45 1 1 1s1-.45 1-1h1c.55 0 1-.45 1-1v-3c0-.55-.45-1-1-1h-3v-1h3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-drink
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.23 2C4.04 2 3.11 3.04 3.24 4.22l1.77 16.01C5.13 21.23 5.97 22 7 22h10c1.03 0 1.87-.77 1.99-1.77l1.77-16.01c.13-1.18-.8-2.22-1.99-2.22H5.23zM12 19c-1.66 0-3-1.34-3-3 0-1.55 1.81-3.95 2.62-4.94.2-.25.57-.25.77 0 .81 1 2.62 3.39 2.62 4.94-.01 1.66-1.35 3-3.01 3zm6.33-11H5.67l-.32-2.89c-.06-.59.4-1.11 1-1.11h11.3c.59 0 1.06.52.99 1.11L18.33 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-hydrant-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,11h-1V8h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1.35C16.83,3.67,14.61,2,12,2S7.17,3.67,6.35,6H5 C4.45,6,4,6.45,4,7v0c0,0.55,0.45,1,1,1h1v3H5c-1.1,0-2,0.9-2,2v2c0,1.1,0.9,2,2,2h1v3H5c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1 h14c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1v-3h1c1.1,0,2-0.9,2-2v-2C21,11.9,20.1,11,19,11z M12,17.5c-1.93,0-3.5-1.57-3.5-3.5 s1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5S13.93,17.5,12,17.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 liquor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M3,14c0,1.3,0.84,2.4,2,2.82V20H4c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H7 v-3.18C8.16,16.4,9,15.3,9,14V7c0-0.55-0.45-1-1-1H4C3.45,6,3,6.45,3,7V14z M5,8h2v3H5V8z",
        :stroke nil,
        :fill nil}))
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M20.64,8.54l-0.96-0.32C19.27,8.08,19,7.7,19,7.27V3c0-0.55-0.45-1-1-1h-3c-0.55,0-1,0.45-1,1v4.28 c0,0.43-0.27,0.81-0.68,0.95l-0.96,0.32C11.55,8.83,11,9.59,11,10.45V20c0,1.1,0.9,2,2,2h7c1.1,0,2-0.9,2-2v-9.56 C22,9.58,21.45,8.82,20.64,8.54z M16,4h1v1h-1V4z M13,10.44l0.95-0.32C15.18,9.72,16,8.57,16,7.28V7h1v0.28 c0,1.29,0.82,2.44,2.05,2.85L20,10.44V12h-7V10.44z M20,20h-7v-2h7V20z",
        :stroke nil,
        :fill nil})))))))


(helix.core/defnc
 emergency-recording
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,10.48V6c0-1.1-0.9-2-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4.48l3.15,3.13 C21.46,16.97,22,16.74,22,16.3V7.7c0-0.44-0.54-0.67-0.85-0.35L18,10.48z M14.5,14.6c-0.28,0.48-0.89,0.64-1.37,0.37L11,13.73V16 c0,0.55-0.45,1-1,1s-1-0.45-1-1v-2.27l-2.13,1.23c-0.48,0.28-1.09,0.11-1.37-0.37c-0.28-0.48-0.11-1.09,0.37-1.37L8,12l-2.13-1.23 C5.39,10.49,5.22,9.88,5.5,9.4c0.28-0.48,0.89-0.64,1.37-0.37L9,10.27V8c0-0.55,0.45-1,1-1s1,0.45,1,1v2.27l2.13-1.23 c0.48-0.28,1.09-0.11,1.37,0.37c0.28,0.48,0.11,1.09-0.37,1.37L12,12l2.13,1.23C14.61,13.51,14.78,14.12,14.5,14.6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bus-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M4,11V8h7.29c-0.77-2.6,0.21-4.61,0.37-4.97C2.97,2.67,2,5.02,2,7v9.5c0,0.95,0.38,1.81,1,2.44v1.56 C3,21.33,3.67,22,4.5,22h0C5.33,22,6,21.33,6,20.5V20h8v0.5c0,0.82,0.67,1.5,1.5,1.5h0c0.82,0,1.5-0.67,1.5-1.5v-1.56 c0.62-0.63,1-1.49,1-2.44V13c-1.91,0-3.63-0.76-4.89-2H4z M6.5,17C5.67,17,5,16.33,5,15.5S5.67,14,6.5,14S8,14.67,8,15.5 S7.33,17,6.5,17z M15,15.5c0,0.83-0.67,1.5-1.5,1.5S12,16.33,12,15.5s0.67-1.5,1.5-1.5S15,14.67,15,15.5z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S20.76,1,18,1z M18.5,6.5C18.5,6.78,18.28,7,18,7s-0.5-0.22-0.5-0.5v-3 C17.5,3.22,17.72,3,18,3s0.5,0.22,0.5,0.5V6.5z M18.5,8.5C18.5,8.78,18.28,9,18,9s-0.5-0.22-0.5-0.5S17.72,8,18,8 S18.5,8.22,18.5,8.5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 restaurant-menu
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.1 13.34l2.83-2.83-6.19-6.18c-.48-.48-1.31-.35-1.61.27-.71 1.49-.45 3.32.78 4.56l4.19 4.18zm6.78-1.81c1.53.71 3.68.21 5.27-1.38 1.91-1.91 2.28-4.65.81-6.12-1.46-1.46-4.2-1.1-6.12.81-1.59 1.59-2.09 3.74-1.38 5.27L4.4 19.17c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 14.41l6.18 6.18c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L13.41 13l1.47-1.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 rate-review
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM6 14v-2.47l6.88-6.88c.2-.2.51-.2.71 0l1.77 1.77c.2.2.2.51 0 .71L8.47 14H6zm11 0h-6.5l2-2H17c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 u-turn-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3.71,12.29c0.39-0.39,1.02-0.39,1.41,0L6,13.17V9c0-3.31,2.69-6,6-6s6,2.69,6,6v11c0,0.55-0.45,1-1,1s-1-0.45-1-1V9 c0-2.21-1.79-4-4-4S8,6.79,8,9v4.17l0.88-0.88c0.39-0.39,1.02-0.39,1.41,0c0.39,0.39,0.39,1.02,0,1.41l-2.59,2.59 c-0.39,0.39-1.02,0.39-1.41,0l-2.59-2.59C3.32,13.32,3.32,12.68,3.71,12.29z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-fire-department
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,12.9l-2.03,2c-0.46,0.46-0.82,1.03-0.93,1.67C8.74,18.41,10.18,20,12,20s3.26-1.59,2.96-3.42 c-0.11-0.64-0.46-1.22-0.93-1.67L12,12.9z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M15.56,6.55L15.56,6.55C14.38,8.02,12,7.19,12,5.3V3.77c0-0.8-0.89-1.28-1.55-0.84C8.12,4.49,4,7.97,4,13 c0,2.92,1.56,5.47,3.89,6.86c-0.71-1.02-1.06-2.31-0.81-3.68c0.19-1.04,0.75-1.98,1.51-2.72l2.71-2.67c0.39-0.38,1.01-0.38,1.4,0 l2.73,2.69c0.74,0.73,1.3,1.65,1.48,2.68c0.25,1.36-0.07,2.64-0.77,3.66c1.89-1.15,3.29-3.06,3.71-5.3 c0.61-3.27-0.81-6.37-3.22-8.1C16.3,6.17,15.83,6.22,15.56,6.55z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 add-location-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,0c0.55,0,1,0.45,1,1v2h2c0.55,0,1,0.45,1,1s-0.45,1-1,1h-2v2c0,0.55-0.45,1-1,1s-1-0.45-1-1V5h-2c-0.55,0-1-0.45-1-1 s0.45-1,1-1h2V1C18,0.45,18.45,0,19,0z M12,12c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S10.9,12,12,12z M14.72,2.47 C14.28,2.83,14,3.38,14,4c0,1.1,0.9,2,2,2h1v1c0,1.1,0.9,2,2,2c0.32,0,0.62-0.08,0.89-0.21C19.96,9.24,20,9.71,20,10.2 c0,3.18-2.45,6.92-7.34,11.23c-0.38,0.33-0.95,0.33-1.33,0C6.45,17.12,4,13.38,4,10.2C4,5.22,7.8,2,12,2 C12.94,2,13.86,2.16,14.72,2.47z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-pharmacy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.89 5h-.53l.71-1.97c.24-.65-.1-1.37-.75-1.6-.65-.24-1.37.1-1.61.75L15.69 5H5.1C3.73 5 2.77 6.34 3.2 7.63L5 13l-1.79 5.37C2.77 19.66 3.74 21 5.1 21h13.78c1.36 0 2.33-1.34 1.9-2.63L19 13l1.78-5.37C21.21 6.34 20.25 5 18.89 5zM15 14h-2v2c0 .55-.45 1-1 1s-1-.45-1-1v-2H9c-.55 0-1-.45-1-1s.45-1 1-1h2v-2c0-.55.45-1 1-1s1 .45 1 1v2h2c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 run-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M13.5,6c0.55,0,1,0.45,1,1 c0,0.55-0.45,1-1,1s-1-0.45-1-1C12.5,6.45,12.95,6,13.5,6z M15.41,11.91c-0.71-0.2-1.63-0.74-2.32-1.66l-0.41,2.35l1.19,1.3 C13.95,13.98,14,14.1,14,14.22v3.28c0,0.28-0.22,0.5-0.5,0.5h0c-0.28,0-0.5-0.22-0.5-0.5v-3.08l-1.11-1.21l-0.43,2.15 c-0.05,0.27-0.32,0.45-0.59,0.39l-2.78-0.57c-0.27-0.06-0.45-0.32-0.39-0.59v0c0.06-0.27,0.32-0.44,0.59-0.39l2.29,0.47l0.96-4.89 L10,10.35v1.15c0,0.28-0.22,0.5-0.5,0.5h0C9.22,12,9,11.78,9,11.5V10c0-0.21,0.13-0.4,0.33-0.47l2.95-1.09 c0.49-0.18,1.02,0.04,1.25,0.51c0.65,1.35,1.55,1.85,2.1,2C15.85,11,16,11.18,16,11.4v0.04C16,11.75,15.71,11.99,15.41,11.91z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fork-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9,20c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-3c0.73-2.58,3.07-3.47,5.17-3l-0.88,0.88c-0.39,0.39-0.39,1.02,0,1.41 c0.39,0.39,1.02,0.39,1.41,0l2.59-2.59c0.39-0.39,0.39-1.02,0-1.41l-2.59-2.59c-0.39-0.39-1.02-0.39-1.41,0 c-0.39,0.39-0.39,1.02,0,1.41L16.17,12c-1.51-0.33-3.73,0.08-5.17,1.36l0-6.53l0.88,0.88c0.39,0.39,1.02,0.39,1.41,0 c0.39-0.39,0.39-1.02,0-1.41l-2.59-2.59c-0.39-0.39-1.02-0.39-1.41,0L6.71,6.29c-0.39,0.39-0.39,1.02,0,1.41 c0.39,0.39,1.02,0.39,1.41,0L9,6.83V20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 delivery-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,7c0-1.1-0.9-2-2-2h-2c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2v2.65L13.52,14H10v-4c0-0.55-0.45-1-1-1H6 c-2.21,0-4,1.79-4,4v2c0,0.55,0.45,1,1,1h1c0,1.66,1.34,3,3,3s3-1.34,3-3h3.52c0.61,0,1.18-0.28,1.56-0.75l3.48-4.35 C18.85,10.54,19,10.1,19,9.65V7z M7,17c-0.55,0-1-0.45-1-1h2C8,16.55,7.55,17,7,17z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M6,6h3c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H6C5.45,8,5,7.55,5,7v0C5,6.45,5.45,6,6,6z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M19,13c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,13,19,13z M19,17c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 C20,16.55,19.55,17,19,17z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 near-me-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,6.34l6.95-2.58c0.8-0.3,1.58,0.48,1.29,1.29L17.66,12L12,6.34z M21.9,19.07L4.93,2.1c-0.39-0.39-1.02-0.39-1.41,0 c-0.39,0.39-0.39,1.02,0,1.41l4.36,4.36l-4.2,1.56C3.27,9.59,3,9.97,3,10.4c0,0.42,0.26,0.8,0.65,0.96l6.42,2.57l2.57,6.42 C12.8,20.74,13.18,21,13.6,21c0.43,0,0.82-0.27,0.97-0.67l1.56-4.2l4.36,4.36c0.39,0.39,1.02,0.39,1.41,0 C22.29,20.09,22.29,19.46,21.9,19.07z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-cafe
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 3H6c-1.1 0-2 .9-2 2v8c0 2.21 1.79 4 4 4h6c2.21 0 4-1.79 4-4v-3h2c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 5h-2V5h2v3zM3 21h16c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 medical-information
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,7h-5V4c0-1.1-0.9-2-2-2h-2C9.9,2,9,2.9,9,4v3H4C2.9,7,2,7.9,2,9v11c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V9 C22,7.9,21.1,7,20,7z M11,4h2v5h-2V4z M7,16H6c-0.55,0-1-0.45-1-1s0.45-1,1-1h1v-1c0-0.55,0.45-1,1-1s1,0.45,1,1v1h1 c0.55,0,1,0.45,1,1s-0.45,1-1,1H9v1c0,0.55-0.45,1-1,1s-1-0.45-1-1V16z M13.75,14.5c-0.41,0-0.75-0.34-0.75-0.75S13.34,13,13.75,13 h4.5c0.41,0,0.75,0.34,0.75,0.75s-0.34,0.75-0.75,0.75H13.75z M13.75,17.5c-0.41,0-0.75-0.34-0.75-0.75S13.34,16,13.75,16h2.5 c0.41,0,0.75,0.34,0.75,0.75s-0.34,0.75-0.75,0.75H13.75z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fort
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,4v1h-2V4c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v1h-2V4c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2.17 c0,0.53,0.21,1.04,0.59,1.41L15,9v1H9V9l1.41-1.41C10.79,7.21,11,6.7,11,6.17V4c0-0.55-0.45-1-1-1h0C9.45,3,9,3.45,9,4v1H7V4 c0-0.55-0.45-1-1-1h0C5.45,3,5,3.45,5,4v1H3V4c0-0.55-0.45-1-1-1h0C1.45,3,1,3.45,1,4v2.17C1,6.7,1.21,7.21,1.59,7.59L3,9v6 l-1.41,1.41C1.21,16.79,1,17.3,1,17.83V19c0,1.1,0.9,2,2,2h7l0-2.89c0-1,0.68-1.92,1.66-2.08C12.92,15.82,14,16.79,14,18v3h7 c1.1,0,2-0.9,2-2v-1.17c0-0.53-0.21-1.04-0.59-1.41L21,15V9l1.41-1.41C22.79,7.21,23,6.7,23,6.17V4c0-0.55-0.45-1-1-1h0 C21.45,3,21,3.45,21,4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-car
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.92 6.01C18.72 5.42 18.16 5 17.5 5h-11c-.66 0-1.21.42-1.42 1.01l-1.97 5.67c-.07.21-.11.43-.11.66v7.16c0 .83.67 1.5 1.5 1.5S6 20.33 6 19.5V19h12v.5c0 .82.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5v-7.16c0-.22-.04-.45-.11-.66l-1.97-5.67zM6.5 16c-.83 0-1.5-.67-1.5-1.5S5.67 13 6.5 13s1.5.67 1.5 1.5S7.33 16 6.5 16zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 11l1.27-3.82c.14-.4.52-.68.95-.68h9.56c.43 0 .81.28.95.68L19 11H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 map
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.65 4.98l-5-1.75c-.42-.15-.88-.15-1.3-.01L4.36 4.56C3.55 4.84 3 5.6 3 6.46v11.85c0 1.41 1.41 2.37 2.72 1.86l2.93-1.14c.22-.09.47-.09.69-.01l5 1.75c.42.15.88.15 1.3.01l3.99-1.34c.81-.27 1.36-1.04 1.36-1.9V5.69c0-1.41-1.41-2.37-2.72-1.86l-2.93 1.14c-.22.08-.46.09-.69.01zM15 18.89l-6-2.11V5.11l6 2.11v11.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 celebration
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M3.99,21.29l9.04-3.23c1.38-0.49,1.78-2.26,0.74-3.3l-4.53-4.53c-1.04-1.04-2.8-0.64-3.3,0.74l-3.23,9.04 C2.43,20.81,3.19,21.57,3.99,21.29z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M15.06,12l5.06-5.06c0.49-0.49,1.28-0.49,1.77,0L21.95,7c0.29,0.29,0.77,0.29,1.06,0l0,0c0.29-0.29,0.29-0.77,0-1.06 l-0.06-0.06c-1.07-1.07-2.82-1.07-3.89,0L14,10.94c-0.29,0.29-0.29,0.77,0,1.06l0,0C14.29,12.29,14.77,12.29,15.06,12z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M10.06,6.88L10,6.94C9.71,7.23,9.71,7.71,10,8l0,0c0.29,0.29,0.77,0.29,1.06,0l0.06-0.06c1.07-1.07,1.07-2.82,0-3.89 L11.07,4C10.77,3.7,10.29,3.7,10,4l0,0c-0.29,0.29-0.29,0.77,0,1.06l0.06,0.06C10.54,5.6,10.54,6.4,10.06,6.88z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M17.06,11.88L16,12.94c-0.29,0.29-0.29,0.77,0,1.06l0,0c0.29,0.29,0.77,0.29,1.06,0l1.06-1.06 c0.49-0.49,1.28-0.49,1.77,0l1.08,1.08c0.29,0.29,0.77,0.29,1.06,0l0,0c0.29-0.29,0.29-0.77,0-1.06l-1.08-1.08 C19.87,10.81,18.13,10.81,17.06,11.88z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M15.06,5.88L12,8.94c-0.29,0.29-0.29,0.77,0,1.06l0,0c0.29,0.29,0.77,0.29,1.06,0l3.06-3.06c1.07-1.07,1.07-2.82,0-3.89 l-1.06-1.06c-0.29-0.29-0.77-0.29-1.06,0l0,0c-0.29,0.29-0.29,0.77,0,1.06l1.06,1.06C15.54,4.6,15.54,5.4,15.06,5.88z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 directions-subway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2c-4.42 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19l-1.15 1.15c-.31.31-.09.85.36.85H17.3c.45 0 .67-.54.35-.85L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-3.58-4-8-4zM7.5 17c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm3.5-6H6V6h5v5zm5.5 6c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-6h-5V6h5v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sailing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11,13V3.59c0-0.49-0.63-0.69-0.91-0.29l-6.54,9.41c-0.23,0.33,0.01,0.79,0.41,0.79h6.54C10.78,13.5,11,13.28,11,13z M20.99,12.98C20.72,7.07,15.9,2.32,13.4,1.23c-0.37-0.16-0.77,0.2-0.67,0.59c0.3,1.13,0.76,3.28,0.76,5.68 c0,2.44-0.49,4.39-0.78,5.35c-0.1,0.32,0.14,0.65,0.48,0.65h7.28C20.76,13.5,21,13.26,20.99,12.98z M20.62,15H3.38 c-0.73,0-1.22,0.76-0.92,1.42c0.43,0.92,1.07,1.71,1.86,2.31c0.38-0.16,0.74-0.38,1.06-0.63c0.35-0.29,0.87-0.29,1.23,0 C7.28,18.63,8.1,19,9,19c0.9,0,1.72-0.37,2.39-0.91c0.35-0.28,0.87-0.28,1.22,0C13.28,18.63,14.1,19,15,19 c0.9,0,1.72-0.37,2.39-0.91c0.35-0.29,0.87-0.28,1.23,0c0.32,0.26,0.67,0.48,1.06,0.63c0.79-0.6,1.43-1.39,1.86-2.31 C21.84,15.76,21.35,15,20.62,15z M22,22c0-0.55-0.45-1-1-1h0c-0.87,0-1.73-0.24-2.53-0.7c-0.29-0.16-0.65-0.17-0.94,0 c-1.59,0.9-3.47,0.9-5.06,0c-0.29-0.16-0.65-0.16-0.94,0c-1.59,0.9-3.47,0.9-5.06,0c-0.29-0.16-0.65-0.16-0.94,0 C4.73,20.76,3.87,21,3,21h0c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h0c1.15,0,2.3-0.31,3.33-0.94c1.66,1.11,3.78,1.01,5.58,0.14 c1.91,1.05,4.17,1.07,6.09,0.05h0c0.95,0.5,1.97,0.75,3,0.75h0C21.55,23,22,22.55,22,22z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ev-station
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.77 7.23l.01-.01-3.19-3.19c-.29-.29-.77-.29-1.06 0-.29.29-.29.77 0 1.06l1.58 1.58c-1.05.4-1.76 1.47-1.58 2.71.16 1.1 1.1 1.99 2.2 2.11.47.05.88-.03 1.27-.2v7.21c0 .55-.45 1-1 1s-1-.45-1-1V14c0-1.1-.9-2-2-2h-1V5c0-1.1-.9-2-2-2H6c-1.1 0-2 .9-2 2v15c0 .55.45 1 1 1h8c.55 0 1-.45 1-1v-6.5h1.5v4.86c0 1.31.94 2.5 2.24 2.63 1.5.15 2.76-1.02 2.76-2.49V9c0-.69-.28-1.32-.73-1.77zM18 10c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zM8 16.12V13.5H6.83c-.38 0-.62-.4-.44-.74l2.67-5c.24-.45.94-.28.94.24v3h1.14c.38 0 .62.41.43.75l-2.64 4.62c-.25.44-.93.26-.93-.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-offer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "m21.41 11.58-9-9C12.05 2.22 11.55 2 11 2H4c-1.1 0-2 .9-2 2v7c0 .55.22 1.05.59 1.42l9 9c.36.36.86.58 1.41.58s1.05-.22 1.41-.59l7-7c.37-.36.59-.86.59-1.41s-.23-1.06-.59-1.42zM5.5 7C4.67 7 4 6.33 4 5.5S4.67 4 5.5 4 7 4.67 7 5.5 6.33 7 5.5 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _360
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 7C6.48 7 2 9.24 2 12c0 2.24 2.94 4.13 7 4.77v2.02c0 .45.54.67.85.35l2.79-2.79c.2-.2.2-.51 0-.71l-2.79-2.79c-.31-.31-.85-.09-.85.36v1.52c-3.15-.56-5-1.9-5-2.73 0-1.06 3.04-3 8-3s8 1.94 8 3c0 .66-1.2 1.68-3.32 2.34-.41.13-.68.51-.68.94 0 .67.65 1.16 1.28.96C20.11 15.36 22 13.79 22 12c0-2.76-4.48-5-10-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 zoom-out-map
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M15.85,3.85L17.3,5.3l-2.18,2.16c-0.39,0.39-0.39,1.03,0,1.42l0,0c0.39,0.39,1.03,0.39,1.42,0L18.7,6.7l1.45,1.45 C20.46,8.46,21,8.24,21,7.79V3.5C21,3.22,20.78,3,20.5,3h-4.29C15.76,3,15.54,3.54,15.85,3.85z M3.85,8.15L5.3,6.7l2.16,2.18 c0.39,0.39,1.03,0.39,1.42,0l0,0c0.39-0.39,0.39-1.03,0-1.42L6.7,5.3l1.45-1.45C8.46,3.54,8.24,3,7.79,3H3.5 C3.22,3,3,3.22,3,3.5v4.29C3,8.24,3.54,8.46,3.85,8.15z M8.15,20.15L6.7,18.7l2.18-2.16c0.39-0.39,0.39-1.03,0-1.42l0,0 c-0.39-0.39-1.03-0.39-1.42,0L5.3,17.3l-1.45-1.45C3.54,15.54,3,15.76,3,16.21v4.29C3,20.78,3.22,21,3.5,21h4.29 C8.24,21,8.46,20.46,8.15,20.15z M20.15,15.85L18.7,17.3l-2.16-2.18c-0.39-0.39-1.03-0.39-1.42,0l0,0 c-0.39,0.39-0.39,1.03,0,1.42l2.18,2.16l-1.45,1.45C15.54,20.46,15.76,21,16.21,21h4.29c0.28,0,0.5-0.22,0.5-0.5v-4.29 C21,15.76,20.46,15.54,20.15,15.85z",
        :stroke nil,
        :fill nil})))))))


(helix.core/defnc
 alt-route
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M9.78,11.16l-1.42,1.42c-0.68-0.69-1.34-1.58-1.79-2.94l1.94-0.49C8.83,10.04,9.28,10.65,9.78,11.16z M10.15,5.15 L7.35,2.35c-0.2-0.2-0.51-0.2-0.71,0L3.85,5.15C3.54,5.46,3.76,6,4.21,6h1.81C6.04,6.81,6.1,7.54,6.21,8.17l1.94-0.49 C8.08,7.2,8.03,6.63,8.02,6h1.78C10.24,6,10.46,5.46,10.15,5.15z M20.15,5.15l-2.79-2.79c-0.2-0.2-0.51-0.2-0.71,0l-2.79,2.79 C13.54,5.46,13.76,6,14.21,6h1.78c-0.1,3.68-1.28,4.75-2.54,5.88c-0.5,0.44-1.01,0.92-1.45,1.55c-0.34-0.49-0.73-0.88-1.13-1.24 L9.46,13.6C10.39,14.45,11,15.14,11,17c0,0,0,0,0,0h0v4c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-4c0,0,0,0,0,0 c0-2.02,0.71-2.66,1.79-3.63c1.38-1.24,3.08-2.78,3.2-7.37h1.8C20.24,6,20.46,5.46,20.15,5.15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 synagogue
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6,8.94V21h4l0-4.89c0-1,0.68-1.92,1.66-2.08C12.92,13.82,14,14.79,14,16v5h4V8.94c0-0.59-0.26-1.16-0.72-1.54l-4-3.33 c-0.74-0.62-1.82-0.62-2.56,0l-4,3.33C6.26,7.78,6,8.34,6,8.94z M13.5,10c0,0.83-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5 s0.67-1.5,1.5-1.5S13.5,9.17,13.5,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M3,5C1.9,5,1,5.9,1,7v1h4V7C5,5.9,4.1,5,3,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M3,21h2V9H1v10C1,20.1,1.9,21,3,21z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M21,5c-1.1,0-2,0.9-2,2v1h4V7C23,5.9,22.1,5,21,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M19,21h2c1.1,0,2-0.9,2-2V9h-4V21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-hotel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 13c1.66 0 3-1.34 3-3S8.66 7 7 7s-3 1.34-3 3 1.34 3 3 3zm12-6h-6c-1.1 0-2 .9-2 2v5H3V6c0-.55-.45-1-1-1s-1 .45-1 1v13c0 .55.45 1 1 1s1-.45 1-1v-2h18v2c0 .55.45 1 1 1s1-.45 1-1v-8c0-2.21-1.79-4-4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-repair-service
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17,16c-0.55,0-1-0.45-1-1H8c0,0.55-0.45,1-1,1s-1-0.45-1-1H2v3c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-3h-4 C18,15.55,17.55,16,17,16z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M20,8h-3V6c0-1.1-0.9-2-2-2H9C7.9,4,7,4.9,7,6v2H4c-1.1,0-2,0.9-2,2v4h4v-1c0-0.55,0.45-1,1-1s1,0.45,1,1v1h8v-1 c0-0.55,0.45-1,1-1s1,0.45,1,1v1h4v-4C22,8.9,21.1,8,20,8z M15,8H9V6h6V8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 money
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 16h3c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1h-3c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1zm1-6h1v4h-1v-4zm-7 6h3c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1H9c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1zm1-6h1v4h-1v-4zM6 8c-.55 0-1 .45-1 1v6c0 .55.45 1 1 1s1-.45 1-1V9c0-.55-.45-1-1-1zM2 6v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2zm17 12H5c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 edit-attributes
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.63 7H6.37C3.96 7 2 9.24 2 12s1.96 5 4.37 5h11.26c2.41 0 4.37-2.24 4.37-5s-1.96-5-4.37-5zm-6.52 3.6L7.6 14.11c-.1.1-.23.15-.35.15s-.26-.05-.35-.15l-1.86-1.86c-.2-.2-.2-.51 0-.71s.51-.2.71 0l1.51 1.51 3.16-3.16c.2-.2.51-.2.71 0s.17.51-.02.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 temple-hindu
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "6.6,11 17.4,11 16.5,8 7.5,8", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M20 12v1H4v-1c0-.55-.45-1-1-1s-1 .45-1 1v8c0 1.1.9 2 2 2h6v-3c0-1.1.9-2 2-2s2 .9 2 2v3h6c1.1 0 2-.9 2-2v-8c0-.55-.45-1-1-1s-1 .45-1 1zm-4.1-6L15 3V2c0-.55-.45-1-1-1s-1 .45-1 1v1h-2.03V2c0-.55-.45-1-1-1s-1 .45-1 1v1.12L8.1 6h7.8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-movies
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 4v1h-2V4c0-.55-.45-1-1-1H9c-.55 0-1 .45-1 1v1H6V4c0-.55-.45-1-1-1s-1 .45-1 1v16c0 .55.45 1 1 1s1-.45 1-1v-1h2v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h2v1c0 .55.45 1 1 1s1-.45 1-1V4c0-.55-.45-1-1-1s-1 .45-1 1zM8 17H6v-2h2v2zm0-4H6v-2h2v2zm0-4H6V7h2v2zm10 8h-2v-2h2v2zm0-4h-2v-2h2v2zm0-4h-2V7h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 terrain
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.2 7.07L10.25 11l2.25 3c.33.44.24 1.07-.2 1.4-.44.33-1.07.25-1.4-.2-1.05-1.4-2.31-3.07-3.1-4.14-.4-.53-1.2-.53-1.6 0l-4 5.33c-.49.67-.02 1.61.8 1.61h18c.82 0 1.29-.94.8-1.6l-7-9.33c-.4-.54-1.2-.54-1.6 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 icecream
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.38,6.24C17.79,3.24,15.14,1,12,1S6.21,3.24,5.62,6.24C4.08,6.81,3,8.29,3,10c0,2.21,1.79,4,4,4 c0.12,0,0.23-0.02,0.34-0.02l3.83,7.31c0.38,0.72,1.41,0.71,1.78-0.01l3.73-7.31C16.79,13.98,16.89,14,17,14c2.21,0,4-1.79,4-4 C21,8.29,19.92,6.81,18.38,6.24z M12.05,18.63l-2.73-5.21C10.15,13.79,11.06,14,12,14c0.95,0,1.88-0.21,2.72-0.6L12.05,18.63z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 satellite
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM5 5h3c0 1.66-1.34 3-3 3V5zm0 5.91c0-.49.36-.9.85-.98 2.08-.36 3.72-2 4.08-4.08.08-.49.49-.85.98-.85.61 0 1.09.53 1 1.13-.48 2.96-2.81 5.3-5.77 5.78-.6.1-1.14-.39-1.14-1zm.63 6.28l2.49-3.2c.2-.25.58-.26.78-.01l2.1 2.53 3.1-3.99c.2-.26.6-.26.8.01l3.51 4.68c.25.33.01.8-.4.8H6.02c-.41-.01-.65-.49-.39-.82z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-parking
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.79 3H8c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2s2-.9 2-2v-4h3c3.57 0 6.42-3.13 5.95-6.79C18.56 5.19 15.84 3 12.79 3zm.41 8H10V7h3.2c1.1 0 2 .9 2 2s-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 train
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2c-4 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19l-1.15 1.15c-.31.31-.09.85.36.85H7.8c.13 0 .26-.05.35-.15L10 19h4l1.85 1.85c.09.09.22.15.35.15h1.09c.45 0 .67-.54.35-.85L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-4-4-8-4zM7.5 17c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm3.5-7H6V6h5v4zm5.5 7c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-7h-5V6h5v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 layers-clear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.99 9.79c.51-.4.51-1.18 0-1.58l-6.76-5.26c-.72-.56-1.73-.56-2.46 0L9.41 4.02l7.88 7.88 2.7-2.11zm0 3.49l-.01-.01c-.36-.28-.86-.28-1.22 0l-.05.04 1.4 1.4c.37-.41.34-1.07-.12-1.43zm1.45 5.6L4.12 1.56c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l3.52 3.52-2.22 1.72c-.51.4-.51 1.18 0 1.58l6.76 5.26c.72.56 1.73.56 2.46 0l.87-.68 1.42 1.42-2.92 2.27c-.36.28-.87.28-1.23 0l-6.15-4.78c-.36-.28-.86-.28-1.22 0-.51.4-.51 1.17 0 1.57l6.76 5.26c.72.56 1.73.56 2.46 0l3.72-2.89 3.07 3.07c.39.39 1.02.39 1.41 0 .41-.39.41-1.02.02-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mode-of-travel
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,10.2C4,5.22,7.8,2,12,2c4,0,7.64,2.92,7.97,7.5l2.32,0c0.45,0,0.67,0.54,0.35,0.85l-3.29,3.29c-0.2,0.2-0.51,0.2-0.71,0 l-3.29-3.29c-0.31-0.31-0.09-0.85,0.35-0.85l2.26,0C17.65,6.24,15.13,4,12,4c-3.35,0-6,2.57-6,6.2c0,2.34,1.95,5.44,6,9.14 c0.64-0.59,1.23-1.16,1.77-1.71c-0.17-0.34-0.27-0.72-0.27-1.12c0-1.38,1.12-2.5,2.5-2.5s2.5,1.12,2.5,2.5S17.38,19,16,19 c-0.24,0-0.47-0.03-0.69-0.1c-0.78,0.82-1.67,1.66-2.65,2.52c-0.38,0.33-0.95,0.33-1.33,0C6.45,17.12,4,13.38,4,10.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 beenhere
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 1H5c-1.1 0-1.99.9-1.99 2L3 15.93c0 .69.35 1.3.88 1.66l7.57 5.04c.34.22.77.22 1.11 0l7.56-5.04c.53-.36.88-.97.88-1.66V3c0-1.1-.9-2-2-2zm-.7 6.7l-7.59 7.59c-.39.39-1.02.39-1.41 0L5.71 11.7c-.39-.39-.39-1.02 0-1.41s1.02-.39 1.41 0L10 13.17l6.88-6.88c.39-.39 1.02-.39 1.41 0s.4 1.02.01 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 museum
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21.5,11c0.28,0,0.5-0.22,0.5-0.5V9.26c0-0.16-0.08-0.32-0.21-0.41L12.57,2.4c-0.34-0.24-0.8-0.24-1.15,0L2.21,8.85 C2.08,8.94,2,9.1,2,9.26v1.24C2,10.78,2.22,11,2.5,11H4v9H3c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1 c0-0.55-0.45-1-1-1h-1v-9H21.5z M16,17c0,0.55-0.45,1-1,1s-1-0.45-1-1v-3l-1.17,1.75c-0.4,0.59-1.27,0.59-1.66,0L10,14v3 c0,0.55-0.45,1-1,1s-1-0.45-1-1v-4.7C8,11.58,8.58,11,9.3,11h0c0.43,0,0.84,0.22,1.08,0.58L12,14l1.61-2.42 C13.86,11.22,14.26,11,14.7,11h0c0.72,0,1.3,0.58,1.3,1.3V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 egg-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,9C17,7,15.99,2,9.97,2C4.95,2,1.94,6,2,11.52C2.06,17.04,6.96,19,9.97,19c2.01,0,2.01,3,6.02,3C19,22,22,19,22,15.02 C22,12,21.01,11,19,9z M12,15.5c-1.93,0-3.5-1.57-3.5-3.5s1.57-3.5,3.5-3.5s3.5,1.57,3.5,3.5S13.93,15.5,12,15.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 directions-bus-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:enable-background "new",
     :d
     "M12,2C8,2,4,2.5,4,6v9.5c0,0.95,0.38,1.81,1,2.44v1.56C5,20.33,5.67,21,6.5,21h0 C7.33,21,8,20.33,8,19.5V19h8v0.5c0,0.82,0.67,1.5,1.5,1.5h0c0.82,0,1.5-0.67,1.5-1.5v-1.56c0.62-0.63,1-1.49,1-2.44V6 C20,2.5,16.42,2,12,2z M8.5,16C7.67,16,7,15.33,7,14.5S7.67,13,8.5,13s1.5,0.67,1.5,1.5S9.33,16,8.5,16z M15.5,16 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,16,15.5,16z M18,10H6V7h12V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 safety-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11.3,2.26l-6,2.25C4.52,4.81,4,5.55,4,6.39v4.7c0,4.83,3.13,9.37,7.43,10.75c0.37,0.12,0.77,0.12,1.14,0 c4.3-1.38,7.43-5.91,7.43-10.75v-4.7c0-0.83-0.52-1.58-1.3-1.87l-6-2.25C12.25,2.09,11.75,2.09,11.3,2.26z M12,17 c-2.76,0-5-2.24-5-5s2.24-5,5-5s5,2.24,5,5S14.76,17,12,17z M14,14c-0.2,0.2-0.51,0.2-0.71,0l-1.65-1.65 c-0.09-0.09-0.15-0.22-0.15-0.35V9.5C11.5,9.22,11.72,9,12,9c0.28,0,0.5,0.22,0.5,0.5v2.29l1.5,1.5C14.2,13.49,14.2,13.8,14,14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-airport
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21.48,13.7L13.5,9V3.5C13.5,2.67,12.83,2,12,2c-0.83,0-1.5,0.67-1.5,1.5V9l-7.98,4.7C2.2,13.88,2,14.23,2,14.6 c0,0.7,0.67,1.2,1.34,1.01l7.16-2.1V19l-2.26,1.35C8.09,20.44,8,20.61,8,20.78l0,0.5h0v0.08c0,0.33,0.31,0.57,0.62,0.49l2.92-0.73 L12,21l0.38,0.09c0,0,0,0,0,0l0.42,0.11l1.9,0.48l0,0l0.67,0.17c0.32,0.08,0.62-0.16,0.62-0.49v-0.37c0,0,0,0,0,0v-0.21 c0-0.18-0.09-0.34-0.24-0.43L13.5,19v-5.5l7.16,2.1C21.33,15.8,22,15.3,22,14.6C22,14.23,21.8,13.88,21.48,13.7z",
     :stroke nil,
     :fill nil})
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))))


(helix.core/defnc
 directions-subway-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19l-1.21,0.81C6.11,19.93,6,20.13,6,20.35v0C6,20.71,6.29,21,6.65,21h10.7 c0.36,0,0.65-0.29,0.65-0.65v0c0-0.22-0.11-0.42-0.29-0.54L16.5,19c1.93,0,3.5-1.57,3.5-3.5V6C20,2.5,16.42,2,12,2z M8.5,16 C7.67,16,7,15.33,7,14.5S7.67,13,8.5,13s1.5,0.67,1.5,1.5S9.33,16,8.5,16z M11,10H6V7h5V10z M15.5,16c-0.83,0-1.5-0.67-1.5-1.5 s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,16,15.5,16z M18,10h-5V7h5V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 person-pin-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12 2c-4.2 0-8 3.22-8 8.2 0 3.18 2.45 6.92 7.34 11.22.36.32.97.32 1.33 0C17.55 17.12 20 13.38 20 10.2 20 5.22 16.2 2 12 2zM7.69 12.49C8.88 11.56 10.37 11 12 11s3.12.56 4.31 1.49C15.45 13.98 13.85 15 12 15s-3.45-1.02-4.31-2.51zM12 6c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 trip-origin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 12C2 6.48 6.48 2 12 2s10 4.48 10 10-4.48 10-10 10S2 17.52 2 12zm10 6c3.31 0 6-2.69 6-6s-2.69-6-6-6-6 2.69-6 6 2.69 6 6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 plumbing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.28,4.93l-2.12-2.12c-0.78-0.78-2.05-0.78-2.83,0L11.5,5.64l2.12,2.12l2.12-2.12l3.54,3.54 C20.45,8,20.45,6.1,19.28,4.93z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5.49,13.77c0.59,0.59,1.54,0.59,2.12,0l2.47-2.47L7.96,9.17l-2.47,2.47C4.9,12.23,4.9,13.18,5.49,13.77L5.49,13.77z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.33,8.46l-0.71,0.71l-3.18-3.18C9.85,5.4,8.9,5.4,8.32,5.99c-0.59,0.59-0.59,1.54,0,2.12l3.18,3.18l-7,7 c-0.7,0.7-0.88,1.84-0.29,2.65c0.74,1.03,2.19,1.12,3.05,0.26L16.45,12c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41 l-2.12-2.12C15.35,8.07,14.72,8.07,14.33,8.46z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-car
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.92,2.01C18.72,1.42,18.16,1,17.5,1h-11C5.84,1,5.29,1.42,5.08,2.01L3.11,7.68C3.04,7.89,3,8.11,3,8.34v7.16 C3,16.33,3.67,17,4.5,17h0C5.33,17,6,16.33,6,15.5V15h12v0.5c0,0.82,0.67,1.5,1.5,1.5h0c0.82,0,1.5-0.67,1.5-1.5V8.34 c0-0.22-0.04-0.45-0.11-0.66L18.92,2.01z M6.5,12C5.67,12,5,11.33,5,10.5S5.67,9,6.5,9S8,9.67,8,10.5S7.33,12,6.5,12z M17.5,12 c-0.83,0-1.5-0.67-1.5-1.5S16.67,9,17.5,9S19,9.67,19,10.5S18.33,12,17.5,12z M5,7l1.27-3.82C6.41,2.78,6.79,2.5,7.22,2.5h9.56 c0.43,0,0.81,0.28,0.95,0.68L19,7H5z",
     :stroke nil,
     :fill nil})
   (helix.dom/polygon
    {:points "7,20 11,20 11,18 17,21 13,21 13,23",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 nightlife
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M2.87,5h10.26c0.8,0,1.28,0.89,0.83,1.55L9,14v4h1c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H6c-0.55,0-1-0.45-1-1v0 c0-0.55,0.45-1,1-1h1v-4L2.04,6.55C1.59,5.89,2.07,5,2.87,5z M10.1,9l1.4-2H4.49l1.4,2H10.1z M19,5h1.5C21.33,5,22,5.67,22,6.5v0 C22,7.33,21.33,8,20.5,8H19v9l0,0c0,1.84-1.64,3.28-3.54,2.95c-1.21-0.21-2.2-1.2-2.41-2.41C12.72,15.64,14.16,14,16,14 c0.35,0,0.69,0.06,1,0.17V7C17,5.9,17.9,5,19,5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 breakfast-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,3H6C3.79,3,2,4.79,2,7c0,1.48,0.81,2.75,2,3.45V19c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-8.55c1.19-0.69,2-1.97,2-3.45 C22,4.79,20.21,3,18,3z M15.71,13.7l-3,3c-0.39,0.39-1.02,0.39-1.42,0l-3-3c-0.39-0.39-0.39-1.02,0-1.41l3-3 c0.39-0.39,1.02-0.39,1.41,0l3,3C16.1,12.68,16.1,13.31,15.71,13.7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-play
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 12c0-.76.43-1.42 1.06-1.76.6-.33.94-1.01.94-1.7V6c0-1.1-.9-2-2-2H4c-1.1 0-1.99.89-1.99 1.99v2.55c0 .69.33 1.37.94 1.69C3.58 10.58 4 11.24 4 12s-.43 1.43-1.06 1.76c-.6.33-.94 1.01-.94 1.7v2.25C2 19.1 2.9 20 4 20h16c1.1 0 2-.9 2-2v-2.54c0-.69-.34-1.37-.94-1.7-.63-.34-1.06-1-1.06-1.76zm-5.5 4.1L12 14.5l-2.5 1.61c-.38.24-.87-.11-.75-.55l.75-2.88-2.3-1.88c-.35-.29-.17-.86.29-.89l2.96-.17 1.08-2.75c.17-.42.77-.42.93 0l1.08 2.76 2.96.17c.45.03.64.6.29.89l-2.3 1.88.76 2.86c.12.45-.37.8-.75.55z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 festival
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M23,11v-0.61c0-0.8-0.48-1.54-1.23-1.84c-3.65-1.48-6.81-3.93-8.48-5.37c-0.74-0.64-1.84-0.64-2.58,0 C9.03,4.62,5.88,7.06,2.23,8.55C1.48,8.85,1,9.58,1,10.39V11c0,1.49,0.93,2.75,2.24,3.26c-0.03,1.68-0.16,3.55-0.52,5.29 C2.46,20.81,3.38,22,4.67,22h14.67c1.29,0,2.21-1.19,1.95-2.45c-0.36-1.75-0.5-3.62-0.52-5.29C22.07,13.75,23,12.49,23,11z M12,4.71c1.33,1.14,3.49,2.84,6.11,4.29H5.89C8.51,7.55,10.67,5.85,12,4.71z M13,11h3c0,0.83-0.67,1.5-1.5,1.5S13,11.83,13,11z M9.5,12.5C8.67,12.5,8,11.83,8,11h3C11,11.83,10.33,12.5,9.5,12.5z M6,11c0,0.83-0.67,1.5-1.5,1.5S3,11.83,3,11H6z M4.66,20 c0.39-1.86,0.54-3.82,0.57-5.58c0.68-0.15,1.29-0.49,1.76-0.98c0.25,0.25,0.54,0.45,0.85,0.62c-0.1,1.87-0.26,4-0.52,5.93H4.66z M9.35,20c0.24-1.83,0.39-3.78,0.48-5.53c0.84-0.08,1.61-0.45,2.17-1.02c0.56,0.57,1.32,0.94,2.17,1.02 c0.1,1.75,0.24,3.7,0.48,5.53H9.35z M16.67,20c-0.27-1.94-0.43-4.07-0.52-5.93c0.31-0.17,0.61-0.37,0.85-0.62 c0.47,0.48,1.08,0.83,1.76,0.98c0.03,1.76,0.18,3.72,0.57,5.58H16.67z M19.5,12.5c-0.83,0-1.5-0.67-1.5-1.5h3 C21,11.83,20.33,12.5,19.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 castle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,9c-0.55,0-1,0.45-1,1v1h-2V4c0-0.55-0.45-1-1-1s-1,0.45-1,1v1h-2V4c0-0.55-0.45-1-1-1s-1,0.45-1,1v1h-2V4 c0-0.55-0.45-1-1-1S9,3.45,9,4v1H7V4c0-0.55-0.45-1-1-1S5,3.45,5,4v7H3v-1c0-0.55-0.45-1-1-1s-1,0.45-1,1v9c0,1.1,0.9,2,2,2h7v-3 c0-1.1,0.9-2,2-2s2,0.9,2,2v3h7c1.1,0,2-0.9,2-2v-9C23,9.45,22.55,9,22,9z M11,12H9V9h2V12z M15,12h-2V9h2V12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 pin-drop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6 20h12c.55 0 1 .45 1 1s-.45 1-1 1H6c-.55 0-1-.45-1-1s.45-1 1-1zm6-13c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0-5c3.27 0 7 2.46 7 7.15 0 2.98-2.13 6.12-6.39 9.39-.36.28-.86.28-1.22 0C7.13 15.26 5 12.13 5 9.15 5 4.46 8.73 2 12 2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-mall
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 6h-2c0-2.76-2.24-5-5-5S7 3.24 7 6H5c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-7-3c1.66 0 3 1.34 3 3H9c0-1.66 1.34-3 3-3zm0 10c-2.33 0-4.29-1.59-4.84-3.75-.17-.63.32-1.25.97-1.25.47 0 .85.34.98.8.35 1.27 1.51 2.2 2.89 2.2s2.54-.93 2.89-2.2c.13-.46.51-.8.98-.8.65 0 1.13.62.97 1.25C16.29 11.41 14.33 13 12 13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 snowmobile
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11,6c0,0.55,0.45,1,1,1h1.25l1.45,1.3L11,11l-9.12-0.96C0.88,9.93,0,10.72,0,11.73c0,0.75,0.49,1.41,1.21,1.63l3.33,1 l-3.49,1.88C-0.77,17.22-0.07,20,2,20h6c2.21,0,4-1.79,4-4h4l2,2h-2c-0.55,0-1,0.45-1,1s0.45,1,1,1h5c1.13,0,2.11-0.62,2.63-1.55 c0.36-0.65-0.15-1.45-0.9-1.45c-0.34,0-0.68,0.16-0.84,0.47C21.72,17.78,21.38,18,21,18h-0.17l-2.2-2.2C20.58,15.37,22,14.4,22,13 c0-0.89-7.72-7.75-7.72-7.75C14.1,5.09,13.87,5,13.62,5H12C11.45,5,11,5.45,11,6z M8,18H2l5.25-2.83L10,16C10,17.1,9.11,18,8,18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-dining
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.1 13.34l2.83-2.83-6.19-6.18c-.48-.48-1.31-.35-1.61.27-.71 1.49-.45 3.32.78 4.56l4.19 4.18zm6.78-1.81c1.53.71 3.68.21 5.27-1.38 1.91-1.91 2.28-4.65.81-6.12-1.46-1.46-4.2-1.1-6.12.81-1.59 1.59-2.09 3.74-1.38 5.27l-9.05 9.05c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 14.41l6.18 6.18c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L13.41 13l1.47-1.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warehouse
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,19V8.35c0-0.82-0.5-1.55-1.26-1.86l-8-3.2c-0.48-0.19-1.01-0.19-1.49,0l-8,3.2C2.5,6.8,2,7.54,2,8.35V19 c0,1.1,0.9,2,2,2h3v-9h10v9h3C21.1,21,22,20.1,22,19z M11,19H9v2h2V19z M13,16h-2v2h2V16z M15,19h-2v2h2V19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 menu-book
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.5,4.5c-1.95,0-4.05,0.4-5.5,1.5c-1.45-1.1-3.55-1.5-5.5-1.5c-1.45,0-2.99,0.22-4.28,0.79C1.49,5.62,1,6.33,1,7.14 l0,11.28c0,1.3,1.22,2.26,2.48,1.94C4.46,20.11,5.5,20,6.5,20c1.56,0,3.22,0.26,4.56,0.92c0.6,0.3,1.28,0.3,1.87,0 c1.34-0.67,3-0.92,4.56-0.92c1,0,2.04,0.11,3.02,0.36c1.26,0.33,2.48-0.63,2.48-1.94l0-11.28c0-0.81-0.49-1.52-1.22-1.85 C20.49,4.72,18.95,4.5,17.5,4.5z M21,17.23c0,0.63-0.58,1.09-1.2,0.98c-0.75-0.14-1.53-0.2-2.3-0.2c-1.7,0-4.15,0.65-5.5,1.5V8 c1.35-0.85,3.8-1.5,5.5-1.5c0.92,0,1.83,0.09,2.7,0.28c0.46,0.1,0.8,0.51,0.8,0.98V17.23z",
     :stroke nil,
     :fill nil})
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M13.98,11.01c-0.32,0-0.61-0.2-0.71-0.52c-0.13-0.39,0.09-0.82,0.48-0.94c1.54-0.5,3.53-0.66,5.36-0.45 c0.41,0.05,0.71,0.42,0.66,0.83c-0.05,0.41-0.42,0.71-0.83,0.66c-1.62-0.19-3.39-0.04-4.73,0.39 C14.13,10.99,14.05,11.01,13.98,11.01z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M13.98,13.67c-0.32,0-0.61-0.2-0.71-0.52c-0.13-0.39,0.09-0.82,0.48-0.94c1.53-0.5,3.53-0.66,5.36-0.45 c0.41,0.05,0.71,0.42,0.66,0.83c-0.05,0.41-0.42,0.71-0.83,0.66c-1.62-0.19-3.39-0.04-4.73,0.39 C14.13,13.66,14.05,13.67,13.98,13.67z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M13.98,16.33c-0.32,0-0.61-0.2-0.71-0.52c-0.13-0.39,0.09-0.82,0.48-0.94c1.53-0.5,3.53-0.66,5.36-0.45 c0.41,0.05,0.71,0.42,0.66,0.83c-0.05,0.41-0.42,0.7-0.83,0.66c-1.62-0.19-3.39-0.04-4.73,0.39 C14.13,16.32,14.05,16.33,13.98,16.33z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 edit-road
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17,4L17,4c-0.55,0-1,0.45-1,1v6.9l2-2V5C18,4.45,17.55,4,17,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,20L5,20c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1h0C4.45,4,4,4.45,4,5v14C4,19.55,4.45,20,5,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,8L11,8c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C10,7.55,10.45,8,11,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,14L11,14c0.55,0,1-0.45,1-1v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C10,13.55,10.45,14,11,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,20L11,20c0.55,0,1-0.45,1-1v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2C10,19.55,10.45,20,11,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.56,12.59l-1.15-1.15c-0.59-0.59-1.54-0.59-2.12,0L14,16.73v2.77c0,0.28,0.22,0.5,0.5,0.5h2.77l5.29-5.29 C23.15,14.12,23.15,13.17,22.56,12.59z M16.58,18.45h-1.03v-1.03L19,13.97L20.03,15L16.58,18.45z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-rickshaw
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,11.18V9.72c0-0.47-0.16-0.92-0.46-1.28L16.6,3.72C16.22,3.26,15.66,3,15.06,3H3C1.9,3,1,3.9,1,5v8c0,1.1,0.9,2,2,2 h0.18C3.6,16.16,4.7,17,6,17s2.4-0.84,2.82-2h8.37c0.41,1.16,1.51,2,2.82,2c1.66,0,3-1.34,3-3C23,12.7,22.16,11.6,21,11.18z M18.4,9H16V6.12L18.4,9z M4,5h3v4H3V6C3,5.45,3.45,5,4,5z M6,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S6.55,15,6,15z M9,13v-2 h2c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H9V5h4c0.55,0,1,0.45,1,1v7H9z M20,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S20.55,15,20,15z",
     :stroke nil,
     :fill nil})
   (helix.dom/polygon
    {:points "7,20 11,20 11,18 17,21 13,21 13,23",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 place
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:enable-background "new",
     :d
     "M12 2c-4.2 0-8 3.22-8 8.2 0 3.18 2.45 6.92 7.34 11.23.38.33.95.33 1.33 0C17.55 17.12 20 13.38 20 10.2 20 5.22 16.2 2 12 2zm0 10c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 near-me
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.75 3.94L4.07 10.08c-.83.35-.81 1.53.02 1.85L9.43 14c.26.1.47.31.57.57l2.06 5.33c.32.84 1.51.86 1.86.03l6.15-14.67c.33-.83-.5-1.66-1.32-1.32z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ramp-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,21c-0.55,0-1-0.45-1-1V6.83l-0.88,0.88C9.73,8.1,9.1,8.1,8.71,7.71c-0.39-0.39-0.39-1.02,0-1.41l2.59-2.59 c0.39-0.39,1.02-0.39,1.41,0l2.59,2.59c0.39,0.39,0.39,1.02,0,1.41c-0.39,0.39-1.02,0.39-1.41,0L13,6.83v0V9 c0,3.62,2.89,6.22,4.97,7.62c0.52,0.35,0.59,1.09,0.14,1.53c-0.33,0.33-0.87,0.4-1.26,0.13c-1.59-1.06-2.89-2.28-3.85-3.59l0,5.3 C13,20.55,12.55,21,12,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 multiple-stop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,5.21c0-0.45,0.54-0.67,0.85-0.35l2.79,2.79c0.2,0.2,0.2,0.51,0,0.71l-2.79,2.79C17.54,11.46,17,11.24,17,10.79V9h-3 c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h3V5.21z M10,7C9.45,7,9,7.45,9,8s0.45,1,1,1s1-0.45,1-1S10.55,7,10,7z M6,7 C5.45,7,5,7.45,5,8s0.45,1,1,1s1-0.45,1-1S6.55,7,6,7z M7,17h3c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H7v-1.79 c0-0.45-0.54-0.67-0.85-0.35l-2.79,2.79c-0.2,0.2-0.2,0.51,0,0.71l2.79,2.79C6.46,19.46,7,19.24,7,18.79V17z M14,17 c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1s-1,0.45-1,1C13,16.55,13.45,17,14,17z M18,17c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1 s-1,0.45-1,1C17,16.55,17.45,17,18,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 directions-transit-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C8,2,4,2.5,4,6v9.5C4,17.43,5.57,19,7.5,19l-1.21,0.81C6.11,19.93,6,20.13,6,20.35v0C6,20.71,6.29,21,6.65,21h10.7 c0.36,0,0.65-0.29,0.65-0.65v0c0-0.22-0.11-0.42-0.29-0.54L16.5,19c1.93,0,3.5-1.57,3.5-3.5V6C20,2.5,16.42,2,12,2z M8.5,16 C7.67,16,7,15.33,7,14.5S7.67,13,8.5,13s1.5,0.67,1.5,1.5S9.33,16,8.5,16z M11,10H6V7h5V10z M15.5,16c-0.83,0-1.5-0.67-1.5-1.5 s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5S16.33,16,15.5,16z M18,10h-5V7h5V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 electrical-services
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M21,14c0-0.55-0.45-1-1-1h-2v2h2C20.55,15,21,14.55,21,14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M20,17h-2v2h2c0.55,0,1-0.45,1-1C21,17.45,20.55,17,20,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,12h-2c-1.1,0-2,0.9-2,2h-1c-0.55,0-1,0.45-1,1v2c0,0.55,0.45,1,1,1h1c0,1.1,0.9,2,2,2h2c0.55,0,1-0.45,1-1v-6 C17,12.45,16.55,12,16,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,13c0-1.1,0.9-2,2-2h1.5c1.93,0,3.5-1.57,3.5-3.5S10.43,4,8.5,4H5C4.45,4,4,4.45,4,5c0,0.55,0.45,1,1,1h3.5 C9.33,6,10,6.67,10,7.5S9.33,9,8.5,9H7c-2.21,0-4,1.79-4,4c0,2.21,1.79,4,4,4h2v-2H7C5.9,15,5,14.1,5,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-taxi
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.92 6.01C18.72 5.42 18.16 5 17.5 5H15V4c0-.55-.45-1-1-1h-4c-.55 0-1 .45-1 1v1H6.5c-.66 0-1.21.42-1.42 1.01l-1.97 5.67c-.07.21-.11.43-.11.66v7.16c0 .83.67 1.5 1.5 1.5S6 20.33 6 19.5V19h12v.5c0 .82.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5v-7.16c0-.22-.04-.45-.11-.66l-1.97-5.67zM6.5 16c-.83 0-1.5-.67-1.5-1.5S5.67 13 6.5 13s1.5.67 1.5 1.5S7.33 16 6.5 16zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 11l1.5-4.5h11L19 11H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sos
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.5,7h-3c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h3c1.1,0,2-0.9,2-2V9C15.5,7.9,14.6,7,13.5,7z M13.5,15h-3V9h3V15z M3,9v2h2 c1.1,0,2,0.9,2,2v2c0,1.1-0.9,2-2,2H2c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h3v-2H3c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h3 c0.55,0,1,0.45,1,1S6.55,9,6,9H3z M19,9v2h2c1.1,0,2,0.9,2,2v2c0,1.1-0.9,2-2,2h-3c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h3v-2h-2 c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h3c0.55,0,1,0.45,1,1s-0.45,1-1,1H19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 volunteer-activism
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,11L3,11c-1.1,0-2,0.9-2,2v7c0,1.1,0.9,2,2,2h0c1.1,0,2-0.9,2-2v-7C5,11.9,4.1,11,3,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,5.3C10,3.45,11.45,2,13.3,2c1.04,0,2.05,0.49,2.7,1.25C16.65,2.49,17.66,2,18.7,2C20.55,2,22,3.45,22,5.3 c0,2.1-2.5,4.51-5.33,7.09c-0.38,0.35-0.97,0.35-1.35,0C12.5,9.81,10,7.4,10,5.3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.99,17h-6.83c-0.11,0-0.22-0.02-0.33-0.06l-1.47-0.51c-0.26-0.09-0.39-0.37-0.3-0.63l0,0c0.09-0.26,0.38-0.4,0.64-0.3 l1.12,0.43c0.11,0.04,0.24,0.07,0.36,0.07h2.63c0.65,0,1.18-0.53,1.18-1.18v0c0-0.49-0.31-0.93-0.77-1.11L9.3,11.13 C9.08,11.04,8.84,11,8.6,11H7v9.02l6.37,1.81c0.41,0.12,0.85,0.1,1.25-0.05L22,19l0,0C22,17.89,21.1,17,19.99,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-police
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14.5,12.59l0.63,2.73c0.1,0.43-0.37,0.77-0.75,0.54L12,14.42l-2.39,1.44c-0.38,0.23-0.85-0.11-0.75-0.54L9.5,12.6 l-2.1-1.81C7.06,10.5,7.24,9.95,7.68,9.91l2.78-0.24l1.08-2.56c0.17-0.41,0.75-0.41,0.92,0l1.08,2.55l2.78,0.24 c0.44,0.04,0.62,0.59,0.28,0.88L14.5,12.59z M4.19,4.47C3.47,4.79,3,5.51,3,6.3V11c0,5.55,3.84,10.74,9,12c5.16-1.26,9-6.45,9-12 V6.3c0-0.79-0.47-1.51-1.19-1.83l-7-3.11c-0.52-0.23-1.11-0.23-1.62,0L4.19,4.47z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-transit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2c-4.42 0-8 .5-8 4v9.5C4 17.43 5.57 19 7.5 19l-1.15 1.15c-.31.31-.09.85.36.85H17.3c.45 0 .67-.54.35-.85L16.5 19c1.93 0 3.5-1.57 3.5-3.5V6c0-3.5-3.58-4-8-4zM7.5 17c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm3.5-6H6V6h5v5zm5.5 6c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-6h-5V6h5v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mosque
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M7,8h10c0.29,0,0.57,0.06,0.84,0.13C17.93,7.8,18,7.46,18,7.09c0-1.31-0.65-2.53-1.74-3.25L12,1L7.74,3.84 C6.65,4.56,6,5.78,6,7.09C6,7.46,6.07,7.8,6.16,8.13C6.43,8.06,6.71,8,7,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M24,7c0-1.1-2-3-2-3s-2,1.9-2,3c0,0.74,0.4,1.38,1,1.72V13h-2v-2c0-1.1-0.9-2-2-2H7c-1.1,0-2,0.9-2,2v2H3V8.72 C3.6,8.38,4,7.74,4,7c0-1.1-2-3-2-3S0,5.9,0,7c0,0.74,0.4,1.38,1,1.72V21h9v-4c0-1.1,0.9-2,2-2s2,0.9,2,2v4h9V8.72 C23.6,8.38,24,7.74,24,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-bar
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 4.45c0-.8-.65-1.45-1.45-1.45H4.45C3.65 3 3 3.65 3 4.45c0 .35.13.7.37.96L11 14v5H7c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1h-4v-5l7.63-8.59c.24-.26.37-.61.37-.96zM7.43 7L5.66 5h12.69l-1.78 2H7.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 streetview
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.56 14.33c-.34.27-.56.7-.56 1.17V21h7c1.1 0 2-.9 2-2v-5.98c-.94-.33-1.95-.52-3-.52-2.03 0-3.93.7-5.44 1.83z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "5", :cy "6", :cx "18", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M11.5 6c0-1.08.27-2.1.74-3H5c-1.1 0-2 .9-2 2v14c0 .55.23 1.05.59 1.41l9.82-9.82C12.23 9.42 11.5 7.8 11.5 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 local-convenience-store
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21.9,7.89l-1.05-3.37c-0.22-0.9-1-1.52-1.91-1.52H5.05c-0.9,0-1.69,0.63-1.9,1.52L2.1,7.89C1.64,9.86,2.95,11,3,11.06V19 c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-7.94C22.12,9.94,22.09,8.65,21.9,7.89z M13,5h1.96l0.54,3.52C15.59,9.23,15.11,10,14.22,10 C13.55,10,13,9.41,13,8.69V5z M6.44,8.86C6.36,9.51,5.84,10,5.23,10C4.3,10,3.88,9.03,4.04,8.36L5.05,5h1.97L6.44,8.86z M10.5,16H9 v1h1.5c0.28,0,0.5,0.22,0.5,0.5l0,0c0,0.28-0.22,0.5-0.5,0.5h-2C8.22,18,8,17.78,8,17.5v-2C8,15.22,8.22,15,8.5,15H10v-1H8.5 C8.22,14,8,13.78,8,13.5v0C8,13.22,8.22,13,8.5,13h2c0.28,0,0.5,0.22,0.5,0.5v2C11,15.78,10.78,16,10.5,16z M11,8.69 C11,9.41,10.45,10,9.71,10c-0.75,0-1.3-0.7-1.22-1.48L9.04,5H11V8.69z M15.5,18L15.5,18c-0.28,0-0.5-0.22-0.5-0.5V16h-1.5 c-0.28,0-0.5-0.22-0.5-0.5v-2c0-0.28,0.22-0.5,0.5-0.5h0c0.28,0,0.5,0.22,0.5,0.5V15h1v-1.5c0-0.28,0.22-0.5,0.5-0.5h0 c0.28,0,0.5,0.22,0.5,0.5v4C16,17.78,15.78,18,15.5,18z M18.77,10c-0.61,0-1.14-0.49-1.21-1.14L16.98,5l1.93-0.01l1.05,3.37 C20.12,9.03,19.71,10,18.77,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 kebab-dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7.75,13v1H8.5c1.38,0,2.5,1.12,2.5,2.5c0,1.38-1.12,2.5-2.5,2.5H7.75v3.25C7.75,22.66,7.41,23,7,23s-0.75-0.34-0.75-0.75 V19H5.5C4.12,19,3,17.88,3,16.5C3,15.12,4.12,14,5.5,14h0.75v-1H4c-0.55,0-1-0.45-1-1V9c0-0.55,0.45-1,1-1h2.25V7H5.5 C4.12,7,3,5.88,3,4.5C3,3.12,4.12,2,5.5,2h0.75V1.75C6.25,1.34,6.59,1,7,1s0.75,0.34,0.75,0.75V2H8.5C9.88,2,11,3.12,11,4.5 C11,5.88,9.88,7,8.5,7H7.75v1H10c0.55,0,1,0.45,1,1v3c0,0.55-0.45,1-1,1H7.75z M17.75,13v1h0.75c1.38,0,2.5,1.12,2.5,2.5 c0,1.38-1.12,2.5-2.5,2.5h-0.75v3.25c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V19H15.5c-1.38,0-2.5-1.12-2.5-2.5 c0-1.38,1.12-2.5,2.5-2.5h0.75v-1H14c-0.55,0-1-0.45-1-1V9c0-0.55,0.45-1,1-1h2.25V7H15.5C14.12,7,13,5.88,13,4.5 C13,3.12,14.12,2,15.5,2h0.75V1.75C16.25,1.34,16.59,1,17,1s0.75,0.34,0.75,0.75V2h0.75C19.88,2,21,3.12,21,4.5 C21,5.88,19.88,7,18.5,7h-0.75v1H20c0.55,0,1,0.45,1,1v3c0,0.55-0.45,1-1,1H17.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pest-control-rodent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21.31,17.38l-2.39-2.13C19.44,12.89,17.56,11,15.5,11c-1.16,0-3.5,0.9-3.5,3.5c0,0.81,0.27,1.55,0.74,2.15 c0.15,0.2,0.14,0.48-0.04,0.66l0,0c-0.21,0.21-0.56,0.19-0.75-0.04C11.35,16.5,11,15.54,11,14.5c0-1.7,0.96-3.17,2.35-3.93 c-0.7-0.36-1.48-0.57-2.28-0.57c-2.38,0-4.37,1.65-4.91,3.87c-1.33-0.39-2.28-1.66-2.15-3.14C4.15,9.16,5.54,8,7.11,8l2,0 c1.58,0,2.75-0.95,2.87-2.25C12.13,4.25,10.96,3,9.5,3H8.05c-0.5,0-0.96,0.34-1.04,0.83C6.91,4.46,7.39,5,8,5h1.5 C9.78,5,10,5.22,10,5.5C10,5.78,9.78,6,9.5,6L7.16,6c-2.67,0-4.99,2.03-5.15,4.7C1.86,13.25,3.62,15.42,6,15.9v0.03 C6,18.73,8.27,21,11.07,21h8.86C21.8,21,22.74,18.66,21.31,17.38z M18,19c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1 C19,18.55,18.55,19,18,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 ramp-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,21c0.55,0,1-0.45,1-1V6.83l0.88,0.88c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41l-2.59-2.59 c-0.39-0.39-1.02-0.39-1.41,0L8.71,6.29c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0L11,6.83v0V9 c0,3.62-2.89,6.22-4.97,7.62c-0.52,0.35-0.59,1.09-0.14,1.53c0.33,0.33,0.87,0.4,1.26,0.13c1.59-1.06,2.89-2.28,3.85-3.59l0,5.3 C11,20.55,11.45,21,12,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dry-cleaning
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.56,11.36L13,8.44V7c0-0.55-0.45-1-1-1s-1-0.45-1-1s0.45-1,1-1c0.38,0,0.72,0.22,0.88,0.53C13.04,4.84,13.39,5,13.73,5 c0.74,0,1.26-0.79,0.91-1.44c-0.6-1.1-1.86-1.78-3.24-1.51c-1.17,0.23-2.12,1.2-2.34,2.37C8.77,5.98,9.67,7.35,11,7.82v0.63 l-6.56,2.92C3.56,11.75,3,12.62,3,13.57v0.01C3,14.92,4.08,16,5.42,16H7v4c0,1.1,0.9,2,2,2h6c1.1,0,2-0.9,2-2v-4h1.58 c1.34,0,2.42-1.08,2.42-2.42v-0.01C21,12.62,20.44,11.75,19.56,11.36z M18.58,14h-1.86c-0.35-0.6-0.98-1-1.72-1H9 c-0.74,0-1.38,0.4-1.72,1H5.42c-0.46,0-0.58-0.65-0.17-0.81l6.75-3l6.75,3C19.17,13.38,19.03,14,18.58,14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 directions-bus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 16c0 .88.39 1.67 1 2.22v1.28c0 .83.67 1.5 1.5 1.5S8 20.33 8 19.5V19h8v.5c0 .82.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5v-1.28c.61-.55 1-1.34 1-2.22V6c0-3.5-3.58-4-8-4s-8 .5-8 4v10zm3.5 1c-.83 0-1.5-.67-1.5-1.5S6.67 14 7.5 14s1.5.67 1.5 1.5S8.33 17 7.5 17zm9 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm1.5-6H6V6h12v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 theater-comedy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,2h-8c-1.1,0-2,0.9-2,2v3.5h1.5c1.1,0,2,0.9,2,2v4.95c1.04,0.48,2.24,0.68,3.5,0.47c2.93-0.49,5-3.17,5-6.14V4 C23,2.9,22.1,2,21,2z M14,6.5c0-0.55,0.45-1,1-1s1,0.45,1,1s-0.45,1-1,1S14,7.05,14,6.5z M18.85,10.88h-3.72 c-0.38,0-0.63-0.41-0.44-0.75C15.08,9.47,15.96,9,16.99,9s1.91,0.47,2.3,1.14C19.48,10.47,19.23,10.88,18.85,10.88z M19,7.5 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S19.55,7.5,19,7.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,9H3c-1.1,0-2,0.9-2,2v4.79c0,3.05,2.19,5.77,5.21,6.16C9.87,22.42,13,19.57,13,16v-5C13,9.9,12.1,9,11,9z M4,13.5 c0-0.55,0.45-1,1-1s1,0.45,1,1s-0.45,1-1,1S4,14.05,4,13.5z M9.3,16.75c-0.38,0.67-1.27,1.14-2.3,1.14s-1.91-0.47-2.3-1.14 C4.51,16.41,4.76,16,5.14,16h3.72C9.24,16,9.49,16.41,9.3,16.75z M9,14.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S9.55,14.5,9,14.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 factory
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,10V8.48c0-0.71-0.71-1.19-1.37-0.93L9,9V8.52C9,7.8,8.27,7.31,7.61,7.6L3.21,9.48C2.48,9.8,2,10.52,2,11.32V20 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V10H14z M9,17c0,0.55-0.45,1-1,1s-1-0.45-1-1v-2c0-0.55,0.45-1,1-1s1,0.45,1,1V17z M13,17 c0,0.55-0.45,1-1,1s-1-0.45-1-1v-2c0-0.55,0.45-1,1-1s1,0.45,1,1V17z M17,17c0,0.55-0.45,1-1,1s-1-0.45-1-1v-2c0-0.55,0.45-1,1-1 s1,0.45,1,1V17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20.12,2h-1.23c-0.51,0-0.93,0.38-0.99,0.88L17.2,8.5h4.6l-0.69-5.62C21.05,2.38,20.62,2,20.12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-moped
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,5c0-1.1-0.9-2-2-2h-2c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2v2.65L13.52,12H10V8c0-0.55-0.45-1-1-1H6 c-2.21,0-4,1.79-4,4v3h2c0,1.66,1.34,3,3,3s3-1.34,3-3h4.48L19,8.35V5z M7,15c-0.55,0-1-0.45-1-1h2C8,14.55,7.55,15,7,15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,4H6C5.45,4,5,4.45,5,5v0c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v0C10,4.45,9.55,4,9,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,11c-1.66,0-3,1.34-3,3s1.34,3,3,3s3-1.34,3-3S20.66,11,19,11z M19,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S19.55,15,19,15z",
      :stroke nil,
      :fill nil}))
   (helix.dom/polygon
    {:points "7,20 11,20 11,18 17,21 13,21 13,23",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 subway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "8.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "15.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M7.01 9h10v5h-10zM17.8 2.8C16 2.09 13.86 2 12 2s-4 .09-5.8.8C3.53 3.84 2 6.05 2 8.86V22h20V8.86c0-2.81-1.53-5.02-4.2-6.06zm.2 12.7c0 1.54-1.16 2.79-2.65 2.96l1.15 1.16V20h-1.67l-1.5-1.5h-2.66L9.17 20H7.5v-.38l1.15-1.16C7.16 18.29 6 17.04 6 15.5V9c0-2.63 3-3 6-3s6 .37 6 3v6.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-meals
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21,18.17l-2-2V14h-1c-1.1,0-2-0.9-2-2V6c0-1.49,1.6-3.32,3.76-3.85C20.39,2,21,2.48,21,3.13V18.17z M21.19,22.61 c-0.39,0.39-1.02,0.39-1.41,0l-9.76-9.76C9.69,12.94,9.36,13,9,13v8c0,0.55-0.45,1-1,1s-1-0.45-1-1v-8c-2.21,0-4-1.79-4-4V5.83 L1.39,4.22C1,3.83,1,3.2,1.39,2.81c0.39-0.39,1.02-0.39,1.41,0l18.38,18.38C21.58,21.58,21.58,22.22,21.19,22.61z M6.17,9L5,7.83V9 H6.17z M13,9V3c0-0.55-0.45-1-1-1s-1,0.45-1,1v5.17l1.85,1.85C12.94,9.69,13,9.36,13,9z M9,3c0-0.55-0.45-1-1-1S7,2.45,7,3v1.17l2,2 V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airlines
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.59,4h-5.01c-0.99,0-1.91,0.49-2.47,1.3L2,20h17l2.56-13.63C21.79,5.14,20.84,4,19.59,4z M14.5,14 c-1.38,0-2.5-1.12-2.5-2.5c0-1.38,1.12-2.5,2.5-2.5s2.5,1.12,2.5,2.5C17,12.88,15.88,14,14.5,14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-stops
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15,18c0,0.55-0.45,1-1,1h-4c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h1c-0.47-4.21-3.89-7.55-8.12-7.96 C2.37,8.99,2,8.56,2,8.05c0-0.59,0.52-1.06,1.11-1C7.03,7.44,10.37,9.87,12,13.3c1.13-2.43,2.99-4.25,4.78-5.52l-1.92-1.92 C14.54,5.54,14.76,5,15.21,5h5.29C20.78,5,21,5.22,21,5.5v5.29c0,0.45-0.54,0.67-0.85,0.35l-1.94-1.94C15.93,10.78,13.45,13.3,13,17 h1C14.55,17,15,17.45,15,18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 turn-sharp-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,6.83l-0.88,0.88c-0.39,0.39-1.02,0.39-1.41,0c-0.39-0.39-0.39-1.02,0-1.41l2.59-2.59c0.39-0.39,1.02-0.39,1.41,0 l2.59,2.59c0.39,0.39,0.39,1.02,0,1.41c-0.39,0.39-1.02,0.39-1.41,0L18,6.83V13c0,1.1-0.9,2-2,2H8v5c0,0.55-0.45,1-1,1h0 c-0.55,0-1-0.45-1-1v-5c0-1.1,0.9-2,2-2h8V6.83L16,6.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 local-post-office
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-.4 4.25l-6.54 4.09c-.65.41-1.47.41-2.12 0L4.4 8.25c-.25-.16-.4-.43-.4-.72 0-.67.73-1.07 1.3-.72L12 11l6.7-4.19c.57-.35 1.3.05 1.3.72 0 .29-.15.56-.4.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-railway
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 15.5C4 17.43 5.57 19 7.5 19L6 20.5v.5h12v-.5L16.5 19c1.93 0 3.5-1.57 3.5-3.5V5c0-3.5-3.58-4-8-4s-8 .5-8 4v10.5zm8 1.5c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm6-7H6V5h12v5zM4 15.5C4 17.43 5.57 19 7.5 19l-1.14 1.15c-.32.31-.1.85.35.85h10.58c.45 0 .67-.54.35-.85L16.5 19c1.93 0 3.5-1.57 3.5-3.5V5c0-3.5-3.58-4-8-4s-8 .5-8 4v10.5zm8 1.5c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm6-7H6V5h12v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 temple-buddhist
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21.85,9.01c-0.41,0-0.82,0.24-0.95,0.63C20.64,10.43,19.89,11,19.02,11H4.98c-0.87,0-1.62-0.57-1.88-1.36 C2.97,9.25,2.57,9.02,2.16,9.02h0C1.5,9.02,1,9.66,1.21,10.28c0.43,1.27,1.48,2.24,2.79,2.58V20c0,1.1,0.9,2,2,2h4l0-2.89 c0-1,0.68-1.92,1.66-2.08C12.92,16.82,14,17.79,14,19v3h4c1.1,0,2-0.9,2-2v-7.14c0.46-0.12,2.22-0.76,2.81-2.58 C23.01,9.65,22.51,9,21.85,9.01L21.85,9.01z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M6,8.86V10h12V8.86c0.46-0.12,2.22-0.76,2.81-2.58c0.2-0.63-0.3-1.27-0.96-1.27l0,0c-0.41,0-0.82,0.24-0.95,0.63 C18.64,6.43,17.89,7,17.02,7H6.98C6.11,7,5.36,6.43,5.1,5.64C4.97,5.25,4.57,5.02,4.16,5.02h0C3.5,5.02,3,5.66,3.21,6.28 C3.64,7.55,4.69,8.53,6,8.86z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M11.2,2.07L8.25,6h7.5L12.8,2.07C12.4,1.53,11.6,1.53,11.2,2.07z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 person-pin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 2H5c-1.11 0-2 .9-2 2v14c0 1.1.9 2 2 2h4l2.29 2.29c.39.39 1.02.39 1.41 0L15 20h4c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 3.3c1.49 0 2.7 1.21 2.7 2.7s-1.21 2.7-2.7 2.7S9.3 9.49 9.3 8s1.21-2.7 2.7-2.7zM18 16H6v-.9c0-2 4-3.1 6-3.1s6 1.1 6 3.1v.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 badge
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,7h-5V4c0-1.1-0.9-2-2-2h-2C9.9,2,9,2.9,9,4v3H4C2.9,7,2,7.9,2,9v11c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V9 C22,7.9,21.1,7,20,7z M9,12c0.83,0,1.5,0.67,1.5,1.5c0,0.83-0.67,1.5-1.5,1.5s-1.5-0.67-1.5-1.5C7.5,12.67,8.17,12,9,12z M12,18H6 v-0.43c0-0.6,0.36-1.15,0.92-1.39C7.56,15.9,8.26,15.75,9,15.75s1.44,0.15,2.08,0.43c0.55,0.24,0.92,0.78,0.92,1.39V18z M13,9h-2V4 h2V9z M17.25,16.5h-2.5c-0.41,0-0.75-0.34-0.75-0.75v0c0-0.41,0.34-0.75,0.75-0.75h2.5c0.41,0,0.75,0.34,0.75,0.75v0 C18,16.16,17.66,16.5,17.25,16.5z M17.25,13.5h-2.5c-0.41,0-0.75-0.34-0.75-0.75v0c0-0.41,0.34-0.75,0.75-0.75h2.5 c0.41,0,0.75,0.34,0.75,0.75v0C18,13.16,17.66,13.5,17.25,13.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 car-repair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M7,15v-1h10v1c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V8.69c0,0-1.34-4.03-1.56-4.69c-0.05-0.16-0.12-0.29-0.19-0.4 c-0.02-0.02-0.03-0.04-0.05-0.07C16.82,3.01,16.28,3,16.28,3H7.72c0,0-0.54,0.01-0.92,0.54C6.78,3.56,6.77,3.58,6.75,3.6 C6.68,3.71,6.61,3.84,6.56,4C6.34,4.66,5,8.69,5,8.69V15c0,0.55,0.45,1,1,1h0C6.55,16,7,15.55,7,15z M9,11.5c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S9.55,11.5,9,11.5z M15,11.5c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,11.5,15,11.5z M8.33,5h7.34 l0.23,0.69L16.33,7H7.67L8.33,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,18.01L4,18.01C4,18.55,4.45,19,4.99,19H11v2.01c0,0.55,0.45,0.99,0.99,0.99h0.01c0.55,0,0.99-0.45,0.99-0.99V19h6.01 c0.55,0,0.99-0.45,0.99-0.99v0c0-0.55-0.45-0.99-0.99-0.99H4.99C4.45,17.01,4,17.46,4,18.01z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 local-hospital
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-1.99.9-1.99 2L3 19c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-2 11h-3v3c0 .55-.45 1-1 1h-2c-.55 0-1-.45-1-1v-3H7c-.55 0-1-.45-1-1v-2c0-.55.45-1 1-1h3V7c0-.55.45-1 1-1h2c.55 0 1 .45 1 1v3h3c.55 0 1 .45 1 1v2c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wind-power
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9,3H5C4.45,3,4,3.45,4,4v0c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v0C10,3.45,9.55,3,9,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,7H2C1.45,7,1,7.45,1,8v0c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v0C6,7.45,5.55,7,5,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,21h3c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H4c-0.55,0-1,0.45-1,1v0C3,20.55,3.45,21,4,21z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.73,10.61c0.75,0.23,1.3,0.78,1.57,1.46l4.27-7.11c0.65-1.08,0.3-2.48-0.78-3.13c-0.87-0.52-1.99-0.41-2.73,0.29 l-3.43,3.21C12.23,5.7,12,6.23,12,6.78v3.93C12.36,10.56,12.98,10.38,13.73,10.61z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.61,12.27c0.16-0.52,0.48-0.96,0.89-1.27H3.28C2.02,11,1,12.02,1,13.28c0,1.02,0.67,1.91,1.65,2.19l4.51,1.29 c0.53,0.15,1.1,0.08,1.58-0.21l2.69-1.61C10.66,14.32,10.3,13.27,10.61,12.27z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.21,18.61l-2.28-4.1c-0.27-0.48-0.73-0.83-1.26-0.97l-3.18-0.8c0.03,0.32,0,0.66-0.1,0.99 c-0.32,1.06-1.28,1.77-2.39,1.77c-0.61,0-0.99-0.22-1-0.22V21c-1.1,0-2,0.9-2,2h6c0-1.1-0.9-2-2-2v-4.28l4.61,4.61 c0.89,0.89,2.33,0.89,3.22,0C22.55,20.61,22.71,19.5,22.21,18.61z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.56,14.43c0.79,0.24,1.63-0.2,1.87-1c0.24-0.79-0.2-1.63-1-1.87c-0.79-0.24-1.63,0.2-1.87,1 C11.32,13.35,11.77,14.19,12.56,14.43z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mode-fan-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M16.34,8.36l-2.29,0.82c-0.18-0.13-0.38-0.25-0.58-0.34c0.17-0.83,0.63-1.58,1.36-2.06C16.85,5.44,16.18,2,13.39,2 c-3.08,0-4.9,1.47-5.3,3.26L18.73,15.9c1.5,0.39,3.27-0.51,3.27-2.51C22,9,18.99,7.16,16.34,8.36z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M2.1,3.51L2.1,3.51c-0.39,0.39-0.39,1.02,0,1.41L5.27,8.1C3.77,7.7,2,8.61,2,10.61c0,4.4,3.01,6.24,5.66,5.03l2.29-0.82 c0.18,0.13,0.38,0.25,0.58,0.34c-0.17,0.83-0.63,1.58-1.36,2.06C7.15,18.56,7.82,22,10.61,22c3.08,0,4.9-1.47,5.3-3.26l3.16,3.16 c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51C3.12,3.12,2.49,3.12,2.1,3.51z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 sensor-door
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M18,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2z M15.5,13.5 c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5S17,11.17,17,12S16.33,13.5,15.5,13.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 gas-meter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,4h-1V3c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v1h-2V3c0-0.55-0.45-1-1-1h0C9.45,2,9,2.45,9,3v1H8C5.79,4,4,5.79,4,8 v10c0,2.21,1.79,4,4,4h8c2.21,0,4-1.79,4-4V8C20,5.79,18.21,4,16,4z M12,18c-1.38,0-2.5-1.1-2.5-2.46c0-1.02,0.38-1.35,2.12-3.35 c0.2-0.23,0.56-0.23,0.75,0c1.73,1.99,2.12,2.34,2.12,3.35C14.5,16.9,13.38,18,12,18z M15,10H9c-0.55,0-1-0.45-1-1v0 c0-0.55,0.45-1,1-1h6c0.55,0,1,0.45,1,1v0C16,9.55,15.55,10,15,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blinds
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H20z M16,9h2v2h-2V9z M14,11H6V9h8V11z M18,7h-2V5h2V7z M14,5v2H6V5H14z M6,19v-6h8v1.82 c-0.45,0.32-0.75,0.84-0.75,1.43c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75c0-0.59-0.3-1.12-0.75-1.43V13h2v6H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roller-shades-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h7.25 c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H20z M6,19v-2h5v2H6z M13,19v-2h5v2H13 z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 propane-tank
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M4,15v3c0,2.21,1.79,4,4,4h8c2.21,0,4-1.79,4-4v-3H4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,13v-3c0-1.86-1.28-3.41-3-3.86V4c0-1.1-0.9-2-2-2H9C7.9,2,7,2.9,7,4v2.14c-1.72,0.45-3,2-3,3.86v3H20z M9,4h6v2h-2 c0-0.55-0.45-1-1-1s-1,0.45-1,1H9V4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-meter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11.73,2C7.05,2.14,3.15,6.03,3,10.71c-0.13,4.04,2.42,7.5,6,8.77V21c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-1.06 c0.33,0.04,0.66,0.06,1,0.06s0.67-0.02,1-0.06V21c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-1.53c3.49-1.24,6-4.57,6-8.47 C21,5.95,16.82,1.85,11.73,2z M13.54,14.71L12,16.25c-0.41,0.41-1.09,0.41-1.5,0h0c-0.41-0.41-0.41-1.09,0-1.5l0.5-0.5l-0.54-0.54 c-0.39-0.39-0.39-1.02,0-1.41L12,10.75c0.41-0.41,1.09-0.41,1.5,0l0,0c0.41,0.41,0.41,1.09,0,1.5l-0.5,0.5l0.54,0.54 C13.93,13.68,13.93,14.32,13.54,14.71z M15,9H9C8.45,9,8,8.55,8,8v0c0-0.55,0.45-1,1-1h6c0.55,0,1,0.45,1,1v0C16,8.55,15.55,9,15,9 z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 nest-cam-wired-stand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M15.83,1.01l-4.11,0.42C8.47,1.75,6,4.48,6,7.75s2.47,6,5.72,6.33l1.9,0.19l-0.56,0.85C12.71,15.04,12.36,15,12,15 c-2.76,0-5,2.24-5,5v2c0,0.55,0.45,1,1,1h8c0.55,0,1-0.45,1-1v-2c0-1.67-0.83-3.15-2.09-4.06l0.97-1.45 C17.02,14.56,18,13.66,18,12.5V3C18,1.83,17,0.91,15.83,1.01z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blinds-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h10.25 c0,0.97,0.78,1.75,1.75,1.75s1.75-0.78,1.75-1.75H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H20z M18,11h-2V9h2V11z M14,11H6V9h8V11 z M14,13v2H6v-2H14z M16,13h2v2h-2V13z M18,7h-2V5h2V7z M14,5v2H6V5H14z M6,19v-2h8v2H6z M16,19v-2h2v2H16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 solar-power
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M3.33,16H11v-3H5.6c-0.94,0-1.75,0.65-1.95,1.57L3.33,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M13,16h7.67l-0.32-1.43C20.14,13.65,19.33,13,18.4,13H13V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M21.11,18H13v4h6.51c1.28,0,2.23-1.18,1.95-2.43L21.11,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M4.49,22H11v-4H2.89l-0.35,1.57C2.26,20.82,3.21,22,4.49,22z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,8L12,8c-0.55,0-1,0.45-1,1v1c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V9C13,8.45,12.55,8,12,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.59,8.62L18.59,8.62c0.39-0.39,0.39-1.02,0-1.41L17.88,6.5c-0.39-0.39-1.02-0.39-1.41,0v0c-0.39,0.39-0.39,1.02,0,1.41 l0.71,0.71C17.57,9.01,18.2,9.01,18.59,8.62z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6.82,8.62l0.71-0.71c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L5.41,7.2c-0.39,0.39-0.39,1.02,0,1.41 l0,0C5.8,9.01,6.43,9.01,6.82,8.62z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,2H4C3.45,2,3,2.45,3,3v0c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v0C6,2.45,5.55,2,5,2z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2h-1c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v0C21,2.45,20.55,2,20,2z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M12,7c2.76,0,5-2.24,5-5H7C7,4.76,9.24,7,12,7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 electric-bolt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.69,2.21L4.33,11.49c-0.64,0.58-0.28,1.65,0.58,1.73L13,14l-4.85,6.76c-0.22,0.31-0.19,0.74,0.08,1.01h0 c0.3,0.3,0.77,0.31,1.08,0.02l10.36-9.28c0.64-0.58,0.28-1.65-0.58-1.73L11,10l4.85-6.76c0.22-0.31,0.19-0.74-0.08-1.01l0,0 C15.47,1.93,15,1.92,14.69,2.21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 oil-barrel
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,13c0.55,0,1-0.45,1-1s-0.45-1-1-1h-1V5h1c0.55,0,1-0.45,1-1s-0.45-1-1-1H4C3.45,3,3,3.45,3,4s0.45,1,1,1h1v6H4 c-0.55,0-1,0.45-1,1s0.45,1,1,1h1v6H4c-0.55,0-1,0.45-1,1s0.45,1,1,1h16c0.55,0,1-0.45,1-1s-0.45-1-1-1h-1v-6H20z M12,16 c-1.66,0-3-1.32-3-2.95c0-1.16,0.41-1.58,2.24-3.68c0.4-0.46,1.12-0.46,1.51,0c1.82,2.09,2.24,2.52,2.24,3.68 C15,14.68,13.66,16,12,16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 curtains
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H20z M8.19,12c2.04-1.35,3.5-3.94,3.76-7h0.09c0.26,3.06,1.72,5.65,3.76,7c-2.04,1.35-3.5,3.94-3.76,7h-0.09 C11.69,15.94,10.23,13.35,8.19,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 curtains-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H20z M11,5h2v14h-2V5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 auto-mode
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.06,2.83c-1.15-0.77-2.46-1.32-3.86-1.61C13.58,1.1,13,1.57,13,2.21v0c0,0.46,0.31,0.88,0.76,0.97 c1.17,0.23,2.26,0.7,3.21,1.34c0.39,0.26,0.9,0.19,1.23-0.14l0,0C18.66,3.93,18.59,3.18,18.06,2.83z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11,2.21L11,2.21c0-0.64-0.58-1.11-1.2-0.99c-1.4,0.29-2.71,0.84-3.86,1.61c-0.52,0.35-0.59,1.1-0.15,1.54l0,0 c0.33,0.33,0.84,0.4,1.23,0.14c0.96-0.64,2.04-1.1,3.21-1.34C10.69,3.09,11,2.67,11,2.21z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4.38,5.79L4.38,5.79C3.93,5.34,3.18,5.42,2.84,5.94C2.07,7.09,1.51,8.39,1.23,9.8C1.1,10.42,1.58,11,2.21,11h0 c0.46,0,0.88-0.31,0.97-0.76c0.23-1.17,0.7-2.26,1.34-3.22C4.77,6.64,4.7,6.12,4.38,5.79z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.79,11L21.79,11c0.63,0,1.11-0.58,0.98-1.2c-0.29-1.4-0.84-2.7-1.61-3.86c-0.35-0.52-1.1-0.6-1.54-0.15l0,0 c-0.33,0.33-0.4,0.84-0.14,1.23c0.64,0.96,1.1,2.05,1.34,3.22C20.91,10.69,21.33,11,21.79,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,12.46l2.44,1.11L11.54,16c0.18,0.39,0.73,0.39,0.91,0l1.11-2.44L16,12.46c0.39-0.18,0.39-0.73,0-0.91l-2.44-1.11 L12.46,8c-0.18-0.39-0.73-0.39-0.91,0l-1.11,2.44L8,11.54C7.61,11.72,7.61,12.28,8,12.46z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,21c-3.11,0-5.85-1.59-7.46-4H6c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H2c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1v-1.7c1.99,2.84,5.27,4.7,9,4.7c4.45,0,8.27-2.64,10-6.43c0.26-0.57-0.08-1.25-0.69-1.39l0,0 c-0.45-0.1-0.93,0.11-1.12,0.54C18.77,18.83,15.64,21,12,21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sensor-window
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M18,4v16H6V4H18 M18,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2L18,2z M7,19h10v-6H7 V19z M10,10h4v1h3V5H7v6h3V10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 heat-pump
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M12.75,7.08 c0.82,0.12,1.57,0.44,2.2,0.91l-2.2,2.2V7.08z M11.25,7.08v3.11l-2.2-2.2C9.68,7.52,10.43,7.2,11.25,7.08z M7.99,9.05l2.2,2.2H7.08 C7.2,10.43,7.52,9.68,7.99,9.05z M7.08,12.75h3.11l-2.2,2.2C7.52,14.32,7.2,13.57,7.08,12.75z M11.25,16.92 c-0.82-0.12-1.57-0.44-2.2-0.91l2.2-2.2V16.92z M12,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C13,12.55,12.55,13,12,13z M12.75,16.92v-3.11l2.2,2.2C14.32,16.48,13.57,16.8,12.75,16.92z M16.01,14.95l-2.2-2.2h3.11C16.8,13.57,16.48,14.32,16.01,14.95z M13.81,11.25l2.2-2.2c0.47,0.64,0.79,1.39,0.91,2.2H13.81z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 propane
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.75,6L16,6V5c0-1.1-0.9-2-2-2h-4C8.9,3,8,3.9,8,5v1L7.25,6C3.97,6,1.1,8.53,1,11.82C0.9,15.21,3.62,18,7,18v2 c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2h6v2c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2c3.38,0,6.1-2.79,6-6.18 C22.9,8.53,20.03,6,16.75,6z M10,5h4v1h-4V5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sensor-occupied
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,11c1.66,0,3-1.34,3-3s-1.34-3-3-3S9,6.34,9,8S10.34,11,12,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,12c-1.84,0-3.56,0.5-5.03,1.37C6.36,13.73,6,14.39,6,15.09L6,16c0,0.55,0.45,1,1,1h10c0.55,0,1-0.45,1-1l0-0.91 c0-0.7-0.36-1.36-0.97-1.72C15.56,12.5,13.84,12,12,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.11,7.79L22.11,7.79c0.55-0.23,0.78-0.88,0.5-1.41c-1.13-2.12-2.87-3.86-4.99-4.99c-0.52-0.28-1.17-0.04-1.4,0.5v0 c-0.19,0.47-0.01,1.02,0.43,1.25c1.79,0.94,3.26,2.42,4.21,4.21C21.09,7.8,21.64,7.98,22.11,7.79z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.79,1.89L7.79,1.89c-0.23-0.55-0.88-0.78-1.4-0.5C4.27,2.52,2.52,4.26,1.4,6.38c-0.28,0.52-0.05,1.18,0.5,1.41l0,0 c0.47,0.2,1.02,0.01,1.25-0.43c0.94-1.79,2.42-3.26,4.21-4.21C7.8,2.91,7.98,2.36,7.79,1.89z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.89,16.21L1.89,16.21c-0.55,0.23-0.78,0.88-0.5,1.4c1.13,2.12,2.87,3.87,5,5c0.52,0.28,1.17,0.04,1.4-0.5l0,0 c0.19-0.47,0.01-1.02-0.43-1.25c-1.79-0.94-3.26-2.42-4.21-4.21C2.91,16.2,2.36,16.02,1.89,16.21z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.21,22.11L16.21,22.11c0.23,0.55,0.88,0.78,1.4,0.5c2.12-1.13,3.87-2.87,5-5c0.28-0.52,0.04-1.17-0.5-1.4h0 c-0.47-0.19-1.02-0.01-1.25,0.43c-0.94,1.79-2.42,3.26-4.21,4.21C16.2,21.09,16.02,21.64,16.21,22.11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 vertical-shades-closed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H20z M13,5h1.5v14H13V5z M11,19H9.5V5H11V19z M6,5h1.5v14H6V5z M16.5,19V5H18v14H16.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 energy-savings-leaf
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,3c-4.8,0-9,3.86-9,9c0,2.12,0.74,4.07,1.97,5.61l-1.68,1.68c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0 l1.68-1.68C7.93,20.26,9.88,21,12,21c2.3,0,4.61-0.88,6.36-2.64C20.12,16.61,21,14.3,21,12V5c0-1.1-0.9-2-2-2H12z M15.83,12.26 l-5.16,4.63c-0.16,0.15-0.41,0.14-0.56-0.01c-0.14-0.14-0.16-0.36-0.04-0.52l2.44-3.33l-4.05-0.4c-0.44-0.04-0.63-0.59-0.3-0.89 l5.16-4.63c0.16-0.15,0.41-0.14,0.56,0.01c0.14,0.14,0.16,0.36,0.04,0.52l-2.44,3.33l4.05,0.4 C15.98,11.41,16.16,11.96,15.83,12.26z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 vertical-shades
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H20z M10,19V5h4v14H10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 broadcast-on-personal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17,8c0.7,0,1.38,0.1,2.02,0.27L12,3L4,9v12h6.76C9.66,19.63,9,17.89,9,16C9,11.58,12.58,8,17,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,14.75c-0.69,0-1.25,0.56-1.25,1.25c0,0.4,0.2,0.75,0.5,0.97V22h1.5v-5.03c0.3-0.23,0.5-0.57,0.5-0.97 C18.25,15.31,17.69,14.75,17,14.75z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,12c-2.21,0-4,1.79-4,4c0,1.1,0.45,2.1,1.17,2.83l1.06-1.06c-0.45-0.45-0.73-1.08-0.73-1.77c0-1.38,1.12-2.5,2.5-2.5 s2.5,1.12,2.5,2.5c0,0.69-0.28,1.31-0.73,1.76l1.06,1.06C20.55,18.1,21,17.1,21,16C21,13.79,19.21,12,17,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17,9.5c-3.59,0-6.5,2.91-6.5,6.5c0,1.79,0.73,3.42,1.9,4.6l1.06-1.06C12.56,18.63,12,17.38,12,16c0-2.76,2.24-5,5-5 s5,2.24,5,5c0,1.37-0.56,2.62-1.46,3.52l1.07,1.06c1.17-1.18,1.89-2.8,1.89-4.58C23.5,12.41,20.59,9.5,17,9.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shield-moon
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11.3,2.26l-6,2.25C4.52,4.81,4,5.55,4,6.39v4.7c0,4.83,3.13,9.37,7.43,10.75c0.37,0.12,0.77,0.12,1.14,0 c4.3-1.38,7.43-5.91,7.43-10.75v-4.7c0-0.83-0.52-1.58-1.3-1.87l-6-2.25C12.25,2.09,11.75,2.09,11.3,2.26z M15.97,14.41 c-1.84,2.17-5.21,2.1-6.96-0.07c-2.19-2.72-0.65-6.72,2.69-7.33c0.34-0.06,0.63,0.27,0.51,0.6c-0.46,1.23-0.39,2.64,0.32,3.86 c0.71,1.22,1.89,1.99,3.18,2.2C16.05,13.72,16.2,14.14,15.97,14.41z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 roller-shades
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2H6C4.9,3,4,3.9,4,5v14H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H20z M6,19v-6h5v1.8c-0.4,0.3-0.8,0.8-0.8,1.4c0,1,0.8,1.8,1.8,1.8s1.8-0.8,1.8-1.8c0-0.6-0.3-1.1-0.8-1.4V13h5 v6H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 broadcast-on-home
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,6c0-1.1-0.9-2-2-2H5C4.45,4,4,4.45,4,5v0c0,0.55,0.45,1,1,1h15v2.59c0.73,0.29,1.4,0.69,2,1.17V6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,9H3c-0.5,0-1,0.5-1,1v9c0,0.5,0.5,1,1,1h5c0.5,0,1-0.5,1-1v-9C9,9.5,8.5,9,8,9z M7,18H4v-7h3V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.75,16.97c0.3-0.23,0.5-0.57,0.5-0.97c0-0.69-0.56-1.25-1.25-1.25s-1.25,0.56-1.25,1.25c0,0.4,0.2,0.75,0.5,0.97v4.28 c0,0.41,0.34,0.75,0.75,0.75l0,0c0.41,0,0.75-0.34,0.75-0.75V16.97z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.54,13.56c0.98,0.21,1.76,1.03,1.93,2.02c0.11,0.64-0.03,1.25-0.34,1.74c-0.18,0.29-0.13,0.67,0.12,0.91l0,0 c0.34,0.33,0.9,0.29,1.16-0.12c0.51-0.82,0.73-1.83,0.53-2.9c-0.3-1.56-1.56-2.83-3.12-3.13C15.24,11.58,13,13.53,13,16 c0,0.78,0.22,1.5,0.6,2.11c0.25,0.41,0.83,0.46,1.16,0.12l0,0c0.24-0.24,0.29-0.63,0.11-0.92c-0.24-0.38-0.37-0.83-0.37-1.31 C14.5,14.45,15.93,13.22,17.54,13.56z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.25,9.54c-2.94,0.33-5.32,2.68-5.69,5.61c-0.23,1.82,0.29,3.51,1.3,4.82c0.27,0.35,0.8,0.37,1.12,0.06l0,0 c0.27-0.27,0.28-0.7,0.05-1c-0.8-1.05-1.2-2.43-0.95-3.89c0.34-2.03,1.95-3.67,3.98-4.05C19.22,10.5,22,12.93,22,16 c0,1.13-0.38,2.18-1.02,3.02c-0.23,0.3-0.21,0.73,0.06,1l0,0c0.31,0.31,0.84,0.3,1.11-0.06C23,18.87,23.5,17.49,23.5,16 C23.5,12.16,20.17,9.1,16.25,9.54z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 device-unknown
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 1H7c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm0 18H7V5h10v14zm-6-3h2v2h-2zm-1.48-5.81h.13c.33 0 .59-.23.7-.54.24-.69.91-1.21 1.66-1.21.93 0 1.75.82 1.75 1.75 0 1.32-1.49 1.55-2.23 2.82h-.01c-.08.14-.14.29-.2.45-.01.02-.02.03-.02.05-.01.02-.01.04-.01.05-.1.31-.16.66-.16 1.08h1.76c0-.25.04-.47.12-.67.54-1.47 2.77-1.86 2.48-4.18-.19-1.55-1.43-2.84-2.98-3.04-1.77-.23-3.29.78-3.81 2.3-.2.56.23 1.14.82 1.14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-capslock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 8.41l3.89 3.89c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L12.71 6.3c-.39-.39-1.02-.39-1.41 0l-4.6 4.59c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 8.41zM7 18h10c.55 0 1-.45 1-1s-.45-1-1-1H7c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-mini
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,5C4.19,5,2,9.48,2,12c0,3.86,3.13,7,6.99,7h6.02c2.69,0,6.99-2.08,6.99-7C22,12,22,5,12,5z M12,7c7.64,0,7.99,4.51,8,5 H4C4,11.8,4.09,7,12,7z M14.86,17H9.14c-2.1,0-3.92-1.24-4.71-3h15.15C18.78,15.76,16.96,17,14.86,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tablet
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 4H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 1.99-.9 1.99-2L23 6c0-1.1-.9-2-2-2zm-2 14H5V6h14v12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11.4 1.02C6.62 1.33 3 5.52 3 10.31V17c0 1.66 1.34 3 3 3h1c1.1 0 2-.9 2-2v-4c0-1.1-.9-2-2-2H5v-1.71C5 6.45 7.96 3.11 11.79 3 15.76 2.89 19 6.06 19 10v2h-2c-1.1 0-2 .9-2 2v4c0 1.1.9 2 2 2h1c1.66 0 3-1.34 3-3v-7c0-5.17-4.36-9.32-9.6-8.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-double-arrow-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.29,17.29L18.29,17.29c0.39-0.39,0.39-1.02,0-1.41L14.42,12l3.88-3.88c0.39-0.39,0.39-1.02,0-1.41l0,0 c-0.39-0.39-1.02-0.39-1.41,0l-4.59,4.59c-0.39,0.39-0.39,1.02,0,1.41l4.59,4.59C17.27,17.68,17.9,17.68,18.29,17.29z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.7,17.29L11.7,17.29c0.39-0.39,0.39-1.02,0-1.41L7.83,12l3.88-3.88c0.39-0.39,0.39-1.02,0-1.41l0,0 c-0.39-0.39-1.02-0.39-1.41,0l-4.59,4.59c-0.39,0.39-0.39,1.02,0,1.41l4.59,4.59C10.68,17.68,11.31,17.68,11.7,17.29z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-double-arrow-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5.7,6.71L5.7,6.71c-0.39,0.39-0.39,1.02,0,1.41L9.58,12L5.7,15.88c-0.39,0.39-0.39,1.02,0,1.41l0,0 c0.39,0.39,1.02,0.39,1.41,0l4.59-4.59c0.39-0.39,0.39-1.02,0-1.41L7.12,6.71C6.73,6.32,6.09,6.32,5.7,6.71z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.29,6.71L12.29,6.71c-0.39,0.39-0.39,1.02,0,1.41L16.17,12l-3.88,3.88c-0.39,0.39-0.39,1.02,0,1.41l0,0 c0.39,0.39,1.02,0.39,1.41,0l4.59-4.59c0.39-0.39,0.39-1.02,0-1.41l-4.59-4.59C13.32,6.32,12.68,6.32,12.29,6.71z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-hide
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 3H4c-1.1 0-1.99.9-1.99 2L2 15c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-9 3h2v2h-2V6zm0 3h2v2h-2V9zM8 6h2v2H8V6zm0 3h2v2H8V9zm-1 2H5V9h2v2zm0-3H5V6h2v2zm8 7H9c-.55 0-1-.45-1-1s.45-1 1-1h6c.55 0 1 .45 1 1s-.45 1-1 1zm1-4h-2V9h2v2zm0-3h-2V6h2v2zm3 3h-2V9h2v2zm0-3h-2V6h2v2zm-6.65 14.65 2.79-2.79a.5.5 0 00-.35-.85H9.21c-.45 0-.67.54-.35.85l2.79 2.79c.19.19.51.19.7 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 monitor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,3H4C2.9,3,2,3.9,2,5v11c0,1.1,0.9,2,2,2h3c-0.55,0.55-1,0.87-1,1.59v0C6,20.37,6.63,21,7.41,21h9.17 c0.78,0,1.41-0.63,1.41-1.41v0c0-0.72-0.44-1.03-1-1.59h3c1.1,0,2-0.9,2-2V5C22,3.9,21.1,3,20,3z M20,16H4V5h16V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 desktop-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7l-1.63 2.45c-.44.66.03 1.55.83 1.55h5.6c.8 0 1.28-.89.83-1.55L14 18h7c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 12H3V5c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 memory
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M14 9h-4c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h4c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1zm-1 4h-2v-2h2v2zm8-3c0-.55-.45-1-1-1h-1V7c0-1.1-.9-2-2-2h-2V4c0-.55-.45-1-1-1s-1 .45-1 1v1h-2V4c0-.55-.45-1-1-1s-1 .45-1 1v1H7c-1.1 0-2 .9-2 2v2H4c-.55 0-1 .45-1 1s.45 1 1 1h1v2H4c-.55 0-1 .45-1 1s.45 1 1 1h1v2c0 1.1.9 2 2 2h2v1c0 .55.45 1 1 1s1-.45 1-1v-1h2v1c0 .55.45 1 1 1s1-.45 1-1v-1h2c1.1 0 2-.9 2-2v-2h1c.55 0 1-.45 1-1s-.45-1-1-1h-1v-2h1c.55 0 1-.45 1-1zm-5 7H8c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1h8c.55 0 1 .45 1 1v8c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M14.71 15.88L10.83 12l3.88-3.88c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0L8.71 11.3c-.39.39-.39 1.02 0 1.41l4.59 4.59c.39.39 1.02.39 1.41 0 .38-.39.39-1.03 0-1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,4c3.87,0,7,3.13,7,7v1h-2c-0.6,0-1.13,0.27-1.49,0.68L21,18.17V11c0-4.97-4.03-9-9-9C9.98,2,8.12,2.67,6.62,3.8 l1.43,1.43C9.17,4.45,10.53,4,12,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.19,21.19L2.81,2.81c-0.39-0.39-1.02-0.39-1.41,0C1,3.2,1,3.83,1.39,4.22l2.63,2.63C3.37,8.09,3,9.5,3,11v7 c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2H5v-1c0-0.94,0.19-1.83,0.52-2.65L15,17.83V18c0,1.1,0.9,2,2,2h0.17l1,1H13 c-0.55,0-1,0.45-1,1s0.45,1,1,1h6c0.36,0,0.68-0.1,0.97-0.26c0.38,0.23,0.89,0.2,1.22-0.13C21.58,22.22,21.58,21.58,21.19,21.19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sim-card
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19.99 4c0-1.1-.89-2-1.99-2h-7.17c-.53 0-1.04.21-1.42.59L4.59 7.41C4.21 7.79 4 8.3 4 8.83V20c0 1.1.9 2 2 2h12.01c1.1 0 1.99-.9 1.99-2l-.01-16zM8 19c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm8 0c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-8-4c-.55 0-1-.45-1-1v-2c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1zm4 4c-.55 0-1-.45-1-1v-2c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1zm0-6c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm4 2c-.55 0-1-.45-1-1v-2c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 toys
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   {:display "none"}
   (helix.dom/rect
    {:y "0",
     :width "24",
     :height "24",
     :fill "none",
     :display "inline",
     :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,14c0-1.95-1.4-3.57-3.25-3.92L17.4,6.05C17,4.82,15.85,4,14.56,4H9.44C8.15,4,7,4.82,6.6,6.05L5.81,8.4L4.41,7 l0.29-0.29c0.39-0.39,0.39-1.02,0-1.41c-0.39-0.39-1.02-0.39-1.41,0l-2,2c-0.39,0.39-0.39,1.02,0,1.41c0.39,0.39,1.02,0.39,1.41,0 L3,8.41l1.79,1.79C3.18,10.72,2,12.22,2,14c0,1.5,0.83,2.79,2.05,3.48C4.28,18.9,5.51,20,7,20c1.3,0,2.4-0.84,2.82-2h4.37 c0.41,1.16,1.51,2,2.82,2c1.49,0,2.72-1.1,2.95-2.52C21.17,16.79,22,15.5,22,14z M7,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1 S7.55,18,7,18z M11,10H7.41L7.39,9.98l1.1-3.3C8.63,6.27,9.01,6,9.44,6H11V10z M13,6h1.56c0.43,0,0.81,0.27,0.95,0.68L16.61,10H13 V6z M17,18c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S17.55,18,17,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 security
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11.19 1.36l-7 3.11C3.47 4.79 3 5.51 3 6.3V11c0 5.55 3.84 10.74 9 12 5.16-1.26 9-6.45 9-12V6.3c0-.79-.47-1.51-1.19-1.83l-7-3.11c-.51-.23-1.11-.23-1.62 0zM12 11.99h7c-.53 4.12-3.28 7.79-7 8.94V12H5V6.3l7-3.11v8.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speaker
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 2H7c-1.1 0-2 .9-2 2v16c0 1.1.9 1.99 2 1.99L17 22c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-5 2c1.1 0 2 .9 2 2s-.9 2-2 2c-1.11 0-2-.9-2-2s.89-2 2-2zm0 16c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 smartphone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 1.01L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-voice
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 15c1.66 0 2.99-1.34 2.99-3L15 6c0-1.66-1.34-3-3-3S9 4.34 9 6v6c0 1.66 1.34 3 3 3zm6.08-3c-.42 0-.77.3-.83.71-.37 2.61-2.72 4.39-5.25 4.39s-4.88-1.77-5.25-4.39c-.06-.41-.42-.71-.83-.71-.52 0-.92.46-.85.97.46 2.97 2.96 5.3 5.93 5.75V21c0 .55.45 1 1 1s1-.45 1-1v-2.28c2.96-.43 5.47-2.78 5.93-5.75.07-.51-.33-.97-.85-.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-command-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.5,3C15.57,3,14,4.57,14,6.5V8h-4V6.5C10,4.57,8.43,3,6.5,3S3,4.57,3,6.5S4.57,10,6.5,10H8v4H6.5 C4.57,14,3,15.57,3,17.5S4.57,21,6.5,21s3.5-1.57,3.5-3.5V16h4v1.5c0,1.93,1.57,3.5,3.5,3.5s3.5-1.57,3.5-3.5S19.43,14,17.5,14H16 v-4h1.5c1.93,0,3.5-1.57,3.5-3.5S19.43,3,17.5,3L17.5,3z M16,8V6.5C16,5.67,16.67,5,17.5,5S19,5.67,19,6.5S18.33,8,17.5,8H16L16,8 z M6.5,8C5.67,8,5,7.33,5,6.5S5.67,5,6.5,5S8,5.67,8,6.5V8H6.5L6.5,8z M10,14v-4h4v4H10L10,14z M17.5,19c-0.83,0-1.5-0.67-1.5-1.5 V16h1.5c0.83,0,1.5,0.67,1.5,1.5S18.33,19,17.5,19L17.5,19z M6.5,19C5.67,19,5,18.33,5,17.5S5.67,16,6.5,16H8v1.5 C8,18.33,7.33,19,6.5,19L6.5,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cast
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v2c0 .55.45 1 1 1s1-.45 1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1h-5c-.55 0-1 .45-1 1s.45 1 1 1h6c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM2.14 14.09c-.6-.1-1.14.39-1.14 1 0 .49.36.9.85.98 2.08.36 3.72 2 4.08 4.08.08.49.49.85.98.85.61 0 1.09-.54 1-1.14-.48-2.96-2.82-5.29-5.77-5.77zM1 18v3h3c0-1.66-1.34-3-3-3zm1.1-7.95c-.59-.05-1.1.41-1.1 1 0 .51.38.94.88.99 4.27.41 7.67 3.81 8.08 8.08.05.5.48.87.99.87.6 0 1.06-.52 1-1.11-.53-5.19-4.66-9.31-9.85-9.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phonelink-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M24 19V9c0-.55-.45-1-1-1h-6c-.55 0-1 .45-1 1v3.61l2 2V10h4v7h-1.61l2.93 2.93c.39-.13.68-.49.68-.93zM21 6c.55 0 1-.45 1-1s-.45-1-1-1H7.39l2 2H21zM1.36 2.21c-.39.39-.39 1.02 0 1.41l1.11 1.11C2.18 5.08 2 5.52 2 6v11h-.5c-.83 0-1.5.67-1.5 1.5S.67 20 1.5 20h16.23l1.64 1.64c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L2.77 2.21c-.39-.39-1.02-.39-1.41 0zM4 17V6.27L14.73 17H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-android
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M16 1H8C6.34 1 5 2.34 5 4v16c0 1.66 1.34 3 3 3h8c1.66 0 3-1.34 3-3V4c0-1.66-1.34-3-3-3zm-2.5 20h-3c-.28 0-.5-.22-.5-.5s.22-.5.5-.5h3c.28 0 .5.22.5.5s-.22.5-.5.5zm3.5-3H7V4h10v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 developer-board-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.83,5H18v10.17L19.83,17H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1v-2h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1V9 h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1V5c0-1.1-0.9-2-2-2H5.83L7.83,5z M15,10h-2c-0.06,0-0.13-0.01-0.19-0.02l-0.79-0.79 C12.01,9.13,12,9.06,12,9V8c0-0.55,0.45-1,1-1h2c0.55,0,1,0.45,1,1v1C16,9.55,15.55,10,15,10z M11,8v0.17L9.83,7H10 C10.55,7,11,7.45,11,8z M16,12v1.17L13.83,11H15C15.55,11,16,11.45,16,12z M1.39,2.81L1.39,2.81C1,3.2,1,3.83,1.39,4.22l0.61,0.61 C2,4.89,2,4.94,2,5v14c0,1.1,0.9,2,2,2h14c0.06,0,0.11,0,0.16-0.01l1.61,1.61c0.39,0.39,1.02,0.39,1.41,0l0,0 c0.39-0.39,0.39-1.02,0-1.41L2.81,2.81C2.42,2.42,1.78,2.42,1.39,2.81z M4,19V6.83l2,2V11c0,0.55,0.45,1,1,1h2.17l1.02,1.02 C10.13,13.01,10.06,13,10,13H7c-0.55,0-1,0.45-1,1v2c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v-2c0-0.06-0.01-0.13-0.02-0.19 L12,14.83v0.46V16c0,0.55,0.45,1,1,1h0.38h0.8l2,2H4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 tablet-android
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18 0H6C4.34 0 3 1.34 3 3v18c0 1.66 1.34 3 3 3h12c1.66 0 3-1.34 3-3V3c0-1.66-1.34-3-3-3zm-4.5 22h-3c-.28 0-.5-.22-.5-.5s.22-.5.5-.5h3c.28 0 .5.22.5.5s-.22.5-.5.5zm5.75-3H4.75V3h14.5v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gamepad
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M15 7.29V3c0-.55-.45-1-1-1h-4c-.55 0-1 .45-1 1v4.29c0 .13.05.26.15.35l2.5 2.5c.2.2.51.2.71 0l2.5-2.5c.09-.09.14-.21.14-.35zM7.29 9H3c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h4.29c.13 0 .26-.05.35-.15l2.5-2.5c.2-.2.2-.51 0-.71l-2.5-2.5C7.55 9.05 7.43 9 7.29 9zM9 16.71V21c0 .55.45 1 1 1h4c.55 0 1-.45 1-1v-4.29c0-.13-.05-.26-.15-.35l-2.5-2.5c-.2-.2-.51-.2-.71 0l-2.5 2.5c-.09.09-.14.21-.14.35zm7.35-7.56l-2.5 2.5c-.2.2-.2.51 0 .71l2.5 2.5c.09.09.22.15.35.15H21c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1h-4.29c-.14-.01-.26.04-.36.14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power-input
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M2 10c0 .55.45 1 1 1h17c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1zm1 5h3c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1s.45 1 1 1zm7 0h3c.55 0 1-.45 1-1s-.45-1-1-1h-3c-.55 0-1 .45-1 1s.45 1 1 1zm7 0h3c.55 0 1-.45 1-1s-.45-1-1-1h-3c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,4H3C1.9,4,1,4.9,1,6v13c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V6C23,4.9,22.1,4,21,4z M7,12v2H5v-2H7z M5,10V8h2v2H5z M11,12v2H9v-2H11z M9,10V8h2v2H9z M16,16.5L16,16.5c0,0.28-0.22,0.5-0.5,0.5h-7C8.22,17,8,16.78,8,16.5l0,0 C8,16.22,8.22,16,8.5,16h7C15.78,16,16,16.22,16,16.5z M15,12v2h-2v-2H15z M13,10V8h2v2H13z M17,14v-2h2v2H17z M19,10h-2V8h2V10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 laptop-windows
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 18v-1c1.1 0 1.99-.9 1.99-2L22 5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2v1H1c-.55 0-1 .45-1 1s.45 1 1 1h22c.55 0 1-.45 1-1s-.45-1-1-1h-3zM5 5h14c.55 0 1 .45 1 1v8c0 .55-.45 1-1 1H5c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speaker-group
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18.2 1H9.8C8.81 1 8 1.81 8 2.8v14.4c0 .99.81 1.79 1.8 1.79l8.4.01c.99 0 1.8-.81 1.8-1.8V2.8c0-.99-.81-1.8-1.8-1.8zM14 3c1.1 0 2 .89 2 2s-.9 2-2 2-2-.89-2-2 .9-2 2-2zm0 13.5c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "12.5", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M5 5c-.55 0-1 .45-1 1v15c0 1.1.89 2 2 2h9c.55 0 1-.45 1-1s-.45-1-1-1H7c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 start
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.29,17.29c0.39,0.39,1.02,0.39,1.41,0l4.59-4.59c0.39-0.39,0.39-1.02,0-1.41L16.7,6.7c-0.39-0.39-1.02-0.39-1.41,0 c-0.38,0.39-0.39,1.03,0,1.42L18.17,11H7c-0.55,0-1,0.45-1,1s0.45,1,1,1h11.17l-2.88,2.88C14.9,16.27,14.9,16.9,15.29,17.29z M3,18 c0.55,0,1-0.45,1-1V7c0-0.55-0.45-1-1-1S2,6.45,2,7v10C2,17.55,2.45,18,3,18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 home-max
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,5H5C2.79,5,1,6.79,1,9v5c0,2.21,1.79,4,4,4h2c0,0.55,0.45,1,1,1h8c0.55,0,1-0.45,1-1h2c2.21,0,4-1.79,4-4V9 C23,6.79,21.21,5,19,5z M21,14c0,1.1-0.9,2-2,2H5c-1.1,0-2-0.9-2-2V9c0-1.1,0.9-2,2-2h14c1.1,0,2,0.9,2,2V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 headphones
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3,12v7c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2H5v-1c0-3.87,3.13-7,7-7s7,3.13,7,7v1h-2c-1.1,0-2,0.9-2,2v4 c0,1.1,0.9,2,2,2h2c1.1,0,2-0.9,2-2v-7c0-4.97-4.03-9-9-9S3,7.03,3,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 keyboard-return
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 8v3H5.83l2.88-2.88c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0L2.71 11.3c-.39.39-.39 1.02 0 1.41L7.3 17.3c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.83 13H20c.55 0 1-.45 1-1V8c0-.55-.45-1-1-1s-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phonelink
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M4 7c0-.55.45-1 1-1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-1.1 0-2 .9-2 2v11h-.5c-.83 0-1.5.67-1.5 1.5S.67 20 1.5 20h11c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5H4V7zm19 1h-6c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h6c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1zm-1 9h-4v-7h4v7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-option-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M15,6L15,6c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-4C15.45,5,15,5.45,15,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9.58,6C9.22,5.38,8.56,5,7.85,5H4C3.45,5,3,5.45,3,6v0c0,0.55,0.45,1,1,1h3.85l6.35,11c0.36,0.62,1.02,1,1.73,1H20 c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-4.07L9.58,6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 videogame-asset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 6H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-11 7H8v2c0 .55-.45 1-1 1s-1-.45-1-1v-2H4c-.55 0-1-.45-1-1s.45-1 1-1h2V9c0-.55.45-1 1-1s1 .45 1 1v2h2c.55 0 1 .45 1 1s-.45 1-1 1zm5.5 2c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4-3c-.83 0-1.5-.67-1.5-1.5S18.67 9 19.5 9s1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tv
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.1-.9-2-2-2zm-1 14H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 watch-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,7c2.76,0,5,2.24,5,5c0,0.64-0.13,1.25-0.35,1.82l1.5,1.5C18.69,14.33,19,13.2,19,12c0-2.22-1.03-4.19-2.64-5.47 l-0.93-3.1C15.17,2.58,14.4,2,13.51,2h-3.02C9.6,2,8.83,2.58,8.57,3.42L8.04,5.21l2.14,2.14C10.75,7.13,11.36,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,3.51L2.1,3.51c-0.39,0.39-0.39,1.02,0,1.41l3.75,3.75C5.31,9.67,5,10.8,5,12c0,2.22,1.03,4.19,2.64,5.47l0.93,3.1 C8.83,21.42,9.6,22,10.49,22h3.02c0.88,0,1.66-0.58,1.92-1.43l0.53-1.78l3.11,3.11c0.39,0.39,1.02,0.39,1.41,0l0,0 c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51C3.12,3.12,2.49,3.12,2.1,3.51z M12,17c-2.76,0-5-2.24-5-5c0-0.64,0.13-1.25,0.35-1.82 l6.47,6.47C13.25,16.87,12.64,17,12,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 smart-screen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,5H3C1.9,5,1,5.9,1,7v10c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V7C23,5.9,22.1,5,21,5z M18,7v10H6V7H18z M14,12 c0-0.41-0.34-0.75-0.75-0.75S12.5,11.59,12.5,12s0.34,0.75,0.75,0.75S14,12.41,14,12z M9,12c0-0.41-0.34-0.75-0.75-0.75 S7.5,11.59,7.5,12s0.34,0.75,0.75,0.75S9,12.41,9,12z M16.5,12c0-0.41-0.34-0.75-0.75-0.75S15,11.59,15,12s0.34,0.75,0.75,0.75 S16.5,12.41,16.5,12z M11.5,12c0-0.41-0.34-0.75-0.75-0.75S10,11.59,10,12s0.34,0.75,0.75,0.75S11.5,12.41,11.5,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mouse
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M13 1.07V9h7c0-4.08-3.05-7.44-7-7.93zM4 15c0 4.42 3.58 8 8 8s8-3.58 8-8v-4H4v4zm7-13.93C7.05 1.56 4 4.92 4 9h7V1.07z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-double-arrow-up
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.7,18.29L6.7,18.29c0.39,0.39,1.02,0.39,1.41,0L12,14.42l3.88,3.88c0.39,0.39,1.02,0.39,1.41,0l0,0 c0.39-0.39,0.39-1.02,0-1.41l-4.59-4.59c-0.39-0.39-1.02-0.39-1.41,0L6.7,16.88C6.31,17.27,6.31,17.9,6.7,18.29z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6.7,11.7L6.7,11.7c0.39,0.39,1.02,0.39,1.41,0L12,7.83l3.88,3.88c0.39,0.39,1.02,0.39,1.41,0l0,0 c0.39-0.39,0.39-1.02,0-1.41l-4.59-4.59c-0.39-0.39-1.02-0.39-1.41,0L6.7,10.29C6.31,10.68,6.31,11.31,6.7,11.7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 browser-not-supported
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,6v10.5l1.95,1.95C20.98,18.3,21,18.15,21,18V6c0-1.1-0.9-2-2-2H6.5l2,2H19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3.86,3.95c-0.35-0.35-0.92-0.35-1.27,0c-0.35,0.35-0.35,0.92,0,1.27L3,5.64L3,18c0,1.1,0.9,2,2,2h12.36l1.42,1.42 c0.35,0.35,0.92,0.35,1.27,0c0.35-0.35,0.35-0.92,0-1.27L3.86,3.95z M5,18V7.64L15.36,18H5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 browser-updated
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15,3c0.55,0,1,0.45,1,1v6h1.59c0.89,0,1.34,1.08,0.71,1.71l-2.59,2.59c-0.39,0.39-1.02,0.39-1.41,0l-2.59-2.59 C11.08,11.08,11.52,10,12.41,10H14V4C14,3.45,14.45,3,15,3z M6,19.59C6,20.37,6.63,21,7.41,21h9.17c0.78,0,1.41-0.63,1.41-1.41 c0-0.72-0.44-1.03-1-1.59h3c1.1,0,2-0.9,2-2v-2c0-0.55-0.45-1-1-1s-1,0.45-1,1v2H4V5l7,0c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1L4,3 C2.9,3,2,3.9,2,5v11c0,1.1,0.9,2,2,2h3C6.45,18.55,6,18.87,6,19.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M8.12 9.29L12 13.17l3.88-3.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-4.59 4.59c-.39.39-1.02.39-1.41 0L6.7 10.7c-.39-.39-.39-1.02 0-1.41.39-.38 1.03-.39 1.42 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tablet-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18.5 0h-14C3.12 0 2 1.12 2 2.5v19C2 22.88 3.12 24 4.5 24h14c1.38 0 2.5-1.12 2.5-2.5v-19C21 1.12 19.88 0 18.5 0zm-7 23c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm7.5-4H4V3h15v16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 developer-board
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M22 8c0-.55-.45-1-1-1h-1V5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-2h1c.55 0 1-.45 1-1s-.45-1-1-1h-1v-2h1c.55 0 1-.45 1-1s-.45-1-1-1h-1V9h1c.55 0 1-.45 1-1zm-5 11H5c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zM6.5 13h4c.28 0 .5.22.5.5v3c0 .28-.22.5-.5.5h-4c-.28 0-.5-.22-.5-.5v-3c0-.28.22-.5.5-.5zm6-6h3c.28 0 .5.22.5.5v2c0 .28-.22.5-.5.5h-3c-.28 0-.5-.22-.5-.5v-2c0-.28.22-.5.5-.5zm-6 0h4c.28 0 .5.22.5.5v4c0 .28-.22.5-.5.5h-4c-.28 0-.5-.22-.5-.5v-4c0-.28.22-.5.5-.5zm6 4h3c.28 0 .5.22.5.5v5c0 .28-.22.5-.5.5h-3c-.28 0-.5-.22-.5-.5v-5c0-.28.22-.5.5-.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M8.12 14.71L12 10.83l3.88 3.88c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L12.7 8.71c-.39-.39-1.02-.39-1.41 0L6.7 13.3c-.39.39-.39 1.02 0 1.41.39.38 1.03.39 1.42 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 laptop-mac
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 18c1.1 0 1.99-.9 1.99-2L22 5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2H0c0 1.1.9 2 2 2h20c1.1 0 2-.9 2-2h-4zM5 5h14c.55 0 1 .45 1 1v9c0 .55-.45 1-1 1H5c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1zm7 14c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 point-of-sale
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,2H7C5.9,2,5,2.9,5,4v2c0,1.1,0.9,2,2,2h10c1.1,0,2-0.9,2-2V4C19,2.9,18.1,2,17,2z M16.5,6h-9C7.22,6,7,5.78,7,5.5v-1 C7,4.22,7.22,4,7.5,4h9C16.78,4,17,4.22,17,4.5v1C17,5.78,16.78,6,16.5,6z M20,22H4c-1.1,0-2-0.9-2-2v-1h20v1 C22,21.1,21.1,22,20,22z M18.53,10.19C18.21,9.47,17.49,9,16.7,9H7.3c-0.79,0-1.51,0.47-1.83,1.19L2,18h20L18.53,10.19z M9.5,16h-1 C8.22,16,8,15.78,8,15.5C8,15.22,8.22,15,8.5,15h1c0.28,0,0.5,0.22,0.5,0.5C10,15.78,9.78,16,9.5,16z M9.5,14h-1 C8.22,14,8,13.78,8,13.5C8,13.22,8.22,13,8.5,13h1c0.28,0,0.5,0.22,0.5,0.5C10,13.78,9.78,14,9.5,14z M9.5,12h-1 C8.22,12,8,11.78,8,11.5C8,11.22,8.22,11,8.5,11h1c0.28,0,0.5,0.22,0.5,0.5C10,11.78,9.78,12,9.5,12z M12.5,16h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C13,15.78,12.78,16,12.5,16z M12.5,14h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C13,13.78,12.78,14,12.5,14z M12.5,12h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C13,11.78,12.78,12,12.5,12z M15.5,16h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C16,15.78,15.78,16,15.5,16z M15.5,14h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C16,13.78,15.78,14,15.5,14z M15.5,12h-1 c-0.28,0-0.5-0.22-0.5-0.5c0-0.28,0.22-0.5,0.5-0.5h1c0.28,0,0.5,0.22,0.5,0.5C16,11.78,15.78,12,15.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 headset-mic
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11.4 1.02C6.62 1.33 3 5.52 3 10.31V17c0 1.66 1.34 3 3 3h1c1.1 0 2-.9 2-2v-4c0-1.1-.9-2-2-2H5v-1.71C5 6.45 7.96 3.11 11.79 3 15.76 2.89 19 6.06 19 10v2h-2c-1.1 0-2 .9-2 2v4c0 1.1.9 2 2 2h2v1h-6c-.55 0-1 .45-1 1s.45 1 1 1h5c1.66 0 3-1.34 3-3V10c0-5.17-4.36-9.32-9.6-8.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 headphones-battery
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,7h-1V6.5C20,6.22,19.78,6,19.5,6h-1C18.22,6,18,6.22,18,6.5V7h-1c-0.55,0-1,0.45-1,1v9c0,0.55,0.45,1,1,1h4 c0.55,0,1-0.45,1-1V8C22,7.45,21.55,7,21,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,6c-3.31,0-6,2.69-6,6v4c0,1.1,0.9,2,2,2s2-0.9,2-2v-1c0-1.1-0.9-2-2-2H3.5v-1c0-2.48,2.02-4.5,4.5-4.5 s4.5,2.02,4.5,4.5v1H12c-1.1,0-2,0.9-2,2v1c0,1.1,0.9,2,2,2s2-0.9,2-2v-4C14,8.69,11.31,6,8,6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-control-key
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M5.71,12.71L5.71,12.71c0.39,0.39,1.02,0.39,1.41,0L12,7.83l4.88,4.88c0.39,0.39,1.02,0.39,1.41,0v0 c0.39-0.39,0.39-1.02,0-1.41l-5.59-5.59c-0.39-0.39-1.02-0.39-1.41,0l-5.59,5.59C5.32,11.68,5.32,12.32,5.71,12.71z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cast-connected
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 16V8c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1v.63c3.96 1.28 7.09 4.41 8.37 8.37H18c.55 0 1-.45 1-1zm2-13H3c-1.1 0-2 .9-2 2v2c0 .55.45 1 1 1s1-.45 1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1h-5c-.55 0-1 .45-1 1s.45 1 1 1h6c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM1 18v3h3c0-.62-.19-1.2-.51-1.68C2.95 18.52 2.04 18 1 18zm1.14-3.91c-.6-.1-1.14.39-1.14 1 0 .49.36.9.85.98 2.08.36 3.72 2 4.08 4.08.08.49.49.85.98.85.61 0 1.09-.54 1-1.14-.48-2.96-2.82-5.29-5.77-5.77zm-.04-4.04c-.59-.05-1.1.41-1.1 1 0 .51.38.94.88.99 4.27.41 7.67 3.81 8.08 8.08.05.5.48.87.99.87.6 0 1.06-.52 1-1.11-.53-5.19-4.66-9.31-9.85-9.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 watch
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 12c0-2.54-1.19-4.81-3.04-6.27l-.68-4.06C16.12.71 15.28 0 14.31 0H9.7c-.98 0-1.82.71-1.98 1.67l-.67 4.06C5.19 7.19 4 9.45 4 12s1.19 4.81 3.05 6.27l.67 4.06c.16.96 1 1.67 1.98 1.67h4.61c.98 0 1.81-.71 1.97-1.67l.68-4.06C18.81 16.81 20 14.54 20 12zM6 12c0-3.31 2.69-6 6-6s6 2.69 6 6-2.69 6-6 6-6-2.69-6-6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 earbuds
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.2,3.01C4.44,2.89,3,4.42,3,6.19L3,16c0,2.76,2.24,5,5,5h0c2.76,0,5-2.24,5-5V8c0-1.66,1.34-3,3-3h0c1.66,0,3,1.34,3,3 v7l-0.83,0c-1.61,0-3.06,1.18-3.17,2.79c-0.12,1.69,1.16,3.1,2.8,3.21c1.76,0.12,3.2-1.42,3.2-3.18L21,8c0-2.76-2.24-5-5-5h0 c-2.76,0-5,2.24-5,5v8c0,1.66-1.34,3-3,3l0,0c-1.66,0-3-1.34-3-3V9l0.83,0C7.44,9,8.89,7.82,9,6.21C9.11,4.53,7.83,3.11,6.2,3.01z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-double-arrow-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.29,5.71L17.29,5.71c-0.39-0.39-1.02-0.39-1.41,0L12,9.58L8.11,5.7c-0.39-0.39-1.02-0.39-1.41,0l0,0 c-0.39,0.39-0.39,1.02,0,1.41l4.59,4.59c0.39,0.39,1.02,0.39,1.41,0l4.59-4.59C17.68,6.73,17.68,6.1,17.29,5.71z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.29,12.3L17.29,12.3c-0.39-0.39-1.02-0.39-1.41,0L12,16.17l-3.88-3.88c-0.39-0.39-1.02-0.39-1.41,0l0,0 c-0.39,0.39-0.39,1.02,0,1.41l4.59,4.59c0.39,0.39,1.02,0.39,1.41,0l4.59-4.59C17.68,13.32,17.68,12.69,17.29,12.3z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 laptop-chromebook
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M23 18h-1V5c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v13H1c-.55 0-1 .45-1 1s.45 1 1 1h22c.55 0 1-.45 1-1s-.45-1-1-1zm-9.5 0h-3c-.28 0-.5-.22-.5-.5s.22-.5.5-.5h3c.28 0 .5.22.5.5s-.22.5-.5.5zm6.5-3H4V6c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cast-for-education
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19.2 8.56l-4.22-2.3c-.3-.16-.66-.16-.96 0L9.8 8.56c-.35.19-.35.69 0 .88l4.22 2.3c.3.16.66.16.96 0l4.22-2.3c.34-.19.34-.69 0-.88zM21 3H3c-1.1 0-2 .9-2 2v2c0 .55.45 1 1 1s1-.45 1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1h-5c-.55 0-1 .45-1 1s.45 1 1 1h6c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-6.98 9.74L11 11.09v1.41c0 .37.2.7.52.88l2.5 1.36c.3.16.66.16.96 0l2.5-1.36c.32-.18.52-.52.52-.88v-1.41l-3.02 1.65c-.3.16-.66.16-.96 0zM1 18v3h3c0-1.66-1.34-3-3-3zm1.14-3.91c-.6-.1-1.14.39-1.14 1 0 .49.36.9.85.98 2.08.36 3.72 2 4.08 4.08.08.49.49.85.98.85.61 0 1.09-.54 1-1.14-.48-2.96-2.82-5.29-5.77-5.77zm-.04-4.04c-.59-.05-1.1.41-1.1 1 0 .51.38.94.88.99 4.27.41 7.67 3.81 8.08 8.08.05.5.48.87.99.87.6 0 1.06-.52 1-1.11-.53-5.19-4.66-9.31-9.85-9.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 videogame-asset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.7,17.87C21.46,17.59,22,16.85,22,16V8c0-1.1-0.9-2-2-2H8.83L20.7,17.87z M17.5,9c0.83,0,1.5,0.67,1.5,1.5 S18.33,12,17.5,12S16,11.33,16,10.5S16.67,9,17.5,9z M20.49,20.49L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0 c-0.39,0.39-0.39,1.02,0,1.41l1.2,1.2C2.54,6.41,2,7.15,2,8v8c0,1.1,0.9,2,2,2h11.17l3.9,3.9c0.39,0.39,1.02,0.39,1.41,0h0 C20.88,21.51,20.88,20.88,20.49,20.49z M10,13H9v1c0,0.55-0.45,1-1,1s-1-0.45-1-1v-1H6c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h1v-1 c0-0.05,0.01-0.11,0.01-0.16l3.14,3.14C10.11,12.99,10.05,13,10,13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 desktop-windows
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h7v2H9c-.55 0-1 .45-1 1s.45 1 1 1h6c.55 0 1-.45 1-1s-.45-1-1-1h-1v-2h7c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-1 14H4c-.55 0-1-.45-1-1V5c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-iphone
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M15.5 1h-8C6.12 1 5 2.12 5 3.5v17C5 21.88 6.12 23 7.5 23h8c1.38 0 2.5-1.12 2.5-2.5v-17C18 2.12 16.88 1 15.5 1zm-4 21c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5-4H7V4h9v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-tab
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12.29 8.12L15.17 11H2c-.55 0-1 .45-1 1s.45 1 1 1h13.17l-2.88 2.88c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0l4.59-4.59c.39-.39.39-1.02 0-1.41L13.7 6.7c-.39-.39-1.02-.39-1.41 0-.38.39-.39 1.03 0 1.42zM20 7v10c0 .55.45 1 1 1s1-.45 1-1V7c0-.55-.45-1-1-1s-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 laptop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 18c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H1c-.55 0-1 .45-1 1s.45 1 1 1h22c.55 0 1-.45 1-1s-.45-1-1-1h-3zM5 6h14c.55 0 1 .45 1 1v8c0 .55-.45 1-1 1H5c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 device-hub
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 16l-4-4V8.82c1.35-.49 2.26-1.89 1.93-3.46-.25-1.18-1.23-2.12-2.42-2.32C10.63 2.73 9 4.17 9 6c0 1.3.84 2.4 2 2.82V12l-4 4H4c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1h3c.55 0 1-.45 1-1v-2.05l4-4.2 4 4.2V20c0 .55.45 1 1 1h3c.55 0 1-.45 1-1v-3c0-.55-.45-1-1-1h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 earbuds-battery
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,7h-1l0,0V6.5C20,6.22,19.78,6,19.5,6l-1,0C18.22,6,18,6.22,18,6.5V7l0,0h-1c-0.55,0-1,0.45-1,1v9c0,0.55,0.45,1,1,1h4 c0.55,0,1-0.45,1-1V8C22,7.45,21.55,7,21,7z M14,9.38C14,7.51,12.49,6,10.62,6S7.25,7.51,7.25,9.38v5.25 c0,1.04-0.84,1.88-1.88,1.88S3.5,15.66,3.5,14.62v-4.7C3.66,9.97,3.83,10,4,10c1.1,0,2-0.9,2-2S5.1,6,4,6S2,6.9,2,8 c0,0.04,0,6.62,0,6.62C2,16.49,3.51,18,5.38,18s3.38-1.51,3.38-3.38V9.38c0-1.04,0.84-1.88,1.88-1.88s1.88,0.84,1.88,1.88v4.7 C12.34,14.03,12.17,14,12,14c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2C14,15.96,14,9.38,14,9.38z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 keyboard-backspace
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 11H6.83l2.88-2.88c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0L3.71 11.3c-.39.39-.39 1.02 0 1.41L8.3 17.3c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L6.83 13H20c.55 0 1-.45 1-1s-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 computer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 18c1.1 0 1.99-.9 1.99-2L22 6c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2H1c-.55 0-1 .45-1 1s.45 1 1 1h22c.55 0 1-.45 1-1s-.45-1-1-1h-3zM5 6h14c.55 0 1 .45 1 1v8c0 .55-.45 1-1 1H5c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adf-scanner
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,12h-1V6c0-1.1-0.9-2-2-2H8C6.9,4,6,4.9,6,6v6H5c-1.66,0-3,1.34-3,3v3c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-3 C22,13.34,20.66,12,19,12z M16,12H8V6h8V12z M18,17c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C19,16.55,18.55,17,18,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 scanner
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19.8 10.7L5.15 5.35c-.52-.19-1.1.08-1.3.6-.19.53.08 1.11.6 1.3L17.6 12H5c-1.1 0-2 .9-2 2v4c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-5.5c0-.8-.5-1.6-1.2-1.8zM7 17H5v-2h2v2zm11 0h-8c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 smart-toy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,9V7c0-1.1-0.9-2-2-2h-3c0-1.66-1.34-3-3-3S9,3.34,9,5H6C4.9,5,4,5.9,4,7v2c-1.66,0-3,1.34-3,3c0,1.66,1.34,3,3,3v4 c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4c1.66,0,3-1.34,3-3C23,10.34,21.66,9,20,9z M7.5,11.5C7.5,10.67,8.17,10,9,10 s1.5,0.67,1.5,1.5S9.83,13,9,13S7.5,12.33,7.5,11.5z M15,17H9c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h6c0.55,0,1,0.45,1,1v0 C16,16.55,15.55,17,15,17z M15,13c-0.83,0-1.5-0.67-1.5-1.5S14.17,10,15,10s1.5,0.67,1.5,1.5S15.83,13,15,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 devices-other
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3 7c0-.55.45-1 1-1h16c.55 0 1-.45 1-1s-.45-1-1-1H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h3c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V7zm9 5h-2c-.55 0-1 .45-1 1v.78c-.61.55-1 1.33-1 2.22 0 .89.39 1.67 1 2.22V19c0 .55.45 1 1 1h2c.55 0 1-.45 1-1v-.78c.61-.55 1-1.34 1-2.22s-.39-1.67-1-2.22V13c0-.55-.45-1-1-1zm-1 5.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM22 8h-6c-.5 0-1 .5-1 1v10c0 .5.5 1 1 1h6c.5 0 1-.5 1-1V9c0-.5-.5-1-1-1zm-1 10h-4v-8h4v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 connected-tv
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,3H4C2.9,3,2,3.9,2,5v12c0,1.1,0.9,2,2,2h4v1c0,0.55,0.45,1,1,1h6c0.55,0,1-0.45,1-1v-1h4c1.1,0,1.99-0.9,1.99-2L22,5 C22,3.9,21.1,3,20,3z M20,17H4V5h16V17z M7,15.97C6.98,14.89,6.11,14.02,5.03,14H5v2h2V15.97z M5.62,12.55 c1.44,0.26,2.58,1.4,2.83,2.84C8.51,15.75,8.82,16,9.18,16h0c0.46,0,0.82-0.41,0.75-0.86c-0.36-2.07-1.99-3.7-4.06-4.06 C5.41,11,5,11.36,5,11.82v0C5,12.19,5.26,12.49,5.62,12.55z M5.64,9.53c3.07,0.3,5.52,2.75,5.83,5.82 c0.04,0.37,0.37,0.65,0.74,0.65c0.45,0,0.79-0.4,0.75-0.85c-0.4-3.74-3.37-6.71-7.11-7.1C5.4,8,5,8.34,5,8.79 C5,9.16,5.27,9.5,5.64,9.53z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 smart-display
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:y "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M9.5,14.67V9.33 c0-0.79,0.88-1.27,1.54-0.84l4.15,2.67c0.61,0.39,0.61,1.29,0,1.68l-4.15,2.67C10.38,15.94,9.5,15.46,9.5,14.67z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 keyboard
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 5H4c-1.1 0-1.99.9-1.99 2L2 17c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm-9 3h2v2h-2V8zm0 3h2v2h-2v-2zM8 8h2v2H8V8zm0 3h2v2H8v-2zm-1 2H5v-2h2v2zm0-3H5V8h2v2zm8 7H9c-.55 0-1-.45-1-1s.45-1 1-1h6c.55 0 1 .45 1 1s-.45 1-1 1zm1-4h-2v-2h2v2zm0-3h-2V8h2v2zm3 3h-2v-2h2v2zm0-3h-2V8h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dock
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M9 23h6c.55 0 1-.45 1-1s-.45-1-1-1H9c-.55 0-1 .45-1 1s.45 1 1 1zm7-21.99L8 1c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM16 15H8V5h8v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 keyboard-arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M9.29 15.88L13.17 12 9.29 8.12c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0l4.59 4.59c.39.39.39 1.02 0 1.41L10.7 17.3c-.39.39-1.02.39-1.41 0-.38-.39-.39-1.03 0-1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 router
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11.45 5.55c.19.19.5.21.72.04C13.3 4.69 14.65 4.2 16 4.2s2.7.49 3.84 1.39c.21.17.52.15.72-.04l.04-.05c.22-.22.21-.59-.03-.8C19.24 3.57 17.62 3 16 3s-3.24.57-4.57 1.7c-.24.21-.26.57-.03.8l.05.05zm1.7.76c-.25.2-.26.58-.04.8l.04.04c.2.2.5.2.72.04.63-.48 1.38-.69 2.13-.69s1.5.21 2.13.68c.22.17.53.16.72-.04l.04-.04c.23-.23.21-.6-.04-.8-.83-.64-1.84-1-2.85-1s-2.02.36-2.85 1.01zM19 13h-2v-3c0-.55-.45-1-1-1s-1 .45-1 1v3H5c-1.1 0-2 .9-2 2v4c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-4c0-1.1-.9-2-2-2zM8 18H6v-2h2v2zm3.5 0h-2v-2h2v2zm3.5 0h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M11,14c0,0.55-0.45,1-1,1H7.25 c-0.41,0-0.75-0.34-0.75-0.75v0c0-0.41,0.34-0.75,0.75-0.75H9.5v-1H8c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1.5v-1 H7.25c-0.41,0-0.75-0.34-0.75-0.75v0C6.5,9.34,6.84,9,7.25,9H10c0.55,0,1,0.45,1,1V14z M16.59,15L16.59,15 c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.5c0,0.41-0.34,0.75-0.75,0.75h0C13.34,15,13,14.66,13,14.25v-4.5 C13,9.34,13.34,9,13.75,9h0c0.41,0,0.75,0.34,0.75,0.75v1.5l1.54-1.98C16.17,9.1,16.38,9,16.59,9l0,0c0.58,0,0.91,0.66,0.56,1.12 L15.75,12l1.41,1.88C17.5,14.34,17.17,15,16.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 music-video
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M20,18H4V6h16V18z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M10.84,16.98c1.26-0.17,2.16-1.33,2.16-2.6L13,9h2c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-2c-0.55,0-1,0.45-1,1v4.51 c-0.46-0.35-1.02-0.54-1.66-0.51c-1.11,0.07-2.09,0.92-2.3,2.02C7.73,15.73,9.15,17.2,10.84,16.98z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 new-releases
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "m22.42 11.34-1.86-2.12.26-2.81c.05-.5-.29-.96-.77-1.07l-2.76-.63-1.44-2.43c-.26-.43-.79-.61-1.25-.41L12 3 9.41 1.89c-.46-.2-1-.02-1.25.41L6.71 4.72l-2.75.62c-.49.11-.83.56-.78 1.07l.26 2.8-1.86 2.13c-.33.38-.33.94 0 1.32l1.86 2.12-.26 2.82c-.05.5.29.96.77 1.07l2.76.63 1.44 2.42c.26.43.79.61 1.26.41L12 21l2.59 1.11c.46.2 1 .02 1.25-.41l1.44-2.43 2.76-.63c.49-.11.82-.57.77-1.07l-.26-2.81 1.86-2.12c.34-.36.34-.92.01-1.3zM13 17h-2v-2h2v2zm-1-4c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1s1 .45 1 1v4c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pause
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M8 19c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2s-2 .9-2 2v10c0 1.1.9 2 2 2zm6-12v10c0 1.1.9 2 2 2s2-.9 2-2V7c0-1.1-.9-2-2-2s-2 .9-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 lyrics
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,9c0-2.04,1.24-3.79,3-4.57V4c0-1.1-0.9-2-2-2H4C2.9,2,2.01,2.9,2.01,4L2,22l4-4h9c1.1,0,2-0.9,2-2v-2.42 C15.24,12.8,14,11.05,14,9z M10,14H6v-2h4V14z M13,11H6V9h7V11z M13,8H6V6h7V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,6.18C19.69,6.07,19.35,6,19,6c-1.66,0-3,1.34-3,3c0,1.66,1.34,3,3,3s3-1.34,3-3V3h2V1h-4V6.18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 playlist-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M13 10H3c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1zm0-4H3c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1zm5 8v-3c0-.55-.45-1-1-1s-1 .45-1 1v3h-3c-.55 0-1 .45-1 1s.45 1 1 1h3v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1h-3zM3 16h6c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 control-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M4.65 9.35L2.7 11.3c-.39.39-.39 1.02 0 1.41l1.95 1.95c.49.49 1.28.49 1.77 0 .48-.49.48-1.27 0-1.76l-.88-.9.88-.89c.48-.49.48-1.27 0-1.76s-1.28-.49-1.77 0zm12.93 0c-.48.49-.48 1.27 0 1.76l.88.89-.88.89c-.48.49-.48 1.27 0 1.76.49.49 1.28.49 1.77 0l1.95-1.95c.39-.39.39-1.02 0-1.41l-1.95-1.95c-.49-.48-1.29-.48-1.77.01zM12 18.46l-.89-.88c-.49-.48-1.27-.48-1.76 0-.49.49-.49 1.28 0 1.77l1.95 1.95c.39.39 1.02.39 1.41 0l1.95-1.95c.49-.49.49-1.28 0-1.77-.49-.48-1.27-.48-1.76 0l-.9.88zM9.35 6.42c.49.48 1.27.48 1.76 0l.89-.88.89.88c.49.48 1.27.48 1.76 0 .49-.49.49-1.28 0-1.77L12.7 2.7c-.39-.39-1.02-.39-1.41 0L9.35 4.65c-.49.49-.49 1.29 0 1.77z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 hearing
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 20c-.29 0-.56-.06-.76-.15-.71-.37-1.21-.88-1.71-2.38-.51-1.56-1.47-2.29-2.39-3-.79-.61-1.61-1.24-2.32-2.53C9.29 10.98 9 9.93 9 9c0-2.8 2.2-5 5-5 2.56 0 4.63 1.85 4.95 4.31.06.4.41.69.82.69h.34c.5 0 .89-.44.83-.94C20.49 4.59 17.61 2 14 2c-3.93 0-7 3.07-7 7 0 1.26.38 2.65 1.07 3.9.91 1.65 1.98 2.48 2.85 3.15.81.62 1.39 1.07 1.71 2.05.6 1.82 1.37 2.84 2.73 3.55.51.23 1.07.35 1.64.35 1.84 0 3.39-1.24 3.86-2.93.14-.54-.25-1.07-.81-1.07h-.35c-.38 0-.68.27-.81.63-.26.79-1.01 1.37-1.89 1.37zM6.97 1.97c-.43-.43-1.12-.39-1.5.07C3.93 3.94 3 6.36 3 9s.93 5.06 2.47 6.95c.38.46 1.07.5 1.49.08.36-.36.39-.93.07-1.32C5.77 13.16 5 11.17 5 9s.77-4.16 2.04-5.7c.33-.4.29-.97-.07-1.33zM11.5 9c0 1.38 1.12 2.5 2.5 2.5s2.5-1.12 2.5-2.5-1.12-2.5-2.5-2.5-2.5 1.12-2.5 2.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21.41 9.41l-4.83-4.83c-.37-.37-.88-.58-1.41-.58H4c-1.1 0-2 .9-2 2v12.01c0 1.1.89 1.99 1.99 1.99H20c1.1 0 2-.9 2-2v-7.17c0-.53-.21-1.04-.59-1.42zM15 5.5l5.5 5.5H16c-.55 0-1-.45-1-1V5.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3 6c-.55 0-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1zm17-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-8 12.5v-9l5.47 4.1c.27.2.27.6 0 .8L12 14.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _5g
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,13h1v2h-5V9h6c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-6c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h5c1.1,0,2-0.9,2-2v-3 c0-0.55-0.45-1-1-1h-2c-0.55,0-1,0.45-1,1v0C17,12.55,17.45,13,18,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,13h4v2H4c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h4c1.1,0,2-0.9,2-2v-2c0-1.1-0.9-2-2-2H5V9h4c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H4C3.45,7,3,7.45,3,8v4C3,12.55,3.45,13,4,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 surround-sound
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM7.11 16.89c-.43.43-1.14.39-1.51-.09C4.53 15.39 4 13.69 4 12s.53-3.38 1.59-4.8c.37-.48 1.08-.53 1.51-.1.35.35.39.9.1 1.29C6.4 9.46 6 10.73 6 12s.4 2.53 1.2 3.6c.3.39.26.94-.09 1.29zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4zm4.9.9c-.35-.35-.39-.9-.09-1.29C17.6 14.54 18 13.27 18 12s-.4-2.53-1.2-3.6c-.3-.39-.26-.95.09-1.3.43-.43 1.14-.39 1.51.09 1.07 1.41 1.6 3.1 1.6 4.8 0 1.69-.53 3.38-1.59 4.8-.37.49-1.08.54-1.51.11zM12 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 closed-caption-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    {:enable-background "new"}
    (helix.dom/path
     {:d
      "M19,4H5C3.89,4,3,4.9,3,6v12c0,1.1,0.89,2,2,2h14c1.1,0,2-0.9,2-2V6C21,4.9,20.1,4,19,4z M11,10.5 c0,0.28-0.22,0.5-0.5,0.5H10c-0.28,0-0.5-0.22-0.5-0.5h-2v3h2c0-0.28,0.22-0.5,0.5-0.5h0.5c0.28,0,0.5,0.22,0.5,0.5V14 c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h3c0.55,0,1,0.45,1,1V10.5z M18,10.5c0,0.28-0.22,0.5-0.5,0.5H17 c-0.28,0-0.5-0.22-0.5-0.5h-2v3h2c0-0.28,0.22-0.5,0.5-0.5h0.5c0.28,0,0.5,0.22,0.5,0.5V14c0,0.55-0.45,1-1,1h-3 c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h3c0.55,0,1,0.45,1,1V10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 repeat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M7 7h10v1.79c0 .45.54.67.85.35l2.79-2.79c.2-.2.2-.51 0-.71l-2.79-2.79c-.31-.31-.85-.09-.85.36V5H6c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1s1-.45 1-1V7zm10 10H7v-1.79c0-.45-.54-.67-.85-.35l-2.79 2.79c-.2.2-.2.51 0 .71l2.79 2.79c.31.31.85.09.85-.36V19h11c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1s-1 .45-1 1v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _9k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,10h1.5v1.5H8V10z M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M11,14 c0,0.55-0.45,1-1,1H7.25c-0.41,0-0.75-0.34-0.75-0.75v0c0-0.41,0.34-0.75,0.75-0.75H9.5v-1h-2c-0.55,0-1-0.45-1-1V10 c0-0.55,0.45-1,1-1H10c0.55,0,1,0.45,1,1V14z M16.59,15L16.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55 c0,0.39-0.31,0.7-0.7,0.7H13.7c-0.39,0-0.7-0.31-0.7-0.7V9.7C13,9.31,13.31,9,13.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98 C16.17,9.1,16.38,9,16.59,9l0,0c0.58,0,0.91,0.66,0.56,1.12L15.75,12l1.41,1.88C17.5,14.34,17.17,15,16.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sd
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,4H4C2.89,4,2,4.9,2,6v12c0,1.1,0.89,2,2,2h16c1.1,0,2-0.9,2-2V6C22,4.9,21.1,4,20,4z M13,9h4c0.55,0,1,0.45,1,1v4 c0,0.55-0.45,1-1,1h-4V9z M9.5,13.5v-1H7c-0.55,0-1-0.45-1-1V10c0-0.55,0.45-1,1-1h3c0.55,0,1,0.45,1,1v1H9.5v-0.5h-2v1H10 c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1v-1h1.5v0.5H9.5z M14.5,13.5h2v-3h-2V13.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pause-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M10 16c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1s-1 .45-1 1v6c0 .55.45 1 1 1zm2-14C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm2-4c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1s-1 .45-1 1v6c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 audio-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.41,7.41l-4.83-4.83C14.21,2.21,13.7,2,13.17,2H6C4.9,2,4.01,2.9,4.01,4L4,20c0,1.1,0.89,2,1.99,2H18c1.1,0,2-0.9,2-2 V8.83C20,8.3,19.79,7.79,19.41,7.41z M15,13h-2v3.61c0,1.28-1,2.41-2.28,2.39c-1.44-0.02-2.56-1.39-2.13-2.91 c0.21-0.72,0.8-1.31,1.53-1.51c0.7-0.19,1.36-0.05,1.88,0.29V12c0-0.55,0.45-1,1-1h2c0.55,0,1,0.45,1,1C16,12.55,15.55,13,15,13z M14,9c-0.55,0-1-0.45-1-1V3.5L18.5,9H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _2k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,11.5c0,0.55-0.45,1-1,1H7.5v1 h1.75c0.41,0,0.75,0.34,0.75,0.75v0C10,14.66,9.66,15,9.25,15H7c-0.55,0-1-0.45-1-1v-1.5c0-0.55,0.45-1,1-1h1.5v-1H6.75 C6.34,10.5,6,10.16,6,9.75v0C6,9.34,6.34,9,6.75,9H9c0.55,0,1,0.45,1,1V11.5z M14.04,14.73l-1.54-1.98v1.5 c0,0.41-0.34,0.75-0.75,0.75h0C11.34,15,11,14.66,11,14.25v-4.5C11,9.34,11.34,9,11.75,9h0c0.41,0,0.75,0.34,0.75,0.75v1.5 l1.54-1.98C14.17,9.1,14.38,9,14.59,9h0c0.58,0,0.91,0.66,0.56,1.12L13.75,12l1.41,1.88C15.5,14.34,15.17,15,14.59,15h0 C14.38,15,14.17,14.9,14.04,14.73z M18.5,12.5h-1v1c0,0.28-0.22,0.5-0.5,0.5l0,0c-0.28,0-0.5-0.22-0.5-0.5v-1h-1 c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1c0-0.28,0.22-0.5,0.5-0.5l0,0c0.28,0,0.5,0.22,0.5,0.5v1h1 c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 videocam
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 10.5V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l2.29 2.29c.63.63 1.71.18 1.71-.71V8.91c0-.89-1.08-1.34-1.71-.71L17 10.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 movie
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18 4l1.82 3.64c.08.16-.04.36-.22.36h-1.98c-.38 0-.73-.21-.89-.55L15 4h-2l1.82 3.64c.08.16-.04.36-.22.36h-1.98c-.38 0-.73-.21-.89-.55L10 4H8l1.82 3.64c.08.16-.04.36-.22.36H7.62c-.38 0-.73-.21-.9-.55L5 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V5c0-.55-.45-1-1-1h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 library-music
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-3 5h-2v5.37c0 1.27-.9 2.44-2.16 2.6-1.69.23-3.11-1.25-2.8-2.95.2-1.1 1.18-1.95 2.3-2.02.63-.04 1.2.16 1.66.51V6c0-.55.45-1 1-1h2c.55 0 1 .45 1 1s-.45 1-1 1zM3 6c-.55 0-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _10k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,10.5h1.5v3H10V10.5z M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M6.75,15 L6.75,15C6.34,15,6,14.66,6,14.25V10.5H5.25c-0.41,0-0.75-0.34-0.75-0.75v0C4.5,9.34,4.84,9,5.25,9H6.5c0.55,0,1,0.45,1,1v4.25 C7.5,14.66,7.16,15,6.75,15z M13,14c0,0.55-0.45,1-1,1H9.5c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1H12c0.55,0,1,0.45,1,1V14z M17.59,15L17.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.5c0,0.41-0.34,0.75-0.75,0.75h0C14.34,15,14,14.66,14,14.25v-4.5 C14,9.34,14.34,9,14.75,9h0c0.41,0,0.75,0.34,0.75,0.75v1.5l1.54-1.98C17.17,9.1,17.38,9,17.59,9l0,0c0.58,0,0.91,0.66,0.56,1.12 L16.75,12l1.41,1.88C18.5,14.34,18.17,15,17.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fiber-manual-record
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/circle
   {:r "8", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 shuffle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M10.59 9.17L6.12 4.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l4.46 4.46 1.42-1.4zm4.76-4.32l1.19 1.19L4.7 17.88c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L17.96 7.46l1.19 1.19c.31.31.85.09.85-.36V4.5c0-.28-.22-.5-.5-.5h-3.79c-.45 0-.67.54-.36.85zm-.52 8.56l-1.41 1.41 3.13 3.13-1.2 1.2c-.31.31-.09.85.36.85h3.79c.28 0 .5-.22.5-.5v-3.79c0-.45-.54-.67-.85-.35l-1.19 1.19-3.13-3.14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pause-circle-filled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 14c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1s1 .45 1 1v6c0 .55-.45 1-1 1zm4 0c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1s1 .45 1 1v6c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 radio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3.24 6.15C2.51 6.43 2 7.17 2 8v12c0 1.1.9 2 2 2h16c1.11 0 2-.9 2-2V8c0-1.1-.9-2-2-2H8.3l7.43-3c.46-.19.68-.71.49-1.17-.19-.46-.71-.68-1.17-.49L3.24 6.15zM7 20c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm13-8h-2v-1c0-.55-.45-1-1-1s-1 .45-1 1v1H4V9c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-circle-filled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M18,12.74c-0.12,3.09-2.67,5.64-5.76,5.76 c-3.01,0.12-5.56-1.99-6.12-4.82C5.99,13.07,6.48,12.5,7.1,12.5h0c0.47,0,0.88,0.33,0.98,0.8c0.42,2.07,2.44,3.57,4.72,3.12 c1.56-0.3,2.82-1.56,3.12-3.12c0.5-2.56-1.45-4.8-3.92-4.8v1.79c0,0.45-0.54,0.67-0.85,0.35L8.35,7.85c-0.2-0.2-0.2-0.51,0-0.71 l2.79-2.79C11.46,4.04,12,4.26,12,4.71V6.5C15.39,6.5,18.13,9.32,18,12.74z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _6k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.5,12.5h1V14h-1V12.5z M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M9.25,10.5 H7.5v1H9c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H7c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h2.25C9.66,9,10,9.34,10,9.75v0 C10,10.16,9.66,10.5,9.25,10.5z M14.59,15L14.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7H11.7 c-0.39,0-0.7-0.31-0.7-0.7V9.7C11,9.31,11.31,9,11.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98C14.17,9.1,14.38,9,14.59,9h0 c0.58,0,0.91,0.66,0.56,1.12L13.75,12l1.41,1.88C15.5,14.34,15.17,15,14.59,15z M18.5,12.5h-1v1c0,0.28-0.22,0.5-0.5,0.5l0,0 c-0.28,0-0.5-0.22-0.5-0.5v-1h-1c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1c0-0.28,0.22-0.5,0.5-0.5l0,0 c0.28,0,0.5,0.22,0.5,0.5v1h1c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 high-quality
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-8.75 11c-.41 0-.75-.34-.75-.75V13h-2v1.25c0 .41-.34.75-.75.75S6 14.66 6 14.25v-4.5c0-.41.34-.75.75-.75s.75.34.75.75v1.75h2V9.75c0-.41.34-.75.75-.75s.75.34.75.75v4.5c0 .41-.34.75-.75.75zM18 14c0 .55-.45 1-1 1h-.75v.75c0 .41-.34.75-.75.75s-.75-.34-.75-.75V15H14c-.55 0-1-.45-1-1v-4c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v4zm-3.5-.5h2v-3h-2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-from-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h5c1.1 0 2-.9 2-2V5c0-1.11-.9-2-2-2zm-1 14H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1zm-4-6c0 .55-.45 1-1 1H9c-.55 0-1-.45-1-1s.45-1 1-1h6c.55 0 1 .45 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10.25,13.5H10v0.75 C10,14.66,9.66,15,9.25,15h0c-0.41,0-0.75-0.34-0.75-0.75V13.5h-2c-0.55,0-1-0.45-1-1V9.75C5.5,9.34,5.84,9,6.25,9h0 C6.66,9,7,9.34,7,9.75V12h1.5V9.75C8.5,9.34,8.84,9,9.25,9h0C9.66,9,10,9.34,10,9.75V12h0.25c0.41,0,0.75,0.34,0.75,0.75v0 C11,13.16,10.66,13.5,10.25,13.5z M15.09,15L15.09,15c-0.22,0-0.42-0.1-0.55-0.27L13,12.75v1.55c0,0.39-0.31,0.7-0.7,0.7H12.2 c-0.39,0-0.7-0.31-0.7-0.7V9.7c0-0.39,0.31-0.7,0.7-0.7h0.09C12.69,9,13,9.31,13,9.7v1.55l1.54-1.98C14.67,9.1,14.88,9,15.09,9h0 c0.58,0,0.91,0.66,0.56,1.12L14.25,12l1.41,1.88C16,14.34,15.67,15,15.09,15z M18.5,12.5h-1v1c0,0.28-0.22,0.5-0.5,0.5l0,0 c-0.28,0-0.5-0.22-0.5-0.5v-1h-1c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1c0-0.28,0.22-0.5,0.5-0.5l0,0 c0.28,0,0.5,0.22,0.5,0.5v1h1c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 hd
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-8.75 12c-.41 0-.75-.34-.75-.75V13h-2v1.25c0 .41-.34.75-.75.75S6 14.66 6 14.25v-4.5c0-.41.34-.75.75-.75s.75.34.75.75v1.75h2V9.75c0-.41.34-.75.75-.75s.75.34.75.75v4.5c0 .41-.34.75-.75.75zm3.25-6H17c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1h-3.5c-.28 0-.5-.22-.5-.5v-5c0-.28.22-.5.5-.5zm1 4.5h2v-3h-2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 5V2.21c0-.45-.54-.67-.85-.35l-3.8 3.79c-.2.2-.2.51 0 .71l3.79 3.79c.32.31.86.09.86-.36V7c3.73 0 6.68 3.42 5.86 7.29-.47 2.26-2.14 3.99-4.39 4.53-3.64.88-6.93-1.6-7.42-4.96-.06-.49-.48-.86-.97-.86-.6 0-1.08.53-1 1.13.63 4.47 4.94 7.75 9.77 6.67 3.09-.69 5.39-3.08 5.99-6.19C20.84 9.48 16.94 5 12 5zm-1.31 8.9l.25-2.17h2.39v.71h-1.7l-.11.92c.03-.02.07-.03.11-.05s.09-.04.15-.05.12-.03.18-.04.13-.02.2-.02c.21 0 .39.03.55.1s.3.16.41.28.2.27.25.45.09.38.09.6c0 .19-.03.37-.09.54s-.15.32-.27.45-.27.24-.45.31-.39.12-.64.12c-.18 0-.36-.03-.53-.08s-.32-.14-.46-.24-.24-.24-.32-.39-.13-.33-.13-.53h.84c.02.18.08.32.19.41s.25.15.42.15c.11 0 .2-.02.27-.06s.14-.1.18-.17.08-.15.11-.25.03-.2.03-.31-.01-.21-.04-.31-.07-.17-.13-.24-.13-.12-.21-.15-.19-.05-.3-.05c-.08 0-.15.01-.2.02s-.11.03-.15.05-.08.05-.12.07-.07.06-.1.09l-.67-.16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 equalizer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 20c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2s-2 .9-2 2v12c0 1.1.9 2 2 2zm-6 0c1.1 0 2-.9 2-2v-4c0-1.1-.9-2-2-2s-2 .9-2 2v4c0 1.1.9 2 2 2zm10-9v7c0 1.1.9 2 2 2s2-.9 2-2v-7c0-1.1-.9-2-2-2s-2 .9-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M7,8c0-0.55,0.45-1,1-1h5c0.55,0,1,0.45,1,1v0 c0,0.55-0.45,1-1,1H8C7.45,9,7,8.55,7,8L7,8z M10,14c0,0.55-0.45,1-1,1H8c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h1 C9.55,13,10,13.45,10,14L10,14z M8,12c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h5c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H8z M18,15 h-1v1c0,0.55-0.45,1-1,1s-1-0.45-1-1v-1h-1c-0.55,0-1-0.45-1-1s0.45-1,1-1h1v-1c0-0.55,0.45-1,1-1s1,0.45,1,1v1h1c0.55,0,1,0.45,1,1 S18.55,15,18,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18.5 12c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM5 10v4c0 .55.45 1 1 1h3l3.29 3.29c.63.63 1.71.18 1.71-.71V6.41c0-.89-1.08-1.34-1.71-.71L9 9H6c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 slow-motion-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M10 8.5v7c0 .41.47.65.8.4l4.67-3.5c.27-.2.27-.6 0-.8L10.8 8.1c-.33-.25-.8-.01-.8.4zm1-5.27c0-.64-.59-1.13-1.21-.99-1.12.26-2.18.7-3.12 1.3-.53.34-.61 1.1-.16 1.55.32.32.83.4 1.21.16.77-.49 1.62-.85 2.54-1.05.44-.1.74-.51.74-.97zM5.1 6.51c-.46-.45-1.21-.38-1.55.16-.6.94-1.04 2-1.3 3.12-.14.62.34 1.21.98 1.21.45 0 .87-.3.96-.74.2-.91.57-1.77 1.05-2.53.26-.39.18-.9-.14-1.22zM3.23 13c-.64 0-1.13.59-.99 1.21.26 1.12.7 2.17 1.3 3.12.34.54 1.1.61 1.55.16.32-.32.4-.83.15-1.21-.49-.76-.85-1.61-1.05-2.53-.09-.45-.5-.75-.96-.75zm3.44 7.45c.95.6 2 1.04 3.12 1.3.62.14 1.21-.35 1.21-.98 0-.45-.3-.87-.74-.96-.91-.2-1.77-.57-2.53-1.05-.39-.24-.89-.17-1.21.16-.46.44-.39 1.19.15 1.53zM22 12c0 4.73-3.3 8.71-7.73 9.74-.62.15-1.22-.34-1.22-.98 0-.46.31-.86.75-.97 3.55-.82 6.2-4 6.2-7.79s-2.65-6.97-6.2-7.79c-.44-.1-.75-.51-.75-.97 0-.64.6-1.13 1.22-.98C18.7 3.29 22 7.27 22 12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-pin
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zM9 11.5c0 .83-.67 1.5-1.5 1.5h-2v1.25c0 .41-.34.75-.75.75S4 14.66 4 14.25V10c0-.55.45-1 1-1h2.5c.83 0 1.5.67 1.5 1.5v1zm3.5 2.75c0 .41-.34.75-.75.75s-.75-.34-.75-.75v-4.5c0-.41.34-.75.75-.75s.75.34.75.75v4.5zm7.5-.04c0 .44-.35.79-.79.79-.25 0-.49-.12-.64-.33l-2.31-3.17v2.88c0 .34-.28.62-.62.62h-.01c-.35 0-.63-.28-.63-.62V9.83c0-.46.37-.83.83-.83.27 0 .52.13.67.35l2.25 3.15V9.62c0-.34.28-.62.62-.62h.01c.34 0 .62.28.62.62v4.59zM5.5 10.5h2v1h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2.1,3.51L2.1,3.51c-0.39,0.39-0.39,1.02,0,1.41l5.9,5.9v6.35c0,0.79,0.87,1.27,1.54,0.84l3.45-2.2l6.08,6.08 c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51C3.12,3.12,2.49,3.12,2.1,3.51z M17.68,12.84 c0.62-0.39,0.62-1.29,0-1.69L9.54,5.98C9.27,5.81,8.97,5.79,8.7,5.87l7.75,7.75L17.68,12.84z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 playlist-remove
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.71,21.3c0.39,0.39,1.02,0.39,1.41,0L17,19.41l1.89,1.89c0.39,0.39,1.02,0.39,1.41,0s0.39-1.02,0-1.41L18.41,18 l1.89-1.89c0.39-0.39,0.39-1.02,0-1.41s-1.02-0.39-1.41,0L17,16.59l-1.89-1.89c-0.39-0.39-1.02-0.39-1.41,0s-0.39,1.02,0,1.41 L15.59,18l-1.89,1.89C13.32,20.27,13.32,20.91,13.71,21.3z M14,11c0-0.55-0.45-1-1-1H4c-0.55,0-1,0.45-1,1s0.45,1,1,1h9 C13.55,12,14,11.55,14,11z M14,7c0-0.55-0.45-1-1-1H4C3.45,6,3,6.45,3,7s0.45,1,1,1h9C13.55,8,14,7.55,14,7z M3,15 c0,0.55,0.45,1,1,1h5c0.55,0,1-0.45,1-1s-0.45-1-1-1H4C3.45,14,3,14.45,3,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 play-circle-filled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-2 13.5v-7c0-.41.47-.65.8-.4l4.67 3.5c.27.2.27.6 0 .8l-4.67 3.5c-.33.25-.8.01-.8-.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 library-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3 6c-.55 0-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1zm17-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 9h-3v3c0 .55-.45 1-1 1s-1-.45-1-1v-3h-3c-.55 0-1-.45-1-1s.45-1 1-1h3V6c0-.55.45-1 1-1s1 .45 1 1v3h3c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,14c0,0.55-0.45,1-1,1H6.25 c-0.41,0-0.75-0.34-0.75-0.75v0c0-0.41,0.34-0.75,0.75-0.75H8.5v-1H7c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1.5v-1 H6.25c-0.41,0-0.75-0.34-0.75-0.75v0C5.5,9.34,5.84,9,6.25,9H9c0.55,0,1,0.45,1,1V14z M14.59,15L14.59,15 c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.5c0,0.41-0.34,0.75-0.75,0.75h0C11.34,15,11,14.66,11,14.25l-0.03-4.49 C10.96,9.34,11.3,9,11.72,9h0c0.41,0,0.75,0.33,0.75,0.74l0.03,1.51l1.54-1.98C14.17,9.1,14.38,9,14.59,9h0 c0.58,0,0.91,0.66,0.56,1.12L13.75,12l1.41,1.88C15.5,14.34,15.17,15,14.59,15z M18.5,12.5h-1v1c0,0.28-0.22,0.5-0.5,0.5l0,0 c-0.28,0-0.5-0.22-0.5-0.5v-1h-1c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1c0-0.28,0.22-0.5,0.5-0.5l0,0 c0.28,0,0.5,0.22,0.5,0.5v1h1c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 missed-video-call
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 10.5V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l2.29 2.29c.63.63 1.71.18 1.71-.71V8.91c0-.89-1.08-1.34-1.71-.71L17 10.5zm-6.29 3.79c-.39.39-1.02.39-1.41 0l-3.18-3.18v2.55H5V9.72c0-.28.22-.5.5-.5h3.94v1.11H6.89l3.11 3.1 4.22-4.22.78.79-4.29 4.29z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 explicit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 6h-3v2h3c.55 0 1 .45 1 1s-.45 1-1 1h-3v2h3c.55 0 1 .45 1 1s-.45 1-1 1h-4c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1h4c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 featured-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-10 9H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h7c.55 0 1 .45 1 1v5c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 speed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.46 10a1 1 0 0 0-.07 1 7.55 7.55 0 0 1 .52 1.81 8 8 0 0 1-.69 4.73 1 1 0 0 1-.89.53H5.68a1 1 0 0 1-.89-.54A8 8 0 0 1 13 6.06a7.69 7.69 0 0 1 2.11.56 1 1 0 0 0 1-.07 1 1 0 0 0-.17-1.76A10 10 0 0 0 3.35 19a2 2 0 0 0 1.72 1h13.85a2 2 0 0 0 1.74-1 10 10 0 0 0 .55-8.89 1 1 0 0 0-1.75-.11z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d "M10.59 12.59a2 2 0 0 0 2.83 2.83l5.66-8.49z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sort-by-alpha
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12.93 2.65c-.2-.2-.51-.2-.71 0l-2.01 2.01h4.72l-2-2.01zm-.7 18.7c.2.2.51.2.71 0l1.98-1.98h-4.66l1.97 1.98zm-1.25-3.62c.6 0 1.01-.6.79-1.16L8.04 7.03c-.18-.46-.63-.76-1.12-.76-.49 0-.94.3-1.12.76l-3.74 9.53c-.22.56.19 1.16.79 1.16.35 0 .67-.22.8-.55l.71-1.9h5.11l.71 1.9c.13.34.45.56.8.56zm-6.01-4.09l1.94-5.18 1.94 5.18H4.97zm16.08 2.5h-5.33l5.72-8.29c.46-.66-.02-1.57-.82-1.57h-6.48c-.44 0-.79.36-.79.8v.01c0 .44.36.8.79.8h5.09l-5.73 8.28c-.46.66.02 1.57.82 1.57h6.72c.44 0 .79-.36.79-.79.02-.45-.34-.81-.78-.81z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM4 9h10.5v3.5H4V9zm0 5.5h10.5V18H5c-.55 0-1-.45-1-1v-2.5zM19 18h-2.5V9H20v8c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mic-none
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 14c1.66 0 3-1.34 3-3V5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm-1-9c0-.55.45-1 1-1s1 .45 1 1v6c0 .55-.45 1-1 1s-1-.45-1-1V5zm6.91 6c-.49 0-.9.36-.98.85C16.52 14.2 14.47 16 12 16s-4.52-1.8-4.93-4.15c-.08-.49-.49-.85-.98-.85-.61 0-1.09.54-1 1.14.49 3 2.89 5.35 5.91 5.78V20c0 .55.45 1 1 1s1-.45 1-1v-2.08c3.02-.43 5.42-2.78 5.91-5.78.1-.6-.39-1.14-1-1.14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-10
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11.99 5V2.21c0-.45-.54-.67-.85-.35L7.35 5.65c-.2.2-.2.51 0 .71l3.79 3.79c.31.31.85.09.85-.35V7c3.73 0 6.68 3.42 5.86 7.29-.47 2.27-2.31 4.1-4.57 4.57-3.57.75-6.75-1.7-7.23-5.01-.06-.48-.48-.85-.98-.85-.6 0-1.08.53-1 1.13.62 4.39 4.8 7.64 9.53 6.72 3.12-.61 5.63-3.12 6.24-6.24.99-5.13-2.9-9.61-7.85-9.61zm-1.1 11h-.85v-3.26l-1.01.31v-.69l1.77-.63h.09V16zm4.28-1.76c0 .32-.03.6-.1.82s-.17.42-.29.57-.28.26-.45.33-.37.1-.59.1-.41-.03-.59-.1-.33-.18-.46-.33-.23-.34-.3-.57-.11-.5-.11-.82v-.74c0-.32.03-.6.1-.82s.17-.42.29-.57.28-.26.45-.33.37-.1.59-.1.41.03.59.1.33.18.46.33.23.34.3.57.11.5.11.82v.74zm-.85-.86c0-.19-.01-.35-.04-.48s-.07-.23-.12-.31-.11-.14-.19-.17-.16-.05-.25-.05-.18.02-.25.05-.14.09-.19.17-.09.18-.12.31-.04.29-.04.48v.97c0 .19.01.35.04.48s.07.24.12.32.11.14.19.17.16.05.25.05.18-.02.25-.05.14-.09.19-.17.09-.19.11-.32.04-.29.04-.48v-.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-arrow
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M8 6.82v10.36c0 .79.87 1.27 1.54.84l8.14-5.18c.62-.39.62-1.29 0-1.69L9.54 5.98C8.87 5.55 8 6.03 8 6.82z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 forward-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18.87 13c-.5 0-.91.37-.98.86-.48 3.37-3.77 5.84-7.42 4.96-2.25-.54-3.91-2.27-4.39-4.53C5.27 10.42 8.22 7 11.95 7v2.79c0 .45.54.67.85.35l3.79-3.79c.2-.2.2-.51 0-.71L12.8 1.85c-.31-.31-.85-.09-.85.35V5c-4.94 0-8.84 4.48-7.84 9.6.6 3.11 2.9 5.5 5.99 6.19 4.83 1.08 9.15-2.2 9.77-6.67.09-.59-.4-1.12-1-1.12zm-6.44 2.15c-.05.07-.11.13-.18.17s-.17.06-.27.06c-.17 0-.31-.05-.42-.15s-.17-.24-.19-.41h-.84c.01.2.05.37.13.53s.19.28.32.39.29.19.46.24.35.08.53.08c.24 0 .46-.04.64-.12s.33-.18.45-.31.21-.28.27-.45.09-.35.09-.54c0-.22-.03-.43-.09-.6s-.14-.33-.25-.45-.25-.22-.41-.28-.34-.1-.55-.1c-.07 0-.14.01-.2.02s-.13.02-.18.04-.1.03-.15.05-.08.04-.11.05l.11-.92h1.7v-.71H10.9l-.25 2.17.67.17c.03-.03.06-.06.1-.09s.07-.05.12-.07.1-.04.15-.05.13-.02.2-.02c.12 0 .22.02.3.05s.16.09.21.15.1.14.13.24.04.19.04.31-.01.22-.03.31-.06.17-.11.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue-play-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h1c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v6c0 .55.45 1 1 1s1-.45 1-1V5c0-1.1-.9-2-2-2zm-8 7V8c0-.55-.45-1-1-1s-1 .45-1 1v2H9c-.55 0-1 .45-1 1s.45 1 1 1h2v2c0 .55.45 1 1 1s1-.45 1-1v-2h2c.55 0 1-.45 1-1s-.45-1-1-1h-2zm10.29 8.71l-3.04 3.04c-.41.41-1.09.41-1.5 0-.41-.41-.41-1.09 0-1.5L21 18l-2.25-2.25c-.41-.41-.41-1.09 0-1.5.41-.41 1.09-.41 1.5 0l3.04 3.04c.39.39.39 1.03 0 1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3.63 3.63c-.39.39-.39 1.02 0 1.41L7.29 8.7 7 9H4c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h3l3.29 3.29c.63.63 1.71.18 1.71-.71v-4.17l4.18 4.18c-.49.37-1.02.68-1.6.91-.36.15-.58.53-.58.92 0 .72.73 1.18 1.39.91.8-.33 1.55-.77 2.22-1.31l1.34 1.34c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.05 3.63c-.39-.39-1.02-.39-1.42 0zM19 12c0 .82-.15 1.61-.41 2.34l1.53 1.53c.56-1.17.88-2.48.88-3.87 0-3.83-2.4-7.11-5.78-8.4-.59-.23-1.22.23-1.22.86v.19c0 .38.25.71.61.85C17.18 6.54 19 9.06 19 12zm-8.71-6.29l-.17.17L12 7.76V6.41c0-.89-1.08-1.33-1.71-.7zM16.5 12c0-1.77-1.02-3.29-2.5-4.03v1.79l2.48 2.48c.01-.08.02-.16.02-.24z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 interpreter-mode
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.5,16.5c-0.83,0-1.5-0.67-1.5-1.5v-2.5c0-0.83,0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5V15C22,15.83,21.33,16.5,20.5,16.5z M20.5,20c0.28,0,0.5-0.22,0.5-0.5c0-0.45,0-1.04,0-1.04c1.51-0.22,2.71-1.4,2.95-2.89C24,15.27,23.76,15,23.46,15 c-0.24,0-0.45,0.17-0.49,0.41c-0.2,1.18-1.23,2.09-2.47,2.09s-2.27-0.9-2.47-2.09C17.99,15.17,17.78,15,17.54,15 c-0.3,0-0.54,0.27-0.5,0.57c0.25,1.5,1.45,2.68,2.95,2.89c0,0,0,0.59,0,1.04C20,19.78,20.22,20,20.5,20z M9,12c-2.21,0-4-1.79-4-4 c0-2.21,1.79-4,4-4c0.47,0,0.92,0.08,1.34,0.23C9.5,5.26,9,6.57,9,8c0,1.43,0.5,2.74,1.34,3.77C9.92,11.92,9.47,12,9,12z M7.11,13.13C5.79,14.05,5,15.57,5,17.22V20H1v-2.78c0-1.12,0.61-2.15,1.61-2.66C3.85,13.92,5.37,13.37,7.11,13.13z M11,8 c0-2.21,1.79-4,4-4s4,1.79,4,4c0,2.21-1.79,4-4,4S11,10.21,11,8z M18.32,20c-1.67-0.81-2.82-2.52-2.82-4.5 c0-0.89,0.23-1.73,0.64-2.45C15.77,13.02,15.39,13,15,13c-2.53,0-4.71,0.7-6.39,1.56C7.61,15.07,7,16.1,7,17.22V20L18.32,20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _1k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M8.25,15L8.25,15 c-0.41,0-0.75-0.34-0.75-0.75V10.5H6.75C6.34,10.5,6,10.16,6,9.75v0C6,9.34,6.34,9,6.75,9H8c0.55,0,1,0.45,1,1v4.25 C9,14.66,8.66,15,8.25,15z M13.54,14.73L12,12.75v1.55c0,0.39-0.31,0.7-0.7,0.7H11.2c-0.39,0-0.7-0.31-0.7-0.7V9.7 c0-0.39,0.31-0.7,0.7-0.7h0.09C11.69,9,12,9.31,12,9.7v1.55l1.54-1.98C13.67,9.1,13.88,9,14.09,9h0c0.58,0,0.91,0.66,0.56,1.12 L13.25,12l1.41,1.88C15,14.34,14.67,15,14.09,15h0C13.88,15,13.67,14.9,13.54,14.73z M18.5,12.5h-1v1c0,0.28-0.22,0.5-0.5,0.5l0,0 c-0.28,0-0.5-0.22-0.5-0.5v-1h-1c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1c0-0.28,0.22-0.5,0.5-0.5l0,0 c0.28,0,0.5,0.22,0.5,0.5v1h1c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 closed-caption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-8 6.5c0 .28-.22.5-.5.5H10c-.28 0-.5-.22-.5-.5h-2v3h2c0-.28.22-.5.5-.5h.5c.28 0 .5.22.5.5v.5c0 .55-.45 1-1 1H7c-.55 0-1-.45-1-1v-4c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v.5zm7 0c0 .28-.22.5-.5.5H17c-.28 0-.5-.22-.5-.5h-2v3h2c0-.28.22-.5.5-.5h.5c.28 0 .5.22.5.5v.5c0 .55-.45 1-1 1h-3c-.55 0-1-.45-1-1v-4c0-.55.45-1 1-1h3c.55 0 1 .45 1 1v.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4k
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.89-2-2-2zm-7 9.76c0 .41-.34.75-.75.75H11v.74c0 .41-.34.75-.75.75s-.75-.34-.75-.75v-.75h-2c-.55 0-1-.45-1-1V9.75c0-.41.34-.75.75-.75s.75.34.75.75V12h1.5V9.75c0-.41.34-.75.75-.75s.75.34.75.75V12h.25c.41 0 .75.34.75.75v.01zm5.47 1.14c.22.33.13.77-.2.98-.12.08-.26.12-.39.12-.23 0-.45-.11-.59-.32L14.5 12v2.24c0 .41-.34.75-.75.75-.41.01-.75-.33-.75-.74v-4.5c0-.41.34-.75.75-.75s.75.34.75.75v2.24l1.79-2.68c.22-.33.66-.41.98-.2.33.22.41.66.2.98L16.2 12l1.27 1.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.17,2H6.01c-1.1,0-2,0.89-2,2L4,20c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V8.83c0-0.53-0.21-1.04-0.59-1.41l-4.83-4.83 C14.21,2.21,13.7,2,13.17,2z M13,8V3.5L18.5,9H14C13.45,9,13,8.55,13,8z M14,14l1.27-0.67C15.6,13.15,16,13.39,16,13.77v2.46 c0,0.38-0.4,0.62-0.73,0.44L14,16v1c0,0.55-0.45,1-1,1H9c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 videocam-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 14.2V8.91c0-.89-1.08-1.34-1.71-.71L17 10.5V7c0-.55-.45-1-1-1h-5.61l8.91 8.91c.62.63 1.7.18 1.7-.71zM2.71 2.56c-.39.39-.39 1.02 0 1.41L4.73 6H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.21 0 .39-.08.55-.18l2.48 2.48c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L4.12 2.56c-.39-.39-1.02-.39-1.41 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-check
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M13 10H3c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1zm0-4H3c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1zM3 16h6c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1s.45 1 1 1zm19.21-3.79l.09.09c.39.39.39 1.02 0 1.41l-5.58 5.59c-.39.39-1.02.39-1.41 0l-3.09-3.09c-.39-.39-.39-1.02 0-1.41l.09-.09c.39-.39 1.02-.39 1.41 0l2.3 2.3 4.78-4.79c.38-.4 1.02-.4 1.41-.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 library-books
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3 6c-.55 0-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1zm17-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 9h-8c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1zm-4 4h-4c-.55 0-1-.45-1-1s.45-1 1-1h4c.55 0 1 .45 1 1s-.45 1-1 1zm4-8h-8c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mic
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 14c1.66 0 3-1.34 3-3V5c0-1.66-1.34-3-3-3S9 3.34 9 5v6c0 1.66 1.34 3 3 3zm5.91-3c-.49 0-.9.36-.98.85C16.52 14.2 14.47 16 12 16s-4.52-1.8-4.93-4.15c-.08-.49-.49-.85-.98-.85-.61 0-1.09.54-1 1.14.49 3 2.89 5.35 5.91 5.78V20c0 .55.45 1 1 1s1-.45 1-1v-2.08c3.02-.43 5.42-2.78 5.91-5.78.1-.6-.39-1.14-1-1.14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _5k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M9.25,10.5H7.5v1H9 c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H6.75C6.34,15,6,14.66,6,14.25v0c0-0.41,0.34-0.75,0.75-0.75H8.5v-1H7c-0.55,0-1-0.45-1-1 V10c0-0.55,0.45-1,1-1h2.25C9.66,9,10,9.34,10,9.75v0C10,10.16,9.66,10.5,9.25,10.5z M14.59,15L14.59,15 c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.5c0,0.41-0.34,0.75-0.75,0.75h0C11.34,15,11,14.66,11,14.25v-4.5 C11,9.34,11.34,9,11.75,9h0c0.41,0,0.75,0.34,0.75,0.75v1.5l1.54-1.98C14.17,9.1,14.38,9,14.59,9h0c0.58,0,0.91,0.66,0.56,1.12 L13.75,12l1.41,1.88C15.5,14.34,15.17,15,14.59,15z M18.5,12.5h-1v1c0,0.28-0.22,0.5-0.5,0.5l0,0c-0.28,0-0.5-0.22-0.5-0.5v-1h-1 c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1c0-0.28,0.22-0.5,0.5-0.5l0,0c0.28,0,0.5,0.22,0.5,0.5v1h1 c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 forward-10
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18.92 13c-.5 0-.91.37-.98.86-.48 3.37-3.77 5.84-7.42 4.96-2.25-.54-3.91-2.27-4.39-4.53C5.32 10.42 8.27 7 12 7v2.79c0 .45.54.67.85.35l3.79-3.79c.2-.2.2-.51 0-.71l-3.79-3.79c-.31-.31-.85-.09-.85.36V5c-4.94 0-8.84 4.48-7.84 9.6.6 3.11 2.9 5.5 5.99 6.19 4.83 1.08 9.15-2.2 9.77-6.67.09-.59-.4-1.12-1-1.12zm-8.02 3v-4.27h-.09l-1.77.63v.69l1.01-.31V16zm3.42-4.22c-.18-.07-.37-.1-.59-.1s-.41.03-.59.1-.33.18-.45.33-.23.34-.29.57-.1.5-.1.82v.74c0 .32.04.6.11.82s.17.42.3.57.28.26.46.33.37.1.59.1.41-.03.59-.1.33-.18.45-.33.22-.34.29-.57.1-.5.1-.82v-.74c0-.32-.04-.6-.11-.82s-.17-.42-.3-.57-.29-.26-.46-.33zm.01 2.57c0 .19-.01.35-.04.48s-.06.24-.11.32-.11.14-.19.17-.16.05-.25.05-.18-.02-.25-.05-.14-.09-.19-.17-.09-.19-.12-.32-.04-.29-.04-.48v-.97c0-.19.01-.35.04-.48s.06-.23.12-.31.11-.14.19-.17.16-.05.25-.05.18.02.25.05.14.09.19.17.09.18.12.31.04.29.04.48v.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stop-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M15,16H9c-0.55,0-1-0.45-1-1V9 c0-0.55,0.45-1,1-1h6c0.55,0,1,0.45,1,1v6C16,15.55,15.55,16,15,16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M8 6h8c1.1 0 2 .9 2 2v8c0 1.1-.9 2-2 2H8c-1.1 0-2-.9-2-2V8c0-1.1.9-2 2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 repeat-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M7 7h10v1.79c0 .45.54.67.85.35l2.79-2.79c.2-.2.2-.51 0-.71l-2.79-2.79c-.31-.31-.85-.09-.85.36V5H6c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1s1-.45 1-1V7zm10 10H7v-1.79c0-.45-.54-.67-.85-.35l-2.79 2.79c-.2.2-.2.51 0 .71l2.79 2.79c.31.31.85.09.85-.36V19h11c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1s-1 .45-1 1v3zm-4-2.75V9.81c0-.45-.36-.81-.81-.81-.13 0-.25.03-.36.09l-1.49.74c-.21.1-.34.32-.34.55 0 .34.28.62.62.62h.88v3.25c0 .41.34.75.75.75s.75-.34.75-.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 call-to-action
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H4c-.55 0-1-.45-1-1v-1c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v1c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-play
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M5 10h10c.55 0 1 .45 1 1s-.45 1-1 1H5c-.55 0-1-.45-1-1s.45-1 1-1zm0-4h10c.55 0 1 .45 1 1s-.45 1-1 1H5c-.55 0-1-.45-1-1s.45-1 1-1zm0 8h6c.55 0 1 .45 1 1s-.45 1-1 1H5c-.55 0-1-.45-1-1s.45-1 1-1zm9 .88v4.23c0 .39.42.63.76.43l3.53-2.12c.32-.19.32-.66 0-.86l-3.53-2.12c-.34-.19-.76.05-.76.44z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _7k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M8.95,15H8.76 c-0.5,0-0.86-0.49-0.72-0.97l1.08-3.53H7.25c-0.41,0-0.75-0.34-0.75-0.75v0C6.5,9.34,6.84,9,7.25,9H10c0.67,0,1.15,0.65,0.96,1.29 l-1.3,4.18C9.57,14.79,9.28,15,8.95,15z M16.59,15L16.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7 H13.7c-0.39,0-0.7-0.31-0.7-0.7V9.7C13,9.31,13.31,9,13.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98 C16.17,9.1,16.38,9,16.59,9l0,0c0.58,0,0.91,0.66,0.56,1.12L15.75,12l1.41,1.88C17.5,14.34,17.17,15,16.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _7k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.95,15H7.76 c-0.5,0-0.86-0.49-0.72-0.97l1.08-3.53H6.25c-0.41,0-0.75-0.34-0.75-0.75v0C5.5,9.34,5.83,9,6.25,9H9c0.67,0,1.15,0.65,0.96,1.29 l-1.3,4.18C8.56,14.79,8.27,15,7.95,15z M14.59,15L14.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7 H11.7c-0.39,0-0.7-0.31-0.7-0.7V9.7C11,9.31,11.31,9,11.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98 C14.17,9.1,14.38,9,14.59,9h0c0.58,0,0.91,0.66,0.56,1.12L13.75,12l1.41,1.88C15.5,14.34,15.17,15,14.59,15z M18.5,12.5h-1v1 c0,0.28-0.22,0.5-0.5,0.5l0,0c-0.28,0-0.5-0.22-0.5-0.5v-1h-1c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1 c0-0.28,0.22-0.5,0.5-0.5l0,0c0.28,0,0.5,0.22,0.5,0.5v1h1c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 subscriptions
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 8H5c-.55 0-1-.45-1-1s.45-1 1-1h14c.55 0 1 .45 1 1s-.45 1-1 1zm-2-6H7c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1zm5 10v8c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2v-8c0-1.1.9-2 2-2h16c1.1 0 2 .9 2 2zm-6.81 3.56L10 12.73v6.53l5.19-2.82c.35-.19.35-.69 0-.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fast-rewind
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M11 16.07V7.93c0-.81-.91-1.28-1.58-.82l-5.77 4.07c-.56.4-.56 1.24 0 1.63l5.77 4.07c.67.47 1.58 0 1.58-.81zm1.66-3.25l5.77 4.07c.66.47 1.58-.01 1.58-.82V7.93c0-.81-.91-1.28-1.58-.82l-5.77 4.07c-.57.4-.57 1.24 0 1.64z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M9.5,14.67V9.33c0-0.79,0.88-1.27,1.54-0.84 l4.15,2.67c0.61,0.39,0.61,1.29,0,1.68l-4.15,2.67C10.38,15.94,9.5,15.46,9.5,14.67z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 mic-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M15 10.6V5c0-1.66-1.34-3-3-3-1.54 0-2.79 1.16-2.96 2.65L15 10.6zm3.08.4c-.41 0-.77.3-.83.71-.05.32-.12.64-.22.93l1.27 1.27c.3-.6.52-1.25.63-1.94.07-.51-.33-.97-.85-.97zM3.71 3.56c-.39.39-.39 1.02 0 1.41L9 10.27v.43c0 1.19.6 2.32 1.63 2.91.75.43 1.41.44 2.02.31l1.66 1.66c-.71.33-1.5.52-2.31.52-2.54 0-4.88-1.77-5.25-4.39-.06-.41-.42-.71-.83-.71-.52 0-.92.46-.85.97.46 2.96 2.96 5.3 5.93 5.75V20c0 .55.45 1 1 1s1-.45 1-1v-2.28c.91-.13 1.77-.45 2.55-.9l3.49 3.49c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.12 3.56c-.39-.39-1.02-.39-1.41 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _6k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,12.5h1.5V14H8V12.5z M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10.25,10.5 H8v1h2c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H7.5c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h2.75C10.66,9,11,9.34,11,9.75v0 C11,10.16,10.66,10.5,10.25,10.5z M16.59,15L16.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7H13.7 c-0.39,0-0.7-0.31-0.7-0.7V9.7C13,9.31,13.31,9,13.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98C16.17,9.1,16.38,9,16.59,9l0,0 c0.58,0,0.91,0.66,0.56,1.12L15.75,12l1.41,1.88C17.5,14.34,17.17,15,16.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 forward-30
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M18.92 13c-.5 0-.91.37-.98.86-.48 3.37-3.77 5.84-7.42 4.96-2.25-.54-3.91-2.27-4.39-4.53C5.32 10.42 8.27 7 12 7v2.79c0 .45.54.67.85.35l3.79-3.79c.2-.2.2-.51 0-.71l-3.79-3.79c-.31-.31-.85-.09-.85.36V5c-4.94 0-8.84 4.48-7.84 9.6.6 3.11 2.9 5.5 5.99 6.19 4.83 1.08 9.15-2.2 9.77-6.67.09-.59-.4-1.12-1-1.12zm-8.38 2.22c-.06.05-.12.09-.2.12s-.17.04-.27.04c-.09 0-.17-.01-.25-.04s-.14-.06-.2-.11-.1-.1-.13-.17-.05-.14-.05-.22h-.85c0 .21.04.39.12.55s.19.28.33.38.29.18.46.23.35.07.53.07c.21 0 .41-.03.6-.08s.34-.14.48-.24.24-.24.32-.39.12-.33.12-.53c0-.23-.06-.44-.18-.61s-.3-.3-.54-.39c.1-.05.2-.1.28-.17s.15-.14.2-.22.1-.16.13-.25.04-.18.04-.27c0-.2-.04-.37-.11-.53s-.17-.28-.3-.38-.28-.18-.46-.23-.37-.08-.59-.08c-.19 0-.38.03-.54.08s-.32.13-.44.23-.23.22-.3.37-.11.3-.11.48h.85c0-.07.02-.14.05-.2s.07-.11.12-.15.11-.07.18-.1.14-.03.22-.03c.1 0 .18.01.25.04s.13.06.18.11.08.11.11.17.04.14.04.22c0 .18-.05.32-.16.43s-.26.16-.48.16h-.43v.66h.45c.11 0 .2.01.29.04s.16.06.22.11.11.12.14.2.05.18.05.29c0 .09-.01.17-.04.24s-.08.11-.13.17zm3.9-3.44c-.18-.07-.37-.1-.59-.1s-.41.03-.59.1-.33.18-.45.33-.23.34-.29.57-.1.5-.1.82v.74c0 .32.04.6.11.82s.17.42.3.57.28.26.46.33.37.1.59.1.41-.03.59-.1.33-.18.45-.33.22-.34.29-.57.1-.5.1-.82v-.74c0-.32-.04-.6-.11-.82s-.17-.42-.3-.57-.28-.26-.46-.33zm.01 2.57c0 .19-.01.35-.04.48s-.06.24-.11.32-.11.14-.19.17-.16.05-.25.05-.18-.02-.25-.05-.14-.09-.19-.17-.09-.19-.12-.32-.04-.29-.04-.48v-.97c0-.19.01-.35.04-.48s.06-.23.12-.31.11-.14.19-.17.16-.05.25-.05.18.02.25.05.14.09.19.17.09.18.12.31.04.29.04.48v.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-new
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.11 0 2-.89 2-2V6c0-1.11-.89-2-2-2zM8.5 14.21c0 .43-.36.79-.79.79-.25 0-.49-.12-.64-.33L4.75 11.5v2.88c0 .35-.28.62-.62.62s-.63-.28-.63-.62V9.79c0-.43.36-.79.79-.79h.05c.26 0 .5.12.65.33l2.26 3.17V9.62c0-.34.28-.62.63-.62s.62.28.62.62v4.59zm5-4.57c0 .35-.28.62-.62.62H11v1.12h1.88c.35 0 .62.28.62.62v.01c0 .35-.28.62-.62.62H11v1.11h1.88c.35 0 .62.28.62.62 0 .35-.28.62-.62.62h-2.53c-.47 0-.85-.38-.85-.85v-4.3c0-.45.38-.83.85-.83h2.53c.35 0 .62.28.62.62v.02zm7 4.36c0 .55-.45 1-1 1h-4c-.55 0-1-.45-1-1V9.62c0-.34.28-.62.62-.62s.62.28.62.62v3.89h1.13v-2.9c0-.35.28-.62.62-.62s.62.28.62.62v2.89h1.12V9.62c0-.35.28-.62.62-.62s.62.28.62.62V14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 repeat-one-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M19,18c0,0.55-0.45,1-1,1H7v1.79 c0,0.45-0.54,0.67-0.85,0.36l-2.79-2.79c-0.2-0.2-0.2-0.51,0-0.71l2.79-2.79C6.46,14.54,7,14.76,7,15.21V17h10v-3 c0-0.55,0.45-1,1-1s1,0.45,1,1V18z M10.75,10.5c-0.41,0-0.75-0.34-0.75-0.75S10.34,9,10.75,9h1.5C12.66,9,13,9.34,13,9.75v4.5 c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V10.5H10.75z M20.64,6.35l-2.79,2.79C17.54,9.46,17,9.24,17,8.79V7H7v3 c0,0.55-0.45,1-1,1s-1-0.45-1-1V6c0-0.55,0.45-1,1-1h11V3.21c0-0.45,0.54-0.67,0.85-0.36l2.79,2.79 C20.84,5.84,20.84,6.15,20.64,6.35z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-to-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h5c1.1 0 2-.9 2-2V5c0-1.11-.9-2-2-2zm-1 14H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1zm-4-6c0 .55-.45 1-1 1h-2v2c0 .55-.45 1-1 1s-1-.45-1-1v-2H9c-.55 0-1-.45-1-1s.45-1 1-1h2V8c0-.55.45-1 1-1s1 .45 1 1v2h2c.55 0 1 .45 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _5k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10.25,10.5H8v1h2 c0.55,0,1,0.45,1,1V14c0,0.55-0.45,1-1,1H7.25c-0.41,0-0.75-0.34-0.75-0.75v0c0-0.41,0.34-0.75,0.75-0.75H9.5v-1H7.25 c-0.41,0-0.75-0.34-0.75-0.75v-2C6.5,9.34,6.84,9,7.25,9h3C10.66,9,11,9.34,11,9.75v0C11,10.16,10.66,10.5,10.25,10.5z M16.59,15 L16.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7H13.7c-0.39,0-0.7-0.31-0.7-0.7V9.7 C13,9.31,13.31,9,13.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98C16.17,9.1,16.38,9,16.59,9l0,0c0.58,0,0.91,0.66,0.56,1.12 L15.75,12l1.41,1.88C17.5,14.34,17.17,15,16.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _9k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.5,10h1v1.5h-1V10z M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,14 c0,0.55-0.45,1-1,1H6.75C6.34,15,6,14.66,6,14.25v0c0-0.41,0.34-0.75,0.75-0.75H8.5v-1H7c-0.55,0-1-0.45-1-1V10c0-0.55,0.45-1,1-1 h2c0.55,0,1,0.45,1,1V14z M14.59,15L14.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7H11.7 c-0.39,0-0.7-0.31-0.7-0.7V9.7C11,9.31,11.31,9,11.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98C14.17,9.1,14.38,9,14.59,9h0 c0.58,0,0.91,0.66,0.56,1.12L13.75,12l1.41,1.88C15.5,14.34,15.17,15,14.59,15z M18.5,12.5h-1v1c0,0.28-0.22,0.5-0.5,0.5l0,0 c-0.28,0-0.5-0.22-0.5-0.5v-1h-1c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5h1v-1c0-0.28,0.22-0.5,0.5-0.5l0,0 c0.28,0,0.5,0.22,0.5,0.5v1h1c0.28,0,0.5,0.22,0.5,0.5v0C19,12.28,18.78,12.5,18.5,12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airplay
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M8.41 22h7.17c.89 0 1.34-1.08.71-1.71L12.7 16.7c-.39-.39-1.02-.39-1.41 0L7.7 20.29c-.62.63-.18 1.71.71 1.71zM21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h3c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1h-2c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay-30
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 5V2.21c0-.45-.54-.67-.85-.35l-3.8 3.79c-.2.2-.2.51 0 .71l3.79 3.79c.32.31.86.09.86-.36V7c3.73 0 6.68 3.42 5.86 7.29-.47 2.27-2.31 4.1-4.57 4.57-3.57.75-6.75-1.7-7.23-5.01-.07-.48-.49-.85-.98-.85-.6 0-1.08.53-1 1.13.62 4.39 4.8 7.64 9.53 6.72 3.12-.61 5.63-3.12 6.24-6.24C20.84 9.48 16.94 5 12 5zm-2.44 8.49h.45c.21 0 .37-.05.48-.16s.16-.25.16-.43c0-.08-.01-.15-.04-.22s-.06-.12-.11-.17-.11-.09-.18-.11-.16-.04-.25-.04c-.08 0-.15.01-.22.03s-.13.05-.18.1-.09.09-.12.15-.05.13-.05.2h-.85c0-.18.04-.34.11-.48s.17-.27.3-.37.27-.18.44-.23.35-.08.54-.08c.21 0 .41.03.59.08s.33.13.46.23.23.23.3.38.11.33.11.53c0 .09-.01.18-.04.27s-.07.17-.13.25-.12.15-.2.22-.17.12-.28.17c.24.09.42.21.54.39s.18.38.18.61c0 .2-.04.38-.12.53s-.18.29-.32.39-.29.19-.48.24-.38.08-.6.08c-.18 0-.36-.02-.53-.07s-.33-.12-.46-.23-.25-.23-.33-.38-.12-.34-.12-.55h.85c0 .08.02.15.05.22s.07.12.13.17.12.09.2.11.16.04.25.04c.1 0 .19-.01.27-.04s.15-.07.2-.12.1-.11.13-.18.04-.15.04-.24c0-.11-.02-.21-.05-.29s-.08-.15-.14-.2-.13-.09-.22-.11-.18-.04-.29-.04h-.47v-.65zm5.74.75c0 .32-.03.6-.1.82s-.17.42-.29.57-.28.26-.45.33-.37.1-.59.1-.41-.03-.59-.1-.33-.18-.46-.33-.23-.34-.3-.57-.11-.5-.11-.82v-.74c0-.32.03-.6.1-.82s.17-.42.29-.57.28-.26.45-.33.37-.1.59-.1.41.03.59.1.33.18.46.33.23.34.3.57.11.5.11.82v.74zm-.85-.86c0-.19-.01-.35-.04-.48s-.07-.23-.12-.31-.11-.14-.19-.17-.16-.05-.25-.05-.18.02-.25.05-.14.09-.19.17-.09.18-.12.31-.04.29-.04.48v.97c0 .19.01.35.04.48s.07.24.12.32.11.14.19.17.16.05.25.05.18-.02.25-.05.14-.09.19-.17.09-.19.11-.32c.03-.13.04-.29.04-.48v-.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hearing-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M16.96,3.3c-0.32-0.39-0.29-0.96,0.07-1.32l0.01-0.01c0.42-0.42,1.12-0.38,1.49,0.08C20.07,3.94,21,6.36,21,9 c0,2.57-0.89,4.94-2.36,6.81l-1.43-1.43C18.33,12.88,19,11.02,19,9C19,6.83,18.23,4.84,16.96,3.3z M7.49,4.66 C8.23,4.24,9.08,4,10,4c2.8,0,5,2.2,5,5c0,0.8-0.23,1.69-0.63,2.54l1.48,1.48c0.02-0.04,0.05-0.08,0.08-0.13 C16.62,11.65,17,10.26,17,9c0-3.93-3.07-7-7-7C8.51,2,7.15,2.44,6.03,3.2L7.49,4.66z M10,6.5c-0.21,0-0.4,0.03-0.59,0.08l3.01,3.01 C12.47,9.4,12.5,9.21,12.5,9C12.5,7.62,11.38,6.5,10,6.5z M20.49,20.49L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0 c-0.39,0.39-0.39,1.02,0,1.41l1.42,1.42c-0.2,0.49-0.35,1-0.43,1.54C2.99,8.47,3.47,9,4.06,9H4.1c0.48,0,0.89-0.35,0.96-0.82 C5.08,8.1,5.1,8.02,5.12,7.95l6.62,6.62c-0.88,0.68-1.78,1.41-2.27,2.9c-0.5,1.5-1,2.01-1.71,2.38C7.56,19.94,7.29,20,7,20 c-0.88,0-1.63-0.58-1.9-1.37C4.97,18.24,4.57,18,4.15,18C3.49,18,3,18.64,3.2,19.26C3.73,20.85,5.23,22,7,22 c0.57,0,1.13-0.12,1.64-0.35c1.36-0.71,2.13-1.73,2.73-3.55c0.32-0.98,0.9-1.43,1.71-2.05c0.03-0.02,0.05-0.04,0.08-0.06l5.91,5.91 c0.39,0.39,1.02,0.39,1.41,0C20.88,21.51,20.88,20.88,20.49,20.49z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 featured-play-list
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-10 8H4c-.55 0-1-.45-1-1s.45-1 1-1h7c.55 0 1 .45 1 1s-.45 1-1 1zm0-4H4c-.55 0-1-.45-1-1s.45-1 1-1h7c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue-music
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M14 6H4c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1zm0 4H4c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1zM4 16h6c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1zM19 6c-1.1 0-2 .9-2 2v6.18c-.31-.11-.65-.18-1-.18-1.84 0-3.28 1.64-2.95 3.54.21 1.21 1.2 2.2 2.41 2.41 1.9.33 3.54-1.11 3.54-2.95V8h2c.55 0 1-.45 1-1s-.45-1-1-1h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 pause-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M10,16L10,16c-0.55,0-1-0.45-1-1V9 c0-0.55,0.45-1,1-1l0,0c0.55,0,1,0.45,1,1v6C11,15.55,10.55,16,10,16z M14,16L14,16c-0.55,0-1-0.45-1-1V9c0-0.55,0.45-1,1-1l0,0 c0.55,0,1,0.45,1,1v6C15,15.55,14.55,16,14,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 volume-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3 10v4c0 .55.45 1 1 1h3l3.29 3.29c.63.63 1.71.18 1.71-.71V6.41c0-.89-1.08-1.34-1.71-.71L7 9H4c-.55 0-1 .45-1 1zm13.5 2c0-1.77-1.02-3.29-2.5-4.03v8.05c1.48-.73 2.5-2.25 2.5-4.02zM14 4.45v.2c0 .38.25.71.6.85C17.18 6.53 19 9.06 19 12s-1.82 5.47-4.4 6.5c-.36.14-.6.47-.6.85v.2c0 .63.63 1.07 1.21.85C18.6 19.11 21 15.84 21 12s-2.4-7.11-5.79-8.4c-.58-.23-1.21.22-1.21.85z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 av-timer
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/circle
   {:r "1", :cy "17", :cx "12", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "12", :cx "7", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "12", :cx "17", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 3c-.55 0-1 .45-1 1v2c0 .55.45 1 1 1s1-.45 1-1v-.92c3.31.48 5.87 3.25 6 6.66.14 3.85-3.03 7.2-6.88 7.26C8.19 19.06 5 15.91 5 12c0-1.68.59-3.22 1.58-4.42l4.71 4.72c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L7.26 5.46c-.38-.38-1-.39-1.4-.02C4.1 7.07 3 9.4 3 12c0 5.04 4.14 9.12 9.21 9 4.7-.11 8.63-4.01 8.78-8.71C21.16 7.19 17.07 3 12 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-asset
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-1 14H6c-.55 0-1-.45-1-1V8h14v9c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-label
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 13H3V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 volume-mute
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M7 10v4c0 .55.45 1 1 1h3l3.29 3.29c.63.63 1.71.18 1.71-.71V6.41c0-.89-1.08-1.34-1.71-.71L11 9H8c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M3 6c-.55 0-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1zm17-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 9h-3v3c0 .55-.45 1-1 1s-1-.45-1-1v-3h-3c-.55 0-1-.45-1-1s.45-1 1-1h3V6c0-.55.45-1 1-1s1 .45 1 1v3h3c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-settings
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M4,6h16c0.55,0,1,0.45,1,1v4h2V6c0-1.1-0.9-2-2-2H3C1.9,4,1,4.9,1,6v12c0,1.1,0.9,2,2,2h9v-2H4c-0.55,0-1-0.45-1-1V7 C3,6.45,3.45,6,4,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "15,12 9,8 9,16", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M22.71,18.43c0.03-0.29,0.04-0.58,0.01-0.86l1.07-0.85c0.1-0.08,0.12-0.21,0.06-0.32l-1.03-1.79 c-0.06-0.11-0.19-0.15-0.31-0.11L21.23,15c-0.23-0.17-0.48-0.31-0.75-0.42l-0.2-1.36C20.26,13.09,20.16,13,20.03,13h-2.07 c-0.12,0-0.23,0.09-0.25,0.21l-0.2,1.36c-0.26,0.11-0.51,0.26-0.74,0.42l-1.28-0.5c-0.12-0.05-0.25,0-0.31,0.11l-1.03,1.79 c-0.06,0.11-0.04,0.24,0.06,0.32l1.07,0.86c-0.03,0.29-0.04,0.58-0.01,0.86l-1.07,0.85c-0.1,0.08-0.12,0.21-0.06,0.32l1.03,1.79 c0.06,0.11,0.19,0.15,0.31,0.11l1.27-0.5c0.23,0.17,0.48,0.31,0.75,0.42l0.2,1.36c0.02,0.12,0.12,0.21,0.25,0.21h2.07 c0.12,0,0.23-0.09,0.25-0.21l0.2-1.36c0.26-0.11,0.51-0.26,0.74-0.42l1.28,0.5c0.12,0.05,0.25,0,0.31-0.11l1.03-1.79 c0.06-0.11,0.04-0.24-0.06-0.32L22.71,18.43z M19,19.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5s1.5,0.67,1.5,1.5 S19.83,19.5,19,19.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 snooze
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M10 11h2.63l-3.72 4.35C8.36 16 8.82 17 9.67 17H14c.55 0 1-.45 1-1s-.45-1-1-1h-2.63l3.72-4.35c.55-.65.09-1.65-.76-1.65H10c-.55 0-1 .45-1 1s.45 1 1 1zm11.3-4.58c-.35.42-.98.48-1.41.13l-3.07-2.56c-.42-.36-.48-.99-.12-1.41.35-.42.98-.48 1.41-.13l3.07 2.56c.42.36.48.99.12 1.41zm-18.6 0c.35.43.98.48 1.4.13l3.07-2.56c.43-.36.49-.99.13-1.41-.35-.43-.98-.48-1.4-.13L2.82 5.01c-.42.36-.48.99-.12 1.41zM12 6c3.86 0 7 3.14 7 7s-3.14 7-7 7-7-3.14-7-7 3.14-7 7-7m0-2c-4.97 0-9 4.03-9 9s4.03 9 9 9 9-4.03 9-9-4.03-9-9-9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 not-interested
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 playlist-add-check-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10c5.52,0,10-4.48,10-10C22,6.48,17.52,2,12,2z M7,8c0-0.55,0.45-1,1-1h5 c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H8C7.45,9,7,8.55,7,8L7,8z M7,11c0-0.55,0.45-1,1-1h5c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1 H8C7.45,12,7,11.55,7,11L7,11z M10,14c0,0.55-0.45,1-1,1H8c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h1C9.55,13,10,13.45,10,14L10,14z M18.29,14.12l-3.54,3.54c-0.39,0.39-1.02,0.39-1.41,0l-1.41-1.41c-0.39-0.39-0.39-1.02,0-1.41c0.39-0.39,1.02-0.39,1.41,0 l0.71,0.71l2.83-2.83c0.39-0.39,1.02-0.39,1.41,0C18.68,13.1,18.68,13.73,18.29,14.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-smart-record
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/circle
   {:r "8", :cy "12", :cx "9", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M17 5.55v.18c0 .37.23.69.57.85C19.6 7.54 21 9.61 21 12s-1.4 4.46-3.43 5.42c-.34.16-.57.47-.57.84v.18c0 .68.71 1.11 1.32.82C21.08 18.01 23 15.23 23 12s-1.92-6.01-4.68-7.27c-.61-.28-1.32.14-1.32.82z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 branding-watermark
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16h-7c-.55 0-1-.45-1-1v-4c0-.55.45-1 1-1h7c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subtitles
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zM5 12h2c.55 0 1 .45 1 1s-.45 1-1 1H5c-.55 0-1-.45-1-1s.45-1 1-1zm8 6H5c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1zm6 0h-2c-.55 0-1-.45-1-1s.45-1 1-1h2c.55 0 1 .45 1 1s-.45 1-1 1zm0-4h-8c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-call
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M17 10.5V7c0-.55-.45-1-1-1H4c-.55 0-1 .45-1 1v10c0 .55.45 1 1 1h12c.55 0 1-.45 1-1v-3.5l2.29 2.29c.63.63 1.71.18 1.71-.71V8.91c0-.89-1.08-1.34-1.71-.71L17 10.5zM13 13h-2v2c0 .55-.45 1-1 1s-1-.45-1-1v-2H7c-.55 0-1-.45-1-1s.45-1 1-1h2V9c0-.55.45-1 1-1s1 .45 1 1v2h2c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 replay
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 5V2.21c0-.45-.54-.67-.85-.35l-3.8 3.79c-.2.2-.2.51 0 .71l3.79 3.79c.32.31.86.09.86-.36V7c3.73 0 6.68 3.42 5.86 7.29-.47 2.27-2.31 4.1-4.57 4.57-3.57.75-6.75-1.7-7.23-5.01-.07-.48-.49-.85-.98-.85-.6 0-1.08.53-1 1.13.62 4.39 4.8 7.64 9.53 6.72 3.12-.61 5.63-3.12 6.24-6.24C20.84 9.48 16.94 5 12 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _8k-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,14c0,0.55-0.45,1-1,1H7 c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h2c0.55,0,1,0.45,1,1V14z M14.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55 c0,0.39-0.31,0.7-0.7,0.7H11.7c-0.39,0-0.7-0.31-0.7-0.7V9.7C11,9.31,11.31,9,11.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98 C14.17,9.1,14.38,9,14.59,9c0.58,0,0.91,0.66,0.56,1.12L13.75,12l1.41,1.88C15.5,14.34,15.17,15,14.59,15z M19,12.5h-1.5V14h-1 v-1.5H15v-1h1.5V10h1v1.5H19V12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "12.5",
      :x "7.5",
      :width "1",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "10",
      :x "7.5",
      :width "1",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 recent-actors
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 6v12c0 .55.45 1 1 1s1-.45 1-1V6c0-.55-.45-1-1-1s-1 .45-1 1zm-3 13c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1s-1 .45-1 1v12c0 .55.45 1 1 1zM14 5H2c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h12c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1zM8 7.75c1.24 0 2.25 1.01 2.25 2.25S9.24 12.25 8 12.25 5.75 11.24 5.75 10 6.76 7.75 8 7.75zM12.5 17h-9v-.75c0-1.5 3-2.25 4.5-2.25s4.5.75 4.5 2.25V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fiber-dvr
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M4.5 10.5h2v3h-2zm13 0h2v1h-2zM21 3H3c-1.11 0-2 .89-2 2v14c0 1.1.89 2 2 2h18c1.11 0 2-.9 2-2V5c0-1.11-.89-2-2-2zM8 13.5c0 .83-.67 1.5-1.5 1.5h-3c-.28 0-.5-.22-.5-.5v-5c0-.28.22-.5.5-.5h3c.83 0 1.5.67 1.5 1.5v3zm6.1-3.58l-1.27 4.36c-.12.43-.52.72-.96.72s-.84-.29-.96-.72L9.64 9.92c-.14-.46.21-.92.69-.92.32 0 .6.21.69.52l.85 2.91.85-2.91c.09-.31.37-.52.69-.52.48 0 .83.46.69.92zM21 11.5c0 .6-.4 1.15-.9 1.4l.63 1.48c.19.45-.14.96-.63.96-.28 0-.53-.16-.63-.42L18.65 13H17.5v1.31c0 .38-.31.69-.69.69h-.12c-.38 0-.69-.31-.69-.69V9.64c0-.35.29-.64.64-.64h2.86c.83 0 1.5.67 1.5 1.5v1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fast-forward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M5.58 16.89l5.77-4.07c.56-.4.56-1.24 0-1.63L5.58 7.11C4.91 6.65 4 7.12 4 7.93v8.14c0 .81.91 1.28 1.58.82zM13 7.93v8.14c0 .81.91 1.28 1.58.82l5.77-4.07c.56-.4.56-1.24 0-1.63l-5.77-4.07c-.67-.47-1.58 0-1.58.81z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 repeat-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M19,18c0,0.55-0.45,1-1,1H7v1.79 c0,0.45-0.54,0.67-0.85,0.36l-2.79-2.79c-0.2-0.2-0.2-0.51,0-0.71l2.79-2.79C6.46,14.54,7,14.76,7,15.21V17h10v-3 c0-0.55,0.45-1,1-1s1,0.45,1,1V18z M20.64,6.35l-2.79,2.79C17.54,9.46,17,9.24,17,8.79V7H7v3c0,0.55-0.45,1-1,1s-1-0.45-1-1V6 c0-0.55,0.45-1,1-1h11V3.21c0-0.45,0.54-0.67,0.85-0.36l2.79,2.79C20.84,5.84,20.84,6.15,20.64,6.35z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 album
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 14.5c-2.49 0-4.5-2.01-4.5-4.5S9.51 7.5 12 7.5s4.5 2.01 4.5 4.5-2.01 4.5-4.5 4.5zm0-5.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _1k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M9.25,15L9.25,15 c-0.41,0-0.75-0.34-0.75-0.75V10.5H7.75C7.34,10.5,7,10.16,7,9.75v0C7,9.34,7.34,9,7.75,9H9c0.55,0,1,0.45,1,1v4.25 C10,14.66,9.66,15,9.25,15z M15.59,15L15.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.5c0,0.41-0.34,0.75-0.75,0.75h0 C12.34,15,12,14.66,12,14.25v-4.5C12,9.34,12.34,9,12.75,9h0c0.41,0,0.75,0.34,0.75,0.75v1.5l1.54-1.98C15.17,9.1,15.38,9,15.59,9 h0c0.58,0,0.91,0.66,0.56,1.12L14.75,12l1.41,1.88C16.5,14.34,16.17,15,15.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 games
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M15 7.29V3c0-.55-.45-1-1-1h-4c-.55 0-1 .45-1 1v4.29c0 .13.05.26.15.35l2.5 2.5c.2.2.51.2.71 0l2.5-2.5c.09-.09.14-.21.14-.35zM7.29 9H3c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h4.29c.13 0 .26-.05.35-.15l2.5-2.5c.2-.2.2-.51 0-.71l-2.5-2.5C7.55 9.05 7.43 9 7.29 9zM9 16.71V21c0 .55.45 1 1 1h4c.55 0 1-.45 1-1v-4.29c0-.13-.05-.26-.15-.35l-2.5-2.5c-.2-.2-.51-.2-.71 0l-2.5 2.5c-.09.09-.14.21-.14.35zm7.35-7.56l-2.5 2.5c-.2.2-.2.51 0 .71l2.5 2.5c.09.09.22.15.35.15H21c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1h-4.29c-.14-.01-.26.04-.36.14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-asset-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.83,4H20c1.11,0,2,0.9,2,2v12c0,0.34-0.09,0.66-0.23,0.94L20,17.17V8h-9.17L6.83,4z M19.78,22.61L17.17,20H4 c-1.11,0-2-0.9-2-2V6c0-0.34,0.08-0.66,0.23-0.94L1.39,4.22C1,3.83,1,3.2,1.39,2.81l0,0c0.39-0.39,1.02-0.39,1.41,0l18.38,18.38 c0.39,0.39,0.39,1.02,0,1.41l0,0C20.8,23,20.17,23,19.78,22.61z M15.17,18l-10-10H4v10H15.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 skip-previous
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M7 6c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1s-1-.45-1-1V7c0-.55.45-1 1-1zm3.66 6.82l5.77 4.07c.66.47 1.58-.01 1.58-.82V7.93c0-.81-.91-1.28-1.58-.82l-5.77 4.07c-.57.4-.57 1.24 0 1.64z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 shuffle-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,1H3C1.9,1,1,1.9,1,3v18c0,1.1,0.9,2,2,2h18c1.1,0,2-0.9,2-2V3C23,1.9,22.1,1,21,1z M4.3,4.7 c0.39-0.39,1.02-0.39,1.41,0l4.47,4.47l-1.42,1.4L4.3,6.11C3.91,5.72,3.91,5.09,4.3,4.7z M19.59,19.5c0,0.28-0.22,0.5-0.5,0.5H15.3 c-0.45,0-0.67-0.54-0.36-0.85l1.2-1.2l-3.13-3.13l1.41-1.41l3.13,3.14l1.19-1.19c0.31-0.32,0.85-0.1,0.85,0.35V19.5z M19.59,8.29 c0,0.45-0.54,0.67-0.85,0.36l-1.19-1.19L5.7,19.29c-0.39,0.39-1.02,0.39-1.41,0c-0.39-0.39-0.39-1.02,0-1.41L16.13,6.04l-1.19-1.19 C14.63,4.54,14.85,4,15.3,4h3.79c0.28,0,0.5,0.22,0.5,0.5V8.29z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 loop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 4V2.21c0-.45-.54-.67-.85-.35l-2.8 2.79c-.2.2-.2.51 0 .71l2.79 2.79c.32.31.86.09.86-.36V6c3.31 0 6 2.69 6 6 0 .79-.15 1.56-.44 2.25-.15.36-.04.77.23 1.04.51.51 1.37.33 1.64-.34.37-.91.57-1.91.57-2.95 0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-.79.15-1.56.44-2.25.15-.36.04-.77-.23-1.04-.51-.51-1.37-.33-1.64.34C4.2 9.96 4 10.96 4 12c0 4.42 3.58 8 8 8v1.79c0 .45.54.67.85.35l2.79-2.79c.2-.2.2-.51 0-.71l-2.79-2.79c-.31-.31-.85-.09-.85.36V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 closed-caption-disabled
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.83,4H19c1.1,0,2,0.9,2,2v12c0,0.05-0.01,0.1-0.02,0.16l-3.38-3.38C17.84,14.59,18,14.32,18,14v-0.5 c0-0.28-0.22-0.5-0.5-0.5H17c-0.28,0-0.5,0.22-0.5,0.5h-0.17l-1.83-1.83V10.5h2c0,0.28,0.22,0.5,0.5,0.5h0.5 c0.28,0,0.5-0.22,0.5-0.5V10c0-0.55-0.45-1-1-1h-3c-0.55,0-1,0.45-1,1v0.17L6.83,4z M20.49,21.9c-0.39,0.39-1.02,0.39-1.41,0 l-1.9-1.9H5c-1.11,0-2-0.9-2-2V6c0-0.05,0.02-0.1,0.02-0.15L2.1,4.93c-0.39-0.39-0.39-1.02,0-1.41c0.39-0.39,1.02-0.39,1.41,0 l16.97,16.97C20.88,20.88,20.88,21.51,20.49,21.9z M11,13.83L10.17,13H10c-0.28,0-0.5,0.22-0.5,0.5h-2v-3h0.17L6.4,9.22 C6.16,9.41,6,9.68,6,10v4c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1V13.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _2k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,12.5H8v1h2.25 c0.41,0,0.75,0.34,0.75,0.75v0c0,0.41-0.34,0.75-0.75,0.75H7.5c-0.55,0-1-0.45-1-1v-1.5c0-0.55,0.45-1,1-1h2v-1H7.25 c-0.41,0-0.75-0.34-0.75-0.75v0C6.5,9.34,6.84,9,7.25,9H10c0.55,0,1,0.45,1,1v1.5C11,12.05,10.55,12.5,10,12.5z M16.59,15L16.59,15 c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7H13.7c-0.39,0-0.7-0.31-0.7-0.7V9.7C13,9.31,13.31,9,13.7,9 h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98C16.17,9.1,16.38,9,16.59,9l0,0c0.58,0,0.91,0.66,0.56,1.12L15.75,12l1.41,1.88 C17.5,14.34,17.17,15,16.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 library-add-check
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path
   {:d
    "M20,2H8C6.9,2,6,2.9,6,4v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M11.76,13.28L9.69,11.2 c-0.38-0.39-0.38-1.01,0-1.4l0,0c0.39-0.39,1.02-0.39,1.41,0l1.36,1.37l4.42-4.46c0.39-0.39,1.02-0.39,1.41,0l0,0 c0.38,0.39,0.38,1.01,0,1.4l-5.13,5.17C12.79,13.68,12.15,13.68,11.76,13.28z M3,6L3,6C2.45,6,2,6.45,2,7v13c0,1.1,0.9,2,2,2h13 c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H5c-0.55,0-1-0.45-1-1V7C4,6.45,3.55,6,3,6z",
    :stroke nil,
    :fill nil})
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})))


(helix.core/defnc
 art-track
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M21 13h-6c-.55 0-1-.45-1-1s.45-1 1-1h6c.55 0 1 .45 1 1s-.45 1-1 1zm0-6h-6c-.55 0-1 .45-1 1s.45 1 1 1h6c.55 0 1-.45 1-1s-.45-1-1-1zm-6 10h6c.55 0 1-.45 1-1s-.45-1-1-1h-6c-.55 0-1 .45-1 1s.45 1 1 1zm-3-8v6c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V9c0-1.1.9-2 2-2h6c1.1 0 2 .9 2 2zm-2.1 5.2l-1.26-1.68c-.2-.26-.59-.27-.8-.01L6.5 14.26l-.85-1.03c-.2-.25-.58-.24-.78.01l-.74.95c-.26.33-.02.81.39.81H9.5c.41 0 .65-.47.4-.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 skip-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M7.58 16.89l5.77-4.07c.56-.4.56-1.24 0-1.63L7.58 7.11C6.91 6.65 6 7.12 6 7.93v8.14c0 .81.91 1.28 1.58.82zM16 7v10c0 .55.45 1 1 1s1-.45 1-1V7c0-.55-.45-1-1-1s-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 play-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M10.8 15.9l4.67-3.5c.27-.2.27-.6 0-.8L10.8 8.1c-.33-.25-.8-.01-.8.4v7c0 .41.47.65.8.4zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _8k
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,12.5h1.5V14H8V12.5z M8,10h1.5v1.5H8V10z M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5 C21,3.9,20.1,3,19,3z M11,14c0,0.55-0.45,1-1,1H7.5c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1H10c0.55,0,1,0.45,1,1V14z M16.59,15 L16.59,15c-0.22,0-0.42-0.1-0.55-0.27l-1.54-1.98v1.55c0,0.39-0.31,0.7-0.7,0.7H13.7c-0.39,0-0.7-0.31-0.7-0.7V9.7 C13,9.31,13.31,9,13.7,9h0.09c0.39,0,0.7,0.31,0.7,0.7v1.55l1.54-1.98C16.17,9.1,16.38,9,16.59,9l0,0c0.58,0,0.91,0.66,0.56,1.12 L15.75,12l1.41,1.88C17.5,14.34,17.17,15,16.59,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-shared
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-1.41-1.41C10.21 4.21 9.7 4 9.17 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-5 3c1.1 0 2 .9 2 2s-.9 2-2 2-2-.9-2-2 .9-2 2-2zm4 8h-8v-1c0-1.33 2.67-2 4-2s4 .67 4 2v1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 snippet-folder
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M15.88,10.5l1.62,1.62v3.38l-3,0v-5H15.88z M22,8v10c0,1.1-0.9,2-2,2H4c-1.1,0-2-0.9-2-2L2.01,6C2.01,4.9,2.9,4,4,4h5.17 c0.53,0,1.04,0.21,1.41,0.59L12,6h8C21.1,6,22,6.9,22,8z M19,11.91c0-0.27-0.11-0.52-0.29-0.71l-1.91-1.91 C16.61,9.11,16.35,9,16.09,9H14c-0.55,0-1,0.45-1,1v6c0,0.55,0.45,1,1,1l4,0c0.55,0,1-0.45,1-1V11.91z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 file-upload
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M7.4,10h1.59v5c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-5h1.59c0.89,0,1.34-1.08,0.71-1.71L12.7,3.7 c-0.39-0.39-1.02-0.39-1.41,0L6.7,8.29C6.07,8.92,6.51,10,7.4,10z M5,19c0,0.55,0.45,1,1,1h12c0.55,0,1-0.45,1-1s-0.45-1-1-1H6 C5.45,18,5,18.45,5,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 create-new-folder
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-1.41-1.41C10.21 4.21 9.7 4 9.17 4H4c-1.11 0-1.99.89-1.99 2L2 18c0 1.11.89 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-2 8h-2v2c0 .55-.45 1-1 1s-1-.45-1-1v-2h-2c-.55 0-1-.45-1-1s.45-1 1-1h2v-2c0-.55.45-1 1-1s1 .45 1 1v2h2c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-open
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-1.41-1.41C10.21 4.21 9.7 4 9.17 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-1 12H5c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v8c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drive-file-move-rtl
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M11.15,16.15l-2.79-2.79c-0.2-0.2-0.2-0.51,0-0.71l2.79-2.79C11.46,9.54,12,9.76,12,10.21V12h3 c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1h-3v1.79C12,16.24,11.46,16.46,11.15,16.15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drive-file-move
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M12,15.79V14H9c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h3v-1.79c0-0.45,0.54-0.67,0.85-0.35l2.79,2.79 c0.2,0.2,0.2,0.51,0,0.71l-2.79,2.79C12.54,16.46,12,16.24,12,15.79z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cloud-done
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zm-8.64 6.25c-.39.39-1.02.39-1.41 0L7.2 14.2c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L10 14.18l4.48-4.48c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-5.18 5.18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cloud-queue
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6c-2.21 0-4-1.79-4-4s1.79-4 4-4h.71C7.37 7.69 9.48 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3s-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-copy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M2,6L2,6C1.45,6,1,6.45,1,7v12c0,1.1,0.9,2,2,2h16c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H3V7C3,6.45,2.55,6,2,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,4h-7l-1.41-1.41C12.21,2.21,11.7,2,11.17,2H7C5.9,2,5.01,2.9,5.01,4L5,15c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V6 C23,4.9,22.1,4,21,4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 drive-file-rename-outline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M15,16l-4,4h8c1.1,0,2-0.9,2-2v0c0-1.1-0.9-2-2-2H15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.06,7.19l-8.77,8.77C3.11,16.14,3,16.4,3,16.66V19c0,0.55,0.45,1,1,1h2.34c0.27,0,0.52-0.11,0.71-0.29l8.77-8.77 L12.06,7.19z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.71,8.04c0.39-0.39,0.39-1.02,0-1.41l-2.34-2.34c-0.39-0.39-1.02-0.39-1.41,0l-1.83,1.83l3.75,3.75L18.71,8.04z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 download-done
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 18h12c.55 0 1 .45 1 1s-.45 1-1 1H6c-.55 0-1-.45-1-1s.45-1 1-1zm5.01-4.1c-.78.77-2.04.77-2.82-.01L6 11.7c-.55-.55-.54-1.44.03-1.97.54-.52 1.4-.5 1.92.02L9.6 11.4l6.43-6.43c.54-.54 1.41-.54 1.95 0l.04.04c.54.54.54 1.42-.01 1.96l-7 6.93z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-delete
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.5,15.5h-2v-4h2V15.5z M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16 c1.1,0,2-0.9,2-2V8C22,6.9,21.1,6,20,6z M18.25,11.5H18v4c0,0.83-0.67,1.5-1.5,1.5h-2c-0.83,0-1.5-0.67-1.5-1.5v-4h-0.25 c-0.41,0-0.75-0.34-0.75-0.75c0-0.41,0.34-0.75,0.75-0.75h1.75V9.75C14.5,9.34,14.84,9,15.25,9h0.5c0.41,0,0.75,0.34,0.75,0.75V10 h1.75c0.41,0,0.75,0.34,0.75,0.75C19,11.16,18.66,11.5,18.25,11.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 text-snippet
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14.17,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V9.83c0-0.53-0.21-1.04-0.59-1.41l-4.83-4.83 C15.21,3.21,14.7,3,14.17,3L14.17,3z M8,15h8c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H8c-0.55,0-1-0.45-1-1v0C7,15.45,7.45,15,8,15z M8,11h8c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H8c-0.55,0-1-0.45-1-1v0C7,11.45,7.45,11,8,11z M8,7h5c0.55,0,1,0.45,1,1v0 c0,0.55-0.45,1-1,1H8C7.45,9,7,8.55,7,8v0C7,7.45,7.45,7,8,7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cloud-download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM17 13l-4.65 4.65c-.2.2-.51.2-.71 0L7 13h3V9h4v4h3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M9,6.17V4c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1v5h1.59c0.89,0,1.33,1.08,0.7,1.71l-1.88,1.88L9,6.17z M20.49,20.49 L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41l4.5,4.5c-0.26,0.37-0.28,0.91,0.1,1.28l4.59,4.59 c0.35,0.35,0.88,0.37,1.27,0.09L15.17,18H6c-0.55,0-1,0.45-1,1s0.45,1,1,1h11.17l1.9,1.9c0.39,0.39,1.02,0.39,1.41,0 C20.88,21.51,20.88,20.88,20.49,20.49z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-open
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13.17,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h9v-6c0-1.1,0.9-2,2-2h3V8.83c0-0.53-0.21-1.04-0.59-1.41l-4.83-4.83 C14.21,2.21,13.7,2,13.17,2z M13,8V3.5L18.5,9H14C13.45,9,13,8.55,13,8z M22.66,17c0,0.55-0.45,1-1,1h-1.24l2.24,2.24 c0.39,0.39,0.39,1.02,0,1.41l0,0c-0.39,0.39-1.02,0.39-1.41,0L19,19.41l0,1.24c0,0.55-0.45,1-1,1c-0.55,0-1-0.45-1-1V17 c0-0.55,0.45-1,1-1h3.66C22.21,16,22.66,16.45,22.66,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 attachment
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.75 16H7.17c-2.09 0-3.95-1.53-4.15-3.61C2.79 10.01 4.66 8 7 8h12.36c1.31 0 2.5.94 2.63 2.24.15 1.5-1.02 2.76-2.49 2.76H9c-.55 0-1-.45-1-1s.45-1 1-1h8.75c.41 0 .75-.34.75-.75s-.34-.75-.75-.75H9.14c-1.31 0-2.5.94-2.63 2.24-.15 1.5 1.02 2.76 2.49 2.76h10.33c2.09 0 3.95-1.53 4.15-3.61.23-2.39-1.64-4.39-3.98-4.39H7.23c-2.87 0-5.44 2.1-5.71 4.96-.3 3.29 2.26 6.04 5.48 6.04h10.75c.41 0 .75-.34.75-.75s-.34-.75-.75-.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cloud-upload
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM14 13v4h-4v-4H7l4.65-4.65c.2-.2.51-.2.71 0L17 13h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10.59 4.59C10.21 4.21 9.7 4 9.17 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2h-8l-1.41-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download-done
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.42,4.71L19.42,4.71c-0.39-0.39-1.02-0.39-1.41,0l-8.48,8.49L5.99,9.66c-0.39-0.39-1.02-0.39-1.41,0l0,0 c-0.39,0.39-0.39,1.02,0,1.41l4.24,4.24c0.39,0.39,1.02,0.39,1.41,0l9.19-9.19C19.82,5.73,19.82,5.1,19.42,4.71z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6,20h12c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H6c-0.55,0-1,0.45-1,1v0C5,19.55,5.45,20,6,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4.5 14H8c-1.66 0-3-1.34-3-3s1.34-3 3-3h.14c.44-1.73 1.99-3 3.86-3 2.21 0 4 1.79 4 4h.5c1.38 0 2.5 1.12 2.5 2.5S17.88 16 16.5 16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 format-overline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M5,4c0-0.55,0.45-1,1-1h12c0.55,0,1,0.45,1,1s-0.45,1-1,1H6C5.45,5,5,4.55,5,4z M12,7c-3.87,0-7,3.13-7,7 c0,3.87,3.13,7,7,7s7-3.13,7-7C19,10.13,15.87,7,12,7z M12,18.5c-2.49,0-4.5-2.01-4.5-4.5S9.51,9.5,12,9.5s4.5,2.01,4.5,4.5 S14.49,18.5,12,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 download-for-offline
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.49,2,2,6.49,2,12s4.49,10,10,10s10-4.49,10-10S17.51,2,12,2z M11,10V7c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v3 h1.79c0.45,0,0.67,0.54,0.35,0.85l-2.79,2.79c-0.2,0.2-0.51,0.2-0.71,0l-2.79-2.79C8.54,10.54,8.76,10,9.21,10H11z M16,17H8 c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h8c0.55,0,1,0.45,1,1v0C17,16.55,16.55,17,16,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cloud-sync
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M24,17.48c0,1.38-1.12,2.5-2.5,2.5L15,20c-1.66,0-3-1.34-3-3c0-1.6,1.26-2.9,2.84-2.98C15.4,12.83,16.6,12,18,12 c1.76,0,3.2,1.3,3.45,2.99c0.02,0,0.03-0.01,0.05-0.01C22.88,14.98,24,16.1,24,17.48z M10,15c0-0.55-0.45-1-1-1s-1,0.45-1,1v1.44 c-1.22-1.1-2-2.67-2-4.44c0-2.38,1.39-4.43,3.4-5.4C9.77,6.42,10,6.04,10,5.63c0-0.71-0.73-1.18-1.37-0.88C5.89,6.03,4,8.79,4,12 c0,2.4,1.06,4.54,2.73,6H5c-0.55,0-1,0.45-1,1s0.45,1,1,1h4c0.55,0,1-0.45,1-1V15z M19,6c0.55,0,1-0.45,1-1s-0.45-1-1-1h-4 c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1s1-0.45,1-1V7.56c0.98,0.89,1.68,2.08,1.92,3.44l2.02,0c-0.25-1.99-1.23-3.74-2.66-5H19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 newspaper
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21.15,3.85l-0.82,0.82l-0.95-0.96c-0.39-0.39-1.02-0.39-1.42,0L17,4.67l-0.96-0.96c-0.39-0.39-1.03-0.39-1.42,0 l-0.95,0.96l-0.96-0.96c-0.39-0.39-1.02-0.39-1.41,0l-0.96,0.96L9.38,3.71c-0.39-0.39-1.02-0.39-1.42,0L7,4.67L6.04,3.71 c-0.39-0.39-1.03-0.39-1.42,0L3.67,4.67L2.85,3.85C2.54,3.54,2,3.76,2,4.21V19c0,1.1,0.9,2,2,2l16,0c1.1,0,2-0.9,2-2V4.21 C22,3.76,21.46,3.54,21.15,3.85z M11,19H4v-6h7V19z M20,19h-7v-2h7V19z M20,15h-7v-2h7V15z M20,11H4V8h16V11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 topic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M13,16H7c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h6c0.55,0,1,0.45,1,1C14,15.55,13.55,16,13,16z M17,12H7 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h10c0.55,0,1,0.45,1,1C18,11.55,17.55,12,17,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 workspaces
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6,13c-2.2,0-4,1.8-4,4s1.8,4,4,4s4-1.8,4-4S8.2,13,6,13z M12,3C9.8,3,8,4.8,8,7s1.8,4,4,4s4-1.8,4-4S14.2,3,12,3z M18,13 c-2.2,0-4,1.8-4,4s1.8,4,4,4s4-1.8,4-4S20.2,13,18,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rule-folder
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M7.12,15.29l-1.41-1.41c-0.39-0.39-0.39-1.02,0-1.41l0,0c0.39-0.39,1.02-0.39,1.41,0l0.71,0.71l2.83-2.83 c0.39-0.39,1.02-0.39,1.41,0l0,0c0.39,0.39,0.39,1.02,0,1.41l-3.54,3.54C8.14,15.68,7.51,15.68,7.12,15.29z M17.41,13l0.88,0.88 c0.39,0.39,0.39,1.02,0,1.41l0,0c-0.39,0.39-1.02,0.39-1.41,0L16,14.41l-0.88,0.88c-0.39,0.39-1.02,0.39-1.41,0l0,0 c-0.39-0.39-0.39-1.02,0-1.41L14.59,13l-0.88-0.88c-0.39-0.39-0.39-1.02,0-1.41l0,0c0.39-0.39,1.02-0.39,1.41,0L16,11.59l0.88-0.88 c0.39-0.39,1.02-0.39,1.41,0l0,0c0.39,0.39,0.39,1.02,0,1.41L17.41,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-zip
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M18,12h-2v2h2v2h-2v2h-2v-2h2v-2h-2v-2h2v-2h-2V8h2v2h2V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 difference
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3,7c0.55,0,1,0.45,1,1v13h13c0.55,0,1,0.45,1,1s-0.45,1-1,1H4c-1.1,0-2-0.9-2-2V8C2,7.45,2.45,7,3,7z M15.59,1.59 C15.21,1.21,14.7,1,14.17,1H8C6.9,1,6.01,1.9,6.01,3L6,17c0,1.1,0.89,2,1.99,2H19c1.1,0,2-0.9,2-2V7.83c0-0.53-0.21-1.04-0.59-1.41 L15.59,1.59z M15.5,15h-4c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1v0C16.5,14.55,16.05,15,15.5,15z M15.5,9h-1 v1c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1V9h-1c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h1V6c0-0.55,0.45-1,1-1h0 c0.55,0,1,0.45,1,1v1h1c0.55,0,1,0.45,1,1v0C16.5,8.55,16.05,9,15.5,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 attach-email
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/path
       {:d
        "M21,10V4c0-1.1-0.9-2-2-2H3C1.9,2,1.01,2.9,1.01,4L1,16c0,1.1,0.9,2,2,2h11v-5c0-1.66,1.34-3,3-3H21z M11.53,10.67 c-0.32,0.2-0.74,0.2-1.06,0L3.4,6.25C3.15,6.09,3,5.82,3,5.53c0-0.67,0.73-1.07,1.3-0.72L11,9l6.7-4.19 C18.27,4.46,19,4.86,19,5.53c0,0.29-0.15,0.56-0.4,0.72L11.53,10.67z",
        :stroke nil,
        :fill nil})
      (helix.dom/path
       {:d
        "M22,14c-0.55,0-1,0.45-1,1v3c0,1.1-0.9,2-2,2s-2-0.9-2-2v-4.5c0-0.28,0.22-0.5,0.5-0.5s0.5,0.22,0.5,0.5V17 c0,0.55,0.45,1,1,1s1-0.45,1-1v-3.5c0-1.38-1.12-2.5-2.5-2.5S15,12.12,15,13.5V18c0,2.21,1.79,4,4,4s4-1.79,4-4v-3 C23,14.45,22.55,14,22,14z",
        :stroke nil,
        :fill nil})))))))


(helix.core/defnc
 download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.59 9H15V4c0-.55-.45-1-1-1h-4c-.55 0-1 .45-1 1v5H7.41c-.89 0-1.34 1.08-.71 1.71l4.59 4.59c.39.39 1.02.39 1.41 0l4.59-4.59c.63-.63.19-1.71-.7-1.71zM5 19c0 .55.45 1 1 1h12c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 downloading
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.33,3.55c-0.94-0.6-1.99-1.04-3.12-1.3C13.59,2.11,13,2.59,13,3.23v0c0,0.45,0.3,0.87,0.74,0.97 c0.91,0.2,1.77,0.56,2.53,1.05c0.39,0.25,0.89,0.17,1.22-0.16l0,0C17.94,4.64,17.87,3.89,17.33,3.55z M20.77,11L20.77,11 c0.64,0,1.13-0.59,0.98-1.21c-0.26-1.12-0.7-2.17-1.3-3.12c-0.34-0.54-1.1-0.61-1.55-0.16l0,0c-0.32,0.32-0.4,0.83-0.16,1.22 c0.49,0.77,0.85,1.62,1.05,2.53C19.9,10.7,20.31,11,20.77,11z M18.9,17.49L18.9,17.49c0.45,0.45,1.21,0.38,1.55-0.15 c0.6-0.94,1.04-1.99,1.3-3.11c0.14-0.62-0.35-1.21-0.98-1.21h0c-0.45,0-0.87,0.3-0.97,0.74c-0.2,0.91-0.57,1.76-1.05,2.53 C18.5,16.66,18.58,17.17,18.9,17.49z M13,20.77L13,20.77c0,0.64,0.59,1.13,1.21,0.98c1.12-0.26,2.17-0.7,3.11-1.3 c0.54-0.34,0.61-1.1,0.16-1.55l0,0c-0.32-0.32-0.83-0.4-1.21-0.15c-0.76,0.49-1.61,0.85-2.53,1.05C13.3,19.9,13,20.31,13,20.77z M13,12V8c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v4H9.41c-0.89,0-1.34,1.08-0.71,1.71l2.59,2.59c0.39,0.39,1.02,0.39,1.41,0 l2.59-2.59c0.63-0.63,0.18-1.71-0.71-1.71H13z M11,20.77L11,20.77c0,0.64-0.59,1.13-1.21,0.99C5.33,20.75,2,16.77,2,12 s3.33-8.75,7.79-9.75C10.41,2.11,11,2.59,11,3.23v0c0,0.46-0.31,0.87-0.76,0.97C6.67,5,4,8.19,4,12s2.67,7,6.24,7.8 C10.69,19.9,11,20.31,11,20.77z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.6 5.64 5.35 8.04 2.34 8.36 0 10.91 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 file-download
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.59,9H15V4c0-0.55-0.45-1-1-1h-4C9.45,3,9,3.45,9,4v5H7.41c-0.89,0-1.34,1.08-0.71,1.71l4.59,4.59 c0.39,0.39,1.02,0.39,1.41,0l4.59-4.59C17.92,10.08,17.48,9,16.59,9z M5,19c0,0.55,0.45,1,1,1h12c0.55,0,1-0.45,1-1s-0.45-1-1-1H6 C5.45,18,5,18.45,5,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 drive-folder-upload
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H4C2.9,4,2.01,4.9,2.01,6L2,18c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V8 C22,6.9,21.1,6,20,6z M13,13v3c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v-3H9.21c-0.45,0-0.67-0.54-0.35-0.85l2.8-2.79 c0.2-0.2,0.51-0.19,0.71,0l2.79,2.79C15.46,12.46,15.24,13,14.8,13H13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 upload-file
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.41,7.41l-4.83-4.83C14.21,2.21,13.7,2,13.17,2H6C4.9,2,4.01,2.9,4.01,4L4,20c0,1.1,0.89,2,1.99,2H18c1.1,0,2-0.9,2-2 V8.83C20,8.3,19.79,7.79,19.41,7.41z M14.8,15H13v3c0,0.55-0.45,1-1,1s-1-0.45-1-1v-3H9.21c-0.45,0-0.67-0.54-0.35-0.85l2.8-2.79 c0.2-0.19,0.51-0.19,0.71,0l2.79,2.79C15.46,14.46,15.24,15,14.8,15z M14,9c-0.55,0-1-0.45-1-1V3.5L18.5,9H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 grid-view
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5,11h4c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2H5C3.9,3,3,3.9,3,5v4C3,10.1,3.9,11,5,11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M5,21h4c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2H5c-1.1,0-2,0.9-2,2v4C3,20.1,3.9,21,5,21z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,5v4c0,1.1,0.9,2,2,2h4c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2h-4C13.9,3,13,3.9,13,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,21h4c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2h-4c-1.1,0-2,0.9-2,2v4C13,20.1,13.9,21,15,21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 cloud-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M24 15c0-2.64-2.05-4.78-4.65-4.96C18.67 6.59 15.64 4 12 4c-1.33 0-2.57.36-3.65.97l1.49 1.49C10.51 6.17 11.23 6 12 6c3.04 0 5.5 2.46 5.5 5.5v.5H19c1.66 0 3 1.34 3 3 0 .99-.48 1.85-1.21 2.4l1.41 1.41c1.09-.92 1.8-2.27 1.8-3.81zM3.71 4.56c-.39.39-.39 1.02 0 1.41l2.06 2.06h-.42c-3.28.35-5.76 3.34-5.29 6.79C.46 17.84 3.19 20 6.22 20h11.51l1.29 1.29c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.12 4.56c-.39-.39-1.02-.39-1.41 0zM6 18c-2.21 0-4-1.79-4-4s1.79-4 4-4h1.73l8 8H6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 request-quote
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M19.41,7.41l-4.83-4.83C14.21,2.21,13.7,2,13.17,2H6C4.9,2,4.01,2.9,4.01,4L4,20c0,1.1,0.89,2,1.99,2H18c1.1,0,2-0.9,2-2 V8.83C20,8.3,19.79,7.79,19.41,7.41z M14,13c0.55,0,1,0.45,1,1v3c0,0.55-0.45,1-1,1h-1c0,0.55-0.45,1-1,1s-1-0.45-1-1h-1 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h3v-1h-3c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1h1c0-0.55,0.45-1,1-1s1,0.45,1,1h1 c0.55,0,1,0.45,1,1c0,0.55-0.45,1-1,1h-3v1H14z M14,8c-0.55,0-1-0.45-1-1V3.5L17.5,8H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 folder-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M2.81,2.81c-0.39-0.39-1.02-0.39-1.41,0C1,3.2,1,3.83,1.39,4.22l0.85,0.85C2.1,5.35,2.01,5.66,2.01,6L2,18 c0,1.1,0.9,2,2,2h13.17l2.61,2.61c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41L2.81,2.81z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,6h-8l-1.41-1.41C10.21,4.21,9.7,4,9.17,4H6.83l14.93,14.93C21.91,18.65,22,18.34,22,18V8C22,6.9,21.1,6,20,6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 upload
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 16h4c.55 0 1-.45 1-1v-5h1.59c.89 0 1.34-1.08.71-1.71L12.71 3.7c-.39-.39-1.02-.39-1.41 0L6.71 8.29c-.63.63-.19 1.71.7 1.71H9v5c0 .55.45 1 1 1zm-4 2h12c.55 0 1 .45 1 1s-.45 1-1 1H6c-.55 0-1-.45-1-1s.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 approval
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M4,16v4c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4c0-1.1-0.9-2-2-2H6C4.9,14,4,14.9,4,16z M17,18H7c-0.55,0-1-0.45-1-1v0 c0-0.55,0.45-1,1-1h10c0.55,0,1,0.45,1,1v0C18,17.55,17.55,18,17,18z M12,2C9.54,2,7.48,3.79,7.07,6.13 C6.99,6.65,7.13,7.18,7.43,7.6l3.76,5.26c0.4,0.56,1.23,0.56,1.63,0l3.76-5.26c0.3-0.42,0.44-0.95,0.35-1.47 C16.52,3.79,14.46,2,12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 phone-callback
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.23 15.26l-2.54-.29c-.61-.07-1.21.14-1.64.57l-1.84 1.84c-2.83-1.44-5.15-3.75-6.59-6.59l1.85-1.85c.43-.43.64-1.03.57-1.64l-.29-2.52c-.12-1.01-.97-1.77-1.99-1.77H5.03c-1.13 0-2.07.94-2 2.07.53 8.54 7.36 15.36 15.89 15.89 1.13.07 2.07-.87 2.07-2v-1.73c.01-1.01-.75-1.86-1.76-1.98zM13 11h4c.55 0 1-.45 1-1s-.45-1-1-1h-1.59l4.31-4.31c.39-.39.39-1.02 0-1.41s-1.02-.39-1.41 0L14 7.59V6c0-.55-.45-1-1-1s-1 .45-1 1v4c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vibration
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M1 15c.55 0 1-.45 1-1v-4c0-.55-.45-1-1-1s-1 .45-1 1v4c0 .55.45 1 1 1zm3 2c.55 0 1-.45 1-1V8c0-.55-.45-1-1-1s-1 .45-1 1v8c0 .55.45 1 1 1zm18-7v4c0 .55.45 1 1 1s1-.45 1-1v-4c0-.55-.45-1-1-1s-1 .45-1 1zm-2 7c.55 0 1-.45 1-1V8c0-.55-.45-1-1-1s-1 .45-1 1v8c0 .55.45 1 1 1zM16.5 3h-9C6.67 3 6 3.67 6 4.5v15c0 .83.67 1.5 1.5 1.5h9c.83 0 1.5-.67 1.5-1.5v-15c0-.83-.67-1.5-1.5-1.5zM16 19H8V5h8v14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-paused
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 3c-.55 0-1 .45-1 1v5c0 .55.45 1 1 1s1-.45 1-1V4c0-.55-.45-1-1-1zm3 1v5c0 .55.45 1 1 1s1-.45 1-1V4c0-.55-.45-1-1-1s-1 .45-1 1zm.23 11.26l-2.54-.29c-.61-.07-1.21.14-1.64.57l-1.84 1.84c-2.83-1.44-5.15-3.75-6.59-6.59l1.85-1.85c.43-.43.64-1.03.57-1.64l-.29-2.52c-.12-1.01-.97-1.77-1.99-1.77H5.03c-1.13 0-2.07.94-2 2.07.53 8.54 7.36 15.36 15.89 15.89 1.13.07 2.07-.87 2.07-2v-1.73c.01-1.01-.75-1.86-1.76-1.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.01 7L16 4c0-.55-.45-1-1-1s-1 .45-1 1v3h-4V4c0-.55-.45-1-1-1s-1 .45-1 1v3h-.01C6.9 7 6 7.9 6 8.99v4.66c0 .53.21 1.04.58 1.41L9.5 18v2c0 .55.45 1 1 1h3c.55 0 1-.45 1-1v-2l2.92-2.92c.37-.38.58-.89.58-1.42V8.99C18 7.89 17.11 7 16.01 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wifi
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2.06 10.06c.51.51 1.32.56 1.87.1 4.67-3.84 11.45-3.84 16.13-.01.56.46 1.38.42 1.89-.09.59-.59.55-1.57-.1-2.1-5.71-4.67-13.97-4.67-19.69 0-.65.52-.7 1.5-.1 2.1zm7.76 7.76l1.47 1.47c.39.39 1.02.39 1.41 0l1.47-1.47c.47-.47.37-1.28-.23-1.59-1.22-.63-2.68-.63-3.91 0-.57.31-.68 1.12-.21 1.59zm-3.73-3.73c.49.49 1.26.54 1.83.13 2.44-1.73 5.72-1.73 8.16 0 .57.4 1.34.36 1.83-.13l.01-.01c.6-.6.56-1.62-.13-2.11-3.44-2.49-8.13-2.49-11.58 0-.69.5-.73 1.51-.12 2.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-recline-extra
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.35 5.64c-.9-.64-1.12-1.88-.49-2.79.63-.9 1.88-1.12 2.79-.49.9.64 1.12 1.88.49 2.79-.64.9-1.88 1.12-2.79.49zM16 20c0-.55-.45-1-1-1H8.93c-1.48 0-2.74-1.08-2.96-2.54L4.16 7.78C4.07 7.33 3.67 7 3.2 7c-.62 0-1.08.57-.96 1.18l1.75 8.58C4.37 19.2 6.47 21 8.94 21H15c.55 0 1-.45 1-1zm-.46-5h-4.19l-1.03-4.1c1.28.72 2.63 1.28 4.1 1.3.58.01 1.05-.49 1.05-1.07 0-.59-.49-1.04-1.08-1.06-1.31-.04-2.63-.56-3.61-1.33L9.14 7.47c-.23-.18-.49-.3-.76-.38-.32-.09-.66-.12-.99-.06h-.02c-1.23.22-2.05 1.39-1.84 2.61l1.35 5.92C7.16 16.98 8.39 18 9.83 18h6.85l3.09 2.42c.42.33 1.02.29 1.39-.08.45-.45.4-1.18-.1-1.57l-4.29-3.35c-.35-.27-.78-.42-1.23-.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sms-failed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 12h-2v-2h2v2zm-1-4c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-normal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 12V4c0-.55-.45-1-1-1s-1 .45-1 1v8c0 2.76 2.24 5 5 5h5c.55 0 1-.45 1-1s-.45-1-1-1H8c-1.66 0-3-1.34-3-3zm15.5 6H19v-7c0-1.1-.9-2-2-2h-5V3H6v8c0 1.65 1.35 3 3 3h7v5c0 1.1.9 2 2 2h2.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-disturb-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4 11H8c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 enhanced-encryption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 8h-1V6c0-2.76-2.24-5-5-5S7 3.24 7 6v2H6c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V10c0-1.1-.9-2-2-2zM8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2H8.9V6zM15 16h-2v2c0 .55-.45 1-1 1s-1-.45-1-1v-2H9c-.55 0-1-.45-1-1s.45-1 1-1h2v-2c0-.55.45-1 1-1s1 .45 1 1v2h2c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tap-and-play
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3.14 16.09c-.6-.1-1.14.39-1.14 1 0 .49.36.9.85.98 2.08.36 3.72 2 4.08 4.08.08.49.49.85.98.85.61 0 1.09-.54 1-1.14-.48-2.95-2.81-5.29-5.77-5.77zM2 20v3h3c0-1.66-1.34-3-3-3zm1.11-7.94c-.59-.06-1.11.4-1.11.99 0 .5.37.94.87.99 4.27.41 7.67 3.81 8.08 8.08.05.5.48.88.99.88.59 0 1.06-.51 1-1.1-.51-5.2-4.63-9.32-9.83-9.84zM17 1.01L7 1c-1.1 0-2 .9-2 2v7.37c.69.16 1.36.37 2 .64V5h10v13h-3.03c.52 1.25.84 2.59.95 4H17c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-locked
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,5V4.11c0-1-0.68-1.92-1.66-2.08C17.08,1.82,16,2.79,16,4v1c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h4 c0.55,0,1-0.45,1-1V6C21,5.45,20.55,5,20,5z M19,5h-2V4c0-0.55,0.45-1,1-1s1,0.45,1,1V5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.63,14.4l-2.52,2.5c-2.5-1.43-4.57-3.5-6-6l2.5-2.52c0.23-0.24,0.33-0.57,0.27-0.9L9.13,3.8C9.04,3.34,8.63,3,8.15,3 L4,3C3.44,3,2.97,3.47,3,4.03C3.17,6.92,4.05,9.63,5.43,12c1.58,2.73,3.85,4.99,6.57,6.57c2.37,1.37,5.08,2.26,7.97,2.43 c0.56,0.03,1.03-0.44,1.03-1l0-4.15c0-0.48-0.34-0.89-0.8-0.98l-3.67-0.73C16.2,14.07,15.86,14.17,15.63,14.4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 do-not-disturb-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M16,13H8c-0.55,0-1-0.45-1-1l0,0c0-0.55,0.45-1,1-1 h8c0.55,0,1,0.45,1,1l0,0C17,12.55,16.55,13,16,13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 do-disturb
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8 0-1.85.63-3.55 1.69-4.9L16.9 18.31C15.55 19.37 13.85 20 12 20zm6.31-3.1L7.1 5.69C8.45 4.63 10.15 4 12 4c4.42 0 8 3.58 8 8 0 1.85-.63 3.55-1.69 4.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 power-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 13.66V8.99c0-1-1.01-2-2-1.99V4c0-.55-.45-1-1-1s-1 .45-1 1v3h-3.88l7.63 7.63c.15-.3.25-.63.25-.97zM10 4c0-.55-.45-1-1-1s-1 .45-1 1v.88l2 2V4zm10.15 15.86l-7.66-7.66-5.1-5.1-2.56-2.56c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l2.63 2.63c-.03.13-.05.27-.05.41v4.66c0 .53.21 1.04.58 1.41L9.5 18v2c0 .55.45 1 1 1h3c.55 0 1-.45 1-1v-2l.48-.48 3.76 3.76c.39.39 1.02.39 1.41 0 .39-.39.39-1.03 0-1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 voice-chat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-1.99.9-1.99 2L2 22l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-3.62 10.7L14 10.8V13c0 .55-.45 1-1 1H7c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1h6c.55 0 1 .45 1 1v2.2l2.38-1.9c.65-.52 1.62-.06 1.62.78v3.84c0 .84-.97 1.3-1.62.78z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-reduced
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.97 19.2c.18.96-.55 1.8-1.47 1.8h-2.69c-1.3 0-2.26-1.22-1.94-2.49L15 14H9c-1.65 0-3-1.35-3-3V3h6v6h5c1.1 0 2 .9 2 2l-2 7h1.44c.73 0 1.39.49 1.53 1.2zM5 12V4c0-.55-.45-1-1-1s-1 .45-1 1v8c0 2.76 2.24 5 5 5h3c.55 0 1-.45 1-1s-.45-1-1-1H8c-1.66 0-3-1.34-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM9 11H7V9h2v2zm4 0h-2V9h2v2zm4 0h-2V9h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sd-card
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 2h-7.17c-.53 0-1.04.21-1.42.59L4.6 7.42c-.37.37-.6.88-.6 1.4V20c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 6c-.55 0-1-.45-1-1V5c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1zm3 0c-.55 0-1-.45-1-1V5c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1zm3 0c-.55 0-1-.45-1-1V5c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-problem
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 12c0 2.21.91 4.2 2.36 5.64l-1.51 1.51c-.31.31-.09.85.36.85H8.5c.28 0 .5-.22.5-.5v-4.29c0-.45-.54-.67-.85-.35l-1.39 1.39C5.68 15.15 5 13.66 5 12c0-2.39 1.4-4.46 3.43-5.42.34-.16.57-.47.57-.84v-.19c0-.68-.71-1.11-1.32-.82C4.92 5.99 3 8.77 3 12zm8 5h2v-2h-2v2zm8.79-13H15.5c-.28 0-.5.22-.5.5v4.29c0 .45.54.67.85.35l1.39-1.39C18.32 8.85 19 10.34 19 12c0 2.39-1.4 4.46-3.43 5.42-.34.16-.57.47-.57.84v.18c0 .68.71 1.11 1.32.82C19.08 18.01 21 15.23 21 12c0-2.21-.91-4.2-2.36-5.64l1.51-1.51c.31-.31.09-.85-.36-.85zM12 13c.55 0 1-.45 1-1V8c0-.55-.45-1-1-1s-1 .45-1 1v4c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 folder-special
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 6h-8l-1.41-1.41C10.21 4.21 9.7 4 9.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-3.06 10.41L15 15.28l-1.94 1.13c-.38.22-.84-.12-.74-.55l.51-2.2-1.69-1.46c-.33-.29-.16-.84.28-.88l2.23-.19.88-2.06c.17-.4.75-.4.92 0l.88 2.06 2.23.19c.44.04.62.59.28.88l-1.69 1.46.51 2.2c.11.43-.35.77-.72.55z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 network-locked
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12l0-7.58c0-0.89-1.08-1.34-1.71-0.71L3.71,20.29C3.08,20.92,3.52,22,4.41,22H15v-6c0-2.21,1.79-4,4-4H22z M22,17v-1 c0-1.1-0.9-2-2-2c-1.1,0-2,0.9-2,2v1c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-3C23,17.45,22.55,17,22,17z M19,16c0-0.55,0.45-1,1-1s1,0.45,1,1v1h-2V16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 system-update
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 1.01L7 1c-1.1 0-2 .9-2 2v18c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V3c0-1.1-.9-1.99-2-1.99zM17 19H7V5h10v14zm-2.21-6H13V9c0-.55-.45-1-1-1s-1 .45-1 1v4H9.21c-.45 0-.67.54-.35.85l2.79 2.79c.2.2.51.2.71 0l2.79-2.79c.31-.31.09-.85-.36-.85z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,20c-4.42,0-8-3.58-8-8 c0-1.85,0.63-3.55,1.69-4.9L16.9,18.31C15.55,19.37,13.85,20,12,20z M18.31,16.9L7.1,5.69C8.45,4.63,10.15,4,12,4 c4.42,0,8,3.58,8,8C20,13.85,19.37,15.55,18.31,16.9z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 tv-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 8v9.88l1.85 1.85c.1-.22.15-.47.15-.73V7c0-1.11-.9-2-2-2h-7.59l2.94-2.94c.2-.2.2-.51 0-.71s-.51-.2-.71 0L12 4.99 8.36 1.35c-.2-.2-.51-.2-.71 0s-.2.51 0 .71L10.59 5H8.12l2 2H20c.55 0 1 .45 1 1zM3.12 2.83c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l.82.82C1.65 5.28 1 6.06 1 7v12c0 1.1.9 2 2 2h15.46l1.29 1.29c.39.39 1.02.39 1.41 0 .36-.36.37-.92.07-1.31h.03L3.12 2.83zM3 18V8c0-.55.45-1 1-1h.46l12 12H4c-.55 0-1-.45-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-individual-suite
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 13c1.65 0 3-1.35 3-3S8.65 7 7 7s-3 1.35-3 3 1.35 3 3 3zm12-6h-6c-1.1 0-2 .9-2 2v5H3V8c0-.55-.45-1-1-1s-1 .45-1 1v7c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2v-4c0-2.21-1.79-4-4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 time-to-leave
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.92 5.01C18.72 4.42 18.16 4 17.5 4h-11c-.66 0-1.21.42-1.42 1.01l-1.97 5.67c-.07.21-.11.43-.11.66v7.16c0 .83.67 1.5 1.5 1.5S6 19.33 6 18.5V18h12v.5c0 .82.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5v-7.16c0-.22-.04-.45-.11-.66l-1.97-5.67zM6.5 15c-.83 0-1.5-.67-1.5-1.5S5.67 12 6.5 12s1.5.67 1.5 1.5S7.33 15 6.5 15zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 10l1.27-3.82c.14-.4.52-.68.95-.68h9.56c.43 0 .81.28.95.68L19 10H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 live-tv
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10.5 17.15l3.98-2.28c.67-.38.67-1.35 0-1.74l-3.98-2.28c-.67-.38-1.5.11-1.5.87v4.55c0 .77.83 1.26 1.5.88zM21 6h-7.59l2.94-2.94c.2-.2.2-.51 0-.71s-.51-.2-.71 0L12 5.99 8.36 2.35c-.2-.2-.51-.2-.71 0s-.2.51 0 .71L10.59 6H3c-1.1 0-2 .89-2 2v12c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.11-.9-2-2-2zm-1 14H4c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wc
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.01 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.5 21v-6.5H5c-.55 0-1-.45-1-1V9c0-1.1.9-2 2-2h3c1.1 0 2 .9 2 2v4.5c0 .55-.45 1-1 1h-.5V21c0 .55-.45 1-1 1h-2c-.55 0-1-.45-1-1zM18 21v-5h1.61c.68 0 1.16-.67.95-1.32l-2.1-6.31C18.18 7.55 17.42 7 16.56 7h-.12c-.86 0-1.63.55-1.9 1.37l-2.1 6.31c-.22.65.26 1.32.95 1.32H15v5c0 .55.45 1 1 1h1c.55 0 1-.45 1-1zM7.5 6c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2zm9 0c1.11 0 2-.89 2-2s-.89-2-2-2-2 .89-2 2 .89 2 2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vpn-lock
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.92,11c0.44,3.63-1.52,5.85-2.02,6.39C17.64,16.58,16.9,16,16,16h-1v-3c0-0.55-0.45-1-1-1H8v-2h2c0.55,0,1-0.45,1-1V7h2 c1.1,0,2-0.9,2-2V2.46C14.05,2.16,13.05,2,12,2C6.48,2,2,6.48,2,12s4.48,10,10,10c5.73,0,10.51-4.86,9.95-11H19.92z M11,19.93 C7.05,19.44,4,16.08,4,12c0-0.62,0.08-1.21,0.21-1.79L9,15v1c0,1.1,0.9,2,2,2V19.93z M22,4V3.11c0-1-0.68-1.92-1.66-2.08 C19.08,0.82,18,1.79,18,3v1c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1V5C23,4.45,22.55,4,22,4z M21,4h-2V3 c0-0.55,0.45-1,1-1s1,0.45,1,1V4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 account-tree
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M17,11h3c1.11,0,2-0.9,2-2V5c0-1.11-0.9-2-2-2h-3c-1.11,0-2,0.9-2,2v1H9.01V5c0-1.11-0.9-2-2-2H4C2.9,3,2,3.9,2,5v4 c0,1.11,0.9,2,2,2h3c1.11,0,2-0.9,2-2V8H11v7.01c0,1.65,1.34,2.99,2.99,2.99H15v1c0,1.11,0.9,2,2,2h3c1.11,0,2-0.9,2-2v-4 c0-1.11-0.9-2-2-2h-3c-1.11,0-2,0.9-2,2v1h-1.01C13.45,16,13,15.55,13,15.01V8h2v1C15,10.1,15.9,11,17,11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-in-talk
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.88 5.05c3.18.4 5.67 2.89 6.07 6.07.06.51.49.88.99.88.04 0 .08 0 .12-.01.55-.07.94-.57.87-1.12-.51-4.09-3.72-7.3-7.81-7.81-.55-.06-1.05.33-1.11.88-.07.55.32 1.05.87 1.11zm.38 2.11c-.53-.14-1.08.18-1.22.72s.18 1.08.72 1.22c1.05.27 1.87 1.09 2.15 2.15.12.45.52.75.97.75.08 0 .17-.01.25-.03.53-.14.85-.69.72-1.22-.47-1.77-1.84-3.14-3.59-3.59zm5.97 8.1l-2.54-.29c-.61-.07-1.21.14-1.64.57l-1.84 1.84c-2.83-1.44-5.15-3.75-6.59-6.59l1.85-1.85c.43-.43.64-1.03.57-1.64l-.29-2.52c-.12-1.01-.97-1.77-1.99-1.77H5.03c-1.13 0-2.07.94-2 2.07.53 8.54 7.36 15.36 15.89 15.89 1.13.07 2.07-.87 2.07-2v-1.73c.01-1.01-.75-1.86-1.76-1.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-chat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,2H4C2.9,2,2.01,2.9,2.01,4L2,19.58c0,0.89,1.08,1.34,1.71,0.71L6,18h14c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M16.15,12.15L15,11.01V13c0,0.55-0.45,1-1,1H8c-0.55,0-1-0.45-1-1V7c0-0.55,0.45-1,1-1h6c0.55,0,1,0.45,1,1v1.99l1.15-1.14 C16.46,7.53,17,7.76,17,8.2v3.59C17,12.24,16.46,12.47,16.15,12.15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airline-seat-flat-angled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22.25 14.29l-.69 1.89L9.2 11.71l1.39-3.79c.38-1.03 1.52-1.56 2.56-1.19l6.69 2.41c2.1.76 3.18 3.06 2.41 5.15zm-19.8-1.81l5.55 2V18c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-.63l3.58 1.29c.52.19 1.1-.08 1.29-.6.19-.52-.08-1.1-.6-1.29L3.13 10.59c-.52-.19-1.1.08-1.29.6-.18.52.09 1.1.61 1.29zM7.3 10.2c1.49-.72 2.12-2.51 1.41-4C7.99 4.71 6.2 4.08 4.7 4.8c-1.49.71-2.12 2.5-1.4 4 .71 1.49 2.5 2.12 4 1.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 directions-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "m21.71 11.29-9-9a.996.996 0 00-1.41 0L8.21 5.38 13 10.17V7.5l3.15 3.15c.2.2.2.51 0 .71l-.98.98 3.45 3.45 3.09-3.09c.38-.38.38-1.01 0-1.41z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M6.79 6.79 3.51 3.51A.996.996 0 102.1 4.92L5.38 8.2l-3.09 3.09a.996.996 0 000 1.41l9 9c.39.39 1.02.39 1.41 0l3.09-3.09 3.28 3.28a.996.996 0 101.41-1.41L6.79 6.79zM9.99 14c0 .55-.45 1-1 1s-1-.45-1-1v-3c0-.05.02-.1.03-.15l1.97 1.97V14z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 no-encryption-gmailerrorred
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:d
    "M8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2h-4.66L20 17.56V10c0-1.1-.9-2-2-2h-1V6c0-2.76-2.24-5-5-5-2.32 0-4.26 1.59-4.82 3.74L8.9 6.46V6zm-3.78-.49c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l1.33 1.33C4.42 8.6 4 9.25 4 10v10c0 1.1.9 2 2 2h12.78l.29.29c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.12 5.51z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wifi-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.06 10.14c.56.46 1.38.42 1.89-.09.59-.59.55-1.57-.1-2.1-3.59-2.94-8.2-4.03-12.55-3.26l2.59 2.59c2.89-.03 5.8.92 8.17 2.86zm-2.27 1.83c-.78-.57-1.63-1-2.52-1.3l2.95 2.95c.24-.58.1-1.27-.43-1.65zm-3.84 4.26c-1.22-.63-2.68-.63-3.91 0-.59.31-.7 1.12-.23 1.59l1.47 1.47c.39.39 1.02.39 1.41 0l1.47-1.47c.49-.47.39-1.28-.21-1.59zm5.73 1.67L4.12 2.34c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L5.05 6.1c-1.01.5-1.99 1.11-2.89 1.85-.65.53-.69 1.51-.1 2.1.51.51 1.32.56 1.87.1 1-.82 2.1-1.46 3.25-1.93l2.23 2.23c-1.13.3-2.21.8-3.19 1.51-.69.5-.73 1.51-.13 2.11l.01.01c.49.49 1.26.54 1.83.13 1.19-.84 2.58-1.26 3.97-1.29l6.37 6.37c.39.39 1.02.39 1.41 0 .39-.37.39-1 0-1.39z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 3H7c-.69 0-1.23.35-1.59.88L.37 11.45c-.22.34-.22.77 0 1.11l5.04 7.56c.36.52.97.88 1.66.88H22c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 13.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm5 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm5 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v18l4-4h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM5.63 13.19l2.49-3.2c.2-.25.58-.26.78-.01l2.1 2.53 3.1-3.99c.2-.26.6-.26.8.01l3.51 4.68c.25.33.01.8-.4.8H6.02c-.41-.01-.65-.49-.39-.82z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-disturb-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 11v2h-.88l4.33 4.33C21.43 15.79 22 13.96 22 12c0-5.52-4.48-10-10-10-1.96 0-3.79.57-5.33 1.55L14.12 11H17zm4.17 9.88L3.12 2.83c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l2.07 2.07C2.66 7.93 2 9.89 2 12c0 5.52 4.48 10 10 10 2.11 0 4.07-.66 5.68-1.78l2.07 2.07c.39.39 1.02.39 1.41 0 .4-.39.4-1.02.01-1.41zM7 13v-2h1.46l2 2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-missed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23.09 16.2c-6.33-5.59-15.86-5.59-22.18 0-.84.74-.84 2.05-.05 2.84l1.2 1.2c.71.71 1.84.77 2.62.15l1.97-1.57c.47-.37.75-.94.75-1.55V14.7c2.98-.97 6.21-.98 9.2 0v2.58c0 .6.28 1.17.75 1.55l1.96 1.56c.79.62 1.91.56 2.62-.15l1.2-1.2c.8-.79.79-2.1-.04-2.84zM6 9c.55 0 1-.45 1-1V6.43l4.24 4.24c.39.39 1.02.39 1.41 0l5.66-5.66c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0l-4.95 4.95L8.4 5H10c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 network-check
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.9 5c-.17 0-.32.09-.41.23l-.07.15-5.18 11.65c-.16.29-.26.61-.26.96 0 1.11.9 2.01 2.01 2.01.96 0 1.77-.68 1.96-1.59l.01-.03L16.4 5.5c0-.28-.22-.5-.5-.5zM2.06 10.06c.51.51 1.33.55 1.89.09 2.76-2.26 6.24-3.18 9.58-2.76l1.19-2.68c-4.35-.78-8.96.3-12.57 3.25-.64.53-.68 1.51-.09 2.1zm19.88 0c.59-.59.55-1.57-.1-2.1-1.36-1.11-2.86-1.95-4.44-2.53l-.53 2.82c1.13.47 2.19 1.09 3.17 1.89.58.46 1.39.43 1.9-.08zm-4.03 4.03c.6-.6.56-1.63-.14-2.12-.46-.33-.94-.61-1.44-.86l-.55 2.92c.11.07.22.14.32.22.57.4 1.33.32 1.81-.16zm-11.83-.01c.5.5 1.27.54 1.85.13.94-.66 2.01-1.06 3.1-1.22l1.28-2.88c-2.13-.06-4.28.54-6.09 1.84-.69.51-.74 1.53-.14 2.13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adb
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 16c0 3.87 3.13 7 7 7s7-3.13 7-7v-4H5v4zM16.12 4.37l2.1-2.1-.82-.83-2.3 2.31C14.16 3.28 13.12 3 12 3s-2.16.28-3.09.75L6.6 1.44l-.82.83 2.1 2.1C6.14 5.64 5 7.68 5 10v1h14v-1c0-2.32-1.14-4.36-2.88-5.63zM9 9c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm6 0c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ondemand-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.11-.9-2-2-2zm-1 14H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1zm-5.52-5.13l-3.98 2.28c-.67.38-1.5-.11-1.5-.87V8.72c0-.77.83-1.25 1.5-.87l3.98 2.28c.67.39.67 1.35 0 1.74z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-forwarded
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22.65 5.65l-3.79-3.79c-.32-.32-.86-.1-.86.35V4h-3.5c-.28 0-.5.22-.5.5v3c0 .28.22.5.5.5H18v1.79c0 .45.54.67.85.35l3.79-3.79c.2-.19.2-.51.01-.7zm-3.42 9.61l-2.54-.29c-.61-.07-1.21.14-1.64.57l-1.84 1.84c-2.83-1.44-5.15-3.75-6.59-6.59l1.85-1.85c.43-.43.64-1.03.57-1.64l-.29-2.52c-.12-1.01-.97-1.77-1.99-1.77H5.03c-1.13 0-2.07.94-2 2.07.53 8.54 7.36 15.36 15.89 15.89 1.13.07 2.07-.87 2.07-2v-1.73c.01-1.01-.75-1.86-1.76-1.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-encryption
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none",
    :d "M0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0zm0 0h24v24H0V0z",
    :stroke nil})
  (helix.dom/path
   {:d
    "M8.9 6c0-1.71 1.39-3.1 3.1-3.1s3.1 1.39 3.1 3.1v2h-4.66L20 17.56V10c0-1.1-.9-2-2-2h-1V6c0-2.76-2.24-5-5-5-2.32 0-4.26 1.59-4.82 3.74L8.9 6.46V6zm-3.78-.49c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l1.33 1.33C4.42 8.6 4 9.25 4 10v10c0 1.1.9 2 2 2h12.78l.29.29c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.12 5.51z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 10H8c-.55 0-1 .45-1 1s.45 1 1 1h8c.55 0 1-.45 1-1s-.45-1-1-1zm3-7h-1V2c0-.55-.45-1-1-1s-1 .45-1 1v1H8V2c0-.55-.45-1-1-1s-1 .45-1 1v1H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H6c-.55 0-1-.45-1-1V8h14v10c0 .55-.45 1-1 1zm-5-5H8c-.55 0-1 .45-1 1s.45 1 1 1h5c.55 0 1-.45 1-1s-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sim-card-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,2h-7.17C10.3,2,9.79,2.21,9.41,2.59L4.6,7.42C4.23,7.79,4.02,8.3,4.02,8.82L4,20c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2 V4C20,2.9,19.1,2,18,2z M12,17L12,17c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C13,16.55,12.55,17,12,17z M12,13L12,13c-0.55,0-1-0.45-1-1V9c0-0.55,0.45-1,1-1l0,0c0.55,0,1,0.45,1,1v3C13,12.55,12.55,13,12,13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 do-disturb-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zM4 12c0-4.4 3.6-8 8-8 1.8 0 3.5.6 4.9 1.7L5.7 16.9C4.6 15.5 4 13.8 4 12zm8 8c-1.8 0-3.5-.6-4.9-1.7L18.3 7.1C19.4 8.5 20 10.2 20 12c0 4.4-3.6 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 running-with-errors
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21,18c-0.55,0-1-0.45-1-1v-6c0-0.55,0.45-1,1-1s1,0.45,1,1v6C22,17.55,21.55,18,21,18z M21,20c-0.55,0-1,0.45-1,1 s0.45,1,1,1s1-0.45,1-1S21.55,20,21,20z M18,17.29C16.53,18.95,14.39,20,12,20c-4.41,0-8-3.59-8-8c0-4.41,3.59-8,8-8v9l7.55-7.55 C17.72,3.34,15.02,2,12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10c2.25,0,4.33-0.74,6-2V17.29z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,2C6.5,2,2,6.5,2,12s4.5,10,10,10s10-4.5,10-10S17.5,2,12,2z M4,12c0-4.4,3.6-8,8-8c1.8,0,3.5,0.6,4.9,1.7L5.7,16.9 C4.6,15.5,4,13.8,4,12z M12,20c-1.8,0-3.5-0.6-4.9-1.7L18.3,7.1C19.4,8.5,20,10.2,20,12C20,16.4,16.4,20,12,20z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 airline-seat-recline-normal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.59 5.41c-.78-.78-.78-2.05 0-2.83s2.05-.78 2.83 0 .78 2.05 0 2.83c-.79.79-2.05.79-2.83 0zM6 16V8c0-.55-.45-1-1-1s-1 .45-1 1v8c0 2.76 2.24 5 5 5h5c.55 0 1-.45 1-1s-.45-1-1-1H9c-1.66 0-3-1.34-3-3zm13.28 3.35l-3.77-3.77c-.37-.37-.88-.58-1.41-.58h-2.6v-3.68c1.09.89 2.66 1.7 4.2 2.02.67.14 1.3-.36 1.3-1.04 0-.53-.39-.96-.92-1.05-1.42-.24-2.88-1.01-3.75-1.97l-1.4-1.55c-.19-.21-.43-.38-.69-.5-.29-.14-.62-.23-.96-.23h-.03C8.01 7 7 8.01 7 9.25V15c0 1.66 1.34 3 3 3h5.07l2.78 2.78c.39.39 1.04.39 1.43 0 .4-.39.4-1.03 0-1.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-disturb-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,11v2h-1.17l4.51,4.51C21.39,15.93,22,14.04,22,12c0-5.52-4.48-10-10-10C9.96,2,8.07,2.61,6.49,3.66L13.83,11H17z M2.1,4.93l1.56,1.56c-1.37,2.07-2,4.68-1.48,7.45c0.75,3.95,3.92,7.13,7.88,7.88c2.77,0.52,5.38-0.1,7.45-1.48l1.56,1.56 c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0l0,0 C1.71,3.91,1.71,4.54,2.1,4.93z M7,11h1.17l2,2H7V11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airline-seat-flat
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 11v2H9V9c0-1.1.9-2 2-2h7c2.21 0 4 1.79 4 4zM2 15c0 .55.45 1 1 1h5v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h5c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1zm5.14-2.9c1.16-1.19 1.14-3.08-.04-4.24-1.19-1.16-3.08-1.14-4.24.04-1.16 1.19-1.14 3.08.04 4.24 1.19 1.16 3.08 1.14 4.24-.04z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sd-card-alert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 2h-7.17c-.53 0-1.04.21-1.42.59L4.6 7.42c-.37.37-.58.88-.58 1.4L4 20c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-5 15h-2v-2h2v2zm-1-4c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1s1 .45 1 1v3c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 disc-full
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 16h2v-2h-2v2zm0-8v3c0 .55.45 1 1 1s1-.45 1-1V8c0-.55-.45-1-1-1s-1 .45-1 1zM10 4c-4.42 0-8 3.58-8 8s3.58 8 8 8 8-3.58 8-8-3.58-8-8-8zm0 10c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 imagesearch-roller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,3v4c0,0.55-0.45,1-1,1H7C6.45,8,6,7.55,6,7V6H4v4h8c1.1,0,2,0.9,2,2v3h1c0.55,0,1,0.45,1,1v6c0,0.55-0.45,1-1,1h-4 c-0.55,0-1-0.45-1-1v-6c0-0.55,0.45-1,1-1h1v-3H4c-1.1,0-2-0.9-2-2V6c0-1.1,0.9-2,2-2h2V3c0-0.55,0.45-1,1-1h12 C19.55,2,20,2.45,20,3z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 personal-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h5v1c0 .55.45 1 1 1h6c.55 0 1-.45 1-1v-1h5c1.1 0 1.99-.9 1.99-2L23 5c0-1.11-.9-2-2-2zm-1 14H4c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h16c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 phone-bluetooth-speaker
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.23 15.26l-2.54-.29c-.61-.07-1.21.14-1.64.57l-1.84 1.84c-2.83-1.44-5.15-3.75-6.59-6.59l1.85-1.85c.43-.43.64-1.03.57-1.64l-.29-2.52c-.12-1.01-.97-1.77-1.99-1.77H5.03c-1.13 0-2.07.94-2 2.07.53 8.54 7.36 15.36 15.89 15.89 1.13.07 2.07-.87 2.07-2v-1.73c.01-1.01-.75-1.86-1.76-1.98zm-2.44-9.25l-2.45 2.45c-.2.2-.2.52 0 .71.2.2.52.2.71 0L17 7.23v3.15c0 .2.12.39.31.47.06.03.13.04.19.04.13 0 .26-.05.36-.15l2.18-2.18c.2-.2.2-.52 0-.71l-1.83-1.83 1.83-1.83c.09-.09.15-.22.15-.36s-.05-.26-.15-.36l-2.18-2.18c-.14-.14-.36-.19-.55-.11-.19.08-.31.26-.31.46v3.15l-1.95-1.95c-.2-.2-.52-.2-.71 0-.2.2-.2.52 0 .71l2.45 2.46zm1.22-3.15l.96.96-.96.96V2.86zm0 4.37l.96.96-.96.96V7.23z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 airline-seat-legroom-extra
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 12V4c0-.55-.45-1-1-1s-1 .45-1 1v8c0 2.76 2.24 5 5 5h5c.55 0 1-.45 1-1s-.45-1-1-1H7c-1.66 0-3-1.34-3-3zm18.83 5.24c-.38-.72-1.29-.97-2.03-.63l-1.09.5-3.41-6.98C15.96 9.45 15.27 9 14.51 9H11V3H5v8c0 1.66 1.34 3 3 3h7l2.56 5.25c.48.98 1.64 1.39 2.63.94l1.95-.89c.76-.36 1.09-1.3.69-2.06z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.01 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 4V2.21c0-.45-.54-.67-.85-.35l-2.8 2.79c-.2.2-.2.51 0 .71l2.79 2.79c.32.31.86.09.86-.36V6c3.31 0 6 2.69 6 6 0 .79-.15 1.56-.44 2.25-.15.36-.04.77.23 1.04.51.51 1.37.33 1.64-.34.37-.91.57-1.91.57-2.95 0-4.42-3.58-8-8-8zm0 14c-3.31 0-6-2.69-6-6 0-.79.15-1.56.44-2.25.15-.36.04-.77-.23-1.04-.51-.51-1.37-.33-1.64.34C4.2 9.96 4 10.96 4 12c0 4.42 3.58 8 8 8v1.79c0 .45.54.67.85.35l2.79-2.79c.2-.2.2-.51 0-.71l-2.79-2.79c-.31-.31-.85-.09-.85.36V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-busy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.84 16.47l1.91-1.91 1.91 1.91c.29.29.77.29 1.06 0 .29-.29.29-.77 0-1.06l-1.91-1.91 1.91-1.91c.29-.29.29-.77 0-1.06-.29-.29-.77-.29-1.06 0l-1.91 1.91-1.91-1.91c-.29-.29-.77-.29-1.06 0-.29.29-.29.77 0 1.06l1.91 1.91-1.91 1.91c-.29.29-.29.77 0 1.06.29.29.77.29 1.06 0zM19 3h-1V2c0-.55-.45-1-1-1s-1 .45-1 1v1H8V2c0-.55-.45-1-1-1s-1 .45-1 1v1H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H6c-.55 0-1-.45-1-1V8h14v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 event-available
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 10.53c-.29-.29-.77-.29-1.06 0l-4.35 4.35L9 13.29c-.29-.29-.77-.29-1.06 0-.29.29-.29.77 0 1.06l1.94 1.94c.39.39 1.02.39 1.41 0l4.7-4.7c.3-.29.3-.77.01-1.06zM19 3h-1V2c0-.55-.45-1-1-1s-1 .45-1 1v1H8V2c0-.55-.45-1-1-1s-1 .45-1 1v1H5c-1.11 0-1.99.9-1.99 2L3 19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H6c-.55 0-1-.45-1-1V8h14v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 support-agent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,12.22C21,6.73,16.74,3,12,3c-4.69,0-9,3.65-9,9.28C2.4,12.62,2,13.26,2,14v2c0,1.1,0.9,2,2,2h0c0.55,0,1-0.45,1-1 l0-4.81c0-3.83,2.95-7.18,6.78-7.29c3.96-0.12,7.22,3.06,7.22,7V19h-7c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h7c1.1,0,2-0.9,2-2 v-1.22c0.59-0.31,1-0.92,1-1.64v-2.3C22,13.14,21.59,12.53,21,12.22z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M18,11.03C17.52,8.18,15.04,6,12.05,6c-3.03,0-6.29,2.51-6.03,6.45c2.47-1.01,4.33-3.21,4.86-5.89 C12.19,9.19,14.88,11,18,11.03z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bluetooth-audio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.98 10.28l-1.38 1.38c-.2.2-.2.51 0 .71l1.38 1.38c.28.28.75.15.85-.23.11-.5.17-1 .17-1.52 0-.51-.06-1.01-.18-1.48-.09-.38-.56-.52-.84-.24zm4.12-2.5c-.25-.55-.98-.67-1.4-.24-.26.26-.31.64-.17.98.46 1.07.72 2.24.72 3.47 0 1.24-.26 2.42-.73 3.49-.14.32-.09.69.16.94.41.41 1.1.29 1.35-.23.63-1.3.98-2.76.98-4.3-.01-1.45-.33-2.85-.91-4.11zM11.39 12l3.59-3.58c.39-.39.39-1.02 0-1.42l-4.29-4.29c-.63-.63-1.71-.18-1.71.71V9.6L5.09 5.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L8.57 12l-4.89 4.89c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0l3.89-3.89v6.18c0 .89 1.08 1.34 1.71.71l4.3-4.3c.39-.39.39-1.02 0-1.42L11.39 12zm-.41-6.17l1.88 1.88-1.88 1.88V5.83zm0 12.34v-3.76l1.88 1.88-1.88 1.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 confirmation-number
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 8.54V6c0-1.1-.9-2-2-2H4c-1.1 0-1.99.89-1.99 2v2.54c0 .69.33 1.37.94 1.69C3.58 10.58 4 11.24 4 12s-.43 1.43-1.06 1.76c-.6.33-.94 1.01-.94 1.7V18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-2.54c0-.69-.34-1.37-.94-1.7-.63-.34-1.06-1-1.06-1.76s.43-1.42 1.06-1.76c.6-.33.94-1.01.94-1.7zm-9 8.96h-2v-2h2v2zm0-4.5h-2v-2h2v2zm0-4.5h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-disabled
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M0 0h24v24H0V0zm0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 5.74v-.19c0-.68-.71-1.11-1.32-.82-.19.09-.36.2-.54.3L9.6 6.49c.24-.18.4-.45.4-.75zM20 12c0-2.21-.91-4.2-2.36-5.64l1.51-1.51c.31-.31.09-.85-.36-.85H14v4.79c0 .45.54.67.85.35l1.39-1.39C17.32 8.85 18 10.34 18 12c0 .85-.18 1.66-.5 2.39l1.48 1.48C19.62 14.72 20 13.41 20 12zM3.57 4.7c-.39.39-.39 1.02 0 1.41l1.65 1.65C4.45 9 4 10.44 4 12c0 2.21.91 4.2 2.36 5.64l-1.51 1.51c-.31.31-.09.85.36.85H9.5c.28 0 .5-.22.5-.5v-4.29c0-.45-.54-.67-.85-.35l-1.39 1.39C6.68 15.15 6 13.66 6 12c0-1 .26-1.93.69-2.76l8.07 8.07c-.01.02-.01.02-.01.04-.43.12-.75.48-.75.91v.18c0 .68.71 1.11 1.32.82.31-.14.61-.31.9-.49l1.87 1.87c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L4.98 4.7c-.39-.39-1.02-.39-1.41 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sync-lock
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,19c0,0.55-0.45,1-1,1H5c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h1.73C5.06,16.54,4,14.4,4,12 c0-3.19,1.87-5.93,4.56-7.22C9.23,4.47,10,4.96,10,5.7c0,0.38-0.22,0.72-0.57,0.88C7.41,7.55,6,9.61,6,12c0,1.77,0.78,3.34,2,4.44 V15c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1V19z M15,4c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V7.56 c1.22,1.1,2,2.67,2,4.44h2c0-2.4-1.06-4.54-2.73-6H19c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H15z M20,17v-1c0-1.1-0.9-2-2-2 s-2,0.9-2,2v1c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-3C21,17.45,20.55,17,20,17z M19,17h-2v-1 c0-0.55,0.45-1,1-1s1,0.45,1,1V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 drive-eta
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.92 5.01C18.72 4.42 18.16 4 17.5 4h-11c-.66 0-1.21.42-1.42 1.01l-1.97 5.67c-.07.21-.11.43-.11.66v7.16c0 .83.67 1.5 1.5 1.5S6 19.33 6 18.5V18h12v.5c0 .82.67 1.5 1.5 1.5.82 0 1.5-.67 1.5-1.5v-7.16c0-.22-.04-.45-.11-.66l-1.97-5.67zM6.5 15c-.83 0-1.5-.67-1.5-1.5S5.67 12 6.5 12s1.5.67 1.5 1.5S7.33 15 6.5 15zm11 0c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zM5 10l1.27-3.82c.14-.4.52-.68.95-.68h9.56c.43 0 .81.28.95.68L19 10H5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 priority-high
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "2", :cy "19", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2s2-.9 2-2V5c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 error-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 7c.55 0 1 .45 1 1v4c0 .55-.45 1-1 1s-1-.45-1-1V8c0-.55.45-1 1-1zm-.01-5C6.47 2 2 6.48 2 12s4.47 10 9.99 10C17.52 22 22 17.52 22 12S17.52 2 11.99 2zM12 20c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm1-3h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-alert
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d "M12,22c1.1,0,2-0.9,2-2h-4C10,21.1,10.9,22,12,22z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,17h-1v-7c0-2.79-1.91-5.14-4.5-5.8V3.5C13.5,2.67,12.83,2,12,2s-1.5,0.67-1.5,1.5v0.7C7.91,4.86,6,7.21,6,10v7H5 c-0.55,0-1,0.45-1,1s0.45,1,1,1h14c0.55,0,1-0.45,1-1S19.55,17,19,17z M14,13h-1v1c0,0.55-0.45,1-1,1s-1-0.45-1-1v-1h-1 c-0.55,0-1-0.45-1-1s0.45-1,1-1h1v-1c0-0.55,0.45-1,1-1s1,0.45,1,1v1h1c0.55,0,1,0.45,1,1S14.55,13,14,13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 notification-important
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 23c1.1 0 1.99-.89 1.99-1.99h-3.98c0 1.1.89 1.99 1.99 1.99zm8.29-4.71L19 17v-6c0-3.35-2.36-6.15-5.5-6.83V3c0-.83-.67-1.5-1.5-1.5s-1.5.67-1.5 1.5v1.17C7.36 4.85 5 7.65 5 11v6l-1.29 1.29c-.63.63-.19 1.71.7 1.71h15.17c.9 0 1.34-1.08.71-1.71zM13 16h-2v-2h2v2zm0-5c0 .55-.45 1-1 1s-1-.45-1-1V9c0-.55.45-1 1-1s1 .45 1 1v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warning-amber
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 5.99L19.53 19H4.47L12 5.99M2.74 18c-.77 1.33.19 3 1.73 3h15.06c1.54 0 2.5-1.67 1.73-3L13.73 4.99c-.77-1.33-2.69-1.33-3.46 0L2.74 18zM11 11v2c0 .55.45 1 1 1s1-.45 1-1v-2c0-.55-.45-1-1-1s-1 .45-1 1zm0 5h2v2h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 warning
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M4.47 21h15.06c1.54 0 2.5-1.67 1.73-3L13.73 4.99c-.77-1.33-2.69-1.33-3.46 0L2.74 18c-.77 1.33.19 3 1.73 3zM12 14c-.55 0-1-.45-1-1v-2c0-.55.45-1 1-1s1 .45 1 1v2c0 .55-.45 1-1 1zm1 4h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-delete
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16,9c-0.7,0-1.37,0.1-2,0.29V7c0-1.1-0.9-2-2-2H4C2.9,5,2,5.9,2,7v10c0,1.1,0.9,2,2,2h5.68c1.12,2.36,3.53,4,6.32,4 c3.87,0,7-3.13,7-7C23,12.13,19.87,9,16,9z M16,21c-2.76,0-5-2.24-5-5s2.24-5,5-5s5,2.24,5,5S18.76,21,16,21z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14,4c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1h-2.5l-0.71-0.71C10.61,1.11,10.35,1,10.09,1H5.91C5.65,1,5.39,1.11,5.21,1.29 L4.5,2H2C1.45,2,1,2.45,1,3c0,0.55,0.45,1,1,1H14z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.75,12L15.75,12C15.34,12,15,12.34,15,12.75v3.68c0,0.36,0.19,0.68,0.5,0.86l2.52,1.47c0.33,0.19,0.75,0.09,0.96-0.22 v0c0.23-0.34,0.12-0.81-0.24-1.02L16.5,16.2v-3.45C16.5,12.34,16.16,12,15.75,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 error
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 11c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1s1 .45 1 1v4c0 .55-.45 1-1 1zm1 4h-2v-2h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 child-care
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.25", :cy "10.5", :cx "14.5", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1.25", :cy "10.5", :cx "9.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M16.1 14H7.9c-.19 0-.32.2-.23.37C8.5 15.94 10.13 17 12 17s3.5-1.06 4.33-2.63c.08-.17-.05-.37-.23-.37zm6.84-2.66c-.25-1.51-1.36-2.74-2.81-3.17-.53-1.12-1.28-2.1-2.19-2.91C16.36 3.85 14.28 3 12 3s-4.36.85-5.94 2.26c-.92.81-1.67 1.8-2.19 2.91-1.45.43-2.56 1.65-2.81 3.17-.04.21-.06.43-.06.66 0 .23.02.45.06.66.25 1.51 1.36 2.74 2.81 3.17.52 1.11 1.27 2.09 2.17 2.89C7.62 20.14 9.71 21 12 21s4.38-.86 5.97-2.28c.9-.8 1.65-1.79 2.17-2.89 1.44-.43 2.55-1.65 2.8-3.17.04-.21.06-.43.06-.66 0-.23-.02-.45-.06-.66zM19 14c-.1 0-.19-.02-.29-.03-.2.67-.49 1.29-.86 1.86C16.6 17.74 14.45 19 12 19s-4.6-1.26-5.85-3.17c-.37-.57-.66-1.19-.86-1.86-.1.01-.19.03-.29.03-1.1 0-2-.9-2-2s.9-2 2-2c.1 0 .19.02.29.03.2-.67.49-1.29.86-1.86C7.4 6.26 9.55 5 12 5s4.6 1.26 5.85 3.17c.37.57.66 1.19.86 1.86.1-.01.19-.03.29-.03 1.1 0 2 .9 2 2s-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 microwave
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.15,9.97L6.15,9.97C5.69,9.51,5.77,8.73,6.33,8.4C6.73,8.18,7.21,8,7.75,8c0.8,0,1.39,0.39,1.81,0.67 C9.87,8.88,10.07,9,10.25,9c0.13,0,0.26-0.05,0.39-0.12c0.39-0.22,0.88-0.16,1.2,0.16l0,0c0.46,0.46,0.38,1.24-0.18,1.56 c-0.39,0.23-0.87,0.4-1.41,0.4c-0.79,0-1.37-0.38-1.79-0.66C8.13,10.12,7.94,10,7.75,10c-0.13,0-0.26,0.05-0.39,0.12 C6.96,10.35,6.47,10.28,6.15,9.97z M7.75,15c0.19,0,0.38,0.12,0.71,0.34c0.42,0.28,1,0.66,1.79,0.66c0.54,0,1.02-0.17,1.41-0.4 c0.56-0.32,0.64-1.1,0.18-1.56l0,0c-0.32-0.32-0.81-0.38-1.2-0.16C10.51,13.95,10.38,14,10.25,14c-0.18,0-0.38-0.12-0.69-0.33 C9.14,13.39,8.55,13,7.75,13c-0.54,0-1.02,0.18-1.42,0.4c-0.56,0.33-0.64,1.11-0.18,1.56l0,0c0.32,0.32,0.81,0.38,1.2,0.16 C7.49,15.05,7.62,15,7.75,15z M22,6v12c0,1.1-0.9,2-2,2H4c-1.1,0-2-0.9-2-2V6c0-1.1,0.9-2,2-2h16C21.1,4,22,4.9,22,6z M14,6H4v12h10 V6z M19,16c0-0.55-0.45-1-1-1c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1C18.55,17,19,16.55,19,16z M19,12c0-0.55-0.45-1-1-1 c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1C18.55,13,19,12.55,19,12z M19,7h-2v2h2V7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 meeting-room
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M20,19h-1V5c0-0.55-0.45-1-1-1h-4c0-0.55-0.45-1-1-1H6C5.45,3,5,3.45,5,4v15H4c-0.55,0-1,0.45-1,1s0.45,1,1,1h9 c0.55,0,1-0.45,1-1V6h3v14c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1S20.55,19,20,19z M11,13L11,13c-0.55,0-1-0.45-1-1v0 c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C12,12.55,11.55,13,11,13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 cottage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22.39,12.19c0.34-0.44,0.25-1.07-0.19-1.4l-9.6-7.33c-0.36-0.27-0.86-0.27-1.21,0L6,7.58V7c0-0.55-0.45-1-1-1S4,6.45,4,7 v2.11l-2.21,1.68c-0.44,0.33-0.52,0.96-0.19,1.4c0.34,0.44,0.96,0.52,1.4,0.19L4,11.62V20c0,0.55,0.45,1,1,1h6v-5c0-0.55,0.45-1,1-1 s1,0.45,1,1v5h6c0.55,0,1-0.45,1-1v-8.38l0.99,0.76C21.43,12.72,22.06,12.63,22.39,12.19z M5.27,5c-0.74,0-1.26-0.8-0.9-1.45 C4.89,2.62,5.87,2,7,2c0.38,0,0.72-0.22,0.89-0.53C8.04,1.16,8.39,1,8.73,1c0.74,0,1.26,0.8,0.9,1.45C9.11,3.38,8.13,4,7,4 C6.62,4,6.28,4.22,6.11,4.53C5.96,4.84,5.61,5,5.27,5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 beach-access
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.13 14.56l1.43-1.43 5.73 5.73c.39.39.39 1.03 0 1.43-.39.39-1.03.39-1.43 0l-5.73-5.73zm4.29-5.73l1.27-1.27c.89-.89.77-2.43-.31-3.08-3.89-2.38-9.03-1.89-12.4 1.47 3.93-1.3 8.31-.25 11.44 2.88zM5.95 5.98c-3.36 3.37-3.85 8.51-1.48 12.4.66 1.08 2.19 1.21 3.08.31l1.27-1.27C5.7 14.29 4.65 9.91 5.95 5.98zm.02-.02l-.01.01c-.38 3.01 1.17 6.88 4.3 10.02l5.73-5.73c-3.13-3.13-7.01-4.68-10.02-4.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dry
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M1.94,11.79C1.34,12.36,1,13.14,1,13.97V20c0,1.66,1.34,3,3,3l13.68,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5l7.18,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5l0,0c0-0.28,0.22-0.5,0.5-0.5l8.18,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5l6.18,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H8.86l1.49-2.61c0.09-0.16,0.14-0.33,0.14-0.53c0-0.26-0.09-0.5-0.26-0.7L9.81,5.71 C9.43,5.32,8.8,5.3,8.4,5.68L1.94,11.79z M16.99,8.07c0,0.52-0.42,0.93-0.93,0.93c-0.52,0-0.93-0.42-0.93-0.93l0,0 c0.03-0.67-0.22-1.33-0.71-1.86l-0.07-0.06c-0.9-0.89-1.38-2.03-1.34-3.22l0,0C13,2.42,13.42,2,13.93,2c0.51,0,0.93,0.42,0.93,0.93 l0,0c-0.03,0.67,0.22,1.33,0.71,1.86l0.07,0.07C16.55,5.74,17.03,6.88,16.99,8.07L16.99,8.07z M21,8.07C21,8.58,20.58,9,20.06,9 s-0.93-0.42-0.93-0.93l0,0c0.03-0.67-0.22-1.33-0.71-1.86l-0.07-0.06c-0.9-0.89-1.38-2.03-1.34-3.22l0,0 c0-0.51,0.42-0.93,0.93-0.93s0.93,0.42,0.93,0.93l0,0c-0.03,0.67,0.22,1.33,0.71,1.86l0.07,0.07C20.55,5.74,21.03,6.88,21,8.07 L21,8.07z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 water-damage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11.33,3.6l-8.36,7.53C2.63,11.43,2.84,12,3.3,12H5v7c0,0.55,0.45,1,1,1h12c0.55,0,1-0.45,1-1v-7h1.7 c0.46,0,0.68-0.57,0.33-0.87L12.67,3.6C12.29,3.26,11.71,3.26,11.33,3.6z M12,16c-1.1,0-2-0.9-2-2c0-0.78,0.99-2.44,1.58-3.36 c0.2-0.31,0.64-0.31,0.84,0C13.01,11.56,14,13.22,14,14C14,15.1,13.1,16,12,16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fire-extinguisher
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M7,19h10v1c0,1.1-0.9,2-2,2H9c-1.1,0-2-0.9-2-2V19z M7,18h10v-5H7V18z M17,4.23v3.54c0,0.63-0.58,1.11-1.21,0.98 l-1.94-0.41c0,0.02,0,0.01-0.01,0.03c1.54,0.62,2.71,1.98,3.06,3.63H7.1c0.34-1.66,1.52-3.02,3.07-3.64 c-0.33-0.26-0.6-0.58-0.8-0.95L5.49,6.6C5.2,6.54,5,6.29,5,6v0c0-0.29,0.2-0.54,0.49-0.6l3.88-0.81C9.87,3.65,10.86,3,12,3 c0.7,0,1.34,0.25,1.85,0.66l1.94-0.41C16.42,3.12,17,3.6,17,4.23z M13,6c-0.03-0.59-0.45-1-1-1s-1,0.45-1,1s0.45,1,1,1 S13,6.55,13,6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 vape-free
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20.49,21.9c-0.39,0.39-1.02,0.39-1.41,0l-2.9-2.9H8v-3h5.17L2.1,4.93c-0.39-0.39-0.39-1.02,0-1.41s1.02-0.39,1.41,0 l16.97,16.97C20.88,20.88,20.88,21.51,20.49,21.9z M18.83,16h1.67c0.83,0,1.5,0.67,1.5,1.5c0,0.46-0.21,0.87-0.53,1.14L18.83,16z M10.5,17c-0.28,0-0.5,0.22-0.5,0.5s0.22,0.5,0.5,0.5s0.5-0.22,0.5-0.5S10.78,17,10.5,17z M18.85,7.73c0.62-0.61,1-1.45,1-2.38 c0-1.51-1-2.79-2.38-3.21C16.99,2,16.5,2.36,16.5,2.86c0,0.33,0.21,0.62,0.52,0.71c0.77,0.23,1.33,0.94,1.33,1.78 c0,0.82-0.53,1.51-1.27,1.76C16.75,7.22,16.5,7.5,16.5,7.85V8c0,0.37,0.27,0.69,0.64,0.75c1.93,0.31,3.36,2,3.36,4.02v1.48 c0,0.41,0.34,0.75,0.75,0.75S22,14.66,22,14.25v-1.49C22,10.54,20.72,8.62,18.85,7.73z M14.48,11.65c0.04,0,0.09,0,0.13,0h1.42 c1.05,0,1.97,0.74,1.97,2.05v0.55c0,0.41,0.34,0.75,0.76,0.75c0.41,0,0.75-0.33,0.75-0.75v-0.89c-0.01-1.81-1.61-3.16-3.48-3.16 h-1.3c-1.02,0-1.94-0.73-2.07-1.75c-0.12-0.95,0.46-1.7,1.3-1.93c0.32-0.09,0.54-0.38,0.54-0.72c0-0.49-0.46-0.86-0.93-0.72 c-1.41,0.41-2.43,1.71-2.42,3.24L14.48,11.65z M3,18.5c1.33,0,2.71,0.18,4,0.5v-3c-1.29,0.32-2.67,0.5-4,0.5c-0.55,0-1,0.45-1,1 S2.45,18.5,3,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 rv-hookup
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 17h-1v-6c0-1.1-.9-2-2-2H7v-.74c0-.46-.56-.7-.89-.37L4.37 9.63c-.2.2-.2.53 0 .74l1.74 1.74c.33.33.89.1.89-.37V11h4v3H5c-.55 0-1 .45-1 1v2c0 1.1.9 2 2 2h2c0 1.66 1.34 3 3 3s3-1.34 3-3h7c.55 0 1-.45 1-1s-.45-1-1-1zm-10 3c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm7-6h-4v-3h3c.55 0 1 .45 1 1v2zm-8-8h7v.74c0 .46.56.7.89.37l1.74-1.74c.2-.2.2-.53 0-.74l-1.74-1.74c-.33-.33-.89-.1-.89.37V4h-7c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 balcony
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20,14.27V10c0-4.42-3.58-8-8-8s-8,3.58-8,8v4.27C3.4,14.61,3,15.26,3,16v4c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-4 C21,15.26,20.6,14.61,20,14.27z M7,20H5v-4h2V20z M11,20H9v-4h2V20z M11,14H6v-4c0-2.97,2.16-5.44,5-5.92V14z M13,4.08 c2.84,0.48,5,2.94,5,5.92v4h-5V4.08z M15,20h-2v-4h2V20z M19,20h-2v-4h2V20z M8,11c0-0.55,0.45-1,1-1s1,0.45,1,1s-0.45,1-1,1 S8,11.55,8,11z M16,11c0,0.55-0.45,1-1,1s-1-0.45-1-1s0.45-1,1-1S16,10.45,16,11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tty
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M15,4L15,4c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v0C14,4.45,14.45,4,15,4z M14,7L14,7 c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v0C13,7.45,13.45,7,14,7z M12,4L12,4c0.55,0,1,0.45,1,1v0 c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v0C11,4.45,11.45,4,12,4z M17,9L17,9c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0 c0.55,0,1,0.45,1,1v0C18,8.55,17.55,9,17,9z M18,6L18,6c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0 C19,5.55,18.55,6,18,6z M20,9L20,9c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C21,8.55,20.55,9,20,9z M21,6 L21,6c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C22,5.55,21.55,6,21,6z M14.62,14.38L12.1,16.9 c-2.5-1.43-4.57-3.5-6-6l2.52-2.52C8.86,8.14,8.96,7.8,8.9,7.48L8.16,3.8C8.07,3.34,7.66,3,7.18,3H3.03C2.47,3,2,3.47,2.03,4.03 C2.2,6.92,3.05,9.63,4.43,12c1.58,2.73,3.85,4.99,6.57,6.57c2.37,1.37,5.08,2.23,7.97,2.4c0.56,0.03,1.03-0.44,1.03-1v-4.15 c0-0.48-0.34-0.89-0.8-0.98l-3.67-0.73C15.2,14.04,14.86,14.14,14.62,14.38z M15,10L15,10c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1h0 c-0.55,0-1-0.45-1-1v0C14,10.45,14.45,10,15,10z M12,10L12,10c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v0 C11,10.45,11.45,10,12,10z M18,12L18,12c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C19,11.55,18.55,12,18,12z M21,12L21,12c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v0C22,11.55,21.55,12,21,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 room-service
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 17h18c.55 0 1 .45 1 1s-.45 1-1 1H3c-.55 0-1-.45-1-1s.45-1 1-1zm10.84-9.21c.1-.24.16-.51.16-.79 0-1.1-.9-2-2-2s-2 .9-2 2c0 .28.06.55.16.79C6.25 8.6 3.27 11.93 3 16h18c-.27-4.07-3.25-7.4-7.16-8.21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-touch
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M13,10.17l-2.5-2.5V2.25C10.5,1.56,11.06,1,11.75,1C12.44,1,13,1.56,13,2.25V10.17z M20,5.32c0-0.65-0.47-1.25-1.12-1.32 c-0.75-0.08-1.38,0.51-1.38,1.24v5.25c0,0.28-0.22,0.5-0.5,0.5h0c-0.28,0-0.5-0.22-0.5-0.5l0-7.18c0-0.65-0.47-1.25-1.12-1.32 C14.63,1.93,14,2.52,14,3.25v7.92l6,6L20,5.32z M9.5,4.25C9.5,3.56,8.94,3,8.25,3c-0.67,0-1.2,0.53-1.24,1.18L9.5,6.67V4.25z M17,22c0.62,0,1.18-0.19,1.65-0.52l-0.02-0.02l0.44,0.44c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51 c-0.39-0.39-1.02-0.39-1.41,0l0,0c-0.39,0.39-0.39,1.02,0,1.41l4.92,4.92L7,9.83v4.3l-2.6-1.48c-0.17-0.09-0.34-0.14-0.54-0.14 c-0.26,0-0.5,0.09-0.7,0.26L2,13.88l0,0l6.8,7.18c0.57,0.6,1.35,0.94,2.18,0.94L17,22L17,22z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 storefront
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:width "24", :height "24", :fill "none", :stroke nil})
    (helix.dom/rect
     {:width "24", :height "24", :fill "none", :stroke nil})))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21.9,7.89l-1.05-3.37c-0.22-0.9-1-1.52-1.91-1.52H5.05c-0.9,0-1.69,0.63-1.9,1.52L2.1,7.89C1.64,9.86,2.95,11,3,11.06V19 c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-7.94C22.12,9.94,22.09,8.65,21.9,7.89z M13,5h1.96l0.54,3.52C15.59,9.23,15.11,10,14.22,10 C13.55,10,13,9.41,13,8.69V5z M6.44,8.86C6.36,9.51,5.84,10,5.23,10C4.3,10,3.88,9.03,4.04,8.36L5.05,5h1.97L6.44,8.86z M11,8.69 C11,9.41,10.45,10,9.71,10c-0.75,0-1.3-0.7-1.22-1.48L9.04,5H11V8.69z M18.77,10c-0.61,0-1.14-0.49-1.21-1.14L16.98,5l1.93-0.01 l1.05,3.37C20.12,9.03,19.71,10,18.77,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 escalator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2l0-14C21,3.9,20.1,3,19,3z M17,9h-1.7l-4.71,8.49 C10.41,17.8,10.07,18,9.71,18H7c-0.83,0-1.5-0.67-1.5-1.5S6.17,15,7,15h1.7l4.71-8.49C13.59,6.2,13.93,6,14.29,6H17 c0.83,0,1.5,0.67,1.5,1.5S17.83,9,17,9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 smoking-rooms
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.5 16h-12c-.83 0-1.5.67-1.5 1.5S2.67 19 3.5 19h12c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5zm3.35-8.27c.62-.61 1-1.45 1-2.38 0-1.51-1-2.79-2.38-3.21-.48-.14-.97.22-.97.72 0 .33.21.62.52.71.77.23 1.33.94 1.33 1.78 0 .82-.53 1.51-1.27 1.76-.33.11-.58.39-.58.74V8c0 .37.27.69.64.75 1.93.31 3.36 2 3.36 4.02v1.48c0 .41.34.75.75.75s.75-.34.75-.75v-1.49c0-2.22-1.28-4.14-3.15-5.03zm-2.82 2.47h-1.3c-1.02 0-1.94-.73-2.07-1.75-.12-.95.46-1.7 1.3-1.93.32-.09.54-.38.54-.72 0-.49-.46-.86-.93-.72-1.42.41-2.45 1.73-2.42 3.28.03 1.84 1.62 3.29 3.46 3.29h1.42c1.05 0 1.97.74 1.97 2.05v.55c0 .41.33.75.75.75h.01c.41 0 .75-.33.75-.75v-.89c-.01-1.81-1.61-3.16-3.48-3.16zM18 16h1.5v3H18zm2.5 0H22v3h-1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 countertops
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,10l0-2.83c0-1.62-1.22-3.08-2.84-3.17c-1.21-0.06-2.27,0.59-2.8,1.57C12.01,6.22,12.53,7,13.27,7h0.01 c0.34,0,0.68-0.16,0.84-0.46C14.28,6.22,14.62,6,15,6c0.55,0,1,0.45,1,1v3H8c1.1,0,2-0.9,2-2V5c0-0.55-0.45-1-1-1H5 C4.45,4,4,4.45,4,5v3c0,1.1,0.9,2,2,2H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1v7c0,0.55,0.45,1,1,1h14c0.55,0,1-0.45,1-1v-7h1 c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H18z M13,18h-2v-6h2V18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 desk
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,7v10c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V8h10v9c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-1h4v1c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1V7c0-0.55-0.45-1-1-1H3C2.45,6,2,6.45,2,7z M20,8v2h-4V8H20z M16,14v-2h4v2H16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 stroller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M18,20c0,1.1-0.9,2-2,2s-2-0.9-2-2s0.9-2,2-2S18,18.9,18,20z M6,18c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S7.1,18,6,18z M14.3,4.1C13.03,3.4,11.56,3,10,3C8.49,3,7.07,3.38,5.83,4.03C5.24,4.34,5.15,5.15,5.61,5.61l3.99,3.99L14.3,4.1z M21.94,5.83 C21.65,4.22,20.3,3,18.65,3c-1.66,0-2.54,1.27-3.18,2.03L6.71,15.31c-0.55,0.65-0.09,1.65,0.76,1.65H15c1.1,0,2-0.9,2-2V6.27 C17.58,5.59,17.97,5,18.65,5c0.68,0,1.22,0.52,1.33,1.21l0,0C20.08,6.66,20.48,7,20.96,7c0.55,0,1-0.45,1-1 C21.96,5.94,21.95,5.89,21.94,5.83L21.94,5.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,9h-1.56c0.33-0.55,0.53-1.18,0.55-1.86c0.04-1.03-0.43-1.99-1.16-2.71c-1.54-1.54-2.74-1.56-3.82-1.29 C12.2,2.45,11.16,2.02,10,2.02c-1.89,0-3.51,1.11-4.27,2.71C4.15,5.26,3,6.74,3,8.5c0,1.86,1.28,3.41,3,3.86L6,19c0,1.1,0.9,2,2,2h7 c1.1,0,2-0.9,2-2v0h2c1.1,0,2-0.9,2-2v-6C21,9.9,20.1,9,19,9z M7,10.5c-1.1,0-2-0.9-2-2c0-0.85,0.55-1.6,1.37-1.88l0.8-0.27 l0.36-0.76C8,4.62,8.94,4.02,10,4.02c0.79,0,1.39,0.35,1.74,0.65l0.78,0.65c0,0,0.64-0.32,1.47-0.32c1.1,0,2,0.9,2,2c0,0-3,0-3,0 C9.67,7,9.15,10.5,7,10.5z M19,17h-2v-6h2V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 all-inclusive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.22 6.86c-2-.6-4.06-.04-5.39 1.29L12 10.66 10.48 12h.01L7.8 14.39c-.81.81-1.95 1.15-3.12.92-1.25-.25-2.28-1.25-2.57-2.49-.52-2.23 1.16-4.2 3.29-4.2.91 0 1.76.35 2.44 1.03l.47.41c.38.34.95.34 1.33 0 .45-.4.45-1.1 0-1.5l-.42-.36C8.2 7.18 6.84 6.62 5.4 6.62 2.42 6.62 0 9.04 0 12s2.42 5.38 5.4 5.38c1.44 0 2.8-.56 3.77-1.53l2.83-2.5.01.01L13.52 12h-.01l2.69-2.39c.81-.81 1.95-1.15 3.12-.92 1.25.25 2.28 1.25 2.57 2.49.52 2.23-1.16 4.2-3.29 4.2-.9 0-1.76-.35-2.44-1.03l-.48-.42c-.38-.34-.95-.34-1.33 0-.45.4-.45 1.1 0 1.5l.42.37c1.02 1.01 2.37 1.57 3.82 1.57 3.27 0 5.86-2.9 5.33-6.25-.3-1.99-1.77-3.69-3.7-4.26z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 business-center
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 16h-2c-.55 0-1-.45-1-1H3.01v4c0 1.1.9 2 2 2H19c1.1 0 2-.9 2-2v-4h-7c0 .55-.45 1-1 1zm7-9h-4c0-2.21-1.79-4-4-4S8 4.79 8 7H4c-1.1 0-2 .9-2 2v3c0 1.11.89 2 2 2h6v-1c0-.55.45-1 1-1h2c.55 0 1 .45 1 1v1h6c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2zM10 7c0-1.1.9-2 2-2s2 .9 2 2H9.99 10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 house-siding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,12h1.7c0.46,0,0.68-0.57,0.33-0.87L12.67,3.6c-0.38-0.34-0.96-0.34-1.34,0l-8.36,7.53C2.63,11.43,2.84,12,3.3,12H5v7 c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-1h10v1c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V12z M7.21,10h9.58L17,10.19V12H7v-1.81 L7.21,10z M14.57,8H9.43L12,5.69L14.57,8z M7,16v-2h10v2H7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 carpenter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19.73,14.23L7.71,2.21c-0.39-0.39-1.02-0.39-1.41,0L3.7,4.8C3.36,5.14,3.31,5.68,3.59,6.08l7.65,10.98 c-0.78,0.78-0.78,2.05,0,2.83l1.41,1.41c0.78,0.78,2.05,0.78,2.83,0l4.24-4.24C20.51,16.28,20.51,15.01,19.73,14.23z M14.07,19.88 l-1.41-1.41l4.24-4.24l1.41,1.41L14.07,19.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 free-breakfast
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 3H6c-1.1 0-2 .9-2 2v8c0 2.21 1.79 4 4 4h6c2.21 0 4-1.79 4-4v-3h2c1.11 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 5h-2V5h2v3zM5 19h14c.55 0 1 .45 1 1s-.45 1-1 1H5c-.55 0-1-.45-1-1s.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gite
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M21.41,9.41l-2.83-2.83C18.21,6.21,17.7,6,17.17,6H9V5c0-0.55-0.45-1-1-1S7,4.45,7,5v1H6.83C6.3,6,5.79,6.21,5.41,6.59 L2.59,9.41C2.21,9.79,2,10.3,2,10.83V17c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-6.17C22,10.3,21.79,9.79,21.41,9.41z M14,17H4v-5h10 V17z M20,17h-4v-6.17l2-2l2,2V17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 escalator-warning
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M6.5,2c1.1,0,2,0.9,2,2s-0.9,2-2,2s-2-0.9-2-2S5.4,2,6.5,2z M15.5,9.5c0,0.83,0.67,1.5,1.5,1.5s1.5-0.67,1.5-1.5 S17.83,8,17,8S15.5,8.67,15.5,9.5z M18.5,12h-2.84c-0.58,0.01-1.14,0.32-1.45,0.86l-0.92,1.32L9.72,8C9.35,7.37,8.69,7.01,8.01,7H5 C3.9,7,3,7.9,3,9v5c0,0.55,0.45,1,1,1h0.5v6c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v-9.39l2.24,3.89c0.18,0.31,0.51,0.5,0.87,0.5 h1.1c0.33,0,0.63-0.16,0.82-0.43L15,14.9V21c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1v-4h0c0.55,0,1-0.45,1-1v-2.5 C20,12.68,19.33,12,18.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 grass
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15.64,11.02c0.55-1.47,1.43-2.78,2.56-3.83c0.38-0.36,0.04-1-0.46-0.85c-3.32,0.98-5.75,4.05-5.74,7.69c0,0,0,0,0,0 C12.95,12.75,14.2,11.72,15.64,11.02z M11.42,8.85c-0.6-1.56-1.63-2.91-2.96-3.87C8.04,4.68,7.5,5.17,7.74,5.63 C8.54,7.15,9,8.88,9,10.71c0,0.21-0.03,0.41-0.04,0.61c0.43,0.24,0.83,0.52,1.22,0.82C10.39,10.96,10.83,9.85,11.42,8.85z M12,20H3 c-0.55,0-1-0.45-1-1s0.45-1,1-1h4.75c-0.57-2.19-2.04-4.02-4-5.06l0,0c-0.16-0.08-0.26-0.25-0.26-0.44c0-0.27,0.22-0.49,0.49-0.5 c0.01,0,0.02,0,0.02,0C8.42,12,12,15.58,12,20z M20.26,12.94L20.26,12.94c-1.96,1.04-3.44,2.87-4,5.06H21c0.55,0,1,0.45,1,1 s-0.45,1-1,1h-5h-2c0-0.68-0.07-1.35-0.2-2c-0.15-0.72-0.38-1.42-0.67-2.07C14.52,13.58,17.07,12,20,12c0.01,0,0.02,0,0.02,0 c0.27,0,0.49,0.23,0.49,0.5C20.52,12.69,20.41,12.85,20.26,12.94z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 golf-course
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.5", :cy "19.5", :cx "19.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M11 18.03V8.98l4.22-2.15c.73-.37.73-1.43-.01-1.79l-4.76-2.33C9.78 2.38 9 2.86 9 3.6V19c0 .55-.45 1-1 1s-1-.45-1-1v-.73c-1.79.35-3 .99-3 1.73 0 1.1 2.69 2 6 2s6-.9 6-2c0-.99-2.16-1.81-5-1.97z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 casino
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM7.5 18c-.83 0-1.5-.67-1.5-1.5S6.67 15 7.5 15s1.5.67 1.5 1.5S8.33 18 7.5 18zm0-9C6.67 9 6 8.33 6 7.5S6.67 6 7.5 6 9 6.67 9 7.5 8.33 9 7.5 9zm4.5 4.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm4.5 4.5c-.83 0-1.5-.67-1.5-1.5s.67-1.5 1.5-1.5 1.5.67 1.5 1.5-.67 1.5-1.5 1.5zm0-9c-.83 0-1.5-.67-1.5-1.5S15.67 6 16.5 6s1.5.67 1.5 1.5S17.33 9 16.5 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tapas
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,10V2c0-0.55-0.45-1-1-1h-6c-0.55,0-1,0.45-1,1v8c0,1.86,1.28,3.41,3,3.86V21h-1c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1 h4c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1v-7.14C20.72,13.41,22,11.86,22,10z M20,3v3h-4V3H20z M9.86,9L8,9V8l1.86,0 c1.31,0,2.5-0.94,2.63-2.24C12.64,4.26,11.47,3,10,3H8V2c0-0.55-0.45-1-1-1h0C6.45,1,6,1.45,6,2v1L4.14,3 c-1.31,0-2.5,0.94-2.63,2.24C1.36,6.74,2.53,8,4,8h2v1L4.14,9c-1.31,0-2.5,0.94-2.63,2.24C1.36,12.74,2.53,14,4,14h2v8 c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-8h2c1.47,0,2.64-1.26,2.49-2.76C12.36,9.94,11.17,9,9.86,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 charging-station
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17,1H7C5.9,1,5,1.9,5,3v18c0,1.1,0.9,2,2,2h10c1.1,0,2-0.9,2-2V3C19,1.9,18.1,1,17,1z M17,18H7V6h10V18z M12.5,11V9.12 c0-0.53-0.71-0.7-0.95-0.22l-1.69,3.38C9.7,12.61,9.94,13,10.31,13h1.19v1.88c0,0.53,0.71,0.7,0.95,0.22l1.69-3.38 C14.3,11.39,14.06,11,13.69,11H12.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 smoke-free
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.5 13H22v3h-1.5zM18 13h1.5v3H18zm-1 1.5c0-.83-.67-1.5-1.5-1.5h-.84l2.18 2.18c.1-.21.16-.44.16-.68zm1.96-12.15H19h-.04zm-.11 2.38c.38-.38.67-.84.84-1.35.16-.5-.19-1.01-.71-1.02-.34.01-.61.25-.72.58-.18.55-.62.99-1.17 1.17-.34.11-.59.39-.59.74V5c0 .37.27.69.64.75 1.93.31 3.36 2 3.36 4.02v1.48c0 .41.34.75.75.75s.75-.34.75-.75V9.76c0-2.22-1.28-4.14-3.15-5.03zm-4.24 3.92h1.42c1.05 0 1.97.74 1.97 2.05v.55c0 .41.33.75.75.75h.01c.41 0 .75-.33.75-.75v-.89c0-1.81-1.6-3.16-3.47-3.16h-1.3c-1.02 0-1.94-.73-2.07-1.75-.12-.95.46-1.7 1.3-1.93.32-.09.54-.38.54-.72 0-.49-.46-.86-.93-.72-1.42.41-2.45 1.73-2.42 3.28.02 1.85 1.61 3.29 3.45 3.29zM4.12 5.29c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L9 13H3.5c-.83 0-1.5.67-1.5 1.5S2.67 16 3.5 16H12l6.29 6.29c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L4.12 5.29z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 foundation
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,12h1.7c0.46,0,0.68-0.57,0.33-0.87L12.67,3.6c-0.38-0.34-0.96-0.34-1.34,0l-8.36,7.53C2.63,11.43,2.84,12,3.3,12H5v3H4 c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1v2c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2h4v2c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1 v-2h4v2c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1V12z M7,15v-4.81l4-3.6V15H7z M13,15 V6.59l4,3.6V15H13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-stroller
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M8,20c0,1.1-0.9,2-2,2s-2-0.9-2-2s0.9-2,2-2S8,18.9,8,20z M14.3,4.1C13.03,3.4,11.56,3,10,3C8.77,3,7.61,3.26,6.54,3.71 l4.37,4.37L14.3,4.1z M20.49,21.9c0.39-0.39,0.39-1.02,0-1.41l-9.82-9.82L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0l0,0 c-0.39,0.39-0.39,1.02,0,1.41l7.26,7.26l-2.66,3.12c-0.55,0.65-0.09,1.65,0.76,1.65h6.66l1.17,1.17c-0.88,0.33-1.47,1.25-1.26,2.28 c0.15,0.76,0.78,1.39,1.54,1.54c1.03,0.21,1.95-0.38,2.28-1.26l1.2,1.2C19.46,22.29,20.09,22.29,20.49,21.9L20.49,21.9z M17,6.27 C17.58,5.59,17.97,5,18.65,5c0.68,0,1.22,0.52,1.33,1.21C20.08,6.66,20.48,7,20.96,7c0.55,0,1-0.45,1-1c0-0.06,0-0.11-0.01-0.16 l0-0.01C21.65,4.22,20.3,3,18.65,3c-1.66,0-2.54,1.27-3.18,2.03l-3.5,4.11L17,14.17V6.27z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 corporate-fare
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,7V5c0-1.1-0.9-2-2-2H4C2.9,3,2,3.9,2,5v14c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V9c0-1.1-0.9-2-2-2H12z M10,19H4v-2h6V19z M10,15H4v-2h6V15z M10,11H4V9h6V11z M10,7H4V5h6V7z M20,19h-8V9h8V19z M18,11h-4v2h4V11z M18,15h-4v2h4V15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-drinks
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M20.49,20.49L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41l7.54,7.54L11,14v5H7c-0.55,0-1,0.45-1,1 s0.45,1,1,1h10c0.32,0,0.59-0.16,0.78-0.4l1.3,1.3c0.39,0.39,1.02,0.39,1.41,0C20.88,21.51,20.88,20.88,20.49,20.49z M13,19v-3.17 L16.17,19H13z M7.83,5l-2-2h13.72C20.35,3,21,3.65,21,4.45c0,0.35-0.13,0.7-0.37,0.96l-5.83,6.56L9.83,7h6.74l1.78-2H7.83z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 family-restroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M16,4c0-1.11,0.89-2,2-2s2,0.89,2,2s-0.89,2-2,2S16,5.11,16,4z M20,21v-5h1.11c0.68,0,1.16-0.67,0.95-1.32l-2.1-6.31 C19.68,7.55,18.92,7,18.06,7h-0.12c-0.86,0-1.63,0.55-1.9,1.37l-0.86,2.58C16.26,11.55,17,12.68,17,14v8h2C19.55,22,20,21.55,20,21 z M12.5,11.5c0.83,0,1.5-0.67,1.5-1.5s-0.67-1.5-1.5-1.5S11,9.17,11,10S11.67,11.5,12.5,11.5z M5.5,6c1.11,0,2-0.89,2-2 s-0.89-2-2-2s-2,0.89-2,2S4.39,6,5.5,6z M7.5,21v-6H8c0.55,0,1-0.45,1-1V9c0-1.1-0.9-2-2-2H4C2.9,7,2,7.9,2,9v5c0,0.55,0.45,1,1,1 h0.5v6c0,0.55,0.45,1,1,1h2C7.05,22,7.5,21.55,7.5,21z M10,14v3c0,0.55,0.45,1,1,1h0v3c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-3h0 c0.55,0,1-0.45,1-1v-3c0-0.82-0.68-1.5-1.5-1.5h-2C10.68,12.5,10,13.18,10,14",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 checkroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.6,18.2L13,11.75v-0.91c1.65-0.49,2.8-2.17,2.43-4.05c-0.26-1.31-1.3-2.4-2.61-2.7c-1.76-0.4-3.37,0.53-4.02,1.98 C8.5,6.74,8.98,7.5,9.71,7.5h0c0.39,0,0.75-0.22,0.9-0.57C10.84,6.38,11.37,6,12,6c0.83,0,1.5,0.67,1.5,1.5 c0,0.84-0.69,1.52-1.53,1.5C11.43,8.99,11,9.45,11,9.99l0,1.76L2.4,18.2C1.63,18.78,2.04,20,3,20h9h9 C21.96,20,22.37,18.78,21.6,18.2z M6,18l6-4.5l6,4.5H6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 soap
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14.25,6C14.66,6,15,6.34,15,6.75S14.66,7.5,14.25,7.5S13.5,7.16,13.5,6.75S13.84,6,14.25,6 M14.25,4.5 C13.01,4.5,12,5.51,12,6.75S13.01,9,14.25,9s2.25-1.01,2.25-2.25S15.49,4.5,14.25,4.5L14.25,4.5z M20,5.5c0.28,0,0.5,0.22,0.5,0.5 S20.28,6.5,20,6.5S19.5,6.28,19.5,6S19.72,5.5,20,5.5 M20,4c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S21.1,4,20,4L20,4z M18,2.5 C18,3.33,17.33,4,16.5,4C15.67,4,15,3.33,15,2.5S15.67,1,16.5,1C17.33,1,18,1.67,18,2.5z M1.94,11.79C1.34,12.35,1,13.14,1,13.97 V20c0,1.66,1.34,3,3,3l13.68,0c0.65,0,1.25-0.47,1.32-1.12c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5v0 c0-0.28,0.22-0.5,0.5-0.5l7.18,0c0.65,0,1.25-0.47,1.32-1.12c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5l0,0 c0-0.28,0.22-0.5,0.5-0.5l8.18,0c0.65,0,1.25-0.47,1.32-1.12c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5v0 c0-0.28,0.22-0.5,0.5-0.5l6.18,0c0.65,0,1.25-0.47,1.32-1.12c0.08-0.75-0.51-1.38-1.24-1.38H8.86l1.49-2.61 c0.09-0.16,0.14-0.33,0.14-0.53c0-0.26-0.09-0.5-0.26-0.7L9.81,5.71C9.43,5.32,8.8,5.3,8.4,5.68L1.94,11.79z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 houseboat
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,17.83c0-0.42-0.27-0.8-0.67-0.94C20.62,16.62,20.21,16,18.67,16c-1.91,0-2.14,1-3.33,1c-1.24,0-1.39-1-3.34-1 s-2.1,1-3.34,1c-1.19,0-1.42-1-3.33-1c-1.54,0-1.95,0.62-2.66,0.88C2.27,17.03,2,17.4,2,17.83c0,0.7,0.69,1.19,1.35,0.95 c0.8-0.29,1.18-0.78,2-0.78c1.19,0,1.42,1,3.33,1c1.95,0,2.08-1,3.32-1s1.37,1,3.32,1c1.91,0,2.14-1,3.33-1c0.83,0,1.21,0.49,2,0.78 C21.31,19.02,22,18.52,22,17.83z M18.91,9.81c0.33-0.45,0.23-1.07-0.22-1.4l-6.1-4.47c-0.35-0.26-0.83-0.26-1.18,0l-6.1,4.47 c-0.45,0.33-0.54,0.95-0.22,1.4c0.33,0.45,0.95,0.54,1.4,0.22L7,9.65V13H5.74c-0.27,0-0.52-0.11-0.71-0.29l-0.66-0.66 c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41l0.66,0.66C4.18,14.68,4.95,15,5.74,15h12.51c0.8,0,1.56-0.32,2.12-0.88 l0.66-0.66c0.39-0.39,0.39-1.02,0-1.41c-0.39-0.39-1.02-0.39-1.41,0l-0.66,0.66C18.78,12.89,18.52,13,18.26,13H17V9.65l0.51,0.37 C17.96,10.35,18.58,10.25,18.91,9.81z M13,13h-2v-2h2V13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 roofing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M13,18h-2v-2h2V18z M9,15v4c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-4c0-0.55-0.45-1-1-1h-4C9.45,14,9,14.45,9,15z M19,9.3 L19,9.3V5c0-0.55-0.45-1-1-1h-1c-0.55,0-1,0.45-1,1v1.6v0l-3.33-3c-0.38-0.34-0.96-0.34-1.34,0l-8.36,7.53 C2.63,11.43,2.84,12,3.3,12h1.31c0.25,0,0.49-0.09,0.67-0.26L12,5.69l6.71,6.05C18.9,11.91,19.14,12,19.38,12h1.31 c0.46,0,0.68-0.57,0.33-0.87L19,9.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 night-shelter
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M10.8,3.9l-6,4.5C4.3,8.78,4,9.37,4,10v9c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-9c0-0.63-0.3-1.22-0.8-1.6l-6-4.5 C12.49,3.37,11.51,3.37,10.8,3.9z M9.75,12.5c0.69,0,1.25,0.56,1.25,1.25S10.44,15,9.75,15S8.5,14.44,8.5,13.75S9.06,12.5,9.75,12.5 z M16.5,18L16.5,18c-0.28,0-0.5-0.22-0.5-0.5v-1H8v1C8,17.78,7.78,18,7.5,18h0C7.22,18,7,17.78,7,17.5v-6C7,11.22,7.22,11,7.5,11h0 C7.78,11,8,11.22,8,11.5v4h3.5v-3c0-0.28,0.22-0.5,0.5-0.5h3c1.1,0,2,0.9,2,2v3.5C17,17.78,16.78,18,16.5,18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 do-not-step
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M2.1,3.51c-0.39,0.39-0.39,1.02,0,1.41l7.19,7.19c0.18,0.2,0.18,0.5-0.01,0.7c-0.1,0.1-0.23,0.15-0.35,0.15 s-0.26-0.05-0.35-0.15L6.87,11.1c-0.11,0.4-0.26,0.78-0.45,1.12l1.4,1.4c0.2,0.2,0.2,0.51,0,0.71c-0.1,0.1-0.23,0.15-0.35,0.15 s-0.26-0.05-0.35-0.15l-1.27-1.27c-0.24,0.29-0.5,0.56-0.77,0.8l1.28,1.28c0.2,0.2,0.2,0.51,0,0.71C6.26,15.95,6.13,16,6,16 s-0.26-0.05-0.35-0.15l-1.38-1.38c-0.71,0.47-1.43,0.81-2.02,1.04C1.49,15.81,1,16.55,1,17.37L1,18c0,1.1,0.9,2,2,2h6.67 c0.53,0,1.04-0.21,1.41-0.59l2.74-2.74l5.23,5.23c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51 C3.12,3.12,2.49,3.12,2.1,3.51L2.1,3.51z M18.51,15.68l-1.41-1.41l4.48-4.48l0,0c0.78,0.78,0.78,2.05,0,2.83L18.51,15.68z M20.88,9.08l-4.48,4.48L9.3,6.47l3.09-3.07c0.78-0.78,2.04-0.77,2.82,0L20.88,9.08z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 spa
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.49 9.63c-.16-2.42-1.03-4.79-2.64-6.76-.41-.5-1.16-.5-1.57 0-1.65 1.98-2.57 4.35-2.77 6.76 1.28.68 2.46 1.56 3.49 2.63 1.03-1.06 2.21-1.94 3.49-2.63zm-6.5 2.65c-.14-.1-.3-.19-.45-.29.15.11.31.19.45.29zm6.42-.25c-.13.09-.27.16-.4.26.13-.1.27-.17.4-.26zM12 15.45c-1.95-2.97-5.14-5.03-8.83-5.39-.64-.06-1.17.47-1.11 1.11.45 4.8 3.65 8.78 7.98 10.33.63.23 1.29.4 1.97.51.68-.12 1.33-.29 1.97-.51 4.33-1.55 7.53-5.52 7.98-10.33.06-.64-.48-1.17-1.11-1.11-3.71.36-6.9 2.42-8.85 5.39z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cabin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4.37,3.55C4.89,2.62,5.87,2,7,2c0.38,0,0.72-0.22,0.89-0.53C8.04,1.16,8.39,1,8.73,1c0.74,0,1.26,0.8,0.9,1.45 C9.11,3.38,8.13,4,7,4C6.62,4,6.28,4.22,6.11,4.53C5.96,4.84,5.61,5,5.27,5C4.53,5,4.01,4.2,4.37,3.55z M22.39,12.19 c-0.34,0.44-0.96,0.52-1.4,0.19L20,11.62V20c0,0.55-0.45,1-1,1H5c-0.55,0-1-0.45-1-1v-8.38l-0.99,0.76 c-0.44,0.34-1.07,0.25-1.4-0.19c-0.33-0.44-0.25-1.07,0.19-1.4L4,9.11V7c0-0.55,0.45-1,1-1s1,0.45,1,1v0.58l5.39-4.12 c0.36-0.27,0.86-0.27,1.21,0l9.6,7.33C22.64,11.13,22.73,11.76,22.39,12.19z M10.06,7h3.89L12,5.52L10.06,7z M6,10.1V11h12v-0.9 L16.56,9H7.44L6,10.1z M6,13v2h12v-2H6z M18,19v-2H6v2H18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 villa
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M7,21H4c-0.55,0-1-0.45-1-1V8.69C3,8.27,3.25,7.9,3.64,7.75l11-4.23C15.3,3.27,16,3.75,16,4.46V10H8c-0.55,0-1,0.45-1,1V21z M17,12h-7c-0.55,0-1,0.45-1,1v7c0,0.55,0.45,1,1,1h4v-4c0-0.55,0.45-1,1-1s1,0.45,1,1v4h4c0.55,0,1-0.45,1-1v-8c0-1.1-0.9-2-2-2 S17,10.9,17,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ac-unit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 11h-3.17l2.54-2.54c.39-.39.39-1.02 0-1.41-.39-.39-1.03-.39-1.42 0L15 11h-2V9l3.95-3.95c.39-.39.39-1.03 0-1.42-.39-.39-1.02-.39-1.41 0L13 6.17V3c0-.55-.45-1-1-1s-1 .45-1 1v3.17L8.46 3.63c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.03 0 1.42L11 9v2H9L5.05 7.05c-.39-.39-1.03-.39-1.42 0-.39.39-.39 1.02 0 1.41L6.17 11H3c-.55 0-1 .45-1 1s.45 1 1 1h3.17l-2.54 2.54c-.39.39-.39 1.02 0 1.41.39.39 1.03.39 1.42 0L9 13h2v2l-3.95 3.95c-.39.39-.39 1.03 0 1.42.39.39 1.02.39 1.41 0L11 17.83V21c0 .55.45 1 1 1s1-.45 1-1v-3.17l2.54 2.54c.39.39 1.02.39 1.41 0 .39-.39.39-1.03 0-1.42L13 15v-2h2l3.95 3.95c.39.39 1.03.39 1.42 0 .39-.39.39-1.02 0-1.41L17.83 13H21c.55 0 1-.45 1-1s-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-food
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M16,22c0,0.55-0.45,1-1,1H2c-0.55,0-1-0.45-1-1s0.45-1,1-1h13C15.55,21,16,21.45,16,22z M22.89,6.1 C22.95,5.51,22.49,5,21.9,5H18V2c0-0.55-0.45-1-1-1s-1,0.45-1,1v3h-3.9c-0.59,0-1.05,0.51-1,1.1l0.24,2.41L18,15.17l3.62,3.62 L22.89,6.1z M21.19,22.61c0.39-0.39,0.39-1.02,0-1.41L12,12L9.01,9.01h0l-6.2-6.2c-0.39-0.39-1.02-0.39-1.41,0l0,0 C1,3.2,1,3.83,1.39,4.22l4.99,4.99c-2.56,0.54-4.76,2.08-5.28,4.63C0.99,14.45,1.49,15,2.1,15l10.07,0l2,2H2c-0.55,0-1,0.45-1,1 s0.45,1,1,1h13c0.32,0,0.59-0.16,0.78-0.4l4,4C20.17,23,20.8,23,21.19,22.61L21.19,22.61z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 room-preferences
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.75,17c0-0.22-0.03-0.42-0.06-0.63l0.84-0.73c0.18-0.16,0.22-0.42,0.1-0.63l-0.59-1.02c-0.12-0.21-0.37-0.3-0.59-0.22 l-1.06,0.36c-0.32-0.27-0.68-0.48-1.08-0.63l-0.22-1.09c-0.05-0.23-0.25-0.4-0.49-0.4h-1.18c-0.24,0-0.44,0.17-0.49,0.4l-0.22,1.09 c-0.4,0.15-0.76,0.36-1.08,0.63l-1.06-0.36c-0.23-0.08-0.47,0.02-0.59,0.22l-0.59,1.02c-0.12,0.21-0.08,0.47,0.1,0.63l0.84,0.73 c-0.03,0.21-0.06,0.41-0.06,0.63s0.03,0.42,0.06,0.63l-0.84,0.73c-0.18,0.16-0.22,0.42-0.1,0.63l0.59,1.02 c0.12,0.21,0.37,0.3,0.59,0.22l1.06-0.36c0.32,0.27,0.68,0.48,1.08,0.63l0.22,1.09c0.05,0.23,0.25,0.4,0.49,0.4h1.18 c0.24,0,0.44-0.17,0.49-0.4l0.22-1.09c0.4-0.15,0.76-0.36,1.08-0.63l1.06,0.36c0.23,0.08,0.47-0.02,0.59-0.22l0.59-1.02 c0.12-0.21,0.08-0.47-0.1-0.63l-0.84-0.73C21.72,17.42,21.75,17.22,21.75,17z M18,19c-1.1,0-2-0.9-2-2s0.9-2,2-2s2,0.9,2,2 S19.1,19,18,19z M14,11.26V6h3v4h2V5c0-0.55-0.45-1-1-1h-4c0-0.55-0.45-1-1-1H6C5.45,3,5,3.45,5,4v15H4c-0.55,0-1,0.45-1,1 s0.45,1,1,1h8.26C11.47,19.87,11,18.49,11,17C11,14.62,12.19,12.53,14,11.26z M10,12c0-0.55,0.45-1,1-1s1,0.45,1,1 c0,0.55-0.45,1-1,1S10,12.55,10,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 no-backpack
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:y "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.98,4.15c0.01,0,0.01-0.01,0.02-0.01V3.5C7,2.67,7.67,2,8.5,2S10,2.67,10,3.5V4h4V3.5C14,2.67,14.67,2,15.5,2 S17,2.67,17,3.5v0.64c1.72,0.45,3,2,3,3.86v9.17l-2.03-2.03C17.98,15.09,18,15.05,18,15v-2c0-0.55-0.45-1-1-1h-2.17L6.98,4.15z M20.49,21.9c-0.39,0.39-1.02,0.39-1.41,0l-0.14-0.14C18.65,21.91,18.34,22,18,22H6c-1.1,0-2-0.9-2-2V8 c0-0.36,0.06-0.69,0.15-1.02L2.1,4.93c-0.39-0.39-0.39-1.02,0-1.41c0.39-0.39,1.02-0.39,1.41,0l16.97,16.97 C20.88,20.88,20.88,21.51,20.49,21.9z M11.17,14l-2-2H7c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1H11.17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 child-friendly
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 3.08V10h8c0-4.03-2.98-7.37-6.86-7.92-.6-.09-1.14.39-1.14 1zm6.32 12.81C20.37 14.54 21 12.84 21 11H6.44l-.68-1.43C5.6 9.22 5.24 9 4.86 9H3c-.55 0-1 .45-1 1s.45 1 1 1h1.22s1.89 4.07 2.12 4.42c-1.33.71-2.14 2.27-1.74 3.94.3 1.26 1.34 2.27 2.6 2.55 2.1.46 3.98-.96 4.25-2.91h2.08c.27 1.94 2.14 3.36 4.22 2.92 1.27-.27 2.31-1.27 2.63-2.53.35-1.39-.14-2.68-1.06-3.5zM8 20c-.83 0-1.5-.67-1.5-1.5S7.17 17 8 17s1.5.67 1.5 1.5S8.83 20 8 20zm9 0c-.83 0-1.5-.67-1.5-1.5S16.17 17 17 17s1.5.67 1.5 1.5S17.83 20 17 20z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hot-tub
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle {:r "2", :cy "6", :cx "7", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 12h-9.85c-.31-.22-.59-.46-.82-.72l-1.4-1.55c-.19-.21-.43-.38-.69-.5-.29-.14-.62-.23-.96-.23h-.03C6.01 9 5 10.01 5 11.25V12H3c-.55 0-1 .45-1 1v7c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2v-7c0-.55-.45-1-1-1zM7 19c0 .55-.45 1-1 1s-1-.45-1-1v-4c0-.55.45-1 1-1s1 .45 1 1v4zm4 0c0 .55-.45 1-1 1s-1-.45-1-1v-4c0-.55.45-1 1-1s1 .45 1 1v4zm4 0c0 .55-.45 1-1 1s-1-.45-1-1v-4c0-.55.45-1 1-1s1 .45 1 1v4zm4 0c0 .55-.45 1-1 1s-1-.45-1-1v-4c0-.55.45-1 1-1s1 .45 1 1v4zm-3.94-9c.5 0 .93-.39.94-.89.04-1.4-.58-2.48-1.35-3.25-.65-.72-.8-1.27-.77-1.91.02-.52-.41-.95-.94-.95-.5 0-.93.4-.94.9-.03 1.29.5 2.43 1.35 3.25.61.59.78 1.27.78 1.89-.01.52.4.96.93.96zm4 0c.5 0 .93-.39.94-.89.04-1.4-.58-2.48-1.35-3.25-.65-.72-.8-1.27-.77-1.91.02-.52-.41-.95-.94-.95-.5 0-.93.4-.94.9-.03 1.29.5 2.43 1.35 3.25.61.59.78 1.27.78 1.89-.01.52.4.96.93.96z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fence
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,11L21,11c0-0.55-0.45-1-1-1h-1V7l-2.29-2.29c-0.39-0.39-1.02-0.39-1.41,0L14,6l-1.29-1.29c-0.39-0.39-1.02-0.39-1.41,0 L10,6L8.71,4.71c-0.39-0.39-1.02-0.39-1.41,0L5,7v3H4c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1v2H4c-0.55,0-1,0.45-1,1v0 c0,0.55,0.45,1,1,1h1v3c0,0.55,0.45,1,1,1h12c0.55,0,1-0.45,1-1v-3h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-1v-2h1 C20.55,12,21,11.55,21,11z M16,6.83l1,1V10h-2V7.83l0.41-0.41L16,6.83z M12,6.83l0.59,0.59L13,7.83V10h-2V7.83l0.41-0.41L12,6.83z M11,14v-2h2v2H11z M13,16v2h-2v-2H13z M7,7.83l1-1l0.59,0.59L9,7.83V10H7V7.83z M7,12h2v2H7V12z M7,16h2v2H7V16z M17,18h-2v-2h2 V18z M17,14h-2v-2h2V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 rice-bowl
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12L22,12c0-5.48-4.4-9.93-9.86-10C8.52,1.95,5.29,4.03,3.43,7.14C0.1,12.69,2.98,18.27,8,20.25v0.25 C8,21.33,8.67,22,9.5,22h5c0.83,0,1.5-0.67,1.5-1.5v-0.25C19.53,18.86,22,15.69,22,12z M20,12h-4V5.08C18.39,6.47,20,9.05,20,12z M14,4.26V12h-4V4.26C10.64,4.1,11.31,4,12,4S13.36,4.1,14,4.26z M4,12c0-2.95,1.61-5.53,4-6.92V12H4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-photography
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M10.94,8.12L7.48,4.66L8.4,3.65C8.78,3.24,9.32,3,9.88,3h4.24c0.56,0,1.1,0.24,1.47,0.65L16.83,5H20c1.1,0,2,0.9,2,2v12 c0,0.05-0.01,0.1-0.02,0.16l-5.1-5.1C16.96,13.71,17,13.36,17,13c0-2.76-2.24-5-5-5C11.64,8,11.29,8.04,10.94,8.12z M19.78,22.61 L18.17,21H4c-1.1,0-2-0.9-2-2V7c0-0.59,0.27-1.12,0.68-1.49L1.39,4.22C1,3.83,1,3.2,1.39,2.81l0,0c0.39-0.39,1.02-0.39,1.41,0 l18.38,18.38c0.39,0.39,0.39,1.02,0,1.41l0,0C20.8,23,20.17,23,19.78,22.61z M14.49,17.32l-1.5-1.5C12.67,15.92,12.35,16,12,16 c-1.66,0-3-1.34-3-3c0-0.35,0.08-0.67,0.19-0.98l-1.5-1.5C7.25,11.24,7,12.09,7,13c0,2.76,2.24,5,5,5 C12.91,18,13.76,17.75,14.49,17.32z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bento
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,11V5h4c1.1,0,2,0.9,2,2v4H16z M20,19c1.1,0,2-0.9,2-2v-4h-6v6H20z M14,5v14H4c-1.1,0-2-0.9-2-2V7c0-1.1,0.9-2,2-2H14z M9.5,12c0-0.83-0.67-1.5-1.5-1.5S6.5,11.17,6.5,12s0.67,1.5,1.5,1.5S9.5,12.83,9.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 iron
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M8.27,10c0.34,0,0.68-0.16,0.84-0.47C9.28,9.22,9.62,9,10,9h4c0.55,0,1,0.45,1,1v1H6c-2.21,0-4,1.79-4,4v2 c0,0.55,0.45,1,1,1h13c0.55,0,1-0.45,1-1v-1c1.66,0,3-1.34,3-3V9c0-0.55,0.45-1,1-1h0c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h0 c-1.66,0-3,1.34-3,3v4c0,0.55-0.45,1-1,1v-4c0-1.66-1.34-3-3-3h-4C8.87,7,7.89,7.62,7.37,8.55C7.01,9.2,7.53,10,8.27,10z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-cell
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M8.83,6l-3.7-3.7C5.42,1.55,6.15,1,7,1l10,0.01c1.1,0,2,0.89,2,1.99v13.17l-2-2V6H8.83z M20.49,21.9 c-0.39,0.39-1.02,0.39-1.41,0l-0.2-0.2C18.58,22.45,17.85,23,17,23H7c-1.1,0-2-0.9-2-2V7.83l-2.9-2.9c-0.39-0.39-0.39-1.02,0-1.41 c0.39-0.39,1.02-0.39,1.41,0l16.97,16.97C20.88,20.88,20.88,21.51,20.49,21.9z M15.17,18L7,9.83V18H15.17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 umbrella
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M17.12,6.28L14.5,6.92L13,5.77V3.88V3.4c0-0.26,0.22-0.48,0.5-0.48c0.23,0,0.43,0.16,0.49,0.36C14.1,3.7,14.49,4,14.94,4 c0.55,0,1-0.45,1-1c0-0.1-0.02-0.2-0.05-0.3C15.59,1.72,14.63,1,13.5,1C12.12,1,11,2.07,11,3.4v0.48v1.89L9.5,6.92L6.88,6.28 C6.5,6.19,6.16,6.55,6.28,6.92l4.77,14.39C11.2,21.77,11.6,22,12,22s0.8-0.23,0.95-0.69l4.77-14.39 C17.84,6.55,17.5,6.19,17.12,6.28z M11,14.8L9.03,8.86l0.92,0.23l0.76-0.58L11,8.29V14.8z M13,14.8V8.29l0.28,0.22l0.76,0.58 l0.92-0.23L13,14.8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 house
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,9.3V5c0-0.55-0.45-1-1-1h-1c-0.55,0-1,0.45-1,1v1.6l-3.33-3c-0.38-0.34-0.96-0.34-1.34,0l-8.36,7.53 C2.63,11.43,2.84,12,3.3,12H5v7c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v-5h4v5c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v-7h1.7 c0.46,0,0.68-0.57,0.33-0.87L19,9.3z M10,10c0-1.1,0.9-2,2-2s2,0.9,2,2H10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 baby-changing-station
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M14,9L14,9c0,0.55-0.45,1-1,1h-1.58c-0.28,0-0.55-0.06-0.8-0.17l-2.3-1.01L7,12.75V21c0,0.55-0.45,1-1,1H4 c-0.55,0-1-0.45-1-1v-8.67c0-0.22,0.04-0.44,0.11-0.65l1.48-4.32C4.96,6.25,6.22,5.69,7.3,6.18l4.15,1.83L13,8 C13.55,8,14,8.45,14,9z M8,1C6.9,1,6,1.9,6,3s0.9,2,2,2s2-0.9,2-2S9.1,1,8,1z M10,19h10c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H10 c-0.55,0-1,0.45-1,1v0C9,18.55,9.45,19,10,19z M19.5,16c0.83,0,1.5-0.67,1.5-1.5c0-0.83-0.67-1.5-1.5-1.5S18,13.67,18,14.5 C18,15.33,18.67,16,19.5,16z M13,12c0-0.55-0.45-1-1-1h-2c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1v1c0,1.1,0.9,2,2,2h2 c1.1,0,2-0.9,2-2v-2c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v1h-2V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bathtub
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/circle
      {:r "2", :cy "7", :cx "7", :stroke nil, :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21,13h-1V4.83C20,3.27,18.73,2,17.17,2c-0.75,0-1.47,0.3-2,0.83l-1.25,1.25C13.76,4.03,13.59,4,13.41,4 c-0.4,0-0.77,0.12-1.08,0.32l2.76,2.76c0.2-0.31,0.32-0.68,0.32-1.08c0-0.18-0.03-0.34-0.07-0.51l1.25-1.25 C16.74,4.09,16.95,4,17.17,4C17.63,4,18,4.37,18,4.83V13h-6.85c-0.3-0.21-0.57-0.45-0.82-0.72l-1.4-1.55 c-0.19-0.21-0.43-0.38-0.69-0.5C7.93,10.08,7.59,10,7.24,10C6,10.01,5,11.01,5,12.25V13H3c-0.55,0-1,0.45-1,1v5c0,1.1,0.9,2,2,2 c0,0.55,0.45,1,1,1h14c0.55,0,1-0.45,1-1c1.1,0,2-0.9,2-2v-5C22,13.45,21.55,13,21,13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 wash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M1.94,11.79C1.34,12.35,1,13.14,1,13.97V20c0,1.66,1.34,3,3,3l13.68,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5l7.18,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5l0,0c0-0.28,0.22-0.5,0.5-0.5l8.18,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H12.5c-0.28,0-0.5-0.22-0.5-0.5v0c0-0.28,0.22-0.5,0.5-0.5l6.18,0c0.65,0,1.25-0.47,1.32-1.12 c0.08-0.75-0.51-1.38-1.24-1.38H8.86l1.49-2.61c0.09-0.16,0.14-0.33,0.14-0.53c0-0.26-0.09-0.5-0.26-0.7L9.81,5.71 C9.43,5.32,8.8,5.3,8.4,5.68L1.94,11.79z M18.5,8C19.88,8,21,6.88,21,5.5c0-1.25-1.41-3.16-2.11-4.04c-0.2-0.25-0.57-0.25-0.77,0 C17.41,2.34,16,4.25,16,5.5C16,6.88,17.12,8,18.5,8z M13.5,9C14.33,9,15,8.33,15,7.5c0-0.56-0.67-1.49-1.11-2.04 c-0.2-0.25-0.58-0.25-0.77,0C12.67,6.01,12,6.94,12,7.5C12,8.33,12.67,9,13.5,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 airport-shuttle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22.41 10.41l-4.83-4.83c-.37-.37-.88-.58-1.41-.58H3c-1.1 0-2 .89-2 2v7c0 1.1.9 2 2 2 0 1.66 1.34 3 3 3s3-1.34 3-3h6c0 1.66 1.34 3 3 3s3-1.34 3-3c1.1 0 2-.9 2-2v-2.17c0-.53-.21-1.04-.59-1.42zM3 10V8c0-.55.45-1 1-1h3v4H4c-.55 0-1-.45-1-1zm3 7.25c-.69 0-1.25-.56-1.25-1.25s.56-1.25 1.25-1.25 1.25.56 1.25 1.25-.56 1.25-1.25 1.25zM13 11H9V7h4v4zm5 6.25c-.69 0-1.25-.56-1.25-1.25s.56-1.25 1.25-1.25 1.25.56 1.25 1.25-.56 1.25-1.25 1.25zM15 11V7h1l4 4h-5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 no-flash
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M3.16,3.16c-0.39-0.39-1.02-0.39-1.41,0l0,0c-0.39,0.39-0.39,1.02,0,1.41l4.6,4.6L6.14,9.4H3.6C2.72,9.4,2,10.12,2,11v9.4 C2,21.28,2.72,22,3.6,22h12.8c0.75,0,1.38-0.52,1.55-1.22l1.47,1.47c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41 L3.16,3.16z M10,20c-2.21,0-4-1.79-4-4c0-1.95,1.4-3.57,3.25-3.92l1.57,1.57c-0.26-0.09-0.53-0.15-0.82-0.15 c-1.38,0-2.5,1.12-2.5,2.5c0,1.38,1.12,2.5,2.5,2.5c1.38,0,2.5-1.12,2.5-2.5c0-0.29-0.06-0.56-0.15-0.82l1.57,1.57 C13.57,18.6,11.95,20,10,20z M18,15.17L10.83,8h0.87c0.56,0,1.1,0.24,1.48,0.65l0.69,0.75h2.54c0.88,0,1.6,0.72,1.6,1.6V15.17z M20.4,5.6h0.75c0.38,0,0.62,0.41,0.44,0.74L19,11V7h-0.5C18.22,7,18,6.78,18,6.5v-4C18,2.22,18.22,2,18.5,2h2.73 c0.36,0,0.6,0.37,0.46,0.7L20.4,5.6z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 backpack
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M20,8v12c0,1.1-0.9,2-2,2H6c-1.1,0-2-0.9-2-2V8c0-1.86,1.28-3.41,3-3.86V3.5C7,2.67,7.67,2,8.5,2h0 C9.33,2,10,2.67,10,3.5V4h4V3.5C14,2.67,14.67,2,15.5,2h0C16.33,2,17,2.67,17,3.5v0.64C18.72,4.59,20,6.14,20,8z M6,13L6,13 c0,0.55,0.45,1,1,1h9v1c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2c0-0.55-0.45-1-1-1H7C6.45,12,6,12.45,6,13z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 bungalow
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24",
    :height "24",
    :fill "none",
    :display "none",
    :stroke nil})
  (helix.dom/path
   {:d
    "M12,16c0.55,0,1,0.45,1,1v4h3c0.55,0,1-0.45,1-1v-5.21l0.57,0.92c0.29,0.47,0.91,0.61,1.38,0.32 c0.47-0.29,0.61-0.91,0.32-1.38L12.85,4.36c-0.39-0.63-1.31-0.63-1.7,0L4.73,14.65c-0.29,0.47-0.15,1.09,0.32,1.38 c0.47,0.29,1.08,0.15,1.38-0.32L7,14.8V20c0,0.55,0.45,1,1,1h3v-4C11,16.45,11.45,16,12,16z M13,13c0,0.55-0.45,1-1,1s-1-0.45-1-1 s0.45-1,1-1S13,12.45,13,13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 food-bank
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M10.8,3.9l-6,4.5C4.3,8.78,4,9.37,4,10v9c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-9c0-0.63-0.3-1.22-0.8-1.6l-6-4.5 C12.49,3.37,11.51,3.37,10.8,3.9z M12.5,12.5c0,0.83-0.67,1.5-1.5,1.5v3.5c0,0.28-0.22,0.5-0.5,0.5h0c-0.28,0-0.5-0.22-0.5-0.5V14 c-0.83,0-1.5-0.67-1.5-1.5V10c0-0.28,0.22-0.5,0.5-0.5h0c0.28,0,0.5,0.22,0.5,0.5v2.5H10V10c0-0.28,0.22-0.5,0.5-0.5h0 c0.28,0,0.5,0.22,0.5,0.5v2.5h0.5V10c0-0.28,0.22-0.5,0.5-0.5h0c0.28,0,0.5,0.22,0.5,0.5V12.5z M14.5,18L14.5,18 c-0.28,0-0.5-0.22-0.5-0.5v-3h-0.5c-0.28,0-0.5-0.22-0.5-0.5v-2.5c0-0.88,0.57-1.63,1.36-1.89C14.67,9.5,15,9.75,15,10.09v7.41 C15,17.78,14.78,18,14.5,18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 kitchen
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 2.01 6 2a2 2 0 00-2 2v16c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.11-.9-1.99-2-1.99zM17 20H7c-.55 0-1-.45-1-1v-7.02c0-.55.45-1 1-1h10c.55 0 1 .45 1 1V19c0 .55-.45 1-1 1zm0-11H7c-.55 0-1-.45-1-1V5c0-.55.45-1 1-1h10c.55 0 1 .45 1 1v3c0 .55-.45 1-1 1zM9 5c.55 0 1 .45 1 1v1c0 .55-.45 1-1 1s-1-.45-1-1V6c0-.55.45-1 1-1zm0 7c.55 0 1 .45 1 1v3c0 .55-.45 1-1 1s-1-.45-1-1v-3c0-.55.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 elevator
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M8.5,6c0.69,0,1.25,0.56,1.25,1.25 c0,0.69-0.56,1.25-1.25,1.25S7.25,7.94,7.25,7.25C7.25,6.56,7.81,6,8.5,6z M11,13c0,0.55-0.45,1-1,1v3c0,0.55-0.45,1-1,1H8 c-0.55,0-1-0.45-1-1v-3c-0.55,0-1-0.45-1-1v-1.5c0-1.1,0.9-2,2-2h1c1.1,0,2,0.9,2,2V13z M17.52,13.76l-1.6,2.56 c-0.2,0.31-0.65,0.31-0.85,0l-1.6-2.56C13.27,13.43,13.51,13,13.9,13h3.2C17.49,13,17.73,13.43,17.52,13.76z M17.1,11h-3.2 c-0.39,0-0.63-0.43-0.42-0.77l1.6-2.56c0.2-0.31,0.65-0.31,0.85,0l1.6,2.56C17.73,10.57,17.49,11,17.1,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 apartment
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,11V5c0-1.1-0.9-2-2-2H9C7.9,3,7,3.9,7,5v2H5C3.9,7,3,7.9,3,9v10c0,1.1,0.9,2,2,2h5c0.55,0,1-0.45,1-1v-3h2v3 c0,0.55,0.45,1,1,1h5c1.1,0,2-0.9,2-2v-6c0-1.1-0.9-2-2-2H17z M7,19H5v-2h2V19z M7,15H5v-2h2V15z M7,11H5V9h2V11z M11,15H9v-2h2V15 z M11,11H9V9h2V11z M11,7H9V5h2V7z M15,15h-2v-2h2V15z M15,11h-2V9h2V11z M15,7h-2V5h2V7z M19,19h-2v-2h2V19z M19,15h-2v-2h2V15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 pool
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.11 5.56C7.3 5.7 8.14 6.14 9 7l1 1-3.25 3.25c.31.12.56.27.77.39.37.23.59.36 1.15.36s.78-.13 1.15-.36c.46-.27 1.08-.64 2.19-.64s1.73.37 2.18.64c.37.22.6.36 1.15.36.55 0 .78-.13 1.15-.36.12-.07.26-.15.41-.23L10.48 5C9.22 3.74 8.04 3.2 6.3 3.05 5.6 2.99 5 3.56 5 4.26v.09c0 .63.49 1.13 1.11 1.21zm15.24 13.35c-.17-.06-.32-.15-.5-.27-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.6.36-1.15.36-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.19.64c-.37.23-.59.36-1.15.36s-.78-.13-1.15-.36c-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.19.64c-.18.11-.33.2-.5.27-.38.13-.65.45-.65.85v.12c0 .67.66 1.13 1.3.91.37-.13.65-.3.89-.44.37-.22.6-.35 1.15-.35.55 0 .78.13 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.19-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.72-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.23.14.51.31.88.44.63.22 1.3-.24 1.3-.91v-.12c0-.41-.27-.73-.65-.86zM3.11 16.35c.47-.13.81-.33 1.09-.49.37-.23.6-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.45.27 1.07.64 2.18.64s1.73-.37 2.18-.64c.37-.23.59-.36 1.15-.36.55 0 .78.14 1.15.36.23.14.5.3.85.43.63.23 1.31-.24 1.31-.91v-.12c0-.4-.27-.72-.64-.86-.17-.06-.32-.15-.51-.26-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.6.36-1.15.36s-.78-.14-1.15-.36c-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.37.23-.59.36-1.15.36-.55 0-.78-.14-1.15-.36-.45-.27-1.07-.64-2.18-.64s-1.73.37-2.18.64c-.18.11-.33.2-.5.27-.38.13-.65.45-.65.85v.23c0 .58.55 1.02 1.11.86z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "2.5", :cy "5.5", :cx "16.5", :stroke nil, :fill nil})))


(helix.core/defnc
 stairs
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M17,8h-1.42v3.33H13v3.33h-2.58 L10.45,18H7c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h1.42v-3.33H11V9.33h2.58V6H17c0.55,0,1,0.45,1,1C18,7.55,17.55,8,17,8z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 no-meeting-room
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 6h3v7.88l2 2V5c0-.55-.45-1-1-1h-4c0-.55-.45-1-1-1H6.12L14 10.88V6zm7.17 14.88L12 11.71V13h-2v-2h1.29L3.12 2.83c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L5 7.54V19H4c-.55 0-1 .45-1 1s.45 1 1 1h9c.55 0 1-.45 1-1v-3.46l5.75 5.75c.39.39 1.02.39 1.41 0 .4-.39.4-1.02.01-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wheelchair-pickup
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M4.5,4c0-1.11,0.89-2,2-2s2,0.89,2,2s-0.89,2-2,2S4.5,5.11,4.5,4z M10,10.95V9c0-1.1-0.9-2-2-2H5C3.9,7,3,7.9,3,9v5 c0,0.55,0.45,1,1,1h1v6c0,0.55,0.45,1,1,1h2.5v-0.11c-1.24-1.26-2-2.99-2-4.89C6.5,14.42,7.91,12.16,10,10.95z M16.5,17 c0,1.65-1.35,3-3,3s-3-1.35-3-3c0-1.11,0.61-2.06,1.5-2.58v-2.16C9.98,12.9,8.5,14.77,8.5,17c0,2.76,2.24,5,5,5s5-2.24,5-5H16.5z M19,14h-4V9c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v6c0,0.55,0.45,1,1,1h4.46l1.92,2.88c0.31,0.46,0.93,0.58,1.39,0.28h0 c0.46-0.31,0.58-0.93,0.28-1.39l-2.21-3.32C19.65,14.17,19.33,14,19,14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 chalet
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M10,15c-0.55,0-1,0.45-1,1v4H6c-0.55,0-1-0.45-1-1v-3.67l-0.38,0.38c-0.39,0.39-1.02,0.39-1.41,0l0,0 c-0.39-0.39-0.39-1.02,0-1.41l6.09-6.09c0.39-0.39,1.02-0.39,1.41,0l6.09,6.09c0.39,0.39,0.39,1.02,0,1.41v0 c-0.39,0.39-1.02,0.39-1.41,0L15,15.33V19c0,0.55-0.45,1-1,1h-3v-4C11,15.45,10.55,15,10,15z M17.5,7.5v0.89l-1.08,1.08 c-0.18,0.18-0.21,0.48-0.05,0.69c0.19,0.23,0.53,0.24,0.74,0.04l0.39-0.39v0.69c0,0.28,0.22,0.5,0.5,0.5h0c0.28,0,0.5-0.22,0.5-0.5 V9.81l0.39,0.39c0.21,0.21,0.55,0.19,0.74-0.04c0.17-0.2,0.14-0.5-0.05-0.69L18.5,8.39c0,0,0-0.89,0-0.89h0.89l1.08,1.08 c0.18,0.18,0.48,0.21,0.69,0.05c0.23-0.19,0.24-0.53,0.04-0.74L20.81,7.5h0.69C21.78,7.5,22,7.28,22,7v0c0-0.28-0.22-0.5-0.5-0.5 l-0.69,0l0.39-0.39c0.21-0.21,0.19-0.55-0.04-0.74c-0.2-0.17-0.5-0.14-0.69,0.05L19.39,6.5c0,0-0.89,0-0.89,0V5.61l1.08-1.08 c0.18-0.18,0.21-0.48,0.05-0.69c-0.19-0.23-0.53-0.24-0.74-0.04L18.5,4.19V3.5C18.5,3.22,18.28,3,18,3h0c-0.28,0-0.5,0.22-0.5,0.5 v0.69L17.11,3.8c-0.21-0.21-0.55-0.19-0.74,0.04c-0.17,0.2-0.14,0.5,0.05,0.69l1.08,1.08c0,0,0,0.89,0,0.89h-0.89l-1.08-1.08 c-0.18-0.18-0.48-0.21-0.69-0.05c-0.23,0.19-0.24,0.53-0.04,0.74l0.39,0.39H14.5C14.22,6.5,14,6.72,14,7v0c0,0.28,0.22,0.5,0.5,0.5 l0.69,0L14.8,7.89c-0.21,0.21-0.19,0.55,0.04,0.74c0.2,0.17,0.5,0.14,0.69-0.05l1.08-1.08C16.61,7.5,17.5,7.5,17.5,7.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 holiday-village
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M17,20c0.55,0,1-0.45,1-1V8.76c0-0.27-0.11-0.52-0.29-0.71l-3.76-3.76C13.76,4.11,13.51,4,13.24,4 c-0.89,0-1.34,1.08-0.71,1.71l3.32,3.32C15.95,9.12,16,9.25,16,9.38V19C16,19.55,16.45,20,17,20z M21,20c0.55,0,1-0.45,1-1V7.11 c0-0.26-0.11-0.52-0.29-0.71l-2.1-2.11C19.42,4.11,19.16,4,18.9,4C18,4,17.56,5.08,18.19,5.71l1.67,1.67C19.95,7.47,20,7.6,20,7.73 V19C20,19.55,20.45,20,21,20z M8,15c0.55,0,1,0.45,1,1v4h4c0.55,0,1-0.45,1-1v-8.59c0-0.27-0.11-0.52-0.29-0.71l-5-5 c-0.39-0.39-1.02-0.39-1.41,0l-5,5C2.11,9.89,2,10.15,2,10.41V19c0,0.55,0.45,1,1,1h4v-4C7,15.45,7.45,15,8,15z M8,13 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S8.55,13,8,13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crib
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18.32,18.32c-0.36-0.36-0.92-0.4-1.31-0.08c-0.32,0.25-0.65,0.48-1,0.69V16h2c1.1,0,2-0.9,2-2v-3c0-1.1-0.9-2-2-2h-6V6 c0-1.1-0.9-2-2-2H8C5.79,4,4,5.79,4,8v6c0,1.1,0.9,2,2,2h2v2.93c-0.35-0.2-0.69-0.43-1-0.69c-0.39-0.32-0.96-0.27-1.31,0.08 c-0.42,0.42-0.39,1.12,0.08,1.5C7.47,21.18,9.64,22,12,22c2.36,0,4.53-0.82,6.24-2.18C18.71,19.44,18.74,18.74,18.32,18.32z M14,19.75C13.36,19.91,12.69,20,12,20c-0.69,0-1.36-0.09-2-0.25V16h4V19.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 other-houses
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M1.61,12.19c0.34,0.44,0.96,0.52,1.4,0.19L4,11.62V20c0,0.55,0.45,1,1,1h14c0.55,0,1-0.45,1-1v-8.38l0.99,0.76 c0.44,0.34,1.07,0.25,1.4-0.19c0.34-0.44,0.25-1.07-0.19-1.4l-9.6-7.33c-0.36-0.27-0.86-0.27-1.21,0l-9.6,7.33 C1.36,11.13,1.27,11.76,1.61,12.19z M8,15c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C9,14.55,8.55,15,8,15z M12,15 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C13,14.55,12.55,15,12,15z M16,15c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1 s1,0.45,1,1C17,14.55,16.55,15,16,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vaping-rooms
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,17.5c0,0.83-0.67,1.5-1.5,1.5H8v-3h12.5C21.33,16,22,16.67,22,17.5z M10.5,17c-0.28,0-0.5,0.22-0.5,0.5 s0.22,0.5,0.5,0.5s0.5-0.22,0.5-0.5S10.78,17,10.5,17z M18.85,7.73c0.62-0.61,1-1.45,1-2.38c0-1.51-1-2.79-2.38-3.21 C16.99,2,16.5,2.36,16.5,2.86c0,0.33,0.21,0.62,0.52,0.71c0.77,0.23,1.33,0.94,1.33,1.78c0,0.82-0.53,1.51-1.27,1.76 C16.75,7.22,16.5,7.5,16.5,7.85V8c0,0.37,0.27,0.69,0.64,0.75c1.93,0.31,3.36,2,3.36,4.02v1.48c0,0.41,0.34,0.75,0.75,0.75 S22,14.66,22,14.25v-1.49C22,10.54,20.72,8.62,18.85,7.73z M18.76,15c0.41,0,0.75-0.33,0.75-0.75v-0.89 c-0.01-1.81-1.61-3.16-3.48-3.16h-1.3c-1.02,0-1.94-0.73-2.07-1.75c-0.12-0.95,0.46-1.7,1.3-1.93c0.32-0.09,0.54-0.38,0.54-0.72 c0-0.49-0.46-0.86-0.93-0.72c-1.42,0.41-2.45,1.73-2.42,3.28c0.03,1.84,1.62,3.29,3.46,3.29h1.42c1.05,0,1.97,0.74,1.97,2.05v0.55 C18,14.66,18.34,15,18.76,15z M3,18.5c1.33,0,2.71,0.18,4,0.5v-3c-1.29,0.32-2.67,0.5-4,0.5c-0.55,0-1,0.45-1,1S2.45,18.5,3,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 fitness-center
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.57 14.86l.72-.72c.39-.39.39-1.02 0-1.41l-.02-.02c-.39-.39-1.02-.39-1.41 0L17 15.57 8.43 7l2.86-2.86c.39-.39.39-1.02 0-1.41l-.02-.02c-.39-.39-1.02-.39-1.41 0l-.72.72-.72-.72c-.39-.39-1.03-.39-1.42 0L5.57 4.14l-.72-.72c-.39-.39-1.04-.39-1.43 0-.39.39-.39 1.04 0 1.43l.72.72L2.71 7c-.39.39-.39 1.02 0 1.41l.72.72-.72.73c-.39.39-.39 1.02 0 1.41l.02.02c.39.39 1.02.39 1.41 0L7 8.43 15.57 17l-2.86 2.86c-.39.39-.39 1.02 0 1.41l.02.02c.39.39 1.02.39 1.41 0l.72-.72.72.72c.39.39 1.02.39 1.41 0l1.43-1.43.72.72c.39.39 1.04.39 1.43 0 .39-.39.39-1.04 0-1.43l-.72-.72L21.29 17c.39-.39.39-1.02 0-1.41l-.72-.73z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-forward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 13h11.17l-4.88 4.88c-.39.39-.39 1.03 0 1.42.39.39 1.02.39 1.41 0l6.59-6.59c.39-.39.39-1.02 0-1.41l-6.58-6.6c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L16.17 11H5c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subdirectory-arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 24H0V0h24v24z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.29 15.71l-4.58 4.58c-.39.39-1.03.39-1.42 0-.39-.39-.39-1.03 0-1.42L15.17 16H5c-.55 0-1-.45-1-1V5c0-.55.45-1 1-1s1 .45 1 1v9h9.17l-2.88-2.87c-.39-.39-.39-1.03 0-1.42.39-.39 1.03-.39 1.42 0l4.58 4.58c.39.39.39 1.03 0 1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 cancel
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm4.3 14.3c-.39.39-1.02.39-1.41 0L12 13.41 9.11 16.3c-.39.39-1.02.39-1.41 0-.39-.39-.39-1.02 0-1.41L10.59 12 7.7 9.11c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L12 10.59l2.89-2.89c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41L13.41 12l2.89 2.89c.38.38.38 1.02 0 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 expand-less
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.29 8.71L6.7 13.3c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 10.83l3.88 3.88c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L12.7 8.71c-.38-.39-1.02-.39-1.41 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 payments
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path
    {:fill "none",
     :d
     "M0 0v24h24V0H0zm1 13V7c0-1.66 1.34-3 3-3h12c1.66 0 3 1.34 3 3v7c0 1.1-.9 2-2 2H4c-1.66 0-3-1.34-3-3zm22 5c0 1.1-.9 2-2 2H5c-.55 0-1-.45-1-1s.45-1 1-1h16V8c0-.55.45-1 1-1s1 .45 1 1v10z",
     :stroke nil})
   (helix.dom/path
    {:d
     "M23 8v10c0 1.1-.9 2-2 2H5c-.55 0-1-.45-1-1s.45-1 1-1h16V8c0-.55.45-1 1-1s1 .45 1 1zM4 16c-1.66 0-3-1.34-3-3V7c0-1.66 1.34-3 3-3h12c1.66 0 3 1.34 3 3v7c0 1.1-.9 2-2 2H4zm3-6c0 1.66 1.34 3 3 3s3-1.34 3-3-1.34-3-3-3-3 1.34-3 3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-drop-down
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.71 11.71l2.59 2.59c.39.39 1.02.39 1.41 0l2.59-2.59c.63-.63.18-1.71-.71-1.71H9.41c-.89 0-1.33 1.08-.7 1.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-downward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 5v11.17l-4.88-4.88c-.39-.39-1.03-.39-1.42 0-.39.39-.39 1.02 0 1.41l6.59 6.59c.39.39 1.02.39 1.41 0l6.59-6.59c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0L13 16.17V5c0-.55-.45-1-1-1s-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unfold-less
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.12 19.3c.39.39 1.02.39 1.41 0L12 16.83l2.47 2.47c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41l-3.17-3.17c-.39-.39-1.02-.39-1.41 0l-3.17 3.17c-.4.38-.4 1.02-.01 1.41zm7.76-14.6c-.39-.39-1.02-.39-1.41 0L12 7.17 9.53 4.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.03 0 1.42l3.17 3.17c.39.39 1.02.39 1.41 0l3.17-3.17c.4-.39.4-1.03.01-1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 close
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.3 5.71c-.39-.39-1.02-.39-1.41 0L12 10.59 7.11 5.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L10.59 12 5.7 16.89c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 13.41l4.89 4.89c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L13.41 12l4.89-4.89c.38-.38.38-1.02 0-1.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 last-page
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.29 8.11L10.18 12l-3.89 3.89c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0l4.59-4.59c.39-.39.39-1.02 0-1.41L7.7 6.7c-.39-.39-1.02-.39-1.41 0-.38.39-.38 1.03 0 1.41zM17 6c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1s-1-.45-1-1V7c0-.55.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 north
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M5.71,9.7L5.71,9.7c0.39,0.39,1.02,0.39,1.41,0L11,5.83V21c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V5.83l3.88,3.88 c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L12.7,2.7c-0.39-0.39-1.02-0.39-1.41,0L5.71,8.29 C5.32,8.68,5.32,9.32,5.71,9.7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 maps-home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.16,10.4l-5-3.57c-0.7-0.5-1.63-0.5-2.32,0l-5,3.57C1.31,10.78,1,11.38,1,12.03V20c0,0.55,0.45,1,1,1h4v-6h4v6h4 c0.55,0,1-0.45,1-1v-7.97C15,11.38,14.69,10.78,14.16,10.4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.03,3h-9.06C10.88,3,10,3.88,10,4.97l0.09,0.09c0.08,0.05,0.16,0.09,0.24,0.14l5,3.57c0.76,0.54,1.3,1.34,1.54,2.23H19 v2h-2v2h2v2h-2v3v1h4.03c1.09,0,1.97-0.88,1.97-1.97V4.97C23,3.88,22.12,3,21.03,3z M19,9h-2V7h2V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 pivot-table-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M21,5c0-1.1-0.9-2-2-2h-9v5h11V5z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M3,19c0,1.1,0.9,2,2,2h3V10H3V19z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d "M3,5v3h5V3H5C3.9,3,3,3.9,3,5z", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M17.65,9.35l-2.79,2.79C14.54,12.46,14.76,13,15.21,13H17v2c0,1.1-0.9,2-2,2h-2v-1.79c0-0.45-0.54-0.67-0.85-0.35 l-2.79,2.79c-0.2,0.2-0.2,0.51,0,0.71l2.79,2.79c0.31,0.31,0.85,0.09,0.85-0.35V19h2c2.21,0,4-1.79,4-4v-2h1.79 c0.45,0,0.67-0.54,0.35-0.85l-2.79-2.79C18.16,9.16,17.84,9.16,17.65,9.35z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 arrow-drop-up
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8.71 12.29L11.3 9.7c.39-.39 1.02-.39 1.41 0l2.59 2.59c.63.63.18 1.71-.71 1.71H9.41c-.89 0-1.33-1.08-.7-1.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fullscreen-exit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 16h2v2c0 .55.45 1 1 1s1-.45 1-1v-3c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1s.45 1 1 1zm2-8H6c-.55 0-1 .45-1 1s.45 1 1 1h3c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1s-1 .45-1 1v2zm7 11c.55 0 1-.45 1-1v-2h2c.55 0 1-.45 1-1s-.45-1-1-1h-3c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1zm1-11V6c0-.55-.45-1-1-1s-1 .45-1 1v3c0 .55.45 1 1 1h3c.55 0 1-.45 1-1s-.45-1-1-1h-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 subdirectory-arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.71 15.71l4.58 4.58c.39.39 1.03.39 1.42 0 .39-.39.39-1.03 0-1.42L8.83 16H19c.55 0 1-.45 1-1V5c0-.55-.45-1-1-1s-1 .45-1 1v9H8.83l2.88-2.87c.39-.39.39-1.03 0-1.42-.39-.39-1.03-.39-1.42 0l-4.58 4.58c-.39.39-.39 1.03 0 1.42z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 refresh
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.65 6.35c-1.63-1.63-3.94-2.57-6.48-2.31-3.67.37-6.69 3.35-7.1 7.02C3.52 15.91 7.27 20 12 20c3.19 0 5.93-1.87 7.21-4.56.32-.67-.16-1.44-.9-1.44-.37 0-.72.2-.88.53-1.13 2.43-3.84 3.97-6.8 3.31-2.22-.49-4.01-2.3-4.48-4.52C5.31 9.44 8.26 6 12 6c1.66 0 3.14.69 4.22 1.78l-1.51 1.51c-.63.63-.19 1.71.7 1.71H19c.55 0 1-.45 1-1V6.41c0-.89-1.08-1.34-1.71-.71l-.64.65z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 apps-outage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6,8c1.1,0,2-0.9,2-2S7.1,4,6,4S4,4.9,4,6S4.9,8,6,8z M12,20c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S10.9,20,12,20z M6,20 c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S4.9,20,6,20z M6,14c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S4.9,14,6,14z M12,14 c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S10.9,14,12,14z M12.07,4C12.05,4,12.02,4,12,4c-1.1,0-2,0.9-2,2s0.9,2,2,2 c0.22,0,0.43-0.04,0.63-0.1C12.22,7.01,12,6.03,12,5C12,4.66,12.02,4.33,12.07,4z M19,12c-1.03,0-2.01-0.22-2.9-0.63 C16.04,11.57,16,11.78,16,12c0,1.1,0.9,2,2,2s2-0.9,2-2c0-0.02,0-0.05,0-0.07C19.67,11.98,19.34,12,19,12z M18,20c1.1,0,2-0.9,2-2 s-0.9-2-2-2s-2,0.9-2,2S16.9,20,18,20z M19,0c-2.76,0-5,2.24-5,5s2.24,5,5,5s5-2.24,5-5S21.76,0,19,0z M19.5,7.5 C19.5,7.78,19.28,8,19,8c-0.27,0-0.5-0.22-0.5-0.5S18.72,7,19,7S19.5,7.22,19.5,7.5z M19,6c-0.28,0-0.5-0.22-0.5-0.5v-3 C18.5,2.22,18.72,2,19,2s0.5,0.22,0.5,0.5v3C19.5,5.78,19.28,6,19,6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 expand-more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 24H0V0h24v24z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.88 9.29L12 13.17 8.12 9.29c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l4.59 4.59c.39.39 1.02.39 1.41 0l4.59-4.59c.39-.39.39-1.02 0-1.41-.39-.38-1.03-.39-1.42 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 app-settings-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,18H7V6h10v1h2V3c0-1.1-0.9-2-2-2L7,1.01C5.9,1.01,5,1.9,5,3v18c0,1.1,0.9,2,2,2h10c1.1,0,2-0.9,2-2v-4h-2V18z M21,12 c0-0.13-0.02-0.26-0.04-0.39l0.64-0.48c0.2-0.15,0.26-0.44,0.13-0.66l-0.57-0.96c-0.13-0.21-0.39-0.3-0.62-0.2l-0.72,0.3 c-0.2-0.15-0.42-0.29-0.65-0.39l-0.1-0.77c-0.03-0.25-0.24-0.43-0.49-0.44l-1.12-0.02c-0.26,0-0.47,0.18-0.5,0.44l-0.1,0.79 c-0.24,0.1-0.45,0.23-0.65,0.39l-0.72-0.3c-0.23-0.1-0.5-0.01-0.62,0.2l-0.57,0.96c-0.13,0.22-0.08,0.5,0.13,0.66l0.64,0.48 C15.02,11.74,15,11.87,15,12c0,0.13,0.02,0.25,0.04,0.37l-0.64,0.49c-0.2,0.15-0.26,0.43-0.13,0.65l0.56,0.97 c0.13,0.22,0.39,0.31,0.63,0.21l0.73-0.31c0.2,0.16,0.42,0.3,0.67,0.4l0.1,0.77c0.03,0.25,0.24,0.44,0.5,0.44h1.12 c0.25,0,0.46-0.19,0.5-0.44l0.1-0.77c0.24-0.1,0.46-0.24,0.67-0.4l0.73,0.31c0.23,0.1,0.5,0.01,0.63-0.21l0.56-0.97 c0.13-0.22,0.07-0.5-0.13-0.65l-0.64-0.49C20.98,12.25,21,12.13,21,12z M18,13.5c-0.83,0-1.5-0.67-1.5-1.5s0.67-1.5,1.5-1.5 s1.5,0.67,1.5,1.5S18.83,13.5,18,13.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-drop-down-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-.35 12.65l-2.79-2.79c-.32-.32-.1-.86.35-.86h5.59c.45 0 .67.54.35.85l-2.79 2.79c-.2.2-.52.2-.71.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unfold-more
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5.83l2.46 2.46c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L12.7 3.7c-.39-.39-1.02-.39-1.41 0L8.12 6.88c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 5.83zm0 12.34l-2.46-2.46c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l3.17 3.18c.39.39 1.02.39 1.41 0l3.17-3.17c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0L12 18.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.96,11.7c-0.09-0.52-0.36-0.99-0.8-1.3l-5-3.57c-0.7-0.5-1.63-0.5-2.32,0l-5,3.57C1.31,10.78,1,11.38,1,12.03V19 c0,1.1,0.9,2,2,2h3v-6h4v6h1.68C11.25,20.09,11,19.08,11,18C11,15.22,12.62,12.83,14.96,11.7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M23,13.11V4.97C23,3.88,22.12,3,21.03,3h-9.06C10.88,3,10,3.88,10,4.97l0.02,0.05c0.1,0.06,0.21,0.11,0.3,0.18l5,3.57 c0.79,0.56,1.34,1.4,1.56,2.32C17.25,11.04,17.62,11,18,11C19.96,11,21.73,11.81,23,13.11z M17,7h2v2h-2V7z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M23,18c0-2.76-2.24-5-5-5s-5,2.24-5,5s2.24,5,5,5S23,20.76,23,18z M17.5,21v-2.5H15v-1h2.5V15h1v2.5H21v1h-2.5V21H17.5z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 offline-share
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M5,5L5,5C4.45,5,4,5.45,4,6v15c0,1.1,0.9,2,2,2h9c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H6V6C6,5.45,5.55,5,5,5z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M18,1h-8C8.9,1,8,1.9,8,3v14c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V3C20,1.9,19.1,1,18,1z M18,15h-8V5h8V15z",
       :stroke nil,
       :fill nil}))
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12.5,10.25h2v0.54c0,0.45,0.54,0.67,0.85,0.35l1.29-1.29c0.2-0.2,0.2-0.51,0-0.71l-1.29-1.29 c-0.31-0.31-0.85-0.09-0.85,0.35v0.54H12c-0.55,0-1,0.45-1,1v1.5c0,0.41,0.34,0.75,0.75,0.75h0c0.41,0,0.75-0.34,0.75-0.75V10.25 z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 arrow-forward-ios
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 24H0V0h24v24z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.38 21.01c.49.49 1.28.49 1.77 0l8.31-8.31c.39-.39.39-1.02 0-1.41L9.15 2.98c-.49-.49-1.28-.49-1.77 0s-.49 1.28 0 1.77L14.62 12l-7.25 7.25c-.48.48-.48 1.28.01 1.76z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 chevron-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.71 6.71c-.39-.39-1.02-.39-1.41 0L8.71 11.3c-.39.39-.39 1.02 0 1.41l4.59 4.59c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L10.83 12l3.88-3.88c.39-.39.38-1.03 0-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14.29,5.71L14.29,5.71c-0.39,0.39-0.39,1.02,0,1.41L18.17,11H3c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h15.18l-3.88,3.88 c-0.39,0.39-0.39,1.02,0,1.41l0,0c0.39,0.39,1.02,0.39,1.41,0l5.59-5.59c0.39-0.39,0.39-1.02,0-1.41L15.7,5.71 C15.32,5.32,14.68,5.32,14.29,5.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 legend-toggle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M19,15H5c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h14c0.55,0,1,0.45,1,1v0C20,14.55,19.55,15,19,15z M19,17H5 c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h14c0.55,0,1-0.45,1-1v0C20,17.45,19.55,17,19,17z M15,11l4.58-3.25 C19.84,7.56,20,7.26,20,6.94v0c0-0.81-0.92-1.29-1.58-0.82L15,8.55L10,5L4.48,8.36C4.18,8.55,4,8.87,4,9.22v0 c0,0.78,0.85,1.26,1.52,0.85l4.4-2.68L15,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 menu-open
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4,18h11c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H4c-0.55,0-1,0.45-1,1v0C3,17.55,3.45,18,4,18z M4,13h8c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H4c-0.55,0-1,0.45-1,1v0C3,12.55,3.45,13,4,13z M3,7L3,7c0,0.55,0.45,1,1,1h11c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1H4C3.45,6,3,6.45,3,7z M20.3,14.88L17.42,12l2.88-2.88c0.39-0.39,0.39-1.02,0-1.41l0,0 c-0.39-0.39-1.02-0.39-1.41,0l-3.59,3.59c-0.39,0.39-0.39,1.02,0,1.41l3.59,3.59c0.39,0.39,1.02,0.39,1.41,0l0,0 C20.68,15.91,20.69,15.27,20.3,14.88z",
    :stroke nil,
    :fill nil})
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})))


(helix.core/defnc
 switch-left
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M8.5,8.62v6.76L5.12,12L8.5,8.62 M3.71,11.29c-0.39,0.39-0.39,1.02,0,1.41l4.59,4.59C8.92,17.92,10,17.48,10,16.59V7.41 c0-0.89-1.08-1.34-1.71-0.71L3.71,11.29z M14,7.41v9.17c0,0.89,1.08,1.34,1.71,0.71l4.59-4.59c0.39-0.39,0.39-1.02,0-1.41 l-4.59-4.59C15.08,6.08,14,6.52,14,7.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-right
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24",
    :transform "matrix(-1 -1.224647e-16 1.224647e-16 -1 24 24)",
    :height "24",
    :fill "none",
    :stroke nil})
  (helix.dom/path
   {:d
    "M15.5,15.38V8.62L18.88,12L15.5,15.38 M20.29,12.71c0.39-0.39,0.39-1.02,0-1.41l-4.59-4.59C15.08,6.08,14,6.52,14,7.41v9.17 c0,0.89,1.08,1.34,1.71,0.71L20.29,12.71z M10,16.59V7.41c0-0.89-1.08-1.34-1.71-0.71l-4.59,4.59c-0.39,0.39-0.39,1.02,0,1.41 l4.59,4.59C8.92,17.92,10,17.48,10,16.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 double-arrow
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.08,11.42l-4.04-5.65C15.7,5.29,15.15,5,14.56,5h0c-1.49,0-2.35,1.68-1.49,2.89L16,12l-2.93,4.11 c-0.87,1.21,0,2.89,1.49,2.89h0c0.59,0,1.15-0.29,1.49-0.77l4.04-5.65C20.33,12.23,20.33,11.77,20.08,11.42z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13.08,11.42L9.05,5.77C8.7,5.29,8.15,5,7.56,5h0C6.07,5,5.2,6.68,6.07,7.89L9,12l-2.93,4.11C5.2,17.32,6.07,19,7.56,19h0 c0.59,0,1.15-0.29,1.49-0.77l4.04-5.65C13.33,12.23,13.33,11.77,13.08,11.42z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 home-work
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.16,10.4l-5-3.57c-0.7-0.5-1.63-0.5-2.32,0l-5,3.57C1.31,10.78,1,11.38,1,12.03V20c0,0.55,0.45,1,1,1h4v-6h4v6h4 c0.55,0,1-0.45,1-1v-7.97C15,11.38,14.69,10.78,14.16,10.4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.03,3h-9.06C10.88,3,10,3.88,10,4.97l0.09,0.09c0.08,0.05,0.16,0.09,0.24,0.14l5,3.57c0.76,0.54,1.3,1.34,1.54,2.23H19 v2h-2v2h2v2h-2v3v1h4.03c1.09,0,1.97-0.88,1.97-1.97V4.97C23,3.88,22.12,3,21.03,3z M19,9h-2V7h2V9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 north-east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M9,6L9,6c0,0.56,0.45,1,1,1h5.59L4.7,17.89c-0.39,0.39-0.39,1.02,0,1.41h0c0.39,0.39,1.02,0.39,1.41,0L17,8.41V14 c0,0.55,0.45,1,1,1H18c0.55,0,1-0.45,1-1V6c0-0.55-0.45-1-1-1H10C9.45,5,9,5.45,9,6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 11H7.83l4.88-4.88c.39-.39.39-1.03 0-1.42-.39-.39-1.02-.39-1.41 0l-6.59 6.59c-.39.39-.39 1.02 0 1.41l6.59 6.59c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L7.83 13H19c.55 0 1-.45 1-1s-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back-ios
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.62 2.99c-.49-.49-1.28-.49-1.77 0L6.54 11.3c-.39.39-.39 1.02 0 1.41l8.31 8.31c.49.49 1.28.49 1.77 0s.49-1.28 0-1.77L9.38 12l7.25-7.25c.48-.48.48-1.28-.01-1.76z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 menu
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 18h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1zm0-5h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1zM3 7c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 campaign
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/path
   {:d
    "M18,12L18,12c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-2C18.45,11,18,11.45,18,12z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16.59,16.82c-0.33,0.44-0.24,1.05,0.2,1.37c0.53,0.39,1.09,0.81,1.62,1.21c0.44,0.33,1.06,0.24,1.38-0.2 c0-0.01,0.01-0.01,0.01-0.02c0.33-0.44,0.24-1.06-0.2-1.38c-0.53-0.4-1.09-0.82-1.61-1.21c-0.44-0.33-1.06-0.23-1.39,0.21 C16.6,16.81,16.59,16.82,16.59,16.82z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M19.81,4.81c0-0.01-0.01-0.01-0.01-0.02c-0.33-0.44-0.95-0.53-1.38-0.2c-0.53,0.4-1.1,0.82-1.62,1.22 c-0.44,0.33-0.52,0.95-0.19,1.38c0,0.01,0.01,0.01,0.01,0.02c0.33,0.44,0.94,0.53,1.38,0.2c0.53-0.39,1.09-0.82,1.62-1.22 C20.05,5.87,20.13,5.25,19.81,4.81z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M8,9H4c-1.1,0-2,0.9-2,2v2c0,1.1,0.9,2,2,2h1v3c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-3h1l5,3V6L8,9z",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M15.5,12c0-1.33-0.58-2.53-1.5-3.35v6.69C14.92,14.53,15.5,13.33,15.5,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 south
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18.3,14.29L18.3,14.29c-0.39-0.39-1.02-0.39-1.41,0L13,18.17V3c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v15.18l-3.88-3.88 c-0.39-0.39-1.02-0.39-1.41,0l0,0c-0.39,0.39-0.39,1.02,0,1.41l5.59,5.59c0.39,0.39,1.02,0.39,1.41,0l5.59-5.59 C18.68,15.32,18.68,14.68,18.3,14.29z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 south-west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M15,18L15,18c0-0.56-0.45-1-1-1H8.41L19.3,6.11c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L7,15.59V10 c0-0.55-0.45-1-1-1H6c-0.55,0-1,0.45-1,1V18c0,0.55,0.45,1,1,1H14C14.55,19,15,18.55,15,18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more-horiz
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 10c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-6 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 waterfall-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.5,4L19.5,4C20.33,4,21,4.67,21,5.5v13c0,0.83-0.67,1.5-1.5,1.5h0c-0.83,0-1.5-0.67-1.5-1.5v-13 C18,4.67,18.67,4,19.5,4z M4.5,13L4.5,13C5.33,13,6,13.67,6,14.5v4C6,19.33,5.33,20,4.5,20h0C3.67,20,3,19.33,3,18.5v-4 C3,13.67,3.67,13,4.5,13z M15.5,4L15.5,4C16.33,4,17,4.67,17,5.5v0C17,6.33,16.33,7,15.5,7h0C14.67,7,14,6.33,14,5.5v0 C14,4.67,14.67,4,15.5,4z M11.5,5L11.5,5C12.33,5,13,5.67,13,6.5v1C13,8.33,12.33,9,11.5,9h0C10.67,9,10,8.33,10,7.5v-1 C10,5.67,10.67,5,11.5,5z M8.5,10L8.5,10c0.83,0,1.5,0.67,1.5,1.5v1c0,0.83-0.67,1.5-1.5,1.5h0C7.67,14,7,13.33,7,12.5v-1 C7,10.67,7.67,10,8.5,10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 expand-circle-down
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M15.79,11.71l-3.08,3.08 c-0.39,0.39-1.02,0.39-1.42,0l-3.08-3.08c-0.39-0.39-0.39-1.03,0-1.42c0.39-0.39,1.02-0.39,1.41,0L12,12.67l2.38-2.38 c0.39-0.39,1.02-0.39,1.41,0C16.18,10.68,16.18,11.32,15.79,11.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant-direction
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13.5,10H9c-0.55,0-1,0.45-1,1v3c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2h3.5v1.29c0,0.45,0.54,0.67,0.85,0.35 l2.29-2.29c0.2-0.2,0.2-0.51,0-0.71l-2.29-2.29c-0.31-0.31-0.85-0.09-0.85,0.35V10z M12,1C5.9,1,1,5.9,1,12s4.9,11,11,11 s11-4.9,11-11S18.1,1,12,1z M19.73,12.58l-7.19,7.22c-0.35,0.27-0.79,0.27-1.15,0L4.2,12.58c-0.27-0.36-0.27-0.8,0-1.16l7.19-7.22 c0.35-0.27,0.79-0.27,1.15,0l7.19,7.22C20.09,11.69,20.09,12.22,19.73,12.58z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M9.7,18.3L9.7,18.3c0.39-0.39,0.39-1.02,0-1.41L5.83,13H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H5.83l3.88-3.88 c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0L2.7,11.3c-0.39,0.39-0.39,1.02,0,1.41l5.59,5.59 C8.68,18.68,9.32,18.68,9.7,18.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fullscreen
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 14c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1h3c.55 0 1-.45 1-1s-.45-1-1-1H7v-2c0-.55-.45-1-1-1zm0-4c.55 0 1-.45 1-1V7h2c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1zm11 7h-2c-.55 0-1 .45-1 1s.45 1 1 1h3c.55 0 1-.45 1-1v-3c0-.55-.45-1-1-1s-1 .45-1 1v2zM14 6c0 .55.45 1 1 1h2v2c0 .55.45 1 1 1s1-.45 1-1V6c0-.55-.45-1-1-1h-3c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 check
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 16.17L5.53 12.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l4.18 4.18c.39.39 1.02.39 1.41 0L20.29 7.71c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0L9 16.17z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 apps
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 8h4V4H4v4zm6 12h4v-4h-4v4zm-6 0h4v-4H4v4zm0-6h4v-4H4v4zm6 0h4v-4h-4v4zm6-10v4h4V4h-4zm-6 4h4V4h-4v4zm6 6h4v-4h-4v4zm0 6h4v-4h-4v4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-upward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 19V7.83l4.88 4.88c.39.39 1.03.39 1.42 0 .39-.39.39-1.02 0-1.41l-6.59-6.59c-.39-.39-1.02-.39-1.41 0l-6.6 6.58c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L11 7.83V19c0 .55.45 1 1 1s1-.45 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 more-vert
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm0 2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 6c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.29 8.71L9.7 11.3c-.39.39-.39 1.02 0 1.41l2.59 2.59c.63.63 1.71.18 1.71-.71V9.41c0-.89-1.08-1.33-1.71-.7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 south-east
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,9L18,9c-0.56,0-1,0.45-1,1v5.59L6.12,4.7c-0.39-0.39-1.02-0.39-1.41,0l0,0c-0.39,0.39-0.39,1.02,0,1.41L15.59,17H10 c-0.55,0-1,0.45-1,1V18c0,0.55,0.45,1,1,1H18c0.55,0,1-0.45,1-1V10C19,9.45,18.55,9,18,9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 north-west
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6,15L6,15c0.56,0,1-0.45,1-1V8.41L17.89,19.3c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L8.41,7H14 c0.55,0,1-0.45,1-1V6c0-0.55-0.45-1-1-1H6C5.45,5,5,5.45,5,6V14C5,14.55,5.45,15,6,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 first-page
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M24 0v24H0V0h24z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.7 15.89L13.82 12l3.89-3.89c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0l-4.59 4.59c-.39.39-.39 1.02 0 1.41l4.59 4.59c.39.39 1.02.39 1.41 0 .38-.38.38-1.02-.01-1.4zM7 6c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1s-1-.45-1-1V7c0-.55.45-1 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 arrow-back-ios-new
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16.88,2.88L16.88,2.88c-0.49-0.49-1.28-0.49-1.77,0l-8.41,8.41c-0.39,0.39-0.39,1.02,0,1.41l8.41,8.41 c0.49,0.49,1.28,0.49,1.77,0l0,0c0.49-0.49,0.49-1.28,0-1.77L9.54,12l7.35-7.35C17.37,4.16,17.37,3.37,16.88,2.88z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 arrow-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.71 15.29l2.59-2.59c.39-.39.39-1.02 0-1.41L11.71 8.7c-.63-.62-1.71-.18-1.71.71v5.17c0 .9 1.08 1.34 1.71.71z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 chevron-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.29 6.71c-.39.39-.39 1.02 0 1.41L13.17 12l-3.88 3.88c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0l4.59-4.59c.39-.39.39-1.02 0-1.41L10.7 6.7c-.38-.38-1.02-.38-1.41.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 biotech
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M7,19c-1.1,0-2,0.9-2,2h14c0-1.1-0.9-2-2-2h-4v-2h3c1.1,0,2-0.9,2-2h-8c-1.66,0-3-1.34-3-3c0-1.09,0.59-2.04,1.46-2.56 C8.17,9.03,8,8.54,8,8c0-0.21,0.04-0.42,0.09-0.62C6.28,8.13,5,9.92,5,12c0,2.76,2.24,5,5,5v2H7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.56,5.51C11.91,5.54,13,6.64,13,8c0,0.75-0.33,1.41-0.85,1.87l0.25,0.68c0.19,0.52,0.76,0.79,1.28,0.6 c0.19,0.52,0.76,0.79,1.28,0.6c0.52-0.19,0.79-0.76,0.6-1.28c0.52-0.19,0.79-0.76,0.6-1.28L14.1,3.54 c-0.19-0.52-0.76-0.79-1.28-0.6c-0.19-0.52-0.76-0.79-1.28-0.6c-0.52,0.19-0.79,0.76-0.6,1.28c-0.52,0.19-0.79,0.76-0.6,1.28 L10.56,5.51z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "8", :cx "10.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 insights
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,8c-1.45,0-2.26,1.44-1.93,2.51l-3.55,3.56c-0.3-0.09-0.74-0.09-1.04,0l-2.55-2.55C12.27,10.45,11.46,9,10,9 c-1.45,0-2.27,1.44-1.93,2.52l-4.56,4.55C2.44,15.74,1,16.55,1,18c0,1.1,0.9,2,2,2c1.45,0,2.26-1.44,1.93-2.51l4.55-4.56 c0.3,0.09,0.74,0.09,1.04,0l2.55,2.55C12.73,16.55,13.54,18,15,18c1.45,0,2.27-1.44,1.93-2.52l3.56-3.55 C21.56,12.26,23,11.45,23,10C23,8.9,22.1,8,21,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points
      "15,9 15.94,6.93 18,6 15.94,5.07 15,3 14.08,5.07 12,6 14.08,6.93",
      :stroke nil,
      :fill nil})
    (helix.dom/polygon
     {:points "3.5,11 4,9 6,8.5 4,8 3.5,6 3,8 1,8.5 3,9",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shield
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M11.3,2.26l-6,2.25C4.52,4.81,4,5.55,4,6.39v4.7c0,4.83,3.13,9.37,7.43,10.75c0.37,0.12,0.77,0.12,1.14,0 c4.3-1.38,7.43-5.91,7.43-10.75v-4.7c0-0.83-0.52-1.58-1.3-1.87l-6-2.25C12.25,2.09,11.75,2.09,11.3,2.26z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flag
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.4 6l-.24-1.2c-.09-.46-.5-.8-.98-.8H6c-.55 0-1 .45-1 1v15c0 .55.45 1 1 1s1-.45 1-1v-6h5.6l.24 1.2c.09.47.5.8.98.8H19c.55 0 1-.45 1-1V7c0-.55-.45-1-1-1h-4.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flag-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M17,15h-3.38 c-0.38,0-0.73-0.21-0.89-0.55L12,13H9.5v4.25C9.5,17.66,9.16,18,8.75,18h0C8.34,18,8,17.66,8,17.25V8c0-0.55,0.45-1,1-1h4.38 c0.38,0,0.73,0.21,0.89,0.55L15,9h2c0.55,0,1,0.45,1,1v4C18,14.55,17.55,15,17,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 save-as
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20.41,6.41l-2.83-2.83C17.21,3.21,16.7,3,16.17,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h7.4l8.6-8.6V7.83 C21,7.3,20.79,6.79,20.41,6.41z M12,18c-1.66,0-3-1.34-3-3s1.34-3,3-3s3,1.34,3,3S13.66,18,12,18z M15,9c0,0.55-0.45,1-1,1H7 c-0.55,0-1-0.45-1-1V7c0-0.55,0.45-1,1-1h7c0.55,0,1,0.45,1,1V9z M19.99,16.25l1.77,1.77l-4.84,4.84C16.82,22.95,16.69,23,16.56,23 H15.5c-0.28,0-0.5-0.22-0.5-0.5v-1.06c0-0.13,0.05-0.26,0.15-0.35L19.99,16.25z M23.25,16.51l-0.85,0.85l-1.77-1.77l0.85-0.85 c0.2-0.2,0.51-0.2,0.71,0l1.06,1.06C23.45,16,23.45,16.32,23.25,16.51z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 font-download
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.93 13.5h4.14L12 7.98 9.93 13.5zM20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-4.29 15.88l-.9-2.38H9.17l-.89 2.37c-.14.38-.5.63-.91.63-.68 0-1.15-.69-.9-1.32l4.25-10.81c.22-.53.72-.87 1.28-.87s1.06.34 1.27.87l4.25 10.81c.25.63-.22 1.32-.9 1.32-.4 0-.76-.25-.91-.62z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 copy-all
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,2H9C7.9,2,7,2.9,7,4v12c0,1.1,0.9,2,2,2h9c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2z M18,16H9V4h9V16z M3,15v-2h2v2H3z M3,9.5h2v2H3V9.5z M10,20h2v2h-2V20z M3,18.5v-2h2v2H3z M5,22c-1.1,0-2-0.9-2-2h2V22z M8.5,22h-2v-2h2V22z M13.5,22L13.5,22l0-2h2 v0C15.5,21.1,14.6,22,13.5,22z M5,6L5,6l0,2H3v0C3,6.9,3.9,6,5,6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 font-download-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12.58,9.75l-0.87-0.87l0.23-0.66h0.1L12.58,9.75z M10.35,7.52L10.55,7c0.23-0.6,0.8-1,1.45-1s1.22,0.4,1.45,1l2.17,5.79 L22,19.17V4c0-1.1-0.9-2-2-2H4.83L10.35,7.52z M21.19,22.61L21.19,22.61c-0.39,0.39-1.02,0.39-1.41,0L19.17,22H4c-1.1,0-2-0.9-2-2 V4.83L1.39,4.22C1,3.83,1,3.2,1.39,2.81l0,0c0.39-0.39,1.02-0.39,1.41,0l18.38,18.38C21.58,21.58,21.58,22.22,21.19,22.61z M12.1,14.93l-3.3-3.3L6.9,16.7C6.67,17.33,7.13,18,7.8,18h0.01c0.41,0,0.77-0.26,0.9-0.64l0.86-2.43H12.1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 13H6c-.55 0-1-.45-1-1s.45-1 1-1h12c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 7c-.55 0-1 .45-1 1v3H8c-.55 0-1 .45-1 1s.45 1 1 1h3v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1h-3V8c0-.55-.45-1-1-1zm0-5C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dynamic-feed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M7,8L7,8C6.45,8,6,8.45,6,9v6c0,1.1,0.9,2,2,2h8c0.55,0,1-0.45,1-1l0,0c0-0.55-0.45-1-1-1H8V9C8,8.45,7.55,8,7,8z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M20,3h-8c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2V5C22,3.9,21.1,3,20,3z M20,11h-8V7h8V11z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M3,12L3,12c-0.55,0-1,0.45-1,1v6c0,1.1,0.9,2,2,2h8c0.55,0,1-0.45,1-1l0,0c0-0.55-0.45-1-1-1H4v-6C4,12.45,3.55,12,3,12z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 select-all
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5h2V3c-1.1 0-2 .9-2 2zm0 8h2v-2H3v2zm4 8h2v-2H7v2zM3 9h2V7H3v2zm10-6h-2v2h2V3zm6 0v2h2c0-1.1-.9-2-2-2zM5 21v-2H3c0 1.1.9 2 2 2zm-2-4h2v-2H3v2zM9 3H7v2h2V3zm2 18h2v-2h-2v2zm8-8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2zm0-12h2V7h-2v2zm0 8h2v-2h-2v2zm-4 4h2v-2h-2v2zm0-16h2V3h-2v2zM8 17h8c.55 0 1-.45 1-1V8c0-.55-.45-1-1-1H8c-.55 0-1 .45-1 1v8c0 .55.45 1 1 1zm1-8h6v6H9V9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-copy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M15,20H5V7c0-0.55-0.45-1-1-1h0C3.45,6,3,6.45,3,7v13c0,1.1,0.9,2,2,2h10c0.55,0,1-0.45,1-1v0C16,20.45,15.55,20,15,20z M20,16V4c0-1.1-0.9-2-2-2H9C7.9,2,7,2.9,7,4v12c0,1.1,0.9,2,2,2h9C19.1,18,20,17.1,20,16z M18,16H9V4h9V16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 inbox
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,5v9h-3.56 c-0.36,0-0.68,0.19-0.86,0.5C14.06,15.4,13.11,16,12,16s-2.06-0.6-2.58-1.5C9.24,14.19,8.91,14,8.56,14H5V5H19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 weekend
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 10c-1.1 0-2 .9-2 2v3H5v-3c0-1.1-.9-2-2-2s-2 .9-2 2v5c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2v-5c0-1.1-.9-2-2-2zm-3-5H6c-1.1 0-2 .9-2 2v2.15c1.16.41 2 1.51 2 2.82V14h12v-2.03c0-1.3.84-2.4 2-2.82V7c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inventory-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,2H4C3,2,2,2.9,2,4v3.01C2,7.73,2.43,8.35,3,8.7V20c0,1.1,1.1,2,2,2h14c0.9,0,2-0.9,2-2V8.7c0.57-0.35,1-0.97,1-1.69V4 C22,2.9,21,2,20,2z M14,14h-4c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1v0C15,13.55,14.55,14,14,14z M20,7H4V4 h16V7z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 push-pin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:fill-rule "evenodd",
     :d
     "M19,12.87c0-0.47-0.34-0.85-0.8-0.98C16.93,11.54,16,10.38,16,9V4l1,0 c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1H7C6.45,2,6,2.45,6,3c0,0.55,0.45,1,1,1l1,0v5c0,1.38-0.93,2.54-2.2,2.89 C5.34,12.02,5,12.4,5,12.87V13c0,0.55,0.45,1,1,1h4.98L11,21c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1l-0.02-7H18c0.55,0,1-0.45,1-1 V12.87z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 calculate
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M13.56,6.53L13.56,6.53 c0.29-0.29,0.77-0.29,1.06,0l0.88,0.88l0.88-0.88c0.29-0.29,0.77-0.29,1.06,0l0,0c0.29,0.29,0.29,0.77,0,1.06l-0.88,0.88l0.88,0.88 c0.29,0.29,0.29,0.77,0,1.06v0c-0.29,0.29-0.77,0.29-1.06,0L15.5,9.54l-0.88,0.88c-0.29,0.29-0.77,0.29-1.06,0l0,0 c-0.29-0.29-0.29-0.77,0-1.06l0.88-0.88l-0.88-0.88C13.26,7.3,13.26,6.82,13.56,6.53z M7,7.72h3.5c0.41,0,0.75,0.34,0.75,0.75v0 c0,0.41-0.34,0.75-0.75,0.75H7c-0.41,0-0.75-0.34-0.75-0.75v0C6.25,8.06,6.59,7.72,7,7.72z M10.75,16H9.5v1.25 C9.5,17.66,9.16,18,8.75,18h0C8.34,18,8,17.66,8,17.25V16H6.75C6.34,16,6,15.66,6,15.25v0c0-0.41,0.34-0.75,0.75-0.75H8v-1.25 c0-0.41,0.34-0.75,0.75-0.75h0c0.41,0,0.75,0.34,0.75,0.75v1.25h1.25c0.41,0,0.75,0.34,0.75,0.75v0C11.5,15.66,11.16,16,10.75,16z M17.25,17.25h-3.5c-0.41,0-0.75-0.34-0.75-0.75l0,0c0-0.41,0.34-0.75,0.75-0.75h3.5c0.41,0,0.75,0.34,0.75,0.75l0,0 C18,16.91,17.66,17.25,17.25,17.25z M17.25,14.75h-3.5C13.34,14.75,13,14.41,13,14v0c0-0.41,0.34-0.75,0.75-0.75h3.5 c0.41,0,0.75,0.34,0.75,0.75v0C18,14.41,17.66,14.75,17.25,14.75z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 archive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.54 5.23l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.16.55L3.46 5.23C3.17 5.57 3 6.02 3 6.5V19c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.48-.17-.93-.46-1.27zm-8.89 11.92L6.5 12H10v-2h4v2h3.5l-5.15 5.15c-.19.19-.51.19-.7 0zM5.12 5l.81-1h12l.94 1H5.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sort
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 18h4c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1zM3 7c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1zm1 6h10c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 how-to-vote
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,12.18l-1.5,1.64l2,2.18h-13l2-2.18L6,12.18l-3,3.27V20c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2v-4.54L18,12.18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.59,14.42c0.78,0.79,2.05,0.8,2.84,0.01l4.98-4.98c0.78-0.78,0.78-2.05,0-2.83l-3.54-3.53c-0.78-0.78-2.05-0.78-2.83,0 L7.09,8.04c-0.78,0.78-0.78,2.03-0.01,2.82L10.59,14.42z M13.46,4.5l3.53,3.53l-4.94,4.94L8.52,9.44L13.46,4.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 how-to-reg
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 20l-.86-.86c-1.18-1.18-1.17-3.1.02-4.26l.84-.82c-.39-.04-.68-.06-1-.06-2.67 0-8 1.34-8 4v2h9zm-1-8c2.21 0 4-1.79 4-4s-1.79-4-4-4-4 1.79-4 4 1.79 4 4 4",
    :stroke nil,
    :fill nil})
  (helix.dom/path
   {:d
    "M16.18 19.78c-.39.39-1.03.39-1.42 0l-2.07-2.09c-.38-.39-.38-1.01 0-1.39l.01-.01c.39-.39 1.02-.39 1.4 0l1.37 1.37 4.43-4.46c.39-.39 1.02-.39 1.41 0l.01.01c.38.39.38 1.01 0 1.39l-5.14 5.18z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bolt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.67,21L10.67,21c-0.35,0-0.62-0.31-0.57-0.66L11,14H7.5c-0.88,0-0.33-0.75-0.31-0.78c1.26-2.23,3.15-5.53,5.65-9.93 c0.1-0.18,0.3-0.29,0.5-0.29h0c0.35,0,0.62,0.31,0.57,0.66L13.01,10h3.51c0.4,0,0.62,0.19,0.4,0.66c-3.29,5.74-5.2,9.09-5.75,10.05 C11.07,20.89,10.88,21,10.67,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 change-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M12.91,18.15 c-0.31,0.31-0.85,0.09-0.85-0.35v-0.8c-0.02,0-0.04,0-0.06,0c-1.28,0-2.56-0.49-3.54-1.46c-1.43-1.43-1.81-3.52-1.14-5.3 c0.19-0.51,0.86-0.64,1.24-0.25l0,0c0.22,0.22,0.27,0.54,0.17,0.82c-0.46,1.24-0.2,2.68,0.8,3.68c0.7,0.7,1.62,1.03,2.54,1.01v-0.94 c0-0.45,0.54-0.67,0.85-0.35l1.62,1.62c0.2,0.2,0.2,0.51,0,0.71L12.91,18.15z M15.44,14.02L15.44,14.02 c-0.22-0.22-0.27-0.54-0.17-0.82c0.46-1.24,0.2-2.68-0.8-3.68c-0.7-0.7-1.62-1.04-2.53-1.02c0,0,0,0,0,0v0.94 c0,0.45-0.54,0.67-0.85,0.35L9.46,8.18c-0.2-0.2-0.2-0.51,0-0.71l1.62-1.62c0.31-0.31,0.85-0.09,0.85,0.35v0.81 c1.3-0.02,2.61,0.45,3.6,1.45c1.43,1.43,1.81,3.52,1.14,5.3C16.48,14.28,15.82,14.41,15.44,14.02z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-cut
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.64 7.64c.29-.62.42-1.33.34-2.09-.19-1.73-1.54-3.2-3.26-3.49-2.77-.48-5.14 1.89-4.66 4.65.3 1.72 1.76 3.07 3.49 3.26.76.08 1.46-.05 2.09-.34L10 12l-2.36 2.36c-.62-.29-1.33-.42-2.09-.34-1.73.19-3.2 1.54-3.49 3.26-.48 2.77 1.89 5.13 4.65 4.65 1.72-.3 3.07-1.76 3.26-3.49.08-.76-.05-1.46-.34-2.09L12 14l7.59 7.59c.89.89 2.41.26 2.41-1v-.01c0-.37-.15-.73-.41-1L9.64 7.64zM6 8c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm0 12c-1.1 0-2-.89-2-2s.9-2 2-2 2 .89 2 2-.9 2-2 2zm6-7.5c-.28 0-.5-.22-.5-.5s.22-.5.5-.5.5.22.5.5-.22.5-.5.5zm7.59-10.09L13 9l2 2 6.59-6.59c.26-.26.41-.62.41-1V3.4c0-1.25-1.52-1.88-2.41-.99z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste-go
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5,5h2v1c0,1.1,0.9,2,2,2h6c1.1,0,2-0.9,2-2V5h2v6h2V5c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5 C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h5v-2H5V5z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.29,16.29l-2.58-2.58c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41l0.87,0.88H13c-0.55,0-1,0.45-1,1 c0,0.55,0.45,1,1,1h5.17l-0.87,0.88c-0.39,0.39-0.39,1.02,0,1.41v0c0.39,0.39,1.02,0.39,1.41,0l2.58-2.58 C21.68,17.31,21.68,16.68,21.29,16.29z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 redo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.4 10.6C16.55 8.99 14.15 8 11.5 8c-4.16 0-7.74 2.42-9.44 5.93-.32.67.04 1.47.75 1.71.59.2 1.23-.08 1.5-.64 1.3-2.66 4.03-4.5 7.19-4.5 1.95 0 3.73.72 5.12 1.88l-1.91 1.91c-.63.63-.19 1.71.7 1.71H21c.55 0 1-.45 1-1V9.41c0-.89-1.08-1.34-1.71-.71l-1.89 1.9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-list
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 18h2c.55 0 1-.45 1-1s-.45-1-1-1h-2c-.55 0-1 .45-1 1s.45 1 1 1zM3 7c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1zm4 6h10c.55 0 1-.45 1-1s-.45-1-1-1H7c-.55 0-1 .45-1 1s.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mail
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-.4 4.25l-6.54 4.09c-.65.41-1.47.41-2.12 0L4.4 8.25c-.25-.16-.4-.43-.4-.72 0-.67.73-1.07 1.3-.72L12 11l6.7-4.19c.57-.35 1.3.05 1.3.72 0 .29-.15.56-.4.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 drafts
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21.99 8c0-.72-.37-1.35-.94-1.7l-8.04-4.71c-.62-.37-1.4-.37-2.02 0L2.95 6.3C2.38 6.65 2 7.28 2 8v10c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2l-.01-10zm-11.05 4.34l-7.2-4.5 7.25-4.25c.62-.37 1.4-.37 2.02 0l7.25 4.25-7.2 4.5c-.65.4-1.47.4-2.12 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 link-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,9h2.87c1.46,0,2.8,0.98,3.08,2.42c0.31,1.64-0.74,3.11-2.22,3.48l1.53,1.53c1.77-0.91,2.95-2.82,2.7-5.01 C21.68,8.86,19.37,7,16.79,7H14c-0.55,0-1,0.45-1,1C13,8.55,13.45,9,14,9z M3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0 c-0.39,0.39-0.39,1.02,0,1.41l2.64,2.64c-1.77,0.91-2.95,2.82-2.7,5.01C2.32,15.14,4.63,17,7.21,17H10c0.55,0,1-0.45,1-1 c0-0.55-0.45-1-1-1H7.13c-1.46,0-2.8-0.98-3.08-2.42C3.74,10.94,4.8,9.47,6.27,9.1l2.12,2.12C8.16,11.41,8,11.68,8,12 c0,0.55,0.45,1,1,1h1.17l8.9,8.9c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51z M14,11l1.71,1.71 C15.89,12.53,16,12.28,16,12c0-0.55-0.45-1-1-1H14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 content-paste
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 2h-4.18C14.4.84 13.3 0 12 0S9.6.84 9.18 2H5c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-7 0c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm6 18H6c-.55 0-1-.45-1-1V5c0-.55.45-1 1-1h1v1c0 1.1.9 2 2 2h6c1.1 0 2-.9 2-2V4h1c.55 0 1 .45 1 1v14c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stream
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "12", :cx "20", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "2", :cy "12", :cx "4", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "2", :cy "20", :cx "12", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M7.89,14.65l-2.94,2.93c-0.39,0.39-0.39,1.02,0,1.41s1.02,0.39,1.41,0l2.94-2.93c0.39-0.38,0.39-1.02,0-1.41 C8.91,14.26,8.28,14.26,7.89,14.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M6.41,4.94C6.02,4.55,5.39,4.55,5,4.94C4.61,5.33,4.61,5.96,5,6.35l2.93,2.94c0.39,0.39,1.02,0.39,1.42,0 C9.73,8.9,9.73,8.27,9.34,7.88L6.41,4.94z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.12,14.65c-0.39-0.39-1.02-0.39-1.42,0c-0.39,0.39-0.39,1.02,0,1.41L17.64,19c0.39,0.39,1.02,0.39,1.41,0 s0.39-1.02,0-1.41L16.12,14.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.06,9.33l2.99-2.98c0.39-0.4,0.39-1.03,0-1.42c-0.39-0.39-1.02-0.39-1.41,0l-2.99,2.98c-0.39,0.39-0.39,1.02,0,1.42 C15.04,9.72,15.67,9.72,16.06,9.33z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 remove-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4 11H8c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-circle-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 12c0 .55.45 1 1 1h8c.55 0 1-.45 1-1s-.45-1-1-1H8c-.55 0-1 .45-1 1zm5-10C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 amp-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16,4H8C7.45,4,7,4.45,7,5v13c0,0.55,0.45,1,1,1h8c0.55,0,1-0.45,1-1V5C17,4.45,16.55,4,16,4z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,6C3.45,6,3,6.45,3,7v9c0,0.55,0.45,1,1,1s1-0.45,1-1V7C5,6.45,4.55,6,4,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,6c-0.55,0-1,0.45-1,1v9c0,0.55,0.45,1,1,1s1-0.45,1-1V7C21,6.45,20.55,6,20,6z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 deselect
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M3,13h2v-2H3V13z M7,21h2v-2H7V21z M13,3h-2v2h2V3z M19,3v2h2C21,3.9,20.1,3,19,3z M5,21v-2H3C3,20.1,3.9,21,5,21z M3,17h2 v-2H3V17z M11,21h2v-2h-2V21z M19,13h2v-2h-2V13z M19,9h2V7h-2V9z M15,5h2V3h-2V5z M7.83,5L7,4.17V3h2v2H7.83z M19.83,17L19,16.17 V15h2v2H19.83z M9,15v-3.17L12.17,15H9z M2.1,3.51c-0.39,0.39-0.39,1.02,0,1.41L4.17,7H3v2h2V7.83l2,2V16c0,0.55,0.45,1,1,1h6.17 l2,2H15v2h2v-1.17l2.07,2.07c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51C3.12,3.12,2.49,3.12,2.1,3.51z M17,8c0-0.55-0.45-1-1-1H9.83l2,2H15v3.17l2,2V8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 undo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.5 8c-2.65 0-5.05.99-6.9 2.6L3.71 8.71C3.08 8.08 2 8.52 2 9.41V15c0 .55.45 1 1 1h5.59c.89 0 1.34-1.08.71-1.71l-1.91-1.91c1.39-1.16 3.16-1.88 5.12-1.88 3.16 0 5.89 1.84 7.19 4.5.27.56.91.84 1.5.64.71-.23 1.07-1.04.75-1.72C20.23 10.42 16.65 8 12.5 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 content-paste-search
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5,5h2v1c0,1.1,0.9,2,2,2h6c1.1,0,2-0.9,2-2V5h2v5h2V5c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5 C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h5v-2H5V5z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22.3,20.9l-2-2c0.58-1.01,0.95-2.23,0.51-3.65c-0.53-1.72-2.04-3.05-3.84-3.22c-2.87-0.28-5.23,2.07-4.95,4.95 c0.18,1.79,1.5,3.31,3.22,3.84c1.43,0.44,2.64,0.07,3.65-0.51l2,2c0.39,0.39,1.01,0.39,1.4,0S22.69,21.29,22.3,20.9z M16.5,19 c-1.4,0-2.5-1.1-2.5-2.5c0-1.4,1.1-2.5,2.5-2.5s2.5,1.1,2.5,2.5C19,17.9,17.9,19,16.5,19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 file-copy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 1H4c-1.1 0-2 .9-2 2v13c0 .55.45 1 1 1s1-.45 1-1V4c0-.55.45-1 1-1h10c.55 0 1-.45 1-1s-.45-1-1-1zm.59 4.59l4.83 4.83c.37.37.58.88.58 1.41V21c0 1.1-.9 2-2 2H7.99C6.89 23 6 22.1 6 21l.01-14c0-1.1.89-2 1.99-2h6.17c.53 0 1.04.21 1.42.59zM15 12h4.5L14 6.5V11c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 text-format
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 18c0 .55.45 1 1 1h12c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1 .45-1 1zm4.5-5.2h5l.66 1.6c.15.36.5.6.89.6.69 0 1.15-.71.88-1.34l-3.88-8.97C12.87 4.27 12.46 4 12 4c-.46 0-.87.27-1.05.69l-3.88 8.97c-.27.63.2 1.34.89 1.34.39 0 .74-.24.89-.6l.65-1.6zM12 5.98L13.87 11h-3.74L12 5.98z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 unarchive
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.55 5.22l-1.39-1.68C18.88 3.21 18.47 3 18 3H6c-.47 0-.88.21-1.15.55L3.46 5.22C3.17 5.57 3 6.01 3 6.5V19c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V6.5c0-.49-.17-.93-.45-1.28zm-8.2 4.63L17.5 15H14v2h-4v-2H6.5l5.15-5.15c.19-.19.51-.19.7 0zM5.12 5l.82-1h12l.93 1H5.12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 clear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.3 5.71c-.39-.39-1.02-.39-1.41 0L12 10.59 7.11 5.7c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L10.59 12 5.7 16.89c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0L12 13.41l4.89 4.89c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L13.41 12l4.89-4.89c.38-.38.38-1.02 0-1.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 markunread
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-.4 4.25l-6.54 4.09c-.65.41-1.47.41-2.12 0L4.4 8.25c-.25-.16-.4-.43-.4-.72 0-.67.73-1.07 1.3-.72L12 11l6.7-4.19c.57-.35 1.3.05 1.3.72 0 .29-.15.56-.4.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 where-to-vote
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2c-4.2,0-8,3.22-8,8.2c0,3.18,2.45,6.92,7.34,11.23c0.38,0.33,0.95,0.33,1.33,0C17.55,17.12,20,13.38,20,10.2 C20,5.22,16.2,2,12,2z M10.23,12.66l-1.41-1.41c-0.39-0.39-0.39-1.02,0-1.41l0,0c0.39-0.39,1.02-0.39,1.41,0l0.71,0.71l2.83-2.83 c0.39-0.39,1.02-0.39,1.41,0l0,0c0.39,0.39,0.39,1.02,0,1.41l-3.54,3.54C11.26,13.05,10.62,13.05,10.23,12.66z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 reply-all
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 7.56c0-.94-1.14-1.42-1.81-.75L.71 11.29c-.39.39-.39 1.02 0 1.41l4.48 4.48c.67.68 1.81.2 1.81-.74 0-.28-.11-.55-.31-.75L3 12l3.69-3.69c.2-.2.31-.47.31-.75zM13 9V7.41c0-.89-1.08-1.34-1.71-.71L6.7 11.29c-.39.39-.39 1.02 0 1.41l4.59 4.59c.63.63 1.71.18 1.71-.71V14.9c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 reply
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 9V7.41c0-.89-1.08-1.34-1.71-.71L3.7 11.29c-.39.39-.39 1.02 0 1.41l4.59 4.59c.63.63 1.71.19 1.71-.7V14.9c5 0 8.5 1.6 11 5.1-1-5-4-10-11-11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 save-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 13v5c0 .55-.45 1-1 1H6c-.55 0-1-.45-1-1v-5c0-.55-.45-1-1-1s-1 .45-1 1v6c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-6c0-.55-.45-1-1-1s-1 .45-1 1zm-6-.33l1.88-1.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-3.59 3.59c-.39.39-1.02.39-1.41 0L7.7 12.2c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L11 12.67V4c0-.55.45-1 1-1s1 .45 1 1v8.67z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 7c.55 0 1 .45 1 1v1.33l7.2 7.2.51-.51c.19-.19.29-.44.29-.71V8.68c0-.27-.11-.52-.29-.71l-4.68-4.68c-.19-.18-.45-.29-.71-.29H8.68c-.26 0-.52.11-.7.29l-.51.51 3.69 3.69c.17-.29.48-.49.84-.49zM2.41 1.58L1 2.99l3.64 3.64-1.35 1.35c-.18.18-.29.44-.29.7v6.63c0 .27.11.52.29.71l4.68 4.68c.19.19.45.3.71.3h6.63c.27 0 .52-.11.71-.29l1.35-1.35L21.01 23l1.41-1.41L2.41 1.58zM12 17.3c-.72 0-1.3-.58-1.3-1.3 0-.72.58-1.3 1.3-1.3s1.3.58 1.3 1.3c0 .72-.58 1.3-1.3 1.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 13h-5v5c0 .55-.45 1-1 1s-1-.45-1-1v-5H6c-.55 0-1-.45-1-1s.45-1 1-1h5V6c0-.55.45-1 1-1s1 .45 1 1v5h5c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 link
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17,7h-3c-0.55,0-1,0.45-1,1s0.45,1,1,1h3c1.65,0,3,1.35,3,3s-1.35,3-3,3h-3c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h3 c2.76,0,5-2.24,5-5S19.76,7,17,7z M8,12c0,0.55,0.45,1,1,1h6c0.55,0,1-0.45,1-1s-0.45-1-1-1H9C8.45,11,8,11.45,8,12z M10,15H7 c-1.65,0-3-1.35-3-3s1.35-3,3-3h3c0.55,0,1-0.45,1-1s-0.45-1-1-1H7c-2.76,0-5,2.24-5,5s2.24,5,5,5h3c0.55,0,1-0.45,1-1 C11,15.45,10.55,15,10,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-circle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm4 11h-3v3c0 .55-.45 1-1 1s-1-.45-1-1v-3H8c-.55 0-1-.45-1-1s.45-1 1-1h3V8c0-.55.45-1 1-1s1 .45 1 1v3h3c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-box
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.11 0-2 .9-2 2v14c0 1.1.89 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-3 10h-3v3c0 .55-.45 1-1 1s-1-.45-1-1v-3H8c-.55 0-1-.45-1-1s.45-1 1-1h3V8c0-.55.45-1 1-1s1 .45 1 1v3h3c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 gesture
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3.72 6.04c.47.46 1.21.48 1.71.06.37-.32.69-.51.87-.43.5.2 0 1.03-.3 1.52-.25.42-2.86 3.89-2.86 6.31 0 1.28.48 2.34 1.34 2.98.75.56 1.74.73 2.64.46 1.07-.31 1.95-1.4 3.06-2.77 1.21-1.49 2.83-3.44 4.08-3.44 1.63 0 1.65 1.01 1.76 1.79-3.78.64-5.38 3.67-5.38 5.37 0 1.7 1.44 3.09 3.21 3.09 1.63 0 4.29-1.33 4.69-6.1h1.21c.69 0 1.25-.56 1.25-1.25s-.56-1.25-1.25-1.25h-1.22c-.15-1.65-1.09-4.2-4.03-4.2-2.25 0-4.18 1.91-4.94 2.84-.58.73-2.06 2.48-2.29 2.72-.25.3-.68.84-1.11.84-.45 0-.72-.83-.36-1.92.35-1.09 1.4-2.86 1.85-3.52.78-1.14 1.3-1.92 1.3-3.28C8.95 3.69 7.31 3 6.44 3c-1.09 0-2.04.63-2.7 1.22-.53.48-.53 1.32-.02 1.82zm10.16 12.51c-.31 0-.74-.26-.74-.72 0-.6.73-2.2 2.87-2.76-.3 2.69-1.43 3.48-2.13 3.48z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 web-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,4c1.1,0,2,0.9,2,2v12c0,1.1-0.9,2-2,2V4z M2,20c0,1.1,0.9,2,2,2h9c1.1,0,2-0.9,2-2V4c0-1.1-0.9-2-2-2H4 C2.9,2,2,2.9,2,4V20z M21,18c0.83,0,1.5-0.67,1.5-1.5v-9C22.5,6.67,21.83,6,21,6V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 next-week
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 7h-4V5c0-.55-.22-1.05-.59-1.41C15.05 3.22 14.55 3 14 3h-4c-1.1 0-2 .9-2 2v2H4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V9c0-1.1-.9-2-2-2zM10 5h4v2h-4V5zm.5 13c-.28-.28-.28-.72 0-1l2.5-2.5-2.5-2.5c-.28-.28-.28-.72 0-1s.72-.28 1 0l3.15 3.15c.2.2.2.51 0 .71L11.5 18c-.28.28-.72.28-1 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 inventory
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M5,5h2v1c0,1.1,0.9,2,2,2h6c1.1,0,2-0.9,2-2V5h2v5h2V5c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5 C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h6v-2H5V5z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1S11.45,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21.75,12.25c-0.41-0.41-1.09-0.41-1.5,0L15.51,17l-2.26-2.25c-0.41-0.41-1.08-0.41-1.5,0l0,0c-0.41,0.41-0.41,1.09,0,1.5 l3.05,3.04c0.39,0.39,1.02,0.39,1.41,0l5.53-5.54C22.16,13.34,22.16,12.66,21.75,12.25z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 attribution
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8.5c-.91 0-2.75.46-2.75 1.38V14c0 .28.22.5.5.5h1v3.25c0 .69.56 1.25 1.25 1.25s1.25-.56 1.25-1.25V14.5h1c.28 0 .5-.22.5-.5V9.88c0-.91-1.84-1.38-2.75-1.38zM12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1.5", :cy "6.5", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 waves
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 16.99c-1.35 0-2.2.42-2.95.8-.65.33-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.38-1.57-.8-2.95-.8s-2.2.42-2.95.8c-.43.22-.81.41-1.27.52-.45.1-.78.46-.78.91v.1c0 .6.56 1.03 1.14.91.74-.15 1.3-.43 1.81-.69.65-.33 1.17-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.42 2.95-.8c.65-.33 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.52.26 1.08.55 1.83.7.58.11 1.12-.33 1.12-.91v-.09c0-.46-.34-.82-.79-.92-.46-.1-.83-.29-1.26-.52-.75-.39-1.6-.81-2.95-.81zm0-4.45c-1.35 0-2.2.43-2.95.8-.65.32-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.38-1.57-.8-2.95-.8s-2.2.43-2.95.8c-.43.21-.81.41-1.28.52-.44.1-.77.46-.77.91v.1c0 .59.54 1.03 1.12.91.75-.15 1.31-.44 1.83-.69.65-.35 1.15-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.35 1.15-.6 2.05-.6s1.4.25 2.05.6c.52.26 1.08.55 1.83.7.58.11 1.12-.33 1.12-.92v-.09c0-.46-.34-.82-.79-.92-.46-.1-.83-.29-1.26-.52-.75-.38-1.6-.8-2.95-.8zm2.95-8.08c-.75-.38-1.58-.8-2.95-.8s-2.2.42-2.95.8c-.65.32-1.18.6-2.05.6-.9 0-1.4-.25-2.05-.6-.75-.37-1.57-.8-2.95-.8s-2.2.42-2.95.8c-.43.22-.81.41-1.27.52-.45.1-.78.46-.78.91v.07c0 .6.54 1.04 1.12.92.75-.15 1.31-.44 1.83-.69.65-.33 1.17-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.32 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.52.26 1.08.55 1.83.7.58.11 1.12-.33 1.12-.92v-.09c0-.46-.34-.82-.79-.92-.46-.1-.83-.28-1.26-.5zM17 8.09c-1.35 0-2.2.43-2.95.8-.65.35-1.15.6-2.05.6s-1.4-.25-2.05-.6c-.75-.38-1.57-.8-2.95-.8s-2.2.43-2.95.8c-.43.23-.8.42-1.26.52-.45.1-.79.46-.79.92v.09c0 .59.54 1.03 1.12.91.75-.15 1.31-.44 1.83-.69.65-.32 1.18-.6 2.05-.6s1.4.25 2.05.6c.75.38 1.57.8 2.95.8s2.2-.43 2.95-.8c.65-.32 1.18-.6 2.05-.6.9 0 1.4.25 2.05.6.52.26 1.08.55 1.83.7.58.11 1.12-.33 1.12-.91v-.09c0-.46-.34-.82-.79-.92-.46-.1-.83-.29-1.26-.52-.75-.39-1.6-.81-2.95-.81z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 ballot
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 9.5h3c.55 0 1-.45 1-1s-.45-1-1-1h-3c-.55 0-1 .45-1 1s.45 1 1 1zm0 7h3c.55 0 1-.45 1-1s-.45-1-1-1h-3c-.55 0-1 .45-1 1s.45 1 1 1zm5 4.5H5c-1.1 0-2-.9-2-2V5c0-1.1.9-2 2-2h14c1.1 0 2 .9 2 2v14c0 1.1-.9 2-2 2zM7 11h3c.55 0 1-.45 1-1V7c0-.55-.45-1-1-1H7c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1zm0-4h3v3H7V7zm0 11h3c.55 0 1-.45 1-1v-3c0-.55-.45-1-1-1H7c-.55 0-1 .45-1 1v3c0 .55.45 1 1 1zm0-4h3v3H7v-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 backspace
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 3H7c-.69 0-1.23.35-1.59.88L.37 11.45c-.22.34-.22.77 0 1.11l5.04 7.56c.36.52.9.88 1.59.88h15c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-3.7 13.3c-.39.39-1.02.39-1.41 0L14 13.41l-2.89 2.89c-.39.39-1.02.39-1.41 0-.39-.39-.39-1.02 0-1.41L12.59 12 9.7 9.11c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L14 10.59l2.89-2.89c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41L15.41 12l2.89 2.89c.38.38.38 1.02 0 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-list-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21,7c0-0.55-0.45-1-1-1H8.83l2,2H20C20.55,8,21,7.55,21,7z M18,12c0-0.55-0.45-1-1-1h-3.17l2,2H17 C17.55,13,18,12.55,18,12z M13.98,16.81C13.99,16.87,14,16.94,14,17c0,0.55-0.45,1-1,1h-2c-0.55,0-1-0.45-1-1s0.45-1,1-1h2 c0.06,0,0.13,0.01,0.19,0.02L10.17,13H7c-0.55,0-1-0.45-1-1s0.45-1,1-1h1.17l-3-3H4C3.45,8,3,7.55,3,7c0-0.32,0.15-0.6,0.38-0.79 L2.1,4.93c-0.39-0.39-0.39-1.02,0-1.41s1.02-0.39,1.41,0l16.97,16.97c0.39,0.39,0.39,1.02,0,1.41s-1.02,0.39-1.41,0L13.98,16.81z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 content-paste-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M20.49,20.49L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0l0,0c-0.39,0.39-0.39,1.02,0,1.41L3,5.83V19c0,1.1,0.9,2,2,2h13.17 l0.9,0.9c0.39,0.39,1.02,0.39,1.41,0l0,0C20.88,21.51,20.88,20.88,20.49,20.49z M5,19V7.83L16.17,19H5z M17,8V5h2v11.17l2,2V5 c0-1.1-0.9-2-2-2h-4.18C14.4,1.84,13.3,1,12,1S9.6,1.84,9.18,3H5.83l5,5H17z M12,3c0.55,0,1,0.45,1,1s-0.45,1-1,1s-1-0.45-1-1 S11.45,3,12,3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.32 3H8.68c-.26 0-.52.11-.7.29L3.29 7.98c-.18.18-.29.44-.29.7v6.63c0 .27.11.52.29.71l4.68 4.68c.19.19.45.3.71.3h6.63c.27 0 .52-.11.71-.29l4.68-4.68c.19-.19.29-.44.29-.71V8.68c0-.27-.11-.52-.29-.71l-4.68-4.68c-.18-.18-.44-.29-.7-.29zM12 17.3c-.72 0-1.3-.58-1.3-1.3s.58-1.3 1.3-1.3 1.3.58 1.3 1.3-.58 1.3-1.3 1.3zm0-4.3c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1s1 .45 1 1v4c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 delete-sweep
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 16h2c.55 0 1 .45 1 1s-.45 1-1 1h-2c-.55 0-1-.45-1-1s.45-1 1-1zm0-8h5c.55 0 1 .45 1 1s-.45 1-1 1h-5c-.55 0-1-.45-1-1s.45-1 1-1zm0 4h4c.55 0 1 .45 1 1s-.45 1-1 1h-4c-.55 0-1-.45-1-1s.45-1 1-1zM3 18c0 1.1.9 2 2 2h6c1.1 0 2-.9 2-2V8H3v10zM13 5h-2l-.71-.71c-.18-.18-.44-.29-.7-.29H6.41c-.26 0-.52.11-.7.29L5 5H3c-.55 0-1 .45-1 1s.45 1 1 1h10c.55 0 1-.45 1-1s-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 square-foot
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M17.66,17.66l-0.71,0.71c-0.2,0.2-0.51,0.2-0.71,0l0,0c-0.2-0.2-0.2-0.51,0-0.71l0.71-0.71l-1.94-1.94l-0.71,0.71 c-0.2,0.2-0.51,0.2-0.71,0l0,0c-0.2-0.2-0.2-0.51,0-0.71l0.71-0.71l-1.94-1.94l-0.71,0.71c-0.2,0.2-0.51,0.2-0.71,0l0,0 c-0.2-0.2-0.2-0.51,0-0.71l0.71-0.71L9.7,9.7l-0.71,0.71c-0.2,0.2-0.51,0.2-0.71,0l0,0c-0.2-0.2-0.2-0.51,0-0.71l0.71-0.71 L7.05,7.05L6.34,7.76c-0.2,0.2-0.51,0.2-0.71,0l0,0c-0.2-0.2-0.2-0.51,0-0.71l0.71-0.71L4.85,4.85C4.54,4.54,4,4.76,4,5.21V18 c0,1.1,0.9,2,2,2h12.79c0.45,0,0.67-0.54,0.35-0.85L17.66,17.66z M7,16v-4.76L12.76,17H8C7.45,17,7,16.55,7,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 upcoming
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.45,6.55L20.45,6.55c-0.38-0.38-1.01-0.38-1.39,0L16.89,8.7c-0.39,0.38-0.39,1.01,0,1.39l0.01,0.01 c0.39,0.39,1.01,0.39,1.4,0c0.62-0.63,1.52-1.54,2.15-2.17C20.83,7.55,20.83,6.93,20.45,6.55z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.02,3h-0.03C11.44,3,11,3.44,11,3.98v3.03C11,7.56,11.44,8,11.98,8h0.03C12.56,8,13,7.56,13,7.02V3.98 C13,3.44,12.56,3,12.02,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.1,10.11l0.01-0.01c0.38-0.38,0.38-1.01,0-1.39L4.96,6.54c-0.38-0.39-1.01-0.39-1.39,0L3.55,6.55 c-0.39,0.39-0.39,1.01,0,1.39c0.63,0.62,1.53,1.54,2.15,2.17C6.09,10.49,6.72,10.49,7.1,10.11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,15c-1.24,0-2.31-0.75-2.76-1.83C8.92,12.43,8.14,12,7.34,12L4,12c-1.1,0-2,0.9-2,2l0,5c0,1.1,0.9,2,2,2h16 c1.1,0,2-0.9,2-2v-5c0-1.1-0.9-2-2-2l-3.34,0c-0.8,0-1.58,0.43-1.9,1.17C14.31,14.25,13.24,15,12,15",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 add-link
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9,11h6c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H9c-0.55,0-1-0.45-1-1v0C8,11.45,8.45,11,9,11z M20.93,12L20.93,12 c0.62,0,1.07-0.59,0.93-1.19C21.32,8.62,19.35,7,17,7h-3.05C13.43,7,13,7.43,13,7.95v0c0,0.52,0.43,0.95,0.95,0.95H17 c1.45,0,2.67,1,3.01,2.34C20.12,11.68,20.48,12,20.93,12z M3.96,11.38C4.24,9.91,5.62,8.9,7.12,8.9l2.93,0 C10.57,8.9,11,8.47,11,7.95v0C11,7.43,10.57,7,10.05,7L7.22,7c-2.61,0-4.94,1.91-5.19,4.51C1.74,14.49,4.08,17,7,17h3.05 c0.52,0,0.95-0.43,0.95-0.95v0c0-0.52-0.43-0.95-0.95-0.95H7C5.09,15.1,3.58,13.36,3.96,11.38z M18,12L18,12c-0.55,0-1,0.45-1,1v2 h-2c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h2v2c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2h2c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1h-2v-2C19,12.45,18.55,12,18,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 outlined-flag
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 6l-.72-1.45c-.17-.34-.52-.55-.9-.55H6c-.55 0-1 .45-1 1v15c0 .55.45 1 1 1s1-.45 1-1v-6h5l.72 1.45c.17.34.52.55.89.55H19c.55 0 1-.45 1-1V7c0-.55-.45-1-1-1h-5zm4 8h-4l-1-2H7V6h5l1 2h5v6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 report-gmailerrorred
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.71 7.98L16.03 3.3c-.19-.19-.45-.3-.71-.3H8.68c-.26 0-.52.11-.7.29L3.29 7.98c-.18.18-.29.44-.29.7v6.63c0 .27.11.52.29.71l4.68 4.68c.19.19.45.3.71.3h6.63c.27 0 .52-.11.71-.29l4.68-4.68c.19-.19.29-.44.29-.71V8.68c.01-.26-.1-.52-.28-.7zM19 14.9L14.9 19H9.1L5 14.9V9.1L9.1 5h5.8L19 9.1v5.8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "16", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M12 7c-.55 0-1 .45-1 1v5c0 .55.45 1 1 1s1-.45 1-1V8c0-.55-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 save
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.59 3.59c-.38-.38-.89-.59-1.42-.59H5c-1.11 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V7.83c0-.53-.21-1.04-.59-1.41l-2.82-2.83zM12 19c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3zm1-10H7c-1.1 0-2-.9-2-2s.9-2 2-2h6c1.1 0 2 .9 2 2s-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 send
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3.4 20.4l17.45-7.48c.81-.35.81-1.49 0-1.84L3.4 3.6c-.66-.29-1.39.2-1.39.91L2 9.12c0 .5.37.93.87.99L17 12 2.87 13.88c-.5.07-.87.5-.87 1l.01 4.61c0 .71.73 1.2 1.39.91z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 create
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 17.46v3.04c0 .28.22.5.5.5h3.04c.13 0 .26-.05.35-.15L17.81 9.94l-3.75-3.75L3.15 17.1c-.1.1-.15.22-.15.36zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 stacked-bar-chart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M6,20L6,20c1.1,0,2-0.9,2-2V9H4v9C4,19.1,4.9,20,6,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M4,8h4V6c0-1.1-0.9-2-2-2h0C4.9,4,4,4.9,4,6V8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M10,11h4V9c0-1.1-0.9-2-2-2h0c-1.1,0-2,0.9-2,2V11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M16,12v2h4v-2c0-1.1-0.9-2-2-2h0C16.9,10,16,10.9,16,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M18,20L18,20c1.1,0,2-0.9,2-2v-3h-4v3C16,19.1,16.9,20,18,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M12,20L12,20c1.1,0,2-0.9,2-2v-6h-4v6C10,19.1,10.9,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tag
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,9L20,9c0-0.55-0.45-1-1-1h-3V5c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v3h-4V5c0-0.55-0.45-1-1-1h0C8.45,4,8,4.45,8,5 v3H5C4.45,8,4,8.45,4,9v0c0,0.55,0.45,1,1,1h3v4H5c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h3v3c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1v-3h4v3c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-3h3c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-3v-4h3 C19.55,10,20,9.55,20,9z M14,14h-4v-4h4V14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 low-priority
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 5h6c.55 0 1 .45 1 1s-.45 1-1 1h-6c-.55 0-1-.45-1-1s.45-1 1-1zm0 5.5h6c.55 0 1 .45 1 1s-.45 1-1 1h-6c-.55 0-1-.45-1-1s.45-1 1-1zm0 5.5h6c.55 0 1 .45 1 1s-.45 1-1 1h-6c-.55 0-1-.45-1-1s.45-1 1-1zm-5.15 3.15l1.79-1.79c.2-.2.2-.51 0-.71l-1.79-1.79c-.31-.32-.85-.1-.85.35v3.59c0 .44.54.66.85.35zM9 16h-.3c-2.35 0-4.45-1.71-4.68-4.05C3.76 9.27 5.87 7 8.5 7H11c.55 0 1-.45 1-1s-.45-1-1-1H8.5c-3.86 0-6.96 3.4-6.44 7.36C2.48 15.64 5.43 18 8.73 18H9",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 forward
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8V6.41c0-.89 1.08-1.34 1.71-.71l5.59 5.59c.39.39.39 1.02 0 1.41l-5.59 5.59c-.63.63-1.71.19-1.71-.7V16H5c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1h7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 policy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,6.3c0-0.79-0.47-1.51-1.19-1.83l-7-3.11c-0.52-0.23-1.11-0.23-1.62,0l-7,3.11C3.47,4.79,3,5.51,3,6.3V11 c0,5.55,3.84,10.74,9,12c2.3-0.56,4.33-1.9,5.88-3.71l-3.12-3.12c-1.94,1.29-4.58,1.07-6.29-0.64c-1.95-1.95-1.95-5.12,0-7.07 c1.95-1.95,5.12-1.95,7.07,0c1.71,1.71,1.92,4.35,0.64,6.29l2.9,2.9C20.29,15.69,21,13.38,21,11V6.3z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 move-to-inbox
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M19,14h-3.56 c-0.36,0-0.68,0.19-0.86,0.5C14.06,15.4,13.11,16,12,16s-2.06-0.6-2.58-1.5C9.24,14.19,8.91,14,8.56,14H5V5h14V14z M14.79,10H13V7 c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v3H9.21c-0.45,0-0.67,0.54-0.35,0.85l2.79,2.79c0.2,0.2,0.51,0.2,0.71,0l2.79-2.79 C15.46,10.54,15.24,10,14.79,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 block
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zM4 12c0-4.42 3.58-8 8-8 1.85 0 3.55.63 4.9 1.69L5.69 16.9C4.63 15.55 4 13.85 4 12zm8 8c-1.85 0-3.55-.63-4.9-1.69L18.31 7.1C19.37 8.45 20 10.15 20 12c0 4.42-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 assistant-photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.4 6l-.24-1.2c-.09-.46-.5-.8-.98-.8H6c-.55 0-1 .45-1 1v15c0 .55.45 1 1 1s1-.45 1-1v-6h5.6l.24 1.2c.09.47.5.8.98.8H19c.55 0 1-.45 1-1V7c0-.55-.45-1-1-1h-4.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M22.6,11.29L20,8.69V5c0-0.55-0.45-1-1-1h-3.69l-2.6-2.6c-0.39-0.39-1.02-0.39-1.41,0L8.69,4H5C4.45,4,4,4.45,4,5v3.69 l-2.6,2.6c-0.39,0.39-0.39,1.02,0,1.41L4,15.3V19c0,0.55,0.45,1,1,1h3.69l2.6,2.6c0.39,0.39,1.02,0.39,1.41,0l2.6-2.6H19 c0.55,0,1-0.45,1-1v-3.69l2.6-2.6C22.99,12.32,22.99,11.68,22.6,11.29z M17.92,12.98c-0.34,2.12-1.85,3.94-3.88,4.66 c-1.21,0.43-2.41,0.45-3.5,0.18c-0.41-0.1-0.48-0.65-0.13-0.9C11.98,15.84,13,14.04,13,12s-1.02-3.84-2.58-4.92 c-0.35-0.24-0.29-0.79,0.13-0.9c1.09-0.27,2.29-0.25,3.5,0.18c2.02,0.72,3.54,2.54,3.88,4.66C17.98,11.35,18,11.68,18,12 C17.99,12.32,17.97,12.65,17.92,12.98z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 auto-fix-high
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.45,6l0.49-1.06L22,4.45c0.39-0.18,0.39-0.73,0-0.91l-1.06-0.49L20.45,2c-0.18-0.39-0.73-0.39-0.91,0l-0.49,1.06 L18,3.55c-0.39,0.18-0.39,0.73,0,0.91l1.06,0.49L19.55,6C19.72,6.39,20.28,6.39,20.45,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.95,6l0.49-1.06l1.06-0.49c0.39-0.18,0.39-0.73,0-0.91L9.44,3.06L8.95,2C8.78,1.61,8.22,1.61,8.05,2L7.56,3.06L6.5,3.55 c-0.39,0.18-0.39,0.73,0,0.91l1.06,0.49L8.05,6C8.22,6.39,8.78,6.39,8.95,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.55,13.5l-0.49,1.06L18,15.05c-0.39,0.18-0.39,0.73,0,0.91l1.06,0.49l0.49,1.06c0.18,0.39,0.73,0.39,0.91,0l0.49-1.06 L22,15.95c0.39-0.18,0.39-0.73,0-0.91l-1.06-0.49l-0.49-1.06C20.28,13.11,19.72,13.11,19.55,13.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.71,9.12l-2.83-2.83c-0.39-0.39-1.02-0.39-1.41,0L2.29,17.46c-0.39,0.39-0.39,1.02,0,1.41l2.83,2.83 c0.39,0.39,1.02,0.39,1.41,0l11.17-11.17C18.1,10.15,18.1,9.51,17.71,9.12z M14.21,11.21l-1.41-1.41l1.38-1.38l1.41,1.41 L14.21,11.21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 broken-image
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 5v6.59l-2.29-2.3c-.39-.39-1.03-.39-1.42 0L14 12.59 10.71 9.3c-.39-.39-1.02-.39-1.41 0L6 12.59 3 9.58V5c0-1.1.9-2 2-2h14c1.1 0 2 .9 2 2zm-3 6.42l3 3.01V19c0 1.1-.9 2-2 2H5c-1.1 0-2-.9-2-2v-6.58l2.29 2.29c.39.39 1.02.39 1.41 0l3.3-3.3 3.29 3.29c.39.39 1.02.39 1.41 0l3.3-3.28z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-3
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M8.93,2C8.88,2,8.84,2,8.79,2C7.96,2.02,7.7,3.12,8.4,3.56c2.78,1.77,4.63,4.89,4.63,8.44c0,3.55-1.84,6.66-4.62,8.43 C7.7,20.89,7.98,21.98,8.82,22c0.07,0,0.14,0,0.21,0c6.05,0,10.86-5.39,9.87-11.63C18.14,5.53,13.83,1.95,8.93,2z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 assistant
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h4l2.29 2.29c.39.39 1.02.39 1.41 0L15 20h4c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-5.12 10.88L12 17l-1.88-4.12L6 11l4.12-1.88L12 5l1.88 4.12L18 11l-4.12 1.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 grid-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M8 4v.89l2 2V4h4v4h-2.89l2 2H14v.89l2 2V10h4v4h-2.89l2 2H20v.89l2 2V4c0-1.1-.9-2-2-2H5.11l2 2H8zm8 0h3c.55 0 1 .45 1 1v3h-4V4zm6.16 17.88L2.12 1.84c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L2 4.55V20c0 1.1.9 2 2 2h15.45l1.3 1.3c.39.39 1.02.39 1.41 0 .39-.39.39-1.03 0-1.42zM10 12.55L11.45 14H10v-1.45zm-6-6L5.45 8H4V6.55zM8 20H5c-.55 0-1-.45-1-1v-3h4v4zm0-6H4v-4h3.45l.55.55V14zm6 6h-4v-4h3.45l.55.55V20zm2 0v-1.45L17.45 20H16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 monochrome-photos
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 5h-3.2l-1.2-1.34c-.38-.42-.92-.66-1.49-.66H9.89c-.57 0-1.11.24-1.49.66L7.2 5H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 13c0 .55-.45 1-1 1h-7v-1c-2.8 0-5-2.2-5-5s2.2-5 5-5V7h7c.55 0 1 .45 1 1v10zm-3-5c0-2.8-2.2-5-5-5v1.8c1.8 0 3.2 1.4 3.2 3.2s-1.4 3.2-3.2 3.2V18c2.8 0 5-2.2 5-5zm-8.2 0c0 1.8 1.4 3.2 3.2 3.2V9.8c-1.8 0-3.2 1.4-3.2 3.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flip-camera-ios
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,5h-3.17l-1.24-1.35C15.22,3.24,14.68,3,14.12,3H9.88c-0.56,0-1.1,0.24-1.48,0.65L7.17,5H4C2.9,5,2,5.9,2,7v12 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M13.67,17.7C13.15,17.89,12.59,18,12,18c-2.76,0-5-2.24-5-5H5l2.5-2.5 L10,13H8c0,2.21,1.79,4,4,4c0.46,0,0.91-0.08,1.32-0.23c0.19-0.07,0.39-0.03,0.53,0.11C14.11,17.14,14.01,17.57,13.67,17.7z M16.5,15.5L14,13h2c0-2.21-1.79-4-4-4c-0.46,0-0.91,0.08-1.32,0.23c-0.19,0.07-0.39,0.03-0.53-0.11 C9.89,8.86,9.99,8.43,10.33,8.3C10.85,8.11,11.41,8,12,8c2.76,0,5,2.24,5,5h2L16.5,15.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 gradient
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 9h2v2h-2V9zm-2 2h2v2H9v-2zm4 0h2v2h-2v-2zm2-2h2v2h-2V9zM7 9h2v2H7V9zm12-6H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM9 18H7v-2h2v2zm4 0h-2v-2h2v2zm4 0h-2v-2h2v2zm2-7h-2v2h2v2h-2v-2h-2v2h-2v-2h-2v2H9v-2H7v2H5v-2h2v-2H5V6c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 switch-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4h-3.17l-1.24-1.35c-.37-.41-.91-.65-1.47-.65H9.88c-.56 0-1.1.24-1.48.65L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-5 11.5V13H9v2.5l-3.15-3.15c-.2-.2-.2-.51 0-.71L9 8.5V11h6V8.5l3.15 3.15c.2.2.2.51 0 .71L15 15.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 remove-red-eye
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vrpano
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20.69,4.05C18.66,4.73,15.86,5.5,12,5.5c-3.89,0-6.95-0.84-8.69-1.43C2.67,3.85,2,4.33,2,5.02V19 c0,0.68,0.66,1.17,1.31,0.95C5.36,19.26,8.1,18.5,12,18.5c3.87,0,6.66,0.76,8.69,1.45C21.34,20.16,22,19.68,22,19V5 C22,4.32,21.34,3.84,20.69,4.05z M17.28,15.26C15.62,15.1,13.84,15,12,15c-1.87,0-3.63,0.1-5.28,0.27 C6.27,15.31,6,14.79,6.29,14.45l2.5-3c0.2-0.24,0.57-0.24,0.77,0l1.62,1.94l2.44-2.93c0.2-0.24,0.57-0.24,0.77,0l3.32,3.99 C17.99,14.79,17.72,15.31,17.28,15.26z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 incomplete-circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M22,12c0,5.52-4.48,10-10,10S2,17.52,2,12c0-2.76,1.12-5.26,2.93-7.07L12,12V2C17.52,2,22,6.48,22,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,3.55l-1.06-0.49L20.45,2c-0.18-0.39-0.73-0.39-0.91,0l-0.49,1.06L18,3.55c-0.39,0.18-0.39,0.73,0,0.91l1.06,0.49 L19.55,6c0.18,0.39,0.73,0.39,0.91,0l0.49-1.06L22,4.45C22.39,4.28,22.39,3.72,22,3.55z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.17,8.42l1.41,1.41l-1.46,1.46l1.41,1.41l2.17-2.17c0.39-0.39,0.39-1.02,0-1.41l-2.83-2.83 c-0.39-0.39-1.02-0.39-1.41,0l-2.17,2.17l1.41,1.41L14.17,8.42z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,4.93l6.36,6.36l-6.17,6.17c-0.39,0.39-0.39,1.02,0,1.41l2.83,2.83c0.39,0.39,1.02,0.39,1.41,0l6.17-6.17l6.36,6.36 c0.39,0.39,1.02,0.39,1.41,0h0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0l0,0 C1.71,3.91,1.71,4.54,2.1,4.93z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _23mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M6.5,9c0-0.55,0.45-1,1-1h2V7H7.25 C6.84,7,6.5,6.66,6.5,6.25S6.84,5.5,7.25,5.5H10c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H8v1h2.25c0.41,0,0.75,0.34,0.75,0.75 s-0.34,0.75-0.75,0.75H7.5c-0.55,0-1-0.45-1-1V9z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25 C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M13,10.75c0-0.41,0.34-0.75,0.75-0.75H16V9h-1.5C14.22,9,14,8.78,14,8.5S14.22,8,14.5,8H16V7h-2.25 C13.34,7,13,6.66,13,6.25s0.34-0.75,0.75-0.75h2.75c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1h-2.75C13.34,11.5,13,11.16,13,10.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1 V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 video-camera-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,10.48V6c0-1.1-0.9-2-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4.48l3.15,3.13 C21.46,16.97,22,16.74,22,16.3V7.7c0-0.44-0.54-0.67-0.85-0.35L18,10.48z M10,8c1.1,0,2,0.9,2,2s-0.9,2-2,2s-2-0.9-2-2S8.9,8,10,8z M14,16H6v-0.57c0-0.81,0.48-1.53,1.22-1.85C8.07,13.21,9.01,13,10,13c0.99,0,1.93,0.21,2.78,0.58C13.52,13.9,14,14.62,14,15.43V16 z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 view-comfy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M2,5v5c0,0.55,0.45,1,1,1h18c0.55,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1H3C2.45,4,2,4.45,2,5z M11,20h10c0.55,0,1-0.45,1-1v-5 c0-0.55-0.45-1-1-1H11c-0.55,0-1,0.45-1,1v5C10,19.55,10.45,20,11,20z M3,20h4c0.55,0,1-0.45,1-1v-5c0-0.55-0.45-1-1-1H3 c-0.55,0-1,0.45-1,1v5C2,19.55,2.45,20,3,20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 brightness-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12.43 2.3c-2.38-.59-4.68-.27-6.63.64-.35.16-.41.64-.1.86C8.3 5.6 10 8.6 10 12c0 3.4-1.7 6.4-4.3 8.2-.32.22-.26.7.09.86 1.28.6 2.71.94 4.21.94 6.05 0 10.85-5.38 9.87-11.6-.61-3.92-3.59-7.16-7.44-8.1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-cloudy
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.37 10.04C18.68 6.59 15.65 4 12.01 4c-2.89 0-5.4 1.64-6.65 4.04C2.35 8.36.01 10.91.01 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.64-4.96z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 15.31l2.6-2.6c.39-.39.39-1.02 0-1.41L20 8.69V5c0-.55-.45-1-1-1h-3.69l-2.6-2.6c-.39-.39-1.02-.39-1.41 0L8.69 4H5c-.55 0-1 .45-1 1v3.69l-2.6 2.6c-.39.39-.39 1.02 0 1.41L4 15.3V19c0 .55.45 1 1 1h3.69l2.6 2.6c.39.39 1.02.39 1.41 0l2.6-2.6H19c.55 0 1-.45 1-1v-3.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 leak-remove
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.12 12.04c.5-.05.88-.48.88-.99 0-.59-.51-1.06-1.1-1-1.5.15-2.9.61-4.16 1.3l1.48 1.48c.9-.41 1.87-.69 2.9-.79zm.88 3.05c0-.61-.54-1.09-1.14-1-.38.06-.75.16-1.11.28l1.62 1.62c.37-.15.63-.49.63-.9zM13.97 4.14c.06-.59-.4-1.11-1-1.11-.5 0-.94.37-.99.87-.1 1.03-.38 2.01-.79 2.91l1.48 1.48c.69-1.26 1.15-2.66 1.3-4.15zm-4.04.02c.1-.6-.39-1.14-1-1.14-.41 0-.75.26-.9.62l1.62 1.62c.13-.35.22-.72.28-1.1zm10.51 14.72L5.12 3.56c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l2.15 2.15c-.59.41-1.26.7-1.99.82-.48.1-.84.5-.84 1 0 .61.54 1.09 1.14 1 1.17-.19 2.23-.68 3.13-1.37L8.73 10c-1.34 1.1-3 1.82-4.81 1.99-.5.05-.88.48-.88.99 0 .59.51 1.06 1.1 1 2.28-.23 4.36-1.15 6.01-2.56l2.48 2.48c-1.4 1.65-2.33 3.72-2.56 6-.06.59.4 1.11 1 1.11.5 0 .94-.37.99-.87.18-1.82.9-3.48 1.99-4.82l1.43 1.43c-.69.9-1.18 1.96-1.37 3.13-.1.6.39 1.14 1 1.14.49 0 .9-.36.98-.85.12-.73.42-1.4.82-1.99l2.13 2.13c.39.39 1.02.39 1.41 0 .38-.41.38-1.04-.01-1.43z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 burst-mode
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1s-1-.45-1-1V6c0-.55.45-1 1-1zm4 0c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1s-1-.45-1-1V6c0-.55.45-1 1-1zm16 0H10c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h12c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1zM11.64 16.19l1.47-1.86c.2-.25.57-.25.78-.01l1.4 1.68 2.1-2.71c.2-.26.59-.26.79 0l2.21 2.9c.25.33.02.8-.4.8h-7.96c-.41.01-.65-.47-.39-.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 picture-as-pdf
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-8.5 7.5c0 .83-.67 1.5-1.5 1.5H9v1.25c0 .41-.34.75-.75.75s-.75-.34-.75-.75V8c0-.55.45-1 1-1H10c.83 0 1.5.67 1.5 1.5v1zm5 2c0 .83-.67 1.5-1.5 1.5h-2c-.28 0-.5-.22-.5-.5v-5c0-.28.22-.5.5-.5h2c.83 0 1.5.67 1.5 1.5v3zm4-3.75c0 .41-.34.75-.75.75H19v1h.75c.41 0 .75.34.75.75s-.34.75-.75.75H19v1.25c0 .41-.34.75-.75.75s-.75-.34-.75-.75V8c0-.55.45-1 1-1h1.25c.41 0 .75.34.75.75zM9 9.5h1v-1H9v1zM3 6c-.55 0-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1zm11 5.5h1v-3h-1v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM6.75 7h3.5c.41 0 .75.34.75.75s-.34.75-.75.75h-3.5c-.41 0-.75-.34-.75-.75S6.34 7 6.75 7zM18 19H5L19 5v13c0 .55-.45 1-1 1zm-3.5-3v1.25c0 .41.34.75.75.75s.75-.34.75-.75V16h1.25c.41 0 .75-.34.75-.75s-.34-.75-.75-.75H16v-1.25c0-.41-.34-.75-.75-.75s-.75.34-.75.75v1.25h-1.25c-.41 0-.75.34-.75.75s.34.75.75.75h1.25z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 audiotrack
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5v8.55c-.94-.54-2.1-.75-3.33-.32-1.34.48-2.37 1.67-2.61 3.07-.46 2.74 1.86 5.08 4.59 4.65 1.96-.31 3.35-2.11 3.35-4.1V7h2c1.1 0 2-.9 2-2s-.9-2-2-2h-2c-1.1 0-2 .9-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-tilt-shift
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 3.23c0-.64-.59-1.13-1.21-.99-1.12.26-2.18.7-3.12 1.3-.53.34-.61 1.1-.16 1.55.32.32.83.4 1.21.16.77-.49 1.62-.85 2.54-1.05.44-.1.74-.51.74-.97zm6.33.32c-.94-.6-2-1.04-3.12-1.3-.62-.14-1.21.34-1.21.98 0 .45.3.87.74.96.91.2 1.77.57 2.53 1.05.39.24.89.17 1.21-.16.46-.44.39-1.19-.15-1.53zM20.77 11c.64 0 1.13-.59.99-1.21-.26-1.12-.7-2.18-1.3-3.12-.34-.53-1.1-.61-1.55-.16-.32.32-.4.83-.16 1.21.49.77.85 1.62 1.05 2.53.1.45.51.75.97.75zM5.1 6.51c-.46-.45-1.21-.38-1.55.16-.6.94-1.04 2-1.3 3.12-.14.62.34 1.21.98 1.21.45 0 .87-.3.96-.74.2-.91.57-1.77 1.05-2.53.26-.39.18-.9-.14-1.22zM3.23 13c-.64 0-1.13.59-.99 1.21.26 1.12.7 2.17 1.3 3.12.34.54 1.1.61 1.55.16.32-.32.4-.83.15-1.21-.49-.76-.85-1.61-1.05-2.53-.09-.45-.5-.75-.96-.75zM15 12c0-1.66-1.34-3-3-3s-3 1.34-3 3 1.34 3 3 3 3-1.34 3-3zm3.9 5.49c.45.45 1.21.38 1.55-.15.6-.94 1.04-2 1.3-3.11.14-.62-.35-1.21-.98-1.21-.45 0-.87.3-.96.74-.2.91-.57 1.76-1.05 2.53-.26.37-.18.88.14 1.2zM13 20.77c0 .64.59 1.13 1.21.99 1.12-.26 2.17-.7 3.12-1.3.54-.34.61-1.1.16-1.55-.32-.32-.83-.4-1.21-.15-.76.49-1.61.85-2.53 1.05-.45.09-.75.5-.75.96zm-6.33-.32c.95.6 2 1.04 3.12 1.3.62.14 1.21-.35 1.21-.98 0-.45-.3-.87-.74-.96-.91-.2-1.77-.57-2.53-1.05-.39-.24-.89-.17-1.21.16-.46.44-.39 1.19.15 1.53z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 adjust
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8zm3-8c0 1.66-1.34 3-3 3s-3-1.34-3-3 1.34-3 3-3 3 1.34 3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 camera-rear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10.85 18.85c-.31-.31-.85-.09-.85.36V20H6c-.55 0-1 .45-1 1s.45 1 1 1h4v.79c0 .45.54.67.85.35l1.79-1.79c.2-.2.2-.51 0-.71l-1.79-1.79zM18 20h-3c-.55 0-1 .45-1 1s.45 1 1 1h3c.55 0 1-.45 1-1s-.45-1-1-1zM17 0H7C5.9 0 5 .9 5 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2zm-5 6c-1.11 0-2-.9-2-2s.89-2 1.99-2 2 .9 2 2C14 5.1 13.1 6 12 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.46,8l0.79-1.75L22,5.46c0.39-0.18,0.39-0.73,0-0.91l-1.75-0.79L19.46,2c-0.18-0.39-0.73-0.39-0.91,0l-0.79,1.75 L16,4.54c-0.39,0.18-0.39,0.73,0,0.91l1.75,0.79L18.54,8C18.72,8.39,19.28,8.39,19.46,8z M11.5,9.5L9.91,6 C9.56,5.22,8.44,5.22,8.09,6L6.5,9.5L3,11.09c-0.78,0.36-0.78,1.47,0,1.82l3.5,1.59L8.09,18c0.36,0.78,1.47,0.78,1.82,0l1.59-3.5 l3.5-1.59c0.78-0.36,0.78-1.47,0-1.82L11.5,9.5z M18.54,16l-0.79,1.75L16,18.54c-0.39,0.18-0.39,0.73,0,0.91l1.75,0.79L18.54,22 c0.18,0.39,0.73,0.39,0.91,0l0.79-1.75L22,19.46c0.39-0.18,0.39-0.73,0-0.91l-1.75-0.79L19.46,16 C19.28,15.61,18.72,15.61,18.54,16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 tag-faces
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11.99,2C6.47,2,2,6.48,2,12s4.47,10,9.99,10C17.52,22,22,17.52,22,12S17.52,2,11.99,2z M8.5,8C9.33,8,10,8.67,10,9.5 S9.33,11,8.5,11S7,10.33,7,9.5S7.67,8,8.5,8z M16.75,14.75C15.8,16.39,14.03,17.5,12,17.5s-3.8-1.11-4.75-2.75 C7.06,14.42,7.31,14,7.69,14h8.62C16.7,14,16.94,14.42,16.75,14.75z M15.5,11c-0.83,0-1.5-0.67-1.5-1.5S14.67,8,15.5,8 S17,8.67,17,9.5S16.33,11,15.5,11z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 raw-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.55,9c-0.33,0-0.63,0.23-0.71,0.55L19.24,12l-0.56-2.26C18.58,9.3,18.19,9,17.74,9S16.9,9.3,16.8,9.74L16.24,12 l-0.6-2.45C15.56,9.23,15.27,9,14.93,9c-0.47,0-0.82,0.44-0.71,0.9l0.5,1.99l2.42,2.42c0-0.01,0.01-0.02,0.01-0.03l0.58-2.32 l0.58,2.32C18.43,14.7,18.81,15,19.24,15s0.81-0.3,0.92-0.72l1.09-4.38C21.37,9.44,21.02,9,20.55,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41L6.17,9H4c-0.55,0-1,0.45-1,1v4.31 C3,14.69,3.31,15,3.69,15h0.11c0.38,0,0.69-0.31,0.69-0.69V13h1.1l0.72,1.59C6.43,14.84,6.68,15,6.95,15 c0.5,0,0.83-0.51,0.64-0.97L7.1,12.9C7.6,12.6,8,12.1,8,11.5v-0.67l1.43,1.43L8.98,14.1C8.86,14.56,9.21,15,9.68,15h0 c0.33,0,0.62-0.23,0.7-0.55l0.24-0.95h0.04l8.4,8.4c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51z M6.5,11.5 h-2v-1h2V11.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 music-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 9.61V7h2c1.1 0 2-.9 2-2s-.9-2-2-2h-3c-.55 0-1 .45-1 1v3.61l2 2zM5.12 3.56c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l8.29 8.3v.28c-.94-.54-2.1-.75-3.33-.32-1.34.48-2.37 1.67-2.61 3.07-.46 2.74 1.86 5.08 4.59 4.65 1.96-.31 3.35-2.11 3.35-4.1v-1.58l5.02 5.02c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L5.12 3.56z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-library
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 16V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2zm-10.6-3.47l1.63 2.18 2.58-3.22c.2-.25.58-.25.78 0l2.96 3.7c.26.33.03.81-.39.81H9c-.41 0-.65-.47-.4-.8l2-2.67c.2-.26.6-.26.8 0zM2 7v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1s-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-sunny
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.05 4.14l-.39-.39c-.39-.39-1.02-.38-1.4 0l-.01.01c-.39.39-.39 1.02 0 1.4l.39.39c.39.39 1.01.39 1.4 0l.01-.01c.39-.38.39-1.02 0-1.4zM3.01 10.5H1.99c-.55 0-.99.44-.99.99v.01c0 .55.44.99.99.99H3c.56.01 1-.43 1-.98v-.01c0-.56-.44-1-.99-1zm9-9.95H12c-.56 0-1 .44-1 .99v.96c0 .55.44.99.99.99H12c.56.01 1-.43 1-.98v-.97c0-.55-.44-.99-.99-.99zm7.74 3.21c-.39-.39-1.02-.39-1.41-.01l-.39.39c-.39.39-.39 1.02 0 1.4l.01.01c.39.39 1.02.39 1.4 0l.39-.39c.39-.39.39-1.01 0-1.4zm-1.81 15.1l.39.39c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41l-.39-.39c-.39-.39-1.02-.38-1.4 0-.4.4-.4 1.02-.01 1.41zM20 11.49v.01c0 .55.44.99.99.99H22c.55 0 .99-.44.99-.99v-.01c0-.55-.44-.99-.99-.99h-1.01c-.55 0-.99.44-.99.99zM12 5.5c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm-.01 16.95H12c.55 0 .99-.44.99-.99v-.96c0-.55-.44-.99-.99-.99h-.01c-.55 0-.99.44-.99.99v.96c0 .55.44.99.99.99zm-7.74-3.21c.39.39 1.02.39 1.41 0l.39-.39c.39-.39.38-1.02 0-1.4l-.01-.01c-.39-.39-1.02-.39-1.41 0l-.39.39c-.38.4-.38 1.02.01 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _16mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.75,5.5H9c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12,10.5v-4c0-0.55,0.45-1,1-1 h2.75c0.41,0,0.75,0.34,0.75,0.75S16.16,7,15.75,7H13.5v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H13 C12.45,11.5,12,11.05,12,10.5z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flash-auto
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 3v10c0 .55.45 1 1 1h2v7.15c0 .51.67.69.93.25l5.19-8.9c.39-.67-.09-1.5-.86-1.5H9l3.38-7.59c.29-.67-.2-1.41-.92-1.41H4c-.55 0-1 .45-1 1zm15-1c-.6 0-1.13.38-1.34.94L14.22 9.8c-.2.59.23 1.2.85 1.2.38 0 .72-.24.84-.6L16.4 9h3.2l.49 1.4c.13.36.46.6.84.6.62 0 1.05-.61.84-1.19l-2.44-6.86C19.13 2.38 18.6 2 18 2zm-1.15 5.65L18 4l1.15 3.65h-2.3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _3mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M10.75,10H13V9h-1.5 C11.22,9,11,8.78,11,8.5v0C11,8.22,11.22,8,11.5,8H13V7h-2.25C10.34,7,10,6.66,10,6.25v0c0-0.41,0.34-0.75,0.75-0.75h2.75 c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1h-2.75c-0.41,0-0.75-0.34-0.75-0.75v0C10,10.34,10.34,10,10.75,10z M18,16 c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-16-9
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,7H5C3.9,7,3,7.9,3,9v6c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V9C21,7.9,20.1,7,19,7z M19,15H5V9h14V15z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 _9mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M11,9c-0.55,0-1-0.45-1-1V6.5 c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1h-2.75c-0.41,0-0.75-0.34-0.75-0.75c0-0.41,0.34-0.75,0.75-0.75H13 V9H11z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1 v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M18,16c0,0.55-0.45,1-1,1 h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bedtime-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M11.65 3.46c.27-.71-.36-1.45-1.12-1.34-1.48.21-2.85.76-4.04 1.54l4.59 4.59c-.2-1.56-.04-3.2.57-4.79zm-9.55.05c-.39.39-.39 1.02 0 1.41l1.56 1.56c-1.4 2.11-2.02 4.77-1.46 7.56.79 3.94 3.99 7.07 7.94 7.78 2.74.49 5.3-.15 7.35-1.51l1.57 1.57c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L3.51 3.51c-.39-.39-1.02-.39-1.41 0z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 currency-franc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,4c0-0.55-0.45-1-1-1H8C7.45,3,7,3.45,7,4v12H6c-0.55,0-1,0.45-1,1s0.45,1,1,1h1v2c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1v-2h3c0.55,0,1-0.45,1-1s-0.45-1-1-1H9v-3h7c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1H9V5h8C17.55,5,18,4.55,18,4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 crop-rotate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 9v5h2V8c0-1.1-.9-2-2-2h-6v2h5c.55 0 1 .45 1 1zm3 7H9c-.55 0-1-.45-1-1V5c0-.55-.45-1-1-1s-1 .45-1 1v1H5c-.55 0-1 .45-1 1s.45 1 1 1h1v8c0 1.1.9 2 2 2h8v1c0 .55.45 1 1 1s1-.45 1-1v-1h1c.55 0 1-.45 1-1s-.45-1-1-1zM17.66 1.4C15.99.51 13.83-.11 11.39.04l3.81 3.81 1.33-1.33c3.09 1.46 5.34 4.37 5.89 7.86.06.41.44.69.86.62.41-.06.69-.45.62-.86-.6-3.8-2.96-7-6.24-8.74zM7.47 21.49c-3.09-1.46-5.34-4.37-5.89-7.86-.06-.41-.44-.69-.86-.62-.41.06-.69.45-.62.86.6 3.81 2.96 7.01 6.24 8.75 1.67.89 3.83 1.51 6.27 1.36L8.8 20.16l-1.33 1.33z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-paused
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,9L4,9c0.26,0.26,0.34,0.63,0.25,0.98c-0.35,1.36-0.36,2.87,0.1,4.38c0.88,2.91,3.44,5.1,6.44,5.55 c5.52,0.81,10.19-4.06,9.03-9.62c-0.65-3.13-3.23-5.61-6.37-6.16c-1.21-0.21-2.38-0.15-3.46,0.13C9.64,4.35,9.26,4.26,9.01,4.01l0,0 C8.45,3.45,8.73,2.52,9.48,2.32c1.47-0.38,3.06-0.44,4.7-0.09c3.98,0.86,7.09,4.18,7.7,8.2c1.04,6.81-4.82,12.58-11.64,11.42 C6.23,21.16,2.98,17.99,2.2,14c-0.31-1.59-0.24-3.12,0.12-4.53C2.52,8.72,3.45,8.45,4,9z M7,5.5C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5 S4.67,4,5.5,4S7,4.67,7,5.5z M12,6c-3.31,0-6,2.69-6,6s2.69,6,6,6s6-2.69,6-6S15.31,6,12,6z M10,15L10,15c-0.55,0-1-0.45-1-1v-4 c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v4C11,14.55,10.55,15,10,15z M14,15L14,15c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h0 c0.55,0,1,0.45,1,1v4C15,14.55,14.55,15,14,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blur-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "14", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M13.8 11.48l.2.02c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5l.02.2c.09.67.61 1.19 1.28 1.28zM14 3.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm-4 0c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "10", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "18", :stroke nil, :fill nil})
  (helix.dom/path
   {:d "M21 10.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "6", :cx "10", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "18", :stroke nil, :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M14 20.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7-7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-18 0c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "18", :cx "10", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M3 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7 11c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "1", :cy "14", :cx "6", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M3.21 4.56c-.39.39-.39 1.02 0 1.41l3.07 3.07L6 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l2.81 2.81c-.71.11-1.25.73-1.25 1.47 0 .83.67 1.5 1.5 1.5.74 0 1.36-.54 1.47-1.25l2.81 2.81c-.09-.03-.18-.06-.28-.06-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1c0-.1-.03-.19-.06-.28l3.08 3.07c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.42L4.62 4.56c-.39-.39-1.02-.39-1.41 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _18mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "9",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.75,5.5H9c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12,10.5v-4c0-0.55,0.45-1,1-1 h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H13C12.45,11.5,12,11.05,12,10.5z M18,16c0,0.55-0.45,1-1,1h-2v0.75 c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-front
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 0H7C5.9 0 5 .9 5 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V2c0-1.1-.9-2-2-2zm0 12.5c0-1.67-3.33-2.5-5-2.5s-5 .83-5 2.5V3c0-.55.45-1 1-1h8c.55 0 1 .45 1 1v9.5zm-6.15 6.35c-.31-.31-.85-.09-.85.36V20H6c-.55 0-1 .45-1 1s.45 1 1 1h4v.79c0 .45.54.67.85.35l1.79-1.79c.2-.2.2-.51 0-.71l-1.79-1.79zM18 20h-3c-.55 0-1 .45-1 1s.45 1 1 1h3c.55 0 1-.45 1-1s-.45-1-1-1zM12 8c1.1 0 2-.9 2-2s-.9-2-2-2-1.99.9-1.99 2S10.9 8 12 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-none
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm19-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-weak
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm12-2c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zm0 10c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-vintage
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18.7 12.4c-.28-.16-.57-.29-.86-.4.29-.11.58-.24.86-.4 1.92-1.11 2.99-3.12 3-5.19-1.79-1.03-4.07-1.11-6 0-.28.16-.54.35-.78.54.05-.31.08-.63.08-.95 0-2.22-1.21-4.15-3-5.19C10.21 1.85 9 3.78 9 6c0 .32.03.64.08.95-.24-.2-.5-.39-.78-.55-1.92-1.11-4.2-1.03-6 0 0 2.07 1.07 4.08 3 5.19.28.16.57.29.86.4-.29.11-.58.24-.86.4-1.92 1.11-2.99 3.12-3 5.19 1.79 1.03 4.07 1.11 6 0 .28-.16.54-.35.78-.54-.05.32-.08.64-.08.96 0 2.22 1.21 4.15 3 5.19 1.79-1.04 3-2.97 3-5.19 0-.32-.03-.64-.08-.95.24.2.5.38.78.54 1.92 1.11 4.2 1.03 6 0-.01-2.07-1.08-4.08-3-5.19zM12 16c-2.21 0-4-1.79-4-4s1.79-4 4-4 4 1.79 4 4-1.79 4-4 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11 15h2v-2h-2v2zm8-12H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 6h-3v2h2c1.1 0 2 .9 2 2v2c0 1.11-.9 2-2 2h-2c-1.1 0-2-.89-2-2V9c0-1.1.9-2 2-2h3c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 iso
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zM6.25 7.5H7.5V6.25c0-.41.34-.75.75-.75s.75.34.75.75V7.5h1.25c.41 0 .75.34.75.75s-.34.75-.75.75H9v1.25c0 .41-.34.75-.75.75s-.75-.34-.75-.75V9H6.25c-.41 0-.75-.34-.75-.75s.34-.75.75-.75zM18 19H5L19 5v13c0 .55-.45 1-1 1zm-1-2.75c0-.41-.34-.75-.75-.75h-3.5c-.41 0-.75.34-.75.75s.34.75.75.75h3.5c.41 0 .75-.34.75-.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 leak-add
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.05 21c.5 0 .94-.37.99-.87.41-4.27 3.81-7.67 8.08-8.08.5-.05.88-.48.88-.99 0-.59-.51-1.06-1.1-1-5.19.52-9.32 4.65-9.84 9.83-.06.59.4 1.11.99 1.11zM18 21h3v-3c-1.66 0-3 1.34-3 3zm-2.91 0c.49 0 .9-.36.98-.85.36-2.08 2-3.72 4.08-4.08.49-.08.85-.49.85-.98 0-.61-.54-1.09-1.14-1-2.96.48-5.29 2.81-5.77 5.77-.1.6.39 1.14 1 1.14zM12.97 3.02c-.5 0-.94.37-.99.87-.41 4.27-3.81 7.67-8.08 8.08-.5.05-.88.48-.88.99 0 .59.51 1.06 1.1 1 5.19-.52 9.32-4.65 9.84-9.83.07-.58-.39-1.11-.99-1.11zm-6.94 0h-3v3c1.66 0 3-1.34 3-3zm2.91 0c-.49 0-.9.36-.98.85-.36 2.08-2 3.72-4.08 4.08-.49.09-.85.49-.85.99 0 .61.54 1.09 1.14 1 2.96-.48 5.29-2.81 5.77-5.77.09-.61-.4-1.15-1-1.15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _12mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M12,9c0-0.55,0.45-1,1-1h2V7h-2.25 C12.34,7,12,6.66,12,6.25s0.34-0.75,0.75-0.75h2.75c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1h-2v1h2.25c0.41,0,0.75,0.34,0.75,0.75 s-0.34,0.75-0.75,0.75H12V9z M7.75,5.5H9c0.55,0,1,0.45,1,1v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75 C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25 C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shutter-speed
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 3h4c.55 0 1-.45 1-1s-.45-1-1-1h-4c-.55 0-1 .45-1 1s.45 1 1 1zm9.03 4.39l.75-.75c.38-.38.39-1.01 0-1.4l-.01-.01c-.39-.39-1.01-.38-1.4 0l-.75.75C16.07 4.74 14.12 4 12 4c-4.8 0-8.88 3.96-9 8.76C2.87 17.84 6.94 22 12 22c4.98 0 9-4.03 9-9 0-2.12-.74-4.07-1.97-5.61zM12 20c-3.87 0-7-3.13-7-7s3.13-7 7-7 7 3.13 7 7-3.13 7-7 7zm-1.19-5h-3.7c-.38 0-.62.4-.45.74.56 1.12 1.44 2.01 2.57 2.57.23.11.52.02.65-.21l1.37-2.35c.19-.33-.05-.75-.44-.75zm3.92-7.35c-.23-.12-.52-.02-.65.2l-1.38 2.39c-.2.34.04.76.43.76h3.76c.38 0 .62-.4.45-.73-.58-1.13-1.49-2.04-2.61-2.62zm-.85 7.05c-.19-.34-.68-.35-.87-.01l-2.04 3.52c-.18.32.02.72.39.75 1.34.14 2.69-.18 3.83-.89.22-.14.28-.43.16-.66l-1.47-2.71zm-3.57-1.47L7.93 9.57c-.2-.3-.64-.3-.84 0-.81 1.16-1.17 2.57-1.05 3.98.02.26.24.45.5.45h3.35c.39 0 .63-.44.42-.77zm3.66-.49l2.02 3.74c.18.33.64.35.86.05.86-1.18 1.24-2.62 1.12-4.08-.02-.26-.25-.45-.5-.45h-3.05c-.39 0-.63.4-.45.74zm-3.8-1.57c.2.31.66.3.85-.02l1.94-3.35c.19-.32-.03-.72-.4-.76-1.36-.12-2.73.21-3.88.97-.22.15-.27.46-.13.68l1.62 2.48z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _7mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12.38,11.5 c-0.56,0-0.97-0.54-0.8-1.08L12.62,7h-1.87C10.34,7,10,6.66,10,6.25c0-0.41,0.34-0.75,0.75-0.75h2.75c0.67,0,1.15,0.65,0.96,1.29 l-1.28,4.12C13.07,11.26,12.75,11.5,12.38,11.5z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75 s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-center-focus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 15c-.55 0-1 .45-1 1v3c0 1.1.9 2 2 2h3c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1-.45-1-1v-2c0-.55-.45-1-1-1zm1-9c0-.55.45-1 1-1h2c.55 0 1-.45 1-1s-.45-1-1-1H5c-1.1 0-2 .9-2 2v3c0 .55.45 1 1 1s1-.45 1-1V6zm14-3h-3c-.55 0-1 .45-1 1s.45 1 1 1h2c.55 0 1 .45 1 1v2c0 .55.45 1 1 1s1-.45 1-1V5c0-1.1-.9-2-2-2zm0 15c0 .55-.45 1-1 1h-2c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2v-3c0-.55-.45-1-1-1s-1 .45-1 1v2zm-7-9c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-neg-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 12c0 .55.45 1 1 1h6c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1 .45-1 1zm15 6h-2V7.38L14 8.4V6.7L18.7 5h.3v13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-plus-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 7c-.55 0-1 .45-1 1v3H5c-.55 0-1 .45-1 1s.45 1 1 1h3v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1h-3V8c0-.55-.45-1-1-1zm11 11h-2V7.38L15 8.4V6.7L19.7 5h.3v13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.02 10.99V18c0 .55-.45 1-1 1H6c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h7c.55 0 1-.45 1-1s-.45-1-1-1H5.02c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2H19c1.1 0 2-.89 2-2v-8.01c0-.55-.44-.99-.99-.99s-.99.44-.99.99zm-5.77-.24L12.46 9c-.18-.39-.73-.39-.91 0l-.79 1.75-1.76.79c-.39.18-.39.73 0 .91l1.75.79.79 1.76c.18.39.73.39.91 0l.79-1.75 1.76-.79c.39-.18.39-.73 0-.91l-1.75-.8zm4.69-4.69l-.6-1.32c-.13-.29-.55-.29-.69 0l-.6 1.32-1.32.6c-.29.13-.29.55 0 .69l1.32.6.6 1.32c.13.29.55.29.69 0l.6-1.32 1.32-.6c.29-.13.29-.55 0-.69l-1.32-.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hevc
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.25,9C5.84,9,5.5,9.34,5.5,9.75V11h-1V9.75C4.5,9.34,4.16,9,3.75,9S3,9.34,3,9.75v4.5C3,14.66,3.34,15,3.75,15 s0.75-0.34,0.75-0.75V12.5h1v1.75C5.5,14.66,5.84,15,6.25,15S7,14.66,7,14.25v-4.5C7,9.34,6.66,9,6.25,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10.75,10.5c0.41,0,0.75-0.34,0.75-0.75C11.5,9.34,11.16,9,10.75,9H9c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h1.75 c0.41,0,0.75-0.34,0.75-0.75c0-0.41-0.34-0.75-0.75-0.75H9.5v-1h1.25c0.41,0,0.75-0.34,0.75-0.75c0-0.41-0.34-0.75-0.75-0.75H9.5 v-0.5H10.75z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.63,9c-0.36,0-0.67,0.26-0.73,0.62l-0.65,3.88L13.6,9.62C13.54,9.26,13.23,9,12.87,9c-0.46,0-0.8,0.41-0.73,0.86 l0.65,3.91c0.12,0.71,0.73,1.23,1.46,1.23s1.34-0.52,1.46-1.23l0.65-3.91C16.43,9.41,16.08,9,15.63,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.5,10.5c0,0.28,0.22,0.5,0.5,0.5h0.5c0.28,0,0.5-0.22,0.5-0.5V10c0-0.55-0.45-1-1-1h-2c-0.55,0-1,0.45-1,1v4 c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1v-0.5c0-0.28-0.22-0.5-0.5-0.5H20c-0.28,0-0.5,0.22-0.5,0.5h-1v-3H19.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 timer-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M11.61 12.97c-.16-.24-.36-.46-.62-.65-.25-.19-.56-.35-.93-.48.3-.14.57-.3.8-.5.23-.2.42-.41.57-.64.15-.23.27-.46.34-.71.08-.24.11-.49.11-.73 0-.55-.09-1.04-.28-1.46-.18-.42-.44-.77-.78-1.06-.33-.28-.73-.5-1.2-.64-.45-.13-.97-.2-1.53-.2-.55 0-1.06.08-1.52.24-.47.17-.87.4-1.2.69-.33.29-.6.63-.78 1.03-.2.39-.29.83-.29 1.29h1.98c0-.26.05-.49.14-.69.09-.2.22-.38.38-.52.17-.14.36-.25.58-.33s.46-.12.73-.12c.61 0 1.06.16 1.36.47.3.31.44.75.44 1.32 0 .27-.04.52-.12.74-.08.22-.21.41-.38.57s-.38.28-.63.37-.55.13-.89.13H6.72v1.57H7.9c.34 0 .64.04.91.11.27.08.5.19.69.35.19.16.34.36.44.61.1.24.16.54.16.87 0 .62-.18 1.09-.53 1.42-.35.33-.84.49-1.45.49-.29 0-.56-.04-.8-.13-.24-.08-.44-.2-.61-.36s-.3-.34-.39-.56c-.09-.22-.14-.46-.14-.72H4.19c0 .55.11 1.03.32 1.45.21.42.5.77.86 1.05s.77.49 1.24.63.96.21 1.48.21c.57 0 1.09-.08 1.58-.23s.91-.38 1.26-.68c.36-.3.64-.66.84-1.1.2-.43.3-.93.3-1.48 0-.29-.04-.58-.11-.86-.08-.25-.19-.51-.35-.76zm9.26 1.4c-.14-.28-.35-.53-.63-.74-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23-.23-.08-.41-.16-.55-.25s-.23-.19-.28-.3c-.05-.11-.08-.24-.08-.39s.03-.28.09-.41.15-.25.27-.34c.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11s.35.17.48.29.22.26.29.42c.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09s-.39-.63-.69-.88c-.3-.25-.66-.44-1.09-.59-.43-.15-.92-.22-1.46-.22-.51 0-.98.07-1.39.21s-.77.33-1.06.57c-.29.24-.51.52-.67.84s-.23.65-.23 1.01.08.68.23.96.37.52.64.73c.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34.05.12.07.25.07.39 0 .32-.13.57-.4.77s-.66.29-1.17.29c-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44-.11-.18-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05s.39.65.7.93c.31.27.69.49 1.15.66.46.17.98.25 1.58.25.53 0 1.01-.06 1.44-.19.43-.13.8-.31 1.11-.54.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 image-not-supported
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M21.19,21.19l-0.78-0.78L18,18l-4.59-4.59L3.59,3.59v0L2.81,2.81c-0.39-0.39-1.02-0.39-1.41,0C1,3.2,1,3.83,1.39,4.22 L3,5.83V19c0,1.1,0.9,2,2,2h13.17l1.61,1.61c0.39,0.39,1.02,0.39,1.41,0C21.58,22.22,21.58,21.58,21.19,21.19z M6.02,18 c-0.42,0-0.65-0.48-0.39-0.81l2.49-3.2c0.2-0.25,0.58-0.26,0.78-0.01l2.1,2.53L12.17,15l3,3H6.02z M21,18.17L5.83,3H19 c1.1,0,2,0.9,2,2V18.17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 photo-camera-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,5h-3.17l-1.24-1.35C15.22,3.24,14.68,3,14.12,3H9.88C9.32,3,8.78,3.24,8.41,3.65L7.17,5H4C2.9,5,2,5.9,2,7v12 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M17,17H7c-0.41,0-0.65-0.47-0.4-0.8l2-2.67c0.2-0.27,0.6-0.27,0.8,0 L11.25,16l2.6-3.47c0.2-0.27,0.6-0.27,0.8,0l2.75,3.67C17.65,16.53,17.41,17,17,17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 filter-frames
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4h-4L12.71.71c-.39-.39-1.02-.39-1.41 0L8 4H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-1 16H5c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1h3.52l3.52-3.5L15.52 6H19c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zM17 8H7c-.55 0-1 .45-1 1v8c0 .55.45 1 1 1h10c.55 0 1-.45 1-1V9c0-.55-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dehaze
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 17c0 .55.45 1 1 1h18c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1zm0-5c0 .55.45 1 1 1h18c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1zm0-5c0 .55.45 1 1 1h18c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-5-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,4H5C3.9,4,3,4.9,3,6v12c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V6C21,4.9,20.1,4,19,4z M19,18H5V6h14V18z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 movie-creation
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 4l1.82 3.64c.08.16-.04.36-.22.36h-1.98c-.38 0-.73-.21-.89-.55L15 4h-2l1.82 3.64c.08.16-.04.36-.22.36h-1.98c-.38 0-.73-.21-.89-.55L10 4H8l1.82 3.64c.08.16-.04.36-.22.36H7.62c-.38 0-.73-.21-.9-.55L5 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V5c0-.55-.45-1-1-1h-3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 control-point
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 7c-.55 0-1 .45-1 1v3H8c-.55 0-1 .45-1 1s.45 1 1 1h3v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1h-3V8c0-.55-.45-1-1-1zm0-5C6.49 2 2 6.49 2 12s4.49 10 10 10 10-4.49 10-10S17.51 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-drama
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.35 10.04C18.67 6.59 15.64 4 12 4 9.11 4 6.61 5.64 5.36 8.04 2.35 8.36 0 10.9 0 14c0 3.31 2.69 6 6 6h13c2.76 0 5-2.24 5-5 0-2.64-2.05-4.78-4.65-4.96zM19 18H6.17c-2.09 0-3.95-1.53-4.15-3.61C1.79 12.01 3.66 10 6 10c1.92 0 3.53 1.36 3.91 3.17.1.48.5.83.98.83.61 0 1.11-.55.99-1.15-.43-2.24-2.11-4.03-4.29-4.63 1.1-1.46 2.89-2.37 4.89-2.2 2.88.25 5.01 2.82 5.01 5.71V12h1.37c1.45 0 2.79.97 3.07 2.4.39 1.91-1.08 3.6-2.93 3.6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-rupee
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.5,14H9.77l5.1,5.31c0.61,0.64,0.16,1.69-0.72,1.69c-0.27,0-0.53-0.11-0.72-0.31L7.4,14.41C7.14,14.15,7,13.79,7,13.43 C7,12.64,7.64,12,8.43,12h2.07c1.76,0,3.22-1.3,3.46-3L7,9C6.45,9,6,8.55,6,8s0.45-1,1-1l6.66,0C13.1,5.82,11.9,5,10.5,5L7,5 C6.45,5,6,4.55,6,4s0.45-1,1-1h10c0.55,0,1,0.45,1,1s-0.45,1-1,1l-2.26,0c0.48,0.58,0.84,1.26,1.05,2L17,7c0.55,0,1,0.45,1,1 s-0.45,1-1,1l-1.02,0C15.72,11.8,13.36,14,10.5,14z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _24mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M6.5,9c0-0.55,0.45-1,1-1h2V7H7.25 C6.84,7,6.5,6.66,6.5,6.25S6.84,5.5,7.25,5.5H10c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H8v1h2.25c0.41,0,0.75,0.34,0.75,0.75 s-0.34,0.75-0.75,0.75H7.5c-0.55,0-1-0.45-1-1V9z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25 C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z M17.75,10H17.5v0.75c0,0.41-0.34,0.75-0.75,0.75S16,11.16,16,10.75V10h-2 c-0.55,0-1-0.45-1-1V6.25c0-0.41,0.34-0.75,0.75-0.75s0.75,0.34,0.75,0.75V8.5H16V6.25c0-0.41,0.34-0.75,0.75-0.75 s0.75,0.34,0.75,0.75V8.5h0.25c0.41,0,0.75,0.34,0.75,0.75S18.16,10,17.75,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 hide-image
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M19,3H5.83L21,18.17V5C21,3.9,20.1,3,19,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0c-0.39,0.39-0.39,1.02,0,1.41L3,5.83V19c0,1.1,0.9,2,2,2h13.17l0.9,0.9 c0.39,0.39,1.02,0.39,1.41,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51z M7,17c-0.41,0-0.65-0.47-0.4-0.8l2-2.67 c0.2-0.27,0.6-0.27,0.8,0L11.25,16l0.82-1.1l2.1,2.1H7z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 raw-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6.5,9H4c-0.55,0-1,0.45-1,1v4.31C3,14.69,3.31,15,3.69,15h0.11c0.38,0,0.69-0.31,0.69-0.69V13h1.1l0.72,1.59 C6.43,14.84,6.68,15,6.95,15h0c0.5,0,0.83-0.51,0.64-0.97L7.1,12.9C7.6,12.6,8,12.1,8,11.5v-1C8,9.68,7.32,9,6.5,9z M6.5,11.5h-2 v-1h2V11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.5,9c-0.73,0-1.37,0.5-1.55,1.21L8.98,14.1C8.86,14.56,9.21,15,9.68,15h0c0.33,0,0.62-0.23,0.7-0.55l0.24-0.95h1.75 l0.23,0.95c0.08,0.32,0.37,0.55,0.71,0.55h0c0.47,0,0.82-0.44,0.71-0.9l-0.97-3.88C12.87,9.5,12.23,9,11.5,9L11.5,9z M11,12 l0.25-1h0.5L12,12H11z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.84,9.55L19.24,12l-0.56-2.26C18.58,9.3,18.19,9,17.74,9l0,0c-0.45,0-0.84,0.3-0.94,0.74L16.24,12l-0.6-2.45 C15.56,9.23,15.27,9,14.93,9h0c-0.47,0-0.82,0.44-0.71,0.9l1.09,4.38C15.43,14.7,15.81,15,16.24,15l0,0c0.43,0,0.81-0.3,0.92-0.72 l0.58-2.32l0.58,2.32C18.43,14.7,18.81,15,19.24,15l0,0c0.43,0,0.81-0.3,0.92-0.72l1.09-4.38C21.37,9.44,21.02,9,20.55,9h0 C20.21,9,19.92,9.23,19.84,9.55z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-photosphere
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.95,8.15c-0.29-0.16-0.61-0.31-0.93-0.46C19.4,4.33,15.98,2,12,2C8.02,2,4.6,4.33,2.99,7.68 c-0.33,0.15-0.64,0.3-0.93,0.46C1.41,8.5,1,9.17,1,9.91v4.18c0,0.74,0.41,1.41,1.05,1.77c0.29,0.16,0.61,0.31,0.93,0.46 C4.6,19.67,8.02,22,12,22c3.98,0,7.4-2.33,9.01-5.68c0.33-0.15,0.64-0.3,0.93-0.46C22.59,15.5,23,14.83,23,14.09V9.91 C23,9.17,22.59,8.5,21.95,8.15z M12,4c2.37,0,4.49,1.04,5.95,2.68C16.17,6.25,14.15,6,12,6C9.85,6,7.83,6.25,6.05,6.68 C7.51,5.04,9.63,4,12,4z M12,20c-2.37,0-4.49-1.04-5.95-2.68C7.83,17.75,9.85,18,12,18s4.17-0.25,5.95-0.68 C16.49,18.96,14.37,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.81 2.86c.17-.3 0-.7-.35-.74-2.62-.37-5.3.28-7.44 1.86-.19.15-.25.43-.12.65l3.01 5.22c.19.33.67.33.87 0l4.03-6.99zm7.49 5.47c-.98-2.47-2.92-4.46-5.35-5.5-.23-.1-.5 0-.63.22l-3.01 5.21c-.19.32.05.74.44.74h8.08c.35 0 .6-.35.47-.67zm.07 1.67h-6.2c-.38 0-.63.42-.43.75L19 18.14c.17.3.6.35.82.08 1.74-2.18 2.48-5.03 2.05-7.79-.03-.25-.25-.43-.5-.43zM4.18 5.79c-1.73 2.19-2.48 5.02-2.05 7.79.03.24.25.42.5.42h6.2c.38 0 .63-.42.43-.75L5 5.87c-.18-.3-.61-.35-.82-.08zM2.7 15.67c.98 2.47 2.92 4.46 5.35 5.5.23.1.5 0 .63-.22l3.01-5.21c.19-.33-.05-.75-.43-.75H3.17c-.35.01-.6.36-.47.68zm7.83 6.22c2.62.37 5.3-.28 7.44-1.86.2-.15.26-.44.13-.66l-3.01-5.22c-.19-.33-.67-.33-.87 0l-4.04 6.99c-.17.3.01.7.35.75z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 deblur
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M12,3v18c4.97,0,9-4.03,9-9C21,7.03,16.97,3,12,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "14", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "18", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "10", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "10", :cx "3", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6", :cx "6", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "14", :cx "3", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "21", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r ".5", :cy "3", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "6", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "14", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.5", :cy "10", :cx "10", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "18", :cx "10", :stroke nil, :fill nil})))))


(helix.core/defnc
 wb-auto
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.85 12.65h2.3L8 9zM22.72 7c-.42 0-.77.3-.85.7l-1.07 5.59-1.31-5.51c-.11-.46-.52-.78-.99-.78s-.88.32-.98.78l-1.31 5.51-1.07-5.59c-.08-.4-.44-.7-.85-.7-.01 0-.03.01-.04.01C12.78 5.18 10.53 4 8 4c-4.42 0-8 3.58-8 8s3.58 8 8 8c3.17 0 5.9-1.85 7.2-4.52.2.32.55.52.94.52.51 0 .95-.35 1.07-.84L18.5 9.9l1.29 5.26c.12.49.57.84 1.07.84.52 0 .96-.36 1.08-.86l1.61-7.08c.13-.54-.28-1.06-.83-1.06zm-11.79 9c-.38 0-.72-.24-.84-.6L9.6 14H6.4l-.49 1.4c-.13.36-.46.6-.84.6-.62 0-1.05-.61-.84-1.19l2.44-6.86C6.87 7.38 7.4 7 8 7s1.13.38 1.34.94l2.44 6.86c.2.59-.23 1.2-.85 1.2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zM2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm15 8v-2c0-1.1-.9-2-2-2h-2V7h3c.55 0 1-.45 1-1s-.45-1-1-1h-4c-.55 0-1 .45-1 1v4c0 .55.45 1 1 1h3v2h-3c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm19-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zm-4-4h-3v-2h2c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2h-3c-.55 0-1 .45-1 1s.45 1 1 1h3v2h-2c-1.1 0-2 .9-2 2v3c0 .55.45 1 1 1h4c.55 0 1-.45 1-1s-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 face-retouching-natural
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22.01,4.05L20.6,3.4l-0.65-1.41c-0.18-0.39-0.73-0.39-0.91,0L18.4,3.4l-1.41,0.65c-0.39,0.18-0.39,0.73,0,0.91L18.4,5.6 l0.65,1.41c0.18,0.39,0.73,0.39,0.91,0L20.6,5.6l1.41-0.65C22.4,4.78,22.4,4.22,22.01,4.05z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M19.5,8.8c-0.78,0-1.49-0.46-1.82-1.17l-0.41-0.9l-0.9-0.41C15.66,5.99,15.2,5.28,15.2,4.5c0-0.66,0.34-1.26,0.87-1.63 C14.83,2.32,13.45,2,12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10c0-1.45-0.32-2.83-0.87-4.07 C20.76,8.46,20.16,8.8,19.5,8.8z M12,20c-4.41,0-8-3.59-8-8c0-0.05,0.01-0.1,0-0.14c2.6-0.98,4.69-2.99,5.74-5.55 C11.58,8.56,14.37,10,17.5,10c0.75,0,1.47-0.09,2.17-0.24C19.88,10.47,20,11.22,20,12C20,16.41,16.41,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-b-and-w
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm0 16l-7-8v8H5l7-8V5h6c.55 0 1 .45 1 1v13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-horizontal-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,5.5c-3.89,0-6.95-0.84-8.69-1.43C2.67,3.85,2,4.33,2,5.02L2,19c0,0.68,0.66,1.17,1.31,0.95 C5.36,19.26,8.1,18.5,12,18.5c3.87,0,6.66,0.76,8.69,1.45C21.34,20.16,22,19.68,22,19l0-14c0-0.68-0.66-1.17-1.31-0.95 C18.66,4.73,15.86,5.5,12,5.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 hdr-enhanced-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C8.69,2,6,4.69,6,8s2.69,6,6,6s6-2.69,6-6S15.31,2,12,2z M14,9h-1v1c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1V9h-1 C9.45,9,9,8.55,9,8v0c0-0.55,0.45-1,1-1h1V6c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v1h1c0.55,0,1,0.45,1,1v0C15,8.55,14.55,9,14,9 z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,16H7c-0.28,0-0.5,0.22-0.5,0.5v5C6.5,21.78,6.72,22,7,22h3c0.82,0,1.5-0.67,1.5-1.5v-3C11.5,16.67,10.82,16,10,16z M10,20.5H8v-3h2V20.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.5,16H14c-0.55,0-1,0.45-1,1v4.31c0,0.38,0.31,0.69,0.69,0.69h0.11c0.38,0,0.69-0.31,0.69-0.69V20h1.1l0.72,1.59 c0.11,0.25,0.36,0.41,0.63,0.41h0c0.5,0,0.83-0.51,0.64-0.97L17.1,19.9c0.5-0.3,0.9-0.8,0.9-1.4v-1C18,16.67,17.33,16,16.5,16z M16.5,18.5h-2v-1h2V18.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M3.5,18h-2v-1.25C1.5,16.34,1.16,16,0.75,16h0C0.34,16,0,16.34,0,16.75v4.5C0,21.66,0.34,22,0.75,22h0 c0.41,0,0.75-0.34,0.75-0.75V19.5h2v1.75C3.5,21.66,3.84,22,4.25,22h0C4.66,22,5,21.66,5,21.25v-4.5C5,16.34,4.66,16,4.25,16h0 c-0.41,0-0.75,0.34-0.75,0.75V18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M22,18.5v-1.25c0-0.41-0.34-0.75-0.75-0.75l0,0c-0.41,0-0.75,0.34-0.75,0.75v1.25h-1.25c-0.41,0-0.75,0.34-0.75,0.75l0,0 c0,0.41,0.34,0.75,0.75,0.75h1.25v1.25c0,0.41,0.34,0.75,0.75,0.75l0,0c0.41,0,0.75-0.34,0.75-0.75V20h1.25 c0.41,0,0.75-0.34,0.75-0.75l0,0c0-0.41-0.34-0.75-0.75-0.75H22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _60fps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,6v6h-3V6H18z M18,4h-3c-1.1,0-2,0.9-2,2v6c0,1.1,0.9,2,2,2h3c1.1,0,2-0.9,2-2V6C20,4.9,19.1,4,18,4z M11,5L11,5 c0-0.55-0.45-1-1-1H6C4.9,4,4,4.9,4,6v6c0,1.1,0.9,2,2,2h3c1.1,0,2-0.9,2-2v-2c0-1.1-0.9-2-2-2H6V6h4C10.55,6,11,5.55,11,5z M9,10 v2H6v-2H9z M4,22L4,22c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v3C5,21.55,4.55,22,4,22z M8,22L8,22 c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v3C9,21.55,8.55,22,8,22z M12,22L12,22c-0.55,0-1-0.45-1-1v-3 c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v3C13,21.55,12.55,22,12,22z M20,22h-4c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1h4 c0.55,0,1,0.45,1,1v3C21,21.55,20.55,22,20,22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 thermostat-auto
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M11,12V6c0-1.66-1.34-3-3-3S5,4.34,5,6v6c-1.21,0.91-2,2.37-2,4c0,1.12,0.38,2.14,1,2.97V19h0.02c0.91,1.21,2.35,2,3.98,2 s3.06-0.79,3.98-2H12v-0.03c0.62-0.83,1-1.85,1-2.97C13,14.37,12.21,12.91,11,12z M5,16c0-0.94,0.45-1.84,1.2-2.4L7,13V6 c0-0.55,0.45-1,1-1s1,0.45,1,1v7l0.8,0.6c0.75,0.57,1.2,1.46,1.2,2.4H5z M17.81,4L17.81,4c-0.48,0-0.92,0.3-1.09,0.75L14,12.02 C13.82,12.49,14.17,13,14.67,13h0c0.31,0,0.58-0.19,0.68-0.48L16,10.7h3.63l0.64,1.82c0.1,0.29,0.38,0.48,0.68,0.48l0,0 c0.51,0,0.86-0.51,0.68-0.98L18.9,4.75C18.73,4.3,18.3,4,17.81,4z M16.47,9.39l1.31-3.72h0.08l1.31,3.72H16.47z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 control-point-duplicate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 8c-.55 0-1 .45-1 1v2h-2c-.55 0-1 .45-1 1s.45 1 1 1h2v2c0 .55.45 1 1 1s1-.45 1-1v-2h2c.55 0 1-.45 1-1s-.45-1-1-1h-2V9c0-.55-.45-1-1-1zM2 12c0-2.58 1.4-4.83 3.48-6.04.32-.19.53-.51.53-.88 0-.77-.84-1.25-1.51-.86C1.82 5.78 0 8.68 0 12s1.82 6.22 4.5 7.78c.67.39 1.51-.09 1.51-.86 0-.37-.21-.69-.53-.88C3.4 16.83 2 14.58 2 12zm13-9c-4.96 0-9 4.04-9 9s4.04 9 9 9 9-4.04 9-9-4.04-9-9-9zm0 16c-3.86 0-7-3.14-7-7s3.14-7 7-7 7 3.14 7 7-3.14 7-7 7z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 1H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zM2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm15 8v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V7c0-1.1-.9-2-2-2h-3c-.55 0-1 .45-1 1s.45 1 1 1h3v2h-1c-.55 0-1 .45-1 1s.45 1 1 1h1v2h-3c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10,3h4c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1h-4C9.45,1,9,1.45,9,2C9,2.55,9.45,3,10,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.03,7.39l0.75-0.75c0.38-0.38,0.39-1.01,0-1.4c0,0-0.01-0.01-0.01-0.01c-0.39-0.39-1.01-0.38-1.4,0l-0.75,0.75 C16.07,4.74,14.12,4,12,4c-4.8,0-8.88,3.96-9,8.76C2.87,17.84,6.94,22,12,22c4.98,0,9-4.03,9-9C21,10.88,20.26,8.93,19.03,7.39z M13,13c0,0.55-0.45,1-1,1s-1-0.45-1-1V9c0-0.55,0.45-1,1-1s1,0.45,1,1V13z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 wb-incandescent
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4.25 19.79c.39.39 1.02.39 1.41 0l.39-.39c.39-.39.38-1.02 0-1.4l-.01-.01c-.39-.39-1.02-.39-1.41 0l-.39.39c-.38.4-.38 1.02.01 1.41zM11.99 23H12c.55 0 .99-.44.99-.99v-.96c0-.55-.44-.99-.99-.99h-.01c-.55 0-.99.44-.99.99v.96c0 .55.44.99.99.99zM3.01 11.05H1.99c-.55 0-.99.44-.99.99v.01c0 .55.44.99.99.99H3c.55 0 .99-.44.99-.99v-.01c.01-.55-.43-.99-.98-.99zM15 6.86V3.05c0-.55-.45-1-1-1h-4c-.55 0-1 .45-1 1v3.81c-2.04 1.18-3.32 3.52-2.93 6.13.4 2.61 2.56 4.7 5.18 5.02 3.64.44 6.75-2.4 6.75-5.95 0-2.23-1.21-4.16-3-5.2zm5 5.18v.01c0 .55.44.99.99.99H22c.55 0 .99-.44.99-.99v-.01c0-.55-.44-.99-.99-.99h-1.01c-.55 0-.99.44-.99.99zm-2.06 7.37l.39.39c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41l-.39-.39c-.39-.39-1.02-.38-1.4 0-.4.4-.4 1.02-.01 1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 straighten
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 6H3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-1 10H4c-.55 0-1-.45-1-1V9c0-.55.45-1 1-1h1v3c0 .55.45 1 1 1s1-.45 1-1V8h2v3c0 .55.45 1 1 1s1-.45 1-1V8h2v3c0 .55.45 1 1 1s1-.45 1-1V8h2v3c0 .55.45 1 1 1s1-.45 1-1V8h1c.55 0 1 .45 1 1v6c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _20mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M6.5,9c0-0.55,0.45-1,1-1h2V7H7.25 C6.84,7,6.5,6.66,6.5,6.25S6.84,5.5,7.25,5.5H10c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H8v1h2.25c0.41,0,0.75,0.34,0.75,0.75 s-0.34,0.75-0.75,0.75H7.5c-0.55,0-1-0.45-1-1V9z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25 C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M13,10.5v-4c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H14 C13.45,11.5,13,11.05,13,10.5z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7",
      :x "14.5",
      :width "1.5",
      :height "3",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm14 10c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1s-1 .45-1 1v3h-2V6c0-.55-.45-1-1-1s-1 .45-1 1v4c0 .55.45 1 1 1h3v3c0 .55.45 1 1 1zm5-14H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-fish-eye
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.47 2 2 6.47 2 12s4.47 10 10 10 10-4.47 10-10S17.53 2 12 2zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 15h2V7c0-1.1-.9-2-2-2H9v2h7c.55 0 1 .45 1 1v7zm-9 2c-.55 0-1-.45-1-1V2c0-.55-.45-1-1-1s-1 .45-1 1v3H2c-.55 0-1 .45-1 1s.45 1 1 1h3v10c0 1.1.9 2 2 2h10v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1H8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timelapse
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.24 7.76C15.07 6.59 13.54 6 12 6v6l-4.24 4.24c2.34 2.34 6.14 2.34 8.49 0 2.34-2.34 2.34-6.14-.01-8.48zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _30fps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M4,5L4,5c0,0.55,0.45,1,1,1h4v2H6C5.45,8,5,8.45,5,9v0c0,0.55,0.45,1,1,1h3v2H5c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h4 c1.1,0,2-0.9,2-2v-1.5C11,9.67,10.83,9,10,9c0.83,0,1-0.67,1-1.5V6c0-1.1-0.9-2-2-2H5C4.45,4,4,4.45,4,5z M18,4c1.1,0,2,0.9,2,2v6 c0,1.1-0.9,2-2,2h-3c-1.1,0-2-0.9-2-2V6c0-1.1,0.9-2,2-2H18z M18,6h-3v6h3V6z M4,22L4,22c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1 h0c0.55,0,1,0.45,1,1v3C5,21.55,4.55,22,4,22z M8,22L8,22c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v3 C9,21.55,8.55,22,8,22z M12,22L12,22c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v3C13,21.55,12.55,22,12,22z M20,22h-4c-0.55,0-1-0.45-1-1v-3c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1v3C21,21.55,20.55,22,20,22z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _15mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.75,5.5H9c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12,10.75 c0-0.41,0.34-0.75,0.75-0.75H15V9h-2c-0.55,0-1-0.45-1-1V6.5c0-0.55,0.45-1,1-1h2.75c0.41,0,0.75,0.34,0.75,0.75S16.16,7,15.75,7 H13.5v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1h-2.75C12.34,11.5,12,11.16,12,10.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75 c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 color-lens
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 3c-4.97 0-9 4.03-9 9s4.03 9 9 9c.83 0 1.5-.67 1.5-1.5 0-.39-.15-.74-.39-1.01-.23-.26-.38-.61-.38-.99 0-.83.67-1.5 1.5-1.5H16c2.76 0 5-2.24 5-5 0-4.42-4.03-8-9-8zm-5.5 9c-.83 0-1.5-.67-1.5-1.5S5.67 9 6.5 9 8 9.67 8 10.5 7.33 12 6.5 12zm3-4C8.67 8 8 7.33 8 6.5S8.67 5 9.5 5s1.5.67 1.5 1.5S10.33 8 9.5 8zm5 0c-.83 0-1.5-.67-1.5-1.5S13.67 5 14.5 5s1.5.67 1.5 1.5S15.33 8 14.5 8zm3 4c-.83 0-1.5-.67-1.5-1.5S16.67 9 17.5 9s1.5.67 1.5 1.5-.67 1.5-1.5 1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 portrait
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 12.25c1.24 0 2.25-1.01 2.25-2.25S13.24 7.75 12 7.75 9.75 8.76 9.75 10s1.01 2.25 2.25 2.25zm4.5 4c0-1.5-3-2.25-4.5-2.25s-4.5.75-4.5 2.25V17h9v-.75zM19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H6c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flash-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.12 11.5c.39-.67-.09-1.5-.86-1.5h-1.87l2.28 2.28.45-.78zm.16-8.05c.33-.67-.15-1.45-.9-1.45H8c-.55 0-1 .45-1 1v.61l6.13 6.13 3.15-6.29zm2.16 14.43L4.12 3.56c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41L7 9.27V12c0 .55.45 1 1 1h2v7.15c0 .51.67.69.93.25l2.65-4.55 3.44 3.44c.39.39 1.02.39 1.41 0 .4-.39.4-1.02.01-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-stories
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.15,1.35l-4,4C14.05,5.45,14,5.57,14,5.71v8.17c0,0.43,0.51,0.66,0.83,0.37l4-3.6c0.11-0.09,0.17-0.23,0.17-0.37V1.71 C19,1.26,18.46,1.04,18.15,1.35z M22.47,5.2C22,4.96,21.51,4.76,21,4.59v12.03C19.86,16.21,18.69,16,17.5,16 c-1.9,0-3.78,0.54-5.5,1.58V5.48C10.38,4.55,8.51,4,6.5,4C4.71,4,3.02,4.44,1.53,5.2C1.2,5.36,1,5.71,1,6.08v12.08 c0,0.76,0.81,1.23,1.48,0.87C3.69,18.4,5.05,18,6.5,18c2.07,0,3.98,0.82,5.5,2c1.52-1.18,3.43-2,5.5-2c1.45,0,2.81,0.4,4.02,1.04 C22.19,19.4,23,18.93,23,18.17V6.08C23,5.71,22.8,5.36,22.47,5.2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 cases
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,5V3c0-1.1-0.9-2-2-2h-4c-1.1,0-2,0.9-2,2v2H7C5.9,5,5,5.9,5,7v9c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V7c0-1.1-0.9-2-2-2 H18z M16,5h-4V3h4V5z M2,9L2,9c-0.55,0-1,0.45-1,1v10c0,1.1,0.9,2,2,2h15c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H3V10 C3,9.45,2.55,9,2,9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 grid-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 2H4c-1.1 0-2 .9-2 2v16c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zM8 20H5c-.55 0-1-.45-1-1v-3h4v4zm0-6H4v-4h4v4zm0-6H4V5c0-.55.45-1 1-1h3v4zm6 12h-4v-4h4v4zm0-6h-4v-4h4v4zm0-6h-4V4h4v4zm5 12h-3v-4h4v3c0 .55-.45 1-1 1zm1-6h-4v-4h4v4zm0-6h-4V4h3c.55 0 1 .45 1 1v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 animation
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M15,2c-2.71,0-5.05,1.54-6.22,3.78c-1.28,0.67-2.34,1.72-3,3C3.54,9.95,2,12.29,2,15c0,3.87,3.13,7,7,7 c2.71,0,5.05-1.54,6.22-3.78c1.28-0.67,2.34-1.72,3-3C20.46,14.05,22,11.71,22,9C22,5.13,18.87,2,15,2z M9,20c-2.76,0-5-2.24-5-5 c0-1.12,0.37-2.16,1-3c0,3.87,3.13,7,7,7C11.16,19.63,10.12,20,9,20z M12,17c-2.76,0-5-2.24-5-5c0-1.12,0.37-2.16,1-3 c0,3.86,3.13,6.99,7,7C14.16,16.63,13.12,17,12,17z M16.7,13.7C16.17,13.89,15.6,14,15,14c-2.76,0-5-2.24-5-5 c0-0.6,0.11-1.17,0.3-1.7C10.83,7.11,11.4,7,12,7c2.76,0,5,2.24,5,5C17,12.6,16.89,13.17,16.7,13.7z M19,12c0-3.86-3.13-6.99-7-7 c0.84-0.63,1.87-1,3-1c2.76,0,5,2.24,5,5C20,10.12,19.63,11.16,19,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flip
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15 21h2v-2h-2v2zm4-12h2V7h-2v2zM3 5v14c0 1.1.9 2 2 2h3c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h2c.55 0 1-.45 1-1s-.45-1-1-1H5c-1.1 0-2 .9-2 2zm16-2v2h2c0-1.1-.9-2-2-2zm-7 20c.55 0 1-.45 1-1V2c0-.55-.45-1-1-1s-1 .45-1 1v20c0 .55.45 1 1 1zm7-6h2v-2h-2v2zM15 5h2V3h-2v2zm4 8h2v-2h-2v2zm0 8c1.1 0 2-.9 2-2h-2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 details
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M11.13,4.57l-8.3,14.94C2.46,20.18,2.94,21,3.7,21h16.6c0.76,0,1.24-0.82,0.87-1.49l-8.3-14.94 C12.49,3.89,11.51,3.89,11.13,4.57z M13,8.92L18.6,19H13V8.92z M11,8.92V19H5.4L11,8.92z",
    :stroke nil,
    :fill nil})
  (helix.dom/g nil (helix.dom/g nil (helix.dom/g nil)))))


(helix.core/defnc
 video-camera-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,10.48V6c0-1.1-0.9-2-2-2H4C2.9,4,2,4.9,2,6v12c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-4.48l3.15,3.13 C21.46,16.97,22,16.74,22,16.3V7.7c0-0.44-0.54-0.67-0.85-0.35L18,10.48z M5.6,15.2l1.38-1.83c0.2-0.27,0.6-0.27,0.8,0L9,15 l2.23-2.97c0.2-0.27,0.6-0.27,0.8,0l2.38,3.17c0.25,0.33,0.01,0.8-0.4,0.8H6C5.59,16,5.35,15.53,5.6,15.2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 add-a-photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 8c0 .55.45 1 1 1s1-.45 1-1V6h2c.55 0 1-.45 1-1s-.45-1-1-1H5V2c0-.55-.45-1-1-1s-1 .45-1 1v2H1c-.55 0-1 .45-1 1s.45 1 1 1h2v2z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "3", :cy "14", :cx "13", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M21 6h-3.17l-1.24-1.35c-.37-.41-.91-.65-1.47-.65h-6.4c.17.3.28.63.28 1 0 1.1-.9 2-2 2H6v1c0 1.1-.9 2-2 2-.37 0-.7-.11-1-.28V20c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V8c0-1.1-.9-2-2-2zm-8 13c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 style
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2.53 19.65l1.34.56v-9.03l-2.43 5.86c-.41 1.02.08 2.19 1.09 2.61zm19.5-3.7L17.07 3.98c-.31-.75-1.04-1.21-1.81-1.23-.26 0-.53.04-.79.15L7.1 5.95c-.75.31-1.21 1.03-1.23 1.8-.01.27.04.54.15.8l4.96 11.97c.31.76 1.05 1.22 1.83 1.23.26 0 .52-.05.77-.15l7.36-3.05c1.02-.42 1.51-1.59 1.09-2.6zM7.88 8.75c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm-2 11c0 1.1.9 2 2 2h1.45l-3.45-8.34v6.34z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-vertical-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.5,12c0-3.89,0.84-6.95,1.43-8.69C20.15,2.67,19.67,2,18.98,2L5,2C4.32,2,3.84,2.66,4.05,3.31C4.74,5.36,5.5,8.1,5.5,12 c0,3.87-0.76,6.66-1.45,8.69C3.84,21.34,4.32,22,5,22h14c0.68,0,1.17-0.66,0.95-1.31C19.27,18.66,18.5,15.86,18.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 currency-ruble
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8,21c0.55,0,1-0.45,1-1v-2h3c0.55,0,1-0.45,1-1s-0.45-1-1-1H9v-2h4.5c3.22,0,5.79-2.76,5.47-6.04 C18.7,5.1,16.14,3,13.26,3l-0.96,0H8C7.45,3,7,3.45,7,4v8H6c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h1v2H6c-0.55,0-1,0.45-1,1 s0.45,1,1,1h1v2C7,20.55,7.45,21,8,21z M13.5,12H9V5h4.5C15.43,5,17,6.57,17,8.5S15.43,12,13.5,12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 crop-din
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H6c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-square
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 4H6c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-1 14H7c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1h10c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 nature
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13 16.12c3.37-.4 6.01-3.19 6.16-6.64.17-3.87-3.02-7.25-6.89-7.31-3.92-.05-7.1 3.1-7.1 7 0 3.47 2.52 6.34 5.83 6.89V20H6c-.55 0-1 .45-1 1s.45 1 1 1h12c.55 0 1-.45 1-1s-.45-1-1-1h-5v-3.88z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-fix-normal
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.45,6l0.49-1.06L22,4.45c0.39-0.18,0.39-0.73,0-0.91l-1.06-0.49L20.45,2c-0.18-0.39-0.73-0.39-0.91,0l-0.49,1.06 L18,3.55c-0.39,0.18-0.39,0.73,0,0.91l1.06,0.49L19.55,6C19.72,6.39,20.28,6.39,20.45,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M17.71,9.12l-2.83-2.83c-0.39-0.39-1.02-0.39-1.41,0L2.29,17.46c-0.39,0.39-0.39,1.02,0,1.41l2.83,2.83 c0.39,0.39,1.02,0.39,1.41,0l11.17-11.17C18.1,10.15,18.1,9.51,17.71,9.12z M14.21,11.21l-1.41-1.41l1.38-1.38l1.41,1.41 L14.21,11.21z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _11mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M8.75,5.5H10c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S9.5,11.16,9.5,10.75V7H8.75C8.34,7,8,6.66,8,6.25S8.34,5.5,8.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M13,6.25 c0-0.41,0.34-0.75,0.75-0.75H15c0.55,0,1,0.45,1,1v4.25c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V7h-0.75 C13.34,7,13,6.66,13,6.25z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-hdr
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.2 7.07L10.25 11l2.25 3c.33.44.24 1.07-.2 1.4-.44.33-1.07.25-1.4-.2-1.05-1.4-2.31-3.07-3.1-4.14-.4-.53-1.2-.53-1.6 0l-4 5.33c-.49.67-.02 1.61.8 1.61h18c.82 0 1.29-.94.8-1.6l-7-9.33c-.4-.54-1.2-.54-1.6 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 image
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.9 13.98l2.1 2.53 3.1-3.99c.2-.26.6-.26.8.01l3.51 4.68c.25.33.01.8-.4.8H6.02c-.42 0-.65-.48-.39-.81L8.12 14c.19-.26.57-.27.78-.02z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _4mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12.5,10.75V10h-2 c-0.55,0-1-0.45-1-1V6.25c0-0.41,0.34-0.75,0.75-0.75S11,5.84,11,6.25V8.5h1.5V6.25c0-0.41,0.34-0.75,0.75-0.75S14,5.84,14,6.25 V8.5h0.25C14.66,8.5,15,8.84,15,9.25S14.66,10,14.25,10H14v0.75c0,0.41-0.34,0.75-0.75,0.75S12.5,11.16,12.5,10.75z M18,16 c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-landscape
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 5H5c-1.1 0-2 .9-2 2v10c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm-1 12H6c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v8c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 camera-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 4h-3.17l-1.24-1.35c-.37-.41-.91-.65-1.47-.65H9.88c-.56 0-1.1.24-1.48.65L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-8 13c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 dirty-lens
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,5h-3.17l-1.24-1.35C15.22,3.24,14.68,3,14.12,3H9.88c-0.56,0-1.1,0.24-1.48,0.65L7.17,5H4C2.9,5,2,5.9,2,7v12 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M16.66,16.58c-1.14,1.86-3-1.03-3.81,0.09 c-0.39,0.57-0.09,1.49,0.13,2.33c0,0.47-0.38,0.85-0.85,0.85c-0.47,0-0.86-0.38-0.86-0.85c0.14-0.98,0.42-2.05-0.16-2.43 c-0.89-0.59-1.27,2.06-2.8,1.35c-1.39-1.12,1.05-1.29,0.5-3.27c-0.22-0.79-2.28,0.36-2.4-1.24c-0.08-1,1.49-0.74,1.51-1.49 c0.03-0.75-1.03-1.05-0.25-1.91c0.22-0.24,0.71-0.26,0.91-0.19c0.79,0.27,1.55,1.82,2.51,1.19c1.03-0.66-1.88-2.35,0-2.86 c1.64-0.44,1.31,2.08,2.65,2.44c1.94,0.52,2.65-4.55,4.41-2.33c1.85,2.33-3.43,2.27-2.85,4.01c0.34,1.01,2.15-1.2,2.76,0.53 c0.64,1.83-3.09,0.82-3.04,1.66C15.08,15.29,17.43,15.01,16.66,16.58z M18.14,18.01c-0.47,0-0.86-0.38-0.86-0.86 s0.38-0.86,0.86-0.86c0.47,0,0.86,0.38,0.86,0.86S18.62,18.01,18.14,18.01z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 blur-linear
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5 17.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zM9 13c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zM4 21h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1s.45 1 1 1zM5 9.5c.83 0 1.5-.67 1.5-1.5S5.83 6.5 5 6.5 3.5 7.17 3.5 8 4.17 9.5 5 9.5zm0 4c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5-1.5.67-1.5 1.5.67 1.5 1.5 1.5zM9 17c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm8-.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM3 4c0 .55.45 1 1 1h16c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1 .45-1 1zm14 4.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm0 4c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM13 9c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 4c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-camera-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,5h-3.17l-1.24-1.35C15.22,3.24,14.68,3,14.12,3H9.88C9.32,3,8.78,3.24,8.41,3.65L7.17,5H4C2.9,5,2,5.9,2,7v12 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V7C22,5.9,21.1,5,20,5z M12,9c1.1,0,2,0.9,2,2c0,1.1-0.9,2-2,2s-2-0.9-2-2C10,9.9,10.9,9,12,9z M16,17H8v-0.57c0-0.81,0.48-1.53,1.22-1.85C10.07,14.21,11.01,14,12,14s1.93,0.21,2.78,0.58C15.52,14.9,16,15.62,16,16.43V17z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 switch-video
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 9.5V6c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v12c0 .55.45 1 1 1h14c.55 0 1-.45 1-1v-3.5l2.29 2.29c.63.63 1.71.18 1.71-.71V7.91c0-.89-1.08-1.34-1.71-.71L18 9.5zm-5 6V13H7v2.5l-3.15-3.15c-.2-.2-.2-.51 0-.71L7 8.5V11h6V8.5l3.15 3.15c.2.2.2.51 0 .71L13 15.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blur-circular
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zM7 9.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm3 7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-3-3c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm3-6c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM14 9c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-1.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm3 6c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-4c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8zm2-3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-3.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 edit
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 17.46v3.04c0 .28.22.5.5.5h3.04c.13 0 .26-.05.35-.15L17.81 9.94l-3.75-3.75L3.15 17.1c-.1.1-.15.22-.15.36zM20.71 7.04c.39-.39.39-1.02 0-1.41l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-7
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 8.69V5c0-.55-.45-1-1-1h-3.69l-2.6-2.6c-.39-.39-1.02-.39-1.41 0L8.69 4H5c-.55 0-1 .45-1 1v3.69l-2.6 2.6c-.39.39-.39 1.02 0 1.41L4 15.3V19c0 .55.45 1 1 1h3.69l2.6 2.6c.39.39 1.02.39 1.41 0l2.6-2.6H19c.55 0 1-.45 1-1v-3.69l2.6-2.6c.39-.39.39-1.02 0-1.41L20 8.69zM12 18c-3.31 0-6-2.69-6-6s2.69-6 6-6 6 2.69 6 6-2.69 6-6 6zm0-10c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 grain
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 12c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zM6 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm0 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm12-8c1.1 0 2-.9 2-2s-.9-2-2-2-2 .9-2 2 .9 2 2 2zm-4 8c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm-4-4c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 receipt-long
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,9h-4C9.45,9,9,8.55,9,8v0c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1v0C15,8.55,14.55,9,14,9z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M14,12h-4c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1v0C15,11.55,14.55,12,14,12z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M19.5,3.5L18,2l-1.5,1.5L15,2l-1.5,1.5L12,2l-1.5,1.5L9,2L7.5,3.5L6,2v14H4c-0.55,0-1,0.45-1,1v2c0,1.66,1.34,3,3,3h12 c1.66,0,3-1.34,3-3V2L19.5,3.5z M15,20H6c-0.55,0-1-0.45-1-1v-1h3h4h3V20z M19,19c0,0.55-0.45,1-1,1s-1-0.45-1-1v-2 c0-0.55-0.45-1-1-1h-2h-2H8V5h11V19z",
     :stroke nil,
     :fill nil})
   (helix.dom/circle
    {:r "1", :cy "8", :cx "17", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "11", :cx "17", :stroke nil, :fill nil}))))


(helix.core/defnc
 image-aspect-ratio
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16 10h-2v2h2v-2zm0 4h-2v2h2v-2zm-8-4H6v2h2v-2zm4 0h-2v2h2v-2zm8-6H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-1 14H5c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v10c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 lens
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome-motion
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13,2H4C2.9,2,2,2.9,2,4v9c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V4h9c0.55,0,1-0.45,1-1v0C14,2.45,13.55,2,13,2z M17,6H8 C6.9,6,6,6.9,6,8v9c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1V8h9c0.55,0,1-0.45,1-1v0C18,6.45,17.55,6,17,6z M20,10h-8 c-1.1,0-2,0.9-2,2v8c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2v-8C22,10.9,21.1,10,20,10z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 movie-filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21.5 4H18l1.74 2.61c.11.17-.01.39-.21.39h-2c-.33 0-.65-.17-.83-.45L15 4h-2l1.74 2.61c.11.17-.01.39-.21.39h-2c-.33 0-.65-.17-.83-.45L10 4H8l1.74 2.61c.11.17-.01.39-.21.39h-2c-.33 0-.64-.17-.83-.45L5 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V4.5c0-.28-.22-.5-.5-.5zM11.25 15.25L10 18l-1.25-2.75L6 14l2.75-1.25L10 10l1.25 2.75L14 14l-2.75 1.25zm5.69-3.31L16 14l-.94-2.06L13 11l2.06-.94L16 8l.94 2.06L19 11l-2.06.94z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer-10
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M-.01 7.72V9.4l3-1V18h2V6h-.25L-.01 7.72zm23.78 6.65c-.14-.28-.35-.53-.63-.74-.28-.21-.61-.39-1.01-.53s-.85-.27-1.35-.38c-.35-.07-.64-.15-.87-.23-.23-.08-.41-.16-.55-.25s-.23-.19-.28-.3c-.05-.11-.08-.24-.08-.39 0-.14.03-.28.09-.41s.15-.25.27-.34c.12-.1.27-.18.45-.24s.4-.09.64-.09c.25 0 .47.04.66.11s.35.17.48.29.22.26.29.42c.06.16.1.32.1.49h1.95c0-.39-.08-.75-.24-1.09s-.39-.63-.69-.88c-.3-.25-.66-.44-1.09-.59-.43-.15-.92-.22-1.46-.22-.51 0-.98.07-1.39.21s-.77.33-1.06.57c-.29.24-.51.52-.67.84-.16.32-.23.65-.23 1.01s.08.69.23.96c.15.28.36.52.64.73.27.21.6.38.98.53.38.14.81.26 1.27.36.39.08.71.17.95.26s.43.19.57.29c.13.1.22.22.27.34.05.12.07.25.07.39 0 .32-.13.57-.4.77s-.66.29-1.17.29c-.22 0-.43-.02-.64-.08-.21-.05-.4-.13-.56-.24-.17-.11-.3-.26-.41-.44-.11-.18-.17-.41-.18-.67h-1.89c0 .36.08.71.24 1.05s.39.65.7.93c.31.27.69.49 1.15.66s.98.25 1.58.25c.53 0 1.01-.06 1.44-.19.43-.13.8-.31 1.11-.54.31-.23.54-.51.71-.83.17-.32.25-.67.25-1.06-.02-.4-.09-.74-.24-1.02zm-9.96-7.32c-.34-.4-.75-.7-1.23-.88-.47-.18-1.01-.27-1.59-.27s-1.11.09-1.59.27c-.48.18-.89.47-1.23.88-.34.41-.6.93-.79 1.59-.18.65-.28 1.45-.28 2.39v1.92c0 .94.09 1.74.28 2.39.19.66.45 1.19.8 1.6.34.41.75.71 1.23.89s1.01.28 1.59.28c.59 0 1.12-.09 1.59-.28.48-.18.88-.48 1.22-.89s.6-.94.78-1.6c.18-.65.28-1.45.28-2.39v-1.92c0-.94-.09-1.74-.28-2.39-.18-.66-.44-1.19-.78-1.59zm-.92 6.17c0 .6-.04 1.11-.12 1.53s-.2.76-.36 1.02c-.16.26-.36.45-.59.57-.23.12-.51.18-.82.18-.3 0-.58-.06-.82-.18s-.44-.31-.6-.57c-.16-.26-.29-.6-.38-1.02s-.13-.93-.13-1.53v-2.5c0-.6.04-1.11.13-1.52s.21-.74.38-1c.16-.25.36-.43.6-.55.24-.11.51-.17.81-.17.31 0 .58.06.81.17.24.11.44.29.6.55.16.25.29.58.37.99s.13.92.13 1.52v2.51h-.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 rotate-90-degrees-cw
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3.86,18.46c2.65,3.45,7.11,4.37,10.74,2.79c0.61-0.27,0.74-1.09,0.27-1.56l-0.05-0.05c-0.29-0.29-0.72-0.35-1.1-0.19 c-2.96,1.24-6.59,0.37-8.58-2.62c-1.58-2.37-1.55-5.37,0.05-7.73C6.6,7.03,8.8,6.03,11,6.03v1.76c0,0.45,0.54,0.67,0.86,0.36 l2.79-2.79c0.2-0.2,0.2-0.51,0-0.71l-2.8-2.79C11.54,1.54,11,1.76,11,2.21v1.8c-2.76,0-5.52,1.25-7.34,3.78 C1.38,10.96,1.46,15.37,3.86,18.46z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M17.7,7.71c-0.39-0.39-1.02-0.39-1.41,0l-4.59,4.58c-0.39,0.39-0.39,1.02,0,1.41l4.59,4.59c0.39,0.39,1.02,0.39,1.41,0 l4.59-4.59c0.39-0.39,0.39-1.02,0-1.41L17.7,7.71z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 panorama-horizontal
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 6.54v10.91c-2.6-.77-5.28-1.16-8-1.16s-5.4.39-8 1.16V6.54c2.6.77 5.28 1.16 8 1.16 2.72.01 5.4-.38 8-1.16M21.43 4c-.1 0-.2.02-.31.06C18.18 5.16 15.09 5.7 12 5.7s-6.18-.55-9.12-1.64C2.77 4.02 2.66 4 2.57 4c-.34 0-.57.23-.57.63v14.75c0 .39.23.62.57.62.1 0 .2-.02.31-.06 2.94-1.1 6.03-1.64 9.12-1.64s6.18.55 9.12 1.64c.11.04.21.06.31.06.33 0 .57-.23.57-.63V4.63c0-.4-.24-.63-.57-.63z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-twilight
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.07,9.37l0.71-0.71c0.39-0.39,0.39-1.02,0-1.41l0,0c-0.39-0.39-1.02-0.39-1.41,0l-0.71,0.71 c-0.39,0.39-0.39,1.02,0,1.41C18.04,9.76,18.68,9.76,19.07,9.37z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M21,18H3c-0.55,0-1,0.45-1,1s0.45,1,1,1h18c0.55,0,1-0.45,1-1S21.55,18,21,18z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,7L12,7c0.56,0,1-0.45,1-1V5c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v1C11,6.55,11.45,7,12,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4.96,9.34c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L5.66,7.22c-0.39-0.39-1.02-0.39-1.41,0l0,0 c-0.39,0.39-0.39,1.02,0,1.41L4.96,9.34z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M19,16c0-3.87-3.13-7-7-7s-7,3.13-7,7H19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 photo-album
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,2H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2V4C20,2.9,19.1,2,18,2z M15.24,10.55L13.5,9.5l-1.74,1.05 c-0.33,0.2-0.76-0.04-0.76-0.43V4h5v6.12C16,10.51,15.58,10.75,15.24,10.55z M7.6,17.2l1.38-1.83c0.2-0.27,0.6-0.27,0.8,0L11,17 l2.23-2.97c0.2-0.27,0.6-0.27,0.8,0l2.38,3.17c0.25,0.33,0.01,0.8-0.4,0.8H8C7.59,18,7.35,17.53,7.6,17.2z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 panorama-photosphere-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.95,8.15c-0.29-0.16-0.61-0.31-0.93-0.46C19.4,4.33,15.98,2,12,2C8.02,2,4.6,4.33,2.99,7.68 c-0.33,0.15-0.64,0.3-0.93,0.46C1.41,8.5,1,9.17,1,9.91v4.18c0,0.74,0.41,1.41,1.05,1.77c0.29,0.16,0.61,0.31,0.93,0.46 C4.6,19.67,8.02,22,12,22c3.98,0,7.4-2.33,9.01-5.68c0.33-0.15,0.64-0.3,0.93-0.46C22.59,15.5,23,14.83,23,14.09V9.91 C23,9.17,22.59,8.5,21.95,8.15z M12,4c2.37,0,4.49,1.04,5.95,2.68C16.17,6.25,14.15,6,12,6C9.85,6,7.83,6.25,6.05,6.68 C7.51,5.04,9.63,4,12,4z M12,20c-2.37,0-4.49-1.04-5.95-2.68C7.83,17.75,9.85,18,12,18s4.17-0.25,5.95-0.68 C16.49,18.96,14.37,20,12,20z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 loupe
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 7c-.55 0-1 .45-1 1v3H8c-.55 0-1 .45-1 1s.45 1 1 1h3v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1h-3V8c0-.55-.45-1-1-1zm0-5C6.49 2 2 6.49 2 12s4.49 10 10 10h8c1.1 0 2-.9 2-2v-8c0-5.51-4.49-10-10-10zm0 18c-4.41 0-8-3.59-8-8s3.59-8 8-8 8 3.59 8 8-3.59 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 10c-3.47 0-6.36 2.54-6.91 5.86-.1.6.39 1.14 1 1.14.49 0 .9-.36.98-.85C7.48 13.79 9.53 12 12 12s4.52 1.79 4.93 4.15c.08.49.49.85.98.85.61 0 1.09-.54.99-1.14C18.36 12.54 15.47 10 12 10zm0-4C6.3 6 1.61 10.34 1.05 15.9c-.05.59.41 1.1 1.01 1.1.51 0 .94-.38.99-.88C3.49 11.57 7.34 8 12 8s8.51 3.57 8.96 8.12c.05.5.48.88.99.88.59 0 1.06-.51 1-1.1C22.39 10.34 17.7 6 12 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-size-select-small
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 15h-2v2h2v-2zm0-4h-2v2h2v-2zm0 8h-2v2c1 0 2-1 2-2zM15 3h-2v2h2V3zm8 4h-2v2h2V7zm-2-4v2h2c0-1-1-2-2-2zM3 21h8v-4c0-1.1-.9-2-2-2H1v4c0 1.1.9 2 2 2zM3 7H1v2h2V7zm12 12h-2v2h2v-2zm4-16h-2v2h2V3zm0 16h-2v2h2v-2zM3 3C2 3 1 4 1 5h2V3zm0 8H1v2h2v-2zm8-8H9v2h2V3zM7 3H5v2h2V3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 15.31l2.6-2.6c.39-.39.39-1.02 0-1.41L20 8.69V5c0-.55-.45-1-1-1h-3.69l-2.6-2.6c-.39-.39-1.02-.39-1.41 0L8.69 4H5c-.55 0-1 .45-1 1v3.69l-2.6 2.6c-.39.39-.39 1.02 0 1.41L4 15.3V19c0 .55.45 1 1 1h3.69l2.6 2.6c.39.39 1.02.39 1.41 0l2.6-2.6H19c.55 0 1-.45 1-1v-3.69zm-8 1.59V7.1c0-.61.55-1.11 1.15-.99C15.91 6.65 18 9.08 18 12s-2.09 5.35-4.85 5.89c-.6.12-1.15-.38-1.15-.99z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _21mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.5,9c0-0.55,0.45-1,1-1h2V7H8.25 C7.84,7,7.5,6.66,7.5,6.25S7.84,5.5,8.25,5.5H11c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H9v1h2.25c0.41,0,0.75,0.34,0.75,0.75 s-0.34,0.75-0.75,0.75H8.5c-0.55,0-1-0.45-1-1V9z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25 C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M13,6.25c0-0.41,0.34-0.75,0.75-0.75H15c0.55,0,1,0.45,1,1v4.25c0,0.41-0.34,0.75-0.75,0.75 s-0.75-0.34-0.75-0.75V7h-0.75C13.34,7,13,6.66,13,6.25z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75 s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 navigate-next
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9.31 6.71c-.39.39-.39 1.02 0 1.41L13.19 12l-3.88 3.88c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0l4.59-4.59c.39-.39.39-1.02 0-1.41L10.72 6.7c-.38-.38-1.02-.38-1.41.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 brightness-1
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/circle
       {:r "10", :cy "12", :cx "12", :stroke nil, :fill nil})))))))


(helix.core/defnc
 tune
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 18c0 .55.45 1 1 1h5v-2H4c-.55 0-1 .45-1 1zM3 6c0 .55.45 1 1 1h9V5H4c-.55 0-1 .45-1 1zm10 14v-1h7c.55 0 1-.45 1-1s-.45-1-1-1h-7v-1c0-.55-.45-1-1-1s-1 .45-1 1v4c0 .55.45 1 1 1s1-.45 1-1zM7 10v1H4c-.55 0-1 .45-1 1s.45 1 1 1h3v1c0 .55.45 1 1 1s1-.45 1-1v-4c0-.55-.45-1-1-1s-1 .45-1 1zm14 2c0-.55-.45-1-1-1h-9v2h9c.55 0 1-.45 1-1zm-5-3c.55 0 1-.45 1-1V7h3c.55 0 1-.45 1-1s-.45-1-1-1h-3V4c0-.55-.45-1-1-1s-1 .45-1 1v4c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-camera
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "3", :cy "12", :cx "12", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M20 4h-3.17l-1.24-1.35c-.37-.41-.91-.65-1.47-.65H9.88c-.56 0-1.1.24-1.48.65L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-8 13c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-plus
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14.5",
      :x "8.5",
      :width "2",
      :height "1",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "7.5",
      :x "14.5",
      :width "1.5",
      :height "3",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M12,15.5c0,0.6-0.4,1.1-0.9,1.4l0.49,1.13 c0.2,0.46-0.14,0.97-0.64,0.97h0c-0.27,0-0.52-0.16-0.63-0.41L9.6,17H8.5v1.31C8.5,18.69,8.19,19,7.81,19H7.69 C7.31,19,7,18.69,7,18.31V14c0-0.55,0.45-1,1-1h2.5c0.82,0,1.5,0.68,1.5,1.5V15.5z M11.25,12L11.25,12 c-0.41,0-0.75-0.34-0.75-0.75V9.5h-2v1.75C8.5,11.66,8.16,12,7.75,12h0C7.34,12,7,11.66,7,11.25v-4.5C7,6.34,7.34,6,7.75,6h0 C8.16,6,8.5,6.34,8.5,6.75V8h2V6.75C10.5,6.34,10.84,6,11.25,6h0C11.66,6,12,6.34,12,6.75v4.5C12,11.66,11.66,12,11.25,12z M16.75,16H16v0.75c0,0.41-0.34,0.75-0.75,0.75h0c-0.41,0-0.75-0.34-0.75-0.75V16h-0.75C13.34,16,13,15.66,13,15.25v0 c0-0.41,0.34-0.75,0.75-0.75h0.75v-0.75c0-0.41,0.34-0.75,0.75-0.75h0c0.41,0,0.75,0.34,0.75,0.75v0.74h0.75 c0.41,0,0.75,0.34,0.75,0.75v0.01C17.5,15.66,17.16,16,16.75,16z M17.5,10.5c0,0.82-0.67,1.5-1.5,1.5h-2.5 c-0.28,0-0.5-0.22-0.5-0.5v-5C13,6.22,13.22,6,13.5,6H16c0.83,0,1.5,0.68,1.5,1.5V10.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 center-focus-weak
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M4 15c-.55 0-1 .45-1 1v3c0 1.1.9 2 2 2h3c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1-.45-1-1v-2c0-.55-.45-1-1-1zm1-9c0-.55.45-1 1-1h2c.55 0 1-.45 1-1s-.45-1-1-1H5c-1.1 0-2 .9-2 2v3c0 .55.45 1 1 1s1-.45 1-1V6zm14-3h-3c-.55 0-1 .45-1 1s.45 1 1 1h2c.55 0 1 .45 1 1v2c0 .55.45 1 1 1s1-.45 1-1V5c0-1.1-.9-2-2-2zm0 15c0 .55-.45 1-1 1h-2c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2v-3c0-.55-.45-1-1-1s-1 .45-1 1v2zM12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 logo-dev
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.68,14.98H6V9h1.71 c1.28,0,1.71,1.03,1.71,1.71l0,2.56C9.42,13.95,9,14.98,7.68,14.98z M12.38,11.46v1.07h-1.18v1.39h1.93v1.07h-2.25 c-0.4,0.01-0.74-0.31-0.75-0.71V9.75c-0.01-0.4,0.31-0.74,0.71-0.75h2.28l0,1.07h-1.92v1.39H12.38z M16.88,14.23 c-0.48,1.11-1.33,0.89-1.71,0L13.77,9h1.18l1.07,4.11L17.09,9h1.18L16.88,14.23z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7.77,10.12H7.14v3.77h0.63c0.14,0,0.28-0.05,0.42-0.16c0.14-0.1,0.21-0.26,0.21-0.47v-2.52c0-0.21-0.07-0.37-0.21-0.47 C8.05,10.17,7.91,10.12,7.77,10.12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _14mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.75,5.5H9c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12,9V6.25 c0-0.41,0.34-0.75,0.75-0.75s0.75,0.34,0.75,0.75V8.5H15V6.25c0-0.41,0.34-0.75,0.75-0.75s0.75,0.34,0.75,0.75V8.5h0.25 c0.41,0,0.75,0.34,0.75,0.75S17.16,10,16.75,10H16.5v0.75c0,0.41-0.34,0.75-0.75,0.75S15,11.16,15,10.75V10h-2 C12.45,10,12,9.55,12,9z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 looks-4
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:fill "none", :d "M.04 0h24v24h-24V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.04 3h-14c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 14c-.55 0-1-.45-1-1v-3h-3c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1s1 .45 1 1v3h2V8c0-.55.45-1 1-1s1 .45 1 1v8c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-bitcoin
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10,7h4c1.1,0,2,0.9,2,2s-0.9,2-2,2h-4V7z M15,17h-5v-4h5c1.1,0,2,0.9,2,2S16.1,17,15,17z M15,4c0-0.55-0.45-1-1-1 s-1,0.45-1,1v1h-2V4c0-0.55-0.45-1-1-1S9,3.45,9,4v1H7C6.45,5,6,5.45,6,6s0.45,1,1,1h1v10H7c-0.55,0-1,0.45-1,1s0.45,1,1,1h2v1 c0,0.55,0.45,1,1,1s1-0.45,1-1v-1h2v1c0,0.55,0.45,1,1,1s1-0.45,1-1v-1c2.21,0,4-1.79,4-4c0-1.45-0.78-2.73-1.94-3.43 C17.65,10.88,18,9.98,18,9c0-1.86-1.27-3.43-3-3.87L15,4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 looks-3
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5.01c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2H19c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-3.99 7.5c0 .83-.67 1.5-1.5 1.5.83 0 1.5.67 1.5 1.5V15c0 1.11-.9 2-2 2H10c-.55 0-1-.45-1-1s.45-1 1-1h3.01L13 13h-1c-.55 0-1-.45-1-1s.45-1 1-1h1l.01-2H10c-.55 0-.99-.45-.99-1s.44-1 .99-1h3.01c1.1 0 2 .9 2 2v1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7,9h4.5c0.55,0,1,0.45,1,1v4.25 c0,0.41-0.34,0.75-0.75,0.75h0C11.34,15,11,14.66,11,14.25V10.5h-1v2.25c0,0.41-0.34,0.75-0.75,0.75h0 c-0.41,0-0.75-0.34-0.75-0.75V10.5h-1v3.75C7.5,14.66,7.16,15,6.75,15h0C6.34,15,6,14.66,6,14.25V10C6,9.45,6.45,9,7,9z M14.25,15 L14.25,15c-0.41,0-0.75-0.33-0.75-0.75V10c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1v2.5c0,0.55-0.45,1-1,1h-2v0.75 C15,14.66,14.66,15,14.25,15z M15,12h1.5v-1.5H15V12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-portrait
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 3H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h10c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h8c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 bedtime
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M11.65 3.46c.27-.71-.36-1.45-1.12-1.34-5.52.8-9.47 6.07-8.34 11.88.78 4.02 4.09 7.21 8.14 7.87 3.74.61 7.16-.87 9.32-3.44.48-.57.19-1.48-.55-1.62-6.02-1.15-9.68-7.54-7.45-13.35z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rotate-right
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.83 4.83L12.7 2.7c-.62-.62-1.7-.18-1.7.71v.66C7.06 4.56 4 7.92 4 12c0 3.64 2.43 6.71 5.77 7.68.62.18 1.23-.32 1.23-.96v-.03c0-.43-.27-.82-.68-.94C7.82 17.03 6 14.73 6 12c0-2.97 2.16-5.43 5-5.91v1.53c0 .89 1.07 1.33 1.7.71l2.13-2.08c.4-.38.4-1.02 0-1.42zm4.84 4.93c-.16-.55-.38-1.08-.66-1.59-.31-.57-1.1-.66-1.56-.2l-.01.01c-.31.31-.38.78-.17 1.16.2.37.36.76.48 1.16.12.42.51.7.94.7h.02c.65 0 1.15-.62.96-1.24zM13 18.68v.02c0 .65.62 1.14 1.24.96.55-.16 1.08-.38 1.59-.66.57-.31.66-1.1.2-1.56l-.02-.02c-.31-.31-.78-.38-1.16-.17-.37.21-.76.37-1.16.49-.41.12-.69.51-.69.94zm4.44-2.65c.46.46 1.25.37 1.56-.2.28-.51.5-1.04.67-1.59.18-.62-.31-1.24-.96-1.24h-.02c-.44 0-.82.28-.94.7-.12.4-.28.79-.48 1.17-.21.38-.13.86.17 1.16z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-strong
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 6c-3.31 0-6 2.69-6 6s2.69 6 6 6 6-2.69 6-6-2.69-6-6-6zM5 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 6c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 video-stable
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19.96,4.01h-16c-1.1,0-2,0.9-2,2v12c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-12C21.96,4.91,21.06,4.01,19.96,4.01z M20,6v12 H4V6H20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M18.42,9.01L7.92,6.18C7.39,6.04,6.84,6.35,6.7,6.88l-1.85,6.87c-0.14,0.53,0.17,1.08,0.71,1.23l10.5,2.83 c0.53,0.14,1.08-0.17,1.23-0.71l1.85-6.87C19.27,9.7,18.95,9.15,18.42,9.01z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 nature-people
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/circle
   {:r "1.5", :cy "9.5", :cx "4.5", :stroke nil, :fill nil})
  (helix.dom/path
   {:d
    "M22.17 9.17c0-3.91-3.19-7.06-7.11-7-3.83.06-6.99 3.37-6.88 7.19.09 3.38 2.58 6.16 5.83 6.7V20H6v-3h.5c.28 0 .5-.22.5-.5V13c0-.55-.45-1-1-1H3c-.55 0-1 .45-1 1v3.5c0 .28.22.5.5.5H3v4c0 .55.45 1 1 1h14c.55 0 1-.45 1-1s-.45-1-1-1h-2v-3.88c3.47-.41 6.17-3.36 6.17-6.95z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-neg-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.05 16.29l2.86-3.07c.38-.39.72-.79 1.04-1.18.32-.39.59-.78.82-1.17s.41-.78.54-1.17.19-.79.19-1.18c0-.53-.09-1.02-.27-1.46s-.44-.81-.78-1.11c-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49s.6-.18.96-.18c.31 0 .58.05.81.15s.43.25.59.43.28.4.37.65c.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H21v-1.71h-5.95zM2 12c0 .55.45 1 1 1h6c.55 0 1-.45 1-1s-.45-1-1-1H3c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 compare
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h5v1c0 .55.45 1 1 1s1-.45 1-1V2c0-.55-.45-1-1-1s-1 .45-1 1v1zm0 15H5l5-6v6zm9-15h-5v2h4c.55 0 1 .45 1 1v12l-5-6v9h5c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-plus-2
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.05 16.29l2.86-3.07c.38-.39.72-.79 1.04-1.18.32-.39.59-.78.82-1.17s.41-.78.54-1.17c.13-.39.19-.79.19-1.18 0-.53-.09-1.02-.27-1.46s-.44-.81-.78-1.11c-.34-.31-.77-.54-1.26-.71-.51-.16-1.08-.24-1.72-.24-.69 0-1.31.11-1.85.32-.54.21-1 .51-1.36.88-.37.37-.65.8-.84 1.3-.18.47-.27.97-.28 1.5h2.14c.01-.31.05-.6.13-.87.09-.29.23-.54.4-.75.18-.21.41-.37.68-.49s.6-.18.96-.18c.31 0 .58.05.81.15s.43.25.59.43.28.4.37.65c.08.25.13.52.13.81 0 .22-.03.43-.08.65-.06.22-.15.45-.29.7-.14.25-.32.53-.56.83-.23.3-.52.65-.88 1.03l-4.17 4.55V18H22v-1.71h-5.95zM7 7c-.55 0-1 .45-1 1v3H3c-.55 0-1 .45-1 1s.45 1 1 1h3v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1H8V8c0-.55-.45-1-1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M23 18V6c0-1.1-.9-2-2-2H3c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2zM8.9 12.98l2.1 2.53 3.1-3.99c.2-.26.6-.26.8.01l3.51 4.68c.25.33.01.8-.4.8H6.02c-.42 0-.65-.48-.39-.81L8.12 13c.19-.26.57-.27.78-.02z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-yuan
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,21c-0.55,0-1-0.45-1-1v-6H7c-0.55,0-1-0.45-1-1s0.45-1,1-1h3.72L5.98,4.54C5.55,3.87,6.03,3,6.82,3 c0.34,0,0.66,0.17,0.84,0.46L12,10.29l4.34-6.83C16.52,3.17,16.84,3,17.18,3c0.79,0,1.27,0.87,0.84,1.54L13.28,12H17 c0.55,0,1,0.45,1,1s-0.45,1-1,1h-4v6C13,20.55,12.55,21,12,21z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 collections-bookmark
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 20H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1s-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1zm3-18H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm0 10l-2.5-1.5L15 12V4h5v8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7.25 9c-.41 0-.75.34-.75.75V11h-2V9.75c0-.41-.34-.75-.75-.75S3 9.34 3 9.75v4.5c0 .41.34.75.75.75s.75-.34.75-.75V12.5h2v1.75c0 .41.34.75.75.75s.75-.34.75-.75v-4.5C8 9.34 7.66 9 7.25 9zM21 11.5v-1c0-.83-.67-1.5-1.5-1.5H17c-.55 0-1 .45-1 1v4.25c0 .41.34.75.75.75s.75-.34.75-.75V13h1.1l.72 1.59c.11.25.36.41.63.41.5 0 .83-.51.64-.96l-.49-1.14c.5-.3.9-.8.9-1.4zm-3.5 0v-1h2v1h-2zM13 9h-3c-.28 0-.5.22-.5.5v5c0 .28.22.5.5.5h3c.82 0 1.5-.68 1.5-1.5v-3c0-.82-.68-1.5-1.5-1.5zm0 4.5h-2v-3h2v3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-9-plus
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm12 7V8c0-1.1-.9-2-2-2h-1c-1.1 0-2 .9-2 2v1c0 1.1.9 2 2 2h1v1h-2c-.55 0-1 .45-1 1s.45 1 1 1h2c1.1 0 2-.9 2-2zm-3-3V8h1v1h-1zm10-8H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zm1-7c0-.55-.45-1-1-1h-1V8c0-.55-.45-1-1-1s-1 .45-1 1v1h-1c-.55 0-1 .45-1 1s.45 1 1 1h1v1c0 .55.45 1 1 1s1-.45 1-1v-1h1c.55 0 1-.45 1-1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 autofps-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/polygon
     {:points "12.03,6.3 11.97,6.3 10.95,9.19 13.05,9.19",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M4,22L4,22c0.55,0,1-0.45,1-1v-3c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v3C3,21.55,3.45,22,4,22z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,15c3.31,0,6-2.69,6-6s-2.69-6-6-6S6,5.69,6,9S8.69,15,12,15z M12,5L12,5c0.38,0,0.71,0.23,0.85,0.59l2.12,5.65 c0.14,0.37-0.13,0.76-0.53,0.76h0c-0.24,0-0.45-0.15-0.53-0.38l-0.49-1.41h-2.83l-0.5,1.41C10.01,11.85,9.8,12,9.56,12h0 c-0.39,0-0.67-0.39-0.53-0.76l2.12-5.65C11.29,5.23,11.62,5,12,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,22L8,22c0.55,0,1-0.45,1-1v-3c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v3C7,21.55,7.45,22,8,22z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,22L12,22c0.55,0,1-0.45,1-1v-3c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v3C11,21.55,11.45,22,12,22z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15,18v3c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-3c0-0.55-0.45-1-1-1h-4C15.45,17,15,17.45,15,18z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 currency-pound
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17.21,17.61c-0.47-0.24-1.03-0.05-1.31,0.4C15.54,18.61,14.93,19,14,19l-4.9,0c0.83-1,1.5-2.34,1.5-4 c0-0.35-0.03-0.69-0.08-1L13,14c0.55,0,1-0.45,1-1s-0.45-1-1-1l-3.18,0C9,10.42,8,9.6,8,8c0-1.93,1.57-3.5,3.5-3.5 c1.2,0,2.26,0.61,2.89,1.53c0.27,0.4,0.77,0.59,1.22,0.4c0.6-0.25,0.8-0.99,0.43-1.53c-0.99-1.45-2.66-2.4-4.54-2.4 C8.46,2.5,6,4.96,6,8c0,1.78,0.79,2.9,1.49,4L7,12c-0.55,0-1,0.45-1,1s0.45,1,1,1l1.47,0c0.08,0.31,0.13,0.64,0.13,1 c0,1.9-1.29,3.11-2.06,3.66C6.2,18.9,6,19.29,6,19.71v0C6,20.42,6.58,21,7.29,21H14c1.55,0,2.95-0.76,3.63-2 C17.91,18.49,17.72,17.86,17.21,17.61z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 _5mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M11,9c-0.55,0-1-0.45-1-1V6.5 c0-0.55,0.45-1,1-1h2.75c0.41,0,0.75,0.34,0.75,0.75S14.16,7,13.75,7H11.5v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1h-2.75 c-0.41,0-0.75-0.34-0.75-0.75S10.34,10,10.75,10H13V9H11z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.17,11,17.75V14h-1v2.25 C10,16.67,9.66,17,9.25,17S8.5,16.67,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.17,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 mic-external-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9.22,7H4.78C4.3,6.47,4,5.77,4,5c0-1.66,1.34-3,3-3s3,1.34,3,3C10,5.77,9.7,6.47,9.22,7z M16.24,2.01 C18.32,2.13,20,4.08,20,6.16L20,21c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1l0-14.91c0-0.96-0.64-1.86-1.58-2.05 C15.14,3.78,14,4.76,14,6l0,11.84c0,2.08-1.68,4.03-3.76,4.15C7.92,22.13,6,20.29,6,18H5.45c-0.26,0-0.47-0.19-0.5-0.45L4.11,9.1 C4.05,8.51,4.51,8,5.1,8H8.9c0.59,0,1.05,0.51,1,1.1l-0.85,8.45C9.02,17.81,8.8,18,8.55,18H8c0,1.24,1.14,2.22,2.42,1.96 c0.94-0.19,1.58-1.09,1.58-2.05L12,6C12,3.71,13.92,1.87,16.24,2.01z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 texture
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.58 3.08L3.15 19.51c.09.34.27.65.51.9.25.24.56.42.9.51L21 4.49c-.19-.69-.73-1.23-1.42-1.41zM11.95 3l-8.88 8.88v2.83L14.78 3h-2.83zM5.07 3c-1.1 0-2 .9-2 2v2l4-4h-2zm14 18c.55 0 1.05-.22 1.41-.59.37-.36.59-.86.59-1.41v-2l-4 4h2zm-9.71 0h2.83l8.88-8.88V9.29L9.36 21z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-photo-alternate
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21.02 5H19V2.98c0-.54-.44-.98-.98-.98h-.03c-.55 0-.99.44-.99.98V5h-2.01c-.54 0-.98.44-.99.98v.03c0 .55.44.99.99.99H17v2.01c0 .54.44.99.99.98h.03c.54 0 .98-.44.98-.98V7h2.02c.54 0 .98-.44.98-.98v-.04c0-.54-.44-.98-.98-.98zM16 9.01V8h-1.01c-.53 0-1.03-.21-1.41-.58-.37-.38-.58-.88-.58-1.44 0-.36.1-.69.27-.98H5c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2v-8.28c-.3.17-.64.28-1.02.28-1.09-.01-1.98-.9-1.98-1.99zM15.96 19H6c-.41 0-.65-.47-.4-.8l1.98-2.63c.21-.28.62-.26.82.02L10 18l2.61-3.48c.2-.26.59-.27.79-.01l2.95 3.68c.26.33.03.81-.39.81z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _10mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13.5,7H15v3h-1.5V7z M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M11.75,18.5 L11.75,18.5c-0.41,0-0.75-0.34-0.75-0.75V14h-1v2.25C10,16.66,9.66,17,9.25,17h0c-0.41,0-0.75-0.34-0.75-0.75V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75h0C6.34,18.5,6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1v4.25 C12.5,18.16,12.16,18.5,11.75,18.5z M14.25,18.5L14.25,18.5c-0.41,0-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17 c0.55,0,1,0.45,1,1V16c0,0.55-0.45,1-1,1h-2v0.75C15,18.16,14.66,18.5,14.25,18.5z M10,6.5v4.25c0,0.41-0.34,0.75-0.75,0.75h0 c-0.41,0-0.75-0.34-0.75-0.75V7H7.75C7.34,7,7,6.66,7,6.25v0C7,5.84,7.34,5.5,7.75,5.5H9C9.55,5.5,10,5.95,10,6.5z M16.5,10.5 c0,0.55-0.45,1-1,1H13c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1V10.5z M15,14h1.5v1.5H15V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 looks-5
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-5 6h-3v2h2c1.1 0 2 .9 2 2v2c0 1.11-.9 2-2 2h-3c-.55 0-1-.45-1-1s.45-1 1-1h3v-2h-3c-.55 0-1-.45-1-1V8c0-.55.45-1 1-1h4c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 circle
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,2C6.47,2,2,6.47,2,12s4.47,10,10,10s10-4.47,10-10S17.53,2,12,2z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 flash-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 3v9c0 .55.45 1 1 1h2v7.15c0 .51.67.69.93.25l5.19-8.9c.39-.67-.09-1.5-.86-1.5H13l2.49-6.65c.25-.65-.23-1.35-.93-1.35H8c-.55 0-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-size-select-large
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 15h2v2h-2v-2zm0-4h2v2h-2v-2zm2 8h-2v2c1 0 2-1 2-2zM13 3h2v2h-2V3zm8 4h2v2h-2V7zm0-4v2h2c0-1-1-2-2-2zM1 7h2v2H1V7zm16-4h2v2h-2V3zm0 16h2v2h-2v-2zM3 3C2 3 1 4 1 5h2V3zm6 0h2v2H9V3zM5 3h2v2H5V3zm-4 8v8c0 1.1.9 2 2 2h12v-8c0-1.1-.9-2-2-2H1zm2.63 7.19l1.49-1.91c.2-.25.57-.26.78-.01l1.39 1.67 2.1-2.7c.2-.26.6-.26.79.01l2.22 2.96c.25.33.01.8-.4.8H4.02c-.41-.01-.65-.49-.39-.82z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-8
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm19-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zm-7-2h2c1.1 0 2-.89 2-2v-1.5c0-.83-.67-1.5-1.5-1.5.83 0 1.5-.67 1.5-1.5V7c0-1.11-.9-2-2-2h-2c-1.1 0-2 .89-2 2v1.5c0 .83.67 1.5 1.5 1.5-.83 0-1.5.67-1.5 1.5V13c0 1.11.9 2 2 2zm0-8h2v2h-2V7zm0 4h2v2h-2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-3-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,6H5C3.9,6,3,6.9,3,8v8c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V8C21,6.9,20.1,6,19,6z M19,16H5V8h14V16z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 contrast
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,22c5.52,0,10-4.48,10-10S17.52,2,12,2S2,6.48,2,12S6.48,22,12,22z M13,4.07c3.94,0.49,7,3.85,7,7.93s-3.05,7.44-7,7.93 V4.07z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 brush
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M7 14c-1.66 0-3 1.34-3 3 0 1.31-1.16 2-2 2 .92 1.22 2.49 2 4 2 2.21 0 4-1.79 4-4 0-1.66-1.34-3-3-3zm13.71-9.37l-1.34-1.34c-.39-.39-1.02-.39-1.41 0L9 12.25 11.75 15l8.96-8.96c.39-.39.39-1.02 0-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-1
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm13 10c.55 0 1-.45 1-1V6c0-.55-.45-1-1-1h-2c-.55 0-1 .45-1 1s.45 1 1 1h1v7c0 .55.45 1 1 1zm6-14H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 healing
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.73 12.02l3.98-3.98c.39-.39.39-1.02 0-1.41l-4.34-4.34c-.39-.39-1.02-.39-1.41 0l-3.98 3.98L8 2.29C7.8 2.1 7.55 2 7.29 2c-.25 0-.51.1-.7.29L2.25 6.63c-.39.39-.39 1.02 0 1.41l3.98 3.98L2.25 16c-.39.39-.39 1.02 0 1.41l4.34 4.34c.39.39 1.02.39 1.41 0l3.98-3.98 3.98 3.98c.2.2.45.29.71.29.26 0 .51-.1.71-.29l4.34-4.34c.39-.39.39-1.02 0-1.41l-3.99-3.98zM12 9c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm-4.71 1.96L3.66 7.34l3.63-3.63 3.62 3.62-3.62 3.63zM10 13c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2 2c-.55 0-1-.45-1-1s.45-1 1-1 1 .45 1 1-.45 1-1 1zm2-4c.55 0 1 .45 1 1s-.45 1-1 1-1-.45-1-1 .45-1 1-1zm2.66 9.34l-3.63-3.62 3.63-3.63 3.62 3.62-3.62 3.63z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 euro
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g nil)
   (helix.dom/path
    {:d
     "M15,18.5c-2.51,0-4.68-1.42-5.76-3.5h5.14c0.38,0,0.73-0.21,0.89-0.55l0,0c0.33-0.66-0.15-1.45-0.89-1.45h-5.8 c-0.05-0.33-0.08-0.66-0.08-1s0.03-0.67,0.08-1h5.8c0.38,0,0.73-0.21,0.89-0.55l0,0C15.61,9.78,15.13,9,14.38,9H9.24 C10.32,6.92,12.5,5.5,15,5.5c1.25,0,2.42,0.36,3.42,0.97c0.5,0.31,1.15,0.26,1.57-0.16l0,0c0.58-0.58,0.45-1.53-0.25-1.96 C18.36,3.5,16.73,3,15,3c-3.92,0-7.24,2.51-8.48,6h-2.9C3.24,9,2.89,9.21,2.72,9.55l0,0C2.39,10.22,2.87,11,3.62,11h2.44 C6.02,11.33,6,11.66,6,12s0.02,0.67,0.06,1H3.62c-0.38,0-0.73,0.21-0.89,0.55l0,0C2.39,14.22,2.87,15,3.62,15h2.9 c1.24,3.49,4.56,6,8.48,6c1.74,0,3.36-0.49,4.74-1.35c0.69-0.43,0.82-1.39,0.24-1.97l0,0c-0.42-0.42-1.07-0.47-1.57-0.15 C17.42,18.15,16.26,18.5,15,18.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 filter-6
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm19-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zm-7-2h2c1.1 0 2-.9 2-2v-2c0-1.1-.9-2-2-2h-2V7h3c.55 0 1-.45 1-1s-.45-1-1-1h-3c-1.1 0-2 .9-2 2v6c0 1.1.9 2 2 2zm0-4h2v2h-2v-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 landscape
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M13.2 7.07L10.25 11l2.25 3c.33.44.24 1.07-.2 1.4-.44.33-1.07.25-1.4-.2-1.05-1.4-2.31-3.07-3.1-4.14-.4-.53-1.2-.53-1.6 0l-4 5.33c-.49.67-.02 1.61.8 1.61h18c.82 0 1.29-.94.8-1.6l-7-9.33c-.4-.54-1.2-.54-1.6 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 navigate-before
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14.91 6.71c-.39-.39-1.02-.39-1.41 0L8.91 11.3c-.39.39-.39 1.02 0 1.41l4.59 4.59c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41L11.03 12l3.88-3.88c.38-.39.38-1.03 0-1.41z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 vignette
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h18c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-9 15c-4.42 0-8-2.69-8-6s3.58-6 8-6 8 2.69 8 6-3.58 6-8 6z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 mic-external-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,6c0-1.24,1.14-2.22,2.42-1.96C17.36,4.24,18,5.13,18,6.09v9.08l2,2V6.16c0-2.08-1.68-4.03-3.76-4.15 C13.92,1.87,12,3.71,12,6v3.17l2,2V6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,5c0-1.66-1.34-3-3-3C6.38,2,5.81,2.19,5.33,2.5l4.15,4.15C9.8,6.18,10,5.61,10,5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M1.39,2.81L1.39,2.81C1,3.2,1,3.83,1.39,4.22L5.17,8H5.1c-0.59,0-1.05,0.51-1,1.1l0.85,8.45C4.98,17.81,5.2,18,5.45,18H6 c0,2.34,2.01,4.21,4.39,3.98c2.08-0.2,3.61-2.06,3.61-4.15l0-1l5.78,5.78c0.39,0.39,1.02,0.39,1.41,0l0,0 c0.39-0.39,0.39-1.02,0-1.41L2.81,2.81C2.42,2.42,1.78,2.42,1.39,2.81z M12,17.91c0,0.96-0.64,1.86-1.58,2.05 C9.14,20.22,8,19.24,8,18h0.55c0.26,0,0.47-0.19,0.5-0.45l0.52-5.16L12,14.83V17.91z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 image-search
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 15v4c0 .55-.45 1-1 1H5c-.55 0-1-.45-1-1V7c0-.55.45-1 1-1h3.02c.55 0 1-.45 1-1s-.45-1-1-1H4c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2v-5c0-.55-.45-1-1-1s-1 .45-1 1zm-2.5 3H6.52c-.42 0-.65-.48-.39-.81l1.74-2.23c.2-.25.58-.26.78-.01l1.56 1.88 2.35-3.02c.2-.26.6-.26.79.01l2.55 3.39c.25.32.01.79-.4.79zm3.8-9.11c.48-.77.75-1.67.69-2.66-.13-2.15-1.84-3.97-3.97-4.2C13.3 1.73 11 3.84 11 6.5c0 2.49 2.01 4.5 4.49 4.5.88 0 1.7-.26 2.39-.7l2.41 2.41c.39.39 1.03.39 1.42 0 .39-.39.39-1.03 0-1.42l-2.41-2.4zM15.5 9C14.12 9 13 7.88 13 6.5S14.12 4 15.5 4 18 5.12 18 6.5 16.88 9 15.5 9z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M15.56 10.81l-2.35 3.02-1.56-1.88c-.2-.25-.58-.24-.78.01l-1.74 2.23c-.26.33-.02.81.39.81h8.98c.41 0 .65-.47.4-.8l-2.55-3.39c-.19-.26-.59-.26-.79 0zM2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm19-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 filter-7
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm19-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zm-6.75-2.49l3.58-7.17c.11-.22.17-.47.17-.72 0-.9-.72-1.62-1.62-1.62H12c-.55 0-1 .45-1 1s.45 1 1 1h3l-3.36 6.71c-.3.59.13 1.29.8 1.29h.01c.34 0 .65-.19.8-.49z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-shade
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,14.13L14,14.13c0,0.23,0.09,0.46,0.26,0.63l4.98,4.98c0.17,0.17,0.39,0.26,0.62,0.26h0c0.79,0,1.18-0.95,0.62-1.51 l-4.98-4.98C14.95,12.95,14,13.35,14,14.13z M15,20h2l-3-3v2C14,19.55,14.45,20,15,20z M7.65,4.35L2.85,9.15 C2.54,9.46,2.76,10,3.21,10H4v9c0,0.55,0.45,1,1,1h6c0.55,0,1-0.45,1-1v-9h0.79c0.45,0,0.67-0.54,0.35-0.85L8.35,4.35 C8.16,4.16,7.84,4.16,7.65,4.35z M9,14H7v-4h2V14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _22mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M6.5,9c0-0.55,0.45-1,1-1h2V7H7.25 C6.84,7,6.5,6.66,6.5,6.25S6.84,5.5,7.25,5.5H10c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1H8v1h2.25c0.41,0,0.75,0.34,0.75,0.75 s-0.34,0.75-0.75,0.75H7.5c-0.55,0-1-0.45-1-1V9z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25 C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M13,10.5V9c0-0.55,0.45-1,1-1h2V7h-2.25C13.34,7,13,6.66,13,6.25s0.34-0.75,0.75-0.75h2.75 c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1h-2v1h2.25c0.41,0,0.75,0.34,0.75,0.75s-0.34,0.75-0.75,0.75H14 C13.45,11.5,13,11.05,13,10.5z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 filter-9
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M2 5c-.55 0-1 .45-1 1v15c0 1.1.9 2 2 2h15c.55 0 1-.45 1-1s-.45-1-1-1H4c-.55 0-1-.45-1-1V6c0-.55-.45-1-1-1zm19-4H7c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V3c0-1.1-.9-2-2-2zm-1 16H8c-.55 0-1-.45-1-1V4c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zM15 5h-2c-1.1 0-2 .9-2 2v2c0 1.1.9 2 2 2h2v2h-3c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2zm0 4h-2V7h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tonality
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 17.93c-3.94-.49-7-3.85-7-7.93s3.05-7.44 7-7.93v15.86zm2-15.86c1.03.13 2 .45 2.87.93H13v-.93zM13 7h5.24c.25.31.48.65.68 1H13V7zm0 3h6.74c.08.33.15.66.19 1H13v-1zm0 9.93V19h2.87c-.87.48-1.84.8-2.87.93zM18.24 17H13v-1h5.92c-.2.35-.43.69-.68 1zm1.5-3H13v-1h6.93c-.04.34-.11.67-.19 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 looks-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-6 14c-.55 0-1-.45-1-1V9h-1c-.55 0-1-.45-1-1s.45-1 1-1h2c.55 0 1 .45 1 1v8c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 center-focus-strong
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 8c-2.21 0-4 1.79-4 4s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm-8 7c-.55 0-1 .45-1 1v3c0 1.1.9 2 2 2h3c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1-.45-1-1v-2c0-.55-.45-1-1-1zm1-9c0-.55.45-1 1-1h2c.55 0 1-.45 1-1s-.45-1-1-1H5c-1.1 0-2 .9-2 2v3c0 .55.45 1 1 1s1-.45 1-1V6zm14-3h-3c-.55 0-1 .45-1 1s.45 1 1 1h2c.55 0 1 .45 1 1v2c0 .55.45 1 1 1s1-.45 1-1V5c0-1.1-.9-2-2-2zm0 15c0 .55-.45 1-1 1h-2c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2v-3c0-.55-.45-1-1-1s-1 .45-1 1v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 photo-size-select-actual
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 3H3C2 3 1 4 1 5v14c0 1.1.9 2 2 2h18c1 0 2-1 2-2V5c0-1-1-2-2-2zM5.63 16.19l2.49-3.2c.2-.25.58-.26.78-.01l2.1 2.53 3.1-3.99c.2-.26.6-.26.8.01l3.51 4.68c.25.33.01.8-.4.8H6.02c-.41-.01-.65-.49-.39-.82z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 crop-7-5
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M19,5H5C3.9,5,3,5.9,3,7v10c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V7C21,5.9,20.1,5,19,5z M19,17H5V7h14V17z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 collections
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M22 16V4c0-1.1-.9-2-2-2H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2zm-10.6-3.47l1.63 2.18 2.58-3.22c.2-.25.58-.25.78 0l2.96 3.7c.26.33.03.81-.39.81H9c-.41 0-.65-.47-.4-.8l2-2.67c.2-.26.6-.26.8 0zM2 7v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1s-1 .45-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flip-camera-android
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9,12c0,1.66,1.34,3,3,3s3-1.34,3-3s-1.34-3-3-3S9,10.34,9,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8,9L8,9c0-0.55-0.45-1-1-1H5.09C6.47,5.61,9.05,4,12,4c3.49,0,6.45,2.24,7.54,5.36C19.68,9.75,20.07,10,20.48,10h0 c0.68,0,1.18-0.67,0.96-1.31C20.07,4.79,16.36,2,12,2C8.73,2,5.82,3.58,4,6.01V5c0-0.55-0.45-1-1-1h0C2.45,4,2,4.45,2,5v4 c0,0.55,0.45,1,1,1h4C7.55,10,8,9.55,8,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16,15L16,15c0,0.55,0.45,1,1,1h1.91c-1.38,2.39-3.96,4-6.91,4c-3.49,0-6.45-2.24-7.54-5.36C4.32,14.25,3.93,14,3.52,14h0 c-0.68,0-1.18,0.67-0.96,1.31C3.93,19.21,7.64,22,12,22c3.27,0,6.18-1.58,8-4.01V19c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-4 c0-0.55-0.45-1-1-1h-4C16.45,14,16,14.45,16,15z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-free
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 5v3c0 .55.45 1 1 1s1-.45 1-1V6c0-.55.45-1 1-1h2c.55 0 1-.45 1-1s-.45-1-1-1H5c-1.1 0-2 .9-2 2zm1 10c-.55 0-1 .45-1 1v3c0 1.1.9 2 2 2h3c.55 0 1-.45 1-1s-.45-1-1-1H6c-.55 0-1-.45-1-1v-2c0-.55-.45-1-1-1zm15 3c0 .55-.45 1-1 1h-2c-.55 0-1 .45-1 1s.45 1 1 1h3c1.1 0 2-.9 2-2v-3c0-.55-.45-1-1-1s-1 .45-1 1v2zm0-15h-3c-.55 0-1 .45-1 1s.45 1 1 1h2c.55 0 1 .45 1 1v2c0 .55.45 1 1 1s1-.45 1-1V5c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-pause
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,9L4,9c0.26,0.26,0.34,0.63,0.25,0.98c-0.35,1.36-0.36,2.87,0.1,4.38c0.88,2.91,3.44,5.1,6.44,5.55 c5.52,0.81,10.19-4.06,9.03-9.62c-0.65-3.13-3.23-5.61-6.37-6.16c-1.21-0.21-2.38-0.15-3.46,0.13C9.64,4.35,9.26,4.26,9.01,4.01l0,0 C8.45,3.45,8.73,2.52,9.48,2.32c1.47-0.38,3.06-0.44,4.7-0.09c3.98,0.86,7.09,4.18,7.7,8.2c1.04,6.81-4.82,12.58-11.64,11.42 C6.23,21.16,2.98,17.99,2.2,14c-0.31-1.59-0.24-3.12,0.12-4.53C2.52,8.72,3.45,8.45,4,9z M7,5.5C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5 S4.67,4,5.5,4S7,4.67,7,5.5z M12,6c-3.31,0-6,2.69-6,6s2.69,6,6,6s6-2.69,6-6S15.31,6,12,6z M10,15L10,15c-0.55,0-1-0.45-1-1v-4 c0-0.55,0.45-1,1-1h0c0.55,0,1,0.45,1,1v4C11,14.55,10.55,15,10,15z M14,15L14,15c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h0 c0.55,0,1,0.45,1,1v4C15,14.55,14.55,15,14,15z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 exposure-zero
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M16.14 12.5c0 1-.1 1.85-.3 2.55s-.48 1.27-.83 1.7c-.36.44-.79.75-1.3.95s-1.07.3-1.7.3c-.62 0-1.18-.1-1.69-.3-.51-.2-.95-.51-1.31-.95s-.65-1.01-.85-1.7c-.2-.7-.3-1.55-.3-2.55v-2.04c0-1 .1-1.85.3-2.55.2-.7.48-1.26.84-1.69.36-.43.8-.74 1.31-.93C10.81 5.1 11.38 5 12 5c.63 0 1.19.1 1.7.29.51.19.95.5 1.31.93.36.43.64.99.84 1.69.2.7.3 1.54.3 2.55v2.04h-.01zm-2.11-2.36c0-.64-.05-1.18-.13-1.62-.09-.44-.22-.79-.4-1.06-.17-.27-.39-.46-.64-.58-.25-.13-.54-.19-.86-.19s-.61.06-.86.18-.47.31-.64.58-.31.62-.4 1.06-.13.98-.13 1.62v2.67c0 .64.05 1.18.14 1.62.09.45.23.81.4 1.09s.39.48.64.61.54.19.87.19.62-.06.87-.19.46-.33.63-.61.3-.64.39-1.09.13-.99.13-1.62v-2.66h-.01z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 hdr-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17.5 14.25V13h1.1l.72 1.59c.11.25.36.41.63.41.5 0 .83-.51.64-.96l-.49-1.14c.5-.3.9-.8.9-1.4v-1c0-.83-.67-1.5-1.5-1.5H17c-.55 0-1 .45-1 1v3.9l1.04 1.04c.27-.11.46-.38.46-.69zm0-3.75h2v1h-2v-1zm-4.5 0v.4l1.5 1.5v-1.9c0-.82-.68-1.5-1.5-1.5h-1.9l1.5 1.5h.4zm8.03 10.53l-18-18c-.29-.29-.76-.29-1.05 0-.29.29-.29.76 0 1.05l4.98 4.98c-.27.11-.46.38-.46.69V11h-2V9.75c0-.41-.34-.75-.75-.75S3 9.34 3 9.75v4.5c0 .41.34.75.75.75s.75-.34.75-.75V12.5h2v1.75c0 .41.34.75.75.75s.75-.34.75-.75V10.1l1.5 1.5v2.9c0 .28.22.5.5.5h2.5c.12 0 .24-.01.36-.04l7.11 7.11c.29.29.76.29 1.05 0 .29-.28.29-.75.01-1.04z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 panorama-wide-angle
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 6c2.45 0 4.71.2 7.29.64.47 1.78.71 3.58.71 5.36s-.24 3.58-.71 5.36c-2.58.44-4.84.64-7.29.64s-4.71-.2-7.29-.64C4.24 15.58 4 13.78 4 12s.24-3.58.71-5.36C7.29 6.2 9.55 6 12 6m0-2c-2.73 0-5.22.24-7.95.72l-.93.16-.25.9C2.29 7.85 2 9.93 2 12s.29 4.15.87 6.22l.25.89.93.16c2.73.49 5.22.73 7.95.73s5.22-.24 7.95-.72l.93-.16.25-.89c.58-2.08.87-4.16.87-6.23s-.29-4.15-.87-6.22l-.25-.89-.93-.16C17.22 4.24 14.73 4 12 4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 transform
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 16H9c-.55 0-1-.45-1-1V4h.79c.45 0 .67-.54.35-.85l-1.79-1.8c-.2-.2-.51-.2-.71 0l-1.79 1.8c-.31.31-.09.85.36.85H6v2H3c-.55 0-1 .45-1 1s.45 1 1 1h3v8c0 1.1.9 2 2 2h8v2h-.79c-.45 0-.67.54-.35.85l1.79 1.79c.2.2.51.2.71 0l1.79-1.79c.32-.31.09-.85-.35-.85H18v-2h3c.55 0 1-.45 1-1s-.45-1-1-1zm-5-2h2V8c0-1.1-.9-2-2-2h-6v2h5c.55 0 1 .45 1 1v5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-lira
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M9,15.84l-1.47,0.92C6.86,17.18,6,16.7,6,15.91c0-0.34,0.18-0.66,0.47-0.85L9,13.48v-2.36l-1.47,0.92 C6.86,12.46,6,11.98,6,11.19c0-0.34,0.18-0.66,0.47-0.85L9,8.76V4c0-0.55,0.45-1,1-1s1,0.45,1,1v3.51l2.47-1.55 C14.14,5.54,15,6.02,15,6.81c0,0.34-0.18,0.66-0.47,0.85L11,9.87l0.01,2.35l2.46-1.54c0.67-0.42,1.53,0.06,1.53,0.85 c0,0.34-0.18,0.66-0.47,0.85L11,14.59V19c2.47,0,4.52-1.79,4.93-4.15c0.08-0.49,0.49-0.85,0.98-0.85c0.61,0,1.09,0.54,1,1.14 C17.37,18.46,14.48,21,11,21h-1c-0.55,0-1-0.45-1-1V15.84z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 camera-roll
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M14 5c0-1.1-.9-2-2-2h-1V2c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1v1H4c-1.1 0-2 .9-2 2v15c0 1.1.9 2 2 2h8c1.1 0 2-.9 2-2h6c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2h-6zm-2 13h-2v-2h2v2zm0-9h-2V7h2v2zm4 9h-2v-2h2v2zm0-9h-2V7h2v2zm4 9h-2v-2h2v2zm0-9h-2V7h2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 slideshow
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10 9.04v5.92c0 .42.48.65.81.39l3.7-2.96c.25-.2.25-.58 0-.78l-3.7-2.96c-.33-.26-.81-.03-.81.39zM19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H6c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 music-note
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5v8.55c-.94-.54-2.1-.75-3.33-.32-1.34.48-2.37 1.67-2.61 3.07-.46 2.74 1.86 5.08 4.59 4.65 1.96-.31 3.35-2.11 3.35-4.1V7h2c1.1 0 2-.9 2-2s-.9-2-2-2h-2c-1.1 0-2 .9-2 2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _8mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,6.5c0-0.55,0.45-1,1-1h2.5 c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1H11c-0.55,0-1-0.45-1-1V6.5z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14 h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5 c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75 s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "6.5",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-vertical
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.94 21.12c-1.1-2.94-1.64-6.03-1.64-9.12s.55-6.18 1.64-9.12c.04-.11.06-.22.06-.31 0-.34-.23-.57-.63-.57H4.63c-.4 0-.63.23-.63.57 0 .1.02.2.06.31C5.16 5.82 5.71 8.91 5.71 12s-.55 6.18-1.64 9.12c-.05.11-.07.22-.07.31 0 .33.23.57.63.57h14.75c.39 0 .63-.24.63-.57-.01-.1-.03-.2-.07-.31zM6.54 20c.77-2.6 1.16-5.28 1.16-8s-.39-5.4-1.16-8h10.91c-.77 2.6-1.16 5.28-1.16 8s.39 5.4 1.16 8H6.54z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _2mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,9c0-0.55,0.45-1,1-1h2V7h-2.25 C10.34,7,10,6.66,10,6.25s0.34-0.75,0.75-0.75h2.75c0.55,0,1,0.45,1,1V8c0,0.55-0.45,1-1,1h-2v1h2.25c0.41,0,0.75,0.34,0.75,0.75 s-0.34,0.75-0.75,0.75H11c-0.55,0-1-0.45-1-1V9z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25 C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1 h4.5c0.55,0,1,0.45,1,1V17.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 photo
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M21 19V5c0-1.1-.9-2-2-2H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2zM8.9 13.98l2.1 2.53 3.1-3.99c.2-.26.6-.26.8.01l3.51 4.68c.25.33.01.8-.4.8H6.02c-.42 0-.65-.48-.39-.81L8.12 14c.19-.26.57-.27.78-.02z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 wb-iridescent
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 15h12c.55 0 1-.45 1-1v-3.95c0-.55-.45-1-1-1H6c-.55 0-1 .45-1 1V14c0 .55.45 1 1 1zm5-13v1.05c0 .55.45.95 1 .95s1-.4 1-.95V2c0-.55-.45-1-1-1s-1 .45-1 1zm7.34 2.3l-.38.38c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0l.38-.38c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0zM13 22v-.96c0-.55-.45-1-1-1s-1 .45-1 1V22c0 .55.45 1 1 1s1-.45 1-1zm6.74-3.61l-.39-.39c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l.38.39c.39.39 1.02.39 1.41 0l.01-.01c.39-.38.39-1.02 0-1.4zM4.25 5.71l.39.39c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41l-.39-.39c-.39-.39-1.02-.39-1.41 0-.38.39-.38 1.03 0 1.41zm1.42 14.08l.38-.38c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0l-.38.38c-.39.39-.39 1.02 0 1.41.38.39 1.02.39 1.41 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 auto-awesome-mosaic
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:x "0", :width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M3,5v14c0,1.1,0.89,2,2,2h6V3H5C3.89,3,3,3.9,3,5z M19,3h-6v8h8V5C21,3.9,20.1,3,19,3z M13,21h6c1.1,0,2-0.9,2-2v-6h-8V21 z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 colorize
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20.71 5.63l-2.34-2.34c-.39-.39-1.02-.39-1.41 0l-3.12 3.12-1.23-1.21c-.39-.39-1.02-.38-1.41 0-.39.39-.39 1.02 0 1.41l.72.72-8.77 8.77c-.1.1-.15.22-.15.36v4.04c0 .28.22.5.5.5h4.04c.13 0 .26-.05.35-.15l8.77-8.77.72.72c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41l-1.22-1.22 3.12-3.12c.41-.4.41-1.03.02-1.42zM6.92 19L5 17.08l8.06-8.06 1.92 1.92L6.92 19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _17mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.75,5.5H9c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12,6.25 c0-0.41,0.34-0.75,0.75-0.75h2.75c0.67,0,1.15,0.65,0.96,1.29l-1.28,4.12c-0.11,0.35-0.43,0.59-0.8,0.59 c-0.56,0-0.97-0.54-0.8-1.08L14.62,7h-1.87C12.34,7,12,6.66,12,6.25z M18,16c0,0.55-0.45,1-1,1h-2v0.75 c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 panorama-wide-angle-select
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M12,4C8.03,4,5.15,4.63,3,5c-0.55,1.97-1,3.92-1,7c0,3.03,0.45,5.06,1,7c2.15,0.37,4.98,1,9,1c3.97,0,6.85-0.63,9-1 c0.57-2.02,1-3.99,1-7c0-3.03-0.45-5.06-1-7C18.85,4.63,16.02,4,12,4z",
       :stroke nil,
       :fill nil}))))))


(helix.core/defnc
 rotate-left
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6.56 7.98C6.1 7.52 5.31 7.6 5 8.17c-.28.51-.5 1.03-.67 1.58-.19.63.31 1.25.96 1.25h.01c.43 0 .82-.28.94-.7.12-.4.28-.79.48-1.17.22-.37.15-.84-.16-1.15zM5.31 13h-.02c-.65 0-1.15.62-.96 1.25.16.54.38 1.07.66 1.58.31.57 1.11.66 1.57.2.3-.31.38-.77.17-1.15-.2-.37-.36-.76-.48-1.16-.12-.44-.51-.72-.94-.72zm2.85 6.02c.51.28 1.04.5 1.59.66.62.18 1.24-.32 1.24-.96v-.03c0-.43-.28-.82-.7-.94-.4-.12-.78-.28-1.15-.48-.38-.21-.86-.14-1.16.17l-.03.03c-.45.45-.36 1.24.21 1.55zM13 4.07v-.66c0-.89-1.08-1.34-1.71-.71L9.17 4.83c-.4.4-.4 1.04 0 1.43l2.13 2.08c.63.62 1.7.17 1.7-.72V6.09c2.84.48 5 2.94 5 5.91 0 2.73-1.82 5.02-4.32 5.75-.41.12-.68.51-.68.94v.02c0 .65.61 1.14 1.23.96C17.57 18.71 20 15.64 20 12c0-4.08-3.05-7.44-7-7.93z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 flare
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 11H2c-.55 0-1 .45-1 1s.45 1 1 1h4c.55 0 1-.45 1-1s-.45-1-1-1zm2.47-3.94l-.72-.72c-.39-.39-1.02-.39-1.41 0-.39.39-.39 1.02 0 1.41l.71.71c.39.39 1.02.39 1.41 0 .39-.38.39-1.02.01-1.4zM12 1c-.56 0-1 .45-1 1v4c0 .55.45 1 1 1s1-.45 1-1V2c0-.55-.45-1-1-1zm5.66 5.35c-.39-.39-1.02-.39-1.41 0l-.71.71c-.39.39-.39 1.02 0 1.41.39.39 1.02.39 1.41 0l.71-.71c.38-.39.38-1.03 0-1.41zM17 12c0 .56.45 1 1 1h4c.55 0 1-.45 1-1s-.45-1-1-1h-4c-.55 0-1 .45-1 1zm-5-3c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3zm3.53 7.94l.71.71c.39.39 1.02.39 1.41 0 .39-.39.39-1.02 0-1.41l-.71-.71c-.39-.39-1.02-.39-1.41 0-.38.39-.38 1.03 0 1.41zm-9.19.71c.39.39 1.02.39 1.41 0l.71-.71c.39-.39.39-1.02 0-1.41-.39-.39-1.02-.39-1.41 0l-.71.71c-.38.39-.38 1.03 0 1.41zM12 23c.56 0 1-.45 1-1v-4c0-.55-.45-1-1-1s-1 .45-1 1v4c0 .55.45 1 1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _6mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M10,6.5c0-0.55,0.45-1,1-1h2.75 c0.41,0,0.75,0.34,0.75,0.75C14.5,6.66,14.16,7,13.75,7H11.5v1h2c0.55,0,1,0.45,1,1v1.5c0,0.55-0.45,1-1,1H11c-0.55,0-1-0.45-1-1 V6.5z M12.5,17.75c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1 v3.75c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M18,16c0,0.55-0.45,1-1,1 h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "9",
      :x "11.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _13mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.75,5.5H9c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12,10.75 c0-0.41,0.34-0.75,0.75-0.75H15V9h-1.5C13.22,9,13,8.78,13,8.5S13.22,8,13.5,8H15V7h-2.25C12.34,7,12,6.66,12,6.25 s0.34-0.75,0.75-0.75h2.75c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1h-2.75C12.34,11.5,12,11.16,12,10.75z M18,16c0,0.55-0.45,1-1,1 h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 motion-photos-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,6c-0.92,0-1.8,0.22-2.58,0.59l7.99,7.99C17.78,13.8,18,12.92,18,12C18,8.69,15.31,6,12,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,3.51L2.1,3.51c-0.39,0.39-0.39,1.03,0,1.42l1.56,1.56c-1.25,1.88-1.88,4.21-1.59,6.7c0.52,4.54,4.21,8.23,8.75,8.75 c2.49,0.28,4.81-0.34,6.69-1.59l1.56,1.56c0.39,0.39,1.03,0.39,1.42,0l0,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51 C3.13,3.13,2.49,3.12,2.1,3.51z M12,20c-4.41,0-8-3.59-8-8c0-1.48,0.41-2.86,1.12-4.06l1.47,1.47C6.22,10.2,6,11.08,6,12 c0,3.31,2.69,6,6,6c0.92,0,1.8-0.22,2.58-0.59l1.47,1.47C14.86,19.59,13.48,20,12,20z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,4c4.41,0,8,3.59,8,8c0,1.48-0.41,2.86-1.12,4.05l1.45,1.45C21.39,15.93,22,14.04,22,12c0-5.52-4.48-10-10-10 C9.96,2,8.07,2.61,6.49,3.66l1.45,1.45C9.14,4.41,10.52,4,12,4z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 crop-original
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-1 16H6c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zm-4.44-6.19l-2.35 3.02-1.56-1.88c-.2-.25-.58-.24-.78.01l-1.74 2.23c-.26.33-.02.81.39.81h8.98c.41 0 .65-.47.4-.8l-2.55-3.39c-.19-.26-.59-.26-.79 0z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 timer-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M10,3h4c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1h-4C9.45,1,9,1.45,9,2C9,2.55,9.45,3,10,3z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,8c0.55,0,1,0.45,1,1v1.17l6.98,6.98C20.63,15.91,21,14.5,21,13c0-2.12-0.74-4.07-1.97-5.61l0.75-0.75 c0.38-0.38,0.39-1.01,0-1.4c0,0-0.01-0.01-0.01-0.01c-0.39-0.39-1.01-0.38-1.4,0l-0.75,0.75C16.07,4.74,14.12,4,12,4 c-1.48,0-2.89,0.38-4.13,1.04l3.36,3.36C11.41,8.16,11.68,8,12,8z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.1,3.51L2.1,3.51c-0.39,0.39-0.39,1.02,0,1.41l2.72,2.72C3.73,9.09,3.05,10.86,3,12.76C2.87,17.84,6.94,22,12,22 c2.02,0,3.88-0.67,5.38-1.79l1.69,1.69c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L3.51,3.51 C3.12,3.12,2.49,3.12,2.1,3.51z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 face-retouching-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1.25", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M17.5,10c0.75,0,1.47-0.09,2.17-0.24C19.88,10.47,20,11.22,20,12c0,1.22-0.28,2.37-0.77,3.4l1.49,1.49 C21.53,15.44,22,13.78,22,12c0-5.52-4.48-10-10-10c-1.78,0-3.44,0.47-4.89,1.28l5.33,5.33C13.93,9.49,15.65,10,17.5,10z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.6,4.43l1.48,1.48C2.51,7.95,1.7,10.6,2.1,13.46c0.62,4.33,4.11,7.82,8.44,8.44c2.85,0.41,5.51-0.41,7.55-1.98 l1.48,1.48c0.39,0.39,1.02,0.39,1.41,0l0,0c0.39-0.39,0.39-1.02,0-1.41L4.01,3.01c-0.39-0.39-1.02-0.39-1.41,0l0,0 C2.21,3.41,2.21,4.04,2.6,4.43z M16.66,18.49C15.35,19.44,13.74,20,12,20c-4.41,0-8-3.59-8-8c0-0.05,0.01-0.1,0-0.14 c1.39-0.52,2.63-1.35,3.64-2.39L16.66,18.49z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 palette
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,2C6.49,2,2,6.49,2,12s4.49,10,10,10c1.38,0,2.5-1.12,2.5-2.5c0-0.61-0.23-1.2-0.64-1.67c-0.08-0.1-0.13-0.21-0.13-0.33 c0-0.28,0.22-0.5,0.5-0.5H16c3.31,0,6-2.69,6-6C22,6.04,17.51,2,12,2z M17.5,13c-0.83,0-1.5-0.67-1.5-1.5c0-0.83,0.67-1.5,1.5-1.5 s1.5,0.67,1.5,1.5C19,12.33,18.33,13,17.5,13z M14.5,9C13.67,9,13,8.33,13,7.5C13,6.67,13.67,6,14.5,6S16,6.67,16,7.5 C16,8.33,15.33,9,14.5,9z M5,11.5C5,10.67,5.67,10,6.5,10S8,10.67,8,11.5C8,12.33,7.33,13,6.5,13S5,12.33,5,11.5z M11,7.5 C11,8.33,10.33,9,9.5,9S8,8.33,8,7.5C8,6.67,8.67,6,9.5,6S11,6.67,11,7.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 looks-two
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-4 8c0 1.1-.9 2-2 2h-2v2h3c.55 0 1 .45 1 1s-.45 1-1 1h-4c-.55 0-1-.45-1-1v-3c0-1.1.9-2 2-2h2V9h-3c-.55 0-1-.45-1-1s.45-1 1-1h3c1.1 0 2 .9 2 2v2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 add-to-photos
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M3 6c-.55 0-1 .45-1 1v13c0 1.1.9 2 2 2h13c.55 0 1-.45 1-1s-.45-1-1-1H5c-.55 0-1-.45-1-1V7c0-.55-.45-1-1-1zm17-4H8c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V4c0-1.1-.9-2-2-2zm-2 9h-3v3c0 .55-.45 1-1 1s-1-.45-1-1v-3h-3c-.55 0-1-.45-1-1s.45-1 1-1h3V6c0-.55.45-1 1-1s1 .45 1 1v3h3c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 _19mp
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "6.5",
      :x "13.5",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M7.75,5.5H9c0.55,0,1,0.45,1,1 v4.25c0,0.41-0.34,0.75-0.75,0.75S8.5,11.16,8.5,10.75V7H7.75C7.34,7,7,6.66,7,6.25S7.34,5.5,7.75,5.5z M12.5,17.75 c0,0.41-0.34,0.75-0.75,0.75S11,18.16,11,17.75V14h-1v2.25C10,16.66,9.66,17,9.25,17S8.5,16.66,8.5,16.25V14h-1v3.75 c0,0.41-0.34,0.75-0.75,0.75S6,18.16,6,17.75V13.5c0-0.55,0.45-1,1-1h4.5c0.55,0,1,0.45,1,1V17.75z M12,10.75 c0-0.41,0.34-0.75,0.75-0.75H15V9h-2c-0.55,0-1-0.45-1-1V6.5c0-0.55,0.45-1,1-1h2.5c0.55,0,1,0.45,1,1v4c0,0.55-0.45,1-1,1h-2.75 C12.34,11.5,12,11.16,12,10.75z M18,16c0,0.55-0.45,1-1,1h-2v0.75c0,0.41-0.34,0.75-0.75,0.75s-0.75-0.34-0.75-0.75V13.5 c0-0.55,0.45-1,1-1H17c0.55,0,1,0.45,1,1V16z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "14",
      :x "15",
      :width "1.5",
      :height "1.5",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 rotate-90-degrees-ccw
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M5.93 7.83l-3.65 3.66c-.78.78-.78 2.05 0 2.83l3.66 3.66c.78.78 2.05.78 2.83 0l3.66-3.65c.78-.78.78-2.05 0-2.83L8.76 7.82c-.79-.78-2.05-.78-2.83.01zM4.4 12.19l2.25-2.25c.39-.39 1.02-.39 1.42 0l2.24 2.24c.39.39.39 1.02 0 1.41l-2.25 2.25c-.39.39-1.02.39-1.42 0L4.4 13.61c-.39-.39-.39-1.03 0-1.42zm14.96-5.55C17.61 4.88 15.3 4 13 4v-.83c0-.89-1.08-1.34-1.71-.71L9.47 4.29c-.39.39-.39 1.02 0 1.41l1.83 1.83c.62.63 1.7.19 1.7-.7V6c2.02 0 4.03.86 5.45 2.61 2.05 2.52 2.05 6.27 0 8.79C17.03 19.14 15.02 20 13 20c-.78 0-1.55-.13-2.29-.39-.36-.12-.75-.01-1.02.26-.5.5-.34 1.39.34 1.62.96.34 1.96.51 2.97.51 2.3 0 4.61-.88 6.36-2.64 3.52-3.51 3.52-9.21 0-12.72z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 motion-photos-auto
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,9L4,9c0.26,0.26,0.34,0.63,0.25,0.98c-0.35,1.36-0.36,2.87,0.1,4.38c0.88,2.91,3.44,5.1,6.44,5.55 c5.52,0.81,10.19-4.06,9.03-9.62c-0.65-3.13-3.23-5.61-6.37-6.16c-1.21-0.21-2.38-0.15-3.46,0.13C9.64,4.35,9.26,4.26,9.01,4.01l0,0 C8.45,3.45,8.73,2.52,9.48,2.32c1.47-0.38,3.06-0.44,4.7-0.09c3.98,0.86,7.09,4.18,7.7,8.2c1.04,6.81-4.82,12.58-11.64,11.42 C6.23,21.16,2.98,17.99,2.2,14c-0.31-1.59-0.24-3.12,0.12-4.53C2.52,8.72,3.45,8.45,4,9z M7,5.5C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5 S4.67,4,5.5,4S7,4.67,7,5.5z M12.03,8.99h-0.07l-1.16,3.31h2.39L12.03,8.99z M12,18c3.31,0,6-2.69,6-6s-2.69-6-6-6s-6,2.69-6,6 S8.69,18,12,18z M8.61,14.63l2.43-6.46C11.19,7.77,11.57,7.5,12,7.5s0.82,0.27,0.97,0.67l2.43,6.46c0.16,0.42-0.15,0.87-0.6,0.87 c-0.27,0-0.52-0.17-0.61-0.43l-0.56-1.61h-3.23l-0.57,1.62c-0.09,0.26-0.33,0.43-0.61,0.43C8.76,15.5,8.45,15.05,8.61,14.63z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 linked-camera
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/g
      nil
      (helix.dom/circle
       {:r "2.5", :cy "13", :cx "12", :stroke nil, :fill nil})
      (helix.dom/g
       nil
       (helix.dom/path
        {:d
         "M16.6,2.37c2.1,0.27,3.77,1.93,4.03,4.03C20.67,6.74,20.95,7,21.29,7l0,0c0.39,0,0.71-0.34,0.66-0.73 c-0.33-2.72-2.5-4.89-5.22-5.22C16.34,1,16,1.32,16,1.71l0,0C16,2.05,16.26,2.33,16.6,2.37z",
         :stroke nil,
         :fill nil})
       (helix.dom/path
        {:d
         "M19.23,6.19C18.93,5,18,4.07,16.81,3.77C16.4,3.67,16,3.99,16,4.42l0,0c0,0.29,0.19,0.57,0.48,0.64 c0.72,0.18,1.29,0.74,1.46,1.46C18.01,6.81,18.28,7,18.58,7l0,0C19.01,7,19.33,6.6,19.23,6.19z",
         :stroke nil,
         :fill nil}))
      (helix.dom/path
       {:d
        "M17,8c0-1.1-0.9-2-2-2V4c0-0.55-0.45-1-1-1H9.88C9.32,3,8.78,3.24,8.4,3.65L7.17,5H4C2.9,5,2,5.9,2,7v12 c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2v-9c0-1.1-0.9-2-2-2H17z M12,17.5c-2.48,0-4.5-2.02-4.5-4.5S9.52,8.5,12,8.5 s4.5,2.02,4.5,4.5S14.48,17.5,12,17.5z",
        :stroke nil,
        :fill nil})))))))


(helix.core/defnc
 motion-photos-on
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M4,9L4,9c0.26,0.26,0.34,0.63,0.25,0.98c-0.35,1.36-0.36,2.87,0.1,4.38c0.88,2.91,3.44,5.1,6.44,5.55 c5.52,0.81,10.19-4.06,9.03-9.62c-0.65-3.13-3.23-5.61-6.37-6.16c-1.21-0.21-2.38-0.15-3.46,0.13C9.64,4.35,9.26,4.26,9.01,4.01l0,0 C8.45,3.45,8.73,2.52,9.48,2.32c1.47-0.38,3.06-0.44,4.7-0.09c3.98,0.86,7.09,4.18,7.7,8.2c1.04,6.81-4.82,12.58-11.64,11.42 C6.23,21.16,2.98,17.99,2.2,14c-0.31-1.59-0.24-3.12,0.12-4.53C2.52,8.72,3.45,8.45,4,9z M6,12c0-3.31,2.69-6,6-6s6,2.69,6,6 s-2.69,6-6,6S6,15.31,6,12z M7,5.5C7,6.33,6.33,7,5.5,7S4,6.33,4,5.5S4.67,4,5.5,4S7,4.67,7,5.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blur-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M6 13c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-8c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm-3 .5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM6 5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm15 5.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM14 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0-3.5c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zm-11 10c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm7 7c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm0-17c.28 0 .5-.22.5-.5s-.22-.5-.5-.5-.5.22-.5.5.22.5.5.5zM10 7c.55 0 1-.45 1-1s-.45-1-1-1-1 .45-1 1 .45 1 1 1zm0 5.5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm8 .5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-8c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0-4c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm3 8.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zM14 17c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm0 3.5c-.28 0-.5.22-.5.5s.22.5.5.5.5-.22.5-.5-.22-.5-.5-.5zm-4-12c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm0 8.5c-.55 0-1 .45-1 1s.45 1 1 1 1-.45 1-1-.45-1-1-1zm4-4.5c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5zm0-4c-.83 0-1.5.67-1.5 1.5s.67 1.5 1.5 1.5 1.5-.67 1.5-1.5-.67-1.5-1.5-1.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 currency-yen
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6.82,3c0.34,0,0.66,0.17,0.84,0.46L12,10.29l4.34-6.83C16.52,3.17,16.84,3,17.18,3c0.79,0,1.27,0.87,0.84,1.54L13.92,11 H17c0.55,0,1,0.45,1,1c0,0.55-0.45,1-1,1h-4v2h4c0.55,0,1,0.45,1,1c0,0.55-0.45,1-1,1h-4v3c0,0.55-0.45,1-1,1s-1-0.45-1-1v-3H7 c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h4v-2H7c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h3.08L5.98,4.54C5.55,3.87,6.03,3,6.82,3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 view-compact
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M4,18h2.5v-2.5H4V18z M4,13.25h2.5v-2.5H4V13.25z M4,8.5h2.5V6H4V8.5z M17.5,6v2.5H20V6H17.5z M13,8.5h2.5V6H13V8.5z M17.5,18H20v-2.5h-2.5V18z M17.5,13.25H20v-2.5h-2.5V13.25z M8.5,18H11v-2.5H8.5V18z M13,18h2.5v-2.5H13V18z M8.5,8.5H11V6H8.5 V8.5z M13,13.25h2.5v-2.5H13V13.25z M8.5,13.25H11v-2.5H8.5V13.25z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M21 10.78V8c0-1.65-1.35-3-3-3h-4c-.77 0-1.47.3-2 .78-.53-.48-1.23-.78-2-.78H6C4.35 5 3 6.35 3 8v2.78c-.61.55-1 1.34-1 2.22v5c0 .55.45 1 1 1s1-.45 1-1v-1h16v1c0 .55.45 1 1 1s1-.45 1-1v-5c0-.88-.39-1.67-1-2.22zM14 7h4c.55 0 1 .45 1 1v2h-6V8c0-.55.45-1 1-1zM5 8c0-.55.45-1 1-1h4c.55 0 1 .45 1 1v2H5V8zm-1 7v-2c0-.55.45-1 1-1h14c.55 0 1 .45 1 1v2H4z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 door-back
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19h-1V5c0-1.1-0.9-2-2-2H7C5.9,3,5,3.9,5,5v14H4c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h16c0.55,0,1-0.45,1-1 C21,19.45,20.55,19,20,19z M10,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C11,12.55,10.55,13,10,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 door-front
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19h-1V5c0-1.1-0.9-2-2-2H7C5.9,3,5,3.9,5,5v14H4c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h16c0.55,0,1-0.45,1-1 C21,19.45,20.55,19,20,19z M14,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C15,12.55,14.55,13,14,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bedroom-child
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/rect
     {:y "8.5",
      :x "9",
      :width "6",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.64,12H8.37c-0.48,0-0.87,0.39-0.87,0.87h0.01V14h9v-1.13C16.51,12.39,16.12,12,15.64,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M17.25,17L17.25,17 c-0.41,0-0.75-0.34-0.75-0.75V15.5h-9v0.75C7.5,16.66,7.16,17,6.75,17h0C6.34,17,6,16.66,6,16.25v-3.38c0-1,0.62-1.85,1.5-2.2V9 c0-1.1,0.9-2,2-2h5c1.1,0,2,0.9,2,2v1.67c0.88,0.35,1.5,1.2,1.5,2.2v3.38C18,16.66,17.66,17,17.25,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 bathroom
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M9,18c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S9.55,18,9,18z M9,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S9.55,15,9,15z M12,18c-0.55,0-1-0.45-1-1 s0.45-1,1-1s1,0.45,1,1S12.55,18,12,18z M12,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S12.55,15,12,15z M15,18 c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,18,15,18z M15,15c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S15.55,15,15,15z M7,11L7,11c0-2.76,2.24-5,5-5h0c2.76,0,5,2.24,5,5v0c0,0.55-0.45,1-1,1H8C7.45,12,7,11.55,7,11z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bedroom-baby
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M12,17.99 c-2.37,0-4.61-0.83-6.4-2.35c-0.33-0.28-0.35-0.8-0.04-1.11l0,0c0.27-0.27,0.71-0.29,1.01-0.04c0.19,0.16,0.39,0.31,0.6,0.46 L8,13.49V9.5l-1,0.65c-0.32,0.21-0.73,0.16-0.99-0.12L6,10.01c-0.29-0.3-0.3-0.77-0.03-1.08C6.27,8.6,6.62,8.19,6.83,7.95 C6.92,7.84,6.9,7.67,6.79,7.59c0,0-0.81-0.31-0.79-0.57C6,6.91,9.36,6.99,9.36,6.99c0.18,0,0.34,0.1,0.43,0.25l1.44,2.5 c0.09,0.15,0.25,0.25,0.43,0.25h4.83c0.28,0,0.5,0.22,0.5,0.5v0c0,0.28-0.22,0.5-0.5,0.5H16v2.5l0.84,1.46 c0.2-0.15,0.4-0.3,0.6-0.46c0.3-0.25,0.73-0.23,1.01,0.04v0c0.31,0.31,0.29,0.82-0.04,1.11C16.61,17.16,14.37,17.99,12,17.99z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M14.69,14.24c-1.74,0.65-3.66,0.65-5.4,0l-0.81,1.41l-0.03,0.06c1.1,0.52,2.28,0.79,3.53,0.79s2.45-0.28,3.55-0.79 l-0.03-0.06L14.69,14.24z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 manage-search
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6,9H3C2.45,9,2,8.55,2,8v0c0-0.55,0.45-1,1-1h3c0.55,0,1,0.45,1,1v0C7,8.55,6.55,9,6,9z M6,12H3c-0.55,0-1,0.45-1,1v0 c0,0.55,0.45,1,1,1h3c0.55,0,1-0.45,1-1v0C7,12.45,6.55,12,6,12z M19.88,18.29l-3.12-3.12c-0.86,0.56-1.89,0.88-3,0.82 c-2.37-0.11-4.4-1.96-4.72-4.31C8.6,8.33,11.49,5.5,14.87,6.07c1.95,0.33,3.57,1.85,4,3.78c0.33,1.46,0.01,2.82-0.7,3.9l3.13,3.13 c0.39,0.39,0.39,1.02,0,1.41l0,0C20.91,18.68,20.27,18.68,19.88,18.29z M17,11c0-1.65-1.35-3-3-3s-3,1.35-3,3s1.35,3,3,3 S17,12.65,17,11z M3,19h8c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H3c-0.55,0-1,0.45-1,1v0C2,18.55,2.45,19,3,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 living
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.5,11.5c-0.55,0-1,0.45-1,1v2h-7v-2c0-0.55-0.45-1-1-1s-1,0.45-1,1V16c0,0.28,0.22,0.5,0.5,0.5h10 c0.28,0,0.5-0.22,0.5-0.5v-3.5C17.5,11.95,17.05,11.5,16.5,11.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M10,12.5V13h4v-0.5c0-1.3,0.99-2.35,2.25-2.47V9c0-0.83-0.67-1.5-1.5-1.5h-5.5c-0.83,0-1.5,0.67-1.5,1.5v1.03 C9.01,10.15,10,11.2,10,12.5z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M19,16c0,1.1-0.9,2-2,2H7 c-1.1,0-2-0.9-2-2v-3.5c0-0.92,0.51-1.72,1.25-2.15V9c0-1.66,1.34-3,3-3h5.5c1.66,0,3,1.34,3,3v1.35C18.49,10.78,19,11.58,19,12.5 V16z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 doorbell
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.8,3.9l-6,4.5C4.3,8.78,4,9.37,4,10v9c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-9c0-0.63-0.3-1.22-0.8-1.6l-6-4.5 C12.49,3.37,11.51,3.37,10.8,3.9z M12,17.5c-0.55,0-1-0.45-1-1h2C13,17.05,12.55,17.5,12,17.5z M15.5,16h-7C8.22,16,8,15.78,8,15.5 v0C8,15.22,8.22,15,8.5,15H9v-2.34c0-1.54,0.82-2.82,2.25-3.16V9.25c0-0.41,0.34-0.75,0.75-0.75s0.75,0.34,0.75,0.75V9.5 C14.19,9.84,15,11.12,15,12.66V15h0.5c0.28,0,0.5,0.22,0.5,0.5v0C16,15.78,15.78,16,15.5,16z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 coffee-maker
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18,6V4h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H6C4.9,2,4,2.9,4,4v16c0,1.1,0.9,2,2,2h13c0.55,0,1-0.45,1-1v0 c0-0.55-0.45-1-1-1h-3.03C17.2,19.09,18,17.64,18,16v-3c0-1.1-0.9-2-2-2h-6c-1.1,0-2,0.9-2,2v3c0,1.64,0.81,3.09,2.03,4H6V4h2v2 c0,0.55,0.45,1,1,1h8C17.55,7,18,6.55,18,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1", :cy "9", :cx "13", :stroke nil, :fill nil})))))


(helix.core/defnc
 chair
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21,9c-1.1,0-2,0.9-2,2v4H5v-4c0-1.1-0.9-2-2-2s-2,0.9-2,2v5c0,1.65,1.35,3,3,3v1c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-1 h12v1c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1v-1c1.65,0,3-1.35,3-3v-5C23,9.9,22.1,9,21,9z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M7,11v2h10v-2c0-1.86,1.28-3.41,3-3.86V6c0-1.65-1.35-3-3-3H7C5.35,3,4,4.35,4,6v1.14C5.72,7.59,7,9.14,7,11z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 shower
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/circle
    {:r "1", :cy "17", :cx "8", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "17", :cx "12", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "17", :cx "16", :stroke nil, :fill nil})
   (helix.dom/path
    {:d
     "M13,5.08V4c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v1.08C7.61,5.57,5,8.47,5,12v1c0,0.55,0.45,1,1,1h12c0.55,0,1-0.45,1-1 v-1C19,8.47,16.39,5.57,13,5.08z",
     :stroke nil,
     :fill nil})
   (helix.dom/circle
    {:r "1", :cy "20", :cx "8", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "20", :cx "12", :stroke nil, :fill nil})
   (helix.dom/circle
    {:r "1", :cy "20", :cx "16", :stroke nil, :fill nil}))))


(helix.core/defnc
 podcasts
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M14,12c0,0.74-0.4,1.38-1,1.72V21c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v-7.28c-0.6-0.35-1-0.98-1-1.72c0-1.1,0.9-2,2-2 S14,10.9,14,12z M10.75,6.13c-2.27,0.46-4.12,2.28-4.61,4.55c-0.4,1.86,0.07,3.62,1.08,4.94c0.35,0.45,1.03,0.47,1.43,0.07 l0.07-0.07c0.34-0.34,0.34-0.87,0.06-1.25c-0.68-0.9-0.98-2.1-0.66-3.37c0.35-1.42,1.52-2.57,2.95-2.88C13.69,7.52,16,9.49,16,12 c0,0.87-0.28,1.67-0.76,2.32c-0.3,0.41-0.29,0.97,0.07,1.33l0,0c0.44,0.44,1.17,0.37,1.54-0.14C17.57,14.53,18,13.31,18,12 C18,8.28,14.61,5.35,10.75,6.13z M10.83,2.07C6.3,2.58,2.61,6.25,2.07,10.78c-0.35,2.95,0.59,5.67,2.32,7.7 c0.37,0.43,1.03,0.46,1.43,0.06l0.05-0.05c0.35-0.35,0.38-0.92,0.05-1.3c-1.56-1.83-2.33-4.37-1.7-7.06 c0.7-3.01,3.18-5.39,6.22-5.97C15.53,3.18,20,7.08,20,12c0,1.96-0.72,3.76-1.9,5.16c-0.34,0.4-0.31,0.98,0.05,1.35l0,0 c0.42,0.42,1.11,0.39,1.49-0.07C21.11,16.7,22,14.46,22,12C22,6.09,16.87,1.38,10.83,2.07z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 feed
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V8L16,3z M8,7h3c0.55,0,1,0.45,1,1v0c0,0.55-0.45,1-1,1H8 C7.45,9,7,8.55,7,8v0C7,7.45,7.45,7,8,7z M16,17H8c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h8c0.55,0,1,0.45,1,1v0 C17,16.55,16.55,17,16,17z M16,13H8c-0.55,0-1-0.45-1-1v0c0-0.55,0.45-1,1-1h8c0.55,0,1,0.45,1,1v0C17,12.55,16.55,13,16,13z M15,8 V5l4,4h-3C15.45,9,15,8.55,15,8z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 window
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M11 11V3H5c-1.1 0-2 .9-2 2v6h8zm2 0h8V5c0-1.1-.9-2-2-2h-6v8zm-2 2H3v6c0 1.1.9 2 2 2h6v-8zm2 0v8h6c1.1 0 2-.9 2-2v-6h-8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 coffee
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18.5,3H6C4.9,3,4,3.9,4,5v5.71c0,3.83,2.95,7.18,6.78,7.29c3.96,0.12,7.22-3.06,7.22-7v-1h0.5c1.93,0,3.5-1.57,3.5-3.5 S20.43,3,18.5,3z M16,5v3H6V5H16z M18.5,8H18V5h0.5C19.33,5,20,5.67,20,6.5S19.33,8,18.5,8z M5,19h14c0.55,0,1,0.45,1,1v0 c0,0.55-0.45,1-1,1H5c-0.55,0-1-0.45-1-1v0C4,19.45,4.45,19,5,19z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 table-bar
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M22,7.5C22,5.57,17.52,4,12,4S2,5.57,2,7.5c0,1.81,3.95,3.31,9,3.48V15H9.35c-0.82,0-1.55,0.5-1.86,1.26l-0.99,2.47 C6.27,19.34,6.71,20,7.37,20h0c0.38,0,0.72-0.23,0.86-0.58L9.2,17h5.6l0.97,2.42c0.14,0.35,0.48,0.58,0.86,0.58h0 c0.66,0,1.11-0.66,0.86-1.27l-0.99-2.47C16.2,15.5,15.46,15,14.65,15H13v-4.02C18.05,10.81,22,9.31,22,7.5z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-indoor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M10.8,3.65l-6,4.5C4.3,8.53,4,9.12,4,9.75v9c0,1.1,0.9,2,2,2h12c1.1,0,2-0.9,2-2v-9c0-0.63-0.3-1.22-0.8-1.6l-6-4.5 C12.49,3.12,11.51,3.12,10.8,3.65z M15.27,15.67L14,15v1c0,0.55-0.45,1-1,1H9c-0.55,0-1-0.45-1-1v-4c0-0.55,0.45-1,1-1h4 c0.55,0,1,0.45,1,1v1l1.27-0.67C15.6,12.15,16,12.39,16,12.77v2.46C16,15.61,15.6,15.85,15.27,15.67z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 door-sliding
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,19V5c0-1.1-0.9-2-2-2h-5.25v16h-1.5V3H6C4.9,3,4,3.9,4,5v14c-0.55,0-1,0.45-1,1c0,0.55,0.45,1,1,1h16 c0.55,0,1-0.45,1-1C21,19.45,20.55,19,20,19z M9,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C10,12.55,9.55,13,9,13z M15,13c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1s1,0.45,1,1C16,12.55,15.55,13,15,13z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 light
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M13,6.06V4c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v2.06c-4.5,0.5-8,4.31-8,8.93C3,16.1,3.9,17,5.01,17L8,17 c0,2.21,1.79,4,4,4s4-1.79,4-4l2.99,0C20.1,17,21,16.1,21,14.99C21,10.37,17.5,6.56,13,6.06z M12,15l-7,0c0-3.86,3.14-7,7-7 s7,3.14,7,7L12,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 flatware
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,7.08c0,1.77-0.84,3.25-2,3.82V20c0,0.55-0.45,1-1,1h0c-0.55,0-1-0.45-1-1v-9.1c-1.16-0.57-2-2.05-2-3.82 C10.01,4.83,11.35,3,13,3C14.66,3,16,4.83,16,7.08z M18.27,3.18C17.64,2.99,17,3.49,17,4.15L17,20c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1v-7h1c0.55,0,1-0.45,1-1V7C21,5.54,20.14,3.74,18.27,3.18z M8.28,3c-0.4,0-0.72,0.32-0.72,0.72V7H6.72V3.72 C6.72,3.32,6.4,3,6,3S5.28,3.32,5.28,3.72V7H4.44V3.72C4.44,3.32,4.12,3,3.72,3S3,3.32,3,3.72V9c0,1.1,0.9,2,2,2v9 c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-9c1.1,0,2-0.9,2-2V3.72C9,3.32,8.68,3,8.28,3z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 dining
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M11,10.3c0,0.93-0.64,1.71-1.5,1.93 v6.02C9.5,18.66,9.16,19,8.75,19h0C8.34,19,8,18.66,8,18.25v-6.02c-0.86-0.22-1.5-1-1.5-1.93V6.5C6.5,6.22,6.72,6,7,6 s0.5,0.22,0.5,0.5V9h0.75V6.5c0-0.28,0.22-0.5,0.5-0.5s0.5,0.22,0.5,0.5V9H10V6.5C10,6.22,10.23,6,10.5,6C10.78,6,11,6.22,11,6.5 V10.3z M15.58,12.59l-0.08,0.03v5.63c0,0.41-0.34,0.75-0.75,0.75h0C14.34,19,14,18.66,14,18.25v-5.63l-0.08-0.04 c-0.97-0.47-1.67-1.7-1.67-3.18c0-1.88,1.13-3.4,2.5-3.4c1.38,0,2.5,1.53,2.5,3.41C17.25,10.89,16.55,12.12,15.58,12.59z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 table-restaurant
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M21.96,9.73l-1.43-5C20.41,4.3,20.02,4,19.57,4H4.43C3.98,4,3.59,4.3,3.47,4.73l-1.43,5C1.86,10.36,2.34,11,3,11h2.2 l-1.05,7.88C4.07,19.47,4.53,20,5.13,20h0c0.5,0,0.92-0.37,0.98-0.86L6.67,15h10.67l0.55,4.14c0.07,0.49,0.49,0.86,0.98,0.86h0 c0.6,0,1.06-0.53,0.98-1.12L18.8,11H21C21.66,11,22.14,10.36,21.96,9.73z M6.93,13l0.27-2h9.6l0.27,2H6.93z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 garage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "1", :cy "13", :cx "15", :stroke nil, :fill nil})
    (helix.dom/circle
     {:r "1", :cy "13", :cx "9", :stroke nil, :fill nil})
    (helix.dom/polygon
     {:points "8.33,7.5 7.67,9.5 16.33,9.5 15.67,7.5",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M19,17.69 c0,0.45-0.35,0.81-0.78,0.81h-0.44c-0.44,0-0.78-0.36-0.78-0.81V16.5H7v1.19c0,0.45-0.35,0.81-0.78,0.81H5.78 C5.35,18.5,5,18.14,5,17.69v-6.5C5.82,8.72,6.34,7.16,6.56,6.5c0.05-0.16,0.12-0.29,0.19-0.4C6.77,6.08,6.78,6.06,6.8,6.04 C7.18,5.51,7.72,5.5,7.72,5.5h8.56c0,0,0.54,0.01,0.92,0.53c0.02,0.03,0.03,0.05,0.05,0.07c0.07,0.11,0.14,0.24,0.19,0.4 c0.22,0.66,0.74,2.23,1.56,4.69V17.69z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 blender
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.13,15.13l1.69-10.98C17.92,3.55,17.45,3,16.83,3H14v0c0-0.55-0.45-1-1-1h-2c-0.55,0-1,0.45-1,1v0H5C3.9,3,3,3.9,3,5v4 c0,1.1,0.9,2,2,2h2.23l0.64,4.13C6.74,16.05,6,17.43,6,19v1c0,1.1,0.9,2,2,2h8c1.1,0,2-0.9,2-2v-1 C18,17.43,17.26,16.05,16.13,15.13z M5,9V5h1.31l0.62,4H5z M12,19c-0.55,0-1-0.45-1-1s0.45-1,1-1s1,0.45,1,1S12.55,19,12,19z M14.29,14H9.72L8.33,5h7.34L14.29,14z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 camera-outdoor
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M18,13c0-0.55-0.45-1-1-1h-4c-0.55,0-1,0.45-1,1v4c0,0.55,0.45,1,1,1h4c0.55,0,1-0.45,1-1v-1l1.27,0.67 C19.6,16.85,20,16.61,20,16.23v-2.46c0-0.38-0.4-0.62-0.73-0.44L18,14V13z M10.8,3.9l-6,4.5C4.3,8.78,4,9.37,4,10v9 c0,1.1,0.9,2,2,2h13c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H6v-9l6-4.5l6,4.5l0,1h2v-1c0-0.63-0.3-1.22-0.8-1.6l-6-4.5 C12.49,3.37,11.51,3.37,10.8,3.9z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 yard
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M8,8.22c0-0.86,0.7-1.56,1.56-1.56 c0.33,0,0.64,0.1,0.89,0.28l-0.01-0.12c0-0.86,0.7-1.56,1.56-1.56s1.56,0.7,1.56,1.56l-0.01,0.12c0.26-0.18,0.56-0.28,0.89-0.28 c0.86,0,1.56,0.7,1.56,1.56c0,0.62-0.37,1.16-0.89,1.4C15.63,9.87,16,10.41,16,11.03c0,0.86-0.7,1.56-1.56,1.56 c-0.33,0-0.64-0.11-0.89-0.28l0.01,0.12c0,0.86-0.7,1.56-1.56,1.56s-1.56-0.7-1.56-1.56l0.01-0.12c-0.26,0.18-0.56,0.28-0.89,0.28 C8.7,12.59,8,11.89,8,11.03c0-0.62,0.37-1.16,0.89-1.4C8.37,9.38,8,8.84,8,8.22z M12,19c-2.83,0-5.21-1.97-5.84-4.61 c-0.18-0.74,0.49-1.4,1.23-1.23C10.03,13.79,12,16.17,12,19c0-2.83,1.97-5.21,4.61-5.84c0.74-0.18,1.4,0.49,1.23,1.23 C17.21,17.03,14.83,19,12,19z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "1.56", :cy "9.62", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 chair-alt
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,10c1.1,0,2-0.9,2-2V5c0-1.1-0.9-2-2-2H7C5.9,3,5,3.9,5,5v3c0,1.1,0.9,2,2,2h1v2H7c-1.1,0-2,0.9-2,2v6 c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2h10v2c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-6c0-1.1-0.9-2-2-2h-1v-2H17z M7,8V5h10v3 H7z M17,16H7v-2h10V16z M14,12h-4v-2h4V12z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 bedroom-parent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M16.5,12h-9c-0.55,0-1,0.45-1,1v1h11v-1C17.5,12.45,17.05,12,16.5,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8.5",
      :x "7.25",
      :width "4",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/rect
     {:y "8.5",
      :x "12.75",
      :width "4",
      :height "2",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M18.25,17L18.25,17 c-0.41,0-0.75-0.34-0.75-0.75V15.5h-11v0.75C6.5,16.66,6.16,17,5.75,17h0C5.34,17,5,16.66,5,16.25v-3.08 c0-0.66,0.25-1.26,0.65-1.72V9c0-1.1,0.9-2,2-2H11c0.37,0,0.72,0.12,1,0.32C12.28,7.12,12.63,7,13,7h3.35c1.1,0,2,0.9,2,2v2.45 c0.4,0.46,0.65,1.06,0.65,1.72v3.08C19,16.66,18.66,17,18.25,17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 indeterminate-check-box
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-3 10H8c-.55 0-1-.45-1-1s.45-1 1-1h8c.55 0 1 .45 1 1s-.45 1-1 1z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star-border
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.65 9.04l-4.84-.42-1.89-4.45c-.34-.81-1.5-.81-1.84 0L9.19 8.63l-4.83.41c-.88.07-1.24 1.17-.57 1.75l3.67 3.18-1.1 4.72c-.2.86.73 1.54 1.49 1.08l4.15-2.5 4.15 2.51c.76.46 1.69-.22 1.49-1.08l-1.1-4.73 3.67-3.18c.67-.58.32-1.68-.56-1.75zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 radio-button-unchecked
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 check-box-outline-blank
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M18 19H6c-.55 0-1-.45-1-1V6c0-.55.45-1 1-1h12c.55 0 1 .45 1 1v12c0 .55-.45 1-1 1zm1-16H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star-border-purple500
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,8.89L12.94,12h2.82l-2.27,1.62l0.93,3.01L12,14.79l-2.42,1.84l0.93-3.01L8.24,12h2.82L12,8.89 M9.58,10H5.12 c-0.97,0-1.37,1.25-0.58,1.81l3.64,2.6l-1.43,4.61c-0.29,0.93,0.79,1.68,1.56,1.09L12,17.31l3.69,2.81 c0.77,0.59,1.85-0.16,1.56-1.09l-1.43-4.61l3.64-2.6c0.79-0.57,0.39-1.81-0.58-1.81h-4.46l-1.47-4.84c-0.29-0.95-1.63-0.95-1.91,0 L9.58,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 star-half
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.65 9.04l-4.84-.42-1.89-4.45c-.34-.81-1.5-.81-1.84 0L9.19 8.63l-4.83.41c-.88.07-1.24 1.17-.57 1.75l3.67 3.18-1.1 4.72c-.2.86.73 1.54 1.49 1.08l4.15-2.5 4.15 2.51c.76.46 1.69-.22 1.49-1.08l-1.1-4.73 3.67-3.18c.67-.58.32-1.68-.56-1.75zM12 15.4V6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 radio-button-checked
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 18c-4.42 0-8-3.58-8-8s3.58-8 8-8 8 3.58 8 8-3.58 8-8 8z",
    :stroke nil,
    :fill nil})
  (helix.dom/circle
   {:r "5", :cy "12", :cx "12", :stroke nil, :fill nil})))


(helix.core/defnc
 toggle-on
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h10c2.76 0 5-2.24 5-5s-2.24-5-5-5zm0 8c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 toggle-off
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M17 7H7c-2.76 0-5 2.24-5 5s2.24 5 5 5h10c2.76 0 5-2.24 5-5s-2.24-5-5-5zM7 15c-1.66 0-3-1.34-3-3s1.34-3 3-3 3 1.34 3 3-1.34 3-3 3z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
   (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "m12 17.27 4.15 2.51c.76.46 1.69-.22 1.49-1.08l-1.1-4.72 3.67-3.18c.67-.58.31-1.68-.57-1.75l-4.83-.41-1.89-4.46c-.34-.81-1.5-.81-1.84 0L9.19 8.63l-4.83.41c-.88.07-1.24 1.17-.57 1.75l3.67 3.18-1.1 4.72c-.2.86.73 1.54 1.49 1.08l4.15-2.5z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 star-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19.65 9.04l-4.84-.42-1.89-4.45c-.34-.81-1.5-.81-1.84 0L9.19 8.63l-4.83.41c-.88.07-1.24 1.17-.57 1.75l3.67 3.18-1.1 4.72c-.2.86.73 1.54 1.49 1.08l4.15-2.5 4.15 2.51c.76.46 1.69-.22 1.49-1.08l-1.1-4.73 3.67-3.18c.67-.58.32-1.68-.56-1.75zM12 15.4l-3.76 2.27 1-4.28-3.32-2.88 4.38-.38L12 6.1l1.71 4.04 4.38.38-3.32 2.88 1 4.28L12 15.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 check-box
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M19 3H5c-1.1 0-2 .9-2 2v14c0 1.1.9 2 2 2h14c1.1 0 2-.9 2-2V5c0-1.1-.9-2-2-2zm-8.29 13.29c-.39.39-1.02.39-1.41 0L5.71 12.7c-.39-.39-.39-1.02 0-1.41.39-.39 1.02-.39 1.41 0L10 14.17l6.88-6.88c.39-.39 1.02-.39 1.41 0 .39.39.39 1.02 0 1.41l-7.58 7.59z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 star-purple500
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:fill "none", :d "M0,0h24v24H0V0z", :stroke nil})))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12,8.89L12.94,12h2.82l-2.27,1.62l0.93,3.01L12,14.79l-2.42,1.84l0.93-3.01L8.24,12h2.82L12,8.89 M9.58,10H5.12 c-0.97,0-1.37,1.25-0.58,1.81l3.64,2.6l-1.43,4.61c-0.29,0.93,0.79,1.68,1.56,1.09L12,17.31l3.69,2.81 c0.77,0.59,1.85-0.16,1.56-1.09l-1.43-4.61l3.64-2.6c0.79-0.57,0.39-1.81-0.58-1.81h-4.46l-1.47-4.84c-0.29-0.95-1.63-0.95-1.91,0 L9.58,10z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sign-language
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M12.49,13l-0.93-1.86c-0.37-0.74-0.07-1.64,0.67-2.01l0,0c0.16-0.08,0.34-0.05,0.47,0.07l5.53,5.26 c0.5,0.47,0.78,1.13,0.78,1.81v5.23c0,1.38-1.12,2.5-2.5,2.5h-11c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1H10v-1H4c-0.55,0-1-0.45-1-1 c0-0.55,0.45-1,1-1h6v-1H3c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h7v-1H4.5c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1H12.49z M11.78,7.12c-0.84,0.4-1.17,0.62-1.63,1.19l-2.7-2.85c-0.38-0.4-0.36-1.03,0.04-1.41c0.4-0.38,1.03-0.36,1.41,0.04L11.78,7.12z M9.64,9.21C9.41,9.76,9.35,10.45,9.44,11H8.58L6.31,8.61C5.93,8.21,5.94,7.58,6.35,7.2c0.4-0.38,1.03-0.36,1.41,0.04L9.64,9.21z M20.33,13.91l0.88-0.83c0.5-0.47,0.79-1.13,0.79-1.82V3.64c0-0.17-0.11-0.33-0.27-0.39l0,0c-0.78-0.28-1.64,0.12-1.92,0.9 L19.1,6.11l-5.5-5.8c-0.38-0.4-1.01-0.42-1.41-0.04c-0.4,0.38-0.42,1.01-0.04,1.41l3.79,3.99l-0.73,0.69l-4.82-5.08 c-0.38-0.4-1.01-0.42-1.41-0.04c-0.4,0.38-0.42,1.01-0.04,1.41l3.78,3.98L15.38,9l3.61,3.43l0.61,0.58 C19.89,13.28,20.13,13.58,20.33,13.91z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-cricket
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M15.05,12.81L6.56,4.32c-0.39-0.39-1.02-0.39-1.41,0L2.32,7.15c-0.39,0.39-0.39,1.02,0,1.41l8.49,8.49 c0.39,0.39,1.02,0.39,1.41,0l2.83-2.83C15.44,13.83,15.44,13.2,15.05,12.81z",
       :stroke nil,
       :fill nil})
     (helix.dom/path
      {:d
       "M14.34,17.76l3.53,3.53c0.39,0.39,1.03,0.39,1.42,0l0,0c0.39-0.39,0.39-1.03,0-1.42l-3.53-3.53L14.34,17.76z",
       :stroke nil,
       :fill nil}))
    (helix.dom/circle
     {:r "3.5", :cy "5.5", :cx "18.5", :stroke nil, :fill nil})))))


(helix.core/defnc
 thumb-down-alt
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path
   {:opacity ".87", :fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M10.88 21.94l5.53-5.54c.37-.37.58-.88.58-1.41V5c0-1.1-.9-2-2-2H6c-.8 0-1.52.48-1.83 1.21L.91 11.82C.06 13.8 1.51 16 3.66 16h5.65l-.95 4.58c-.1.5.05 1.01.41 1.37.59.58 1.53.58 2.11-.01zM21 3c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2s2-.9 2-2V5c0-1.1-.9-2-2-2z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-tennis
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M19.52,2.49c-2.34-2.34-6.62-1.87-9.55,1.06c-1.6,1.6-2.52,3.87-2.54,5.46c-0.02,1.58,0.26,3.89-1.35,5.5l-3.54,3.53 c-0.39,0.39-0.39,1.02,0,1.42l0,0c0.39,0.39,1.02,0.39,1.42,0l3.53-3.54c1.61-1.61,3.92-1.33,5.5-1.35s3.86-0.94,5.46-2.54 C21.38,9.11,21.86,4.83,19.52,2.49z M10.32,11.68c-1.53-1.53-1.05-4.61,1.06-6.72s5.18-2.59,6.72-1.06 c1.53,1.53,1.05,4.61-1.06,6.72S11.86,13.21,10.32,11.68z",
     :stroke nil,
     :fill nil})
   (helix.dom/path
    {:d
     "M18,17c0.53,0,1.04,0.21,1.41,0.59c0.78,0.78,0.78,2.05,0,2.83C19.04,20.79,18.53,21,18,21s-1.04-0.21-1.41-0.59 c-0.78-0.78-0.78-2.05,0-2.83C16.96,17.21,17.47,17,18,17 M18,15c-1.02,0-2.05,0.39-2.83,1.17c-1.56,1.56-1.56,4.09,0,5.66 C15.95,22.61,16.98,23,18,23s2.05-0.39,2.83-1.17c1.56-1.56,1.56-4.09,0-5.66C20.05,15.39,19.02,15,18,15L18,15z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 man
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,7h-4C8.9,7,8,7.9,8,9v5c0,0.55,0.45,1,1,1h1v6c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1v-6h1c0.55,0,1-0.45,1-1V9 C16,7.9,15.1,7,14,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 recycling
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.2 7.41c-.23-.14-.31-.45-.17-.68L7.2 4.78l1.03-1.71c.39-.65 1.33-.65 1.72 0l1.48 2.46-1.23 2.06-.72 1.2c-.16.23-.47.31-.71.17L6.2 7.41zm15.52 5.56-1.34-2.24c-.14-.23-.44-.31-.68-.18l-2.6 1.5c-.24.14-.32.45-.18.69L18.87 16h1.09c.61 0 1.2-.26 1.59-.73.3-.37.45-.82.45-1.27 0-.36-.1-.71-.28-1.03zM16 21h1.5c.76 0 1.45-.43 1.79-1.11L20.74 17H16v-.79c0-.45-.54-.67-.85-.35l-2.79 2.79c-.2.2-.2.51 0 .71l2.79 2.79c.31.31.85.09.85-.35V21zm-6.5-4H5.7l-.84 1.41c-.3.5-.32 1.12-.06 1.65.28.57.87.94 1.52.94H9.5c.28 0 .5-.22.5-.5v-3c0-.28-.22-.5-.5-.5zm-3.38-2.65.7.42c.38.23.85-.12.74-.55l-.96-3.84c-.06-.26-.33-.43-.6-.36l-3.83.96c-.43.11-.52.68-.14.91l.66.4-.41.69c-.35.59-.38 1.31-.07 1.92l1.63 3.26 2.28-3.81zm10.9-9.21-1.3-2.17C15.35 2.37 14.7 2 14 2h-3.53l3.12 5.2-.69.41c-.38.23-.3.81.14.91l3.83.96c.27.07.54-.1.61-.36l.96-3.83c.11-.43-.36-.78-.74-.55l-.68.4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 sports-rugby
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M20.49,3.51c-0.56-0.56-2.15-0.97-4.16-0.97c-3.08,0-7.15,0.96-9.98,3.79C1.66,11.03,2.1,19.07,3.51,20.49 c0.56,0.56,2.15,0.97,4.16,0.97c3.08,0,7.15-0.96,9.98-3.79C22.34,12.97,21.9,4.93,20.49,3.51z M7.76,7.76 c2.64-2.64,6.35-3.12,8.03-3.19c-2.05,0.94-4.46,2.45-6.61,4.61c-2.16,2.16-3.67,4.58-4.61,6.63C4.66,13.33,5.44,10.07,7.76,7.76z M16.24,16.24c-2.64,2.64-6.35,3.12-8.03,3.19c2.05-0.94,4.46-2.45,6.61-4.61c2.16-2.16,3.67-4.58,4.62-6.63 C19.34,10.67,18.56,13.93,16.24,16.24z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 water-drop
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12.66,2.58c-0.38-0.33-0.95-0.33-1.33,0C6.45,6.88,4,10.62,4,13.8c0,4.98,3.8,8.2,8,8.2s8-3.22,8-8.2 C20,10.62,17.55,6.88,12.66,2.58z M7.83,14c0.37,0,0.67,0.26,0.74,0.62c0.41,2.22,2.28,2.98,3.64,2.87 c0.43-0.02,0.79,0.32,0.79,0.75c0,0.4-0.32,0.73-0.72,0.75c-2.13,0.13-4.62-1.09-5.19-4.12C7.01,14.42,7.37,14,7.83,14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 luggage
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M17,6h-2V3c0-0.55-0.45-1-1-1h-4C9.45,2,9,2.45,9,3v3H7C5.9,6,5,6.9,5,8v11c0,1.1,0.9,2,2,2c0,0.55,0.45,1,1,1 c0.55,0,1-0.45,1-1h6c0,0.55,0.45,1,1,1c0.55,0,1-0.45,1-1c1.1,0,2-0.9,2-2V8C19,6.9,18.1,6,17,6z M8.75,18L8.75,18 C8.34,18,8,17.66,8,17.25v-7.5C8,9.34,8.34,9,8.75,9h0C9.16,9,9.5,9.34,9.5,9.75v7.5C9.5,17.66,9.16,18,8.75,18z M12,18L12,18 c-0.41,0-0.75-0.34-0.75-0.75v-7.5C11.25,9.34,11.59,9,12,9h0c0.41,0,0.75,0.34,0.75,0.75v7.5C12.75,17.66,12.41,18,12,18z M13.5,6 h-3V3.5h3V6z M15.25,18L15.25,18c-0.41,0-0.75-0.34-0.75-0.75v-7.5C14.5,9.34,14.84,9,15.25,9h0C15.66,9,16,9.34,16,9.75v7.5 C16,17.66,15.66,18,15.25,18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sick
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M23,7c0,1.1-0.9,2-2,2s-2-0.9-2-2c0-0.78,0.99-2.44,1.58-3.36c0.2-0.31,0.64-0.31,0.84,0C22.01,4.56,23,6.22,23,7z M21.86,10.38C21.94,10.91,22,11.45,22,12c0,5.52-4.48,10-10.01,10C6.47,22,2,17.52,2,12C2,6.48,6.47,2,11.99,2 c2.45,0,4.69,0.88,6.43,2.34C17.91,5.29,17.5,6.27,17.5,7c0,1.93,1.57,3.5,3.5,3.5C21.3,10.5,21.58,10.45,21.86,10.38z M14.03,10.03 l1.06,1.06c0.29,0.29,0.77,0.29,1.06,0c0.29-0.29,0.29-0.77,0-1.06L15.62,9.5l0.53-0.53c0.29-0.29,0.29-0.77,0-1.06 s-0.77-0.29-1.06,0l-1.06,1.06C13.74,9.26,13.74,9.74,14.03,10.03z M8.38,9.5l-0.53,0.53c-0.29,0.29-0.29,0.77,0,1.06 c0.29,0.29,0.77,0.29,1.06,0l1.06-1.06c0.29-0.29,0.29-0.77,0-1.06L8.91,7.91c-0.29-0.29-0.77-0.29-1.06,0s-0.29,0.77,0,1.06 L8.38,9.5z M16.47,15.8c-1-1.39-2.62-2.3-4.47-2.3c-0.87,0-1.69,0.2-2.43,0.56L5.99,12c0-0.52-0.26-1.02-0.74-1.29 c-0.8-0.46-1.84-0.11-2.17,0.8c-0.21,0.57-0.03,1.25,0.44,1.64c0.52,0.44,1.2,0.45,1.72,0.16l2.97,1.72 c-0.25,0.24-0.48,0.5-0.68,0.78C7.17,16.3,7.53,17,8.15,17c0.23,0,0.46-0.1,0.6-0.3C9.47,15.68,10.65,15,12,15s2.53,0.68,3.25,1.7 c0.14,0.19,0.36,0.3,0.6,0.3h0C16.47,17,16.83,16.3,16.47,15.8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 history-edu
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M9,5v0.38c-0.83-0.33-1.72-0.5-2.61-0.5c-1.42,0-2.84,0.43-4.05,1.29C1.83,6.53,1.77,7.26,2.21,7.7l2.57,2.57h1.11v1.11 c0.86,0.86,1.98,1.31,3.11,1.36V15H7c-0.55,0-1,0.45-1,1v2c0,1.1,0.9,2,2,2h10c1.66,0,3-1.34,3-3V5c0-0.55-0.45-1-1-1H10 C9.45,4,9,4.45,9,5z M7.89,10.41V8.26H5.61L4.57,7.22C5.14,7,5.76,6.88,6.39,6.88c1.34,0,2.59,0.52,3.54,1.46l1.41,1.41l-0.2,0.2 c-0.51,0.51-1.19,0.8-1.92,0.8C8.75,10.75,8.29,10.63,7.89,10.41z M19,17c0,0.55-0.45,1-1,1s-1-0.45-1-1v-1c0-0.55-0.45-1-1-1h-5 v-2.59c0.57-0.23,1.1-0.57,1.56-1.03l0.2-0.2L15.59,14H17v-1.41l-6-5.97V6h8V17z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-handball
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14.27,6C13.72,6.95,14.05,8.18,15,8.73c0.95,0.55,2.18,0.22,2.73-0.73c0.55-0.95,0.22-2.18-0.73-2.73 C16.05,4.72,14.82,5.05,14.27,6z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M15.84,10.41c0,0-1.63-0.94-2.6-1.5c-2.13-1.24-3.01-3.83-2.18-6.07c0.17-0.46-0.01-0.97-0.43-1.21 C10.1,1.33,9.41,1.56,9.2,2.13C8.25,4.64,8.85,7.48,10.66,9.4l-4.65,8.05c-0.28,0.48-0.11,1.09,0.37,1.37 c0.48,0.28,1.09,0.11,1.37-0.37l1-1.73l1.73,1l-2.5,4.33c-0.28,0.48-0.11,1.09,0.37,1.37c0.48,0.28,1.09,0.11,1.37-0.37 l5.79-10.02c0.98,1.34,1.26,3.12,0.66,4.72c-0.17,0.45,0.02,0.96,0.43,1.2c0.53,0.31,1.22,0.08,1.44-0.5 C19.01,15.83,18.45,12.61,15.84,10.41z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.75,3.8c0.72,0.41,1.63,0.17,2.05-0.55c0.41-0.72,0.17-1.63-0.55-2.05c-0.72-0.41-1.63-0.17-2.05,0.55 C11.79,2.47,12.03,3.39,12.75,3.8z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 surfing
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M17,1.5c-1.1,0-2,0.9-2,2s0.9,2,2,2s2-0.9,2-2S18.1,1.5,17,1.5z M22,22c0,0.55-0.45,1-1,1h0c-1.03,0-2.05-0.25-3-0.75 c-1.92,1.02-4.18,1-6.09-0.05c-1.79,0.87-3.92,0.98-5.58-0.14C5.3,22.69,4.15,23,3,23h0c-0.55,0-1-0.45-1-1c0-0.55,0.45-1,1-1h0 c0.87,0,1.73-0.24,2.53-0.7c0.29-0.16,0.65-0.17,0.94,0c1.59,0.9,3.48,0.9,5.06,0c0.29-0.16,0.65-0.16,0.94,0 c1.59,0.9,3.48,0.9,5.06,0c0.29-0.16,0.65-0.16,0.94,0C19.27,20.76,20.13,21,21,21h0C21.55,21,22,21.45,22,22z M8.04,18.86 C8.35,18.95,8.67,19,9,19c0.9,0,1.72-0.37,2.39-0.91c0.35-0.28,0.87-0.28,1.22,0C13.28,18.63,14.1,19,15,19s1.72-0.37,2.39-0.91 c0.03-0.03,0.07-0.05,0.11-0.07c-0.46-0.39-0.97-0.79-1.5-1.17v-2.87c0-0.61-0.28-1.19-0.77-1.57L12.17,10l2.25-1.52 c1.03,1.79,2.82,3.08,4.93,3.43c0.6,0.1,1.14-0.39,1.14-1c0-0.49-0.36-0.9-0.84-0.98c-1.5-0.25-2.78-1.18-3.51-2.46l-0.88-1.55 c-0.29-0.52-0.77-0.8-1.22-0.89L9.31,4.15c-0.52-0.1-1.06,0.02-1.5,0.32L5.82,5.83C5.37,6.15,5.25,6.77,5.56,7.22 C5.88,7.68,6.5,7.8,6.96,7.49l1.99-1.37l2,0.37L8.8,7.94C8.2,8.35,7.91,9.06,8.03,9.73l0.52,3.1C7.13,12.31,5.83,12,4.85,12 C4.01,12,3,12.25,3,13.28C3,14.72,5.19,16.9,8.04,18.86z M14,14v1.5c-0.78-0.48-2.34-1.33-3.26-1.75L10.3,11.1L14,14z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 fireplace
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M20,2H4C2.9,2,2,2.9,2,4v16c0,1.1,0.9,2,2,2h16c1.1,0,2-0.9,2-2V4C22,2.9,21.1,2,20,2z M20,19c0,0.55-0.45,1-1,1h-1v-1 c0-0.55-0.45-1-1-1h-1.15c0.71-0.85,1.15-1.89,1.15-3c0-1.89-1.09-2.84-1.85-3.36c-1.86-1.27-2.23-2.78-2.25-3.72 c-0.01-0.4-0.43-0.63-0.77-0.43c-5.8,3.43-5.15,7-5.13,7.51c0.03,0.96,0.49,2.07,1.24,3H7c-0.55,0-1,0.45-1,1v1H5 c-0.55,0-1-0.45-1-1V5c0-0.55,0.45-1,1-1h14c0.55,0,1,0.45,1,1V19z M13.2,13.74c-0.08-0.46-0.07-0.85,0.08-1.28 c0.54,1.21,2.15,1.64,1.98,3.18c-0.19,1.69-2.11,2.37-3.39,1.32c0.76-0.24,1.4-1.04,1.53-1.63C13.52,14.78,13.29,14.29,13.2,13.74z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 south-america
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M12,2C6.48,2,2,6.48,2,12c0,5.52,4.48,10,10,10s10-4.48,10-10C22,6.48,17.52,2,12,2z M4,12c0-1.95,0.7-3.74,1.87-5.13L9,10 v1c0,1.1,0.9,2,2,2v5.59c0,0.27,0.11,0.52,0.29,0.71L12,20C7.58,20,4,16.42,4,12z M13,19.94V18l3.75-5.62 c0.16-0.25,0.25-0.54,0.25-0.83V10.5c0-0.55-0.45-1-1-1h-1.5l-1.4-1.75C12.72,7.28,12.15,7,11.54,7H8V5.07C9.18,4.39,10.54,4,12,4 c4.41,0,8,3.59,8,8C20,16.07,16.94,19.44,13,19.94z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 blind
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "3.5", :cx "11.41", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M12.04,7.12c-0.17-0.35-0.44-0.65-0.8-0.85C10.63,5.91,9.9,5.93,9.31,6.24l0-0.01L4.92,8.73 C4.3,9.08,3.91,9.74,3.91,10.46V13c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-2.54l1.5-0.85c-0.32,1.1-0.5,2.24-0.5,3.39v5.33 l-2,2.67c-0.33,0.44-0.24,1.07,0.2,1.4l0,0c0.44,0.33,1.07,0.24,1.4-0.2l2.04-2.72c0.23-0.31,0.37-0.69,0.4-1.08l0.18-2.94 L10.91,18v4c0,0.55,0.45,1,1,1h0c0.55,0,1-0.45,1-1v-4.87c0-0.41-0.13-0.81-0.36-1.15l-1.6-2.29c0,0,0,0,0-0.01 c-0.11-1.16,0.07-2.32,0.46-3.4c0.75,1.14,1.88,1.98,3.2,2.41l5.7,9.87c0.14,0.24,0.44,0.32,0.68,0.18l0,0 c0.24-0.14,0.32-0.44,0.18-0.68L15.92,13h0c0.54,0,0.98-0.44,0.98-0.98v-0.05c0-0.5-0.37-0.94-0.87-0.99 c-0.95-0.1-2.37-0.52-3.21-2.18",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 sports-hockey
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d "M2,17v3l2,0v-4H3C2.45,16,2,16.45,2,17z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,16H5v4l4.69-0.01c0.38,0,0.72-0.21,0.89-0.55l0.87-1.9l-1.59-3.48L9,16z",
      :stroke nil,
      :fill nil})
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M21.71,16.29C21.53,16.11,21.28,16,21,16h-1v4l2,0v-3C22,16.72,21.89,16.47,21.71,16.29z",
       :stroke nil,
       :fill nil}))
    (helix.dom/path
     {:d
      "M13.6,12.84L17.65,4H14.3l-1.76,3.97l-0.49,1.1L12,9.21L9.7,4H6.35l4.05,8.84l1.52,3.32L12,16.34l1.42,3.1 c0.17,0.34,0.51,0.55,0.89,0.55L19,20v-4h-4L13.6,12.84z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 piano
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,3H5C3.9,3,3,3.9,3,5v14c0,1.1,0.9,2,2,2h14c1.1,0,2-0.9,2-2V5C21,3.9,20.1,3,19,3z M14,14.5h0.25V19h-4.5v-4.5H10 c0.55,0,1-0.45,1-1V5h2v8.5C13,14.05,13.45,14.5,14,14.5z M5,5h2v8.5c0,0.55,0.45,1,1,1h0.25V19H5V5z M19,19h-3.25v-4.5H16 c0.55,0,1-0.45,1-1V5h2V19z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 woman-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/g
     nil
     (helix.dom/path
      {:d
       "M13.94,8.31c-0.38-0.96-1.42-1.52-2.48-1.24c-0.66,0.17-1.18,0.7-1.43,1.34l-2.48,6.22C7.28,15.29,7.77,16,8.47,16h2.03 v5c0,0.55,0.45,1,1,1h1c0.55,0,1-0.45,1-1v-5h2.03c0.71,0,1.19-0.71,0.93-1.37L13.94,8.31z",
       :stroke nil,
       :fill nil})
     (helix.dom/circle
      {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil}))))))


(helix.core/defnc
 group-remove
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M18,10c0-0.55,0.45-1,1-1h4c0.55,0,1,0.45,1,1s-0.45,1-1,1h-4C18.45,11,18,10.55,18,10z M8,4C5.79,4,4,5.79,4,8s1.79,4,4,4 s4-1.79,4-4S10.21,4,8,4z M8,13c-2.67,0-8,1.34-8,4v3h16v-3C16,14.34,10.67,13,8,13z M12.51,4.05C13.43,5.11,14,6.49,14,8 s-0.57,2.89-1.49,3.95C14.47,11.7,16,10.04,16,8S14.47,4.3,12.51,4.05z M16.53,13.83C17.42,14.66,18,15.7,18,17v3h2v-3 C20,15.55,18.41,14.49,16.53,13.83z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 person-outline
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M12 5.9c1.16 0 2.1.94 2.1 2.1s-.94 2.1-2.1 2.1S9.9 9.16 9.9 8s.94-2.1 2.1-2.1m0 9c2.97 0 6.1 1.46 6.1 2.1v1.1H5.9V17c0-.64 3.13-2.1 6.1-2.1M12 4C9.79 4 8 5.79 8 8s1.79 4 4 4 4-1.79 4-4-1.79-4-4-4zm0 9c-2.67 0-8 1.34-8 4v2c0 .55.45 1 1 1h14c.55 0 1-.45 1-1v-2c0-2.66-5.33-4-8-4z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 public-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/path
    {:d
     "M11,8.17L6.49,3.66C8.07,2.61,9.96,2,12,2c5.52,0,10,4.48,10,10c0,2.04-0.61,3.93-1.66,5.51l-1.46-1.46 C19.59,14.87,20,13.48,20,12c0-3.35-2.07-6.22-5-7.41V5c0,1.1-0.9,2-2,2h-2V8.17z M20.49,21.9L20.49,21.9 c-0.39,0.39-1.02,0.39-1.41,0l-1.56-1.56c-2.07,1.37-4.68,2-7.45,1.48c-3.95-0.75-7.13-3.92-7.88-7.88 c-0.52-2.77,0.1-5.38,1.48-7.45L2.1,4.93c-0.39-0.39-0.39-1.02,0-1.41l0,0c0.39-0.39,1.02-0.39,1.41,0l16.97,16.97 C20.88,20.88,20.88,21.51,20.49,21.9z M11,18c-1.1,0-2-0.9-2-2v-1l-4.79-4.79C4.08,10.79,4,11.38,4,12c0,4.08,3.05,7.44,7,7.93V18z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 plus-one
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M9 8c-.55 0-1 .45-1 1v3H5c-.55 0-1 .45-1 1s.45 1 1 1h3v3c0 .55.45 1 1 1s1-.45 1-1v-3h3c.55 0 1-.45 1-1s-.45-1-1-1h-3V9c0-.55-.45-1-1-1zm5.5-1.21c0 .57.52 1 1.08.89L17 7.4V17c0 .55.45 1 1 1s1-.45 1-1V6.27c0-.65-.6-1.12-1.23-.97l-2.57.62c-.41.09-.7.46-.7.87z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 tsunami
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M18.16,17.98c-2.76,1.76-4.67,0.77-5.61,0.08c-0.34-0.24-0.78-0.23-1.12,0.01c-0.97,0.7-2.83,1.65-5.55-0.06 C5.55,17.8,5.13,17.78,4.81,18c-0.91,0.61-1.53,0.85-2,0.94C2.34,19.03,2,19.44,2,19.91v0c0,0.6,0.54,1.09,1.13,0.98 c0.77-0.14,1.51-0.42,2.2-0.83c2.04,1.21,4.63,1.21,6.67,0c2.06,1.22,4.61,1.22,6.67,0c0.69,0.41,1.44,0.69,2.21,0.83 c0.59,0.11,1.13-0.38,1.13-0.98v-0.01c0-0.47-0.33-0.88-0.8-0.97c-0.49-0.1-1.11-0.34-2.02-0.94 C18.88,17.79,18.47,17.78,18.16,17.98z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M19.33,12H21c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1l-1.61,0c-1.86,0-3.4-1.5-3.39-3.36c0-0.37,0.06-0.7,0.16-1.05 C16.53,4.3,15.6,3.03,14.27,3C14.18,3,14.09,3,14,3C7.36,3,2.15,8.03,2.01,14.5l0,0.03c-0.04,1.13,1.07,1.98,2.14,1.6 c0.4-0.14,0.78-0.32,1.15-0.54c2.08,1.2,4.64,1.22,6.7-0.02c2.06,1.22,4.61,1.22,6.67,0c0.68,0.41,1.42,0.68,2.18,0.82 c0.6,0.11,1.16-0.36,1.16-0.98v-0.01c0-0.46-0.32-0.88-0.78-0.97c-0.49-0.09-1.12-0.33-2.03-0.94c-0.31-0.21-0.73-0.22-1.05-0.01 c-2.73,1.74-4.63,0.77-5.58,0.09c-0.35-0.25-0.81-0.26-1.16-0.01c-0.15,0.11-0.09,0.06-0.32,0.2C10.39,12.82,10,11.7,10,10.5 c0-2.58,1.77-4.74,4.21-5.33C14.08,5.68,14,6.19,14,6.67C14,9.61,16.39,12,19.33,12z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 person-off
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M8.65,5.82C9.36,4.72,10.6,4,12,4c2.21,0,4,1.79,4,4c0,1.4-0.72,2.64-1.82,3.35L8.65,5.82z M20,17.17 c-0.02-1.1-0.63-2.11-1.61-2.62c-0.54-0.28-1.13-0.54-1.77-0.76L20,17.17z M20.49,20.49L3.51,3.51c-0.39-0.39-1.02-0.39-1.41,0l0,0 c-0.39,0.39-0.39,1.02,0,1.41l8.18,8.18c-1.82,0.23-3.41,0.8-4.7,1.46C4.6,15.08,4,16.11,4,17.22L4,20h13.17l1.9,1.9 c0.39,0.39,1.02,0.39,1.41,0l0,0C20.88,21.51,20.88,20.88,20.49,20.49z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 sports-volleyball
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M6,4.01C3.58,5.84,2,8.73,2,12c0,1.46,0.32,2.85,0.89,4.11L6,14.31V4.01z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M11,11.42V2.05C9.94,2.16,8.93,2.43,8,2.84v10.32L11,11.42z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12,13.15l-8.11,4.68c0.61,0.84,1.34,1.59,2.18,2.2L15,14.89L12,13.15z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M13,7.96v3.46l8.11,4.68c0.42-0.93,0.7-1.93,0.82-2.98L13,7.96z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M8.07,21.2C9.28,21.71,10.6,22,12,22c3.34,0,6.29-1.65,8.11-4.16L17,16.04L8.07,21.2z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M21.92,10.81c-0.55-4.63-4.26-8.3-8.92-8.76v3.6L21.92,10.81z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 domain-add
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M6,19H4v-2h2V19z M6,15H4v-2h2V15z M6,11H4V9h2V11z M6,7H4V5h2V7z M10,19H8v-2h2V19z M10,15H8v-2h2V15z M10,11H8V9h2V11z M10,7H8V5h2V7z M16,19h-4v-2h2v-2h-2v-2h2v-2h-2V9h8v6h2V8c0-0.55-0.45-1-1-1h-9V4c0-0.55-0.45-1-1-1H3C2.45,3,2,3.45,2,4v16 c0,0.55,0.45,1,1,1h13V19z M18,11h-2v2h2V11z M18,15h-2v2h2V15z M24,20c0,0.55-0.45,1-1,1h-1v1c0,0.55-0.45,1-1,1s-1-0.45-1-1v-1 h-1c-0.55,0-1-0.45-1-1s0.45-1,1-1h1v-1c0-0.55,0.45-1,1-1c0.55,0,1,0.45,1,1v1h1C23.55,19,24,19.45,24,20z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 reduce-capacity
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M16,4c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S16,5.1,16,4z M20.78,7.58C19.93,7.21,18.99,7,18,7c-0.67,0-1.31,0.1-1.92,0.28 C16.66,7.83,17,8.6,17,9.43V10h5V9.43C22,8.62,21.52,7.9,20.78,7.58z M6,6c1.1,0,2-0.9,2-2S7.1,2,6,2S4,2.9,4,4S4.9,6,6,6z M7.92,7.28C7.31,7.1,6.67,7,6,7C5.01,7,4.07,7.21,3.22,7.58C2.48,7.9,2,8.62,2,9.43V10h5V9.43C7,8.6,7.34,7.83,7.92,7.28z M10,4 c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S10,5.1,10,4z M16,10H8V9.43C8,8.62,8.48,7.9,9.22,7.58C10.07,7.21,11.01,7,12,7 c0.99,0,1.93,0.21,2.78,0.58C15.52,7.9,16,8.62,16,9.43V10z M15,16c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S15,17.1,15,16z M21,22h-8 v-0.57c0-0.81,0.48-1.53,1.22-1.85C15.07,19.21,16.01,19,17,19c0.99,0,1.93,0.21,2.78,0.58C20.52,19.9,21,20.62,21,21.43V22z M5,16 c0-1.1,0.9-2,2-2s2,0.9,2,2s-0.9,2-2,2S5,17.1,5,16z M11,22H3v-0.57c0-0.81,0.48-1.53,1.22-1.85C5.07,19.21,6.01,19,7,19 c0.99,0,1.93,0.21,2.78,0.58C10.52,19.9,11,20.62,11,21.43V22z M13.79,13h-1.04v-1.25c0-0.41-0.34-0.75-0.75-0.75 s-0.75,0.34-0.75,0.75V13h-1.04c-0.45,0-0.67,0.54-0.35,0.85l1.79,1.79c0.2,0.2,0.51,0.2,0.71,0l1.79-1.79 C14.46,13.54,14.24,13,13.79,13z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 man-2
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,7h-4C8.9,7,8,7.9,8,9v5c0,0.55,0.45,1,1,1h1.5v5.5c0,0.83,0.67,1.5,1.5,1.5h0c0.83,0,1.5-0.67,1.5-1.5V15H15 c0.55,0,1-0.45,1-1V9C16,7.9,15.1,7,14,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 scale
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M16,21c0,0.55,0.45,1,1,1l3.43,0c0.87,0,1.58-0.75,1.5-1.62C21.34,14.18,17.4,11.68,14,11V8c3.31-0.42,6.03-1.86,7.27-3.73 C21.92,3.3,21.15,2,19.98,2H4.02C2.85,2,2.08,3.3,2.73,4.27C3.97,6.14,6.69,7.58,10,8l0,3c-3.4,0.68-7.34,3.18-7.93,9.38 C1.99,21.25,2.7,22,3.57,22L7,22c0.55,0,1-0.45,1-1c0-0.55-0.45-1-1-1H4.13c0.93-6.83,6.65-7.2,7.87-7.2s6.94,0.37,7.87,7.2H17 C16.45,20,16,20.45,16,21z M11.5,21.94c-0.7-0.17-1.27-0.74-1.44-1.44c-0.18-0.74,0.06-1.44,0.53-1.91 c0.55-0.55,2.91-1.57,4.33-2.15c0.41-0.17,0.82,0.24,0.65,0.65c-0.58,1.42-1.6,3.78-2.15,4.33C12.95,21.88,12.25,22.12,11.5,21.94z",
     :stroke nil,
     :fill nil}))))


(helix.core/defnc
 diversity-1
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/circle
     {:r "2", :cy "14", :cx "4", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M1.22,17.58C0.48,17.9,0,18.62,0,19.43L0,20c0,0.55,0.45,1,1,1l3.5,0v-1.61c0-0.83,0.23-1.61,0.63-2.29 C4.76,17.04,4.39,17,4,17C3.01,17,2.07,17.21,1.22,17.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "14", :cx "20", :stroke nil, :fill nil})
    (helix.dom/path
     {:d
      "M22.78,17.58C21.93,17.21,20.99,17,20,17c-0.39,0-0.76,0.04-1.13,0.1c0.4,0.68,0.63,1.46,0.63,2.29V21l3.5,0 c0.55,0,1-0.45,1-1l0-0.57C24,18.62,23.52,17.9,22.78,17.58z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.24,16.65c-1.17-0.52-2.61-0.9-4.24-0.9c-1.63,0-3.07,0.39-4.24,0.9C6.68,17.13,6,18.21,6,19.39L6,20 c0,0.55,0.45,1,1,1h10c0.55,0,1-0.45,1-1l0-0.61C18,18.21,17.32,17.13,16.24,16.65z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M9,12c0,1.66,1.34,3,3,3s3-1.34,3-3c0-1.66-1.34-3-3-3S9,10.34,9,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M2.48,10.86C2.17,10.1,2,9.36,2,8.6C2,6.02,4.02,4,6.6,4c2.68,0,3.82,1.74,5.4,3.59C13.57,5.76,14.7,4,17.4,4 C19.98,4,22,6.02,22,8.6c0,0.76-0.17,1.5-0.48,2.26c0.65,0.31,1.18,0.82,1.53,1.44C23.65,11.1,24,9.88,24,8.6 C24,4.9,21.1,2,17.4,2c-2.09,0-4.09,0.97-5.4,2.51C10.69,2.97,8.69,2,6.6,2C2.9,2,0,4.9,0,8.6c0,1.28,0.35,2.5,0.96,3.7 C1.31,11.68,1.84,11.17,2.48,10.86z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 _6-ft-apart
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:x "0", :width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6,6c1.1,0,2-0.9,2-2S7.1,2,6,2S4,2.9,4,4S4.9,6,6,6z M10,9.43c0-0.81-0.48-1.53-1.22-1.85C7.93,7.21,6.99,7,6,7 C5.01,7,4.07,7.21,3.22,7.58C2.48,7.9,2,8.62,2,9.43V10h8V9.43z M18,6c1.1,0,2-0.9,2-2s-0.9-2-2-2s-2,0.9-2,2S16.9,6,18,6z M22,9.43 c0-0.81-0.48-1.53-1.22-1.85C19.93,7.21,18.99,7,18,7c-0.99,0-1.93,0.21-2.78,0.58C14.48,7.9,14,8.62,14,9.43V10h8V9.43z M21.65,14.35l-1.79,1.79C19.54,16.46,19,16.24,19,15.79v-0.8L5,15v0.79c0,0.45-0.54,0.67-0.85,0.35l-1.79-1.79 c-0.2-0.2-0.2-0.51,0-0.71l1.79-1.79C4.46,11.54,5,11.76,5,12.21v0.8L19,13v-0.79c0-0.45,0.54-0.67,0.85-0.35l1.79,1.79 C21.84,13.84,21.84,14.16,21.65,14.35z M10,18.5L10,18.5c0-0.28-0.22-0.5-0.5-0.5h-2C7.22,18,7,18.22,7,18.5v3 C7,21.78,7.22,22,7.5,22h2c0.28,0,0.5-0.22,0.5-0.5V20c0-0.28-0.22-0.5-0.5-0.5H8V19h1.5C9.78,19,10,18.78,10,18.5z M9,20.5V21H8 v-0.5H9z M17,19h-0.5v2.5c0,0.28-0.22,0.5-0.5,0.5h0c-0.28,0-0.5-0.22-0.5-0.5V19H15c-0.28,0-0.5-0.22-0.5-0.5v0 c0-0.28,0.22-0.5,0.5-0.5h2c0.28,0,0.5,0.22,0.5,0.5v0C17.5,18.78,17.28,19,17,19z M14,18.5c0,0.28-0.22,0.5-0.5,0.5h-1v0.5H13 c0.28,0,0.5,0.22,0.5,0.5c0,0.28-0.22,0.5-0.5,0.5h-0.5v1c0,0.28-0.22,0.5-0.5,0.5c-0.28,0-0.5-0.22-0.5-0.5v-3 c0-0.28,0.22-0.5,0.5-0.5h1.5C13.78,18,14,18.22,14,18.5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 man-4
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M13.75,7h-3.5C9.04,7,8.11,8.07,8.27,9.26L9.82,20.7c0.1,0.74,0.74,1.3,1.49,1.3h1.38c0.75,0,1.39-0.55,1.49-1.3 l1.56-11.44C15.89,8.07,14.96,7,13.75,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/circle
     {:r "2", :cy "4", :cx "12", :stroke nil, :fill nil})))))


(helix.core/defnc
 group-add
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/path
    {:d
     "M22,9V8c0-0.55-0.45-1-1-1h0c-0.55,0-1,0.45-1,1v1h-1c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h1v1c0,0.55,0.45,1,1,1h0 c0.55,0,1-0.45,1-1v-1h1c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1H22z",
     :stroke nil,
     :fill nil})
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M8,12c2.21,0,4-1.79,4-4s-1.79-4-4-4S4,5.79,4,8S5.79,12,8,12z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d "M8,13c-2.67,0-8,1.34-8,4v3h16v-3C16,14.34,10.67,13,8,13z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M12.51,4.05C13.43,5.11,14,6.49,14,8s-0.57,2.89-1.49,3.95C14.47,11.7,16,10.04,16,8S14.47,4.3,12.51,4.05z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M16.53,13.83C17.42,14.66,18,15.7,18,17v3h2v-3C20,15.55,18.41,14.49,16.53,13.83z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 man-3
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil})
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M14,7h-4C8.9,7,8,7.9,8,9v5c0,0.55,0.45,1,1,1h1v6c0,0.55,0.45,1,1,1h2c0.55,0,1-0.45,1-1v-6h1c0.55,0,1-0.45,1-1V9 C16,7.9,15.1,7,14,7z",
      :stroke nil,
      :fill nil})
    (helix.dom/path
     {:d
      "M11.65,5.9L10.1,4.35c-0.2-0.2-0.2-0.51,0-0.71l1.54-1.54c0.2-0.2,0.51-0.2,0.71,0l1.54,1.54c0.2,0.2,0.2,0.51,0,0.71 L12.35,5.9C12.16,6.09,11.84,6.09,11.65,5.9z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 party-mode
 [props]
 (helix.dom/svg
  {:width "1em",
   :viewBox "0 0 24 24",
   :height "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :stroke "currentColor",
   :fill "currentColor",
   :& props}
  (helix.dom/path {:fill "none", :d "M0 0h24v24H0V0z", :stroke nil})
  (helix.dom/path
   {:d
    "M20 4h-3.17l-1.24-1.35c-.37-.41-.91-.65-1.47-.65H9.88c-.56 0-1.1.24-1.48.65L7.17 4H4c-1.1 0-2 .9-2 2v12c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm-8 3c1.63 0 3.06.79 3.98 2H12c-1.66 0-3 1.34-3 3 0 .35.07.69.18 1H7.1c-.06-.32-.1-.66-.1-1 0-2.76 2.24-5 5-5zm0 10c-1.63 0-3.06-.79-3.98-2H12c1.66 0 3-1.34 3-3 0-.35-.07-.69-.18-1h2.08c.07.32.1.66.1 1 0 2.76-2.24 5-5 5z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 boy
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/g
   nil
   (helix.dom/rect
    {:width "24", :height "24", :fill "none", :stroke nil}))
  (helix.dom/g
   nil
   (helix.dom/g
    nil
    (helix.dom/path
     {:d
      "M12,7.5c0.97,0,1.75-0.78,1.75-1.75S12.97,4,12,4s-1.75,0.78-1.75,1.75S11.03,7.5,12,7.5z M14,19c0,0.55-0.45,1-1,1h-2 c-0.55,0-1-0.45-1-1v-4c-0.55,0-1-0.45-1-1v-3.5c0-1.1,0.9-2,2-2h2c1.1,0,2,0.9,2,2V14c0,0.55-0.45,1-1,1V19z",
      :stroke nil,
      :fill nil})))))


(helix.core/defnc
 catching-pokemon
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M14.5,12c0,1.38-1.12,2.5-2.5,2.5c-1.38,0-2.5-1.12-2.5-2.5s1.12-2.5,2.5-2.5C13.38,9.5,14.5,10.62,14.5,12z M22,12 c0,5.52-4.48,10-10,10C6.48,22,2,17.52,2,12S6.48,2,12,2C17.52,2,22,6.48,22,12z M20,12h-4c0-2.21-1.79-4-4-4c-2.21,0-4,1.79-4,4H4 c0,4.41,3.59,8,8,8C16.41,20,20,16.41,20,12z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 emoji-events
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M19,5h-2V4c0-0.55-0.45-1-1-1H8C7.45,3,7,3.45,7,4v1H5C3.9,5,3,5.9,3,7v1c0,2.55,1.92,4.63,4.39,4.94 c0.63,1.5,1.98,2.63,3.61,2.96V19H8c-0.55,0-1,0.45-1,1v0c0,0.55,0.45,1,1,1h8c0.55,0,1-0.45,1-1v0c0-0.55-0.45-1-1-1h-3v-3.1 c1.63-0.33,2.98-1.46,3.61-2.96C19.08,12.63,21,10.55,21,8V7C21,5.9,20.1,5,19,5z M5,8V7h2v3.82C5.84,10.4,5,9.3,5,8z M19,8 c0,1.3-0.84,2.4-2,2.82V7h2V8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 real-estate-agent
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M3,22c1.1,0,2-0.9,2-2v-7c0-1.1-0.9-2-2-2s-2,0.9-2,2v7C1,21.1,1.9,22,3,22z M11.37,16.43l1.47,0.51 c0.11,0.04,0.22,0.06,0.33,0.06h6.83c1.11,0,2,0.89,2.01,2l0,0l-7.39,2.77c-0.4,0.15-0.84,0.17-1.25,0.05L7,20.02V11H8.6 c0.24,0,0.48,0.04,0.7,0.13l6.93,2.59c0.46,0.17,0.77,0.61,0.77,1.11v0c0,0.65-0.53,1.18-1.18,1.18h-2.63 c-0.12,0-0.24-0.02-0.36-0.07l-1.12-0.43c-0.26-0.1-0.55,0.04-0.64,0.3C10.98,16.06,11.11,16.34,11.37,16.43z M20.16,5.9l-5-3.57 c-0.7-0.5-1.63-0.5-2.32,0l-5,3.57C7.31,6.28,7,6.88,7,7.53V9h1.61c0.25,0,0.51,0.05,0.74,0.14l7.79,3.11 C18.26,12.71,19,13.79,19,15h2V7.53C21,6.88,20.69,6.28,20.16,5.9z M13,10c-0.28,0-0.5-0.22-0.5-0.5C12.5,9.22,12.72,9,13,9 s0.5,0.22,0.5,0.5C13.5,9.78,13.28,10,13,10z M13,8c-0.28,0-0.5-0.22-0.5-0.5C12.5,7.22,12.72,7,13,7s0.5,0.22,0.5,0.5 C13.5,7.78,13.28,8,13,8z M15,10c-0.28,0-0.5-0.22-0.5-0.5C14.5,9.22,14.72,9,15,9s0.5,0.22,0.5,0.5C15.5,9.78,15.28,10,15,10z M15,8c-0.28,0-0.5-0.22-0.5-0.5C14.5,7.22,14.72,7,15,7s0.5,0.22,0.5,0.5C15.5,7.78,15.28,8,15,8z",
    :stroke nil,
    :fill nil})))


(helix.core/defnc
 waving-hand
 [props]
 (helix.dom/svg
  {:stroke "currentColor",
   :fill "currentColor",
   :width "1em",
   :xmlns "http://www.w3.org/2000/svg",
   :stroke-width "0",
   :& props,
   :viewBox "0 0 24 24",
   :enable-background "new 0 0 24 24",
   :height "1em"}
  (helix.dom/rect
   {:width "24", :height "24", :fill "none", :stroke nil})
  (helix.dom/path
   {:d
    "M6.07,9.8c-0.2,0.2-0.2,0.51,0,0.71l0,0c1.07,1.07,1.16,2.75,0.28,3.92c-0.15,0.2-0.12,0.47,0.05,0.65 c0.22,0.22,0.57,0.19,0.76-0.05c1.07-1.43,1.06-3.43-0.04-4.85l7.62-7.62c0.49-0.49,1.28-0.49,1.77,0s0.49,1.28,0,1.77l-5.13,5.13 c-0.2,0.2-0.2,0.51,0,0.71s0.51,0.2,0.71,0l6.54-6.54c0.49-0.49,1.28-0.49,1.77,0s0.49,1.28,0,1.77l-6.54,6.54 c-0.2,0.2-0.2,0.51,0,0.71s0.51,0.2,0.71,0l5.48-5.48c0.49-0.49,1.28-0.49,1.77,0s0.49,1.28,0,1.77l-6.19,6.19 c-0.2,0.2-0.2,0.51,0,0.71c0.2,0.2,0.51,0.2,0.71,0l4.07-4.07c0.49-0.49,1.28-0.49,1.77,0c0.49,0.49,0.49,1.28,0,1.77l-7.07,7.07 c-3.22,3.22-8.45,3.22-11.67,0s-3.22-8.45,0-11.67l4.6-4.6c0.49-0.49,1.28-0.49,1.77,0c0.49,0.49,0.49,1.28,0,1.77L6.07,9.8z M7,1.8 c0-0.41-0.34-0.75-0