(ns glossa.metazoa.query
  (:require
   [glossa.metazoa.api :as api]
   [glossa.metazoa.optional-deps :as deps]))

(def ^:private ds 'glossa.metazoa.query.datascript)

(when deps/datascript-enabled?
  (require ds))

(defn- throw-datascript-required
  []
  (throw (ex-info "You must add Datascript to your classpath to use `meta/query`."
                  {:problem :unsatisfied-dependencies
                   :dependencies deps/recommended-datascript-artifacts})))

;; NOTE: Named `index` for consistency with glossa.metazoa.search
(defn index
  ([] (index (api/find-imetas)))
  ([imetas]
   (if deps/datascript-enabled?
     ((requiring-resolve 'glossa.metazoa.query.datascript/populate-database) imetas)
     (throw-datascript-required))))

(defn reset
  ([] (reset (api/find-imetas)))
  ([imetas]
   (if deps/datascript-enabled?
     ((requiring-resolve 'glossa.metazoa.query.datascript/reset) imetas)
     (throw-datascript-required))))

(defn db
  []
  (if deps/datascript-enabled?
    ((requiring-resolve 'glossa.metazoa.query.datascript/db))
    (throw-datascript-required)))

(defn q
  [datalog-query & args]
  (if deps/datascript-enabled?
    (let [q-fn (requiring-resolve 'glossa.metazoa.query.datascript/q)
          db (db)]
      (apply q-fn datalog-query db args))
    (throw-datascript-required)))
