package dev.goodpay.ir.interfaces.common;

import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

@Getter
public enum Currency {
    GBP("British pound", "£", "826", 2);

    private final String name;
    private final String symbol;
    private final String numericCode;
    private final int minorUnit;

    Currency(final String name, final String symbol, final String numericCode, final int minorUnit) {
        this.name = name;
        this.symbol = symbol;
        this.numericCode = numericCode;
        this.minorUnit = minorUnit;
    }

    private static final List<Currency> CACHED_VALUES = Arrays.stream(values())
            .collect(Collectors.toList());

    public static final Map<String, Currency> BY_ALPHA3_CODE = CACHED_VALUES.stream()
            .collect(Collectors.toMap(Currency::name, Function.identity()));

    public static final Map<String, Currency> BY_NUMERIC_CODE = CACHED_VALUES.stream()
            .filter(currency -> currency.getNumericCode() != null)
            .collect(Collectors.toMap(Currency::getNumericCode, Function.identity()));

}
