package dev.goodpay.ir.interfaces.identifier.v1;

import dev.goodpay.ir.interfaces.identifier.v1.alias.AliasV1;
import dev.goodpay.ir.interfaces.identifier.v1.methods.fps.FPSDetailsV1;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.UUID;

@Data
@Accessors(chain = true)
public class IdentifierV1 {
    private UUID uuid;
    private String currency;
    private String country;
    private String name;
    private String issuerId;
    private FPSDetailsV1 fpsDetails;
    private List<AliasV1> aliases;

    public List<AliasV1> getAliases() {
        return aliases == null ? List.of() : aliases;
    }
}
