/*
 * Decompiled with CFR 0.152.
 */
package dev.goodpay.ir.interfaces.common;

import dev.goodpay.ir.interfaces.common.ErrorType;

public class ValidationError {
    private ErrorType errorType;
    private String details;
    private String field;

    public static ValidationError missing(String field) {
        return new ValidationError().setErrorType(ErrorType.MISSING).setField(field);
    }

    public static ValidationError invalid(String field, String details) {
        return new ValidationError().setErrorType(ErrorType.INVALID).setField(field).setDetails(details);
    }

    public static ValidationError conflict(String field) {
        return new ValidationError().setErrorType(ErrorType.CONFLICT).setField(field);
    }

    public static ValidationError invalid(String field) {
        return ValidationError.invalid(field, null);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public String getDetails() {
        return this.details;
    }

    public String getField() {
        return this.field;
    }

    public ValidationError setErrorType(ErrorType errorType) {
        this.errorType = errorType;
        return this;
    }

    public ValidationError setDetails(String details) {
        this.details = details;
        return this;
    }

    public ValidationError setField(String field) {
        this.field = field;
        return this;
    }

    public String toString() {
        return "ValidationError(errorType=" + this.getErrorType() + ", details=" + this.getDetails() + ", field=" + this.getField() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidationError)) {
            return false;
        }
        ValidationError other = (ValidationError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ErrorType this$errorType = this.getErrorType();
        ErrorType other$errorType = other.getErrorType();
        if (this$errorType == null ? other$errorType != null : !((Object)((Object)this$errorType)).equals((Object)other$errorType)) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidationError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ErrorType $errorType = this.getErrorType();
        result = result * 59 + ($errorType == null ? 43 : ((Object)((Object)$errorType)).hashCode());
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }
}

