/*
 * Decompiled with CFR 0.152.
 */
package dev.goodpay.ir.interfaces.issuer.v1.validator;

import dev.goodpay.ir.interfaces.common.ContractValidationResult;
import dev.goodpay.ir.interfaces.common.Country;
import dev.goodpay.ir.interfaces.common.ValidationError;
import dev.goodpay.ir.interfaces.common.validator.Validator;
import dev.goodpay.ir.interfaces.issuer.v1.IssuerV1;
import java.net.MalformedURLException;
import java.net.URL;

public class IssuerV1Validator
implements Validator<IssuerV1> {
    @Override
    public ContractValidationResult validateCreate(IssuerV1 issuer) {
        ContractValidationResult validationResult = new ContractValidationResult();
        this.identifierCheck(issuer, validationResult);
        this.countryCheck(issuer, validationResult);
        this.nameCheck(issuer, validationResult);
        this.urlCheck(issuer, validationResult);
        return validationResult;
    }

    @Override
    public ContractValidationResult validateUpdate(IssuerV1 updateObject) {
        ContractValidationResult result = new ContractValidationResult();
        if (updateObject.getUuid() == null) {
            result.registerError(ValidationError.missing("uuid"));
        }
        this.urlCheck(updateObject, result);
        return result;
    }

    private void urlCheck(IssuerV1 issuer, ContractValidationResult validationResult) {
        if (issuer.getUrl() != null) {
            try {
                URL uRL = new URL(issuer.getUrl());
            }
            catch (MalformedURLException e) {
                validationResult.registerError(ValidationError.invalid("url", "malformed URL"));
            }
        }
    }

    private void nameCheck(IssuerV1 issuer, ContractValidationResult validationResult) {
        if (issuer.getName() == null) {
            validationResult.registerError(ValidationError.missing("name"));
        }
    }

    private void countryCheck(IssuerV1 issuer, ContractValidationResult validationResult) {
        if (issuer.getCountry() == null) {
            validationResult.registerError(ValidationError.missing("country"));
        } else if (!Country.BY_ISO3_CODE.containsKey(issuer.getCountry().toLowerCase())) {
            validationResult.registerError(ValidationError.invalid("country", "Invalid iso3Code for country"));
        }
    }

    private void identifierCheck(IssuerV1 issuer, ContractValidationResult validationResult) {
        if (issuer.getIssuerIdentifier() == null) {
            validationResult.registerError(ValidationError.missing("identifier"));
        }
    }
}

