/*
 * Decompiled with CFR 0.152.
 */
package dev.goodpay.ir.interfaces.common;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Currency {
    GBP("British pound", "\u00a3", "826", 2);

    private final String name;
    private final String symbol;
    private final String numericCode;
    private final int minorUnit;
    private static final List<Currency> CACHED_VALUES;
    public static final Map<String, Currency> BY_ALPHA3_CODE;
    public static final Map<String, Currency> BY_NUMERIC_CODE;

    private Currency(String name, String symbol, String numericCode, int minorUnit) {
        this.name = name;
        this.symbol = symbol;
        this.numericCode = numericCode;
        this.minorUnit = minorUnit;
    }

    public String getName() {
        return this.name;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getNumericCode() {
        return this.numericCode;
    }

    public int getMinorUnit() {
        return this.minorUnit;
    }

    static {
        CACHED_VALUES = Arrays.stream(Currency.values()).collect(Collectors.toList());
        BY_ALPHA3_CODE = CACHED_VALUES.stream().collect(Collectors.toMap(Enum::name, Function.identity()));
        BY_NUMERIC_CODE = CACHED_VALUES.stream().filter(currency -> currency.getNumericCode() != null).collect(Collectors.toMap(Currency::getNumericCode, Function.identity()));
    }
}

