(ns dev.polymeris.sys.nrepl
  (:require
    [clojure.tools.logging :as log]
    [integrant.core :as ig]
    [nrepl.server :as nrepl]))

(defmethod ig/init-key ::server
  [_ {:keys [port bind]}]
  (let [server (nrepl/start-server :port port
                                   :bind bind)]
    (log/info "nREPL server started on port" port)
    server))

(defmethod ig/halt-key! ::server
  [_ server]
  (nrepl/stop-server server)
  (log/info "nREPL server stopped"))
