(ns dev.polymeris.sys.mq
  (:require
    [clojure.tools.logging :as log]
    [integrant.core :as ig]
    [langohr.core :as langohr]
    [langohr.basic :as basic]
    [langohr.channel :as channel]
    [langohr.exchange :as exchange]
    [jsonista.core :as json]))

(defn publish-message!
  "Publishes a message to the global messages exchange"
  [channel routing-key message]
  (log/info "Publishing" routing-key "event")
  (basic/publish
    (:channel channel)
    (:exchange channel)
    routing-key
    (json/write-value-as-string message)
    {:content-type "application/json"}))

(defmethod ig/init-key ::connection
  [_ settings]
  (let [connection (langohr/connect settings)]
    (log/info "RabbitMQ connection established")
    connection))

(defmethod ig/halt-key! ::connection
  [_ connection]
  (when-not (langohr/closed? connection)
    (langohr/close connection)
    (log/info "RabbitMQ connection destroyed")))

(defmethod ig/init-key ::channel
  [_ {:keys [connection exchange] :or {connection ::connection}}]
  (let [channel (channel/open connection)]
    (log/info "RabbitMQ channel opened")
    (exchange/topic channel exchange {:durable true})
    (log/info "Exchange declared" exchange)
    {:exchange exchange
     :channel channel}))

(defmethod ig/halt-key! ::channel
  [_ {:keys [channel]}]
  (when-not (langohr/closed? channel)
    (langohr/close channel)
    (log/info "RabbitMQ channel closed")))