(ns dev.polymeris.sys
  (:require [integrant.core :as ig]
            [clojure.java.io :as io]
            [aero.core :as aero]))

(defmethod aero/reader 'ig/ref
  [_ _tag value]
  (ig/ref value))

(defn load-config
  "Load integrant config from file, parsing it with areo"
  [filename]
  (let [config (-> (io/resource filename)
                   (aero/read-config {}))]
    (when-not config
      (throw (ex-info "Could not load config" {:filename filename})))
    (ig/load-namespaces config)
    config))

(defn init [config-file]
  (-> (load-config config-file)
      (ig/prep)
      (ig/init)))