(ns vlaaad.reveal.pro.form.tuple
  "© 2021 Vladislav Protsenko. All rights reserved."
  (:require [vlaaad.reveal.event :as event]
            [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.pro.form.copy-paste :as copy-paste]
            [vlaaad.reveal.pro.form.compatible :as compatible]
            [vlaaad.reveal.pro.form.vignette :as vignette]))

(defmethod event/handle ::edit-tuple [{:keys [index on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update % index fn))))

(defn- edit-content [forms x]
  (mapv
    (fn [form item]
      (impl/edit (:editor form) item))
    forms
    (if (impl/completely-undefined? x)
      (repeat impl/undefined)
      x)))

(defn- content-view [forms {:keys [edit on-edit]}]
  {:fx/type impl/multi-line-view
   :children (mapv
               (fn [i item-form item-edit]
                 {:fx/type impl/form-view
                  :form item-form
                  :edit item-edit
                  :on-edit {::event/type ::edit-tuple
                            :index i
                            :on-edit on-edit}})
               (range)
               forms
               edit)})

(defn content-editor
  "Can only edit tuples of valid length"
  [{:keys [forms]}]
  (impl/make-editor
    :edit #(edit-content forms %)
    :assemble impl/assemble-all
    :view #(content-view forms %)))

(defmethod event/handle ::edit-content [{:keys [on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update % :content fn))))

(defn- view [{:keys [edit on-edit form]}]
  {:fx/type impl/multi-line-view
   :children [{:fx/type vignette/view
               :edit edit
               :on-edit on-edit
               :form form
               :main true
               :desc {:fx/type :button
                      :style-class "reveal-form-input"
                      :pseudo-classes #{:object}
                      :text "["}}
              {:fx/type impl/indent-view
               :desc {:fx/type impl/content-view
                      :edit (:content edit)
                      :on-edit {::event/type ::edit-content
                                :on-edit on-edit}}}
              {:fx/type :label
               :style-class "reveal-form-object"
               :text "]"}]})

(defn- edit [content-editor x]
  {:content (impl/edit content-editor x)})

(defn- assemble [{:keys [content]}]
  (impl/assemble content))

(defn value-editor [{:keys [forms] :as opts}]
  (let [content-editor (content-editor opts)]
    (-> (impl/make-editor
          :edit #(edit content-editor %)
          :assemble assemble
          :view view)
        (compatible/wrap #(and (vector? %)
                               (= (count forms) (count %))))
        (copy-paste/wrap))))

