(ns vlaaad.reveal.pro.form.copy-paste
  "© 2021 Vladislav Protsenko. All rights reserved."
  (:require [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.pro.form.text :as text]
            [vlaaad.reveal.event :as event]
            [cljfx.api :as fx])
  (:import [javafx.scene.input Clipboard ClipboardContent DataFormat]))


(defmethod event/handle ::copy [{:keys [edit]}]
  (let [v (impl/value (impl/assemble edit))]
    (fx/on-fx-thread
      (.setContent
        (Clipboard/getSystemClipboard)
        (doto (ClipboardContent.)
          (.putString (impl/pprint-str v))))))
  identity)

(defmethod event/handle ::edit-pref-edit [{:keys [on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update % :pref fn))))

(defmethod event/handle ::paste [{:keys [on-edit pref-editor]}]
  (let [text @(fx/on-fx-thread
                (.getContent (Clipboard/getSystemClipboard) DataFormat/PLAIN_TEXT))
        text-edit (text/make-edit-with-text text)
        result (impl/assemble text-edit)]
    (event/handle (assoc on-edit :fn (fn [e]
                                       (if (impl/error result)
                                         (-> e
                                             (dissoc :pref)
                                             (assoc :text text-edit :focused :text))
                                         (assoc e :pref (impl/edit pref-editor (impl/value result))
                                                  :focused :pref)))))))

(defmethod event/handle ::edit-text-edit [{:keys [on-edit pref-editor fn]}]
  (event/handle
    (assoc on-edit :fn #(let [text-edit (fn (:text %))
                              result (impl/assemble text-edit)]
                          (if (impl/error result)
                            (assoc % :text text-edit :focused :text)
                            (-> %
                                (dissoc :text)
                                (assoc :pref (impl/edit pref-editor (impl/value result))
                                       :focused :pref)))))))

(defn- view [pref-editor {:keys [edit on-edit form]}]
  (let [{:keys [pref text focused]} edit]
    {:fx/type impl/ext-with-focus-on-request
     :focused focused
     :desc (if pref
             {:fx/type impl/form-view
              :form (-> form
                        (assoc :editor pref-editor)
                        (update :options (fnil conj [])
                                {:invoke {::event/type ::copy
                                          :edit pref}
                                 :label "Copy"
                                 :shortcut [:shortcut :c]}
                                {:invoke {::event/type ::paste
                                          :on-edit on-edit
                                          :pref-editor pref-editor}
                                 :label "Paste"
                                 :shortcut [:shortcut :v]}))
              :edit pref
              :on-edit {::event/type ::edit-pref-edit
                        :on-edit on-edit}}
             {:fx/type impl/form-view
              :form (assoc form :editor text/value-editor)
              :edit text
              :on-edit {::event/type ::edit-text-edit
                        :on-edit on-edit
                        :pref-editor pref-editor}})}))

(defn- edit [pref-editor x]
  {:pref (impl/edit pref-editor x)})

(defn- assemble [{:keys [pref text]}]
  (impl/assemble (or pref text)))

(defn wrap [pref-value-editor]
  (impl/make-editor
    :edit #(edit pref-value-editor %)
    :assemble assemble
    :view #(view pref-value-editor %)))
