(ns vlaaad.reveal.pro.form.compatible
  "© 2021 Vladislav Protsenko. All rights reserved."
  (:require [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.pro.form.text :as text]
            [vlaaad.reveal.event :as event]))

(defmethod event/handle ::edit-pref-edit [{:keys [on-edit compatible? fn]}]
  (event/handle (assoc on-edit :fn #(let [pref-edit (fn (:pref %))
                                          result (impl/assemble pref-edit)]
                                      (if (and (not (impl/error result))
                                               (not (or (impl/completely-undefined? (impl/value result))
                                                        (compatible? (impl/value result)))))
                                        (-> %
                                            (dissoc :pref)
                                            (assoc :text (impl/edit text/value-editor (impl/value result))))
                                        (assoc % :pref pref-edit))))))

(defmethod event/handle ::edit-text-edit [{:keys [on-edit pref-editor compatible? fn]}]
  (event/handle (assoc on-edit :fn #(let [text-edit (fn (:text %))
                                          result (impl/assemble text-edit)]
                                      (if (and (not (impl/error result))
                                               (not (impl/completely-undefined? (impl/value result)))
                                               (compatible? (impl/value result)))
                                        (-> %
                                            (dissoc :text)
                                            (assoc :pref (impl/edit pref-editor (impl/value result))))
                                        (assoc % :text text-edit))))))

(defn- view [pref-editor compatible? {:keys [edit on-edit form]}]
  (let [{:keys [pref text]} edit]
    (if pref
      {:fx/type impl/form-view
       :form (assoc form :editor pref-editor)
       :edit pref
       :on-edit {::event/type ::edit-pref-edit
                 :on-edit on-edit
                 :compatible? compatible?}}
      {:fx/type impl/form-view
       :form (assoc form :editor text/value-editor)
       :edit text
       :on-edit {::event/type ::edit-text-edit
                 :on-edit on-edit
                 :pref-editor pref-editor
                 :compatible? compatible?}})))

(defn- edit [pref-editor compatible? v]
  (if (or (impl/completely-undefined? v)
          (compatible? v))
    {:pref (impl/edit pref-editor v)}
    {:text (impl/edit text/value-editor v)}))

(defn- assemble [{:keys [pref text]}]
  (impl/assemble (or pref text)))

(defn wrap [pref-value-editor compatible?]
  (impl/make-editor
    :edit #(edit pref-value-editor compatible? %)
    :assemble assemble
    :view #(view pref-value-editor compatible? %)))