(ns vlaaad.reveal.pro.form.specs
  (:require [clojure.spec.alpha :as s]
            [vlaaad.reveal.pro.form.impl :as impl])
  (:import [javafx.scene.input KeyCombination KeyCode]))

(defmacro validate! [spec x]
  `(let [x# ~x]
     (if-let [~'fail (s/explain-data ~spec x#)]
       (throw (ex-info "Invalid input" ~'fail))
       x#)))

;; form

(s/def ::explain ifn?)

(s/def ::label string?)

(defn editor? [x]
  (or (satisfies? impl/Editor x)
      (contains? (meta x) `impl/edit*)))

(s/def ::editor editor?)

(s/def ::description string?)

(s/def ::invoke
  (s/or :gen (s/and (complement map?) ifn?)
        :event (s/and map? #(contains? % :vlaaad.reveal.event/type))))

(s/def ::shortcut
  (s/or :vector (s/and vector?
                       (s/cat :modifiers (s/* keyword?)
                              :key (s/or :code keyword?
                                         :char string?
                                         :code-instance #(instance? KeyCode %))))
        :string string?
        :instance #(instance? KeyCombination %)))

(s/def ::option
  (s/keys :req-un [::label ::invoke]
          :opt-un [::shortcut]))

(s/def ::options
  (s/coll-of ::option :kind vector?))

(s/def ::form (s/keys :req-un [::explain ::editor ::label]
                      :opt-un [::description ::options]))

;; editors

(s/def ::alt (s/tuple any? ::form))
(defn unique-keys? [kvs]
  (apply distinct? (map first kvs)))
(s/def ::alts (s/and (s/coll-of ::alt :min-count 1) unique-keys?))
(s/def ::alt-editor-args
  (s/keys :req-un [::alts]))

(s/def ::forms (s/coll-of ::form))
(s/def ::tuple-editor-args
  (s/keys :req-un [::forms]))

(s/def ::values (s/coll-of any?))
(s/def ::enum-editor-args
  (s/keys :req-un [::values]))

(s/def :vlaaad.reveal.pro.form.specs.coll/kinds
  (s/coll-of #{:vector :set :map :list} :distinct true))
(s/def ::item-form ::form)
(s/def ::min-count (s/and int? (complement neg?)))
(s/def ::max-count (s/and int? (complement neg?)))
(defn min-count<=max-count? [{:keys [min-count max-count]
                              :or {min-count 0
                                   max-count Integer/MAX_VALUE}}]
  (<= min-count max-count))
(s/def ::coll-editor-args
  (s/and (s/keys :req-un [::item-form]
                 :opt-un [::min-count
                          ::max-count
                          :vlaaad.reveal.pro.form.specs.coll/kinds])
         min-count<=max-count?))

(s/def ::key-form ::form)
(s/def ::val-form ::form)
(s/def ::map-editor-args
  (s/and (s/keys :req-un [::key-form ::val-form]
                 :opt-un [::min-count ::max-count])
         min-count<=max-count?))

(s/def ::req (s/and (s/coll-of ::alt) unique-keys?))
(s/def ::opt (s/and (s/coll-of ::alt) unique-keys?))
(s/def ::any ifn?)
(s/def ::entity-editor-args
  (s/keys :opt-un [::req ::opt ::any]))

(s/def ::op
  (s/or :form ::form
        :labeled-editor (s/and editor? (s/keys :req-un [::label]))))
(s/def :vlaaad.reveal.pro.form.specs.regex/kinds
  (s/coll-of #{:vector :list} :distinct true))
(s/def ::regex-editor-args
  (s/keys :req-un [::op]
          :opt-un [:vlaaad.reveal.pro.form.specs.regex/kinds]))

(s/def ::parse ifn?)

(s/def ::*-args (s/keys :req-un [::op ::parse]))

(s/def ::?-args (s/keys :req-un [::op ::parse]))

(s/def ::+-args (s/keys :req-un [::op ::parse]))

(s/def ::repeat-args
  (s/and (s/keys :req-un [::op ::parse]
                 :opt-un [::min-count ::max-count])
         min-count<=max-count?))

(s/def ::entity-args
  (s/keys :opt-un [::req ::opt ::any]))

(s/def ::alt-ops
  (s/and (s/coll-of (s/tuple any? ::op) :min-count 1)
         unique-keys?))
(s/def ::alt-args
  (s/keys :req-un [::alt-ops ::parse]))

(s/def ::cat-ops ::alt-ops)
(s/def ::cat-args (s/keys :req-un [::cat-ops ::parse]))