(ns vlaaad.reveal.pro.form.delay
  (:require [vlaaad.reveal.pro.form.impl :as impl]
            [vlaaad.reveal.event :as event]))

(defn- edit [editor-fn x]
  (let [editor (editor-fn)]
    {:editor editor
     :value (impl/edit editor x)}))

(defn- assemble [{:keys [value]}]
  (impl/assemble value))

(defmethod event/handle ::edit [{:keys [on-edit fn]}]
  (event/handle (assoc on-edit :fn #(update % :value fn))))

(defn- view [{:keys [edit on-edit form]}]
  (let [{:keys [editor value]} edit]
    {:fx/type impl/form-view
     :form (assoc form :editor editor)
     :edit value
     :on-edit {::event/type ::edit
               :on-edit on-edit}}))

(defn value-editor [editor-fn]
  (impl/make-editor
    :edit #(edit editor-fn %)
    :assemble assemble
    :view view))