(ns ragtime.protocols
  "Protocols for defining a migration and data store.")

(defprotocol Migration
  "Protocol for a migration that can be applied to a DataStore."
  (id [_]
    "Return the string identifier of the migration.")
  (run-up! [_ store]
    "Run the 'up' part of the migration.")
  (run-down! [_ store]
    "Run the 'down' part of the migration."))

(defprotocol DataStore
  "Protocol for a data store that can be migrated."
  (add-migration-id [store migration-id]
    "Add an applied migration ID to the data store.")
  (remove-migration-id [store migration-id]
    "Remove a rolled-back migration ID from the data store.")
  (applied-migration-ids [store]
    "Return an ordered list of ids of all migrations applied to the data
    store."))

(defprotocol MigrationIndex
  "Protocol for keeping an index of migrations."
  (index-migration [index key migration]
    "Add a migration to the index with the supplied key.")
  (deindex-migration [index key]
    "Remove a migration from the index.")
  (get-indexed-migration [index key not-found]
    "Get a migration from the index."))
