(ns pagerduty.config
  (:require [clojure.java.io :as io]))

(defn file-exists? [path]
  (-> path io/file .isFile))

(def config
  (if (file-exists? "pagerduty.clj")
    (read-string (slurp "pagerduty.clj"))
    (let [system-properties (System/getProperties)
          subdomain-env-var (get system-properties "PAGERDUTY_SUBDOMAIN")
          token-env-var (get system-properties "PAGERDUTY_TOKEN")]
      (when (and subdomain-env-var token-env-var)
        {:subdomain subdomain-env-var
         :token token-env-var}))))
